/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import com.stevesoft.pat.Regex;
import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.util.Enumeration;
import java.util.Vector;

public class Sequence
implements SequenceI {
    SequenceI datasetSequence;
    String name;
    private char[] sequence;
    String description;
    int start;
    int end;
    Vector pdbIds;
    String vamsasId;
    DBRefEntry[] dbrefs;
    Vector annotation;
    public SequenceFeature[] sequenceFeatures;
    Regex limitrx = new Regex("[/][0-9]{1,}[-][0-9]{1,}$");
    Regex endrx = new Regex("[0-9]{1,}$");

    public Sequence(String name, String sequence, int start, int end) {
        this.name = name;
        this.sequence = sequence.toCharArray();
        this.start = start;
        this.end = end;
        this.parseId();
        this.checkValidRange();
    }

    public Sequence(String name, char[] sequence, int start, int end) {
        this.name = name;
        this.sequence = sequence;
        this.start = start;
        this.end = end;
        this.parseId();
        this.checkValidRange();
    }

    void parseId() {
        if (this.name == null) {
            System.err.println("POSSIBLE IMPLEMENTATION ERROR: null sequence name passed to constructor.");
            this.name = "";
        }
        if (this.limitrx.search(this.name)) {
            this.name = this.limitrx.left();
            this.endrx.search(this.limitrx.stringMatched());
            this.setStart(Integer.parseInt(this.limitrx.stringMatched().substring(1, this.endrx.matchedFrom() - 1)));
            this.setEnd(Integer.parseInt(this.endrx.stringMatched()));
        }
    }

    void checkValidRange() {
        if (this.end < 1) {
            int endRes = 0;
            for (int j = 0; j < this.sequence.length; ++j) {
                if (Comparison.isGap(this.sequence[j])) continue;
                ++endRes;
            }
            if (endRes > 0) {
                endRes += this.start - 1;
            }
            this.end = endRes;
        }
    }

    public Sequence(String name, String sequence) {
        this(name, sequence, 1, -1);
    }

    public Sequence(SequenceI seq) {
        this(seq, seq.getAnnotation());
    }

    public Sequence(SequenceI seq, AlignmentAnnotation[] alAnnotation) {
        this(seq.getName(), seq.getSequence(), seq.getStart(), seq.getEnd());
        int i;
        this.description = seq.getDescription();
        if (seq.getSequenceFeatures() != null) {
            SequenceFeature[] sf = seq.getSequenceFeatures();
            for (i = 0; i < sf.length; ++i) {
                this.addSequenceFeature(new SequenceFeature(sf[i]));
            }
        }
        this.setDatasetSequence(seq.getDatasetSequence());
        if (this.datasetSequence == null && seq.getDBRef() != null) {
            DBRefEntry[] dbr = seq.getDBRef();
            for (i = 0; i < dbr.length; ++i) {
                this.addDBRef(new DBRefEntry(dbr[i]));
            }
        }
        if (seq.getAnnotation() != null) {
            AlignmentAnnotation[] sqann = seq.getAnnotation();
            for (i = 0; i < sqann.length; ++i) {
                boolean found;
                if (sqann[i] == null) continue;
                boolean bl = found = alAnnotation == null;
                if (!found) {
                    for (int apos = 0; !found && apos < alAnnotation.length; ++apos) {
                        found = alAnnotation[apos] == sqann[i];
                    }
                }
                if (!found) continue;
                AlignmentAnnotation newann = new AlignmentAnnotation(sqann[i]);
                this.addAlignmentAnnotation(newann);
            }
        }
        if (seq.getPDBId() != null) {
            Vector ids = seq.getPDBId();
            Enumeration e = ids.elements();
            while (e.hasMoreElements()) {
                this.addPDBId(new PDBEntry((PDBEntry)e.nextElement()));
            }
        }
    }

    public void setSequenceFeatures(SequenceFeature[] features) {
        this.sequenceFeatures = features;
    }

    public synchronized void addSequenceFeature(SequenceFeature sf) {
        if (this.sequenceFeatures == null) {
            this.sequenceFeatures = new SequenceFeature[0];
        }
        for (int i = 0; i < this.sequenceFeatures.length; ++i) {
            if (!this.sequenceFeatures[i].equals(sf)) continue;
            return;
        }
        SequenceFeature[] temp = new SequenceFeature[this.sequenceFeatures.length + 1];
        System.arraycopy(this.sequenceFeatures, 0, temp, 0, this.sequenceFeatures.length);
        temp[this.sequenceFeatures.length] = sf;
        this.sequenceFeatures = temp;
    }

    public void deleteFeature(SequenceFeature sf) {
        if (this.sequenceFeatures == null) {
            return;
        }
        int index = 0;
        for (index = 0; index < this.sequenceFeatures.length && !this.sequenceFeatures[index].equals(sf); ++index) {
        }
        if (index == this.sequenceFeatures.length) {
            return;
        }
        int sfLength = this.sequenceFeatures.length;
        if (sfLength < 2) {
            this.sequenceFeatures = null;
        } else {
            SequenceFeature[] temp = new SequenceFeature[sfLength - 1];
            System.arraycopy(this.sequenceFeatures, 0, temp, 0, index);
            if (index < sfLength) {
                System.arraycopy(this.sequenceFeatures, index + 1, temp, index, this.sequenceFeatures.length - index - 1);
            }
            this.sequenceFeatures = temp;
        }
    }

    public SequenceFeature[] getSequenceFeatures() {
        return this.sequenceFeatures;
    }

    public void addPDBId(PDBEntry entry) {
        if (this.pdbIds == null) {
            this.pdbIds = new Vector();
        }
        if (!this.pdbIds.contains(entry)) {
            this.pdbIds.addElement(entry);
        }
    }

    public void setPDBId(Vector id) {
        this.pdbIds = id;
    }

    public Vector getPDBId() {
        return this.pdbIds;
    }

    public String getDisplayId(boolean jvsuffix) {
        StringBuffer result = new StringBuffer(this.name);
        if (jvsuffix) {
            result.append("/" + this.start + "-" + this.end);
        }
        return result.toString();
    }

    public void setName(String name) {
        this.name = name;
        this.parseId();
    }

    public String getName() {
        return this.name;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.sequence.length;
    }

    public void setSequence(String seq) {
        this.sequence = seq.toCharArray();
        this.checkValidRange();
    }

    public String getSequenceAsString() {
        return new String(this.sequence);
    }

    public String getSequenceAsString(int start, int end) {
        return new String(this.getSequence(start, end));
    }

    public char[] getSequence() {
        return this.sequence;
    }

    public char[] getSequence(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start >= this.sequence.length) {
            return new char[0];
        }
        if (end >= this.sequence.length) {
            end = this.sequence.length;
        }
        char[] reply = new char[end - start];
        System.arraycopy(this.sequence, start, reply, 0, end - start);
        return reply;
    }

    public SequenceI getSubSequence(int start, int end) {
        char[] seq;
        if (start < 0) {
            start = 0;
        }
        if ((seq = this.getSequence(start, end)).length == 0) {
            return null;
        }
        int nstart = this.findPosition(start);
        int nend = this.findPosition(end) - 1;
        Sequence nseq = new Sequence(this.getName(), seq, nstart, nend);
        nseq.setDescription(this.description);
        if (this.datasetSequence != null) {
            nseq.setDatasetSequence(this.datasetSequence);
        } else {
            nseq.setDatasetSequence(this);
        }
        return nseq;
    }

    public char getCharAt(int i) {
        if (i < this.sequence.length) {
            return this.sequence[i];
        }
        return ' ';
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public int findIndex(int pos) {
        int i;
        int j = this.start;
        for (i = 0; i < this.sequence.length && j <= this.end && j <= pos; ++i) {
            if (Comparison.isGap(this.sequence[i])) continue;
            ++j;
        }
        if (j == this.end && j < pos) {
            return this.end + 1;
        }
        return i;
    }

    public int findPosition(int i) {
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (int j = 0; j < i && j < seqlen; ++j) {
            if (Comparison.isGap(this.sequence[j])) continue;
            ++pos;
        }
        return pos;
    }

    public int[] gapMap() {
        String seq = AlignSeq.extractGaps(" .-", new String(this.sequence));
        int[] map = new int[seq.length()];
        int p = 0;
        for (int j = 0; j < this.sequence.length; ++j) {
            if (Comparison.isGap(this.sequence[j])) continue;
            map[p++] = j;
        }
        return map;
    }

    public int[] findPositionMap() {
        int[] map = new int[this.sequence.length];
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (int j = 0; j < seqlen; ++j) {
            map[j] = pos++;
            if (Comparison.isGap(this.sequence[j])) continue;
        }
        return map;
    }

    public void deleteChars(int i, int j) {
        char[] tmp;
        int newstart = this.start;
        int newend = this.end;
        if (i >= this.sequence.length) {
            return;
        }
        if (j >= this.sequence.length) {
            tmp = new char[i];
            System.arraycopy(this.sequence, 0, tmp, 0, i);
        } else {
            tmp = new char[this.sequence.length - j + i];
            System.arraycopy(this.sequence, 0, tmp, 0, i);
            System.arraycopy(this.sequence, j, tmp, i, this.sequence.length - j);
        }
        boolean createNewDs = false;
        for (int s = i; s < j; ++s) {
            if (ResidueProperties.aaIndex[this.sequence[s]] == 23) continue;
            if (createNewDs) {
                --newend;
                continue;
            }
            int sindex = this.findIndex(this.start) - 1;
            if (sindex == s) {
                newstart = this.findPosition(j);
                break;
            }
            int eindex = this.findIndex(this.end) - 1;
            if (eindex < j) {
                newend = this.findPosition(i - 1);
                break;
            }
            createNewDs = true;
            --newend;
        }
        if (createNewDs && this.datasetSequence != null) {
            Sequence ds = new Sequence(this.datasetSequence);
            ds.deleteChars(i, j);
            this.datasetSequence = ds;
        }
        this.start = newstart;
        this.end = newend;
        this.sequence = tmp;
    }

    public void insertCharAt(int i, int length, char c) {
        char[] tmp = new char[this.sequence.length + length];
        if (i >= this.sequence.length) {
            System.arraycopy(this.sequence, 0, tmp, 0, this.sequence.length);
            i = this.sequence.length;
        } else {
            System.arraycopy(this.sequence, 0, tmp, 0, i);
        }
        int index = i;
        while (length > 0) {
            tmp[index++] = c;
            --length;
        }
        if (i < this.sequence.length) {
            System.arraycopy(this.sequence, i, tmp, index, this.sequence.length - i);
        }
        this.sequence = tmp;
    }

    public void insertCharAt(int i, char c) {
        this.insertCharAt(i, 1, c);
    }

    public String getVamsasId() {
        return this.vamsasId;
    }

    public void setVamsasId(String id) {
        this.vamsasId = id;
    }

    public void setDBRef(DBRefEntry[] dbref) {
        this.dbrefs = dbref;
    }

    public DBRefEntry[] getDBRef() {
        if (this.dbrefs == null && this.datasetSequence != null && this != this.datasetSequence) {
            return this.datasetSequence.getDBRef();
        }
        return this.dbrefs;
    }

    public void addDBRef(DBRefEntry entry) {
        if (this.dbrefs == null) {
            this.dbrefs = new DBRefEntry[0];
        }
        int iSize = this.dbrefs.length;
        for (int i = 0; i < iSize; ++i) {
            if (!this.dbrefs[i].equalRef(entry)) continue;
            if (entry.getMap() != null && this.dbrefs[i].getMap() == null) {
                this.dbrefs[i] = entry;
            }
            return;
        }
        DBRefEntry[] temp = new DBRefEntry[iSize + 1];
        System.arraycopy(this.dbrefs, 0, temp, 0, iSize);
        temp[temp.length - 1] = entry;
        this.dbrefs = temp;
    }

    public void setDatasetSequence(SequenceI seq) {
        this.datasetSequence = seq;
    }

    public SequenceI getDatasetSequence() {
        return this.datasetSequence;
    }

    public AlignmentAnnotation[] getAnnotation() {
        if (this.annotation == null) {
            return null;
        }
        AlignmentAnnotation[] ret = new AlignmentAnnotation[this.annotation.size()];
        for (int r = 0; r < ret.length; ++r) {
            ret[r] = (AlignmentAnnotation)this.annotation.elementAt(r);
        }
        return ret;
    }

    public void addAlignmentAnnotation(AlignmentAnnotation annotation) {
        if (this.annotation == null) {
            this.annotation = new Vector();
        }
        this.annotation.addElement(annotation);
        annotation.setSequenceRef(this);
    }

    public void removeAlignmentAnnotation(AlignmentAnnotation annotation) {
        if (this.annotation != null) {
            this.annotation.removeElement(annotation);
            if (this.annotation.size() == 0) {
                this.annotation = null;
            }
        }
    }

    private boolean isValidDatasetSequence() {
        if (this.datasetSequence != null) {
            return false;
        }
        for (int i = 0; i < this.sequence.length; ++i) {
            if (!Comparison.isGap(this.sequence[i])) continue;
            return false;
        }
        return true;
    }

    public SequenceI deriveSequence() {
        Sequence seq = new Sequence(this);
        if (this.datasetSequence != null) {
            seq.setDatasetSequence(this.datasetSequence);
        } else if (this.isValidDatasetSequence()) {
            seq.setDatasetSequence(this);
        } else {
            Sequence ds = seq;
            ds.setSequence(AlignSeq.extractGaps(" .-", new String(this.sequence)));
            this.setDatasetSequence(ds);
            ds.setSequenceFeatures(this.getSequenceFeatures());
            seq = this;
        }
        return seq;
    }

    public SequenceI createDatasetSequence() {
        if (this.datasetSequence == null) {
            this.datasetSequence = new Sequence(this.getName(), AlignSeq.extractGaps(" .-", this.getSequenceAsString()), this.getStart(), this.getEnd());
            this.datasetSequence.setSequenceFeatures(this.getSequenceFeatures());
            this.datasetSequence.setDescription(this.getDescription());
            this.setSequenceFeatures(null);
            this.datasetSequence.setDBRef(this.getDBRef());
            this.setDBRef(null);
            this.datasetSequence.setPDBId(this.getPDBId());
            this.setPDBId(null);
            this.datasetSequence.updatePDBIds();
        }
        return this.datasetSequence;
    }

    public void setAlignmentAnnotation(AlignmentAnnotation[] annotations) {
        if (this.annotation != null) {
            this.annotation.removeAllElements();
        }
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null) continue;
                this.addAlignmentAnnotation(annotations[i]);
            }
        }
    }

    public AlignmentAnnotation[] getAnnotation(String label) {
        if (this.annotation == null || this.annotation.size() == 0) {
            return null;
        }
        Vector<AlignmentAnnotation> subset = new Vector<AlignmentAnnotation>();
        Enumeration e = this.annotation.elements();
        while (e.hasMoreElements()) {
            AlignmentAnnotation ann = (AlignmentAnnotation)e.nextElement();
            if (ann.label == null || !ann.label.equals(label)) continue;
            subset.addElement(ann);
        }
        if (subset.size() == 0) {
            return null;
        }
        AlignmentAnnotation[] anns = new AlignmentAnnotation[subset.size()];
        int i = 0;
        e = subset.elements();
        while (e.hasMoreElements()) {
            anns[i++] = (AlignmentAnnotation)e.nextElement();
        }
        subset.removeAllElements();
        return anns;
    }

    public boolean updatePDBIds() {
        if (this.datasetSequence != null) {
            return this.datasetSequence.updatePDBIds();
        }
        if (this.dbrefs == null || this.dbrefs.length == 0) {
            return false;
        }
        Vector<PDBEntry> newpdb = new Vector<PDBEntry>();
        for (int i = 0; i < this.dbrefs.length; ++i) {
            if (!DBRefSource.PDB.equals(this.dbrefs[i].getSource())) continue;
            PDBEntry pdbe = new PDBEntry();
            pdbe.setId(this.dbrefs[i].getAccessionId());
            if (this.pdbIds == null || this.pdbIds.size() == 0) {
                newpdb.addElement(pdbe);
                continue;
            }
            Enumeration en = this.pdbIds.elements();
            boolean matched = false;
            while (!matched && en.hasMoreElements()) {
                PDBEntry anentry = (PDBEntry)en.nextElement();
                if (!anentry.getId().equals(pdbe.getId())) continue;
                matched = true;
            }
            if (matched) continue;
            newpdb.addElement(pdbe);
        }
        if (newpdb.size() > 0) {
            Enumeration en = newpdb.elements();
            while (en.hasMoreElements()) {
                this.addPDBId((PDBEntry)en.nextElement());
            }
            return true;
        }
        return false;
    }

    public void transferAnnotation(SequenceI entry, Mapping mp) {
        DBRefEntry[] entryRefs;
        if (this.datasetSequence != null) {
            this.datasetSequence.transferAnnotation(entry, mp);
            return;
        }
        if (entry.getDatasetSequence() != null) {
            this.transferAnnotation(entry.getDatasetSequence(), mp);
            return;
        }
        if (entry.getSequenceFeatures() != null) {
            SequenceFeature[] sfs = entry.getSequenceFeatures();
            for (int si = 0; si < sfs.length; ++si) {
                SequenceFeature[] sequenceFeatureArray;
                if (mp != null) {
                    sequenceFeatureArray = mp.locateFeature(sfs[si]);
                } else {
                    SequenceFeature[] sequenceFeatureArray2 = new SequenceFeature[1];
                    sequenceFeatureArray = sequenceFeatureArray2;
                    sequenceFeatureArray2[0] = new SequenceFeature(sfs[si]);
                }
                SequenceFeature[] sf = sequenceFeatureArray;
                if (sf == null || sf.length <= 0) continue;
                for (int sfi = 0; sfi < sf.length; ++sfi) {
                    this.addSequenceFeature(sf[sfi]);
                }
            }
        }
        if (entry.getPDBId() != null) {
            Enumeration e = entry.getPDBId().elements();
            while (e.hasMoreElements()) {
                PDBEntry pdb = (PDBEntry)e.nextElement();
                this.addPDBId(pdb);
            }
        }
        if ((entryRefs = entry.getDBRef()) != null) {
            for (int r = 0; r < entryRefs.length; ++r) {
                DBRefEntry newref = new DBRefEntry(entryRefs[r]);
                if (newref.getMap() == null || mp != null) {
                    // empty if block
                }
                this.addDBRef(newref);
            }
        }
    }
}

