#!/usr/bin/env perl
#
# Copyright 2008 Robert Rati
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License. You may
# obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

my $out_dir = "--RESULTS--";

if ( ! -d $out_dir )
{
  `mkdir $out_dir`;
}

my @classad = <STDIN>;
my $classad_filename = "";

foreach my $line (@classad)
{
  if ($line =~ /WorkFetchFileName\s*=\s*\"(.*)\"/)
  {
    $classad_filename = $1;
    last;
  }
}
if ( $classad_filename eq "" )
{
  print "Unable to determine output file.  Exiting.\n";
  exit 1;
}

my $filename = "$out_dir/$classad_filename\.reply";
open(OUT, ">$filename") || die "Can't open $filename: $!\n";

$result = $ARGV[0];
print OUT "Result: $result\n";
foreach my $line (@classad)
{
  print OUT $line;
}

$pid = fork();

if ($pid)
{
  # parent
  print OUT "Forked reply hook child, pid: $pid\n";
  sleep(5);
  exit 0;
}
else
{
  # child
  close OUT;
  $filename = "$out_dir/$classad_filename\.reply-child";
  open(OUT, ">$filename") || die "Can't open $filename: $!\n";
  while(1)
  {
  	my $date =  scalar localtime();
    print OUT "In forked child: $date \n";
    sleep(1);
  }
}

