#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-04-28 17:11:36 +0300 (Wed, 28 Apr 2021) $
#$Revision: 8737 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.7.0/src/lib/perl5/COD/Spacegroups/Lookup/CCP4.pm $
#------------------------------------------------------------------------
#*
#**

package COD::Spacegroups::Lookup::CCP4;

use strict;
use warnings;

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    @table
);

@COD::Spacegroups::Lookup::CCP4::table =
(
{
    spacegroup_name => 'A 2 1 1',
    setting_name    => 'A 2 1 1',
    full   => 'A 2 1 1',
    short  => 'A2',
    number => 2005,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,-z",
        "x,y+1/2,z+1/2",
        "x,-y+1/2,-z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'A b a 2',
    setting_name    => 'A b a 2',
    full   => 'A b a 2',
    short  => 'Aba2',
    number => 41,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'A b m 2',
    setting_name    => 'A b m 2',
    full   => 'A b m 2',
    short  => 'Abm2',
    number => 39,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y+1/2,z",
        "-x,y+1/2,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'A m a 2',
    setting_name    => 'A m a 2',
    full   => 'A m a 2',
    short  => 'Ama2',
    number => 40,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y,z",
        "-x+1/2,y,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'A m m 2',
    setting_name    => 'A m m 2',
    full   => 'A m m 2',
    short  => 'Amm2',
    number => 38,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z",
        "-x,y,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'B 1 1 2',
    setting_name    => 'B 1 1 2',
    full   => 'B 1 1 2',
    short  => 'B2',
    number => 1005,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'B 1 1 2/b',
    setting_name    => 'B 1 1 2/b',
    full   => 'B 1 1 2/b',
    short  => 'B112/b',
    number => 1015,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z",
        "-x,-y,-z",
        "x,y+1/2,-z",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,-y,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'B 1 1 2/m',
    setting_name    => 'B 1 1 2/m',
    full   => 'B 1 1 2/m',
    short  => 'B112/m',
    number => 1012,
    nsymop => 8,
    symops => [
        "x,y,z",
        "x,y,-z",
        "-x,-y,z",
        "-x,-y,-z",
        "x+1/2,y,z+1/2",
        "x+1/2,y,-z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,-y,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'B 1 1 b',
    setting_name    => 'B 1 1 b',
    full   => 'B 1 1 b',
    short  => 'B11b',
    number => 1009,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,y+1/2,-z",
        "x+1/2,y,z+1/2",
        "x+1/2,y+1/2,-z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'B 1 1 m',
    setting_name    => 'B 1 1 m',
    full   => 'B 1 1 m',
    short  => 'B11m',
    number => 1008,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,z",
        "x+1/2,y+1/2,z",
        "x+1/2,-y+1/2,z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'C 1 2 1',
    setting_name    => 'C 1 2 1',
    full   => 'C 1 2 1',
    short  => 'C2',
    number => 5,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y,-z",
        "x+1/2,y+1/2,z",
        "-x+1/2,y+1/2,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'C 1 2/c 1',
    setting_name    => 'C 1 2/c 1',
    full   => 'C 1 2/c 1',
    short  => 'C2/c',
    number => 15,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,y,-z+1/2",
        "-x,-y,-z",
        "x,-y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,y+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,-y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 1 2/m 1',
    setting_name    => 'C 1 2/m 1',
    full   => 'C 1 2/m 1',
    short  => 'C2/m',
    number => 12,
    nsymop => 8,
    symops => [
        "x,y,z",
        "x,-y,z",
        "-x,y,-z",
        "-x,-y,-z",
        "x+1/2,y+1/2,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 1 21 1',
    setting_name    => 'C 1 21 1',
    full   => 'C 1 21 1',
    short  => 'C21',
    number => 3005,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y+1/2,-z",
        "x+1/2,y+1/2,z",
        "-x+1/2,y,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'C 1 c 1',
    setting_name    => 'C 1 c 1',
    full   => 'C 1 c 1',
    short  => 'Cc',
    number => 9,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,z+1/2",
        "x+1/2,y+1/2,z",
        "x+1/2,-y+1/2,z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'C 1 m 1',
    setting_name    => 'C 1 m 1',
    full   => 'C 1 m 1',
    short  => 'Cm',
    number => 8,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,z",
        "x+1/2,y+1/2,z",
        "x+1/2,-y+1/2,z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'C 2 2 2',
    setting_name    => 'C 2 2 2',
    full   => 'C 2 2 2',
    short  => 'C222',
    number => 21,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 2 2 21',
    setting_name    => 'C 2 2 21',
    full   => 'C 2 2 21',
    short  => 'C2221',
    number => 20,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 2 2 21a)',
    setting_name    => 'C 2 2 21a)',
    full   => 'C 2 2 21a)',
    short  => 'C2221a',
    number => 1020,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x,y+1/2,-z+1/2",
        "x+1/2,y+1/2,z",
        "-x,-y+1/2,z+1/2",
        "x,-y,-z",
        "-x+1/2,y,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 2 2 2a',
    setting_name    => 'C 2 2 2a',
    full   => 'C 2 2 2a',
    short  => 'C222a',
    number => 1021,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y,-z",
        "-x,y+1/2,-z",
        "x+1/2,y+1/2,z",
        "-x,-y,z",
        "x,-y+1/2,-z",
        "-x+1/2,y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C 2/c 2/c 2/a',
    setting_name    => 'C 2/c 2/c 2/a',
    full   => 'C 2/c 2/c 2/a',
    short  => 'Ccca',
    number => 68,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "-x,y,-z",
        "x+1/2,-y+1/2,-z",
        "-x,-y+1/2,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z",
        "x,-y,-z",
        "-x+1/2,-y,-z+1/2",
        "x,y+1/2,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C 2/c 2/c 2/m',
    setting_name    => 'C 2/c 2/c 2/m',
    full   => 'C 2/c 2/c 2/m',
    short  => 'Cccm',
    number => 66,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C 2/m 2/c 21/a',
    setting_name    => 'C 2/m 2/c 21/a',
    full   => 'C 2/m 2/c 21/a',
    short  => 'Cmca',
    number => 64,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C 2/m 2/c 21/m',
    setting_name    => 'C 2/m 2/c 21/m',
    full   => 'C 2/m 2/c 21/m',
    short  => 'Cmcm',
    number => 63,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y,-z+1/2",
        "x,-y,z+1/2",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C 2/m 2/m 2/a',
    setting_name    => 'C 2/m 2/m 2/a',
    full   => 'C 2/m 2/m 2/a',
    short  => 'Cmma',
    number => 67,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z",
        "-x,y+1/2,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y+1/2,-z",
        "x,-y+1/2,z",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y,z",
        "-x+1/2,y,-z",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y,-z",
        "x+1/2,-y,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C 2/m 2/m 2/m',
    setting_name    => 'C 2/m 2/m 2/m',
    full   => 'C 2/m 2/m 2/m',
    short  => 'Cmmm',
    number => 65,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'C c c 2',
    setting_name    => 'C c c 2',
    full   => 'C c c 2',
    short  => 'Ccc2',
    number => 37,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C m c 21',
    setting_name    => 'C m c 21',
    full   => 'C m c 21',
    short  => 'Cmc21',
    number => 36,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "x,-y,z+1/2",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'C m m 2',
    setting_name    => 'C m m 2',
    full   => 'C m m 2',
    short  => 'Cmm2',
    number => 35,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z",
        "-x,y,z",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'F -4 3 c',
    setting_name    => 'F -4 3 c',
    full   => 'F -4 3 c',
    short  => 'F-43c',
    number => 219,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "z+1/2,y+1/2,x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y+1/2,x,z",
        "-y+1/2,-x,z",
        "y+1/2,-x,-z",
        "-y+1/2,x,-z",
        "x+1/2,z,y",
        "-x+1/2,z,-y",
        "-x+1/2,-z,y",
        "x+1/2,-z,-y",
        "z+1/2,y,x",
        "z+1/2,-y,-x",
        "-z+1/2,y,-x",
        "-z+1/2,-y,x",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y,x+1/2,z",
        "-y,-x+1/2,z",
        "y,-x+1/2,-z",
        "-y,x+1/2,-z",
        "x,z+1/2,y",
        "-x,z+1/2,-y",
        "-x,-z+1/2,y",
        "x,-z+1/2,-y",
        "z,y+1/2,x",
        "z,-y+1/2,-x",
        "-z,y+1/2,-x",
        "-z,-y+1/2,x",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "y,x,z+1/2",
        "-y,-x,z+1/2",
        "y,-x,-z+1/2",
        "-y,x,-z+1/2",
        "x,z,y+1/2",
        "-x,z,-y+1/2",
        "-x,-z,y+1/2",
        "x,-z,-y+1/2",
        "z,y,x+1/2",
        "z,-y,-x+1/2",
        "-z,y,-x+1/2",
        "-z,-y,x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F -4 3 m',
    setting_name    => 'F -4 3 m',
    full   => 'F -4 3 m',
    short  => 'F-43m',
    number => 216,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,z",
        "-y,-x,z",
        "y,-x,-z",
        "-y,x,-z",
        "x,z,y",
        "-x,z,-y",
        "-x,-z,y",
        "x,-z,-y",
        "z,y,x",
        "z,-y,-x",
        "-z,y,-x",
        "-z,-y,x",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y,x+1/2,z+1/2",
        "-y,-x+1/2,z+1/2",
        "y,-x+1/2,-z+1/2",
        "-y,x+1/2,-z+1/2",
        "x,z+1/2,y+1/2",
        "-x,z+1/2,-y+1/2",
        "-x,-z+1/2,y+1/2",
        "x,-z+1/2,-y+1/2",
        "z,y+1/2,x+1/2",
        "z,-y+1/2,-x+1/2",
        "-z,y+1/2,-x+1/2",
        "-z,-y+1/2,x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/2,x,z+1/2",
        "-y+1/2,-x,z+1/2",
        "y+1/2,-x,-z+1/2",
        "-y+1/2,x,-z+1/2",
        "x+1/2,z,y+1/2",
        "-x+1/2,z,-y+1/2",
        "-x+1/2,-z,y+1/2",
        "x+1/2,-z,-y+1/2",
        "z+1/2,y,x+1/2",
        "z+1/2,-y,-x+1/2",
        "-z+1/2,y,-x+1/2",
        "-z+1/2,-y,x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/2,x+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,-x+1/2,-z",
        "-y+1/2,x+1/2,-z",
        "x+1/2,z+1/2,y",
        "-x+1/2,z+1/2,-y",
        "-x+1/2,-z+1/2,y",
        "x+1/2,-z+1/2,-y",
        "z+1/2,y+1/2,x",
        "z+1/2,-y+1/2,-x",
        "-z+1/2,y+1/2,-x",
        "-z+1/2,-y+1/2,x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F 2 2 2',
    setting_name    => 'F 2 2 2',
    full   => 'F 2 2 2',
    short  => 'F222',
    number => 22,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'F 2 2 2a',
    setting_name    => 'F 2 2 2a',
    full   => 'F 2 2 2a',
    short  => 'F222a',
    number => 1022,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y,-z",
        "-x,y+1/2,-z",
        "x,y+1/2,z+1/2",
        "-x+1/2,-y,z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x,y,-z+1/2",
        "x+1/2,y,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x,-y,-z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,y+1/2,z",
        "-x,-y,z",
        "x,-y+1/2,-z",
        "-x+1/2,y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'F 2 3',
    setting_name    => 'F 2 3',
    full   => 'F 2 3',
    short  => 'F23',
    number => 196,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'F 2/d -3',
    setting_name    => 'F 2/d -3',
    full   => 'F 2/d -3',
    short  => 'Fd-3',
    number => 203,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "-x+1/4,-y+1/4,-z+1/4",
        "x+1/4,y+1/4,-z+1/4",
        "x+1/4,-y+1/4,z+1/4",
        "-x+1/4,y+1/4,z+1/4",
        "-z+1/4,-x+1/4,-y+1/4",
        "-z+1/4,x+1/4,y+1/4",
        "z+1/4,x+1/4,-y+1/4",
        "z+1/4,-x+1/4,y+1/4",
        "-y+1/4,-z+1/4,-x+1/4",
        "y+1/4,-z+1/4,x+1/4",
        "-y+1/4,z+1/4,x+1/4",
        "y+1/4,z+1/4,-x+1/4",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "-x+1/4,-y+3/4,-z+3/4",
        "x+1/4,y+3/4,-z+3/4",
        "x+1/4,-y+3/4,z+3/4",
        "-x+1/4,y+3/4,z+3/4",
        "-z+1/4,-x+3/4,-y+3/4",
        "-z+1/4,x+3/4,y+3/4",
        "z+1/4,x+3/4,-y+3/4",
        "z+1/4,-x+3/4,y+3/4",
        "-y+1/4,-z+3/4,-x+3/4",
        "y+1/4,-z+3/4,x+3/4",
        "-y+1/4,z+3/4,x+3/4",
        "y+1/4,z+3/4,-x+3/4",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "-x+3/4,-y+1/4,-z+3/4",
        "x+3/4,y+1/4,-z+3/4",
        "x+3/4,-y+1/4,z+3/4",
        "-x+3/4,y+1/4,z+3/4",
        "-z+3/4,-x+1/4,-y+3/4",
        "-z+3/4,x+1/4,y+3/4",
        "z+3/4,x+1/4,-y+3/4",
        "z+3/4,-x+1/4,y+3/4",
        "-y+3/4,-z+1/4,-x+3/4",
        "y+3/4,-z+1/4,x+3/4",
        "-y+3/4,z+1/4,x+3/4",
        "y+3/4,z+1/4,-x+3/4",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "-x+3/4,-y+3/4,-z+1/4",
        "x+3/4,y+3/4,-z+1/4",
        "x+3/4,-y+3/4,z+1/4",
        "-x+3/4,y+3/4,z+1/4",
        "-z+3/4,-x+3/4,-y+1/4",
        "-z+3/4,x+3/4,y+1/4",
        "z+3/4,x+3/4,-y+1/4",
        "z+3/4,-x+3/4,y+1/4",
        "-y+3/4,-z+3/4,-x+1/4",
        "y+3/4,-z+3/4,x+1/4",
        "-y+3/4,z+3/4,x+1/4",
        "y+3/4,z+3/4,-x+1/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F 2/d 2/d 2/d',
    setting_name    => 'F 2/d 2/d 2/d',
    full   => 'F 2/d 2/d 2/d',
    short  => 'Fddd',
    number => 70,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x+1/4,-y+1/4,-z+1/4",
        "x+1/4,y+1/4,-z+1/4",
        "x+1/4,-y+1/4,z+1/4",
        "-x+1/4,y+1/4,z+1/4",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "-x+1/4,-y+3/4,-z+3/4",
        "x+1/4,y+3/4,-z+3/4",
        "x+1/4,-y+3/4,z+3/4",
        "-x+1/4,y+3/4,z+3/4",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "-x+3/4,-y+1/4,-z+3/4",
        "x+3/4,y+1/4,-z+3/4",
        "x+3/4,-y+1/4,z+3/4",
        "-x+3/4,y+1/4,z+3/4",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x+3/4,-y+3/4,-z+1/4",
        "x+3/4,y+3/4,-z+1/4",
        "x+3/4,-y+3/4,z+1/4",
        "-x+3/4,y+3/4,z+1/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'F 2/m -3',
    setting_name    => 'F 2/m -3',
    full   => 'F 2/m -3',
    short  => 'Fm-3',
    number => 202,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "-x,-y+1/2,-z+1/2",
        "x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
        "-z,-x+1/2,-y+1/2",
        "-z,x+1/2,y+1/2",
        "z,x+1/2,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z+1/2,-x+1/2",
        "y,-z+1/2,x+1/2",
        "-y,z+1/2,x+1/2",
        "y,z+1/2,-x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "-x+1/2,-y,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
        "-z+1/2,-x,-y+1/2",
        "-z+1/2,x,y+1/2",
        "z+1/2,x,-y+1/2",
        "z+1/2,-x,y+1/2",
        "-y+1/2,-z,-x+1/2",
        "y+1/2,-z,x+1/2",
        "-y+1/2,z,x+1/2",
        "y+1/2,z,-x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-z+1/2,-x+1/2,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x+1/2,-y",
        "z+1/2,-x+1/2,y",
        "-y+1/2,-z+1/2,-x",
        "y+1/2,-z+1/2,x",
        "-y+1/2,z+1/2,x",
        "y+1/2,z+1/2,-x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F 2/m 2/m 2/m',
    setting_name    => 'F 2/m 2/m 2/m',
    full   => 'F 2/m 2/m 2/m',
    short  => 'Fmmm',
    number => 69,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "-x,-y+1/2,-z+1/2",
        "x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "-x+1/2,-y,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'F 4 3 2',
    setting_name    => 'F 4 3 2',
    full   => 'F 4 3 2',
    short  => 'F432',
    number => 209,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y,x+1/2,-z+1/2",
        "-y,-x+1/2,-z+1/2",
        "y,-x+1/2,z+1/2",
        "-y,x+1/2,z+1/2",
        "x,z+1/2,-y+1/2",
        "-x,z+1/2,y+1/2",
        "-x,-z+1/2,-y+1/2",
        "x,-z+1/2,y+1/2",
        "z,y+1/2,-x+1/2",
        "z,-y+1/2,x+1/2",
        "-z,y+1/2,x+1/2",
        "-z,-y+1/2,-x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/2,x,-z+1/2",
        "-y+1/2,-x,-z+1/2",
        "y+1/2,-x,z+1/2",
        "-y+1/2,x,z+1/2",
        "x+1/2,z,-y+1/2",
        "-x+1/2,z,y+1/2",
        "-x+1/2,-z,-y+1/2",
        "x+1/2,-z,y+1/2",
        "z+1/2,y,-x+1/2",
        "z+1/2,-y,x+1/2",
        "-z+1/2,y,x+1/2",
        "-z+1/2,-y,-x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
        "y+1/2,-x+1/2,z",
        "-y+1/2,x+1/2,z",
        "x+1/2,z+1/2,-y",
        "-x+1/2,z+1/2,y",
        "-x+1/2,-z+1/2,-y",
        "x+1/2,-z+1/2,y",
        "z+1/2,y+1/2,-x",
        "z+1/2,-y+1/2,x",
        "-z+1/2,y+1/2,x",
        "-z+1/2,-y+1/2,-x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F 4/m -3 2/c',
    setting_name    => 'F 4/m -3 2/c',
    full   => 'F 4/m -3 2/c',
    short  => 'Fm-3c',
    number => 226,
    nsymop => 192,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "z+1/2,y+1/2,x+1/2",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y+1/2,x,-z",
        "-y+1/2,-x,-z",
        "y+1/2,-x,z",
        "-y+1/2,x,z",
        "x+1/2,z,-y",
        "-x+1/2,z,y",
        "-x+1/2,-z,-y",
        "x+1/2,-z,y",
        "z+1/2,y,-x",
        "z+1/2,-y,x",
        "-z+1/2,y,x",
        "-z+1/2,-y,-x",
        "-x,-y+1/2,-z+1/2",
        "x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
        "-z,-x+1/2,-y+1/2",
        "-z,x+1/2,y+1/2",
        "z,x+1/2,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z+1/2,-x+1/2",
        "y,-z+1/2,x+1/2",
        "-y,z+1/2,x+1/2",
        "y,z+1/2,-x+1/2",
        "-y+1/2,-x,z",
        "y+1/2,x,z",
        "-y+1/2,x,-z",
        "y+1/2,-x,-z",
        "-x+1/2,-z,y",
        "x+1/2,-z,-y",
        "x+1/2,z,y",
        "-x+1/2,z,-y",
        "-z+1/2,-y,x",
        "-z+1/2,y,-x",
        "z+1/2,-y,-x",
        "z+1/2,y,x",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y,x+1/2,-z",
        "-y,-x+1/2,-z",
        "y,-x+1/2,z",
        "-y,x+1/2,z",
        "x,z+1/2,-y",
        "-x,z+1/2,y",
        "-x,-z+1/2,-y",
        "x,-z+1/2,y",
        "z,y+1/2,-x",
        "z,-y+1/2,x",
        "-z,y+1/2,x",
        "-z,-y+1/2,-x",
        "-x+1/2,-y,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
        "-z+1/2,-x,-y+1/2",
        "-z+1/2,x,y+1/2",
        "z+1/2,x,-y+1/2",
        "z+1/2,-x,y+1/2",
        "-y+1/2,-z,-x+1/2",
        "y+1/2,-z,x+1/2",
        "-y+1/2,z,x+1/2",
        "y+1/2,z,-x+1/2",
        "-y,-x+1/2,z",
        "y,x+1/2,z",
        "-y,x+1/2,-z",
        "y,-x+1/2,-z",
        "-x,-z+1/2,y",
        "x,-z+1/2,-y",
        "x,z+1/2,y",
        "-x,z+1/2,-y",
        "-z,-y+1/2,x",
        "-z,y+1/2,-x",
        "z,-y+1/2,-x",
        "z,y+1/2,x",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "y,-x,z+1/2",
        "-y,x,z+1/2",
        "x,z,-y+1/2",
        "-x,z,y+1/2",
        "-x,-z,-y+1/2",
        "x,-z,y+1/2",
        "z,y,-x+1/2",
        "z,-y,x+1/2",
        "-z,y,x+1/2",
        "-z,-y,-x+1/2",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-z+1/2,-x+1/2,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x+1/2,-y",
        "z+1/2,-x+1/2,y",
        "-y+1/2,-z+1/2,-x",
        "y+1/2,-z+1/2,x",
        "-y+1/2,z+1/2,x",
        "y+1/2,z+1/2,-x",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
        "-y,x,-z+1/2",
        "y,-x,-z+1/2",
        "-x,-z,y+1/2",
        "x,-z,-y+1/2",
        "x,z,y+1/2",
        "-x,z,-y+1/2",
        "-z,-y,x+1/2",
        "-z,y,-x+1/2",
        "z,-y,-x+1/2",
        "z,y,x+1/2",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'F 4/m -3 2/m',
    setting_name    => 'F 4/m -3 2/m',
    full   => 'F 4/m -3 2/m',
    short  => 'Fm-3m',
    number => 225,
    nsymop => 192,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "-y,-x,z",
        "y,x,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,-z,y",
        "x,-z,-y",
        "x,z,y",
        "-x,z,-y",
        "-z,-y,x",
        "-z,y,-x",
        "z,-y,-x",
        "z,y,x",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "z,x+1/2,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y,x+1/2,-z+1/2",
        "-y,-x+1/2,-z+1/2",
        "y,-x+1/2,z+1/2",
        "-y,x+1/2,z+1/2",
        "x,z+1/2,-y+1/2",
        "-x,z+1/2,y+1/2",
        "-x,-z+1/2,-y+1/2",
        "x,-z+1/2,y+1/2",
        "z,y+1/2,-x+1/2",
        "z,-y+1/2,x+1/2",
        "-z,y+1/2,x+1/2",
        "-z,-y+1/2,-x+1/2",
        "-x,-y+1/2,-z+1/2",
        "x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
        "-z,-x+1/2,-y+1/2",
        "-z,x+1/2,y+1/2",
        "z,x+1/2,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z+1/2,-x+1/2",
        "y,-z+1/2,x+1/2",
        "-y,z+1/2,x+1/2",
        "y,z+1/2,-x+1/2",
        "-y,-x+1/2,z+1/2",
        "y,x+1/2,z+1/2",
        "-y,x+1/2,-z+1/2",
        "y,-x+1/2,-z+1/2",
        "-x,-z+1/2,y+1/2",
        "x,-z+1/2,-y+1/2",
        "x,z+1/2,y+1/2",
        "-x,z+1/2,-y+1/2",
        "-z,-y+1/2,x+1/2",
        "-z,y+1/2,-x+1/2",
        "z,-y+1/2,-x+1/2",
        "z,y+1/2,x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "z+1/2,x,y+1/2",
        "z+1/2,-x,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z+1/2,x,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/2,x,-z+1/2",
        "-y+1/2,-x,-z+1/2",
        "y+1/2,-x,z+1/2",
        "-y+1/2,x,z+1/2",
        "x+1/2,z,-y+1/2",
        "-x+1/2,z,y+1/2",
        "-x+1/2,-z,-y+1/2",
        "x+1/2,-z,y+1/2",
        "z+1/2,y,-x+1/2",
        "z+1/2,-y,x+1/2",
        "-z+1/2,y,x+1/2",
        "-z+1/2,-y,-x+1/2",
        "-x+1/2,-y,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
        "-z+1/2,-x,-y+1/2",
        "-z+1/2,x,y+1/2",
        "z+1/2,x,-y+1/2",
        "z+1/2,-x,y+1/2",
        "-y+1/2,-z,-x+1/2",
        "y+1/2,-z,x+1/2",
        "-y+1/2,z,x+1/2",
        "y+1/2,z,-x+1/2",
        "-y+1/2,-x,z+1/2",
        "y+1/2,x,z+1/2",
        "-y+1/2,x,-z+1/2",
        "y+1/2,-x,-z+1/2",
        "-x+1/2,-z,y+1/2",
        "x+1/2,-z,-y+1/2",
        "x+1/2,z,y+1/2",
        "-x+1/2,z,-y+1/2",
        "-z+1/2,-y,x+1/2",
        "-z+1/2,y,-x+1/2",
        "z+1/2,-y,-x+1/2",
        "z+1/2,y,x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "z+1/2,x+1/2,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x+1/2,y",
        "-z+1/2,x+1/2,-y",
        "y+1/2,z+1/2,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
        "y+1/2,-x+1/2,z",
        "-y+1/2,x+1/2,z",
        "x+1/2,z+1/2,-y",
        "-x+1/2,z+1/2,y",
        "-x+1/2,-z+1/2,-y",
        "x+1/2,-z+1/2,y",
        "z+1/2,y+1/2,-x",
        "z+1/2,-y+1/2,x",
        "-z+1/2,y+1/2,x",
        "-z+1/2,-y+1/2,-x",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-z+1/2,-x+1/2,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x+1/2,-y",
        "z+1/2,-x+1/2,y",
        "-y+1/2,-z+1/2,-x",
        "y+1/2,-z+1/2,x",
        "-y+1/2,z+1/2,x",
        "y+1/2,z+1/2,-x",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
        "-y+1/2,x+1/2,-z",
        "y+1/2,-x+1/2,-z",
        "-x+1/2,-z+1/2,y",
        "x+1/2,-z+1/2,-y",
        "x+1/2,z+1/2,y",
        "-x+1/2,z+1/2,-y",
        "-z+1/2,-y+1/2,x",
        "-z+1/2,y+1/2,-x",
        "z+1/2,-y+1/2,-x",
        "z+1/2,y+1/2,x",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'F 41 3 2',
    setting_name    => 'F 41 3 2',
    full   => 'F 41 3 2',
    short  => 'F4132',
    number => 210,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y,-z+1/2",
        "z,x,y",
        "z+1/2,-x,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y",
        "y,z,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y+3/4,x+1/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+1/4,-x+3/4,z+3/4",
        "-y+3/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+3/4",
        "-x+3/4,z+3/4,y+1/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+1/4,-z+3/4,y+3/4",
        "z+3/4,y+1/4,-x+3/4",
        "z+1/4,-y+3/4,x+3/4",
        "-z+3/4,y+3/4,x+1/4",
        "-z+1/4,-y+1/4,-x+1/4",
        "x,y+1/2,z+1/2",
        "-x,-y,z",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y",
        "-z,-x,y",
        "-z+1/2,x,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y,-z,x",
        "y+3/4,x+3/4,-z+1/4",
        "-y+1/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+3/4,z+3/4,-y+1/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+1/4",
        "z+3/4,y+3/4,-x+1/4",
        "z+1/4,-y+1/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+3/4,-x+3/4",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y+1/2,z",
        "-x,y+1/2,-z+1/2",
        "x,-y,-z",
        "z+1/2,x,y+1/2",
        "z,-x,-y",
        "-z+1/2,-x+1/2,y",
        "-z,x+1/2,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/4,x+1/4,-z+1/4",
        "-y+3/4,-x+1/4,-z+3/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+1/4,x+3/4,z+3/4",
        "x+1/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+3/4",
        "-x+3/4,-z+1/4,-y+3/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+1/4,-x+1/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+1/4,y+3/4,x+3/4",
        "-z+3/4,-y+1/4,-x+3/4",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y,z+1/2",
        "-x,y,-z",
        "x,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y",
        "z,-x+1/2,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z,x,-y",
        "y+1/2,z+1/2,x",
        "-y,z,-x",
        "y,-z+1/2,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/4,x+3/4,-z+3/4",
        "-y+3/4,-x+3/4,-z+1/4",
        "y+3/4,-x+1/4,z+3/4",
        "-y+1/4,x+1/4,z+1/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+1/4,z+1/4,y+1/4",
        "-x+3/4,-z+3/4,-y+1/4",
        "x+3/4,-z+1/4,y+3/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+1/4,x+3/4",
        "-z+1/4,y+1/4,x+1/4",
        "-z+3/4,-y+3/4,-x+1/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'F 41/d -3 2/c',
    setting_name    => 'F 41/d -3 2/c',
    full   => 'F 41/d -3 2/c',
    short  => 'Fd-3c',
    number => 228,
    nsymop => 192,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y,-z+1/2",
        "z,x,y",
        "z+1/2,-x,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y",
        "y,z,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y+3/4,x+1/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+1/4,-x+3/4,z+3/4",
        "-y+3/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+3/4",
        "-x+3/4,z+3/4,y+1/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+1/4,-z+3/4,y+3/4",
        "z+3/4,y+1/4,-x+3/4",
        "z+1/4,-y+3/4,x+3/4",
        "-z+3/4,y+3/4,x+1/4",
        "-z+1/4,-y+1/4,-x+1/4",
        "-x+3/4,-y+3/4,-z+3/4",
        "x+3/4,y+1/4,-z+1/4",
        "x+1/4,-y+1/4,z+3/4",
        "-x+1/4,y+3/4,z+1/4",
        "-z+3/4,-x+3/4,-y+3/4",
        "-z+1/4,x+3/4,y+1/4",
        "z+3/4,x+1/4,-y+1/4",
        "z+1/4,-x+1/4,y+3/4",
        "-y+3/4,-z+3/4,-x+3/4",
        "y+1/4,-z+1/4,x+3/4",
        "-y+1/4,z+3/4,x+1/4",
        "y+3/4,z+1/4,-x+1/4",
        "-y,-x+1/2,z",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,x,-z",
        "y,-x,-z+1/2",
        "-x,-z+1/2,y",
        "x,-z,-y+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z,-y",
        "-z,-y+1/2,x",
        "-z+1/2,y,-x",
        "z,-y,-x+1/2",
        "z+1/2,y+1/2,x+1/2",
        "x,y+1/2,z+1/2",
        "-x,-y,z",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y",
        "-z,-x,y",
        "-z+1/2,x,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y,-z,x",
        "y+3/4,x+3/4,-z+1/4",
        "-y+1/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+3/4,z+3/4,-y+1/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+1/4",
        "z+3/4,y+3/4,-x+1/4",
        "z+1/4,-y+1/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+3/4,-x+3/4",
        "-x+3/4,-y+1/4,-z+1/4",
        "x+3/4,y+3/4,-z+3/4",
        "x+1/4,-y+3/4,z+1/4",
        "-x+1/4,y+1/4,z+3/4",
        "-z+3/4,-x+1/4,-y+1/4",
        "-z+1/4,x+1/4,y+3/4",
        "z+3/4,x+3/4,-y+3/4",
        "z+1/4,-x+3/4,y+1/4",
        "-y+3/4,-z+1/4,-x+1/4",
        "y+1/4,-z+3/4,x+1/4",
        "-y+1/4,z+1/4,x+3/4",
        "y+3/4,z+3/4,-x+3/4",
        "-y,-x,z+1/2",
        "y+1/2,x,z",
        "-y+1/2,x+1/2,-z+1/2",
        "y,-x+1/2,-z",
        "-x,-z,y+1/2",
        "x,-z+1/2,-y",
        "x+1/2,z,y",
        "-x+1/2,z+1/2,-y+1/2",
        "-z,-y,x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "z,-y+1/2,-x",
        "z+1/2,y,x",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y+1/2,z",
        "-x,y+1/2,-z+1/2",
        "x,-y,-z",
        "z+1/2,x,y+1/2",
        "z,-x,-y",
        "-z+1/2,-x+1/2,y",
        "-z,x+1/2,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/4,x+1/4,-z+1/4",
        "-y+3/4,-x+1/4,-z+3/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+1/4,x+3/4,z+3/4",
        "x+1/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+3/4",
        "-x+3/4,-z+1/4,-y+3/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+1/4,-x+1/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+1/4,y+3/4,x+3/4",
        "-z+3/4,-y+1/4,-x+3/4",
        "-x+1/4,-y+3/4,-z+1/4",
        "x+1/4,y+1/4,-z+3/4",
        "x+3/4,-y+1/4,z+1/4",
        "-x+3/4,y+3/4,z+3/4",
        "-z+1/4,-x+3/4,-y+1/4",
        "-z+3/4,x+3/4,y+3/4",
        "z+1/4,x+1/4,-y+3/4",
        "z+3/4,-x+1/4,y+1/4",
        "-y+1/4,-z+3/4,-x+1/4",
        "y+3/4,-z+1/4,x+1/4",
        "-y+3/4,z+3/4,x+3/4",
        "y+1/4,z+1/4,-x+3/4",
        "-y+1/2,-x+1/2,z+1/2",
        "y,x+1/2,z",
        "-y,x,-z+1/2",
        "y+1/2,-x,-z",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z,-y",
        "x,z+1/2,y",
        "-x,z,-y+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "-z,y,-x+1/2",
        "z+1/2,-y,-x",
        "z,y+1/2,x",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y,z+1/2",
        "-x,y,-z",
        "x,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y",
        "z,-x+1/2,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z,x,-y",
        "y+1/2,z+1/2,x",
        "-y,z,-x",
        "y,-z+1/2,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/4,x+3/4,-z+3/4",
        "-y+3/4,-x+3/4,-z+1/4",
        "y+3/4,-x+1/4,z+3/4",
        "-y+1/4,x+1/4,z+1/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+1/4,z+1/4,y+1/4",
        "-x+3/4,-z+3/4,-y+1/4",
        "x+3/4,-z+1/4,y+3/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+1/4,x+3/4",
        "-z+1/4,y+1/4,x+1/4",
        "-z+3/4,-y+3/4,-x+1/4",
        "-x+1/4,-y+1/4,-z+3/4",
        "x+1/4,y+3/4,-z+1/4",
        "x+3/4,-y+3/4,z+3/4",
        "-x+3/4,y+1/4,z+1/4",
        "-z+1/4,-x+1/4,-y+3/4",
        "-z+3/4,x+1/4,y+1/4",
        "z+1/4,x+3/4,-y+1/4",
        "z+3/4,-x+3/4,y+3/4",
        "-y+1/4,-z+1/4,-x+3/4",
        "y+3/4,-z+3/4,x+3/4",
        "-y+3/4,z+1/4,x+1/4",
        "y+1/4,z+3/4,-x+1/4",
        "-y+1/2,-x,z",
        "y,x,z+1/2",
        "-y,x+1/2,-z",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z,y",
        "x+1/2,-z+1/2,-y+1/2",
        "x,z,y+1/2",
        "-x,z+1/2,-y",
        "-z+1/2,-y,x",
        "-z,y+1/2,-x",
        "z+1/2,-y+1/2,-x+1/2",
        "z,y,x+1/2",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'F 41/d -3 2/m',
    setting_name    => 'F 41/d -3 2/m',
    full   => 'F 41/d -3 2/m',
    short  => 'Fd-3m',
    number => 227,
    nsymop => 192,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y,-z+1/2",
        "z,x,y",
        "z+1/2,-x,-y+1/2",
        "-z,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y",
        "y,z,x",
        "-y+1/2,z+1/2,-x",
        "y+1/2,-z,-x+1/2",
        "-y,-z+1/2,x+1/2",
        "y+3/4,x+1/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+1/4,-x+3/4,z+3/4",
        "-y+3/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+3/4",
        "-x+3/4,z+3/4,y+1/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+1/4,-z+3/4,y+3/4",
        "z+3/4,y+1/4,-x+3/4",
        "z+1/4,-y+3/4,x+3/4",
        "-z+3/4,y+3/4,x+1/4",
        "-z+1/4,-y+1/4,-x+1/4",
        "-x+1/4,-y+1/4,-z+1/4",
        "x+1/4,y+3/4,-z+3/4",
        "x+3/4,-y+3/4,z+1/4",
        "-x+3/4,y+1/4,z+3/4",
        "-z+1/4,-x+1/4,-y+1/4",
        "-z+3/4,x+1/4,y+3/4",
        "z+1/4,x+3/4,-y+3/4",
        "z+3/4,-x+3/4,y+1/4",
        "-y+1/4,-z+1/4,-x+1/4",
        "y+3/4,-z+3/4,x+1/4",
        "-y+3/4,z+1/4,x+3/4",
        "y+1/4,z+3/4,-x+3/4",
        "-y+1/2,-x,z+1/2",
        "y,x,z",
        "-y,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z",
        "-x+1/2,-z,y+1/2",
        "x+1/2,-z+1/2,-y",
        "x,z,y",
        "-x,z+1/2,-y+1/2",
        "-z+1/2,-y,x+1/2",
        "-z,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,-x",
        "z,y,x",
        "x,y+1/2,z+1/2",
        "-x,-y,z",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y",
        "-z,-x,y",
        "-z+1/2,x,-y+1/2",
        "y,z+1/2,x+1/2",
        "-y+1/2,z,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y,-z,x",
        "y+3/4,x+3/4,-z+1/4",
        "-y+1/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+3/4,z+3/4,-y+1/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+1/4",
        "z+3/4,y+3/4,-x+1/4",
        "z+1/4,-y+1/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+3/4,-x+3/4",
        "-x+1/4,-y+3/4,-z+3/4",
        "x+1/4,y+1/4,-z+1/4",
        "x+3/4,-y+1/4,z+3/4",
        "-x+3/4,y+3/4,z+1/4",
        "-z+1/4,-x+3/4,-y+3/4",
        "-z+3/4,x+3/4,y+1/4",
        "z+1/4,x+1/4,-y+1/4",
        "z+3/4,-x+1/4,y+3/4",
        "-y+1/4,-z+3/4,-x+3/4",
        "y+3/4,-z+1/4,x+3/4",
        "-y+3/4,z+3/4,x+1/4",
        "y+1/4,z+1/4,-x+1/4",
        "-y+1/2,-x+1/2,z",
        "y,x+1/2,z+1/2",
        "-y,x,-z",
        "y+1/2,-x,-z+1/2",
        "-x+1/2,-z+1/2,y",
        "x+1/2,-z,-y+1/2",
        "x,z+1/2,y+1/2",
        "-x,z,-y",
        "-z+1/2,-y+1/2,x",
        "-z,y,-x",
        "z+1/2,-y,-x+1/2",
        "z,y+1/2,x+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y+1/2,z",
        "-x,y+1/2,-z+1/2",
        "x,-y,-z",
        "z+1/2,x,y+1/2",
        "z,-x,-y",
        "-z+1/2,-x+1/2,y",
        "-z,x+1/2,-y+1/2",
        "y+1/2,z,x+1/2",
        "-y,z+1/2,-x+1/2",
        "y,-z,-x",
        "-y+1/2,-z+1/2,x",
        "y+1/4,x+1/4,-z+1/4",
        "-y+3/4,-x+1/4,-z+3/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+1/4,x+3/4,z+3/4",
        "x+1/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+3/4",
        "-x+3/4,-z+1/4,-y+3/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+1/4,-x+1/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+1/4,y+3/4,x+3/4",
        "-z+3/4,-y+1/4,-x+3/4",
        "-x+3/4,-y+1/4,-z+3/4",
        "x+3/4,y+3/4,-z+1/4",
        "x+1/4,-y+3/4,z+3/4",
        "-x+1/4,y+1/4,z+1/4",
        "-z+3/4,-x+1/4,-y+3/4",
        "-z+1/4,x+1/4,y+1/4",
        "z+3/4,x+3/4,-y+1/4",
        "z+1/4,-x+3/4,y+3/4",
        "-y+3/4,-z+1/4,-x+3/4",
        "y+1/4,-z+3/4,x+3/4",
        "-y+1/4,z+1/4,x+1/4",
        "y+3/4,z+3/4,-x+1/4",
        "-y,-x,z",
        "y+1/2,x,z+1/2",
        "-y+1/2,x+1/2,-z",
        "y,-x+1/2,-z+1/2",
        "-x,-z,y",
        "x,-z+1/2,-y+1/2",
        "x+1/2,z,y+1/2",
        "-x+1/2,z+1/2,-y",
        "-z,-y,x",
        "-z+1/2,y+1/2,-x",
        "z,-y+1/2,-x+1/2",
        "z+1/2,y,x+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y,z+1/2",
        "-x,y,-z",
        "x,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y",
        "z,-x+1/2,-y+1/2",
        "-z+1/2,-x,y+1/2",
        "-z,x,-y",
        "y+1/2,z+1/2,x",
        "-y,z,-x",
        "y,-z+1/2,-x+1/2",
        "-y+1/2,-z,x+1/2",
        "y+1/4,x+3/4,-z+3/4",
        "-y+3/4,-x+3/4,-z+1/4",
        "y+3/4,-x+1/4,z+3/4",
        "-y+1/4,x+1/4,z+1/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+1/4,z+1/4,y+1/4",
        "-x+3/4,-z+3/4,-y+1/4",
        "x+3/4,-z+1/4,y+3/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+1/4,x+3/4",
        "-z+1/4,y+1/4,x+1/4",
        "-z+3/4,-y+3/4,-x+1/4",
        "-x+3/4,-y+3/4,-z+1/4",
        "x+3/4,y+1/4,-z+3/4",
        "x+1/4,-y+1/4,z+1/4",
        "-x+1/4,y+3/4,z+3/4",
        "-z+3/4,-x+3/4,-y+1/4",
        "-z+1/4,x+3/4,y+3/4",
        "z+3/4,x+1/4,-y+3/4",
        "z+1/4,-x+1/4,y+1/4",
        "-y+3/4,-z+3/4,-x+1/4",
        "y+1/4,-z+1/4,x+1/4",
        "-y+1/4,z+3/4,x+3/4",
        "y+3/4,z+1/4,-x+3/4",
        "-y,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z",
        "-y+1/2,x,-z+1/2",
        "y,-x,-z",
        "-x,-z+1/2,y+1/2",
        "x,-z,-y",
        "x+1/2,z+1/2,y",
        "-x+1/2,z,-y+1/2",
        "-z,-y+1/2,x+1/2",
        "-z+1/2,y,-x+1/2",
        "z,-y,-x",
        "z+1/2,y+1/2,x",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'F d d 2',
    setting_name    => 'F d d 2',
    full   => 'F d d 2',
    short  => 'Fdd2',
    number => 43,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/4,-y+1/4,z+1/4",
        "-x+1/4,y+1/4,z+1/4",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x+1/4,-y+3/4,z+3/4",
        "-x+1/4,y+3/4,z+3/4",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "x+3/4,-y+1/4,z+3/4",
        "-x+3/4,y+1/4,z+3/4",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "x+3/4,-y+3/4,z+1/4",
        "-x+3/4,y+3/4,z+1/4",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'F m m 2',
    setting_name    => 'F m m 2',
    full   => 'F m m 2',
    short  => 'Fmm2',
    number => 42,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z",
        "-x,y,z",
        "x,y+1/2,z+1/2",
        "-x,-y+1/2,z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
        "x+1/2,y,z+1/2",
        "-x+1/2,-y,z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y,z+1/2",
        "x+1/2,y+1/2,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'H -3',
    setting_name    => 'H -3',
    full   => 'H -3',
    short  => 'H-3',
    number => 148,
    nsymop => 18,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "-x+2/3,-y+1/3,-z+1/3",
        "y+2/3,-x+y+1/3,-z+1/3",
        "x-y+2/3,x+1/3,-z+1/3",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "-x+1/3,-y+2/3,-z+2/3",
        "y+1/3,-x+y+2/3,-z+2/3",
        "x-y+1/3,x+2/3,-z+2/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'H -3 2/c',
    setting_name    => 'H -3 2/c',
    full   => 'H -3 2/c',
    short  => 'H-3c',
    number => 167,
    nsymop => 36,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z+1/2",
        "x-y,-y,-z+1/2",
        "-x,-x+y,-z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "y+2/3,x+1/3,-z+5/6",
        "x-y+2/3,-y+1/3,-z+5/6",
        "-x+2/3,-x+y+1/3,-z+5/6",
        "-x+2/3,-y+1/3,-z+1/3",
        "y+2/3,-x+y+1/3,-z+1/3",
        "x-y+2/3,x+1/3,-z+1/3",
        "-y+2/3,-x+1/3,z+5/6",
        "-x+y+2/3,y+1/3,z+5/6",
        "x+2/3,x-y+1/3,z+5/6",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "y+1/3,x+2/3,-z+1/6",
        "x-y+1/3,-y+2/3,-z+1/6",
        "-x+1/3,-x+y+2/3,-z+1/6",
        "-x+1/3,-y+2/3,-z+2/3",
        "y+1/3,-x+y+2/3,-z+2/3",
        "x-y+1/3,x+2/3,-z+2/3",
        "-y+1/3,-x+2/3,z+1/6",
        "-x+y+1/3,y+2/3,z+1/6",
        "x+1/3,x-y+2/3,z+1/6",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'H -3 2/m',
    setting_name    => 'H -3 2/m',
    full   => 'H -3 2/m',
    short  => 'H-3m',
    number => 166,
    nsymop => 36,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "y+2/3,x+1/3,-z+1/3",
        "x-y+2/3,-y+1/3,-z+1/3",
        "-x+2/3,-x+y+1/3,-z+1/3",
        "-x+2/3,-y+1/3,-z+1/3",
        "y+2/3,-x+y+1/3,-z+1/3",
        "x-y+2/3,x+1/3,-z+1/3",
        "-y+2/3,-x+1/3,z+1/3",
        "-x+y+2/3,y+1/3,z+1/3",
        "x+2/3,x-y+1/3,z+1/3",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "y+1/3,x+2/3,-z+2/3",
        "x-y+1/3,-y+2/3,-z+2/3",
        "-x+1/3,-x+y+2/3,-z+2/3",
        "-x+1/3,-y+2/3,-z+2/3",
        "y+1/3,-x+y+2/3,-z+2/3",
        "x-y+1/3,x+2/3,-z+2/3",
        "-y+1/3,-x+2/3,z+2/3",
        "-x+y+1/3,y+2/3,z+2/3",
        "x+1/3,x-y+2/3,z+2/3",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'H 3',
    setting_name    => 'H 3',
    full   => 'H 3',
    short  => 'H3',
    number => 146,
    nsymop => 9,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
    ],
    nncsym => 3,
},

{
    spacegroup_name => 'H 3 2',
    setting_name    => 'H 3 2',
    full   => 'H 3 2',
    short  => 'H32',
    number => 155,
    nsymop => 18,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "y+2/3,x+1/3,-z+1/3",
        "x-y+2/3,-y+1/3,-z+1/3",
        "-x+2/3,-x+y+1/3,-z+1/3",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "y+1/3,x+2/3,-z+2/3",
        "x-y+1/3,-y+2/3,-z+2/3",
        "-x+1/3,-x+y+2/3,-z+2/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'H 3 c',
    setting_name    => 'H 3 c',
    full   => 'H 3 c',
    short  => 'H3c',
    number => 161,
    nsymop => 18,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "-y+2/3,-x+1/3,z+5/6",
        "-x+y+2/3,y+1/3,z+5/6",
        "x+2/3,x-y+1/3,z+5/6",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "-y+1/3,-x+2/3,z+1/6",
        "-x+y+1/3,y+2/3,z+1/6",
        "x+1/3,x-y+2/3,z+1/6",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'H 3 m',
    setting_name    => 'H 3 m',
    full   => 'H 3 m',
    short  => 'H3m',
    number => 160,
    nsymop => 18,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "x+2/3,y+1/3,z+1/3",
        "-y+2/3,x-y+1/3,z+1/3",
        "-x+y+2/3,-x+1/3,z+1/3",
        "-y+2/3,-x+1/3,z+1/3",
        "-x+y+2/3,y+1/3,z+1/3",
        "x+2/3,x-y+1/3,z+1/3",
        "x+1/3,y+2/3,z+2/3",
        "-y+1/3,x-y+2/3,z+2/3",
        "-x+y+1/3,-x+2/3,z+2/3",
        "-y+1/3,-x+2/3,z+2/3",
        "-x+y+1/3,y+2/3,z+2/3",
        "x+1/3,x-y+2/3,z+2/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'I -4',
    setting_name    => 'I -4',
    full   => 'I -4',
    short  => 'I-4',
    number => 82,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I -4 2 d',
    setting_name    => 'I -4 2 d',
    full   => 'I -4 2 d',
    short  => 'I-42d',
    number => 122,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x+1/2,y,-z+3/4",
        "x+1/2,-y,-z+3/4",
        "-y+1/2,-x,z+3/4",
        "y+1/2,x,z+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x,y+1/2,-z+1/4",
        "x,-y+1/2,-z+1/4",
        "-y,-x+1/2,z+1/4",
        "y,x+1/2,z+1/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I -4 2 m',
    setting_name    => 'I -4 2 m',
    full   => 'I -4 2 m',
    short  => 'I-42m',
    number => 121,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,y,-z",
        "x,-y,-z",
        "-y,-x,z",
        "y,x,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I -4 3 d',
    setting_name    => 'I -4 3 d',
    full   => 'I -4 3 d',
    short  => 'I-43d',
    number => 220,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "y+1/4,x+1/4,z+1/4",
        "-y+1/4,-x+3/4,z+3/4",
        "y+3/4,-x+1/4,-z+3/4",
        "-y+3/4,x+3/4,-z+1/4",
        "x+1/4,z+1/4,y+1/4",
        "-x+3/4,z+3/4,-y+1/4",
        "-x+1/4,-z+3/4,y+3/4",
        "x+3/4,-z+1/4,-y+3/4",
        "z+1/4,y+1/4,x+1/4",
        "z+3/4,-y+1/4,-x+3/4",
        "-z+3/4,y+3/4,-x+1/4",
        "-z+1/4,-y+3/4,x+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z,-x,-y+1/2",
        "-z,-x+1/2,y",
        "-z+1/2,x,-y",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z,-x",
        "y,-z,-x+1/2",
        "-y,-z+1/2,x",
        "y+3/4,x+3/4,z+3/4",
        "-y+3/4,-x+1/4,z+1/4",
        "y+1/4,-x+3/4,-z+1/4",
        "-y+1/4,x+1/4,-z+3/4",
        "x+3/4,z+3/4,y+3/4",
        "-x+1/4,z+1/4,-y+3/4",
        "-x+3/4,-z+1/4,y+1/4",
        "x+1/4,-z+3/4,-y+1/4",
        "z+3/4,y+3/4,x+3/4",
        "z+1/4,-y+3/4,-x+1/4",
        "-z+1/4,y+1/4,-x+3/4",
        "-z+3/4,-y+1/4,x+1/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I -4 3 m',
    setting_name    => 'I -4 3 m',
    full   => 'I -4 3 m',
    short  => 'I-43m',
    number => 217,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,z",
        "-y,-x,z",
        "y,-x,-z",
        "-y,x,-z",
        "x,z,y",
        "-x,z,-y",
        "-x,-z,y",
        "x,-z,-y",
        "z,y,x",
        "z,-y,-x",
        "-z,y,-x",
        "-z,-y,x",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x+1/2",
        "-y+1/2,-z+1/2,x+1/2",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "z+1/2,y+1/2,x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "-z+1/2,-y+1/2,x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I -4 c 2',
    setting_name    => 'I -4 c 2',
    full   => 'I -4 c 2',
    short  => 'I-4c2',
    number => 120,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I -4 m 2',
    setting_name    => 'I -4 m 2',
    full   => 'I -4 m 2',
    short  => 'I-4m2',
    number => 119,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "x,-y,z",
        "-x,y,z",
        "y,x,-z",
        "-y,-x,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 1 2 1',
    setting_name    => 'I 1 2 1',
    full   => 'I 1 2 1',
    short  => 'I2',
    number => 4005,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'I 1 21 1',
    setting_name    => 'I 1 21 1',
    full   => 'I 1 21 1',
    short  => 'I21',
    number => 3004,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y+1/2,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,y,-z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'I 2 2 2',
    setting_name    => 'I 2 2 2',
    full   => 'I 2 2 2',
    short  => 'I222',
    number => 23,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,-z",
        "-x,y,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I 2 2 2a',
    setting_name    => 'I 2 2 2a',
    full   => 'I 2 2 2a',
    short  => 'I222a',
    number => 1023,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y,-z",
        "-x,y+1/2,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x,-y+1/2,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I 2 3',
    setting_name    => 'I 2 3',
    full   => 'I 2 3',
    short  => 'I23',
    number => 197,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x+1/2",
        "-y+1/2,-z+1/2,x+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'I 2 3a',
    setting_name    => 'I 2 3a',
    full   => 'I 2 3a',
    short  => 'I23a',
    number => 1197,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y,-z",
        "-x,y+1/2,-z",
        "y,z,x",
        "-y+1/2,-z+1/2,x",
        "y+1/2,-z,-x",
        "-y,z+1/2,-x",
        "z,x,y",
        "-z+1/2,-x+1/2,y",
        "z+1/2,-x,-y",
        "-z,x+1/2,-y",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z+1/2",
        "x,-y+1/2,-z+1/2",
        "-x+1/2,y,-z+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y,-z,x+1/2",
        "y,-z+1/2,-x+1/2",
        "-y+1/2,z,-x+1/2",
        "z+1/2,x+1/2,y+1/2",
        "-z,-x,y+1/2",
        "z,-x+1/2,-y+1/2",
        "-z+1/2,x,-y+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'I 2/b 2/a 2/m',
    setting_name    => 'I 2/b 2/a 2/m',
    full   => 'I 2/b 2/a 2/m',
    short  => 'Ibam',
    number => 72,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 2/m -3',
    setting_name    => 'I 2/m -3',
    full   => 'I 2/m -3',
    short  => 'Im-3',
    number => 204,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x+1/2",
        "-y+1/2,-z+1/2,x+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,x+1/2,y+1/2",
        "z+1/2,x+1/2,-y+1/2",
        "z+1/2,-x+1/2,y+1/2",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x+1/2",
        "y+1/2,z+1/2,-x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I 2/m 2/m 2/m',
    setting_name    => 'I 2/m 2/m 2/m',
    full   => 'I 2/m 2/m 2/m',
    short  => 'Immm',
    number => 71,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 21 21 21',
    setting_name    => 'I 21 21 21',
    full   => 'I 21 21 21',
    short  => 'I212121',
    number => 24,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I 21 3',
    setting_name    => 'I 21 3',
    full   => 'I 21 3',
    short  => 'I213',
    number => 199,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z,-x,-y+1/2",
        "-z,-x+1/2,y",
        "-z+1/2,x,-y",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z,-x",
        "y,-z,-x+1/2",
        "-y,-z+1/2,x",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'I 21/a -3',
    setting_name    => 'I 21/a -3',
    full   => 'I 21/a -3',
    short  => 'Ia-3',
    number => 206,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
        "-z,-x,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z,-x",
        "y,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x",
        "y+1/2,z,-x+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z,-x,-y+1/2",
        "-z,-x+1/2,y",
        "-z+1/2,x,-y",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z,-x",
        "y,-z,-x+1/2",
        "-y,-z+1/2,x",
        "-x+1/2,-y+1/2,-z+1/2",
        "x,y+1/2,-z",
        "x+1/2,-y,z",
        "-x,y,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z,x,y+1/2",
        "z,x+1/2,-y",
        "z+1/2,-x,y",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z,x",
        "-y,z,x+1/2",
        "y,z+1/2,-x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I 21/b 21/c 21/a',
    setting_name    => 'I 21/b 21/c 21/a',
    full   => 'I 21/b 21/c 21/a',
    short  => 'Ibca',
    number => 73,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x,y+1/2,-z",
        "x+1/2,-y,z",
        "-x,y,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 21/m 21/m 21/a',
    setting_name    => 'I 21/m 21/m 21/a',
    full   => 'I 21/m 21/m 21/a',
    short  => 'Imma',
    number => 74,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z",
        "-x,y+1/2,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y+1/2,-z",
        "x,-y+1/2,z",
        "-x,y,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 4',
    setting_name    => 'I 4',
    full   => 'I 4',
    short  => 'I4',
    number => 79,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I 4 2 2',
    setting_name    => 'I 4 2 2',
    full   => 'I 4 2 2',
    short  => 'I422',
    number => 97,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 4 3 2',
    setting_name    => 'I 4 3 2',
    full   => 'I 4 3 2',
    short  => 'I432',
    number => 211,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x+1/2",
        "-y+1/2,-z+1/2,x+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I 4 c m',
    setting_name    => 'I 4 c m',
    full   => 'I 4 c m',
    short  => 'I4cm',
    number => 108,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 4 m m',
    setting_name    => 'I 4 m m',
    full   => 'I 4 m m',
    short  => 'I4mm',
    number => 107,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z",
        "y,x,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 4/m',
    setting_name    => 'I 4/m',
    full   => 'I 4/m',
    short  => 'I4/m',
    number => 87,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 4/m -3 2/m',
    setting_name    => 'I 4/m -3 2/m',
    full   => 'I 4/m -3 2/m',
    short  => 'Im-3m',
    number => 229,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "-y,-x,z",
        "y,x,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,-z,y",
        "x,-z,-y",
        "x,z,y",
        "-x,z,-y",
        "-z,-y,x",
        "-z,y,-x",
        "z,-y,-x",
        "z,y,x",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,-x+1/2,y+1/2",
        "-z+1/2,x+1/2,-y+1/2",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x+1/2",
        "-y+1/2,-z+1/2,x+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,x+1/2,y+1/2",
        "z+1/2,x+1/2,-y+1/2",
        "z+1/2,-x+1/2,y+1/2",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x+1/2",
        "y+1/2,z+1/2,-x+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "z+1/2,y+1/2,x+1/2",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'I 4/m 2/c 2/m',
    setting_name    => 'I 4/m 2/c 2/m',
    full   => 'I 4/m 2/c 2/m',
    short  => 'I4/mcm',
    number => 140,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'I 4/m 2/m 2/m',
    setting_name    => 'I 4/m 2/m 2/m',
    full   => 'I 4/m 2/m 2/m',
    short  => 'I4/mmm',
    number => 139,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z",
        "y,x,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'I 41',
    setting_name    => 'I 41',
    full   => 'I 41',
    short  => 'I41',
    number => 80,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I 41 2 2',
    setting_name    => 'I 41 2 2',
    full   => 'I 41 2 2',
    short  => 'I4122',
    number => 98,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "-x+1/2,y,-z+3/4",
        "x,-y+1/2,-z+1/4",
        "y+1/2,x+1/2,-z+1/2",
        "-y,-x,-z",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "-x,y+1/2,-z+1/4",
        "x+1/2,-y,-z+3/4",
        "y,x,-z",
        "-y+1/2,-x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 41 3 2',
    setting_name    => 'I 41 3 2',
    full   => 'I 41 3 2',
    short  => 'I4132',
    number => 214,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "y+3/4,x+1/4,-z+1/4",
        "-y+3/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+3/4",
        "-y+1/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+1/4",
        "-x+3/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+3/4",
        "z+3/4,y+1/4,-x+1/4",
        "z+1/4,-y+1/4,x+3/4",
        "-z+1/4,y+3/4,x+1/4",
        "-z+3/4,-y+3/4,-x+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z,-x,-y+1/2",
        "-z,-x+1/2,y",
        "-z+1/2,x,-y",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z,-x",
        "y,-z,-x+1/2",
        "-y,-z+1/2,x",
        "y+1/4,x+3/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+1/4,-x+1/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'I 41 c d',
    setting_name    => 'I 41 c d',
    full   => 'I 41 c d',
    short  => 'I41cd',
    number => 110,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "x,-y,z+1/2",
        "-x+1/2,y+1/2,z",
        "-y,-x+1/2,z+3/4",
        "y+1/2,x,z+1/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "x+1/2,-y+1/2,z",
        "-x,y,z+1/2",
        "-y+1/2,-x,z+1/4",
        "y,x+1/2,z+3/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 41 m d',
    setting_name    => 'I 41 m d',
    full   => 'I 41 m d',
    short  => 'I41md',
    number => 109,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "x,-y,z",
        "-x+1/2,y+1/2,z+1/2",
        "-y,-x+1/2,z+1/4",
        "y+1/2,x,z+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "x+1/2,-y+1/2,z+1/2",
        "-x,y,z",
        "-y+1/2,-x,z+3/4",
        "y,x+1/2,z+1/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 41/a',
    setting_name    => 'I 41/a',
    full   => 'I 41/a',
    short  => 'I41/a',
    number => 88,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "-x,-y+1/2,-z+1/4",
        "x+1/2,y,-z+3/4",
        "y,-x,-z",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "-x+1/2,-y,-z+3/4",
        "x,y+1/2,-z+1/4",
        "y+1/2,-x+1/2,-z+1/2",
        "-y,x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'I 41/a -3 2/d',
    setting_name    => 'I 41/a -3 2/d',
    full   => 'I 41/a -3 2/d',
    short  => 'Ia-3d',
    number => 230,
    nsymop => 96,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "y+3/4,x+1/4,-z+1/4",
        "-y+3/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+3/4",
        "-y+1/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+1/4",
        "-x+3/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+3/4",
        "z+3/4,y+1/4,-x+1/4",
        "z+1/4,-y+1/4,x+3/4",
        "-z+1/4,y+3/4,x+1/4",
        "-z+3/4,-y+3/4,-x+3/4",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
        "-z,-x,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z,-x",
        "y,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x",
        "y+1/2,z,-x+1/2",
        "-y+1/4,-x+3/4,z+3/4",
        "y+1/4,x+1/4,z+1/4",
        "-y+3/4,x+3/4,-z+1/4",
        "y+3/4,-x+1/4,-z+3/4",
        "-x+1/4,-z+3/4,y+3/4",
        "x+3/4,-z+1/4,-y+3/4",
        "x+1/4,z+1/4,y+1/4",
        "-x+3/4,z+3/4,-y+1/4",
        "-z+1/4,-y+3/4,x+3/4",
        "-z+3/4,y+3/4,-x+1/4",
        "z+3/4,-y+1/4,-x+3/4",
        "z+1/4,y+1/4,x+1/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y+1/2,z",
        "-x+1/2,y,-z",
        "x,-y,-z+1/2",
        "z+1/2,x+1/2,y+1/2",
        "z,-x,-y+1/2",
        "-z,-x+1/2,y",
        "-z+1/2,x,-y",
        "y+1/2,z+1/2,x+1/2",
        "-y+1/2,z,-x",
        "y,-z,-x+1/2",
        "-y,-z+1/2,x",
        "y+1/4,x+3/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+1/4,-x+1/4",
        "-x+1/2,-y+1/2,-z+1/2",
        "x,y+1/2,-z",
        "x+1/2,-y,z",
        "-x,y,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z,x,y+1/2",
        "z,x+1/2,-y",
        "z+1/2,-x,y",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z,x",
        "-y,z,x+1/2",
        "y,z+1/2,-x",
        "-y+3/4,-x+1/4,z+1/4",
        "y+3/4,x+3/4,z+3/4",
        "-y+1/4,x+1/4,-z+3/4",
        "y+1/4,-x+3/4,-z+1/4",
        "-x+3/4,-z+1/4,y+1/4",
        "x+1/4,-z+3/4,-y+1/4",
        "x+3/4,z+3/4,y+3/4",
        "-x+1/4,z+1/4,-y+3/4",
        "-z+3/4,-y+1/4,x+1/4",
        "-z+1/4,y+1/4,-x+3/4",
        "z+1/4,-y+3/4,-x+1/4",
        "z+3/4,y+3/4,x+3/4",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'I 41/a 2/c 2/d',
    setting_name    => 'I 41/a 2/c 2/d',
    full   => 'I 41/a 2/c 2/d',
    short  => 'I41/acd',
    number => 142,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "-x+1/2,y,-z+1/4",
        "x,-y+1/2,-z+3/4",
        "y+1/2,x+1/2,-z",
        "-y,-x,-z+1/2",
        "-x,-y+1/2,-z+1/4",
        "x+1/2,y,-z+3/4",
        "y,-x,-z",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z",
        "-x,y,z+1/2",
        "-y+1/2,-x,z+1/4",
        "y,x+1/2,z+3/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "-x,y+1/2,-z+3/4",
        "x+1/2,-y,-z+1/4",
        "y,x,-z+1/2",
        "-y+1/2,-x+1/2,-z",
        "-x+1/2,-y,-z+3/4",
        "x,y+1/2,-z+1/4",
        "y+1/2,-x+1/2,-z+1/2",
        "-y,x,-z",
        "x,-y,z+1/2",
        "-x+1/2,y+1/2,z",
        "-y,-x+1/2,z+3/4",
        "y+1/2,x,z+1/4",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'I 41/a 2/m 2/d',
    setting_name    => 'I 41/a 2/m 2/d',
    full   => 'I 41/a 2/m 2/d',
    short  => 'I41/amd',
    number => 141,
    nsymop => 32,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-y,x+1/2,z+1/4",
        "y+1/2,-x,z+3/4",
        "-x+1/2,y,-z+3/4",
        "x,-y+1/2,-z+1/4",
        "y+1/2,x+1/2,-z+1/2",
        "-y,-x,-z",
        "-x,-y+1/2,-z+1/4",
        "x+1/2,y,-z+3/4",
        "y,-x,-z",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x,y,z",
        "-y+1/2,-x,z+3/4",
        "y,x+1/2,z+1/4",
        "x+1/2,y+1/2,z+1/2",
        "-x,-y,z",
        "-y+1/2,x,z+3/4",
        "y,-x+1/2,z+1/4",
        "-x,y+1/2,-z+1/4",
        "x+1/2,-y,-z+3/4",
        "y,x,-z",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-y,-z+3/4",
        "x,y+1/2,-z+1/4",
        "y+1/2,-x+1/2,-z+1/2",
        "-y,x,-z",
        "x,-y,z",
        "-x+1/2,y+1/2,z+1/2",
        "-y,-x+1/2,z+1/4",
        "y+1/2,x,z+3/4",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'I b a 2',
    setting_name    => 'I b a 2',
    full   => 'I b a 2',
    short  => 'Iba2',
    number => 45,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I m a 2',
    setting_name    => 'I m a 2',
    full   => 'I m a 2',
    short  => 'Ima2',
    number => 46,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y,z",
        "-x+1/2,y,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'I m m 2',
    setting_name    => 'I m m 2',
    full   => 'I m m 2',
    short  => 'Imm2',
    number => 44,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z",
        "-x,y,z",
        "x+1/2,y+1/2,z+1/2",
        "-x+1/2,-y+1/2,z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P -1',
    setting_name    => 'P -1',
    full   => 'P -1',
    short  => 'P-1',
    number => 2,
    nsymop => 2,
    symops => [
        "x,y,z",
        "-x,-y,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P -3',
    setting_name    => 'P -3',
    full   => 'P -3',
    short  => 'P-3',
    number => 147,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P -3 1 2/c',
    setting_name    => 'P -3 1 2/c',
    full   => 'P -3 1 2/c',
    short  => 'P-31c',
    number => 163,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,-z+1/2",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -3 1 2/m',
    setting_name    => 'P -3 1 2/m',
    full   => 'P -3 1 2/m',
    short  => 'P-31m',
    number => 162,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -3 2/c 1',
    setting_name    => 'P -3 2/c 1',
    full   => 'P -3 2/c 1',
    short  => 'P-3c1',
    number => 165,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z+1/2",
        "x-y,-y,-z+1/2",
        "-x,-x+y,-z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -3 2/m 1',
    setting_name    => 'P -3 2/m 1',
    full   => 'P -3 2/m 1',
    short  => 'P-3m1',
    number => 164,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -4',
    setting_name    => 'P -4',
    full   => 'P -4',
    short  => 'P-4',
    number => 81,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "y,-x,-z",
        "-y,x,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P -4 2 c',
    setting_name    => 'P -4 2 c',
    full   => 'P -4 2 c',
    short  => 'P-42c',
    number => 112,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 2 m',
    setting_name    => 'P -4 2 m',
    full   => 'P -4 2 m',
    short  => 'P-42m',
    number => 111,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,y,-z",
        "x,-y,-z",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 21 c',
    setting_name    => 'P -4 21 c',
    full   => 'P -4 21 c',
    short  => 'P-421c',
    number => 114,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 21 m',
    setting_name    => 'P -4 21 m',
    full   => 'P -4 21 m',
    short  => 'P-421m',
    number => 113,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 3 m',
    setting_name    => 'P -4 3 m',
    full   => 'P -4 3 m',
    short  => 'P-43m',
    number => 215,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,z",
        "-y,-x,z",
        "y,-x,-z",
        "-y,x,-z",
        "x,z,y",
        "-x,z,-y",
        "-x,-z,y",
        "x,-z,-y",
        "z,y,x",
        "z,-y,-x",
        "-z,y,-x",
        "-z,-y,x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P -4 3 n',
    setting_name    => 'P -4 3 n',
    full   => 'P -4 3 n',
    short  => 'P-43n',
    number => 218,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "z+1/2,y+1/2,x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "-z+1/2,-y+1/2,x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P -4 b 2',
    setting_name    => 'P -4 b 2',
    full   => 'P -4 b 2',
    short  => 'P-4b2',
    number => 117,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 c 2',
    setting_name    => 'P -4 c 2',
    full   => 'P -4 c 2',
    short  => 'P-4c2',
    number => 116,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 m 2',
    setting_name    => 'P -4 m 2',
    full   => 'P -4 m 2',
    short  => 'P-4m2',
    number => 115,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z",
        "-x,y,z",
        "y,x,-z",
        "-y,-x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -4 n 2',
    setting_name    => 'P -4 n 2',
    full   => 'P -4 n 2',
    short  => 'P-4n2',
    number => 118,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,-z",
        "y,-x,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P -6',
    setting_name    => 'P -6',
    full   => 'P -6',
    short  => 'P-6',
    number => 174,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x,y,-z",
        "-y,x-y,-z",
        "-x+y,-x,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P -6 2 c',
    setting_name    => 'P -6 2 c',
    full   => 'P -6 2 c',
    short  => 'P-62c',
    number => 190,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x,y,-z+1/2",
        "-y,x-y,-z+1/2",
        "-x+y,-x,-z+1/2",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -6 2 m',
    setting_name    => 'P -6 2 m',
    full   => 'P -6 2 m',
    short  => 'P-62m',
    number => 189,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x,y,-z",
        "-y,x-y,-z",
        "-x+y,-x,-z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -6 c 2',
    setting_name    => 'P -6 c 2',
    full   => 'P -6 c 2',
    short  => 'P-6c2',
    number => 188,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x,y,-z+1/2",
        "-y,x-y,-z+1/2",
        "-x+y,-x,-z+1/2",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P -6 m 2',
    setting_name    => 'P -6 m 2',
    full   => 'P -6 m 2',
    short  => 'P-6m2',
    number => 187,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "x,y,-z",
        "-y,x-y,-z",
        "-x+y,-x,-z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 1',
    setting_name    => 'P 1',
    full   => 'P 1',
    short  => 'P1',
    number => 1,
    nsymop => 1,
    symops => [
        "x,y,z",
    ],
    nncsym => 1,
},

{
    spacegroup_name => 'P 1 1 2',
    setting_name    => 'P 1 1 2',
    full   => 'P 1 1 2',
    short  => 'P2',
    number => 1003,
    nsymop => 2,
    symops => [
        "x,y,z",
        "-x,-y,z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 1 2/b',
    setting_name    => 'P 1 1 2/b',
    full   => 'P 1 1 2/b',
    short  => 'P112/b',
    number => 1013,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y+1/2,z",
        "-x,-y,-z",
        "x,y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 1 2/m',
    setting_name    => 'P 1 1 2/m',
    full   => 'P 1 1 2/m',
    short  => 'P112/m',
    number => 1010,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,y,-z",
        "-x,-y,z",
        "-x,-y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 1 21',
    setting_name    => 'P 1 1 21',
    full   => 'P 1 1 21',
    short  => 'P1121',
    number => 1004,
    nsymop => 2,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 1 21/b',
    setting_name    => 'P 1 1 21/b',
    full   => 'P 1 1 21/b',
    short  => 'P1121/b',
    number => 1014,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,-z",
        "-x,-y+1/2,z+1/2",
        "x,y+1/2,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 1 21/m',
    setting_name    => 'P 1 1 21/m',
    full   => 'P 1 1 21/m',
    short  => 'P1121/m',
    number => 1011,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-x,-y,-z",
        "x,y,-z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 1 b',
    setting_name    => 'P 1 1 b',
    full   => 'P 1 1 b',
    short  => 'P11b',
    number => 1007,
    nsymop => 2,
    symops => [
        "x,y,z",
        "x,y+1/2,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 1 m',
    setting_name    => 'P 1 1 m',
    full   => 'P 1 1 m',
    short  => 'P11m',
    number => 1006,
    nsymop => 2,
    symops => [
        "x,y,z",
        "x,y,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 2 1',
    setting_name    => 'P 1 2 1',
    full   => 'P 1 2 1',
    short  => 'P2',
    number => 3,
    nsymop => 2,
    symops => [
        "x,y,z",
        "-x,y,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 2/c 1',
    setting_name    => 'P 1 2/c 1',
    full   => 'P 1 2/c 1',
    short  => 'P2/c',
    number => 13,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y,-z+1/2",
        "-x,-y,-z",
        "x,-y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 2/m 1',
    setting_name    => 'P 1 2/m 1',
    full   => 'P 1 2/m 1',
    short  => 'P2/m',
    number => 10,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,z",
        "-x,y,-z",
        "-x,-y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 21 1',
    setting_name    => 'P 1 21 1',
    full   => 'P 1 21 1',
    short  => 'P21',
    number => 4,
    nsymop => 2,
    symops => [
        "x,y,z",
        "-x,y+1/2,-z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 21/c 1',
    setting_name    => 'P 1 21/c 1',
    full   => 'P 1 21/c 1',
    short  => 'P21/c',
    number => 14,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,-z",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 21/m 1',
    setting_name    => 'P 1 21/m 1',
    full   => 'P 1 21/m 1',
    short  => 'P21/m',
    number => 11,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y+1/2,-z",
        "-x,-y,-z",
        "x,-y+1/2,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 1 c 1',
    setting_name    => 'P 1 c 1',
    full   => 'P 1 c 1',
    short  => 'Pc',
    number => 7,
    nsymop => 2,
    symops => [
        "x,y,z",
        "x,-y,z+1/2",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 1 m 1',
    setting_name    => 'P 1 m 1',
    full   => 'P 1 m 1',
    short  => 'Pm',
    number => 6,
    nsymop => 2,
    symops => [
        "x,y,z",
        "x,-y,z",
    ],
    nncsym => 2,
},

{
    spacegroup_name => 'P 2 2 2',
    setting_name    => 'P 2 2 2',
    full   => 'P 2 2 2',
    short  => 'P222',
    number => 16,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 2 2 21',
    setting_name    => 'P 2 2 21',
    full   => 'P 2 2 21',
    short  => 'P2221',
    number => 17,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 2 21 2',
    setting_name    => 'P 2 21 2',
    full   => 'P 2 21 2',
    short  => 'P2212',
    number => 2017,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y+1/2,-z",
        "-x,y+1/2,-z",
        "-x,-y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 2 21 21',
    setting_name    => 'P 2 21 21',
    full   => 'P 2 21 21',
    short  => 'P22121',
    number => 3018,
    nsymop => 4,
    symops => [
        "x,y,z",
        "x,-y,-z",
        "-x,y+1/2,-z+1/2",
        "-x,-y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 2 3',
    setting_name    => 'P 2 3',
    full   => 'P 2 3',
    short  => 'P23',
    number => 195,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 2/b 2/a 2/n',
    setting_name    => 'P 2/b 2/a 2/n',
    full   => 'P 2/b 2/a 2/n',
    short  => 'Pban',
    number => 50,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/b 21/c 21/m',
    setting_name    => 'P 2/b 21/c 21/m',
    full   => 'P 2/b 21/c 21/m',
    short  => 'Pbcm',
    number => 57,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x,-y+1/2,-z",
        "-x,-y,-z",
        "x,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/c 2/c 2/m',
    setting_name    => 'P 2/c 2/c 2/m',
    full   => 'P 2/c 2/c 2/m',
    short  => 'Pccm',
    number => 49,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/m -3',
    setting_name    => 'P 2/m -3',
    full   => 'P 2/m -3',
    short  => 'Pm-3',
    number => 200,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 2/m 2/m 2/m',
    setting_name    => 'P 2/m 2/m 2/m',
    full   => 'P 2/m 2/m 2/m',
    short  => 'Pmmm',
    number => 47,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/m 2/n 21/a',
    setting_name    => 'P 2/m 2/n 21/a',
    full   => 'P 2/m 2/n 21/a',
    short  => 'Pmna',
    number => 53,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x+1/2,y,-z+1/2",
        "x,-y,-z",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x+1/2,-y,z+1/2",
        "-x,y,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/n -3',
    setting_name    => 'P 2/n -3',
    full   => 'P 2/n -3',
    short  => 'Pn-3',
    number => 201,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,x+1/2,y+1/2",
        "z+1/2,x+1/2,-y+1/2",
        "z+1/2,-x+1/2,y+1/2",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x+1/2",
        "y+1/2,z+1/2,-x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 2/n 2/n 2/n',
    setting_name    => 'P 2/n 2/n 2/n',
    full   => 'P 2/n 2/n 2/n',
    short  => 'Pnnn',
    number => 48,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 2/n 21/n 2/a',
    setting_name    => 'P 2/n 21/n 2/a',
    full   => 'P 2/n 21/n 2/a',
    short  => 'Pnna',
    number => 52,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z",
        "-x+1/2,y+1/2,-z+1/2",
        "x,-y+1/2,-z+1/2",
        "-x,-y,-z",
        "x+1/2,y,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21 2 2',
    setting_name    => 'P 21 2 2',
    full   => 'P 21 2 2',
    short  => 'P2122',
    number => 1017,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y,-z",
        "x+1/2,-y,-z",
        "-x+1/2,-y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 21 2 21',
    setting_name    => 'P 21 2 21',
    full   => 'P 21 2 21',
    short  => 'P21221',
    number => 2018,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,y,-z",
        "x+1/2,-y,-z+1/2",
        "-x+1/2,-y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 21 21 2',
    setting_name    => 'P 21 21 2',
    full   => 'P 21 21 2',
    short  => 'P21212',
    number => 18,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 21 21 2 (a)',
    setting_name    => 'P 21 21 2 (a)',
    full   => 'P 21 21 2 (a)',
    short  => 'P21212a',
    number => 1018,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "x+1/2,-y,-z",
        "-x,y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 21 21 21',
    setting_name    => 'P 21 21 21',
    full   => 'P 21 21 21',
    short  => 'P212121',
    number => 19,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 21 3',
    setting_name    => 'P 21 3',
    full   => 'P 21 3',
    short  => 'P213',
    number => 198,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 21/a -3',
    setting_name    => 'P 21/a -3',
    full   => 'P 21/a -3',
    short  => 'Pa-3',
    number => 205,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
        "-z,-x,-y",
        "-z+1/2,x+1/2,y",
        "z+1/2,x,-y+1/2",
        "z,-x+1/2,y+1/2",
        "-y,-z,-x",
        "y,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x",
        "y+1/2,z,-x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 21/b 2/c 21/n',
    setting_name    => 'P 21/b 2/c 21/n',
    full   => 'P 21/b 2/c 21/n',
    short  => 'Pbcn',
    number => 60,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z+1/2",
        "-x,y,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x,-y,-z",
        "x+1/2,y+1/2,-z+1/2",
        "x,-y,z+1/2",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/b 21/a 2/m',
    setting_name    => 'P 21/b 21/a 2/m',
    full   => 'P 21/b 21/a 2/m',
    short  => 'Pbam',
    number => 55,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x,-y,-z",
        "x,y,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/b 21/c 21/a',
    setting_name    => 'P 21/b 21/c 21/a',
    full   => 'P 21/b 21/c 21/a',
    short  => 'Pbca',
    number => 61,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/c 2/c 2/a',
    setting_name    => 'P 21/c 2/c 2/a',
    full   => 'P 21/c 2/c 2/a',
    short  => 'Pcca',
    number => 54,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z",
        "-x,y,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "-x,-y,-z",
        "x+1/2,y,-z",
        "x,-y,z+1/2",
        "-x+1/2,y,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/c 21/c 2/n',
    setting_name    => 'P 21/c 21/c 2/n',
    full   => 'P 21/c 21/c 2/n',
    short  => 'Pccn',
    number => 56,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y,-z+1/2",
        "-x,-y,-z",
        "x+1/2,y+1/2,-z",
        "x,-y+1/2,z+1/2",
        "-x+1/2,y,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/m 2/m 2/a',
    setting_name    => 'P 21/m 2/m 2/a',
    full   => 'P 21/m 2/m 2/a',
    short  => 'Pmma',
    number => 51,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z",
        "-x,y,-z",
        "x+1/2,-y,-z",
        "-x,-y,-z",
        "x+1/2,y,-z",
        "x,-y,z",
        "-x+1/2,y,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/m 21/m 2/n',
    setting_name    => 'P 21/m 21/m 2/n',
    full   => 'P 21/m 21/m 2/n',
    short  => 'Pmmn',
    number => 59,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "x,-y,z",
        "-x,y,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/m 21/m 2/n a',
    setting_name    => 'P 21/m 21/m 2/n a',
    full   => 'P 21/m 21/m 2/n a',
    short  => 'Pmmn2',
    number => 1059,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "-x,y+1/2,-z",
        "x+1/2,-y,-z",
        "-x,-y,-z",
        "x+1/2,y+1/2,-z",
        "x,-y+1/2,z",
        "-x+1/2,y,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/n 21/m 21/a',
    setting_name    => 'P 21/n 21/m 21/a',
    full   => 'P 21/n 21/m 21/a',
    short  => 'Pnma',
    number => 62,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z",
        "x+1/2,-y+1/2,-z+1/2",
        "-x,-y,-z",
        "x+1/2,y,-z+1/2",
        "x,-y+1/2,z",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 21/n 21/n 2/m',
    setting_name    => 'P 21/n 21/n 2/m',
    full   => 'P 21/n 21/n 2/m',
    short  => 'Pnnm',
    number => 58,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 3',
    setting_name    => 'P 3',
    full   => 'P 3',
    short  => 'P3',
    number => 143,
    nsymop => 3,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
    ],
    nncsym => 3,
},

{
    spacegroup_name => 'P 3 1 2',
    setting_name    => 'P 3 1 2',
    full   => 'P 3 1 2',
    short  => 'P312',
    number => 149,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 3 1 c',
    setting_name    => 'P 3 1 c',
    full   => 'P 3 1 c',
    short  => 'P31c',
    number => 159,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 3 1 m',
    setting_name    => 'P 3 1 m',
    full   => 'P 3 1 m',
    short  => 'P31m',
    number => 157,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 3 2 1',
    setting_name    => 'P 3 2 1',
    full   => 'P 3 2 1',
    short  => 'P321',
    number => 150,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 3 c 1',
    setting_name    => 'P 3 c 1',
    full   => 'P 3 c 1',
    short  => 'P3c1',
    number => 158,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 3 m 1',
    setting_name    => 'P 3 m 1',
    full   => 'P 3 m 1',
    short  => 'P3m1',
    number => 156,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 31',
    setting_name    => 'P 31',
    full   => 'P 31',
    short  => 'P31',
    number => 144,
    nsymop => 3,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
    ],
    nncsym => 3,
},

{
    spacegroup_name => 'P 31 1 2',
    setting_name    => 'P 31 1 2',
    full   => 'P 31 1 2',
    short  => 'P3112',
    number => 151,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "-y,-x,-z+2/3",
        "-x+y,y,-z+1/3",
        "x,x-y,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 31 2 1',
    setting_name    => 'P 31 2 1',
    full   => 'P 31 2 1',
    short  => 'P3121',
    number => 152,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "y,x,-z",
        "x-y,-y,-z+2/3",
        "-x,-x+y,-z+1/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 32',
    setting_name    => 'P 32',
    full   => 'P 32',
    short  => 'P32',
    number => 145,
    nsymop => 3,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
    ],
    nncsym => 3,
},

{
    spacegroup_name => 'P 32 1 2',
    setting_name    => 'P 32 1 2',
    full   => 'P 32 1 2',
    short  => 'P3212',
    number => 153,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "-y,-x,-z+1/3",
        "-x+y,y,-z+2/3",
        "x,x-y,-z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 32 2 1',
    setting_name    => 'P 32 2 1',
    full   => 'P 32 2 1',
    short  => 'P3221',
    number => 154,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "y,x,-z",
        "x-y,-y,-z+1/3",
        "-x,-x+y,-z+2/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 4',
    setting_name    => 'P 4',
    full   => 'P 4',
    short  => 'P4',
    number => 75,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 4 2 2',
    setting_name    => 'P 4 2 2',
    full   => 'P 4 2 2',
    short  => 'P422',
    number => 89,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4 21 2',
    setting_name    => 'P 4 21 2',
    full   => 'P 4 21 2',
    short  => 'P4212',
    number => 90,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z",
        "y+1/2,-x+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y,x,-z",
        "-y,-x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4 3 2',
    setting_name    => 'P 4 3 2',
    full   => 'P 4 3 2',
    short  => 'P432',
    number => 207,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 4 b m',
    setting_name    => 'P 4 b m',
    full   => 'P 4 b m',
    short  => 'P4bm',
    number => 100,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4 c c',
    setting_name    => 'P 4 c c',
    full   => 'P 4 c c',
    short  => 'P4cc',
    number => 103,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4 m m',
    setting_name    => 'P 4 m m',
    full   => 'P 4 m m',
    short  => 'P4mm',
    number => 99,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4 n c',
    setting_name    => 'P 4 n c',
    full   => 'P 4 n c',
    short  => 'P4nc',
    number => 104,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4/m',
    setting_name    => 'P 4/m',
    full   => 'P 4/m',
    short  => 'P4/m',
    number => 83,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4/m -3 2/m',
    setting_name    => 'P 4/m -3 2/m',
    full   => 'P 4/m -3 2/m',
    short  => 'Pm-3m',
    number => 221,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "-y,-x,z",
        "y,x,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,-z,y",
        "x,-z,-y",
        "x,z,y",
        "-x,z,-y",
        "-z,-y,x",
        "-z,y,-x",
        "z,-y,-x",
        "z,y,x",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'P 4/m 2/c 2/c',
    setting_name    => 'P 4/m 2/c 2/c',
    full   => 'P 4/m 2/c 2/c',
    short  => 'P4/mcc',
    number => 124,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/m 2/m 2/m',
    setting_name    => 'P 4/m 2/m 2/m',
    full   => 'P 4/m 2/m 2/m',
    short  => 'P4/mmm',
    number => 123,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/m 21/b 2/m',
    setting_name    => 'P 4/m 21/b 2/m',
    full   => 'P 4/m 21/b 2/m',
    short  => 'P4/mbm',
    number => 127,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/m 21/n 2/c',
    setting_name    => 'P 4/m 21/n 2/c',
    full   => 'P 4/m 21/n 2/c',
    short  => 'P4/mnc',
    number => 128,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/n',
    setting_name    => 'P 4/n',
    full   => 'P 4/n',
    short  => 'P4/n',
    number => 85,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z",
        "y+1/2,-x+1/2,z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "y,-x,-z",
        "-y,x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 4/n -3 2/n',
    setting_name    => 'P 4/n -3 2/n',
    full   => 'P 4/n -3 2/n',
    short  => 'Pn-3n',
    number => 222,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y,x,-z",
        "-y,-x,-z",
        "y,-x,z",
        "-y,x,z",
        "x,z,-y",
        "-x,z,y",
        "-x,-z,-y",
        "x,-z,y",
        "z,y,-x",
        "z,-y,x",
        "-z,y,x",
        "-z,-y,-x",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,x+1/2,y+1/2",
        "z+1/2,x+1/2,-y+1/2",
        "z+1/2,-x+1/2,y+1/2",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x+1/2",
        "y+1/2,z+1/2,-x+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "z+1/2,y+1/2,x+1/2",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'P 4/n 2/b 2/m',
    setting_name    => 'P 4/n 2/b 2/m',
    full   => 'P 4/n 2/b 2/m',
    short  => 'P4/nbm',
    number => 125,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "y+1/2,-x+1/2,-z",
        "-y+1/2,x+1/2,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/n 2/c 2/c',
    setting_name    => 'P 4/n 2/c 2/c',
    full   => 'P 4/n 2/c 2/c',
    short  => 'P4/ncc',
    number => 130,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z",
        "y+1/2,-x+1/2,z",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/n 2/n 2/c',
    setting_name    => 'P 4/n 2/n 2/c',
    full   => 'P 4/n 2/n 2/c',
    short  => 'P4/nnc',
    number => 126,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z",
        "y,-x,z",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z",
        "-y,-x,-z",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 4/n 21/m 2/m',
    setting_name    => 'P 4/n 21/m 2/m',
    full   => 'P 4/n 21/m 2/m',
    short  => 'P4/nmm',
    number => 129,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z",
        "y+1/2,-x+1/2,z",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y,x,-z",
        "-y,-x,-z",
        "-x+1/2,-y+1/2,-z",
        "x+1/2,y+1/2,-z",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z",
        "-x,y,z",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 41',
    setting_name    => 'P 41',
    full   => 'P 41',
    short  => 'P41',
    number => 76,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y,x,z+1/4",
        "y,-x,z+3/4",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 41 2 2',
    setting_name    => 'P 41 2 2',
    full   => 'P 41 2 2',
    short  => 'P4122',
    number => 91,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y,x,z+1/4",
        "y,-x,z+3/4",
        "-x,y,-z",
        "x,-y,-z+1/2",
        "y,x,-z+3/4",
        "-y,-x,-z+1/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 41 21 2',
    setting_name    => 'P 41 21 2',
    full   => 'P 41 21 2',
    short  => 'P41212',
    number => 92,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y+1/2,x+1/2,z+1/4",
        "y+1/2,-x+1/2,z+3/4",
        "-x+1/2,y+1/2,-z+1/4",
        "x+1/2,-y+1/2,-z+3/4",
        "y,x,-z",
        "-y,-x,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 41 3 2',
    setting_name    => 'P 41 3 2',
    full   => 'P 41 3 2',
    short  => 'P4132',
    number => 213,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "y+3/4,x+1/4,-z+1/4",
        "-y+3/4,-x+3/4,-z+3/4",
        "y+1/4,-x+1/4,z+3/4",
        "-y+1/4,x+3/4,z+1/4",
        "x+3/4,z+1/4,-y+1/4",
        "-x+1/4,z+3/4,y+1/4",
        "-x+3/4,-z+3/4,-y+3/4",
        "x+1/4,-z+1/4,y+3/4",
        "z+3/4,y+1/4,-x+1/4",
        "z+1/4,-y+1/4,x+3/4",
        "-z+1/4,y+3/4,x+1/4",
        "-z+3/4,-y+3/4,-x+3/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 42',
    setting_name    => 'P 42',
    full   => 'P 42',
    short  => 'P42',
    number => 77,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 42 2 2',
    setting_name    => 'P 42 2 2',
    full   => 'P 42 2 2',
    short  => 'P4222',
    number => 93,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 21 2',
    setting_name    => 'P 42 21 2',
    full   => 'P 42 21 2',
    short  => 'P42212',
    number => 94,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y,x,-z",
        "-y,-x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 21 2a',
    setting_name    => 'P 42 21 2a',
    full   => 'P 42 21 2a',
    short  => 'P42212a',
    number => 1094,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x+1/2,-y+1/2,z",
        "-y,x+1/2,z+1/2",
        "y+1/2,-x,z+1/2",
        "-x,y+1/2,-z",
        "x+1/2,-y,-z",
        "y,x,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 3 2',
    setting_name    => 'P 42 3 2',
    full   => 'P 42 3 2',
    short  => 'P4232',
    number => 208,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 42 b c',
    setting_name    => 'P 42 b c',
    full   => 'P 42 b c',
    short  => 'P42bc',
    number => 106,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 c m',
    setting_name    => 'P 42 c m',
    full   => 'P 42 c m',
    short  => 'P42cm',
    number => 101,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 m c',
    setting_name    => 'P 42 m c',
    full   => 'P 42 m c',
    short  => 'P42mc',
    number => 105,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42 n m',
    setting_name    => 'P 42 n m',
    full   => 'P 42 n m',
    short  => 'P42nm',
    number => 102,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42/m',
    setting_name    => 'P 42/m',
    full   => 'P 42/m',
    short  => 'P42/m',
    number => 84,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z+1/2",
        "-y,x,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42/m -3 2/n',
    setting_name    => 'P 42/m -3 2/n',
    full   => 'P 42/m -3 2/n',
    short  => 'Pm-3n',
    number => 223,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "x,-y,z",
        "-x,y,z",
        "-z,-x,-y",
        "-z,x,y",
        "z,x,-y",
        "z,-x,y",
        "-y,-z,-x",
        "y,-z,x",
        "-y,z,x",
        "y,z,-x",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z+1/2,y+1/2",
        "x+1/2,-z+1/2,-y+1/2",
        "x+1/2,z+1/2,y+1/2",
        "-x+1/2,z+1/2,-y+1/2",
        "-z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,-x+1/2",
        "z+1/2,y+1/2,x+1/2",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'P 42/m 2/c 2/m',
    setting_name    => 'P 42/m 2/c 2/m',
    full   => 'P 42/m 2/c 2/m',
    short  => 'P42/mcm',
    number => 132,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "y,x,-z",
        "-y,-x,-z",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z+1/2",
        "-y,x,-z+1/2",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/m 2/m 2/c',
    setting_name    => 'P 42/m 2/m 2/c',
    full   => 'P 42/m 2/m 2/c',
    short  => 'P42/mmc',
    number => 131,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "-x,y,-z",
        "x,-y,-z",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z+1/2",
        "-y,x,-z+1/2",
        "x,-y,z",
        "-x,y,z",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/m 21/b 2/c',
    setting_name    => 'P 42/m 21/b 2/c',
    full   => 'P 42/m 21/b 2/c',
    short  => 'P42/mbc',
    number => 135,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y,x,z+1/2",
        "y,-x,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x,-y,-z",
        "x,y,-z",
        "y,-x,-z+1/2",
        "-y,x,-z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/m 21/n 2/m',
    setting_name    => 'P 42/m 21/n 2/m',
    full   => 'P 42/m 21/n 2/m',
    short  => 'P42/mnm',
    number => 136,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y,x,-z",
        "-y,-x,-z",
        "-x,-y,-z",
        "x,y,-z",
        "y+1/2,-x+1/2,-z+1/2",
        "-y+1/2,x+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/n',
    setting_name    => 'P 42/n',
    full   => 'P 42/n',
    short  => 'P42/n',
    number => 86,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y,-x,-z",
        "-y,x,-z",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 42/n -3 2/m',
    setting_name    => 'P 42/n -3 2/m',
    full   => 'P 42/n -3 2/m',
    short  => 'Pn-3m',
    number => 224,
    nsymop => 48,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-x,y,-z",
        "x,-y,-z",
        "z,x,y",
        "z,-x,-y",
        "-z,-x,y",
        "-z,x,-y",
        "y,z,x",
        "-y,z,-x",
        "y,-z,-x",
        "-y,-z,x",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,-y+1/2",
        "-x+1/2,z+1/2,y+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "x+1/2,-z+1/2,y+1/2",
        "z+1/2,y+1/2,-x+1/2",
        "z+1/2,-y+1/2,x+1/2",
        "-z+1/2,y+1/2,x+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-z+1/2,-x+1/2,-y+1/2",
        "-z+1/2,x+1/2,y+1/2",
        "z+1/2,x+1/2,-y+1/2",
        "z+1/2,-x+1/2,y+1/2",
        "-y+1/2,-z+1/2,-x+1/2",
        "y+1/2,-z+1/2,x+1/2",
        "-y+1/2,z+1/2,x+1/2",
        "y+1/2,z+1/2,-x+1/2",
        "-y,-x,z",
        "y,x,z",
        "-y,x,-z",
        "y,-x,-z",
        "-x,-z,y",
        "x,-z,-y",
        "x,z,y",
        "-x,z,-y",
        "-z,-y,x",
        "-z,y,-x",
        "z,-y,-x",
        "z,y,x",
    ],
    nncsym => 48,
},

{
    spacegroup_name => 'P 42/n 2/b 2/c',
    setting_name    => 'P 42/n 2/b 2/c',
    full   => 'P 42/n 2/b 2/c',
    short  => 'P42/nbc',
    number => 133,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x,y,-z+1/2",
        "x,-y,-z+1/2",
        "y+1/2,x+1/2,-z",
        "-y+1/2,-x+1/2,-z",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
        "-y,-x,z+1/2",
        "y,x,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/n 2/n 2/m',
    setting_name    => 'P 42/n 2/n 2/m',
    full   => 'P 42/n 2/n 2/m',
    short  => 'P42/nnm',
    number => 134,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x,y,-z",
        "x,-y,-z",
        "y+1/2,x+1/2,-z+1/2",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y,-x,-z",
        "-y,x,-z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
        "-y,-x,z",
        "y,x,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/n 21/c 2/m',
    setting_name    => 'P 42/n 21/c 2/m',
    full   => 'P 42/n 21/c 2/m',
    short  => 'P42/ncm',
    number => 138,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z",
        "x+1/2,-y+1/2,-z",
        "y,x,-z+1/2",
        "-y,-x,-z+1/2",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
        "-y+1/2,-x+1/2,z",
        "y+1/2,x+1/2,z",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 42/n 21/m 2/c',
    setting_name    => 'P 42/n 21/m 2/c',
    full   => 'P 42/n 21/m 2/c',
    short  => 'P42/nmc',
    number => 137,
    nsymop => 16,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "-y+1/2,x+1/2,z+1/2",
        "y+1/2,-x+1/2,z+1/2",
        "-x+1/2,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z+1/2",
        "y,x,-z",
        "-y,-x,-z",
        "-x+1/2,-y+1/2,-z+1/2",
        "x+1/2,y+1/2,-z+1/2",
        "y,-x,-z",
        "-y,x,-z",
        "x,-y,z",
        "-x,y,z",
        "-y+1/2,-x+1/2,z+1/2",
        "y+1/2,x+1/2,z+1/2",
    ],
    nncsym => 16,
},

{
    spacegroup_name => 'P 43',
    setting_name    => 'P 43',
    full   => 'P 43',
    short  => 'P43',
    number => 78,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y,x,z+3/4",
        "y,-x,z+1/4",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P 43 2 2',
    setting_name    => 'P 43 2 2',
    full   => 'P 43 2 2',
    short  => 'P4322',
    number => 95,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y,x,z+3/4",
        "y,-x,z+1/4",
        "-x,y,-z",
        "x,-y,-z+1/2",
        "y,x,-z+1/4",
        "-y,-x,-z+3/4",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 43 21 2',
    setting_name    => 'P 43 21 2',
    full   => 'P 43 21 2',
    short  => 'P43212',
    number => 96,
    nsymop => 8,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "-y+1/2,x+1/2,z+3/4",
        "y+1/2,-x+1/2,z+1/4",
        "-x+1/2,y+1/2,-z+3/4",
        "x+1/2,-y+1/2,-z+1/4",
        "y,x,-z",
        "-y,-x,-z+1/2",
    ],
    nncsym => 8,
},

{
    spacegroup_name => 'P 43 3 2',
    setting_name    => 'P 43 3 2',
    full   => 'P 43 3 2',
    short  => 'P4332',
    number => 212,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "-x,y+1/2,-z+1/2",
        "x+1/2,-y+1/2,-z",
        "z,x,y",
        "z+1/2,-x+1/2,-y",
        "-z+1/2,-x,y+1/2",
        "-z,x+1/2,-y+1/2",
        "y,z,x",
        "-y,z+1/2,-x+1/2",
        "y+1/2,-z+1/2,-x",
        "-y+1/2,-z,x+1/2",
        "y+1/4,x+3/4,-z+3/4",
        "-y+1/4,-x+1/4,-z+1/4",
        "y+3/4,-x+3/4,z+1/4",
        "-y+3/4,x+1/4,z+3/4",
        "x+1/4,z+3/4,-y+3/4",
        "-x+3/4,z+1/4,y+3/4",
        "-x+1/4,-z+1/4,-y+1/4",
        "x+3/4,-z+3/4,y+1/4",
        "z+1/4,y+3/4,-x+3/4",
        "z+3/4,-y+3/4,x+1/4",
        "-z+3/4,y+1/4,x+3/4",
        "-z+1/4,-y+1/4,-x+1/4",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 6',
    setting_name    => 'P 6',
    full   => 'P 6',
    short  => 'P6',
    number => 168,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 6 2 2',
    setting_name    => 'P 6 2 2',
    full   => 'P 6 2 2',
    short  => 'P622',
    number => 177,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 6 c c',
    setting_name    => 'P 6 c c',
    full   => 'P 6 c c',
    short  => 'P6cc',
    number => 184,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 6 m m',
    setting_name    => 'P 6 m m',
    full   => 'P 6 m m',
    short  => 'P6mm',
    number => 183,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 6/m',
    setting_name    => 'P 6/m',
    full   => 'P 6/m',
    short  => 'P6/m',
    number => 175,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z",
        "-y,x-y,-z",
        "-x+y,-x,-z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 6/m 2/c 2/c',
    setting_name    => 'P 6/m 2/c 2/c',
    full   => 'P 6/m 2/c 2/c',
    short  => 'P6/mcc',
    number => 192,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "y,x,-z+1/2",
        "x-y,-y,-z+1/2",
        "-x,-x+y,-z+1/2",
        "-y,-x,-z+1/2",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z",
        "-x+y,-x,-z",
        "-y,x-y,-z",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 6/m 2/m 2/m',
    setting_name    => 'P 6/m 2/m 2/m',
    full   => 'P 6/m 2/m 2/m',
    short  => 'P6/mmm',
    number => 191,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z",
        "y,-x+y,z",
        "x-y,x,z",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z",
        "-x+y,-x,-z",
        "-y,x-y,-z",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 61',
    setting_name    => 'P 61',
    full   => 'P 61',
    short  => 'P61',
    number => 169,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "-x,-y,z+1/2",
        "y,-x+y,z+5/6",
        "x-y,x,z+1/6",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 61 2 2',
    setting_name    => 'P 61 2 2',
    full   => 'P 61 2 2',
    short  => 'P6122',
    number => 178,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "-x,-y,z+1/2",
        "y,-x+y,z+5/6",
        "x-y,x,z+1/6",
        "y,x,-z+1/3",
        "x-y,-y,-z",
        "-x,-x+y,-z+2/3",
        "-y,-x,-z+5/6",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+1/6",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 62',
    setting_name    => 'P 62',
    full   => 'P 62',
    short  => 'P62',
    number => 171,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "-x,-y,z",
        "y,-x+y,z+2/3",
        "x-y,x,z+1/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 62 2 2',
    setting_name    => 'P 62 2 2',
    full   => 'P 62 2 2',
    short  => 'P6222',
    number => 180,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "-x,-y,z",
        "y,-x+y,z+2/3",
        "x-y,x,z+1/3",
        "y,x,-z+2/3",
        "x-y,-y,-z",
        "-x,-x+y,-z+1/3",
        "-y,-x,-z+2/3",
        "-x+y,y,-z",
        "x,x-y,-z+1/3",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 63',
    setting_name    => 'P 63',
    full   => 'P 63',
    short  => 'P63',
    number => 173,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 63 2 2',
    setting_name    => 'P 63 2 2',
    full   => 'P 63 2 2',
    short  => 'P6322',
    number => 182,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-y,-x,-z+1/2",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 63 c m',
    setting_name    => 'P 63 c m',
    full   => 'P 63 c m',
    short  => 'P63cm',
    number => 185,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 63 m c',
    setting_name    => 'P 63 m c',
    full   => 'P 63 m c',
    short  => 'P63mc',
    number => 186,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 63/m',
    setting_name    => 'P 63/m',
    full   => 'P 63/m',
    short  => 'P63/m',
    number => 176,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z+1/2",
        "-y,x-y,-z+1/2",
        "-x+y,-x,-z+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 63/m 2/c 2/m',
    setting_name    => 'P 63/m 2/c 2/m',
    full   => 'P 63/m 2/c 2/m',
    short  => 'P63/mcm',
    number => 193,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "y,x,-z+1/2",
        "x-y,-y,-z+1/2",
        "-x,-x+y,-z+1/2",
        "-y,-x,-z",
        "-x+y,y,-z",
        "x,x-y,-z",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z+1/2",
        "-x+y,-x,-z+1/2",
        "-y,x-y,-z+1/2",
        "-y,-x,z+1/2",
        "-x+y,y,z+1/2",
        "x,x-y,z+1/2",
        "y,x,z",
        "x-y,-y,z",
        "-x,-x+y,z",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 63/m 2/m 2/c',
    setting_name    => 'P 63/m 2/m 2/c',
    full   => 'P 63/m 2/m 2/c',
    short  => 'P63/mmc',
    number => 194,
    nsymop => 24,
    symops => [
        "x,y,z",
        "-y,x-y,z",
        "-x+y,-x,z",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/2",
        "x-y,x,z+1/2",
        "y,x,-z",
        "x-y,-y,-z",
        "-x,-x+y,-z",
        "-y,-x,-z+1/2",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+1/2",
        "-x,-y,-z",
        "y,-x+y,-z",
        "x-y,x,-z",
        "x,y,-z+1/2",
        "-x+y,-x,-z+1/2",
        "-y,x-y,-z+1/2",
        "-y,-x,z",
        "-x+y,y,z",
        "x,x-y,z",
        "y,x,z+1/2",
        "x-y,-y,z+1/2",
        "-x,-x+y,z+1/2",
    ],
    nncsym => 24,
},

{
    spacegroup_name => 'P 64',
    setting_name    => 'P 64',
    full   => 'P 64',
    short  => 'P64',
    number => 172,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "-x,-y,z",
        "y,-x+y,z+1/3",
        "x-y,x,z+2/3",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 64 2 2',
    setting_name    => 'P 64 2 2',
    full   => 'P 64 2 2',
    short  => 'P6422',
    number => 181,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z+1/3",
        "-x+y,-x,z+2/3",
        "-x,-y,z",
        "y,-x+y,z+1/3",
        "x-y,x,z+2/3",
        "y,x,-z+1/3",
        "x-y,-y,-z",
        "-x,-x+y,-z+2/3",
        "-y,-x,-z+1/3",
        "-x+y,y,-z",
        "x,x-y,-z+2/3",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P 65',
    setting_name    => 'P 65',
    full   => 'P 65',
    short  => 'P65',
    number => 170,
    nsymop => 6,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/6",
        "x-y,x,z+5/6",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'P 65 2 2',
    setting_name    => 'P 65 2 2',
    full   => 'P 65 2 2',
    short  => 'P6522',
    number => 179,
    nsymop => 12,
    symops => [
        "x,y,z",
        "-y,x-y,z+2/3",
        "-x+y,-x,z+1/3",
        "-x,-y,z+1/2",
        "y,-x+y,z+1/6",
        "x-y,x,z+5/6",
        "y,x,-z+2/3",
        "x-y,-y,-z",
        "-x,-x+y,-z+1/3",
        "-y,-x,-z+1/6",
        "-x+y,y,-z+1/2",
        "x,x-y,-z+5/6",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'P b a 2',
    setting_name    => 'P b a 2',
    full   => 'P b a 2',
    short  => 'Pba2',
    number => 32,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P c a 21',
    setting_name    => 'P c a 21',
    full   => 'P c a 21',
    short  => 'Pca21',
    number => 29,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "x+1/2,-y,z",
        "-x+1/2,y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P c c 2',
    setting_name    => 'P c c 2',
    full   => 'P c c 2',
    short  => 'Pcc2',
    number => 27,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z+1/2",
        "-x,y,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P m a 2',
    setting_name    => 'P m a 2',
    full   => 'P m a 2',
    short  => 'Pma2',
    number => 28,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y,z",
        "-x+1/2,y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P m c 21',
    setting_name    => 'P m c 21',
    full   => 'P m c 21',
    short  => 'Pmc21',
    number => 26,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "x,-y,z+1/2",
        "-x,y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P m m 2',
    setting_name    => 'P m m 2',
    full   => 'P m m 2',
    short  => 'Pmm2',
    number => 25,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y,z",
        "-x,y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P m n 21',
    setting_name    => 'P m n 21',
    full   => 'P m n 21',
    short  => 'Pmn21',
    number => 31,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x+1/2,-y,z+1/2",
        "x+1/2,-y,z+1/2",
        "-x,y,z",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P n a 21',
    setting_name    => 'P n a 21',
    full   => 'P n a 21',
    short  => 'Pna21',
    number => 33,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z+1/2",
        "x+1/2,-y+1/2,z",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P n c 2',
    setting_name    => 'P n c 2',
    full   => 'P n c 2',
    short  => 'Pnc2',
    number => 30,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x,-y+1/2,z+1/2",
        "-x,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'P n n 2',
    setting_name    => 'P n n 2',
    full   => 'P n n 2',
    short  => 'Pnn2',
    number => 34,
    nsymop => 4,
    symops => [
        "x,y,z",
        "-x,-y,z",
        "x+1/2,-y+1/2,z+1/2",
        "-x+1/2,y+1/2,z+1/2",
    ],
    nncsym => 4,
},

{
    spacegroup_name => 'R -3',
    setting_name    => 'R -3',
    full   => 'R -3',
    short  => 'R-3',
    number => 1148,
    nsymop => 6,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "-x,-y,-z",
        "-z,-x,-y",
        "-y,-z,-x",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'R -3 2/c',
    setting_name    => 'R -3 2/c',
    full   => 'R -3 2/c',
    short  => 'R-3c',
    number => 1167,
    nsymop => 12,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "-y+1/2,-x+1/2,-z+1/2",
        "-x+1/2,-z+1/2,-y+1/2",
        "-z+1/2,-y+1/2,-x+1/2",
        "-x,-y,-z",
        "-z,-x,-y",
        "-y,-z,-x",
        "y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,y+1/2",
        "z+1/2,y+1/2,x+1/2",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'R -3 2/m',
    setting_name    => 'R -3 2/m',
    full   => 'R -3 2/m',
    short  => 'R-3m',
    number => 1166,
    nsymop => 12,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "-y,-x,-z",
        "-x,-z,-y",
        "-z,-y,-x",
        "-x,-y,-z",
        "-z,-x,-y",
        "-y,-z,-x",
        "y,x,z",
        "x,z,y",
        "z,y,x",
    ],
    nncsym => 12,
},

{
    spacegroup_name => 'R 3',
    setting_name    => 'R 3',
    full   => 'R 3',
    short  => 'R3',
    number => 1146,
    nsymop => 3,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
    ],
    nncsym => 3,
},

{
    spacegroup_name => 'R 3 2',
    setting_name    => 'R 3 2',
    full   => 'R 3 2',
    short  => 'R32',
    number => 1155,
    nsymop => 6,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "-y,-x,-z",
        "-x,-z,-y",
        "-z,-y,-x",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'R 3 c',
    setting_name    => 'R 3 c',
    full   => 'R 3 c',
    short  => 'R3c',
    number => 1161,
    nsymop => 6,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "y+1/2,x+1/2,z+1/2",
        "x+1/2,z+1/2,y+1/2",
        "z+1/2,y+1/2,x+1/2",
    ],
    nncsym => 6,
},

{
    spacegroup_name => 'R 3 m',
    setting_name    => 'R 3 m',
    full   => 'R 3 m',
    short  => 'R3m',
    number => 1160,
    nsymop => 6,
    symops => [
        "x,y,z",
        "z,x,y",
        "y,z,x",
        "y,x,z",
        "x,z,y",
        "z,y,x",
    ],
    nncsym => 6,
},

);

1;
