//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_46.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot46(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[46] = {1.333742891059480e-02,1.200599470082749e-01,3.336282758938885e-01,6.542897860813291e-01,1.082417508278657e+00,
    1.618512537546250e+00,2.263207296941506e+00,3.017269712589601e+00,3.881608367893986e+00,4.857278722422409e+00,5.945490501488364e+00,7.147616386343818e+00,
    8.465202163133917e+00,9.899978522507352e+00,1.145387474250570e+01,1.312903453698342e+01,1.492783441280015e+01,1.685290495462581e+01,1.890715555067650e+01,
    2.109380319177515e+01,2.341640612750172e+01,2.587890335735440e+01,2.848566118623576e+01,3.124152840233684e+01,3.415190207003891e+01,3.722280651143067e+01,
    4.046098883645525e+01,4.387403546057887e+01,4.747051555078885e+01,5.126015946537328e+01,5.525408331208722e+01,5.946507524110557e+01,6.390796583001595e+01,
    6.860011528488650e+01,7.356206657197211e+01,7.881844033999124e+01,8.439919275006795e+01,9.034143722433798e+01,9.669217939657422e+01,1.035126067611858e+02,
    1.108851944593616e+02,1.189263319546920e+02,1.278109698542234e+02,1.378275830301891e+02,1.495289391604307e+02,1.643404073143761e+02};
  constexpr double aw[46] = {2.279208832278825e-01,2.049087117733847e-01,1.655998150159143e-01,1.202750893159248e-01,7.847783981190361e-02,
    4.597881388935413e-02,2.417325210411894e-02,1.139587780743454e-02,4.812868705752729e-03,1.819066584203055e-03,6.145537269722041e-04,1.853300723976886e-04,
    4.981271596855133e-05,1.191232924731862e-05,2.529785014232799e-06,4.760767641836890e-07,7.920499353876436e-08,1.161921427862696e-08,1.498635556105118e-09,
    1.694043339299303e-10,1.672359378492024e-11,1.436200372305090e-12,1.068318855139839e-13,6.850149207931225e-15,3.766082836004507e-16,1.764731333396296e-17,
    7.001068361030809e-19,2.333916032868272e-20,6.482735757989675e-22,1.485946572151995e-23,2.780009179112892e-25,4.191780259187148e-27,5.019934094427782e-29,
    4.693558872978239e-31,3.357458184827123e-33,1.793428827734612e-35,6.945640108299903e-38,1.880361280468476e-40,3.397961343485392e-43,3.859958997823809e-46,
    2.542588333949454e-49,8.668622708166449e-53,1.290263073673895e-56,6.340884055269682e-61,6.048791108598756e-66,2.904278079328870e-72};
  constexpr double x[17664] = {  5.705182832704843e-04, -3.066437463823634e-06,  1.235761423175758e-08, -4.425079825682941e-11,  1.484812794039761e-13,
 -4.780219096985130e-16,  1.495199630210889e-18, -4.577887614442449e-21,  1.378529182398367e-23, -4.095941278555837e-26,  1.203543648685720e-28, -3.503097643747352e-31,
  5.130841769398552e-03, -2.751516255050964e-05,  1.103834798137374e-07, -3.922805149740949e-10,  1.301301058186833e-12, -4.122278214513941e-15,  1.261597970564376e-17,
 -3.754186402175555e-20,  1.090107234024180e-22, -3.094274851809046e-25,  8.590048244140987e-28, -2.330777303554375e-30,  1.423111773354266e-02, -7.597275831845512e-05,
  3.020190814805636e-07, -1.056961364923673e-09,  3.424899841424359e-12, -1.048859884585812e-14,  3.062412805780800e-17, -8.545790443158907e-20,  2.273919584826314e-22,
 -5.725152751848973e-25,  1.341532573627925e-27, -2.821675587725058e-30,  2.783068644893137e-02, -1.475672174979454e-04,  5.786104442487351e-07, -1.977884680841973e-09,
  6.177607271429534e-12, -1.790536864624886e-14,  4.819472905217628e-17, -1.190119528395816e-19,  2.606816874017183e-22, -4.601797423391376e-25,  4.014991719329042e-28,
  1.517393713425025e-30,  4.586876386334320e-02, -2.410096568688275e-04,  9.276153787090661e-07, -3.070142021909327e-09,  9.100392013011585e-12, -2.426785435008636e-14,
  5.692331392494867e-17, -1.088472392793461e-19,  1.210883578644272e-22,  2.344397653719447e-25, -2.210207134133794e-27,  9.702158245187923e-30,  6.826468772276682e-02,
 -3.546169189425205e-04,  1.333110841441397e-06, -4.230715349801464e-09,  1.167416048544639e-11, -2.744429777430902e-14,  4.972512546988271e-17, -3.770064243988321e-20,
 -2.057658111987589e-22,  1.358664987374845e-24, -5.245590173611598e-27,  1.541017243024571e-29,  9.491824486079774e-02, -4.863411268247618e-04,  1.776438230259359e-06,
 -5.346271986969580e-09,  1.338551561920180e-11, -2.570222881873941e-14,  2.303688737771528e-17,  9.066066444102781e-20, -6.356553961611589e-22,  2.388159300284024e-24,
 -6.397306894376339e-27,  1.078026487879053e-29,  1.257100788920329e-01, -6.338057048398840e-04,  2.236961377655817e-06, -6.301807478401867e-09,  1.379338726446489e-11,
 -1.808091959542543e-14, -2.173289644393331e-17,  2.489333860228865e-19, -1.002378288309961e-21,  2.633139361456022e-24, -3.647206624273319e-27, -7.024866920600729e-30,
  1.605021773433605e-01, -7.943472684789634e-04,  2.692907504512211e-06, -6.989516182634502e-09,  1.258876844246412e-11, -4.643532862265349e-15, -7.790027454676535e-17,
  3.915630210307241e-19, -1.114028548003292e-21,  1.585750305451551e-24,  3.195402888631568e-27, -3.117536680519788e-29,  1.991384370437455e-01, -9.650626866420889e-04,
  3.122258009749321e-06, -7.317249218951636e-09,  9.640480840184928e-12,  1.343880171807212e-14, -1.344904207454240e-16,  4.668121184200359e-19, -8.303567153613547e-22,
 -7.511831970125436e-25,  1.172897087405506e-26, -4.665345954923193e-29,  2.414453063694516e-01, -1.142860528528120e-03,  3.503653835968835e-06, -7.215944005632753e-09,
  5.021380611746547e-12,  3.399188763643626e-14, -1.783584421877680e-16,  4.324292963884488e-19, -1.323897910718277e-22, -3.725694656739500e-24,  1.761930974942717e-26,
 -3.839442910410614e-29,  2.872325027063903e-01, -1.324516028351702e-03,  3.817279358552465e-06, -6.645477716360734e-09, -9.884541563954623e-13,  5.412240621176964e-14,
 -1.970253168206269e-16,  2.704058982216320e-19,  8.443964451468001e-22, -6.189884432391689e-24,  1.659052590538079e-26, -1.923449012203432e-30,  3.362938032434423e-01,
 -1.506728634706030e-03,  4.045689340891357e-06, -5.598504252819455e-09, -7.922467745721162e-12,  7.064106982798344e-14, -1.816238593634374e-16, -3.750774925481077e-21,
  1.830954557221748e-21, -6.919894861528546e-24,  6.859299187856579e-27,  5.030647067561301e-29,  3.884079069494445e-01, -1.686181159090705e-03,  4.174545476045097e-06,
 -4.101973737247806e-09, -1.517053215524082e-11,  8.056101247427878e-14, -1.292940828675324e-16, -3.405098944578023e-19,  2.498550496309814e-21, -5.149362568979018e-24,
 -9.275539344653807e-27,  9.212652321178668e-29,  4.433393653116413e-01, -1.859599500995991e-03,  4.193232338704053e-06, -2.216195717388285e-09, -2.203971481510446e-11,
  8.159308449648382e-14, -4.445656256239025e-17, -6.655338613729030e-19,  2.564841880079166e-21, -9.914023043529904e-25, -2.571228082503402e-26,  9.637165671729634e-29,
  5.008395791247034e-01, -2.023811905922579e-03,  4.095327093962395e-06, -3.148118042434433e-11, -2.782652067745328e-11,  7.255765132200546e-14,  6.138851178778417e-17,
 -8.968414555892167e-19,  1.897605154858814e-21,  4.453244939811527e-24, -3.486036652048947e-26,  5.095313826570031e-29,  5.606478583172160e-01, -2.175806708575853e-03,
  3.878902896238497e-06,  2.337427969594556e-09, -3.189280892649234e-11,  5.364333264431307e-14,  1.713837081407731e-16, -9.657547442043104e-19,  5.792595866748298e-22,
  9.389417512036347e-24, -3.110112045902602e-26, -3.099125061600784e-29,  6.224925414875438e-01, -2.312787526748285e-03,  3.546652364081631e-06,  4.758772353785644e-09,
 -3.373701858162066e-11,  2.646541931978439e-14,  2.662777111256693e-16, -8.361299996699672e-19, -1.093989120896478e-21,  1.194555228915591e-23, -1.379785604271471e-26,
 -1.139272783531613e-28,  6.860921714943659e-01, -2.432224902397101e-03,  3.105824598153382e-06,  7.092525090041577e-09, -3.305269487747874e-11, -6.092834667387807e-15,
  3.280698502798232e-16, -5.165099938394962e-19, -2.683904584234058e-21,  1.089443805114728e-23,  1.170061450011475e-26, -1.559755019541768e-28,  7.511567231105372e-01,
 -2.531903435178152e-03,  2.567976653743620e-06,  9.199869438794178e-09, -2.976756626461729e-11, -4.023891355211517e-14,  3.436069218812675e-16, -6.147355634780958e-20,
 -3.734456845143044e-21,  6.191824112126189e-24,  3.577968440865511e-26, -1.306630966082113e-28,  8.173888784044218e-01, -2.609963519967146e-03,  1.948547898035459e-06,
  1.095273500437844e-08, -2.405845627253940e-11, -7.178054379981881e-14,  3.073847388895004e-16,  4.387960689705529e-19, -3.911106620070119e-21, -8.994940335023362e-25,
  4.844319669461760e-26, -4.272633509577109e-29,  8.844853451630291e-01, -2.664936883137291e-03,  1.266272977455181e-06,  1.224271037048349e-08, -1.633991216767768e-11,
 -9.671179913748120e-14,  2.229471455288455e-16,  8.785692539291984e-19, -3.110468441526443e-21, -8.179632279889236e-24,  4.370414514157418e-26,  7.140161175870833e-29,
  9.521382133193262e-01, -2.695775211698499e-03,  5.424558938199895e-07,  1.298868608979922e-08, -7.227312621640804e-12, -1.117878033201580e-13,  1.025489695291530e-16,
  1.161432082925269e-18, -1.503280753041376e-21, -1.326041893123818e-23,  2.246292138816036e-26,  1.599143294277107e-28,  1.020036343995572e+00, -2.701871283636787e-03,
 -1.998663460261057e-07,  1.314266532647153e-08,  2.521938932173803e-12, -1.149998901182573e-13, -3.489857353486385e-17,  1.223680448651662e-18,  5.059503346646562e-22,
 -1.442036976555371e-23, -7.544792719233416e-27,  1.810015032760185e-28,  1.087866785429552e+00, -2.683072135386615e-03, -9.368371451259744e-07,  1.269330498931275e-08,
  1.208304110208506e-11, -1.058769174885138e-13, -1.672246707817351e-16,  1.050178329579274e-18,  2.392500960421986e-21, -1.123986497036461e-23, -3.483275888991368e-26,
  1.241002562193561e-28,  1.155316209715696e+00, -2.639683941454488e-03, -1.644733830657028e-06,  1.166690952499113e-08,  2.064630448750133e-11, -8.556430755588522e-14,
 -2.730772642859281e-16,  6.784594273420053e-19,  3.663865513031612e-21, -4.767233647244826e-24, -4.896782328185914e-26,  1.560422034090720e-29,  1.222072363973226e+00,
 -2.572468429598710e-03, -2.300922171600539e-06,  1.012578162074021e-08,  2.749862999692966e-11, -5.666637032094329e-14, -3.358712259659180e-16,  1.898731128354688e-19,
  4.003468717940170e-21,  2.854546749784166e-24, -4.494893159536661e-26, -9.424362866998162e-29,  1.287825529253942e+00, -2.482630810167591e-03, -2.884772268152087e-06,
  8.164025913724605e-09,  3.209505452704359e-11, -2.287424506795905e-14, -3.468125402282945e-16, -3.100327436318994e-19,  3.360351272485655e-21,  9.160539565084422e-24,
 -2.519105499792346e-26, -1.564311905732948e-28,  1.352269980228639e+00, -2.371799357447641e-03, -3.378497299075048e-06,  5.901089405266238e-09,  3.411248375585338e-11,
  1.156452175036092e-14, -3.063904574552534e-16, -7.168614517308271e-19,  1.956899804781481e-21,  1.223985562063852e-23,  1.749235919261986e-27, -1.469729752600191e-28,
  1.415105438449134e+00, -2.241996941188179e-03, -3.767879374702251e-06,  3.473491604893904e-09,  3.347965945558908e-11,  4.245363806824508e-14, -2.240454853846093e-16,
 -9.519191729919351e-19,  2.133895608330950e-22,  1.138121725232899e-23,  2.505767821498089e-26, -7.706964733748243e-29,  1.476038511778367e+00, -2.095604964688321e-03,
 -4.042851067314704e-06,  1.025335496765664e-09,  3.038003635872062e-11,  6.623950032111367e-14, -1.161004103889634e-16, -9.796981099751673e-19, -1.384886964411375e-21,
  7.250462818164067e-24,  3.632076390382142e-26,  1.505364134279078e-29,  1.534784112419730e+00, -1.935320318682134e-03, -4.197906925769632e-06, -1.301713696481636e-09,
  2.522727899698519e-11,  8.049551141089512e-14, -2.402802398272103e-18, -8.139749704625153e-19, -2.433996797808185e-21,  1.552105351050159e-24,  3.283241530108925e-26,
  8.530643883262942e-29,  1.591066845864419e+00, -1.764106104421562e-03, -4.232326209839387e-06, -3.378249252741491e-09,  1.861618676697546e-11,  8.422562719722545e-14,
  9.760779671588370e-17, -5.113158626710580e-19, -2.724190751869108e-21, -3.668731459625354e-24,  1.814788942630137e-26,  1.058989589060597e-28,  1.644622363017568e+00,
 -1.585137011554664e-03, -4.150195925121090e-06, -5.096019248807875e-09,  1.125465677942377e-11,  7.794267174419729e-14,  1.685844922112288e-16, -1.541720608374952e-19,
 -2.284843416388816e-21, -6.793320663056813e-24, -1.563201595489510e-28,  7.681865326138240e-29,  1.695198667765345e+00, -1.401740353468982e-03, -3.960231676422975e-06,
 -6.375237949972866e-09,  3.884468348797621e-12,  6.351340460637696e-14,  2.019542549264752e-16,  1.715181128339801e-19, -1.351120898998556e-21, -7.163695672623719e-24,
 -1.425038636679182e-26,  2.166797164761870e-29,  1.742557372311045e+00, -1.217333861763832e-03, -3.675402525782829e-06, -7.169766043223294e-09, -2.800041786572667e-12,
  4.380003447615502e-14,  1.970720416625831e-16,  3.979955414308670e-19, -2.686128819872764e-22, -5.195601024075009e-24, -1.946360886548330e-26, -2.809862657975043e-29,
  1.786474892743653e+00, -1.035361419770253e-03, -3.312374560533409e-06, -7.469770448690311e-09, -8.226109179122843e-12,  2.216059621792545e-14,  1.606669235060251e-16,
  4.908470738639358e-19,  6.278760567393551e-22, -2.065508923518382e-24, -1.579818486105100e-26, -5.056128248062914e-29,  1.826743577514031e+00, -8.592279702627816e-04,
 -2.890795864308466e-06, -7.301662725190273e-09, -1.200102519585398e-11,  1.892865089667464e-15,  1.047764169571286e-16,  4.539695425880203e-19,  1.118684531986192e-21,
  8.582988449928748e-25, -7.069408205980806e-27, -4.265994780344852e-29,  1.863172761794383e+00, -6.922348628391107e-04, -2.432452672115682e-06, -6.725320548882693e-09,
 -1.394837394083697e-11, -1.428548352117650e-14,  4.369181176171336e-17,  3.236733985993423e-19,  1.152898261276498e-21,  2.579731929971611e-24,  1.593217157308140e-27,
 -1.758447496040492e-29,  1.895589741117367e+00, -5.375169104426174e-04, -1.960332345104521e-06, -5.828803681325532e-09, -1.411805870769631e-11, -2.463531968583324e-14,
 -9.359825089246729e-18,  1.543921330885005e-19,  8.376274787688104e-22,  2.800399270772659e-24,  6.424822175327278e-27,  6.260537208869565e-30,  1.923840658330750e+00,
 -3.979824009516227e-04, -1.497633135798780e-06, -4.720968173582778e-09, -1.276926770289062e-11, -2.860983698442491e-14, -4.503692768695003e-17,  7.521831014597641e-22,
  3.734212823536850e-22,  1.899397497996825e-24,  6.519384523172866e-27,  1.682129541360438e-29,  1.947791299122580e+00, -2.762572566432525e-04, -1.066763304206524e-06,
 -3.522545089263979e-09, -1.032874964457304e-11, -2.685285041754758e-14, -5.958807131565614e-17, -9.844161963029072e-20, -3.494486448897901e-23,  6.233290485978543e-25,
  3.569268680748548e-27,  1.354805506624191e-29,  1.967327794757240e+00, -1.746344436318409e-04, -6.883728134610624e-07, -2.356369637156382e-09, -7.329711100711110e-12,
 -2.098827636961112e-14, -5.510028264451347e-17, -1.296370422965583e-19, -2.562984049013944e-22, -3.333079416489941e-25,  2.897820441760080e-28,  4.293395547293783e-30,
  1.982357245155089e+00, -9.502955772725873e-05, -3.804593273752902e-07, -1.337512794255129e-09, -4.338950587929497e-12, -1.324348407613120e-14, -3.830486886814194e-17,
 -1.049775499804834e-19, -2.707525256033679e-22, -6.462835032632859e-25, -1.374239263025467e-27, -2.339020701360280e-30,  1.992808374614793e+00, -3.894285445916200e-05,
 -1.575849551017855e-07, -5.640686571193761e-10, -1.881207721349589e-12, -5.977496642709585e-15, -1.829766324018864e-17, -5.427025492675341e-20, -1.563837266326765e-22,
 -4.380725665310112e-25, -1.191507961546711e-27, -3.136426262426866e-30,  1.998633733539573e+00, -7.420234488067560e-06, -3.020427656403402e-08, -1.091878947628888e-10,
 -3.696242534738445e-13, -1.199571040745707e-15, -3.778878828005836e-18, -1.163980557246952e-20, -3.521926704979603e-23, -1.050017268588791e-25, -3.091026735148618e-28,
 -8.997585706655075e-31,  5.584469482567830e-04, -2.969660915516661e-06,  1.184054955980269e-08, -4.194967425340229e-11,  1.392695584286339e-13, -4.436267711828520e-16,
  1.372979369193726e-18, -4.159451077769618e-21,  1.239381963313813e-23, -3.643974638077097e-26,  1.059573710131567e-28, -3.052015111170611e-31,  5.022517933125464e-03,
 -2.665057638355701e-05,  1.057983701621608e-07, -3.721031617561626e-10,  1.221800178440906e-12, -3.831724645689971e-15,  1.161201583848431e-17, -3.422531508496362e-20,
  9.846587423727267e-23, -2.770340822629703e-25,  7.626838765387053e-28, -2.053548318426111e-30,  1.393197997097315e-02, -7.360642392657254e-05,  2.896575401794903e-07,
 -1.003802008419576e-09,  3.222288006730128e-12, -9.781530058850328e-15,  2.833015232980690e-17, -7.850101271924125e-20,  2.077180065907698e-22, -5.212695906664765e-25,
  1.222401118264522e-27, -2.595232330240114e-30,  2.724952736363821e-02, -1.430316189128695e-04,  5.554572613525780e-07, -1.881846093785623e-09,  5.830801521443783e-12,
 -1.678775573370964e-14,  4.497671208507726e-17, -1.109319814589169e-19,  2.444189887640102e-22, -4.429363674532490e-25,  4.571130979933556e-28,  1.028745946308329e-30,
  4.491933719765258e-02, -2.337336617595756e-04,  8.916315329274455e-07, -2.928345406649948e-09,  8.628451949648418e-12, -2.293782242424007e-14,  5.393099065073189e-17,
 -1.048536293393265e-19,  1.280356292355859e-22,  1.541229802644249e-25, -1.816289021058532e-27,  8.238535055394605e-30,  6.686723271450092e-02, -3.441519724720234e-04,
  1.283445072441123e-06, -4.048255399846182e-09,  1.113711939627956e-11, -2.626426244894409e-14,  4.858439631758230e-17, -4.354175546739333e-20, -1.604716000899419e-22,
  1.161930092893676e-24, -4.602656182711575e-27,  1.383118378325658e-29,  9.300090213729344e-02, -4.723826400459118e-04,  1.713551112012862e-06, -5.136185230835679e-09,
  1.287719396580319e-11, -2.512110237128224e-14,  2.530319036328180e-17,  7.164681497123293e-20, -5.541729965890667e-22,  2.141794806329897e-24, -5.920408475458576e-27,
  1.085145020085425e-29,  1.232101737775561e-01, -6.162087764318791e-04,  2.162651834206398e-06, -6.084032263255825e-09,  1.342709919385605e-11, -1.852240552406845e-14,
 -1.519778051595725e-17,  2.183452660283166e-19, -9.102769891147960e-22,  2.482021807835057e-24, -3.886328483886184e-27, -3.955595574942342e-30,  1.573673484102593e-01,
 -7.731360887745420e-04,  2.610238448320987e-06, -6.788936778881654e-09,  1.247806919213529e-11, -6.385549037794983e-15, -6.742685184405508e-17,  3.568495841315693e-19,
 -1.054956420580138e-21,  1.687771308665952e-24,  1.945033921850193e-27, -2.576732292666708e-29,  1.953275900418598e-01, -9.404332090063968e-04,  3.035384818816196e-06,
 -7.161022302999756e-09,  9.878022291185739e-12,  1.036485607409171e-14, -1.217951239378359e-16,  4.398946352559893e-19, -8.494368700569264e-22, -3.217281575540745e-25,
  9.777324055076501e-27, -4.205050599276599e-29,  2.369293762994215e-01, -1.115176247160099e-03,  3.417566252923998e-06, -7.130391686657491e-09,  5.659390105436442e-12,
  2.985598339552705e-14, -1.663289454114648e-16,  4.261795269110680e-19, -2.542378679910851e-22, -3.054894515751320e-24,  1.591820345935165e-26, -3.874124678934585e-29,
  2.819950097332219e-01, -1.294296964663345e-03,  3.737473630070657e-06, -6.652887692277090e-09,  4.733609537738158e-14,  4.948750699945590e-14, -1.891082502421144e-16,
  2.939889809341115e-19,  6.334637262117776e-22, -5.530308704283388e-24,  1.633336953429783e-26, -9.462987525309980e-30,  3.303311913451483e-01, -1.474633897258256e-03,
  3.977792589063621e-06, -5.714197922612390e-09, -6.553211334844237e-12,  6.628722948734854e-14, -1.809456624102463e-16,  5.091096501073968e-20,  1.587275636524859e-21,
 -6.605061868678094e-24,  8.790515881609883e-27,  3.769959558115053e-29,  3.817296576252556e-01, -1.652985695064560e-03,  4.123918035770361e-06, -4.331984170545559e-09,
 -1.359106880473755e-11,  7.735240426373242e-14, -1.377373431981206e-16, -2.635861843220928e-19,  2.307442332683272e-21, -5.442573864441240e-24, -5.466511229703946e-27,
  8.094606665452174e-29,  4.359678822939521e-01, -1.826165890869150e-03,  4.164575824213139e-06, -2.555840401782495e-09, -2.041998436435007e-11,  8.031174221600452e-14,
 -6.194919425376937e-17, -5.842201951480941e-19,  2.511656985912939e-21, -1.935506915661759e-24, -2.150795288642617e-26,  9.432053083581134e-29,  4.928098438025725e-01,
 -1.991058258315331e-03,  4.092326098139706e-06, -4.650246491092558e-10, -2.636263238823804e-11,  7.373663723969038e-14,  3.714928685609436e-17, -8.338175420726901e-19,
  2.033395420989082e-21,  3.107199869393492e-24, -3.236085372301454e-26,  6.208221140467444e-29,  5.520068594362143e-01, -2.144671880763083e-03,  3.903926425719080e-06,
  1.835940291963469e-09, -3.078098839629115e-11,  5.743444633483544e-14,  1.446511737711780e-16, -9.420525151173965e-19,  8.946156661692075e-22,  8.124491444177076e-24,
 -3.199119296564474e-26, -9.855125954322460e-30,  6.132984865858897e-01, -2.284195020788153e-03,  3.600537448567312e-06,  4.223553723627571e-09, -3.314571866030837e-11,
  3.257158215479629e-14,  2.424397989233032e-16, -8.643729693782855e-19, -6.750356461885615e-22,  1.129955842999705e-23, -1.834764440389898e-26, -9.277069057179608e-29,
  6.764134914092804e-01, -2.407046861247365e-03,  3.187759191176219e-06,  6.563129834430782e-09, -3.309703485972097e-11,  1.597954674627051e-15,  3.124647088306331e-16,
 -5.960426991477485e-19, -2.284912670725902e-21,  1.122764033054697e-23,  5.026899209676623e-27, -1.467339980123890e-28,  7.410708846786399e-01, -2.510926183249158e-03,
  2.675492292182493e-06,  8.717597390373455e-09, -3.049008717689259e-11, -3.202629077973011e-14,  3.402480389781785e-16, -1.771449108721363e-19, -3.487205339603304e-21,
  7.504808326084337e-24,  2.979916749697045e-26, -1.403248480646214e-28,  8.069810241197911e-01, -2.593856055885317e-03,  2.077625040320945e-06,  1.055671956935428e-08,
 -2.541937279107120e-11, -6.427003379872240e-14,  3.179166276762068e-16,  3.134923794644224e-19, -3.909134115912515e-21,  9.928019827513594e-25,  4.598377684891002e-26,
 -6.850281974442066e-29,  8.738467819781996e-01, -2.654223638748411e-03,  1.411554004633053e-06,  1.196609676927613e-08, -1.821870747907728e-11, -9.107737571140992e-14,
  2.461117651133230e-16,  7.746658150860172e-19, -3.372790502159329e-21, -6.377367595478983e-24,  4.619162110064823e-26,  4.156215616357665e-29,  9.413647759088262e-01,
 -2.690814242438851e-03,  6.975529880661038e-07,  1.285530771662860e-08, -9.435852748829730e-12, -1.089422572941735e-13,  1.343251472822573e-16,  1.105875971858031e-18,
 -1.962833180976190e-21, -1.222633800077162e-23,  2.910504964652518e-26,  1.412443077213811e-28,  1.009226660579716e+00, -2.702838855539481e-03, -4.198827141384167e-08,
  1.316458253542003e-08,  2.163481927590966e-13, -1.154249511103022e-13, -4.872229069012240e-19,  1.231522136918976e-18, -1.668442405686690e-23, -1.456170569257604e-23,
  4.963014362735608e-28,  1.835130272128321e-28,  1.077120476610850e+00, -2.689954429620347e-03, -7.834280707496856e-07,  1.286948542764107e-08,  9.927793726123187e-12,
 -1.095291816097633e-13, -1.368105205268096e-16,  1.120006391531662e-18,  1.964166046659569e-21, -1.251700775245384e-23, -2.885905635154990e-26,  1.467835141459937e-28,
  1.144732052647547e+00, -2.652276316985955e-03, -1.502806478830507e-06,  1.198321070995656e-08,  1.887108628724534e-11, -9.187712304289512e-14, -2.524674735631665e-16,
  7.925810554209549e-19,  3.457236982085291e-21, -6.703064242585719e-24, -4.759638462273673e-26,  4.679642955349582e-29,  1.211746455501831e+00, -2.590382378794707e-03,
 -2.176811736628062e-06,  1.055625717449546e-08,  2.628519930245005e-11, -6.464892348153865e-14, -3.287482950467379e-16,  3.192736092812349e-19,  4.072930309915962e-21,
  9.803613493497306e-25, -4.858659697310182e-26, -7.039878989214690e-29,  1.277849482397894e+00, -2.505308422934918e-03, -2.783739401420650e-06,  8.673431934324758e-09,
  3.155369552668376e-11, -3.128946857414260e-14, -3.539399070447397e-16, -1.974329095592229e-19,  3.670344009954956e-21,  8.016376360964037e-24, -3.197917269318722e-26,
 -1.512180357537949e-28,  1.342729188443917e+00, -2.398534790004221e-03, -3.304403107709378e-06,  6.448333243686884e-09,  3.426865293830605e-11,  3.977768784481326e-15,
 -3.255196232108692e-16, -6.471899162968400e-19,  2.397194725461454e-21,  1.217605113121034e-23, -5.043256379210399e-27, -1.612090751001719e-28,  1.406077441538569e+00,
 -2.271964079534892e-03, -3.722956379819980e-06,  4.015657539487998e-09,  3.427280796676445e-11,  3.675785852235231e-14, -2.505406898992658e-16, -9.383487408481237e-19,
  6.402726242191112e-22,  1.230855433163396e-23,  2.113164894217755e-26, -1.014299438614440e-28,  1.467591496025417e+00, -2.127890194099326e-03, -4.027587355894852e-06,
  1.521853589987542e-09,  3.167471549060907e-11,  6.311915538540226e-14, -1.441111424480946e-16, -1.019556886255120e-18, -1.097613528371188e-21,  8.710585017746775e-24,
  3.653210035278536e-26, -5.982681256023122e-30,  1.526975575552463e+00, -1.968959072232127e-03, -4.211052576008282e-06, -8.852089905946785e-10,  2.683472122353398e-11,
  8.015560810174316e-14, -2.627428309435557e-17, -8.907081648862257e-19, -2.353595285833627e-21,  2.938418314829361e-24,  3.642558202127332e-26,  7.738463017300234e-29,
  1.583942454798847e+00, -1.798121677636613e-03, -4.271022059463659e-06, -3.066791930015275e-09,  2.032291410919122e-11,  8.638644471510406e-14,  8.205171220391095e-17,
 -6.004538135506341e-19, -2.842056543648824e-21, -2.847555092116003e-24,  2.295840615225368e-26,  1.124070248522255e-28,  1.638215029018860e+00, -1.618580006719723e-03,
 -4.210215559166176e-06, -4.903255697934022e-09,  1.285357717251649e-11,  8.192840990321630e-14,  1.632073301320168e-16, -2.311943462978263e-19, -2.528662546302588e-21,
 -6.727751789340451e-24,  3.539959746253998e-27,  9.125513854702000e-29,  1.689527859747644e+00, -1.433727063467504e-03, -4.036318846716157e-06, -6.302659421442704e-09,
  5.203568190077399e-12,  6.841280898115605e-14,  2.061119175348144e-16,  1.240480262852261e-19, -1.619010960811853e-21, -7.710936673736593e-24, -1.301635784383324e-26,
  3.475363070970091e-29,  1.737628684536043e+00, -1.247081924087157e-03, -3.761678771552306e-06, -7.207297955173802e-09, -1.875846926143646e-12,  4.866234041687229e-14,
  2.080663747872423e-16,  3.862546702198203e-19, -4.699532543060396e-22, -5.997414890050025e-24, -2.058752448244187e-26, -2.266214235462590e-29,  1.782279878256376e+00,
 -1.062221167669116e-03, -3.402786194884064e-06, -7.597628277705486e-09, -7.743212526000846e-12,  2.618372422249368e-14,  1.746798565243547e-16,  5.096230097795725e-19,
  5.415991531503576e-22, -2.742769384145299e-24, -1.808421851478203e-26, -5.321745552615529e-29,  1.823259853369328e+00, -8.827080774803379e-04, -2.979566211578398e-06,
 -7.493235246548947e-09, -1.193697093134289e-11,  4.564104532458895e-15,  1.179929690117236e-16,  4.902034670549620e-19,  1.144023665609421e-21,  5.360771102457214e-25,
 -9.089604236270213e-27, -4.923869065228337e-29,  1.860364386591593e+00, -7.120211148882659e-04, -2.514504797863153e-06, -6.950720077700256e-09, -1.422284157418640e-11,
 -1.312387068405216e-14,  5.328520533230156e-17,  3.620627637794022e-19,  1.246715340476060e-21,  2.626444699296860e-24,  7.026492657393741e-28, -2.304664636983678e-29,
  1.893407859698200e+00, -5.534832294095853e-04, -2.031649617613394e-06, -6.058644951494040e-09, -1.461264524270130e-11, -2.480495593166566e-14, -4.646075881374144e-18,
  1.828593535667296e-19,  9.431299161448385e-22,  3.062432368013239e-24,  6.664152109324871e-27,  4.517456086850177e-30,  1.922224402841976e+00, -4.101935896195281e-04,
 -1.555529676229795e-06, -4.929912726619065e-09, -1.335226434599439e-11, -2.968905520678777e-14, -4.483792695790083e-17,  1.384751814628855e-20,  4.466755233925941e-22,
  2.175370543478172e-24,  7.288960032964182e-27,  1.815120174536680e-29,  1.946668930149018e+00, -2.849632959869165e-04, -1.110043382390396e-06, -3.692180181651100e-09,
 -1.088033161701333e-11, -2.831614512486325e-14, -6.235651512832207e-17, -9.917206160397142e-20, -9.786074757862942e-24,  7.786195012924504e-25,  4.210496270295749e-27,
  1.564117492558504e-29,  1.966618061076340e+00, -1.802565579387173e-04, -7.173669897911704e-07, -2.477076240714988e-09, -7.762999549181219e-12, -2.235517897201449e-14,
 -5.884672719821949e-17, -1.380279518575561e-19, -2.680405433997115e-22, -3.176306162979281e-25,  5.020684904575773e-28,  5.390203907277139e-30,  1.981970936230858e+00,
 -9.813863361459402e-05, -3.969349254357358e-07, -1.409105927942619e-09, -4.613256679511343e-12, -1.419907430917861e-14, -4.136911189635428e-17, -1.140247019232574e-19,
 -2.950331966814301e-22, -7.033340654934341e-25, -1.478800117520569e-27, -2.409051419500911e-30,  1.992650038233896e+00, -4.023113032743792e-05, -1.645383988021640e-07,
 -5.951487672930964e-10, -2.005275163874859e-12, -6.435455757406507e-15, -1.988972831408111e-17, -5.953633921761034e-20, -1.730465319651518e-22, -4.886088016890510e-25,
 -1.338261070389789e-27, -3.542560789188483e-30,  1.998603560890534e+00, -7.667212113247647e-06, -3.155082321678282e-08, -1.152988549907389e-10, -3.945496776028122e-13,
 -1.294306040210813e-15, -4.121157357562333e-18, -1.282976907250716e-20, -3.923176812504149e-23, -1.181956707903745e-25, -3.515714352872029e-28, -1.033939029576792e-30,
  5.467546178173289e-04, -2.876912884956692e-06,  1.135023624587890e-08, -3.979059004375918e-11,  1.307173309950034e-13, -4.120292093562276e-16,  1.261875641606026e-18,
 -3.783045700592541e-21,  1.115515056931577e-23, -3.245815642959671e-26,  9.340550585220019e-29, -2.662793445259144e-31,  4.917580583288011e-03, -2.582172377181196e-05,
  1.014479442740041e-07, -3.531526123109527e-10,  1.147876748091758e-12, -3.564188927881876e-15,  1.069636139577570e-17, -3.122826309608542e-20,  8.902067982505206e-23,
 -2.482600742822151e-25,  6.777835235482905e-28, -1.810868535819060e-30,  1.364211372501138e-02, -7.133648427077171e-05,  2.779149175739100e-07, -9.537742366378019e-10,
  3.033282411280353e-12, -9.127248642475188e-15,  2.622242653584219e-17, -7.214507036091152e-20,  1.898054951117490e-22, -4.745932964980190e-25,  1.112976278256794e-27,
 -2.380691667054308e-30,  2.668614738972405e-02, -1.386767285980619e-04,  5.334239723883627e-07, -1.791181701086335e-09,  5.505593729581149e-12, -1.574471857598794e-14,
  4.197774477550126e-17, -1.033620950820876e-19,  2.288121969372093e-22, -4.238674433290562e-25,  4.935075953804129e-28,  6.405167270132145e-31,  4.399844936881791e-02,
 -2.267388575502534e-04,  8.573048055692492e-07, -2.793890890847838e-09,  8.182403543603235e-12, -2.167824184868536e-14,  5.105318712783304e-17, -1.006810504094539e-19,
  1.323601565076958e-22,  8.833599298709303e-26, -1.482253379785468e-27,  6.975939343142804e-30,  6.551085650289769e-02, -3.340757383673818e-04,  1.235918040755601e-06,
 -3.874200841919154e-09,  1.062339281030257e-11, -2.511340982340954e-14,  4.729937768693844e-17, -4.804194362702410e-20, -1.218133932684732e-22,  9.895542643768359e-25,
 -4.026848398376190e-27,  1.236035682103157e-29,  9.113840293959824e-02, -4.589173034105943e-04,  1.653136628595510e-06, -4.934135861480054e-09,  1.238099711910654e-11,
 -2.449168672861186e-14,  2.707230261515018e-17,  5.510217949332724e-20, -4.812162949582092e-22,  1.914493289917705e-24, -5.445898134943917e-27,  1.068348378172297e-29,
  1.207794838334612e-01, -5.991959714086125e-04,  2.090920165126195e-06, -5.872180058469070e-09,  1.305348215827893e-11, -1.881699832690848e-14, -9.478700102385419e-18,
  1.906157504524328e-19, -8.237572959251330e-22,  2.323849240969247e-24, -4.004507291642096e-27, -1.511184859132696e-30,  1.543160566892216e-01, -7.525766663792250e-04,
  2.529964611462200e-06, -6.590393954967709e-09,  1.233496562679007e-11, -7.887650118617066e-15, -5.789845510457906e-17,  3.240760205527591e-19, -9.930561950058524e-22,
  1.744345937218170e-24,  9.184072119110561e-28, -2.100118058350427e-29,  1.916138829378973e-01, -9.164911579610487e-04,  2.950407178971822e-06, -7.001470257785844e-09,
  1.005707035380900e-11,  7.586498041849887e-15, -1.098598454797790e-16,  4.125992830057753e-19, -8.544129817006013e-22,  3.371372939128150e-26,  8.028114881453330e-27,
 -3.747415232174497e-29,  2.325228126923463e-01, -1.088176392591530e-03,  3.332563867553018e-06, -7.035277341141546e-09,  6.217552234936606e-12,  2.600626839565383e-14,
 -1.545254934556151e-16,  4.164038566488462e-19, -3.531627178640057e-22, -2.452129513935689e-24,  1.422485653290138e-26, -3.808472424776244e-29,  2.768771159485341e-01,
 -1.264716427723651e-03,  3.657675392731254e-06, -6.644456073115565e-09,  9.923780961982637e-13,  4.504980042177698e-14, -1.806218033378352e-16,  3.111995298443932e-19,
  4.460154399275378e-22, -4.887128722027932e-24,  1.578338325779457e-26, -1.526666448529106e-29,  3.244958637729770e-01, -1.443087521293083e-03,  3.908636092527896e-06,
 -5.808678715250839e-09, -5.270749498260168e-12,  6.196716205444763e-14, -1.788443008904857e-16,  9.797017148013942e-20,  1.356191185699934e-21, -6.223667680154923e-24,
  1.019758691885514e-26,  2.649579829045937e-29,  3.751833632373321e-01, -1.620205866392412e-03,  4.070679947402709e-06, -4.537246857794207e-09, -1.207763314701610e-11,
  7.396630439874590e-14, -1.441137389141977e-16, -1.929183872299517e-19,  2.108401695930692e-21, -5.593345452574013e-24, -2.154814197130026e-27,  6.959115160301471e-29,
  4.287296500187691e-01, -1.792977397328415e-03,  4.131998150163934e-06, -2.869796453865967e-09, -1.882989569439174e-11,  7.863767560077669e-14, -7.719374944368626e-17,
 -5.051200114042342e-19,  2.427483272830291e-21, -2.713940616905569e-24, -1.744500647264126e-26,  9.003504900776274e-29,  4.849110426698745e-01, -1.958349028993831e-03,
  4.084263791372187e-06, -8.749882671140382e-10, -2.488083650618508e-11,  7.435550474918568e-14,  1.472842356605282e-17, -7.672034690836517e-19,  2.122636445773982e-21,
  1.869912986712183e-24, -2.944715863650348e-26,  6.982129297714423e-29,  5.434907625641244e-01, -2.113360628170593e-03,  3.923041227720548e-06,  1.352813707401375e-09,
 -2.959970192980200e-11,  6.059304119913434e-14,  1.187166968970202e-16, -9.089925838662063e-19,  1.164011161405010e-21,  6.841840968789909e-24, -3.200582026881411e-26,
  8.746401611647835e-30,  6.042196234318520e-01, -2.255196954734617e-03,  3.648060602990003e-06,  3.698741551721786e-09, -3.243807290249074e-11,  3.809763769604075e-14,
  2.179950387794200e-16, -8.796148147196509e-19, -2.823881271439065e-22,  1.049032456570630e-23, -2.195805231298409e-26, -7.136466915225315e-29,  6.668367942064577e-01,
 -2.381238754832051e-03,  3.263341792492233e-06,  6.034234585223871e-09, -3.299147717249334e-11,  8.888949650201149e-15,  2.948128409121943e-16, -6.626663983971939e-19,
 -1.878622574534316e-21,  1.130311106283519e-23, -1.160578256783502e-27, -1.340080450679205e-28,  7.310706385909655e-01, -2.489112139347336e-03,  2.777156707206912e-06,
  8.225073562453477e-09, -3.104941930835031e-11, -2.393221070517112e-14,  3.337678991559114e-16, -2.841948486874058e-19, -3.197081036401069e-21,  8.571581804405989e-24,
  2.350624493849185e-26, -1.448964397701734e-28,  7.966396343211556e-01, -2.576735342076095e-03,  2.201824347566316e-06,  1.014014369325300e-08, -2.662783534371483e-11,
 -5.654879116111715e-14,  3.249509900340590e-16,  1.893206297401993e-19, -3.841073536690961e-21,  2.765094812951362e-24,  4.247040706180793e-26, -9.052493323542772e-29,
  8.632533745348019e-01, -2.642361925871695e-03,  1.553339118071228e-06,  1.166035315204613e-08, -1.997949511183357e-11, -8.492280095397710e-14,  2.662594439812642e-16,
  6.634228025460526e-19, -3.568757501148218e-21, -4.501959416529544e-24,  4.736101785474351e-26,  1.168031727317138e-29,  9.306136529500751e-01, -2.684619494718368e-03,
  8.508395327488145e-07,  1.268708886659028e-08, -1.157999010970292e-11, -1.053543754073022e-13,  1.643458267744017e-16,  1.036259406006333e-18, -2.380586151006778e-21,
 -1.094428622246358e-23,  3.483128110817774e-26,  1.184328278824462e-28,  9.984156337053205e-01, -2.702542978294256e-03,  1.159313379301526e-07,  1.314958719579433e-08,
 -2.089477036251131e-12, -1.150233972058994e-13,  3.390923302415551e-17,  1.222620290950969e-18, -5.386071627793971e-22, -1.438095687865409e-23,  8.515666515377991e-27,
  1.800182295116410e-28,  1.066349105715510e+00, -2.695601586115903e-03, -6.281140151383659e-07,  1.301063784211642e-08,  7.706950654999435e-12, -1.124296335421972e-13,
 -1.046396507284977e-16,  1.175440099053712e-18,  1.494384539076666e-21, -1.353646816015107e-23, -2.198064863961026e-26,  1.650748686045920e-28,  1.134099820259684e+00,
 -2.663718583520819e-03, -1.357258010199711e-06,  1.227012630058212e-08,  1.697481282173994e-11, -9.765776980269332e-14, -2.287652325019438e-16,  8.989888070715669e-19,
  3.182237095572758e-21, -8.556567154943895e-24, -4.485311247164588e-26,  7.775810095054225e-29,  1.201350909234882e+00, -2.607283123804498e-03, -2.047657319379935e-06,
  1.096605115253903e-08,  2.491412155856190e-11, -7.241685985490365e-14, -3.179813624945807e-16,  4.497913886257162e-19,  4.072566058764301e-21, -1.017138044134811e-24,
 -5.108599107247216e-26, -4.262537377880957e-29,  1.267784380106686e+00, -2.527153481375174e-03, -2.676651214083165e-06,  9.172821572683434e-09,  3.084258248944436e-11,
 -3.983683432605418e-14, -3.577821645145791e-16, -7.562420438285322e-20,  3.934329501956283e-21,  6.606904210347381e-24, -3.841580884978957e-26, -1.404213825984214e-28,
  1.333082682071127e+00, -2.424651170538131e-03, -3.223732084218546e-06,  6.996837655991111e-09,  3.426866228900506e-11, -4.043086443544567e-15, -3.425014598044929e-16,
 -5.635192945347097e-19,  2.830160869435509e-21,  1.182910191548472e-23, -1.237954481289742e-26, -1.715392244632068e-28,  1.396930336340018e+00, -2.301545603102588e-03,
 -3.671455122175065e-06,  4.569568133132681e-09,  3.494572092005460e-11,  3.043232705383354e-14, -2.764598881956574e-16, -9.106163118518499e-19,  1.097454561632474e-21,
  1.305740404576769e-23,  1.613477372519751e-26, -1.255871838373206e-28,  1.459015621800182e+00, -2.160029133779811e-03, -4.006243316895126e-06,  2.038550407990850e-09,
  3.290018032312044e-11,  5.931424769415174e-14, -1.731013186933393e-16, -1.049382117352752e-18, -7.578551231403595e-22,  1.015971739247769e-23,  3.574885110957229e-26,
 -3.009433248368306e-29,  1.519032305611267e+00, -2.002682562256356e-03, -4.219046182473943e-06, -4.430714466924790e-10,  2.842946389943133e-11,  7.921734472233321e-14,
 -5.225057715031919e-17, -9.640430061504800e-19, -2.220793950732662e-21,  4.460326136487002e-24,  3.958279380205309e-26,  6.543282089913596e-29,  1.576681406637120e+00,
 -1.832431400318923e-03, -4.305815217296027e-06, -2.727702380043157e-09,  2.206892009472524e-11,  8.814356830698906e-14,  6.395167321933165e-17, -6.928528147526862e-19,
 -2.926833524594090e-21, -1.828912889756266e-24,  2.800308452861018e-26,  1.164298013589241e-28,  1.631672977997287e+00, -1.652493465391292e-03, -4.267765928410593e-06,
 -4.684279463560456e-09,  1.453074257992560e-11,  8.575833826659559e-14,  1.555648786138900e-16, -3.159512933968894e-19, -2.767306053187310e-21, -6.501553300623052e-24,
  7.876135638994198e-27,  1.058235868196140e-28,  1.683727893527586e+00, -1.466318620783841e-03, -4.111405191190606e-06, -6.208186438732695e-09,  6.621541213478818e-12,
  7.339506078470337e-14,  2.088175159204424e-16,  6.770093500779193e-20, -1.905569089903054e-21, -8.196714056222313e-24, -1.116271812125701e-26,  4.982697051904329e-29,
  1.732579621604142e+00, -1.277521739044169e-03, -3.848313422334290e-06, -7.229250569012551e-09, -8.517978121665080e-13,  5.378381040356463e-14,  2.186373646396016e-16,
  3.676008893715804e-19, -7.009050236846000e-22, -6.838795844446823e-24, -2.142642724242394e-26, -1.509260731939589e-29,  1.777975968667805e+00, -1.089810208235951e-03,
 -3.494683050174843e-06, -7.717097614085993e-09, -7.176449335297941e-12,  3.054913619194431e-14,  1.891760712879353e-16,  5.252301210192473e-19,  4.292690775955206e-22,
 -3.513549909830217e-24, -2.046721112044589e-26, -5.491481482928018e-29,  1.819680773940780e+00, -9.069075213603454e-04, -3.070627460104319e-06, -7.683337920528148e-09,
 -1.181623730096424e-11,  7.564796159358741e-15,  1.322335645120794e-16,  5.270464746425707e-19,  1.156237408307118e-21,  1.271382415471373e-25, -1.140803747873866e-26,
 -5.619733771632700e-29,  1.857475536313267e+00, -7.324746759272143e-04, -2.599287258648956e-06, -7.180312349224742e-09, -1.447168571034238e-11, -1.171877703586651e-14,
  6.399573216893662e-17,  4.034738203820943e-19,  1.341512449222686e-21,  2.632452148238573e-24, -4.490384049002643e-28, -2.946836373145036e-29,  1.891160954268660e+00,
 -5.700312536816684e-04, -2.105772556963438e-06, -6.296420323309244e-09, -1.510942663031189e-11, -2.485150693520795e-14,  9.134509641911203e-19,  2.148552695559246e-19,
  1.058217670091960e-21,  3.332315166036735e-24,  6.812370994437206e-27,  2.096310539503808e-30,  1.920558360148067e+00, -4.228781401626013e-04, -1.615990230066061e-06,
 -5.148357511810750e-09, -1.395676648443740e-11, -3.075882309655111e-14, -4.423790236618863e-17,  2.945200390705619e-20,  5.304328259861272e-22,  2.483278002603671e-24,
  8.115529806868248e-27,  1.940182970327464e-29,  1.945511031429794e+00, -2.940238707184724e-04, -1.155413011035593e-06, -3.870878328050317e-09, -1.146184507401054e-11,
 -2.984603159089152e-14, -6.513326338737026e-17, -9.900283997656845e-20,  2.144775364999844e-23,  9.614785267224180e-25,  4.949654649249962e-27,  1.800301240876528e-29,
  1.965885365688526e+00, -1.861165395374950e-04, -7.478521592558216e-07, -2.604939129867280e-09, -8.224544443978183e-12, -2.381485746640234e-14, -6.283328060256028e-17,
 -1.467838426945102e-19, -2.790532448159574e-22, -2.924327840149296e-25,  7.674562516836687e-28,  6.713497456674555e-30,  1.981571921845148e+00, -1.013830268469783e-04,
 -4.142966183573302e-07, -1.485244937038692e-09, -4.907430974937282e-12, -1.523133594359152e-14, -4.469786746457624e-17, -1.238825091656453e-19, -3.214436319929637e-22,
 -7.646194746644169e-25, -1.585732734585199e-27, -2.444863873673763e-30,  1.992486435083761e+00, -4.157656004678879e-05, -1.718770234166468e-07, -6.282893572974998e-10,
 -2.138896146469324e-12, -6.933455813327335e-15, -2.163699047124301e-17, -6.536591095466494e-20, -1.916387506330964e-22, -5.453880270155538e-25, -1.504052236670584e-27,
 -4.002909341243859e-30,  1.998572378312051e+00, -7.925262364410329e-06, -3.297315823546058e-08, -1.218242375309972e-10, -4.214547242970483e-13, -1.397670512222840e-15,
 -4.498626277368652e-18, -1.415607208824398e-20, -4.375130698575333e-23, -1.332125810978944e-25, -4.004089846456845e-28, -1.189821170446787e-30,  5.354255953555936e-04,
 -2.787986003967420e-06,  1.088503132332658e-08, -3.776342723796355e-11,  1.227712209921023e-13, -3.829760147519932e-16,  1.160777217267722e-18, -3.444077986180708e-21,
  1.005117930446029e-23, -2.894600598864469e-26,  8.244690331232060e-29, -2.326443309665383e-31,  4.815890449465027e-03, -2.502678464893578e-05,  9.731800111223224e-08,
 -3.353431981203731e-10,  1.079090899812557e-12, -3.317655126841220e-15,  9.860544131914237e-18, -2.851751859851577e-20,  8.055271090394596e-23, -2.226776785314501e-25,
  6.028842577447625e-28, -1.598267834670383e-30,  1.336114308653268e-02, -6.915813469534513e-05,  2.667549067778173e-07, -9.066685584681938e-10,  2.856870676975889e-12,
 -8.521480297273119e-15,  2.428488901797542e-17, -6.633626934351520e-20,  1.734967852564022e-22, -4.321089534033524e-25,  1.012709305816399e-27, -2.179083808388789e-30,
  2.613984121211841e-02, -1.344938396002750e-04,  5.124481121198880e-07, -1.705557586706766e-09,  5.200543808286923e-12, -1.477116894247740e-14,  3.918384746001469e-17,
 -9.628039324460890e-20,  2.139142073732516e-22, -4.036589502103302e-25,  5.146907266370477e-28,  3.346031617842843e-31,  4.310500157893715e-02, -2.200123327778248e-04,
  8.245495310301908e-07, -2.666375329329009e-09,  7.760865611490485e-12, -2.048631303244149e-14,  4.829381493593513e-17, -9.640550657927004e-20,  1.345439603970122e-22,
  3.485294044513041e-26, -1.199808777386379e-27,  5.889607972879480e-30,  6.419403782837381e-02, -3.243715038928687e-04,  1.190431100036603e-06, -3.708183489010707e-09,
  1.013236536461967e-11, -2.399477549823597e-14,  4.590477073553327e-17, -5.140003700978234e-20, -8.896142901600352e-23,  8.389496744056344e-25, -3.513264974723989e-27,
  1.100331911952309e-29,  8.932881362320141e-02, -4.459257182674922e-04,  1.595099525181055e-06, -4.739922781100580e-09,  1.189777698077598e-11, -2.382511500839481e-14,
  2.840964553658927e-17,  4.076487814351606e-20, -4.161030960121677e-22,  1.705968724354369e-24, -4.982832187643161e-27,  1.034077517342153e-29,  1.184157133595218e-01,
 -5.827469528566084e-04,  2.021694684286264e-06, -5.666345661843169e-09,  1.267528454985341e-11, -1.898334275089048e-14, -4.498146667071124e-18,  1.655630458271218e-19,
 -7.429924769891761e-22,  2.162937845491173e-24, -4.027135583100183e-27,  4.023161574707216e-31,  1.513457333077680e-01, -7.326499457514020e-04,  2.452058598566578e-06,
 -6.394369007198816e-09,  1.216403368838111e-11, -9.171856155343443e-15, -4.925973484604710e-17,  2.933083248476085e-19, -9.298095791182057e-22,  1.763867317892182e-24,
  8.792353455182536e-29, -1.684558847895564e-29,  1.879945965851465e-01, -8.932212249584918e-04,  2.867359568271877e-06, -6.839482677280733e-09,  1.018335377221065e-11,
  5.085408810966382e-15, -9.868923653590483e-17,  3.853363177251827e-19, -8.478043937131894e-22,  3.231794285012327e-25,  6.477464503324528e-27, -3.304145175353445e-29,
  2.282228959008145e-01, -1.061851845549301e-03,  3.248753946669316e-06, -6.931833063500062e-09,  6.701528956368013e-12,  2.243621348992663e-14, -1.430369092375541e-16,
  4.037967823928750e-19, -4.315980594389413e-22, -1.916280525951124e-24,  1.257793200001998e-26, -3.666849457613783e-29,  2.718762685347051e-01, -1.235773621586180e-03,
  3.578066166233197e-06, -6.621602596744372e-09,  1.850738333411496e-12,  4.082089473232470e-14, -1.717339900316384e-16,  3.227774880580484e-19,  2.812683697911051e-22,
 -4.270589500309169e-24,  1.501248802893816e-26, -1.953861350310629e-29,  3.187856085040146e-01, -1.412098590095158e-03,  3.838466101636743e-06, -5.883328155981469e-09,
 -4.074082216620405e-12,  5.771251664167438e-14, -1.755266713326537e-16,  1.378642824037309e-19,  1.139735090864849e-21, -5.795423583710863e-24,  1.114360404088612e-26,
  1.674541806579136e-29,  3.687673213290286e-01, -1.587861388579298e-03,  4.015121736658325e-06, -4.718844005564528e-09, -1.063329328470513e-11,  7.045019156007249e-14,
 -1.486012458694404e-16, -1.286821441947122e-19,  1.906197585076262e-21, -5.621604779608404e-24,  6.606349011763305e-28,  5.844535633112524e-29,  4.216236272213854e-01,
 -1.760064165236473e-03,  4.095804484768745e-06, -3.158598069551444e-09, -1.727676932963289e-11,  7.662398816842192e-14, -9.026520087011157e-17, -4.291308001492206e-19,
  2.318160851227412e-21, -3.334166543705003e-24, -1.360996819461155e-26,  8.404587329436437e-29,  4.771429188703337e-01, -1.925723572577756e-03,  4.071424489085726e-06,
 -1.261172729557610e-09, -2.339189170434954e-11,  7.445893622632905e-14, -5.793797948106003e-18, -6.984232571750091e-19,  2.169506513424943e-21,  7.550492889796782e-25,
 -2.626224515038356e-26,  7.446520379159769e-29,  5.351001802812853e-01, -2.081919321345253e-03,  3.936473890234388e-06,  8.890595946337488e-10, -2.836138800703296e-11,
  6.314124825809691e-14,  9.382165380682995e-17, -8.680493635185674e-19,  1.387410627436814e-21,  5.574166755667444e-24, -3.126271904181518e-26,  2.455773252608522e-29,
  5.952574733093227e-01, -2.225843693758413e-03,  3.689357488948814e-06,  3.186103884948008e-09, -3.162580012470182e-11,  4.303328967790149e-14,  1.932948454109514e-16,
 -8.827840932610344e-19,  7.875364034231093e-23,  9.555410437372361e-24, -2.463545556079521e-26, -5.047805062104847e-29,  6.573644986098315e-01, -2.354851334936755e-03,
  3.332592520181581e-06,  5.508171192362524e-09, -3.274447953933157e-11,  1.573538420851893e-14,  2.754776018652639e-16, -7.162919639420461e-19, -1.473927795657402e-21,
  1.114312342224978e-23, -6.726701117737929e-27, -1.186298052153246e-28,  7.211592376790896e-01, -2.466508561164277e-03,  2.872862452394221e-06,  7.724886023336022e-09,
 -3.144866229506107e-11, -1.602853993585525e-14,  3.244257619256814e-16, -3.813952354890296e-19, -2.873119124954830e-21,  9.384053854241339e-24,  1.711902059212438e-26,
 -1.446756195809473e-28,  7.863686824583980e-01, -2.558641346362742e-03,  2.320913854409037e-06,  9.705475810997744e-09, -2.768046489976188e-11, -4.870014148952997e-14,
  3.285484221932659e-16,  6.831871386536355e-20, -3.711962393418262e-21,  4.378706863979014e-24,  3.808107522455522e-26, -1.082480630673073e-28,  8.527096586046110e-01,
 -2.629381077194997e-03,  1.691290416690439e-06,  1.132744686624574e-08, -2.161261150220054e-11, -7.832270552971008e-14,  2.832147245207000e-16,  5.469955499417409e-19,
 -3.696682668408443e-21, -2.605832042733159e-24,  4.723545375680679e-26, -1.712234296088866e-29,  9.198897479664461e-01, -2.677207106646071e-03,  1.001904106978750e-06,
  1.248517633748017e-08, -1.364533038053408e-11, -1.010708547965903e-13,  1.922373310524603e-16,  9.540553885840348e-19, -2.748313550939459e-21, -9.454264757103132e-24,
  3.948051554317174e-26,  9.246264252058597e-29,  9.876083150297432e-01, -2.700985090233833e-03,  2.734500539797800e-07,  1.309780763550658e-08, -4.379045947283429e-12,
 -1.138011984355628e-13,  6.782403322325563e-17,  1.197182532831941e-18, -1.048301944809575e-21, -1.388424982572470e-23,  1.625162137723767e-26,  1.706797610935794e-28,
  1.055557641088392e+00, -2.700000063053630e-03, -4.713211085292308e-07,  1.311583514271025e-08,  5.435936361482580e-12, -1.145410895791368e-13, -7.113222927750124e-17,
  1.215308177271453e-18,  9.930355140714366e-22, -1.426617324656443e-23, -1.440913715251847e-26,  1.781734537089633e-28,  1.123424168647270e+00, -2.673983214725493e-03,
 -1.208452309119587e-06,  1.252580851433015e-08,  1.496885089381223e-11, -1.028348650041649e-13, -2.022166391679324e-16,  9.955527686716415e-19,  2.842811621420495e-21,
 -1.027343519375243e-23, -4.077534635975963e-26,  1.072501621598406e-28,  1.190889857060975e+00, -2.623131348008383e-03, -1.913722075824081e-06,  1.135268029858903e-08,
  2.339056487425790e-11, -7.988260426466401e-14, -3.035710291993094e-16,  5.791301069298029e-19,  3.998795777449994e-21, -3.089196941886600e-24, -5.229211111948986e-26,
 -1.177132364932457e-29,  1.257633648656097e+00, -2.548118070055557e-03, -2.563644272219556e-06,  9.659461989797264e-09,  2.995988098553211e-11, -4.843458059715564e-14,
 -3.581034892017876e-16,  5.377151888905276e-20,  4.143069309982648e-21,  4.951137373309157e-24, -4.425262762743888e-26, -1.239612573149050e-28,  1.323333042582665e+00,
 -2.450095867001282e-03, -3.136484370134241e-06,  7.544037561298639e-09,  3.410437669418745e-11, -1.244184040167804e-14, -3.569488363950143e-16, -4.662510446294491e-19,
  3.245257335839539e-21,  1.118095840246783e-23, -2.006811096724146e-26, -1.770849775352462e-28,  1.387665771409972e+00, -2.330688355701268e-03, -3.613246621302717e-06,
  5.133199744420680e-09,  3.548597417786495e-11,  2.349572957158071e-14, -3.013939951939057e-16, -8.678633630316306e-19,  1.577743595658420e-21,  1.358540108032892e-23,
  1.009786212184689e-26, -1.485281845972880e-28,  1.450311573052451e+00, -2.191972192404981e-03, -3.978583905870281e-06,  2.574207813675833e-09,  3.404252826888710e-11,
  5.480483099722087e-14, -2.027666023108846e-16, -1.067508550191265e-18, -3.667550012427386e-22,  1.155549320223551e-23,  3.384525921480241e-26, -5.681310201527850e-29,
  1.510954048024944e+00, -2.036448346409855e-03, -4.221581773978943e-06,  2.439729594443560e-11,  2.999904337345240e-11,  7.763154145785445e-14, -8.021234774999935e-17,
 -1.032228315464747e-18, -2.031068868194632e-21,  6.096750516895371e-24,  4.211995081244352e-26,  4.916404889901132e-29,  1.569282589338734e+00, -1.867002714538767e-03,
 -4.336370603122898e-06, -2.360420081684698e-09,  2.384551354637693e-11,  8.943497362938329e-14,  4.323227441517598e-17, -7.873387023334531e-19, -2.971272534389504e-21,
 -6.058292756266303e-25,  3.315728559137939e-26,  1.172682769225566e-28,  1.624994369628934e+00, -1.686856354215900e-03, -4.322525081734247e-06, -4.437866582189955e-09,
  1.628247571409990e-11,  8.937551527645893e-14,  1.454437903789489e-16, -4.081798172371682e-19, -2.994530533610714e-21, -6.089167294588866e-24,  1.284627945538395e-26,
  1.199704641026148e-28,  1.677796367431210e+00, -1.499505940870936e-03, -4.185218436258670e-06, -6.090225754527695e-09,  8.139675399560622e-12,  7.842226251811857e-14,
  2.098144983881694e-16,  1.919817517340382e-21, -2.208115534686641e-21, -8.594510538062456e-24, -8.603406953519508e-27,  6.680778709058539e-29,  1.727407411993211e+00,
 -1.308655398518294e-03, -3.935109771467523e-06, -7.233985370228390e-09,  2.771709967523498e-13,  5.915185315239881e-14,  2.285779864838657e-16,  3.410662328310165e-19,
 -9.626639539670802e-22, -7.706375997000591e-24, -2.187973110621697e-26, -5.085872834896627e-30,  1.773560223714153e+00, -1.118139997254726e-03, -3.587956185444319e-06,
 -7.826781229498972e-09, -6.518865627165147e-12,  3.526726881934114e-14,  2.040546579244542e-16,  5.367801784244248e-19,  2.874603675557433e-22, -4.380785145962636e-24,
 -2.289740400323196e-26, -5.530007042353546e-29,  1.816003425361462e+00, -9.318445426339223e-04, -3.163956308720845e-06, -7.871009824665051e-09, -1.163198836703861e-11,
  1.091967123593550e-14,  1.475088917035317e-16,  5.640262708546297e-19,  1.151985518355465e-21, -3.807441045204685e-25, -1.403852900816628e-26, -6.339543941541595e-29,
  1.854503497729776e+00, -7.536175825386230e-04, -2.686847742035020e-06, -7.413646945017312e-09, -1.468976175560385e-11, -1.004237397429609e-14,  7.590820352949624e-17,
  4.479123831069841e-19,  1.435625779038800e-21,  2.586439338041926e-24, -1.905972217802934e-27, -3.693449839533201e-29,  1.888846652513278e+00, -5.871838098330504e-04,
 -2.182796498178143e-06, -6.542144083660180e-09, -1.560572999582576e-11, -2.475345349648490e-14,  7.421890261158913e-18,  2.506903683793838e-19,  1.183100157595670e-21,
  3.605764270471444e-24,  6.836448348996331e-27, -1.151592212280817e-30,  1.918840595047055e+00, -4.360570265308391e-04, -1.679130856622910e-06, -5.376644557510769e-09,
 -1.458248297424116e-11, -3.180863394949238e-14, -4.316171639925033e-17,  4.792056461185193e-20,  6.258828497757753e-22,  2.825310457549630e-24,  8.994119782525382e-27,
  2.050245522966593e-29,  1.944316150690130e+00, -3.034561405108129e-04, -1.202983864174038e-06, -4.059129088752905e-09, -1.207462168584693e-11, -3.144238392338550e-14,
 -6.789024916762388e-17, -9.772289448548026e-20,  5.982250580602979e-23,  1.176066038409112e-24,  5.799027860537607e-27,  2.065412999661366e-29,  1.965128732713825e+00,
 -1.922266677037826e-04, -7.799169721566667e-07, -2.740425568422111e-09, -8.716259741812811e-12, -2.537319412941205e-14, -6.706978098142599e-17, -1.558754588707989e-19,
 -2.889530287361674e-22, -2.553791812370327e-25,  1.096811996622586e-27,  8.305319988079683e-30,  1.981159646197790e+00, -1.047700499082922e-04, -4.326009157343955e-07,
 -1.566260333011228e-09, -5.223072264211391e-12, -1.634689750318394e-14, -4.831481108697683e-17, -1.346215785804335e-19, -3.501375971765925e-22, -8.302007455101931e-25,
 -1.693245772384799e-27, -2.432914627132137e-30,  1.992317330225742e+00, -4.298232662832641e-05, -1.796264989405881e-07, -6.636498981939184e-10, -2.282910050204606e-12,
 -7.475418062050331e-15, -2.355612659988115e-17, -7.182445908846885e-20, -2.123994311664647e-22, -6.092215271715936e-25, -1.691421886448038e-27, -4.524654934587250e-30,
  1.998540140268732e+00, -8.195011992632885e-06, -3.447645057930615e-08, -1.287971442803166e-10, -4.505207476585718e-13, -1.510556732118084e-15, -4.915340474350714e-18,
 -1.563604095524283e-20, -4.884833571221110e-23, -1.503273742447533e-25, -4.566511238728902e-28, -1.371190043116973e-30,  5.244449882092845e-04, -2.702685576565725e-06,
  1.044340828459976e-08, -3.585888235680327e-11,  1.153826598921780e-13, -3.562391672662982e-16,  1.068693730756087e-18, -3.138496143031294e-21,  9.066099240486877e-24,
 -2.584398403233681e-26,  7.286613039738213e-29, -2.035353451748131e-31,  4.717315320629962e-03, -2.426404856144710e-05,  9.339532673033820e-08, -3.185959767337123e-10,
  1.015041124667213e-12, -3.090299919413557e-15,  9.096968496976419e-18, -2.606357405403611e-20,  7.295396208451086e-23, -1.999121400529115e-25,  5.367498731137237e-28,
 -1.411870280185971e-30,  1.308871079966599e-02, -6.706685121310350e-05,  2.561436203647993e-07, -8.622910174045117e-10,  2.692122176052219e-12, -7.960318681702842e-15,
  2.250291613249584e-17, -6.102563300425271e-20,  1.586474216762915e-22, -3.934617999626212e-25,  9.210191609753959e-28, -1.990874647458370e-30,  2.560993736895472e-02,
 -1.304747290442678e-04,  4.924710873547545e-07, -1.624662079911384e-09,  4.914310130065140e-12, -1.386234658641777e-14,  3.658167388468800e-17, -8.966364851091989e-20,
  1.997559227024326e-22, -3.828515368424355e-25,  5.239432815551847e-28,  9.596240103599712e-32,  4.223794533542500e-02, -2.135418423245162e-04,  7.932847507168153e-07,
 -2.545417223511513e-09,  7.362513736848043e-12, -1.935916637280704e-14,  4.565486188335441e-17, -9.208879745037537e-20,  1.349946444081445e-22, -8.241448705221795e-27,
 -9.616991859156019e-28,  4.957230656192387e-30,  6.291532073168743e-02, -3.150233279822744e-04,  1.146889961243212e-06, -3.549845442203242e-09,  9.663368876801930e-12,
 -2.291062613738237e-14,  4.443006737849965e-17, -5.378976568098373e-20, -6.117553155207060e-23,  7.077280976931079e-25, -3.056860289496373e-27,  9.761211681481500e-30,
  8.757027662970922e-02, -4.333892381358668e-04,  1.539347034821210e-06, -4.553332959906676e-09,  1.142817791001540e-11, -2.313103575131644e-14,  2.937361150267770e-17,
  2.839463195035383e-20, -3.581673742830115e-22,  1.515625665996915e-24, -4.537716535300295e-27,  9.875185539419047e-30,  1.161166468500016e-01, -5.668419611818465e-04,
  1.954902819846801e-06, -5.466582780734324e-09,  1.229490005284791e-11, -1.903828491047304e-14, -1.837575075579546e-19,  1.430021121098286e-19, -6.680177299058137e-22,
  2.002667962119291e-24, -3.975683325748369e-27,  1.869213381936450e-30,  1.484538851423943e-01, -7.133371124029816e-04,  2.376487663701655e-06, -6.201273467306882e-09,
  1.196942232486731e-11, -1.025884172305462e-14, -4.145411362260386e-17,  2.645697011965045e-19, -8.664156364597701e-22,  1.753655503253567e-24, -5.723983846978608e-28,
 -1.325912530738751e-29,  1.844670735572891e-01, -8.706078667968849e-04,  2.786266327504050e-06, -6.675860428878390e-09,  1.026223468256854e-11,  2.843286945231454e-15,
 -8.827754653984574e-17,  3.584399663811227e-19, -8.318450578237440e-22,  5.544580846878201e-25,  5.117105436657407e-27, -2.883585932272932e-29,  2.240269443792972e-01,
 -1.036192686236914e-03,  3.166229510834382e-06, -6.821201510884973e-09,  7.116831855246258e-12,  1.913738237942410e-14, -1.319336520042322e-16,  3.889758446632020e-19,
 -4.919119774583696e-22, -1.444886244615460e-24,  1.100612437039460e-26, -3.470210359649110e-29,  2.669899206558973e-01, -1.207466365171978e-03,  3.498810830774669e-06,
 -6.585680292014664e-09,  2.626676798270456e-12,  3.680861131791409e-14, -1.625925083113217e-16,  3.294323721538805e-19,  1.381200781316407e-22, -3.688240799384619e-24,
  1.408349628467712e-26, -2.248704063667556e-29,  3.131981810176637e-01, -1.381674282941142e-03,  3.767512404467784e-06, -5.939506971387961e-09, -2.961625116095554e-12,
  5.355013054023536e-14, -1.711866140080396e-16,  1.710849565964590e-19,  9.392774163371480e-22, -5.337491933189061e-24,  1.169247868695181e-26,  8.437881671112959e-30,
  3.624797551467584e-01, -1.555969705634317e-03,  3.957520678817010e-06, -4.877899546931285e-09, -9.260210773063121e-12,  6.684723057551853e-14, -1.513807289584437e-16,
 -7.091192663833874e-20,  1.704886224142814e-21, -5.546924076499816e-24,  2.995887880633935e-27,  4.780638663442761e-29,  4.146486568970302e-01, -1.727453925662859e-03,
  4.056292917827787e-06, -3.422888182511333e-09, -1.576688364508583e-11,  7.432170338103145e-14, -1.012610795130332e-16, -3.569680895274206e-19,  2.189204395687175e-21,
 -3.806652129473883e-24, -1.006680787380903e-26,  7.684510264563204e-29,  4.695050626893485e-01, -1.893218962454570e-03,  4.054093895325260e-06, -1.623543629741758e-09,
 -2.190564689084517e-11,  7.409307782369592e-14, -2.437503201657905e-17, -6.287604277568922e-19,  2.178576238251764e-21, -2.291640237311209e-25, -2.293456487497170e-26,
  7.637393917094671e-29,  5.268355433833909e-01, -2.050392472931472e-03,  3.944461959290425e-06,  4.454941583988504e-10, -2.707798789740038e-11,  6.510649708734537e-14,
  7.016629172679258e-17, -8.206804938452280e-19,  1.565868789391510e-21,  4.349280914198004e-24, -2.988751878772089e-26,  3.747172959077248e-29,  5.864133583419509e-01,
 -2.196184436071474e-03,  3.724583854262934e-06,  2.687220070801527e-09, -3.072074292710807e-11,  4.737634623619306e-14,  1.686625069641821e-16, -8.749542348460935e-19,
  4.045295994296999e-22,  8.531480832422454e-24, -2.641729140991407e-26, -3.075150322129052e-29,  6.479988208319698e-01, -2.327935082839101e-03,  3.395558634572427e-06,
  4.987129493738846e-09, -3.236530776029203e-11,  2.210121139134310e-14,  2.548209858791212e-16, -7.571010596946683e-19, -1.078831595425954e-21,  1.077461749098215e-23,
 -1.157329673173520e-26, -1.014392207730548e-28,  7.113397442200405e-01, -2.443163442685764e-03,  2.962532794269995e-06,  7.219562097664138e-09, -3.169228826732717e-11,
 -8.380543078673824e-15,  3.125111948476582e-16, -4.678100683576475e-19, -2.524492669024516e-21,  9.942542989591692e-24,  1.083861047111971e-26, -1.401303681999974e-28,
  7.761719785873946e-01, -2.539615773013492e-03,  2.434691486405844e-06,  9.255225187981160e-09, -2.857552987493367e-11, -4.080529079655393e-14,  3.288241253382836e-16,
 -4.765753577129693e-20, -3.528097268578786e-21,  5.802492866946530e-24,  3.301275879809857e-26, -1.213540423068940e-28,  8.422200473753112e-01, -2.615313031668467e-03,
  1.825094485341876e-06,  1.096948772725036e-08, -2.310992289709969e-11, -7.135520252946331e-14,  2.968629722375101e-16,  4.275634444936028e-19, -3.756738226824275e-21,
 -7.395269424516171e-25,  4.588514784914055e-26, -4.383451836888112e-29,  9.091978934387278e-01, -2.668596448810618e-03,  1.150350400936211e-06,  1.225093929199785e-08,
 -1.561849937410721e-11, -9.614683754418448e-14,  2.176706876992876e-16,  8.609759608472670e-19, -3.059334546252612e-21, -7.801817959412247e-24,  4.293747972160639e-26,
  6.442438685124446e-29,  9.768097433942331e-01, -2.698170158482918e-03,  4.301285658567944e-07,  1.300963447425127e-08, -6.636098471052780e-12, -1.117754159675838e-13,
  1.008013417580994e-16,  1.155779464297130e-18, -1.534659356104845e-21, -1.308795661215803e-23,  2.345548215159849e-26,  1.559227888427637e-28,  1.044751098359082e+00,
 -2.703139767907730e-03, -3.134851027528869e-07,  1.318440242195769e-08,  3.130815684659253e-12, -1.158368068620653e-13, -3.673663238352361e-17,  1.238772257005737e-18,
  4.709923984306277e-22, -1.468315571325703e-23, -6.386564625669422e-27,  1.855031356936502e-28,  1.112709858052727e+00, -2.683045680836703e-03, -1.056774296104051e-06,
  1.274860251785221e-08,  1.286593115008999e-11, -1.073436317593262e-13, -1.731253702671459e-16,  1.080300177105848e-18,  2.444821351896905e-21, -1.180194540403593e-23,
 -3.545484677523902e-26,  1.340489211093490e-28,  1.180367583738118e+00, -2.637889957691987e-03, -1.775298407128508e-06,  1.171375803527919e-08,  2.172144344986186e-11,
 -8.695937881064805e-14, -2.855835256555790e-16,  7.049080567116707e-19,  3.849896477536863e-21, -5.181669438017798e-24, -5.209187414314123e-26,  2.111175207546788e-29,
  1.247400903590344e+00, -2.568155497620947e-03, -2.444888057167811e-06,  1.013060436914391e-08,  2.890544456923253e-11, -5.699586354612725e-14, -3.547174917834652e-16,
  1.888496490014616e-19,  4.288188477485267e-21,  3.078018742972911e-24, -4.924343753596916e-26, -1.020189367783630e-28,  1.313483061778905e+00, -2.474816373725783e-03,
 -3.042691630212175e-06,  8.087247209777941e-09,  3.376887691228803e-11, -2.115317196924203e-14, -3.684906720079752e-16, -3.561327778065264e-19,  3.631440371223420e-21,
  1.022197362054880e-23, -2.788121905939615e-26, -1.770881405812010e-28,  1.378285609834840e+00, -2.359338249779464e-03, -3.548227359070406e-06,  5.704333476622900e-09,
  3.588161730798601e-11,  1.597683108611262e-14, -3.249133361580891e-16, -8.094855837677546e-19,  2.072456009794654e-21,  1.385233491305561e-23,  3.098534905703649e-27,
 -1.691451225756114e-28,  1.441480235760065e+00, -2.223667960574228e-03, -3.944390042504572e-06,  3.127382449760491e-09,  3.508753460569944e-11,  4.957881707610023e-14,
 -2.327567775370973e-16, -1.072332845924922e-18,  7.293335653600196e-23,  1.285098848032747e-23,  3.072074560421720e-26, -8.546153020280057e-29,  1.502740722859406e+00,
 -2.070211552520614e-03, -4.218358227425858e-06,  5.166884834168268e-10,  3.153004509196638e-11,  7.535248657913846e-14, -1.099893226929818e-16, -1.093381733117215e-18,
 -1.780790160296386e-21,  7.819037543647742e-24,  4.384345792103077e-26,  2.844041960786447e-29,  1.561745026495323e+00, -1.901800357278561e-03, -4.362347286052897e-06,
 -1.964533583205937e-09,  2.564274750212317e-11,  9.019724753864892e-14,  1.985426520019147e-17, -8.825023440102406e-19, -2.967970495071618e-21,  8.230655176869624e-25,
  3.826528961232988e-26,  1.142142094928114e-28,  1.618177452966009e+00, -1.721645006569434e-03, -4.374156771949448e-06, -4.162861312858627e-09,  1.810390996993501e-11,
  9.271799086023534e-14,  1.326410192777250e-16, -5.074024182210765e-19, -3.203182965851134e-21, -5.465796171953374e-24,  1.841741063881599e-26,  1.330196745604725e-28,
  1.671730920600620e+00, -1.533277684226633e-03, -4.257467091828847e-06, -5.947169917083837e-09,  9.758437997080108e-12,  8.345018287819903e-14,  2.088320653691967e-16,
 -7.375066603595644e-20, -2.522955092391448e-21, -8.874468514703561e-24, -5.258290439299169e-27,  8.550301134687410e-29,  1.722109279087339e+00, -1.340483340734111e-03,
 -4.021850973044310e-06, -7.219785091100389e-09,  1.515821214689969e-12,  6.474857969848163e-14,  2.376536548661673e-16,  3.056529724511403e-19, -1.255868958039991e-21,
 -8.582501053981340e-24, -2.183385288357075e-26,  7.641406239885921e-30,  1.769029659160433e+00, -1.147221050008308e-03, -3.682479218970674e-06, -7.925169102329461e-09,
 -5.763324985142083e-12,  4.034582604622940e-14,  2.191882885752845e-16,  5.432740632013832e-19,  1.126816346798568e-22, -5.345092149475990e-24, -2.530827271059207e-26,
 -5.396455422590473e-29,  1.812224821250047e+00, -9.575371476015514e-04, -3.259517252588058e-06, -8.055176695272795e-09, -1.137689213672135e-11,  1.465354636618639e-14,
  1.638148513023645e-16,  6.005565374569894e-19,  1.127479294156730e-21, -1.000208848750984e-24, -1.698745378457718e-26, -7.063310481678541e-29,  1.851445468738424e+00,
 -7.754722297432223e-04, -2.777228017956017e-06, -7.650186570027483e-09, -1.487134820906900e-11, -8.064801878157168e-15,  8.910678439081537e-17,  4.953241596317172e-19,
  1.526951545900617e-21,  2.475255347968162e-24, -3.715717347767941e-27, -4.551511826491593e-29,  1.886462489284912e+00, -6.049644870432545e-04, -2.262816676481277e-06,
 -6.795784172913305e-09, -1.609842662072584e-11, -2.448669625092299e-14,  1.499113921143775e-17,  2.906791033066816e-19,  1.317807178452101e-21,  3.877038023019617e-24,
  6.696346842998117e-27, -5.396161312078285e-30,  1.917069086558364e+00, -4.497521674703070e-04, -1.745071684344859e-06, -5.615109451259219e-09, -1.522889367683550e-11,
 -3.282605413340015e-14, -4.152374915394120e-17,  6.964741053284034e-20,  7.342897299938741e-22,  3.203391291254803e-24,  9.916187943948182e-27,  2.136090920235467e-29,
  1.943082765192054e+00, -3.132781822897548e-04, -1.252873618194190e-06, -4.257443271952181e-09, -1.271998336969412e-11, -3.310432771159650e-14, -7.059299514044136e-17,
 -9.508456387765563e-20,  1.065628793060526e-22,  1.427050621972528e-24,  6.771742829707998e-27,  2.361197306839315e-29,  1.964347135700496e+00, -1.985999538738842e-04,
 -8.136558736239423e-07, -2.884034397184394e-09, -9.240179332218595e-12, -2.703629605522323e-14, -7.156506223517470e-17, -1.652598403381479e-19, -2.972640574842504e-22,
 -2.036608965624331e-25,  1.503002073093503e-27,  1.021466686751570e-29,  1.980733523308777e+00, -1.083074836688716e-04, -4.519084512594007e-07, -1.652509300087051e-09,
 -5.561917752954104e-12, -1.755298000554091e-14, -5.224566438173226e-17, -1.463174576287884e-19, -3.812696115545289e-22, -9.000542696812297e-25, -1.798871917339783e-27,
 -2.355881455003159e-30,  1.992142475565980e+00, -4.445182633215279e-05, -1.878144922628715e-07, -7.014039409271037e-10, -2.438238836750455e-12, -8.065686896860921e-15,
 -2.566575890671035e-17, -7.898560966765768e-20, -2.355987358869312e-22, -6.810287750616731e-25, -1.903245323876209e-27, -5.115847984692315e-30,  1.998506798632888e+00,
 -8.477130740277305e-06, -3.606628444680357e-08, -1.362537270222589e-10, -4.819479611216013e-13, -1.633960378361526e-15, -5.375873082164905e-18, -1.728942316141916e-20,
 -5.460399108953712e-23, -1.698599288383161e-25, -5.215153135178974e-28, -1.582538953361784e-30,  5.137986587647811e-04, -2.620828685134104e-06,  1.002394774773732e-08,
 -3.406839378816071e-11,  1.085074107840831e-13, -3.316131094051087e-16,  9.847414949571460e-19, -2.862721627420651e-21,  8.186091609521561e-24, -2.310076256583331e-26,
  6.447862699221867e-29, -1.783068691807381e-31,  4.621729621996060e-03, -2.353190708470095e-05,  8.966761711842634e-08, -3.028381477420865e-10,  9.553606222071178e-13,
 -2.880472739524522e-15,  8.398818727712713e-18, -2.384017145745512e-20,  6.612906875076835e-23, -1.796348980610921e-25,  4.783031236336565e-28, -1.248314078731723e-30,
  1.282447717668121e-02, -6.505837187367130e-05,  2.460494115639199e-07, -8.204619405823236e-10,  2.538181006330140e-12, -7.440192476224401e-15,  2.086319275405092e-17,
 -5.616860742657391e-20,  1.451252983576376e-22, -3.583205951131640e-25,  8.373138689382171e-28, -1.816117206902976e-30,  2.509579637555749e-02, -1.266116281979427e-04,
  4.734379192391471e-07, -1.548204231545709e-09,  4.645643122438314e-12, -1.301380367209062e-14,  3.415853925548699e-17, -8.348793189405354e-20,  1.863509920969121e-22,
 -3.618670692527832e-25,  5.239422996956213e-28, -8.788061444376585e-32,  4.139627985932089e-02, -2.073157707852356e-04,  7.634339587754598e-07, -2.430655804310872e-09,
  6.986081239534407e-12, -1.829390391220654e-14,  4.313675801894253e-17, -8.778072836980010e-20,  1.340558564641714e-22, -4.259113365347644e-26, -7.615978043016434e-28,
  4.158860854603850e-30,  6.167331153617641e-02, -3.060160068875177e-04,  1.105204564600181e-06, -3.398839819313565e-09,  9.215696528681441e-12, -2.186257637371891e-14,
  4.290021404078230e-17, -5.536251071167594e-20, -3.779786579841445e-23,  5.937031066083018e-25, -2.652613560203776e-27,  8.631947614943715e-30,  8.586100751879866e-02,
 -4.212899482840526e-04,  1.485789002656124e-06, -4.374144528227756e-09,  1.097266477678874e-11, -2.241777442794220e-14,  3.001615990095665e-17,  1.777208582252326e-20,
 -3.067687044166629e-22,  1.342650823689845e-24, -4.115014681888859e-27,  9.327996248409407e-30,  1.138801466731954e-01, -5.514618193168975e-04,  1.890471574455824e-06,
 -5.272909426330279e-09,  1.191440237641780e-11, -1.899699640929034e-14,  3.531650342774157e-18,  1.227485713473678e-19, -5.987611504514491e-22,  1.845632463178189e-24,
 -3.868124457949876e-27,  2.964140620124033e-30,  1.456380937738901e-01, -6.946196324692872e-04,  2.303214507447373e-06, -6.011455717865549e-09,  1.175488060251936e-11,
 -1.116791984092590e-14, -3.442486324442284e-17,  2.378490032118746e-19, -8.038281571660381e-22,  1.720029757035964e-24, -1.086573616109153e-27, -1.019443722835192e-29,
  1.810287189314234e-01, -8.486353825589739e-04,  2.707142689766073e-06, -6.511321503485189e-09,  1.029871128984157e-11,  8.420735009676562e-16, -7.861062571976046e-17,
  3.321773855449472e-19, -8.084952755064058e-22,  7.349432518792077e-25,  3.935726840831331e-27, -2.491319266212958e-29,  2.199323176650370e-01, -1.011188304055165e-03,
  3.085070391986208e-06, -6.704438591040602e-09,  7.468788237591242e-12,  1.609984676327559e-14, -1.212699359716097e-16,  3.724844270592497e-19, -5.363654218085574e-22,
 -1.034512144444882e-24,  9.529640664227220e-27, -3.236207749988439e-29,  2.622155367374917e-01, -1.179791222136501e-03,  3.420058443723315e-06, -6.537972962413997e-09,
  3.324576049825016e-12,  3.301746099056738e-14, -1.533257210982634e-16,  3.318345390762425e-19,  1.523935979572657e-23, -3.145302249976911e-24,  1.305013714458228e-26,
 -2.431537518884004e-29,  3.077313116500744e-01, -1.351820005647826e-03,  3.695988629386344e-06, -5.978546492111261e-09, -1.931302460369696e-12,  4.950235847305289e-14,
 -1.660036783269774e-16,  1.981583010051636e-19,  7.556161505680278e-22, -4.864502583742227e-24,  1.190658683862130e-26,  1.516250384325503e-30,  3.563188225111384e-01,
 -1.524546097836981e-03,  3.898140382176900e-06, -5.015565329401323e-09, -7.959727283490246e-12,  6.319624795431582e-14, -1.526323059873631e-16, -1.952353231607627e-20,
  1.507833732775189e-21, -5.387995381418629e-24,  4.878326055162771e-27,  3.789282557987281e-29,  4.078034758349190e-01, -1.695172057450543e-03,  4.013753254458955e-06,
 -3.663402150302389e-09, -1.430552147525433e-11,  7.177928311597189e-14, -1.102965404957406e-16, -2.891774196764003e-19,  2.045710783948563e-21, -4.144004893624311e-24,
 -6.858933576813643e-27,  6.887362464420671e-29,  4.619969206889580e-01, -1.860869987336320e-03,  4.032557212123597e-06, -1.962216716813536e-09, -2.043102071234964e-11,
  7.330467749308292e-14, -4.100678629472315e-17, -5.593484635673712e-19,  2.154623867100068e-21, -1.079308094979656e-24, -1.957581080511489e-26,  7.594497931852073e-29,
  5.186971084737978e-01, -2.018822659232298e-03,  3.947251647925123e-06,  2.274717918215115e-11, -2.576084950189121e-11,  6.652053813313661e-14,  4.791066004918991e-17,
 -7.682948203380749e-19,  1.701350379296746e-21,  3.189915354056003e-24, -2.800766788497524e-26,  4.750919172587562e-29,  5.776884064679851e-01, -2.166267061316328e-03,
  3.753913261922325e-06,  2.203480035589778e-09, -2.973471265954660e-11,  5.113200099981127e-14,  1.443897223059979e-16, -8.573014139777834e-19,  6.923662422474748e-22,
  7.453179449226364e-24, -2.736617182399748e-26, -1.268781631354509e-29,  6.387417760792962e-01, -2.300539999193901e-03,  3.452312762262952e-06,  4.473145776732770e-09,
 -3.186386225367342e-11,  2.795898304355915e-14,  2.331964658785670e-16, -7.855152504808525e-19, -7.003055570399737e-22,  1.022772797131113e-23, -1.563856968105576e-26,
 -8.324380597364303e-29,  7.016150274773993e-01, -2.419125271766919e-03,  3.046120856102424e-06,  6.711547499569695e-09, -3.178600319970212e-11, -1.046253726831314e-15,
  2.983358765786781e-16, -5.427951891297236e-19, -2.160223804472216e-21,  1.025495944342945e-23,  4.842543867473275e-27, -1.318577840482286e-28,  7.660531629049656e-01,
 -2.519701822098768e-03,  2.542985393468179e-06,  8.791915969449826e-09, -2.931289106975809e-11, -3.294208045615904e-14,  3.259422855140152e-16, -1.569701730173567e-19,
 -3.296751380094201e-21,  7.013400494591153e-24,  2.747150756450331e-26, -1.297469162836798e-28,  8.317888214274555e-01, -2.600192132199522e-03,  1.954463955519291e-06,
  1.058870306362199e-08, -2.446488038497335e-11, -6.410042628032278e-14,  3.071502291502853e-16,  3.072718770441603e-19, -3.750854992391311e-21,  1.050070626558146e-24,
  4.342156971602428e-26, -6.759874927799328e-29,  8.985428381334761e-01, -2.658809993008156e-03,  1.295799780938051e-06,  1.198595164483871e-08, -1.748730069700551e-11,
 -9.064476321094011e-14,  2.403676021857207e-16,  7.589199223569159e-19, -3.308679154347592e-21, -6.036122830182956e-24,  4.513616395327798e-26,  3.545666543157258e-29,
  9.660249307784573e-01, -2.694106641510525e-03,  5.855337979166783e-07,  1.288571517478165e-08, -8.844823663084124e-12, -1.089738197510575e-13,  1.324061745026240e-16,
  1.099325879123967e-18, -1.987333260910558e-21, -1.201795042197841e-23,  2.990260510138895e-26,  1.364094706547133e-28,  1.033934526510167e+00, -2.705014122156160e-03,
 -1.550482905687062e-07,  1.321592549672926e-08,  8.080790152723425e-13, -1.163010452392003e-13, -1.919728586741171e-18,  1.245353234139162e-18, -6.022426736044488e-23,
 -1.477456286284655e-23,  1.825265456526363e-27,  1.867461855534462e-28,  1.101961740558050e+00, -2.690884607328757e-03, -9.026274861054559e-07,  1.293706711807592e-08,
  1.068000253505141e-11, -1.111272213843230e-13, -1.418474399686423e-16,  1.151474794388377e-18,  1.995910229122040e-21, -1.309510281256752e-23, -2.903565587730316e-26,
  1.570125394096343e-28,  1.169788517542208e+00, -2.651524310894097e-03, -1.632706632694907e-06,  1.204702218778526e-08,  1.991538572221984e-11, -9.356279977857356e-14,
 -2.641522433442091e-16,  8.247203622839803e-19,  3.626164222168131e-21, -7.236862611668140e-24, -5.042218411628420e-26,  5.481157444663739e-29,  1.237089944298576e+00,
 -2.587220560416464e-03, -2.320584992069552e-06,  1.058351167047214e-08,  2.768090393325692e-11, -6.543003519089235e-14, -3.474946939571480e-16,  3.274561273629166e-19,
  4.362528591906179e-21,  1.026098385335813e-24, -5.315609287087745e-26, -7.505298709851214e-29,  1.303535740769612e+00, -2.498760569057424e-03, -2.942418377795026e-06,
  8.623681071162137e-09,  3.325663728049335e-11, -3.010314547023212e-14, -3.767818056953684e-16, -2.342692414933356e-19,  3.977490508655866e-21,  8.952228968467236e-24,
 -3.556148335860023e-26, -1.709685406987934e-28,  1.368791932534367e+00, -2.387440479350816e-03, -3.476321570533666e-06,  6.280564393963639e-09,  3.612137950306019e-11,
  7.914879135902999e-15, -3.465754187491205e-16, -7.351790079159947e-19,  2.571528311857000e-21,  1.382209255446581e-23, -4.735604142896369e-27, -1.862825813852777e-28,
  1.432522704928578e+00, -2.255063349410020e-03, -3.903461338800644e-06,  3.696401901038270e-09,  3.602082047695654e-11,  4.363305006874646e-14, -2.626782278123817e-16,
 -1.062367519729125e-18,  5.567025413716161e-22,  1.399591459435727e-23,  2.630919207058470e-26, -1.151514777715452e-28,  1.494392434443316e+00, -2.103924927568738e-03,
 -4.209081841962205e-06,  1.033071655269122e-09,  3.300818546487410e-11,  7.233919948151404e-14, -1.413570633055869e-16, -1.145522751267907e-18, -1.467499864186869e-21,
  9.590721049175330e-24,  4.455767792234095e-26,  3.313522968133085e-30,  1.554067888232809e+00, -1.936786321126130e-03, -4.383400394662853e-06, -1.539800767654332e-09,
  2.744940065121889e-11,  9.036653511601413e-14, -6.178834243483616e-18, -9.766981828663570e-19, -2.909594602012405e-21,  2.452294558599118e-24,  4.314068723170950e-26,
  1.065877516769244e-28,  1.611220577193014e+00, -1.756833011794290e-03, -4.422311391902178e-06, -3.858195952046433e-09,  1.998889222990644e-11,  9.571912895724218e-14,
  1.169702257450664e-16, -6.128987315676334e-19, -3.385248853658884e-21, -4.608591978529354e-24,  2.452416313058244e-26,  1.441765880341075e-28,  1.665529242322029e+00,
 -1.567620102212811e-03, -4.327840363880583e-06, -5.777411432889795e-09,  1.147734567747286e-11,  8.842795275460255e-14,  2.055884891223476e-16, -1.596298112850011e-19,
 -2.845262384572207e-21, -9.003733389249286e-24, -1.058646705126861e-27,  1.055831376936099e-28,  1.716682448119552e+00, -1.373004185454123e-03, -4.108299129643398e-06,
 -7.184859454148311e-09,  2.868498203737255e-12,  7.055013409825561e-14,  2.456016636464415e-16,  2.603540043732149e-19, -1.580438706135189e-21, -9.444734980493385e-24,
 -2.116360322913924e-26,  2.332930807219975e-29,  1.764381250850151e+00, -1.177062796293063e-03, -3.778106959156498e-06, -8.010635971442831e-09, -4.902569803889400e-12,
  4.578910761549637e-14,  2.344200964439984e-16,  5.436011263997436e-19, -9.852834733198720e-23, -6.404051502349133e-24, -2.761413254497207e-26, -5.044675089593939e-29,
  1.808341903852593e+00, -9.840030049283793e-04, -3.357261175484700e-06, -8.234642997301448e-09, -1.104312267127801e-11,  1.879092864669494e-14,  1.811291611287161e-16,
  6.359224069199847e-19,  1.078472743941774e-21, -1.743953925265320e-24, -2.025086907493648e-26, -7.763925547071646e-29,  1.848298557031205e+00, -7.980613193287128e-04,
 -2.870462839480815e-06, -7.889297498559286e-09, -1.501010634217300e-11, -5.754207467048527e-15,  1.036731032255503e-16,  5.455795887488219e-19,  1.612877599461316e-21,
  2.283791368679078e-24, -5.928426429661527e-27, -5.525600011325132e-29,  1.884005903559628e+00, -6.233976339461261e-04, -2.345927625637615e-06, -7.057254467133545e-09,
 -1.658387823099011e-11, -2.402434473945848e-14,  2.374187969472680e-17,  3.351332499157684e-19,  1.462131146564197e-21,  4.138637427757584e-24,  6.344080762979916e-27,
 -1.082872848084892e-29,  1.915241724079097e+00, -4.639864587017073e-04, -1.813936810215293e-06, -5.864077353513649e-09, -1.589520831427397e-11, -3.379645805120567e-14,
 -3.922676661577157e-17,  9.506823782992953e-20,  8.569796500058151e-22,  3.619013775344212e-24,  1.086858072231906e-26,  2.185892228471653e-29,  1.941809277967742e+00,
 -3.235090392689443e-04, -1.305206205357494e-06, -4.466352649212620e-09, -1.339922569469473e-11, -3.483007328724621e-14, -7.319951480036912e-17, -9.079820470935230e-20,
  1.630712649951170e-22,  1.719639917308452e-24,  7.881586967349081e-27,  2.688870613267212e-29,  1.963539494601225e+00, -2.052501895520778e-04, -8.491694941977410e-07,
 -3.036297987404882e-09, -9.798461260013082e-12, -2.881046609932515e-14, -7.632652627246630e-17, -1.748770786316894e-19, -3.033995689403411e-22, -1.339090046360788e-25,
  2.001218003486696e-27,  1.249838363795038e-29,  1.980292935076656e+00, -1.120036116971523e-04, -4.722843164837852e-07, -1.744378007415967e-09, -5.925855414549280e-12,
 -1.885744772826789e-14, -5.651833324800570e-17, -1.590506041760110e-19, -4.149913725570695e-22, -9.740411880102557e-25, -1.899281566876906e-27, -2.191718894864056e-30,
  1.991961608969350e+00, -4.598868534146471e-05, -1.964708443399564e-07, -7.417405079337019e-10, -2.605895997137355e-12, -8.709079390661389e-15, -2.798669729906341e-17,
 -8.693218645785838e-20, -2.615420861819339e-22, -7.618516107392440e-25, -2.142772415588994e-27, -5.785474221937271e-30,  1.998472302505692e+00, -8.772334814590249e-06,
 -3.774869775532069e-08, -1.442335064206680e-10, -5.159576355917275e-13, -1.768993824158759e-15, -5.885388313909805e-18, -1.913875662148765e-20, -6.111185190724877e-23,
 -1.921830149219059e-25, -5.964348504739268e-28, -1.829210970324879e-30,  5.034731790029204e-04, -2.542243367880674e-06,  9.625328955406289e-09, -3.238407594043546e-11,
  1.021051436866001e-13, -3.089123380853234e-16,  9.081310991149484e-19, -2.613589902329418e-21,  7.399059139534018e-24, -2.067185776458395e-26,  5.712603746360002e-29,
 -1.564105369476611e-31,  4.529014021006214e-03, -2.282884682902927e-05,  8.612340771991677e-08, -2.880025240970643e-10,  8.997140253382688e-13, -2.686678110927516e-15,
  7.759973282185648e-18, -2.182392325549956e-20,  5.999375326301843e-23, -1.615576588503504e-25,  4.266046627651388e-28, -1.104682239521687e-30,  1.256811908463489e-02,
 -6.312867950403070e-05,  2.364427098139729e-07, -7.810147951081632e-10,  2.394259595016812e-12, -6.957835421030675e-15,  1.935359384355402e-17, -5.172467986031589e-20,
  1.328098080557463e-22, -3.263777288583183e-25,  7.610060036921306e-28, -1.654568543389685e-30,  2.459680896415904e-02, -1.228971945277021e-04,  4.552970032327613e-07,
 -1.475912390273640e-09,  4.393379179761832e-12, -1.222138872265923e-14,  3.190243276302630e-17, -7.772910099516969e-20,  1.736996788025764e-22, -3.410306491116460e-25,
  5.168646113484431e-28, -2.272509065311209e-31,  4.057904963612878e-02, -2.013230978249345e-04,  7.349248588934067e-07, -2.321750105743353e-09,  6.630359395009041e-12,
 -1.728763291683792e-14,  4.073868423747839e-17, -8.352100770519067e-20,  1.320164118310245e-22, -6.960388775404304e-26, -5.940059122114045e-28,  3.476779935693657e-30,
  6.046667596530317e-02, -2.973350408828787e-04,  1.065288944099798e-06, -3.254831274459555e-09,  8.788614865232647e-12, -2.085169068257418e-14,  4.133620162958817e-17,
 -5.624982329646091e-20, -1.824572194319990e-23,  4.948865445963394e-25, -2.295648337178563e-27,  7.611195524035910e-30,  8.419929208362012e-02, -4.096106444552986e-04,
  1.434337975608571e-06, -4.202129444841009e-09,  1.053154792625352e-11, -2.169248089926952e-14,  3.038339045952931e-17,  8.697878753821352e-21, -2.612987404919531e-22,
  1.186085974283218e-24, -3.717574045530779e-27,  8.731653700284489e-30,  1.117041507371078e-01, -5.365879344961367e-04,  1.828327923968918e-06, -5.085312772071831e-09,
  1.153557750508074e-11, -1.887309806931997e-14,  6.710142560668582e-18,  1.046217075134896e-19, -5.350696662115990e-22,  1.693768158362898e-24, -3.719356235096503e-27,
  3.752390414089567e-30,  1.428960142966373e-01, -6.764792862124956e-04,  2.232197997195746e-06, -5.825207172663170e-09,  1.152378489975379e-11, -1.191704904199035e-14,
 -2.811596201651640e-17,  2.131080218615073e-19, -7.427902169931135e-22,  1.668391424812493e-24, -1.476462983759952e-27, -7.601409713763051e-30,  1.776770007793621e-01,
 -8.272879825940917e-04,  2.629995740239988e-06, -6.346506789288927e-09,  1.029742458636922e-11, -9.358679521142347e-16, -6.966768276924826e-17,  3.067571691257048e-19,
 -7.794578523190146e-22,  8.715338504317162e-25,  2.920069892813289e-27, -2.130701446138518e-29,  2.159364189367611e-01, -9.868274989994147e-04,  3.005344255823339e-06,
 -6.582516629010988e-09,  7.762515022638924e-12,  1.331255172017957e-14, -1.110857539058106e-16,  3.547956824348349e-19, -5.670829375349155e-22, -6.810614883580478e-25,
  8.161609502073037e-27, -2.979405206820612e-29,  2.575505972392872e-01, -1.152743624100977e-03,  3.341943079982751e-06, -6.479693729847343e-09,  3.948879551072184e-12,
  2.944909411926252e-14, -1.440438430913023e-16,  3.306091381434701e-19, -8.885634365213668e-23, -2.645020443114907e-24,  1.195741481166520e-26, -2.521591238371219e-29,
  3.023827124318426e-01, -1.322539518311866e-03,  3.624092642070241e-06, -6.001741489333637e-09, -9.806333044063999e-13,  4.558742516509677e-14, -1.601424009817055e-16,
  2.196280073946610e-19,  5.890668150798303e-22, -4.388651162392230e-24,  1.184502112901237e-26, -4.109778372808933e-30,  3.502826242514208e-01, -1.493603792196534e-03,
  3.837230528932970e-06, -5.133008688843328e-09, -6.732450934208312e-12,  5.953178722841864e-14, -1.525323286295572e-16,  2.566441913413918e-20,  1.317755153684063e-21,
 -5.162244517005009e-24,  6.343366414663123e-27,  2.885291076058285e-29,  4.010867238879570e-01, -1.663241657662982e-03,  3.968465999822375e-06, -3.880952256962771e-09,
 -1.289702519817931e-11,  6.904226022603821e-14, -1.174998010703691e-16, -2.261487907459242e-19,  1.892296291337663e-21, -4.360197591980648e-24, -4.011627149731281e-27,
  6.051361933669950e-29,  4.546178048274576e-01, -1.828709162229541e-03,  4.007097427194480e-06, -2.277442957999282e-09, -1.897599729941189e-11,  7.214032351424943e-14,
 -5.571015274473220e-17, -4.911668018797091e-19,  2.102474575295418e-21, -1.796076424223012e-24, -1.627980967472880e-26,  7.358933692114024e-29,  5.106849658336295e-01,
 -1.987250459654102e-03,  3.945095658737297e-06, -3.787278534459126e-10, -2.442065045617691e-11,  6.741849748058670e-14,  2.717635672297009e-17, -7.122262036131572e-19,
  1.796547235250074e-21,  2.113754921230711e-24, -2.574730798366961e-26,  5.479568628939164e-29,  5.690835569852239e-01, -2.136137997117499e-03,  3.777534824772018e-06,
  1.736085924028726e-09, -2.867934950238214e-11,  5.431204500410027e-14,  1.207342882926772e-16, -8.310647268161427e-19,  9.408871961333761e-22,  6.352244132447226e-24,
 -2.756376488037604e-26,  3.349141523422539e-30,  6.295951808685457e-01, -2.272715408633049e-03,  3.502950998224998e-06,  3.968093986801476e-09, -3.125050864945846e-11,
  3.328956852297510e-14,  2.109427537964714e-16, -8.021614256569271e-19, -3.442003328826528e-22,  9.534367856881914e-24, -1.889492494230550e-26, -6.478586997878872e-29,
  6.919877621968692e-01, -2.394442795520005e-03,  3.123608524985431e-06,  6.203187774195036e-09, -3.173659764209000e-11,  5.923958938151560e-15,  2.822255325623022e-16,
 -6.059892743200733e-19, -1.788928673805487e-21,  1.033576073906430e-23, -7.199697813055460e-28, -1.205409000527339e-28,  7.560157002497819e-01, -2.498943947409719e-03,
  2.645653977973253e-06,  8.318062302431465e-09, -2.989392313169814e-11, -2.518388803709262e-14,  3.201095794671577e-16, -2.582256776209707e-19, -3.025879025040462e-21,
  7.996641672375553e-24,  2.166298264267373e-26, -1.335367636852285e-28,  8.214201195437016e-01, -2.584054912072716e-03,  2.079138762293574e-06,  1.018741211493283e-08,
 -2.567254586755811e-11, -5.663909375849048e-14,  3.140814960200600e-16,  1.881783776385282e-19, -3.682562776546365e-21,  2.721236005602973e-24,  3.998992667949532e-26,
 -8.774314108855098e-29,  8.879292349960959e-01, -2.647873161336147e-03,  1.437893628795731e-06,  1.169197211814581e-08, -1.924084914536001e-11, -8.463309610991651e-14,
  2.601049037117038e-16,  6.499163746892994e-19, -3.493183203556093e-21, -4.207994052831256e-24,  4.606060576588144e-26,  6.686058507106816e-30,  9.552588484542150e-01,
 -2.688806427057884e-03,  7.392419417784746e-07,  1.272694517392174e-08, -1.099006810984691e-11, -1.054342754929372e-13,  1.622336445838185e-16,  1.029051070958305e-18,
 -2.397063114692269e-21, -1.070844601006871e-23,  3.540199761526806e-26,  1.129998062992884e-28,  1.023112993736517e+00, -2.705620100994405e-03,  3.543656549696378e-09,
  1.321025593596824e-08, -1.515581371112385e-12, -1.159293883697488e-13,  3.284341487389396e-17,  1.234946021346923e-18, -5.888223803593765e-22, -1.453821304793899e-23,
  9.956622016581102e-27,  1.818616695854302e-28,  1.091184747183033e+00, -2.697481913095420e-03, -7.464313133224704e-07,  1.308999292038501e-08,  8.426061689634509e-12,
 -1.141378904697358e-13, -1.087843667687006e-16,  1.207590849725475e-18,  1.505298538234242e-21, -1.411264046259088e-23, -2.170906835239654e-26,  1.751451517655376e-28,
  1.159157220023433e+00, -2.664002434319153e-03, -1.486293334625570e-06,  1.235036194087393e-08,  1.798267034798158e-11, -9.961248988347691e-14, -2.394774625372619e-16,
  9.362052336774229e-19,  3.330004265174038e-21, -9.195661744883850e-24, -4.727581000690243e-26,  8.801129444306132e-29,  1.226704747538581e+00, -2.605269804967966e-03,
 -2.190970127685451e-06,  1.101548759617565e-08,  2.628972879124094e-11, -7.364408837328652e-14, -3.363689168723174e-16,  4.672317787882230e-19,  4.360480575960380e-21,
 -1.157273564243919e-24, -5.578475822942537e-26, -4.379936171535346e-29,  1.293494287905288e+00, -2.521876982541913e-03, -2.835763032827292e-06,  9.150477473131031e-09,
  3.256369097317501e-11, -3.920995305570469e-14, -3.815130208806481e-16, -1.021221260180894e-19,  4.272382099819034e-21,  7.382547212063203e-24, -4.283091291524810e-26,
 -1.583781423210431e-28,  1.359187040677460e+00, -2.414939750748568e-03, -3.397483404196083e-06,  6.859314086589690e-09,  3.619488160102810e-11, -6.401943449762509e-16,
 -3.659339358636461e-16, -6.449814174491001e-19,  3.063701090173075e-21,  1.346468341274051e-23, -1.322611354725849e-26, -1.987955285856032e-28,  1.423440290992633e+00,
 -2.286103751119224e-03, -3.855618856496154e-06,  4.279363712781103e-09,  3.682804165901332e-11,  3.697430271756638e-14, -2.920979816619665e-16, -1.036298720504293e-18,
  1.078197113506954e-21,  1.493817959413026e-23,  2.058799971773763e-26, -1.447961330871925e-28,  1.485909480755551e+00, -2.137538907935045e-03, -4.193469079532926e-06,
  1.572581568373722e-09,  3.441841968764733e-11,  6.855675916027776e-14, -1.740347836057288e-16, -1.186614713862462e-18, -1.090192530471400e-21,  1.136761901578977e-23,
  4.407410876162295e-26, -2.593816453692290e-29,  1.546250502238673e+00, -1.971919831225444e-03, -4.399183271457428e-06, -1.086169255106051e-09,  2.925297929758073e-11,
  8.987964511455842e-14, -3.481418327863619e-17, -1.068050663515841e-18, -2.789150484123174e-21,  4.268344512720632e-24,  4.756860653374282e-26,  9.378315337164388e-29,
  1.604122202809442e+00, -1.792391112902341e-03, -4.466627157442343e-06, -3.522912143481422e-09,  2.192989372049649e-11,  9.830809312046108e-14,  9.826895057362760e-17,
 -7.236793431684800e-19, -3.531946960980144e-21, -3.498053034904482e-24,  3.106381903402025e-26,  1.525409954291641e-28,  1.659189081970781e+00, -1.602516882890685e-03,
 -4.396008249641882e-06, -5.579359050833502e-09,  1.329482948602821e-11,  9.329785284752632e-14,  1.997954448124388e-16, -2.558630780057078e-19, -3.168983690434727e-21,
 -8.947036859476164e-24,  4.046330427212123e-27,  1.265598262349688e-28,  1.711124153787864e+00, -1.406214562184743e-03, -4.194194460239763e-06, -7.127352825190672e-09,
  4.339004878343098e-12,  7.652601814935122e-14,  2.521312726409868e-16,  2.041787364932284e-19, -1.935391655503035e-21, -1.026544158911226e-23, -1.973467978551110e-26,
  4.214699270106388e-29,  1.759611939357006e+00, -1.207673424380823e-03, -3.874674012394855e-06, -8.081439981411752e-09, -3.929296714445498e-12,  5.159726287820210e-14,
  2.495605839784574e-16,  5.365420554801832e-19, -3.494769883736180e-22, -7.551396056809691e-24, -2.970794603179027e-26, -4.423914428672248e-29,  1.804351545620271e+00,
 -1.011259330798418e-03, -3.457123847417500e-06, -8.408084095689003e-09, -1.062237094022080e-11,  2.335553443203925e-14,  1.994075521453443e-16,  6.692658811330825e-19,
  1.000268677248649e-21, -2.624257374150701e-24, -2.381111632531997e-26, -8.405953439289293e-29,  1.845059778987574e+00, -8.214077989152763e-04, -2.966578725087820e-06,
 -8.130239383701251e-09, -1.509904111475366e-11, -3.076831871835826e-15,  1.196839059998474e-16,  5.984564272119366e-19,  1.690211363866397e-21,  1.994901934322090e-24,
 -8.595515123022659e-27, -6.616655390819170e-29,  1.881474235414413e+00, -6.425083502801589e-04, -2.432222478384872e-06, -7.326406167207581e-09, -1.705787907764458e-11,
 -2.333650839505759e-14,  3.380338698544411e-17,  3.843532343218582e-19,  1.615557877289977e-21,  4.380969547760804e-24,  5.722789586768197e-27, -1.766108221670848e-29,
  1.913356303413547e+00, -4.787838040912800e-04, -1.885854147201254e-06, -6.123858309161078e-09, -1.658031974736590e-11, -3.470273525432353e-14, -3.616073385151966e-17,
  1.246619284095316e-19,  9.953217464858327e-22,  4.073032122269168e-24,  1.183226996299344e-26,  2.184680545355006e-29,  1.940494013852690e+00, -3.341687719944589e-04,
 -1.360112062192518e-06, -4.686409377256754e-09, -1.411359767599626e-11, -3.661672073762702e-14, -7.565905440637084e-17, -8.452619006885547e-20,  2.309475653469588e-22,
  2.059601597062441e-24,  9.142715034478103e-27,  3.048831437379630e-29,  1.962704672551293e+00, -2.121919974374105e-04, -8.865650642349639e-07, -3.197784256550399e-09,
 -1.039339125625267e-11, -3.070216239565804e-14, -8.135961559768139e-17, -1.846464260775630e-19, -3.066399562044958e-22, -4.209438011999436e-26,  2.609342156964590e-27,
  1.522208797179235e-29,  1.979837229194144e+00, -1.158672573558236e-04, -4.937984235446451e-07, -1.842284127171389e-09, -6.316937390638944e-12, -2.026886226734417e-14,
 -6.116304341940946e-17, -1.729062227239868e-19, -4.514469328245489e-22, -1.051868416773988e-24, -1.990050228404860e-27, -1.912491503020962e-30,  1.991774453303775e+00,
 -4.759677792335938e-05, -2.056277649620530e-07, -7.848656361834350e-10, -2.786996551933997e-12, -9.410941022891214e-15, -3.054221340036688e-17, -9.575741268848551e-20,
 -2.905748474906364e-22, -8.528700649892539e-25, -2.413670067459263e-27, -6.543512584899526e-30,  1.998436598023786e+00, -9.081390685070522e-06, -3.953022466877963e-08,
 -1.527797284085358e-10, -5.527945817686847e-13, -1.916901307757111e-15, -6.449725466660091e-18, -2.120980002879519e-20, -6.848000789788767e-23, -2.177317233247457e-25,
 -6.830999115303336e-28, -2.117570485560052e-30,  4.934557882037709e-04, -2.466767861258153e-06,  9.246322024872743e-09, -3.079865982126695e-11,  9.613905617881138e-14,
 -2.879692751041379e-16,  8.381565522286219e-19, -2.388299097593273e-21,  6.694397544655249e-24, -1.851866256083108e-26,  5.067228425000071e-29, -1.373797649082553e-31,
  4.439055060209442e-03, -2.215344298523580e-05,  8.275200898932211e-08, -2.740270531127222e-10,  8.477944588292919e-13, -2.507559911575868e-15,  7.174929223529749e-18,
 -1.999397973000140e-20,  5.447347008162482e-23, -1.454272529475706e-25,  3.808348237208091e-28, -9.784425735274004e-31,  1.231932899850715e-02, -6.127398571143056e-05,
  2.272958694470365e-07, -7.437951420847668e-10,  2.259632874177996e-12, -6.510259071013573e-15,  1.796307631947218e-17, -4.765702431371857e-20,  1.215909977304840e-22,
 -2.973488080352587e-25,  6.915236490642449e-28, -1.505779494982016e-30,  2.411239443166027e-02, -1.193244856072981e-04,  4.379998855950530e-07, -1.407532873645471e-09,
  4.156434898049674e-12, -1.148123041814894e-14,  2.980201805840337e-17, -7.236317630007198e-20,  1.617920053097059e-22, -3.205888384296514e-25,  5.044734484951165e-28,
 -3.306768358378383e-31,  3.978534210140688e-02, -1.955533654370842e-04,  7.076891322169430e-07, -2.218378040008394e-09,  6.294197051967691e-12, -1.633749265442751e-14,
  3.845883166381770e-17, -7.934087165059305e-20,  1.291182227932137e-22, -9.048250772857405e-26, -4.541583568290421e-28,  2.895334264648123e-30,  5.929413639117960e-02,
 -2.889666020750433e-04,  1.027061086856031e-06, -3.117496341198703e-09,  8.381373891996946e-12, -1.987857191642436e-14,  3.975558817885960e-17, -5.656571585075095e-20,
 -2.004503206663257e-24,  4.094810159416878e-25, -1.981313822294422e-27,  6.693139119224919e-30,  8.258348355253819e-02, -3.983348109975656e-04,  1.384909262359857e-06,
 -4.037055788723577e-09,  1.010500532936217e-11, -2.096126345093426e-14,  3.051608801017001e-17,  9.915455443843463e-22, -2.211853594205639e-22,  1.044885295640816e-24,
 -3.346980379255305e-27,  8.111293616328970e-30,  1.095866701540536e-01, -5.222022970658183e-04,  1.768399160882638e-06, -4.903753515755036e-09,  1.115995349593282e-11,
 -1.867878124292217e-14,  9.408803044412222e-18,  8.844670895583096e-20, -4.767305373123722e-22,  1.548470794575410e-24, -3.541598478992085e-27,  4.290478877363880e-30,
  1.402253740049610e-01, -6.588981960519592e-04,  2.163393815888555e-06, -5.642768024156279e-09,  1.127916576972936e-11, -1.252285869005429e-14, -2.247276294079802e-17,
  1.902877164302949e-19, -6.838656489610204e-22,  1.603311783798824e-24, -1.761706274373835e-27, -5.429532335686086e-30,  1.744094503979231e-01, -8.065498500970202e-04,
  2.554825307437796e-06, -6.181985711439015e-09,  1.026266826802798e-11, -2.507610696980435e-15, -6.142281201723327e-17,  2.823372901201967e-19, -7.461970844864555e-22,
  9.705743896936009e-25,  2.055800366464335e-27, -1.803337099134305e-29,  2.120366971839117e-01, -9.630985750363560e-04,  2.927107583914837e-06, -6.456327895702393e-09,
  8.002899466933045e-12,  1.076363393904808e-14, -1.014087792651656e-16,  3.363172272540137e-19, -5.860336011923827e-22, -3.800320655515682e-25,  6.909380637598313e-27,
 -2.711556488699503e-29,  2.529926029493070e-01, -1.126317987107027e-03,  3.264584684205906e-06, -6.411984494618943e-09,  4.504038710579067e-12,  2.610272051346674e-14,
 -1.348402641826882e-16,  3.263323379015526e-19, -1.757360654664858e-22, -2.189006739145234e-24,  1.084219882931958e-26, -2.536556821842635e-29,  2.971500834216129e-01,
 -1.293835059552361e-03,  3.552007020461322e-06, -6.010344332525191e-09, -1.068104601493154e-13,  4.181978989251574e-14, -1.537520167389248e-16,  2.360412875107773e-19,
  4.395474104025922e-22, -3.919856325771438e-24,  1.156237638995027e-26, -8.552649622896056e-30,  3.443692121948518e-01, -1.463154074411173e-03,  3.775026756929371e-06,
 -5.231401392118955e-09, -5.578340837515473e-12,  5.588422968143460e-14, -1.512509458599616e-16,  6.491043722071592e-20,  1.136765102014287e-21, -4.885568715409132e-24,
  7.431580925822769e-27,  2.077439472441375e-29,  3.944969529455674e-01, -1.631683619425009e-03,  3.920701524302079e-06, -4.076413149936641e-09, -1.154485810723284e-11,
  6.615297553140215e-14, -1.230080072287706e-16, -1.681326937477197e-19,  1.733059859047856e-21, -4.469896041861469e-24, -1.534710672691400e-27,  5.208542065921414e-29,
  4.473669015088738e-01, -1.796766752386581e-03,  3.977993780802857e-06, -2.569593649004147e-09, -1.754763621043684e-11,  7.064578626868283e-14, -6.853149460646676e-17,
 -4.250415627881111e-19,  2.026865372761312e-21, -2.383554426984997e-24, -1.312237609342344e-26,  6.971184200041539e-29,  5.027990475000624e-01, -1.955714413064924e-03,
  3.938251134810173e-06, -7.586425258643368e-10, -2.306733966323717e-11,  6.783798167640735e-14,  8.048926491234939e-18, -6.537131250024770e-19,  1.854700034698594e-21,
  1.133654804795523e-24, -2.322319209301506e-26,  5.953754953259018e-29,  5.605995665936926e-01, -2.105842103639886e-03,  3.795650972774920e-06,  1.286055848808812e-09,
 -2.756599877562324e-11,  5.693403612813702e-14,  9.791885757364839e-17, -7.975096918517830e-19,  1.149796354204238e-21,  5.256865531306829e-24, -2.710479477153661e-26,
  1.712825093373910e-29,  6.205606560938500e-01, -2.244509779924974e-03,  3.547590918462716e-06,  3.473679593765083e-09, -3.053591542620440e-11,  3.808173555062026e-14,
  1.883785614405280e-16, -8.078351629624535e-19, -1.520548647152675e-23,  8.726925631157062e-24, -2.134552841699704e-26, -4.671797527052975e-29,  6.824604280214543e-01,
 -2.369164795295185e-03,  3.195005150802128e-06,  5.696712186446802e-09, -3.155179069326966e-11,  1.248763391474271e-14,  2.645122313789451e-16, -6.572972973629533e-19,
 -1.418602910175443e-21,  1.020475588916766e-23, -5.730882490820707e-27, -1.069063324965348e-28,  7.460628755701910e-01, -2.477387615323042e-03,  2.742585632575253e-06,
  7.836144881432963e-09, -3.032141564720012e-11, -1.759869184155788e-14,  3.115680702015456e-16, -3.502920098804762e-19, -2.723820468612039e-21,  8.745502717094215e-24,
  1.578392934355821e-26, -1.330138452076675e-28,  8.111179303905274e-01, -2.566939872547925e-03,  2.198887092468764e-06,  9.768000241472791e-09, -2.672958979115823e-11,
 -4.905112470209037e-14,  3.177175855895952e-16,  7.220466425422493e-20, -3.556782341828016e-21,  4.238584870649217e-24,  3.576053849017627e-26, -1.038001203992474e-28,
  8.773616296834144e-01, -2.635814157563986e-03,  1.576295429890111e-06,  1.137092237152052e-08, -2.086967770860169e-11, -7.818496512592045e-14,  2.767173785398670e-16,
  5.360663764906841e-19, -3.611511538004040e-21, -2.367909612306449e-24,  4.574310531487329e-26, -2.082900734121279e-29,  9.445164134351987e-01, -2.682284746291500e-03,
  8.908413623625982e-07,  1.253445578891670e-08, -1.305752992871566e-11, -1.012039208452820e-13,  1.899172388353319e-16,  9.464595656392605e-19, -2.755948060281428e-21,
 -9.200493564380495e-24,  3.980395950121606e-26,  8.670180916878422e-29,  1.012291573196611e+00, -2.704958247571443e-03,  1.618448893216945e-07,  1.316751247192072e-08,
 -3.823498906181082e-12, -1.147288141976231e-13,  6.708006814140505e-17,  1.207822054319495e-18, -1.103125187668617e-21, -1.398266745417617e-23,  1.774212510070907e-26,
  1.710871893273766e-28,  1.080383874474885e+00, -2.702822926406804e-03, -5.886182552341592e-07,  1.320641757825551e-08,  6.119960566592113e-12, -1.163379966439130e-13,
 -7.437493314259536e-17,  1.247479255986365e-18,  9.835083851831005e-22, -1.482276357214109e-23, -1.370591722863558e-26,  1.876540591189950e-28,  1.148478374923531e+00,
 -2.675295225731384e-03, -1.336429385912530e-06,  1.262184351471581e-08,  1.593513015898309e-11, -1.050336614653949e-13, -2.118241964072056e-16,  1.037111840537212e-18,
  2.965941074763171e-21, -1.099983807718749e-23, -4.270456126708591e-26,  1.193556402758298e-28,  1.216249459917835e+00, -2.622261786544101e-03, -2.056310475652878e-06,
  1.142390630870531e-08,  2.473725943436123e-11, -8.154423897780720e-14, -3.213422842522620e-16,  6.056667322836256e-19,  4.278279637996021e-21, -3.417239568786912e-24,
 -5.696179376770329e-26, -9.253885161271558e-30,  1.283362115624688e+00, -2.544115069396871e-03, -2.722858680876999e-06,  9.664724752001403e-09,  3.168777801431013e-11,
 -4.838489623818128e-14, -3.824208937828220e-16,  3.850246283875185e-20,  4.505682247120680e-21,  5.535098131144587e-24, -4.940217517814147e-26, -1.392470431951882e-28,
  1.349473457141479e+00, -2.441780530001128e-03, -3.311698911041538e-06,  7.437846648044359e-09,  3.609284989206502e-11, -9.627800406680763e-15, -3.825488344314459e-16,
 -5.393066949364593e-19,  3.536775740320537e-21,  1.275824460040269e-23, -2.214560905455303e-26, -2.056158305670923e-28,  1.414234525530982e+00, -2.316733221608035e-03,
 -3.800707857498948e-06,  4.874137582988358e-09,  3.749509614990248e-11,  2.962015581641225e-14, -3.205494096251727e-16, -9.930460538994291e-19,  1.629182062745653e-21,
  1.562579692583917e-23,  1.358628690537278e-26, -1.731373712572125e-28,  1.477292362486872e+00, -2.171001712170376e-03, -4.171249451110454e-06,  2.134007060949792e-09,
  3.574507655580136e-11,  6.397766990541088e-14, -2.076844701283908e-16, -1.214615666191891e-18, -6.495853614270646e-22,  1.309832832487762e-23,  4.222207577972535e-26,
 -5.877843796811913e-29,  1.538292364845394e+00, -2.007157340440075e-03, -4.409349871210172e-06, -6.037965881659512e-10,  3.103974298428275e-11,  8.867530943083988e-14,
 -6.594337749235133e-17, -1.154469903407267e-18, -2.600291085543276e-21,  6.248607386021250e-24,  5.131010864862087e-26,  7.532135950990345e-29,  1.596880913201085e+00,
 -1.828287114787981e-03, -4.506731554318001e-06, -3.156183526947749e-09,  2.391793235977554e-11,  1.004105126963919e-13,  7.640647157766329e-17, -8.384634784593194e-19,
 -3.633877736269020e-21, -2.119604777734501e-24,  3.789214275378463e-26,  1.571308212645072e-28,  1.652708259570236e+00, -1.637948998436181e-03, -4.461621841262477e-06,
 -5.351456235117606e-09,  1.520809667233405e-11,  9.799521826298395e-14,  1.911634402075823e-16, -3.623815452083982e-19, -3.486764691726540e-21, -8.667559270380153e-24,
  1.008210552150724e-26,  1.477667655123474e-28,  1.705431648571185e+00, -1.440108932128216e-03, -4.279254572500907e-06, -7.045353991606829e-09,  5.930462186982181e-12,
  8.263842755199125e-14,  2.569246018537818e-16,  1.361849542655663e-19, -2.318653119435430e-21, -1.101149170884975e-23, -1.740749025765063e-26,  6.415995065460399e-29,
  1.754718635283091e+00, -1.239059713800424e-03, -3.971993382424360e-06, -8.135722657934193e-09, -2.836247666454045e-12,  5.776547183465577e-14,  2.643846712212816e-16,
  5.207761813506008e-19, -6.431635302998226e-22, -8.776119551091472e-24, -3.145954961233498e-26, -3.480064418948072e-29,  1.800250551271109e+00, -1.039322761677561e-03,
 -3.559024329662782e-06, -8.574038682474634e-09, -1.010586624597293e-11,  2.836971194473962e-14,  2.185795617342810e-16,  6.995717481698216e-19,  8.877446115892452e-22,
 -3.652351918007365e-24, -2.763289620077418e-26, -8.944459293243294e-29,  1.841726058831233e+00, -8.455347907796671e-04, -3.065592614969913e-06, -8.372154458734409e-09,
 -1.513046445641665e-11,  2.838877194558917e-18,  1.372081899730604e-16,  6.536199966315044e-19,  1.755106032167247e-21,  1.589390597843435e-24, -1.176774303866524e-26,
 -7.820481721795928e-29,  1.878864723050161e+00, -6.623224725128839e-04, -2.521792157837941e-06, -7.603018228150465e-09, -1.751559390396415e-11, -2.239009529546840e-14,
  4.531306278071736e-17,  4.386170456753169e-19,  1.777184604327497e-21,  4.591975146283390e-24,  4.765888796760006e-27, -2.612283036290461e-29,  1.911410522680830e+00,
 -4.941691453630512e-04, -1.960955210752708e-06, -6.394741763055814e-09, -1.728275110777399e-11, -3.552496857782005e-14, -3.220159036333212e-17,  1.589515081749711e-19,
  1.150700524919679e-21,  4.565397142367930e-24,  1.278084151179961e-26,  2.113748716995948e-29,  1.939135215310791e+00, -3.452785113430052e-04, -1.417728368876589e-06,
 -4.918185063559777e-09, -1.486427735312901e-11, -3.846003263658899e-14, -7.791065791277616e-17, -7.587626455503665e-20,  3.120095239575680e-22,  2.453269811529484e-24,
  1.056920885465284e-26,  3.440277867522591e-29,  1.961841472435443e+00, -2.194408859634000e-04, -9.259568528154358e-07, -3.369098733365830e-09, -1.102738532370270e-11,
 -3.271794382584699e-14, -8.666716657304937e-17, -1.944616429403222e-19, -3.061069675157487e-22,  7.658792442851427e-26,  3.348353736954080e-27,  1.846107136394558e-29,
  1.979365716909365e+00, -1.199078239243923e-04, -5.165258994313207e-07, -1.946679575883098e-09, -6.737394504850623e-12, -2.179653977493062e-14, -6.621246904698579e-17,
 -1.879739219614517e-19, -4.907662937242576e-22, -1.133039267147000e-24, -2.065368803488514e-27, -1.482935587889953e-30,  1.991580715408656e+00, -4.928024622464266e-05,
 -2.153200470337789e-07, -8.310040895084971e-10, -2.982768234542284e-12, -1.017720840408486e-14, -3.335835040140358e-17, -1.055662721661086e-19, -3.230876150947764e-22,
 -9.554199282673708e-25, -2.720066883556757e-27, -7.400974920135204e-30,  1.998399628150007e+00, -9.405119238863553e-06, -4.141794265067541e-08, -1.619397628350572e-10,
 -5.927299570523088e-13, -2.079076271260439e-15, -7.075495956115407e-18, -2.353203517672303e-20, -7.683349959560845e-23, -2.470146980191698e-25, -7.835069280623564e-28,
 -2.455211576972458e-30,  4.837343535621062e-04, -2.394249901630886e-06,  8.885780875969429e-09, -2.930543935912913e-11,  9.057553412780025e-14, -2.686323817118540e-16,
  7.741857666198208e-19, -2.184365454170186e-21,  6.062799171129606e-24, -1.660762354658441e-26,  4.500025990818627e-29, -1.208169295975057e-31,  4.351744814959649e-03,
 -2.150435336341371e-05,  7.954344742569089e-08, -2.608543821093954e-10,  7.993208951138816e-13, -2.341887345758565e-15,  6.638735336857176e-18, -1.833173691048593e-20,
  4.950222352867887e-23, -1.310211707264897e-25,  3.402778569839802e-28, -8.673958129248766e-31,  1.207781411598323e-02, -5.949071604816393e-05,  2.185830303821028e-07,
 -7.086596796072299e-10,  2.133632975948167e-12, -6.094728029775540e-15,  1.668158047697491e-17, -4.393217385560642e-20,  1.113687458956300e-22, -2.709718759687015e-25,
  6.283178983755459e-28, -1.369163127157413e-30,  2.364199908827875e-02, -1.158869347525458e-04,  4.215010552759000e-07, -1.342828728819140e-09,  3.933801633157567e-12,
 -1.078972149765331e-14,  2.784662450773039e-17, -6.736662668844174e-20,  1.506103012022270e-22, -3.007247138876206e-25,  4.881907548996856e-28, -4.051881745055490e-31,
  3.901428545368021e-02, -1.899966470145525e-04,  6.816622163151039e-07, -2.120235482650041e-09,  5.976499773133612e-12, -1.544067546503882e-14,  3.629461893119045e-17,
 -7.526447254378905e-20,  1.255631710761669e-22, -1.062523903700811e-25, -3.379365348028177e-28,  2.400759373024547e-30,  5.815446920957913e-02, -2.808975033521674e-04,
  9.904427892540866e-07, -2.986523627613234e-09,  7.993215522181904e-12, -1.894343804083833e-14,  3.817296043974595e-17, -5.640873360823494e-20,  1.137896501521183e-23,
  3.358697352633861e-25, -1.705236876308742e-27,  5.871056485068870e-30,  8.101199987914709e-02, -3.874465986176940e-04,  1.337420967864977e-06, -3.878689717140900e-09,
  9.693102180961766e-12, -2.022931013529415e-14,  3.045023493490469e-17, -5.509683651778019e-21, -1.858949799494373e-22,  9.179598016339931e-25, -3.003849773772295e-27,
  7.486056323580777e-30,  1.075257869151925e-01, -5.082874767481419e-04,  1.710613188203787e-06, -4.728169784091197e-09,  1.078882788684643e-11, -1.842492519317300e-14,
  1.167992318214322e-17,  7.405628602870738e-20, -4.234889981882415e-22,  1.410694629922044e-24, -3.344764605336936e-27,  4.626850286557546e-30,  1.376239709773123e-01,
 -6.418588496732399e-04,  2.096755044345033e-06, -5.464332565986247e-09,  1.102373414979286e-11, -1.300068835072486e-14, -1.744250107250999e-17,  1.693134893154309e-19,
 -6.274673275087700e-22,  1.528620687981373e-24, -1.959744448078762e-27, -3.629602315738572e-30,  1.712236623067399e-01, -7.864051958246916e-04,  2.481624787809450e-06,
 -6.018261692483813e-09,  1.019840111419509e-11, -3.889558289401543e-15, -5.384630701263017e-17,  2.590324067006751e-19, -7.099593176946219e-22,  1.037826117928709e-24,
  1.328187219102156e-27, -1.509487244150094e-29,  2.082306490178095e-01, -9.399894257980472e-04,  2.850406611819140e-06, -6.326688396378000e-09,  8.194585807483743e-12,
  8.440695936292544e-15, -9.225612967914503e-17,  3.173963078870208e-19, -5.950202948609572e-22, -1.267235282040262e-25,  5.775692943460923e-27, -2.441919750419168e-29,
  2.485390788254451e-01, -1.100507821241450e-03,  3.188089924676016e-06, -6.335916177324411e-09,  4.994467996764554e-12,  2.297549650044502e-14, -1.257929512503596e-16,
  3.195294394001198e-19, -2.470021313169683e-22, -1.777548267420608e-24,  9.733961685477335e-27, -2.492336533327609e-29,  2.920311185507261e-01, -1.265707466694317e-03,
  3.479899592484817e-06, -6.005560352065031e-09,  6.932278678347192e-13,  3.821051354858381e-14, -1.469665259045010e-16,  2.479374274904993e-19,  3.066569403591481e-22,
 -3.465956266084924e-24,  1.110798817556015e-26, -1.193758358296596e-29,  3.385765967071113e-01, -1.433206401265275e-03,  3.711750666073113e-06, -5.311909910163601e-09,
 -4.496788692176877e-12,  5.227996700977814e-14, -1.489502048033489e-16,  9.853186215443033e-20,  9.664358920691426e-22, -4.572180650127476e-24,  8.186259224265221e-27,
  1.369472858772367e-29,  3.880326355828799e-01, -1.600516715760291e-03,  3.870719397396354e-06, -4.250708295793543e-09, -1.025167008801213e-11,  6.315040851533014e-14,
 -1.269635621431748e-16, -1.152569504360117e-19,  1.571568617656826e-21, -4.487895273690632e-24,  5.747291828652825e-28,  4.384788121875499e-29,  4.402432805132296e-01,
 -1.765070808810921e-03,  3.945520409939465e-06, -2.839145783222824e-09, -1.615209450914247e-11,  6.886546281682465e-14, -7.953821038474425e-17, -3.616501860180372e-19,
  1.932335853652631e-21, -2.848509222458280e-24, -1.016193792412527e-26,  6.469579618560466e-29,  4.950391354872655e-01, -1.924250989992556e-03,  3.926977750245706e-06,
 -1.116861489876327e-09, -2.171009611099432e-11,  6.781824632555813e-14, -9.419248302006470e-18, -5.938838420037962e-19,  1.879430539551735e-21,  2.580001971953416e-25,
 -2.054164901036107e-26,  6.199854144801159e-29,  5.522370158646935e-01, -2.075422575796690e-03,  3.808475276591249e-06,  8.542294850447954e-10, -2.640560407690806e-11,
  5.902045054078699e-14,  7.613066287457360e-17, -7.578958141328885e-19,  1.319742155925740e-21,  4.191278565494346e-24, -2.609144197772414e-26,  2.853940238594228e-29,
  6.116396307809827e-01, -2.215970562283760e-03,  3.586369534355694e-06,  2.991435982357148e-09, -2.973090110465872e-11,  4.233161773446544e-14,  1.657983983129907e-16,
 -8.034635292123440e-19,  2.831464788600594e-22,  7.837119167906149e-24, -2.301997228229927e-26, -2.958675998085054e-29,  6.730353097847348e-01, -2.343339872800162e-03,
  3.260346066960656e-06,  5.194220135301585e-09, -3.124007090658362e-11,  1.861028355401155e-14,  2.455272336492405e-16, -6.968678334596326e-19, -1.056451774097181e-21,
  9.885832396151240e-24, -1.010434993527727e-26, -9.168519817307451e-29,  7.361977903506437e-01, -2.455079066860857e-03,  2.833698206647075e-06,  7.348589216931971e-09,
 -3.059945726278237e-11, -1.024831062241648e-14,  3.005877557297614e-16, -4.323063945665762e-19, -2.399019512579781e-21,  9.260838398507154e-24,  1.001495136057385e-26,
 -1.286157668527770e-28,  8.008860851027664e-01, -2.548887254108534e-03,  2.313506024368565e-06,  9.332893386492666e-09, -2.763426214010551e-11, -4.141435256874342e-14,
  3.181707322927409e-16, -3.890403949248351e-20, -3.379581260958078e-21,  5.573895313274603e-24,  3.091967489666979e-26, -1.155121636342615e-28,  8.668444498024809e-01,
 -2.622663782875788e-03,  1.710692589442170e-06,  1.102486364074059e-08, -2.236581682208783e-11, -7.137675515778861e-14,  2.900989698345374e-16,  4.194849747223812e-19,
 -3.664112007782093e-21, -5.641552708909450e-25,  4.426012032270645e-26, -4.614709737151142e-29,  9.338024753156468e-01, -2.674560065339861e-03,  1.039935340758470e-06,
  1.230959916199541e-08, -1.503393439928813e-11, -9.633815709058944e-14,  2.151358805073363e-16,  8.532840045391870e-19, -3.057661851587804e-21, -7.540213113706580e-24,
  4.300536327667777e-26,  5.861466295431567e-29,  1.001475328758148e+00, -2.703032661612641e-03,  3.194125766507990e-07,  1.308807877235443e-08, -6.099259203305852e-12,
 -1.127175131152042e-13,  1.003302719457109e-16,  1.164619470082030e-18, -1.591951969254785e-21, -1.312681416851614e-23,  2.493273082541499e-26,  1.549238812645659e-28,
  1.069564170681112e+00, -2.706896477180308e-03, -4.296307927285968e-07,  1.328563781658233e-08,  3.778196207714278e-12, -1.177007820876534e-13, -3.908578310826438e-17,
  1.270324101130795e-18,  4.420325188083341e-22, -1.520353778429496e-23, -5.286573723070643e-27,  1.939958037746302e-28,  1.137756776316941e+00, -2.685376639370529e-03,
 -1.183507680771264e-06,  1.285973405413038e-08,  1.378602512492626e-11, -1.097586251792898e-13, -1.815181428070876e-16,  1.125367158819872e-18,  2.540543712640817e-21,
 -1.259442328854859e-23, -3.681940522128380e-26,  1.475230314078412e-28,  1.205728389353227e+00, -2.638157320951844e-03, -1.916903983169123e-06,  1.180624239374484e-08,
  2.303070557157199e-11, -8.903760891960036e-14, -3.024885772359783e-16,  7.401634457388899e-19,  4.114245363151192e-21, -5.693182029978614e-24, -5.656847209519642e-26,
  2.736329175303993e-29,  1.273142836194353e+00, -2.565425489762065e-03, -2.603873504828957e-06,  1.016348960187365e-08,  3.062847133153335e-11, -5.753359811952711e-14,
 -3.792971097145579e-16,  1.854795552559134e-19,  4.667962971789966e-21,  3.443516528157557e-24, -5.499162279936510e-26, -1.138169162890165e-28,  1.339653926951491e+00,
 -2.467907305294930e-03, -3.218987821372737e-06,  8.013288055832502e-09,  3.580732688857650e-11, -1.897697266262853e-14, -3.959972203539720e-16, -4.189698261759325e-19,
  3.977941296658093e-21,  1.169091014540779e-23, -3.122271003079594e-26, -2.058237672251830e-28,  1.404907166207284e+00, -2.346894684937429e-03, -3.738600507531939e-06,
  5.478371008767331e-09,  3.800834784374263e-11,  2.159972078238240e-14, -3.475395995929013e-16, -9.318222545323574e-19,  2.199585551593731e-21,  1.600909320462754e-23,
  5.391524772356259e-27, -1.987894948728800e-28,  1.468541791683544e+00, -2.204259457350515e-03, -4.142168522710670e-06,  2.715882292771098e-09,  3.697202068420943e-11,
  5.858323007768423e-14, -2.419115432800215e-16, -1.227537478862499e-18, -1.483625376561000e-22,  1.472517154892007e-23,  3.886056547678602e-26, -9.439297621671901e-29,
  1.530193152093349e+00, -2.042452544663341e-03, -4.413557398213480e-06, -9.306979798858906e-11,  3.279475676442211e-11,  8.669558599986861e-14, -9.939678800953201e-17,
 -1.233677819337969e-18, -2.337659907175931e-21,  8.360545970813763e-24,  5.410901216518189e-26,  5.090737948419964e-29,  1.589495426553591e+00, -1.864485805123514e-03,
 -4.542243063836484e-06, -2.757339512496460e-09,  2.594251036178041e-11,  1.019493444709943e-13,  5.129220970237200e-17, -9.556623813449659e-19, -3.681231363207380e-21,
 -4.653228511062632e-25,  4.482052377741371e-26,  1.569181050435079e-28,  1.646084676954667e+00, -1.673894555909064e-03, -4.524313864465242e-06, -5.092201856681947e-09,
  1.721299200893133e-11,  1.024484872744076e-13,  1.794084079193243e-16, -4.788596096689915e-19, -3.789914798466489e-21, -8.128104328847468e-24,  1.704065180881771e-26,
  1.683463731594365e-28,  1.699602211768262e+00, -1.474679404821223e-03, -4.363173866249543e-06, -6.936908277624442e-09,  7.645156607580779e-12,  8.884162094510939e-14,
  2.596385057410175e-16,  5.551699655117779e-20, -2.726854907090516e-21, -1.164415349466393e-23, -1.404251951720983e-26,  8.929270971730301e-29,  1.749698225248343e+00,
 -1.271226856938950e-03, -4.069855078685915e-06, -8.171510475369479e-09, -1.616318078381454e-12,  6.428305837931474e-14,  2.786290228218828e-16,  4.948942505980807e-19,
 -9.820914779415378e-22, -1.006152716843363e-23, -3.271457456596230e-26, -2.157594018773946e-29,  1.796035660386758e+00, -1.068209213960179e-03, -3.662863291389400e-06,
 -8.730901644706686e-09, -9.484410237312061e-12,  3.385375830746948e-14,  2.385439478556673e-16,  7.256547196007188e-19,  7.354041416980747e-22, -4.837632560549547e-24,
 -3.165885485977170e-26, -9.323978547761930e-29,  1.838294228093946e+00, -8.704655094016763e-04, -3.167510394343251e-06, -8.614056179050609e-09, -1.509596229173119e-11,
  3.521847669536995e-15,  1.563037513814946e-16,  7.106010765024779e-19,  1.802987794301912e-21,  1.046086500508639e-24, -1.549256476142696e-26, -9.125924705719466e-29,
  1.876174499885850e+00, -6.828665525199259e-04, -2.614724447959123e-06, -7.886786764407869e-09, -1.795149202653359e-11, -2.114862615776686e-14,  5.841561898942801e-17,
  4.981663044290126e-19,  1.945624013851805e-21,  4.756725307761994e-24,  3.396384780332973e-27, -3.645646443522576e-29,  1.909401978107529e+00, -5.101684898249413e-04,
 -2.039374834195332e-06, -6.676990176568305e-09, -1.800059619728121e-11, -3.624008267107664e-14, -2.721001248650447e-17,  1.985040581195965e-19,  1.324477605717240e-21,
  5.094826023248526e-24,  1.367870864367611e-26,  1.949998885618986e-29,  1.937731038043660e+00, -3.568605133833175e-04, -1.478199274903856e-06, -5.162269402899237e-09,
 -1.565234246313588e-11, -4.035417002754655e-14, -7.988153672336899e-17, -6.439424874702337e-20,  4.083129265846032e-22,  2.907530333775132e-24,  1.217444419672273e-26,
  3.860709444510927e-29,  1.960948633229422e+00, -2.270133074487237e-04, -9.674666316381229e-07, -3.550886654689336e-09, -1.170299106542361e-11, -3.486439830611511e-14,
 -9.224862019393092e-17, -2.041854491586622e-19, -3.007334420727831e-22,  2.278513138679778e-25,  4.242772823742736e-27,  2.230111391326766e-29,  1.978877670620071e+00,
 -1.241353380114989e-04, -5.405475145796046e-07, -2.058053497311659e-09, -7.189651951237083e-12, -2.345061114321442e-14, -7.170184853955339e-17, -2.043471364977571e-19,
 -5.330569964854088e-22, -1.216791117702015e-24, -2.117683549786289e-27, -8.586903921439558e-31,  1.991380084980554e+00, -5.104352186721411e-05, -2.255853025191071e-07,
 -8.804012603189563e-10, -3.194564006536096e-12, -1.101447991390420e-14, -3.646427348834245e-17, -1.164770500005713e-19, -3.595221648975159e-22, -1.071012133146650e-24,
 -3.066598966147838e-27, -8.369915894948937e-30,  1.998361332446696e+00, -9.744400332505783e-06, -4.341952458218913e-08, -1.717655499288714e-10, -6.360644436996036e-13,
 -2.257081206265735e-15, -7.770195572919768e-18, -2.613925422524972e-20, -8.631720043268148e-23, -2.806275394488986e-25, -9.000180885564806e-28, -2.851211529539981e-30,
  4.742973334870108e-04, -2.324546081031068e-06,  8.542636771839469e-09, -2.789822286361112e-11,  8.538384793844626e-14, -2.507644872918662e-16,  7.156522053728093e-19,
 -1.999584602106583e-21,  5.496084023039331e-24, -1.490953956006156e-26,  4.000903556188174e-29, -1.063826515486139e-31,  4.266980574047654e-03, -2.088031288334491e-05,
  7.648841157346626e-08, -2.484314642046415e-10,  7.540357752395613e-13, -2.188542427419600e-15,  6.146932918286986e-18, -1.682057986425162e-20,  4.502153544901776e-23,
 -1.181436850138130e-25,  3.043082918911645e-28, -7.696307774159355e-31,  1.184329552941780e-02, -5.777549624626644e-05,  2.102799898094323e-07, -6.754753667987255e-10,
  2.015644400128950e-12, -5.708737442421867e-15,  1.549994021867790e-17, -4.051971874058738e-20,  1.020519727825901e-22, -2.470063871655604e-25,  5.708677239977406e-28,
 -1.244046514726402e-30,  2.318509480042015e-02, -1.125783282628824e-04,  4.057577501657761e-07, -1.281578577788860e-09,  3.724540378221129e-12, -1.014350295863092e-14,
  2.602623151620568e-17, -6.271658154973294e-20,  1.401312580862651e-22, -2.815702766043741e-25,  4.691574483223365e-28, -4.565669040944480e-31,  3.826504658760219e-02,
 -1.846435181451236e-04,  6.567830950259718e-07, -2.027035374566504e-09,  5.676228603755337e-12, -1.459444305971981e-14,  3.424287352091444e-17, -7.131006249375346e-20,
  1.215190482811051e-22, -1.177857847370250e-25, -2.417892061932596e-28,  1.981001139902106e-30,  5.704650233683906e-02, -2.731151684909252e-04,  9.553595115211162e-07,
 -2.861613887936761e-09,  7.623380595248458e-12, -1.804618846446478e-14,  3.660034040632806e-17, -5.586381831200532e-20,  2.230272887366088e-23,  2.726047616536025e-25,
 -1.463351828190359e-27,  5.137755242850162e-30,  7.948332112167994e-02, -3.769308019482890e-04,  1.291794006174169e-06, -3.726797128923540e-09,  9.295808191279224e-12,
 -1.950099822513181e-14,  3.021748918605809e-17, -1.095213453732659e-20, -1.549334788283416e-22,  8.042111964934510e-25, -2.688067089544881e-27,  6.870209481516520e-30,
  1.055196515844228e-01, -4.948266167345064e-04,  1.654898769018522e-06, -4.558480617255418e-09,  1.042329280583884e-11, -1.812120944881487e-14,  1.357122902919715e-17,
  6.129177874184545e-20, -3.750625741194916e-22,  1.281037811546011e-24, -3.136799898562999e-27,  4.802651443989714e-30,  1.350896725769378e-01, -6.253441187269386e-04,
  2.032232682207469e-06, -5.290054103057348e-09,  1.075990667318594e-11, -1.336463766599695e-14, -1.297466537596146e-17,  1.500996064802207e-19, -5.738822939603961e-22,
  1.447492990938755e-24, -2.085904674823176e-27, -2.154896701223578e-30,  1.681172940399888e-01, -7.668383064746098e-04,  2.410381906079073e-06, -5.855777399320478e-09,
  1.010826120023213e-11, -5.097367124387890e-15, -4.690577886965915e-17,  2.369204987024195e-19, -6.717940974393382e-22,  1.078461914933166e-24,  7.226157807256577e-28,
 -1.248413639187844e-29,  2.045158201547580e-01, -9.174876129560727e-04,  2.775278220632389e-06, -6.194341831237083e-09,  8.341966977926438e-12,  6.331039717694308e-15,
 -8.363598202516761e-17,  2.983251994550185e-19, -5.956756371174997e-22,  8.359917805903107e-26,  4.759700921661881e-27, -2.177583062443593e-29,  2.441875774122391e-01,
 -1.075305833453187e-03,  3.112553040225393e-06, -6.252489618824523e-09,  5.424507453968670e-12,  2.006287790778574e-14, -1.169658805941836e-16,  3.106745180540744e-19,
 -3.042476190855537e-22, -1.409887637938478e-24,  8.655595631573121e-27, -2.402928961202943e-29,  2.870235109960611e-01, -1.238156291446683e-03,  3.407924022781897e-06,
 -5.988544289494103e-09,  1.422733747320399e-12,  3.476762052199214e-14, -1.399050481866946e-16,  2.558387367570301e-19,  1.897464082850743e-22, -3.032927971934423e-24,
  1.052554331004871e-26, -1.439501749199619e-29,  3.329027537839727e-01, -1.403768512530353e-03,  3.647609933759418e-06, -5.375686966613497e-09, -3.486696507190797e-12,
  4.874161362991196e-14, -1.457826371832281e-16,  1.268884983560971e-19,  8.078596317239338e-22, -4.234541037753218e-24,  8.651415544168563e-27,  7.610989836089675e-30,
  3.816921733649176e-01, -1.569757688125635e-03,  3.818767877737805e-06, -4.404797509240083e-09, -9.019365838531335e-12,  6.007009044478420e-14, -1.295109297069343e-16,
 -6.754371260790060e-20,  1.410861759294430e-21, -4.428663493413315e-24,  2.329694333244093e-27,  3.600139647155460e-29,  4.332459037641985e-01, -1.733647213913637e-03,
  3.909945165596645e-06, -3.086667857584404e-09, -1.479465894628782e-11,  6.684192121000480e-14, -8.881467280951020e-17, -3.015291607388150e-19,  1.823143912136531e-21,
 -3.199716680966249e-24, -7.440743190363786e-27,  5.889183989195171e-29,  4.874048700889226e-01, -1.892894579511884e-03,  3.911535948242562e-06, -1.453389922390581e-09,
 -2.035730359363481e-11,  6.739943846118021e-14, -2.520571430982077e-17, -5.337466832712108e-19,  1.874588731144087e-21, -5.088327105211503e-25, -1.779653909190582e-26,
  6.247828716623862e-29,  5.439963160666673e-01, -2.044920862572389e-03,  3.816230347989732e-06,  4.412752386894614e-10, -2.520861738576514e-11,  6.059783792514182e-14,
  5.552208677076248e-17, -7.134486856872929e-19,  1.452171056119390e-21,  3.175566289240568e-24, -2.462835147807572e-26,  3.757787082574308e-29,  6.028333464634218e-01,
 -2.187144038176047e-03,  3.619441217989881e-06,  2.522723197354871e-09, -2.884629301528809e-11,  4.604209368832099e-14,  1.434694032494292e-16, -7.900686353476657e-19,
  5.484381024338825e-22,  6.895034872744602e-24, -2.396940536720368e-26, -1.382468642957556e-29,  6.637144986350234e-01, -2.317016248662733e-03,  3.319690963388181e-06,
  4.697670114949736e-09, -3.081053755397136e-11,  2.426529530316849e-14,  2.255945455726722e-16, -7.250656668121968e-19, -7.087664666020253e-22,  9.405674561957212e-24,
 -1.378616119027057e-26, -7.557915911193917e-29,  7.264233599797402e-01, -2.432065085029548e-03,  2.918938223538502e-06,  6.857745869803946e-09, -3.073330640122193e-11,
 -3.187823743230047e-15,  2.874590232852214e-16, -5.036744113235356e-19, -2.059764118561250e-21,  9.550307290870229e-24,  4.514831244873105e-27, -1.208904993753112e-28,
  7.907282507914607e-01, -2.529938803807333e-03,  2.422821864785610e-06,  8.884533202702688e-09, -2.838633879063859e-11, -3.380335362174648e-14,  3.155991761777443e-16,
 -1.436114716178959e-19, -3.157906805131239e-21,  6.706562054089935e-24,  2.566041336258647e-26, -1.228253645317678e-28,  8.563819949136517e-01, -2.608455238223761e-03,
  1.840797961773311e-06,  1.065597233482187e-08, -2.372284529096861e-11, -6.428668901517585e-14,  3.002023847806189e-16,  3.022457412703078e-19, -3.653106108883765e-21,
  1.158826542504428e-24,  4.172622307632370e-26, -6.848265213815336e-29,  9.231218035855274e-01, -2.665653955656031e-03,  1.186144620260359e-06,  1.205393056491029e-08,
 -1.690718784398262e-11, -9.089948787038692e-14,  2.376195862413815e-16,  7.514322031217464e-19, -3.297601028154537e-21, -5.776868918286991e-24,  4.495235314077753e-26,
  2.986891368041411e-29,  9.906693008400460e-01, -2.699850962642882e-03,  4.758100533046539e-07,  1.297259763176716e-08, -8.326920420603999e-12, -1.099244603897143e-13,
  1.321568281573849e-16,  1.106321433989190e-18, -2.044975320170107e-21, -1.199899075418295e-23,  3.130670773529352e-26,  1.341058706880808e-28,  1.058730721602792e+00,
 -2.709694964413761e-03, -2.699182466094550e-07,  1.332721797866512e-08,  1.417687183729729e-12, -1.182109203701617e-13, -3.401153338718182e-18,  1.275687823238544e-18,
 -1.070391720222270e-22, -1.524384093131255e-23,  3.270770824438050e-27,  1.939076961996208e-28,  1.126997316048360e+00, -2.694223852100357e-03, -1.027940591475945e-06,
  1.306252324975280e-08,  1.154988626371164e-11, -1.137281794159003e-13, -1.489398105943154e-16,  1.199139067269114e-18,  2.062266419003187e-21, -1.393002450999601e-23,
 -2.978736756435424e-26,  1.712988535736835e-28,  1.195145995542287e+00, -2.652919726694169e-03, -1.773078149351097e-06,  1.216010053179245e-08,  2.117911085208936e-11,
 -9.603396766518658e-14, -2.799547269950781e-16,  8.681063277023027e-19,  3.868951607929854e-21, -7.920862893687671e-24, -5.454375057597660e-26,  6.466024721034502e-29,
  1.262840256326437e+00, -2.585760390010074e-03, -2.479010865125765e-06,  1.064384723480842e-08,  2.938727639537630e-11, -6.655742913404632e-14, -3.719968793831435e-16,
  3.364040229599322e-19,  4.751207937790042e-21,  1.152474338103914e-24, -5.933344123389480e-26, -8.265791666065310e-29,  1.329731416642796e+00, -2.493264862664940e-03,
 -3.119405069080234e-06,  8.582648865136821e-09,  3.533187383608820e-11, -2.860691574546209e-14, -4.058848072879659e-16, -2.852004119282042e-19,  4.374164230622639e-21,
  1.026241892383768e-23, -4.015016024168974e-26, -1.987199811415095e-28,  1.395460200850340e+00, -2.376530159074867e-03, -3.669198490104465e-06,  6.089498616933976e-09,
  3.835486275228177e-11,  1.295416539938757e-14, -3.725583715279074e-16, -8.521901715807788e-19,  2.777625407877820e-21,  1.604313808298470e-23, -3.846111852786994e-27,
 -2.202992023868249e-28,  1.459658699876837e+00, -2.237256299853521e-03, -4.105991010054281e-06,  3.316480798446323e-09,  3.808284180470073e-11,  5.236486429791819e-14,
 -2.762672778380286e-16, -1.223512151986768e-18,  4.086232407220446e-22,  1.618563107513262e-23,  3.389065331162794e-26, -1.316833685204181e-28,  1.521952730688811e+00,
 -2.077756420149225e-03, -4.411469172353685e-06,  4.453760976079522e-10,  3.450197282266898e-11,  8.388738750113151e-14, -1.349387902331703e-16, -1.303245660729379e-18,
 -1.997258763043065e-21,  1.056118349488927e-23,  5.570129081293461e-26,  2.048927903173377e-29,  1.581964608052994e+00, -1.900948890216577e-03, -4.572773179201450e-06,
 -2.325889904017352e-09,  2.799157112484053e-11,  1.028459408365978e-13,  2.288449785304369e-17, -1.073370361979992e-18, -3.664059483453735e-21,  1.464265020884249e-24,
  5.161499110024571e-26,  1.508781863070163e-28,  1.639316329518840e+00, -1.710328653362078e-03, -4.583699478746936e-06, -4.800173086724905e-09,  1.930386176377065e-11,
  1.065794225989542e-13,  1.642594912539092e-16, -6.046722834419501e-19, -4.068419752023709e-21, -7.292609137578490e-24,  2.487189933289261e-26,  1.872453421425353e-28,
  1.693633159278640e+00, -1.509915550625141e-03, -4.445623097357675e-06, -6.800032197813807e-09,  9.484375563825416e-12,  9.508134747849169e-14,  2.599076064400529e-16,
 -3.854963853835665e-20, -3.155135284428499e-21, -1.211923133904342e-23, -9.507417196233541e-27,  1.172881771189198e-28,  1.744547578615691e+00, -1.304178269615863e-03,
 -4.168024754468499e-06, -8.186718299910000e-09, -2.626833317458125e-13,  7.113254439552817e-14,  2.919898218893421e-16,  4.574177533330807e-19, -1.368046299658530e-21,
 -1.138426230261239e-23, -3.329439662240862e-26, -4.023119809257676e-30,  1.791703550598147e+00, -1.097933729816684e-03, -3.768521244432317e-06, -8.876917591939298e-09,
 -8.748425710867492e-12,  3.982512240656457e-14,  2.591637706011212e-16,  7.461487029658439e-19,  5.374601161236067e-22, -6.186679277410449e-24, -3.580477264040989e-26,
 -9.477766481203630e-29,  1.834761025433678e+00, -8.962231666432826e-04, -3.272325277457955e-06, -8.854817377379878e-09, -1.498636696908265e-11,  7.518449590309643e-15,
  1.770130820946203e-16,  7.687715347071541e-19,  1.828487930833355e-21,  3.420439036379610e-25, -1.981060633938090e-26, -1.051271681178408e-28,  1.873400591753707e+00,
 -7.041678283010699e-04, -2.711102930444813e-06, -8.177313371897826e-09, -1.835927792553839e-11, -1.957207296363615e-14,  7.326182622194033e-17,  5.631890225368013e-19,
  2.118893323632401e-21,  4.856995839858520e-24,  1.526471291613571e-27, -4.890935838594477e-29,  1.907328159714496e+00, -5.268089354948541e-04, -2.121250801563023e-06,
 -6.970831632676824e-09, -1.873145256161144e-11, -3.682146300569021e-14, -2.103019730317559e-17,  2.439291967264223e-19,  1.517940225643916e-21,  5.658394773480973e-24,
  1.447902898468002e-26,  1.665250900503139e-29,  1.936279546377028e+00, -3.689382159690636e-04, -1.541676105395245e-06, -5.419268300235488e-09, -1.647873542518232e-11,
 -4.229138675691813e-14, -8.148522623840009e-17, -4.955611113686174e-20,  5.221707551510556e-22,  3.429775597749040e-24,  1.397020815494013e-26,  4.305286366914328e-29,
  1.960024826101322e+00, -2.349267200599690e-04, -1.011224164155863e-06, -3.743835070966869e-09, -1.242288737651315e-11, -3.714805015461533e-14, -9.809906321169261e-17,
 -2.136429277339429e-19, -2.892279430381871e-22,  4.184687184097573e-25,  5.321136619452067e-27,  2.683911393563451e-29,  1.978372321287128e+00, -1.285604965435253e-04,
 -5.659501488067275e-07, -2.176935506112262e-09, -7.676346212716818e-12, -2.524208474154154e-14, -7.766908008738094e-17, -2.221222406739610e-19, -5.783931905456719e-22,
 -1.302017016359283e-24, -2.137249673531458e-27,  1.587157337622633e-32,  1.991172233368567e+00, -5.289134952580862e-05, -2.364642224565143e-07, -9.333252833376818e-10,
 -3.423876073471789e-12, -1.193009528930301e-14, -3.989266618446874e-17, -1.286230752740484e-19, -4.003781349428904e-22, -1.201353965305507e-24, -3.458455208180528e-27,
 -9.463396872855183e-30,  1.998321646829934e+00, -1.010017778293978e-05, -4.554329655655114e-08, -1.823141009392819e-10, -6.831318522237923e-13, -2.452670401857456e-15,
 -8.542334549568607e-18, -2.907024739701065e-20, -9.709922702574719e-23, -3.192688265650473e-25, -1.035433175437654e-27, -3.316439859907017e-30,  4.651337433786878e-04,
 -2.257521252339260e-06,  8.215892414065418e-09, -2.657128908882386e-11,  8.053588030976734e-14, -2.342413060799113e-16,  6.620475419385991e-19, -1.831997862327272e-21,
  4.987054137696983e-24, -1.339896304144131e-26,  3.561150128628680e-29, -9.378682408075880e-32,  4.184664541536713e-03, -2.028012847859910e-05,  7.357820253348172e-08,
 -2.367092002411869e-10,  7.117028665028828e-13, -2.046508801893710e-15,  5.695503309619925e-18, -1.544565688946124e-20,  4.097954309611780e-23, -1.066224816393166e-25,
  2.723791334032014e-28, -6.834856449886742e-31,  1.161550745087206e-02, -5.612513943797442e-05,  2.023640839370521e-07, -6.441186216777324e-10,  1.905099611057133e-12,
 -5.349992544205909e-15,  1.440980138982690e-17, -3.739202918505267e-20,  9.355789040951819e-23, -2.252320287324130e-25,  5.186828662293701e-28, -1.129709526623757e-30,
  2.274117762156947e-02, -1.093927841588651e-04,  3.907297767217710e-07, -1.223575542068969e-09,  3.527776952901489e-12, -9.539448696661559e-15,  2.433144776958196e-17,
 -5.839098384499315e-20,  1.303275786094555e-22, -2.632166597953629e-25,  4.482835567641680e-28, -4.895577699833246e-31,  3.753682914063954e-02, -1.794850290455010e-04,
  6.329940989506154e-07, -1.938506846105953e-09,  5.392398555076224e-12, -1.379613884400045e-14,  3.229998249487123e-17, -6.749100028749813e-20,  1.171246783644231e-22,
 -1.258230335539102e-25, -1.626611130106976e-28,  1.625540758320663e-30,  5.596911282400519e-02, -2.656076034286178e-04,  9.217402320690792e-07, -2.742479991983584e-09,
  7.271114662353611e-12, -1.718646121624280e-14,  3.504754241246774e-17, -5.500397747853133e-20,  3.111555904328178e-23,  2.183943878065652e-25, -1.251913747144692e-27,
  4.485893548663223e-30,  7.799598691223592e-02, -3.667728370873281e-04,  1.247952094884877e-06, -3.581145067981444e-09,  8.913012800207043e-12, -1.877999261753333e-14,
  2.984562703260304e-17, -1.546695144663235e-20, -1.278460484672008e-22,  7.025571273562150e-25, -2.398978879550109e-27,  6.274097192113859e-30,  1.035664810196399e-01,
 -4.818034259428066e-04,  1.601185736584211e-06, -4.394589069356186e-09,  1.006425789012047e-11, -1.777622038380099e-14,  1.512613352964398e-17,  5.000385291329745e-20,
 -3.311525594287469e-22,  1.159814912663651e-24, -2.923985138477562e-27,  4.852525276359478e-30,  1.326204138857250e-01, -6.093372735888362e-04,  1.969776112361411e-06,
 -5.120049465051869e-09,  1.048982990358296e-11, -1.362762375611011e-14, -9.021257601273707e-18,  1.325528629231420e-19, -5.232938432204725e-22,  1.362530666513996e-24,
 -2.153527357995485e-27, -9.619258578606620e-31,  1.650880657563754e-01, -7.478335872284600e-04,  2.341079414028711e-06, -5.694919751752224e-09,  9.995581404892938e-12,
 -6.145893689567686e-15, -4.056709826792391e-17,  2.160488280344915e-19, -6.325751686305282e-22,  1.097078860147136e-24,  2.249626565599062e-28, -1.018663876817467e-29,
  2.008898065996118e-01, -8.955804376553358e-04,  2.701750780362101e-06, -6.059963653204217e-09,  8.449180622598265e-12,  4.421863501997463e-15, -7.554903534443965e-17,
  2.793466483924975e-19, -5.894630928925466e-22,  2.555805863340059e-25,  3.857858758474485e-27, -1.923784062968357e-29,  2.399356818598453e-01, -1.050704023647819e-03,
  3.038056672982973e-06, -6.162637025353355e-09,  5.798391934331814e-12,  1.735893869187040e-14, -1.084104628104316e-16,  3.001912720618754e-19, -3.490232910925533e-22,
 -1.084469303939672e-24,  7.624255707170332e-27, -2.280419209661425e-29,  2.821249580997987e-01, -1.211179910733098e-03,  3.336220436100162e-06, -5.960397719771129e-09,
  2.085092316794909e-12,  3.149644929058890e-14, -1.326723993884808e-16,  2.602436401130477e-19,  8.798171497014905e-23, -2.625115922429323e-24,  9.852985419298765e-27,
 -1.605472942228346e-29,  3.273456316978205e-01, -1.374846541557738e-03,  3.582798524397754e-06, -5.423864294352385e-09, -2.546549776108867e-12,  4.528824763791961e-14,
 -1.418902759542705e-16,  1.503682592649963e-19,  6.617114119200241e-22, -3.883362398117532e-24,  8.870218983775716e-27,  2.489141681285998e-30,  3.754739047894066e-01,
 -1.539421338445190e-03,  3.765083546171852e-06, -4.539665583548583e-09, -7.849174098271534e-12,  5.694408852272799e-14, -1.307939099968620e-16, -2.492609495256385e-20,
  1.253468959137928e-21, -4.305988650265507e-24,  3.750805489306503e-27,  2.869280503807570e-29,  4.263736338962739e-01, -1.702519735959754e-03,  3.871528597000738e-06,
 -3.312806260998173e-09, -1.347978629952528e-11,  6.461553938737252e-14, -9.645841841970530e-17, -2.450840750557738e-19,  1.703204708096949e-21, -3.447345380066218e-24,
 -4.986470560319636e-27,  5.261066737252061e-29,  4.798957582059776e-01, -1.861677489619925e-03,  3.892185331598521e-06, -1.768360697565524e-09, -1.901653979029452e-11,
  6.662191924015542e-14, -3.931450792672872e-17, -4.741849557860375e-19,  1.844117790648186e-21, -1.165952225354049e-24, -1.506810433842750e-26,  6.129328588227990e-29,
  5.358777162807447e-01, -2.014376602775179e-03,  3.819145834355310e-06,  4.769871911404783e-11, -2.398492586612477e-11,  6.169599921674029e-14,  3.621194620810941e-17,
 -6.653368507679569e-19,  1.549177354124036e-21,  2.225648891392166e-24, -2.281838441397602e-26,  4.432639801615750e-29,  5.941428621139460e-01, -2.158075192748087e-03,
  3.646975625566169e-06,  2.068728845300142e-09, -2.789279916209497e-11,  4.922210217302975e-14,  1.216291727635373e-16, -7.687330513283678e-19,  7.792939317003594e-22,
  5.928366719140170e-24, -2.426145948018294e-26,  2.511539912337307e-31,  6.544998939384622e-01, -2.290241574496281e-03,  3.373122142205917e-06,  4.208871191855687e-09,
 -3.027274533802446e-11,  2.943368834284639e-14,  2.050252879866504e-16, -7.424411709136362e-19, -3.808458288889456e-22,  8.792532684344444e-24, -1.675181107874146e-26,
 -5.923283005365685e-29,  7.167423120349447e-01, -2.408392769333306e-03,  2.998279873409621e-06,  6.365872837250077e-09, -3.072925218513427e-11,  3.534828779396519e-15,
  2.724852407715579e-16, -5.640612660760634e-19, -1.713958249934894e-21,  9.627413087149863e-24, -5.834818763120780e-28, -1.104580120273254e-28,  7.806479249858541e-01,
 -2.510137541094422e-03,  2.526690193347868e-06,  8.425353217101178e-09, -2.898704581495316e-11, -2.628841593261595e-14,  3.102009593721943e-16, -2.406140596688795e-19,
 -2.899308965120667e-21,  7.623693864746694e-24,  2.017401852965932e-26, -1.258724725813443e-28,  8.459784273468595e-01, -2.593223915630553e-03,  1.966351082774577e-06,
  1.026651504416221e-08, -2.493591306980129e-11, -5.699343693156815e-14,  3.070372063056425e-16,  1.863297103163394e-19, -3.582124916123347e-21,  2.761815255023567e-24,
  3.828659933423212e-26, -8.723317431960792e-29,  9.124790755036057e-01, -2.655590944901398e-03,  1.329109726074098e-06,  1.176918843405492e-08, -1.866650704809943e-11,
 -8.495624040587976e-14,  2.571535848427892e-16,  6.429305927506731e-19, -3.472962458883937e-21, -3.960888493644839e-24,  4.564042251733182e-26,  1.567779429319423e-30,
  9.798784924513948e-01, -2.695424228366290e-03,  6.306098770584604e-07,  1.282196171799668e-08, -1.049122273048844e-11, -1.063887573582152e-13,  1.621545287711451e-16,
  1.034223620945864e-18, -2.453039303975712e-21, -1.063569873950300e-23,  3.667896861314754e-26,  1.095565409788297e-28,  1.047888636229292e+00, -2.711214397961917e-03,
 -1.099335333174712e-07,  1.333099492234440e-08, -9.444583879842204e-13, -1.178648097518418e-13,  3.218792880541744e-17,  1.263523978120725e-18, -6.514186973349293e-22,
 -1.494382317792835e-23,  1.168284469140667e-26,  1.874224423817420e-28,  1.116204970547988e+00, -2.701817408218564e-03, -8.701571816159052e-07,  1.322894224770738e-08,
  9.242333312837075e-12, -1.168928382063873e-13, -1.145169629929410e-16,  1.256893039359469e-18,  1.541208859215426e-21, -1.496495166855581e-23, -2.182527759720762e-26,
  1.896447513793066e-28,  1.184506879490151e+00, -2.666515054646667e-03, -1.625188290095782e-06,  1.248324432218529e-08,  1.919328235999998e-11, -1.024474856422136e-13,
 -2.539602938630505e-16,  9.869355004438933e-19,  3.545313651598704e-21, -1.003486339655356e-23, -5.089040020408392e-26,  1.011403583757427e-28,  1.252458370672329e+00,
 -2.605073683226323e-03, -2.348509009496792e-06,  1.110291289653201e-08,  2.796770041904319e-11, -7.535512032517711e-14, -3.604460923238843e-16,  4.886419431706321e-19,
  4.749193456701877e-21, -1.283322451551693e-24, -6.219411751540884e-26, -4.666595788429164e-29,  1.319709112498110e+00, -2.517798572735849e-03, -3.013042024556435e-06,
  9.142850039923624e-09,  3.466175948416678e-11, -3.842783161315716e-14, -4.118575609084452e-16, -1.396428487667109e-19,  4.712629533420775e-21,  8.485335483161557e-24,
 -4.859602686413638e-26, -1.838925215498744e-28,  1.385895850590297e+00, -2.405581002044925e-03, -3.592435485531722e-06,  6.704755345988874e-09,  3.852265345124668e-11,
  3.737004600564594e-15, -3.950888177542367e-16, -7.541142788483557e-19,  3.350025548332732e-21,  1.569029090535681e-23, -1.391236291521990e-26, -2.362202036390528e-28,
  1.450644245599535e+00, -2.269934601126298e-03, -4.062503925548994e-06,  3.933812778811218e-09,  3.906106997259442e-11,  4.532537458841562e-14, -3.102531618110527e-16,
 -1.200863646479177e-18,  1.014209806949824e-21,  1.741428052521653e-23,  2.726780900540383e-26, -1.692792120156917e-28,  1.513571168765392e+00, -2.113017284635242e-03,
 -4.402757708299801e-06,  1.010641152406293e-09,  3.614434372397907e-11,  8.020411061960626e-14, -1.722642104866223e-16, -1.360643527459194e-18, -1.576826520587756e-21,
  1.279702067583304e-23,  5.582702755819988e-26, -1.568538003037758e-29,  1.574287482308675e+00, -1.937634948190225e-03, -4.597928720729284e-06, -1.861550030189578e-09,
  3.005147960273202e-11,  1.030213303760091e-13, -8.800531125744678e-18, -1.189365580695530e-18, -3.572611938978771e-21,  3.658384958253870e-24,  5.799768542577950e-26,
  1.380521603632561e-28,  1.632401318528562e+00, -1.747223243487153e-03, -4.639377365179828e-06, -4.474050420703455e-09,  2.147342406319108e-11,  1.103035337841083e-13,
  1.454680114427350e-16, -7.388538306602856e-19, -4.311014764091176e-21, -6.127996892108426e-24,  3.347524213872994e-26,  2.032223378990488e-28,  1.687521854139449e+00,
 -1.545804210476432e-03, -4.526249133646436e-06, -6.632730831116795e-09,  1.144823222576665e-11,  1.012943628866534e-13,  2.573486644171538e-16, -1.465574248134622e-19,
 -3.596949475809870e-21, -1.238752465444204e-23, -3.685914092734474e-27,  1.476655602935062e-28,  1.739263554995386e+00, -1.337915390963427e-03, -4.266242399149620e-06,
 -8.179155010709454e-09,  1.231055330400856e-12,  7.828865775306579e-14,  3.041211898704423e-16,  4.068259230507004e-19, -1.801838372522658e-21, -1.271335831708880e-23,
 -3.299750493738919e-26,  1.834925758976162e-29,  1.787250841416455e+00, -1.128510308623129e-03, -3.875856705628236e-06, -9.010175298604755e-09, -7.888022558407277e-12,
  4.629748644298215e-14,  2.802612161968651e-16,  7.594993365479555e-19,  2.879565299153287e-22, -7.702081859596817e-24, -3.995451647614662e-26, -9.327507978329780e-29,
  1.831123096858781e+00, -9.228308634243592e-04, -3.380016047051709e-06, -9.093158034142356e-09, -1.479173706531789e-11,  1.203168828980330e-14,  1.993585547881922e-16,
  8.273179290629498e-19,  1.825384864210368e-21, -5.470973966033529e-25, -2.475112079213329e-26, -1.194899515268263e-28,  1.870539914229429e+00, -7.262541856117663e-04,
 -2.811005774712609e-06, -8.474092315480649e-09, -1.873181894915674e-11, -1.761673382880599e-14,  9.000672755158961e-17,  6.337985666771630e-19,  2.294287844815649e-21,
  4.870833675311268e-24, -9.424380426787998e-28, -6.372178648730249e-29,  1.905186446909610e+00, -5.441186929156766e-04, -2.206723385010049e-06, -7.276451307713744e-09,
 -1.947234665701144e-11, -3.723854640758164e-14, -1.348871444400471e-17,  2.958756629808135e-19,  1.732233493529191e-21,  6.251041202367028e-24,  1.512131367511136e-26,
  1.225541131202654e-29,  1.934778708417616e+00, -3.815362968821223e-04, -1.608317541311754e-06, -5.689801381958687e-09, -1.734422175107472e-11, -4.426167683335595e-14,
 -8.261951212996872e-17, -3.075946042617306e-20,  6.561700152847902e-22,  4.027818304756177e-24,  1.596549752342179e-26,  4.766014765569219e-29,  1.959068650257098e+00,
 -2.431996537882936e-04, -1.057367719881312e-06, -3.948674930697779e-09, -1.318988203742096e-11, -3.957524209620480e-14, -1.042080678629633e-16, -2.226137056337316e-19,
 -2.700336032692479e-22,  6.564431813571100e-25,  6.616496823643718e-27,  3.218339133675114e-29,  1.977848855652330e+00, -1.331947176410768e-04, -5.928272978362661e-07,
 -2.303899212346938e-09, -8.200343254957175e-12, -2.718291110609337e-14, -8.415478702520900e-17, -2.413972637627200e-19, -6.268015339208831e-22, -1.387167380795963e-24,
 -2.111579137536057e-27,  1.210298059502517e-30,  1.990956812271074e+00, -5.482881269125527e-05, -2.480008637387146e-07, -9.900693868562110e-10, -3.672351591664275e-12,
 -1.293222533530817e-14, -4.368017859723216e-17, -1.421546900817424e-19, -4.462205025949590e-22, -1.348372036127363e-24, -3.901419582721017e-27, -1.069538118847907e-29,
  1.998280503302855e+00, -1.047346484593086e-05, -4.779830204260676e-08, -1.936480602479264e-10, -7.343032125950732e-13, -2.667816058158554e-15, -9.401588501438449e-18,
 -3.236960961351003e-20, -1.093749814268059e-22, -3.637593033645896e-25, -1.193076450787086e-27, -3.863935686349122e-30,  4.562331236933048e-04, -2.193047979666764e-06,
  7.904616539850894e-09, -2.531934742464055e-11,  7.600588196897007e-14, -2.189501192375172e-16,  6.129152011634739e-19, -1.679862881064922e-21,  4.529367904343264e-24,
 -1.205368832440096e-26,  3.173236839339940e-29, -8.278109018998833e-32,  4.104703558216237e-03, -1.970267437992356e-05,  7.080468857231613e-08, -2.256421132705109e-10,
  6.721053315539689e-13, -1.914861754091936e-15,  5.280821369064161e-18, -1.419368072296645e-20,  3.733021021578108e-23, -9.630572964366543e-26,  2.440116439995686e-28,
 -6.075145033856484e-31,  1.139419648643643e-02, -5.453663428487607e-05,  1.948140789533066e-07, -6.144745863070568e-10,  1.801475024515112e-12, -5.016390078654456e-15,
  1.340354754630362e-17, -3.452400144294420e-20,  8.581129677724642e-23, -2.054474572078469e-25,  4.713052471801600e-28, -1.025413508860628e-30,  2.230976650542600e-02,
 -1.063247323123308e-04,  3.763793420456193e-07, -1.168626241920618e-09,  3.342697494536006e-12, -8.974650689199184e-15,  2.275348687607803e-17, -5.436869591011299e-20,
  1.211692919659165e-22, -2.457225058085495e-25,  4.262898618843347e-28, -5.080447000899381e-31,  3.682887164689488e-02, -1.745126785497469e-04,  6.102407163047692e-07,
 -1.854394367211275e-09,  5.124076875318996e-12, -1.304319694429605e-14,  3.046201721834511e-17, -6.381660607649780e-20,  1.124943249844399e-22, -1.309911112222032e-25,
 -9.792913121861569e-29,  1.325227909124911e-30,  5.492122458356167e-02, -2.583633686975816e-04,  8.895173027235843e-07, -2.628846810709113e-09,  6.935672710273874e-12,
 -1.636368209241895e-14,  3.352248604257033e-17, -5.389177370679856e-20,  3.812234329696328e-23,  1.720902527473683e-25, -1.067499642955809e-27,  3.908211449451017e-30,
  7.654859401565899e-02, -3.569587192455310e-04,  1.205821734149013e-06, -3.441502898568923e-09,  8.544538526912592e-12, -1.806933403484368e-14,  2.935895063908572e-17,
 -1.917134243088720e-20, -1.042162747697383e-22,  6.119495083956034e-25, -2.135548008032168e-27,  5.704935237127807e-30,  1.016645561281004e-01, -4.692021697367447e-04,
  1.549405169346624e-06, -4.236384958918087e-09,  9.712471135459887e-12, -1.739755154879000e-14,  1.638400346412871e-17,  4.005286852559066e-20, -2.914530945597343e-22,
  1.047118020307943e-24, -2.711205556062461e-27,  4.805388445769119e-30,  1.302141960861042e-01, -5.938219946148212e-04,  1.909333513481329e-06, -4.954403141680992e-09,
  1.021540336737325e-11, -1.380144368002017e-14, -5.536957985730489e-18,  1.165755876348817e-19, -4.758007526370824e-22,  1.275839286926846e-24, -2.174118887887136e-27,
 -1.086392663599357e-32,  1.621337596897511e-01, -7.293755989415694e-04,  2.273695730699113e-06, -5.536024675660579e-09,  9.863405759711971e-12, -7.049162499287924e-15,
 -3.479517988153081e-17,  1.964392370010459e-19, -5.930207815641745e-22,  1.097723449915238e-24, -1.781428223117351e-28, -8.183030007370281e-30,  1.973502555567950e-01,
 -8.742550053964347e-04,  2.629844944348515e-06, -5.924165159873421e-09,  8.520108706292725e-12,  2.700425155280782e-15, -6.798982249391896e-17,  2.606592139153804e-19,
 -5.776819885088015e-22,  3.936820748535881e-25,  3.064667271632004e-27, -1.684211969080351e-29,  2.357810085718379e-01, -1.026693774197338e-03,  2.964672681031119e-06,
 -6.067223856783707e-09,  6.120226362781793e-12,  1.485665576603539e-14, -1.001669303831198e-16,  2.884547935893829e-19, -3.828127896088475e-22, -7.991523605809787e-25,
  6.652189365347533e-27, -2.135045312594883e-29,  2.773331658560106e-01, -1.184775632426814e-03,  3.264916066354487e-06, -5.922167333473400e-09,  2.683771442773497e-12,
  2.839998707326441e-14, -1.253598345830789e-16,  2.616216505891103e-19,  3.983137221532118e-25, -2.245459845748163e-24,  9.122645219988968e-27, -1.704146604693452e-29,
  3.219031572056707e-01, -1.346445123866906e-03,  3.517496978997381e-06, -5.457546523144022e-09, -1.674485627535395e-12,  4.193567077450984e-14, -1.374040456734122e-16,
  1.693748207085333e-19,  5.283113264275043e-22, -3.527667716114075e-24,  8.883811323459417e-27, -1.727643736994037e-30,  3.693761128564164e-01, -1.509520623553105e-03,
  3.709891068624728e-06, -4.656312027790393e-09, -6.741716577627056e-12,  5.380104991839742e-14, -1.309533704231134e-16,  1.273596654388207e-20,  1.101439797865359e-21,
 -4.132719088425681e-24,  4.864076381250168e-27,  2.202147510249310e-29,  4.196252425889196e-01, -1.671710090998864e-03,  3.830523095088020e-06, -3.518272361144133e-09,
 -1.221115004466200e-11,  6.222423194551819e-14, -1.025766426342131e-16, -1.926012767563649e-19,  1.576050583023248e-21, -3.602410365725512e-24, -2.814084717246596e-27,
  4.611909069155700e-29,  4.725111816481032e-01, -1.830629959869125e-03,  3.869183207763224e-06, -2.062021488056497e-09, -1.769457805530906e-11,  6.552567042148482e-14,
 -5.177263102995464e-17, -4.159558632462562e-19,  1.791938596017042e-21, -1.715396497183424e-24, -1.242258865041103e-26,  5.876094528461374e-29,  5.278813107418722e-01,
 -1.983827576407982e-03,  3.817456521358092e-06, -3.261477468278986e-10, -2.274379475611509e-11,  6.234720240131957e-14,  1.828735768587153e-17, -6.146534516691783e-19,
  1.613355492371678e-21,  1.353426507859391e-24, -2.075918217332936e-26,  4.893639696871698e-29,  5.855690595654152e-01, -2.128807599788436e-03,  3.669155643470408e-06,
  1.630470934314461e-09, -2.688089422783567e-11,  5.188591645052673e-14,  1.004845212164444e-16, -7.405679572855609e-19,  9.752837419337443e-22,  4.961857456313806e-24,
 -2.397525745263937e-26,  1.243433913856840e-29,  6.453932059053590e-01, -2.263062759287155e-03,  3.420742685852915e-06,  3.729476920440692e-09, -2.963655525198468e-11,
  3.410374561280356e-14,  1.841129513141707e-16, -7.496978750344537e-19, -7.696068884385910e-23,  8.075091610031422e-24, -1.900351092501083e-26, -4.321317150372834e-29,
  7.071571854518476e-01, -2.384109319152099e-03,  3.071723808279663e-06,  5.875120218377934e-09, -3.059446911553094e-11,  9.879072153168347e-15,  2.559756894372883e-16,
 -6.133763412592768e-19, -1.368930709553281e-21,  9.510419029768070e-24, -5.175212195601505e-27, -9.797299841088357e-29,  7.706484310110027e-01, -2.489527524412177e-03,
  2.624995628783469e-06,  7.957756363600672e-09, -2.943896470278500e-11, -1.893466423859042e-14,  3.022071823153883e-16, -3.288557941113665e-19, -2.611665967883181e-21,
  8.319883723197880e-24,  1.464226023020224e-26, -1.249475869077963e-28,  8.356377638704858e-01, -2.577007180835532e-03,  2.087119101195201e-06,  9.858823403752259e-09,
 -2.600173679816858e-11, -4.957478791601219e-14,  3.106666555854873e-16,  7.358029985461318e-20, -3.456101045186767e-21,  4.211870348526405e-24,  3.410862403881478e-26,
 -1.019939612260453e-28,  9.018788646025276e-01, -2.644398350263304e-03,  1.468493033880798e-06,  1.145727254429352e-08, -2.030252224523357e-11, -7.858120708621941e-14,
  2.735808283804742e-16,  5.298663177548469e-19, -3.582750126836056e-21, -2.141928997123778e-24,  4.511200408256506e-26, -2.526664717210925e-29,  9.691078555250099e-01,
 -2.689766909088861e-03,  7.833967551615420e-07,  1.263730108443139e-08, -1.257778247766971e-11, -1.021587631585149e-13,  1.899583392788366e-16,  9.498923242557293e-19,
 -2.808425101943320e-21, -9.079986491625685e-24,  4.090824737836099e-26,  8.233492097302895e-29,  1.037043032258068e+00, -2.711454414187155e-03,  4.987011568373514e-08,
  1.329707917167383e-08, -3.291178077827786e-12, -1.166706044046427e-13,  6.719462418368869e-17,  1.234177071939056e-18, -1.179026290178138e-21, -1.431484995747510e-23,
  1.967428547355517e-26,  1.748648186569798e-28,  1.105384787113472e+00, -2.708141341116451e-03, -7.106002107166109e-07,  1.335797945593565e-08,  6.879869780099734e-12,
 -1.192138596550218e-13, -7.871559212603292e-17,  1.297439991902386e-18,  9.888050039506883e-22, -1.566703596655395e-23, -1.319064547095224e-26,  2.017589008154493e-28,
  1.173815772147754e+00, -2.678912302491328e-03, -1.473615464974018e-06,  1.277362369987826e-08,  1.708568533425666e-11, -1.081984501314831e-13, -2.247948555616828e-16,
  1.094221905239541e-18,  3.148583847148637e-21, -1.197120649008864e-23, -4.567793295997872e-26,  1.352800137177133e-28,  1.242001354201420e+00, -2.623321325837885e-03,
 -2.212640398949107e-06,  1.153787422239918e-08,  2.637528769928622e-11, -8.382452970593623e-14, -3.446468676746923e-16,  6.393934658352281e-19,  4.657823049645077e-21,
 -3.800707005148724e-24, -6.338632134808116e-26, -7.038548602138697e-30,  1.309590417620081e+00, -2.541454686036708e-03, -2.900027400108810e-06,  9.690751657017673e-09,
  3.379412954458881e-11, -4.834202374587510e-14, -4.136131446724123e-16,  1.565821584053255e-20,  4.981216998078074e-21,  6.385766617805384e-24, -5.621763636175967e-26,
 -1.612732492648268e-28,  1.376216571971685e+00, -2.433988177212512e-03, -3.508279468157541e-06,  7.321193571540237e-09,  3.850092670025107e-11, -5.985878156120808e-15,
 -4.146191747505144e-16, -6.380037883837751e-19,  3.902324251374129e-21,  1.492273329561790e-23, -2.453105194803990e-26, -2.451993323412020e-28,  1.441499821188895e+00,
 -2.302235118696633e-03, -4.011519736309716e-06,  4.565626029431827e-09,  3.989041458467325e-11,  3.748006232437903e-14, -3.433273185974794e-16, -1.158183019561874e-18,
  1.658862788852975e-21,  1.834519174067985e-23,  1.901321650647804e-26, -2.055711983102083e-28,  1.505048746350486e+00, -2.148180883878713e-03, -4.387107986032241e-06,
  1.601545626852674e-09,  3.770396898094855e-11,  7.560733258050272e-14, -2.109963285941528e-16, -1.403301958120307e-18, -1.076211637761095e-21,  1.500447875378291e-23,
  5.424470387799242e-26, -5.702073812198438e-29,  1.566463245924640e+00, -1.974499401894345e-03, -4.617314453638646e-06, -1.364265973040534e-09,  3.210703041230657e-11,
  1.023977102179237e-13, -4.368023887772272e-17, -1.301122624103901e-18, -3.397736344909883e-21,  6.094340405935545e-24,  6.365135360918052e-26,  1.176215045563135e-28,
  1.625337863957290e+00, -1.784547007199733e-03, -4.690931126628738e-06, -4.112644696862218e-09,  2.371264994694143e-11,  1.135307283774304e-13,  1.228175497869882e-16,
 -8.800598765837917e-19, -4.505330346963490e-21, -4.606358186875830e-24,  4.269171379673144e-26,  2.148712293853286e-28,  1.681265717825713e+00, -1.582329304566538e-03,
 -4.604674936392995e-06, -6.433018069298606e-09,  1.353548179969372e-11,  1.074080682176020e-13,  2.515664553430430e-16, -2.688102119389008e-19, -4.043903546565272e-21,
 -1.239568016347049e-23,  3.511429037948850e-27,  1.796797024918423e-28,  1.733843012570250e+00, -1.372437473156080e-03, -4.364221112556218e-06, -8.146531615893511e-09,
  2.870704751883377e-12,  8.571731241526535e-14,  3.146344826215513e-16,  3.415914944956675e-19, -2.283013196753281e-21, -1.400938067770441e-23, -3.160272698391203e-26,
  4.593477246822634e-29,  1.782674098768164e+00, -1.159951723442110e-03, -3.984704299418860e-06, -9.128603355306414e-09, -6.893083339827562e-12,  5.327972123227091e-14,
  3.016122732271183e-16,  7.639611407123756e-19, -1.906362842353486e-23, -9.381062135133083e-24, -4.395500614359215e-26, -8.783711102183252e-29,  1.827376996414581e+00,
 -9.503114667221780e-04, -3.490545145409466e-06, -9.327632798988890e-09, -1.450134687945717e-11,  1.710084773105955e-14,  2.233368452130030e-16,  8.852134993829968e-19,
  1.786562728350978e-21, -1.646547144238804e-24, -3.032628612041207e-26, -1.338853211838127e-28,  1.867589270136246e+00, -7.491541092796935e-04, -2.914504367123212e-06,
 -8.776496542216183e-09, -1.906107099417296e-11, -1.523515828216091e-14,  1.088072042636421e-16,  7.100083270658937e-19,  2.468239097259987e-21,  4.772136520310896e-24,
 -4.119043208788161e-27, -8.110990115195491e-29,  1.902974104001354e+00, -5.621271028392335e-04, -2.295934772425152e-06, -7.593981678802168e-09, -2.021965056099567e-11,
 -3.745638544262310e-14, -4.393486739880727e-18,  3.550254262248138e-19,  1.968272958044014e-21,  6.864966164117470e-24,  1.552873410066747e-26,  5.904583550179894e-30,
  1.933226390974757e+00, -3.946807332862422e-04, -1.678289765568411e-06, -5.974498782495375e-09, -1.824934088567318e-11, -4.625236910137176e-14, -8.316411140090329e-17,
 -7.314559116686245e-21,  8.131844968129695e-22,  4.709749206531336e-24,  1.816491402346948e-26,  5.230722841257060e-29,  1.958078628513783e+00, -2.518517806397424e-04,
 -1.106044613392209e-06, -4.166183105904054e-09, -1.400690665036618e-11, -4.215198663887895e-14, -1.105582932763682e-16, -2.308227156422810e-19, -2.412804697883695e-22,
  9.511984711134756e-25,  8.166919658661821e-27,  3.845346632800546e-29,  1.977306413244342e+00, -1.380501957218863e-04, -6.212796239067445e-07, -2.439566047521292e-09,
 -8.764758026546262e-12, -2.928604871217057e-14, -9.120234034047460e-17, -2.622700928585112e-19, -6.782431275982243e-22, -1.470127112635398e-24, -2.024759313225437e-27,
  2.811291480633820e-30,  1.990733452324642e+00, -5.686136184524674e-05, -2.602429656764694e-07, -1.050954510256512e-09, -3.941810281366826e-12, -1.402997308314072e-14,
 -4.786793427480634e-17, -1.572414713904387e-19, -4.976879178293656e-22, -1.514236827977919e-24, -4.401906762610366e-27, -1.208052972795540e-29,  1.998237829665965e+00,
 -1.086535023592747e-05, -5.019437320437133e-08, -2.058363373226022e-10, -7.899914258460366e-13, -2.904738308775795e-15, -1.035897387337356e-17, -3.608868823943124e-20,
 -1.233719508610339e-22, -4.150648964787058e-25, -1.376901936728778e-27, -4.509369409222616e-30,  4.475855101227994e-04, -2.131006030114225e-06,  7.607938974301048e-09,
 -2.413750179347504e-11,  7.177025227820030e-14, -2.047886025119133e-16,  5.678446689113155e-19, -1.541628006144519e-21,  4.117431442367159e-24, -1.085431358640074e-26,
  2.830647544584812e-29, -7.315252334479324e-32,  4.027008841219706e-03, -1.914688774664370e-05,  6.816026345888290e-08, -2.151880523908983e-10,  6.350439866068390e-13,
 -1.792759269353614e-15,  4.899614170017316e-18, -1.305275338198348e-20,  3.403263658723190e-23, -8.705953216755967e-26,  2.187864944932437e-28, -5.404584647663297e-31,
  1.117912095634626e-02, -5.300713394515311e-05,  1.876100704343202e-07, -5.864364532736139e-10,  1.704287349026045e-12, -4.706001414452258e-15,  1.247423252321055e-17,
 -3.189282573107141e-20,  7.874391627566399e-23, -1.874690016312785e-25,  4.283093019598380e-28, -9.304221478633586e-31,  2.189040209590539e-02, -1.033688958730990e-04,
  3.626708975478325e-07, -1.116549865382154e-09,  3.168544239551488e-12, -8.446404794979552e-15,  2.128414059201594e-17, -5.062956768124843e-20,  1.126247960216908e-22,
 -2.291208238201175e-25,  4.037424327440855e-28, -5.151983577862982e-31,  3.614044579201325e-02, -1.697183895705967e-04,  5.884714137973398e-07, -1.774456926518510e-09,
  4.870381168217064e-12, -1.233314851279933e-14,  2.872483602923759e-17, -6.029288522718511e-20,  1.077214757088839e-22, -1.338197516566774e-25, -4.534553043788168e-29,
  1.072124839263060e-30,  5.390180622411746e-02, -2.513715530110609e-04,  8.586263057483530e-07, -2.520451033656835e-09,  6.616322974208142e-12, -1.557710677504285e-14,
  3.203146968786166e-17, -5.258064883880668e-20,  4.358901652699200e-23,  1.326745883143609e-25, -9.070010853116330e-28,  3.397692519227928e-30,  7.513979397740699e-02,
 -3.474750406145823e-04,  1.165332172802065e-06, -3.307643280548339e-09,  8.190152650443061e-12, -1.737151785817330e-14,  2.877866128634251e-17, -2.216978540688594e-20,
 -8.366465856663325e-23,  5.313873190534542e-25, -1.896476305828316e-27,  5.167471855284320e-30,  9.981221966150741e-02, -4.570076593715064e-04,  1.499489534887790e-06,
 -4.083747301476675e-09,  9.368537803660450e-12, -1.699189750298806e-14,  1.738043296134101e-17,  3.130899079189742e-20, -2.556582294902808e-22,  9.428677389053315e-25,
 -2.502186373861038e-27,  4.685169580374982e-30,  1.278690848042261e-01, -5.787823802877728e-04,  1.850852225122510e-06, -4.793171059601518e-09,  9.938301303432207e-12,
 -1.389683993006829e-14, -2.479215025561259e-18,  1.020680760715559e-19, -4.314338714899370e-22,  1.189098088856448e-24, -2.157517718381667e-27,  7.342641543417972e-31,
  1.592522194608617e-01, -7.114490904344238e-04,  2.208205527139954e-06, -5.379381590430649e-09,  9.714506263088534e-12, -7.820351147298386e-15, -2.955462740253263e-17,
  1.780928131844104e-19, -5.537129250757130e-22,  1.083925377867060e-24, -4.991484641022529e-28, -6.450980372234368e-30,  1.938948660941893e-01, -8.534982847589481e-04,
  2.559574394647610e-06, -5.787497567206654e-09,  8.558380089913693e-12,  1.154175919399918e-15, -6.094787494561546e-17,  2.424224011615410e-19, -5.614753551252706e-22,
  5.021165232891011e-25,  2.373293288597030e-27, -1.461284500761220e-29,  2.317212095078191e-01, -1.003265933045611e-03,  2.892462926210861e-06, -5.967051066871256e-09,
  6.393966370013524e-12,  1.254816120450102e-14, -9.226566567617751e-17,  2.757940174623385e-19, -4.070149044091346e-22, -5.513909130311911e-25,  5.747524564710189e-27,
 -1.975317048625777e-29,  2.726458529848068e-01, -1.158939795823859e-03,  3.194125921686165e-06, -5.874843971949706e-09,  3.222277881378437e-12,  2.547918514660208e-14,
 -1.180459087876560e-16,  2.604099614231902e-19, -7.405219735580695e-23, -1.895713816428438e-24,  8.361533826115502e-27, -1.747187024854824e-29,  3.165732413279114e-01,
 -1.318567503141856e-03,  3.451872771732716e-06, -5.477806115396860e-09, -8.683556568681884e-13,  3.869667909464999e-14, -1.324434711702406e-16,  1.843172166864716e-19,
  4.076836140455762e-22, -3.174889378187847e-24,  8.730467571075928e-27, -5.111745769632661e-30,  3.633970322571896e-01, -1.480066751059304e-03,  3.653403075545668e-06,
 -4.755741897085844e-09, -5.697075497605042e-12,  5.066629503596740e-14, -1.301254064489577e-16,  4.564093045123534e-20,  9.563809846736725e-22, -3.920587656995585e-24,
  5.698971021296172e-27,  1.604599732426113e-29,  4.129994186402566e-01, -1.641238011041195e-03,  3.787172186292863e-06, -3.703830377263533e-09, -1.099169167746634e-11,
  5.970325698108838e-14, -1.072830364289597e-16, -1.442605167241535e-19,  1.444809270805751e-21, -3.676303731134822e-24, -9.278016158880911e-28,  3.963888446571678e-29,
  4.652504053623374e-01, -1.799780185022464e-03,  3.842783288127248e-06, -2.334721985271764e-09, -1.639740023270124e-11,  6.414978539116123e-14, -6.262654516593841e-17,
 -3.596927994587933e-19,  1.721854299165780e-21, -2.161576784751238e-24, -9.912490258851061e-27,  5.518682132873501e-29,  5.200070463448401e-01, -1.953309670747083e-03,
  3.811400554764399e-06, -6.800548098483715e-10, -2.149382545536874e-11,  6.258544871552944e-14,  1.806051138993233e-18, -5.624024938215922e-19,  1.647659770727386e-21,
  5.670429421491089e-25, -1.854055468764304e-26,  5.160945616998918e-29,  5.771126493550940e-01, -2.099383323955896e-03,  3.686175378881350e-06,  1.208802420406963e-09,
 -2.582072031936599e-11,  5.405239921599606e-14,  8.021108664397822e-17, -7.066846754630291e-19,  1.136809170414452e-21,  4.016933910802186e-24, -2.319673380479851e-26,
  2.261983014204544e-29,  6.363959588812582e-01, -2.235525810689123e-03,  3.462674566253432e-06,  3.260981580252772e-09, -2.891199386397176e-11,  3.827054294618429e-14,
  1.631295686734022e-16, -7.476595167859261e-19,  1.996434120968845e-22,  7.281474903243588e-24, -2.056644846852845e-26, -2.799593784762084e-29,  6.976703305395258e-01,
 -2.359261827455501e-03,  3.139295767133321e-06,  5.387517232008837e-09, -3.033686889053099e-11,  1.581175891733396e-14,  2.382390087992239e-16, -6.517522690442534e-19,
 -1.031284354400104e-21,  9.221200753389659e-24, -9.184519695930313e-27, -8.409074767063310e-29,  7.607329142935960e-01, -2.468153620711466e-03,  2.717651335224557e-06,
  7.484094163213822e-09, -2.974592172729064e-11, -1.180135066519280e-14,  2.918749648508439e-16, -4.075345076500560e-19, -2.302923312564372e-21,  8.796695865931231e-24,
  9.230982885315362e-27, -1.204750077253190e-28,  8.253638682426453e-01, -2.559844149694139e-03,  2.202897409580349e-06,  9.435269235763163e-09, -2.691856963853954e-11,
 -4.210641316596540e-14,  3.112031908105932e-16, -3.433456613948715e-20, -3.281028707916186e-21,  5.483043274922225e-24,  2.937306081666438e-26, -1.125605790941565e-28,
  8.913256298920337e-01, -2.632106096297746e-03,  1.603980567505570e-06,  1.112022075509345e-08, -2.180735246296949e-11, -7.185024620675383e-14,  2.868028892708651e-16,
  4.143302060319314e-19, -3.627714590209856e-21, -3.670851850691939e-25,  4.345186007824074e-26, -4.973912630877799e-29,  9.583622776391059e-01, -2.682896719380202e-03,
  9.337703029177647e-07,  1.241996772487186e-08, -1.457326710750519e-11, -9.729104503948151e-14,  2.152502991988720e-16,  8.551150458232386e-19, -3.105053866045428e-21,
 -7.379594243423474e-24,  4.390177119246112e-26,  5.357612659161830e-29,  1.026199021604355e+00, -2.710418265373929e-03,  2.090424257851088e-07,  1.322585231413488e-08,
 -5.605688375825810e-12, -1.146479836586553e-13,  1.011470750843039e-16,  1.188369524000458e-18, -1.678385407088697e-21, -1.337893350211798e-23,  2.699009224224812e-26,
  1.568307340336965e-28,  1.094541869754274e+00, -2.713183270274104e-03, -5.497229694992944e-07,  1.344889291899026e-08,  4.479659694215914e-12, -1.206640428663752e-13,
 -4.202970247926983e-17,  1.319973205773540e-18,  4.174537186588737e-22, -1.601503408697738e-23, -4.170169675390188e-27,  2.071227830146328e-28,  1.163077522227489e+00,
 -2.690083611280690e-03, -1.318764086349328e-06,  1.302940039731932e-08,  1.487030436754417e-11, -1.132148933446343e-13, -1.928133087421897e-16,  1.187740742189009e-18,
  2.686251600749047e-21, -1.367002591736162e-23, -3.904196589524695e-26,  1.656119684130715e-28,  1.231473553486613e+00, -2.640461587290237e-03, -2.071710643281685e-06,
  1.194602386957360e-08,  2.461761844648546e-11, -9.186451956089093e-14, -3.246812040486413e-16,  7.857653759802914e-19,  4.475395694152435e-21, -6.330152407413575e-24,
 -6.278124436451418e-26,  3.477101714300695e-29,  1.299378947810315e+00, -2.564180634136747e-03, -2.780527795432889e-06,  1.022318413008070e-08,  3.272815136056476e-11,
 -5.824526941194187e-14, -4.109117418662919e-16,  1.782879700382705e-19,  5.168992705583906e-21,  4.003475270140398e-24, -6.267765369052201e-26, -1.311779615475223e-28,
  1.366425057969955e+00, -2.461692536054566e-03, -3.416734774337699e-06,  7.935704181195401e-09,  3.828032854931957e-11, -1.613650772331288e-14, -4.306557504750470e-16,
 -5.047444649053140e-19,  4.419271105922533e-21,  1.372483682539943e-23, -3.537021271426795e-26, -2.460694320998429e-28,  1.432227058775205e+00, -2.334097222338180e-03,
 -3.952879487379577e-06,  5.209410863814708e-09,  4.055502412363868e-11,  2.885767066424264e-14, -3.749130474138523e-16, -1.094404097338905e-18,  2.330707261048221e-21,
  1.891475884259590e-23,  9.223142216966766e-27, -2.387669008716898e-28,  1.496385965432171e+00, -2.183190505028322e-03, -4.364220884553816e-06,  2.216617741637421e-09,
  3.916227588467759e-11,  7.006853360010352e-14, -2.506867686218234e-16, -1.428685069968064e-18, -4.977179763333748e-22,  1.711095353330336e-23,  5.074736349249681e-26,
 -1.025372203872133e-28,  1.558491280135353e+00, -2.011494513965812e-03, -4.630536006783033e-06, -8.342394168001725e-10,  3.414148784134453e-11,  1.009001416012854e-13,
 -8.159731588990247e-17, -1.405838791901457e-18, -3.131333961358973e-21,  8.736084135991840e-24,  6.822735061581926e-26,  8.899233469913101e-29,  1.618124317803900e+00,
 -1.822265239753001e-03, -4.737931023135849e-06, -3.714925900197616e-09,  2.601065994920689e-11,  1.161662171971498e-13,  9.613501319418519e-17, -1.026535497741904e-18,
 -4.638122010374494e-21, -2.707419571564200e-24,  5.229758547607615e-26,  2.206629979191344e-28,  1.674862242314630e+00, -1.619471641896216e-03, -4.680499802667175e-06,
 -6.198939854352269e-09,  1.574333213436743e-11,  1.133403091921709e-13,  2.421613008548005e-16, -4.053118909401661e-19, -4.485627127701255e-21, -1.208750869754442e-23,
  1.213478280192173e-26,  2.122856447365476e-28,  1.728282817280926e+00, -1.407741361770981e-03, -4.461645993333766e-06, -8.086472189137066e-09,  4.661293331646270e-12,
  9.337458474195393e-14,  3.230987219653970e-16,  2.602261996354462e-19, -2.809533579799958e-21, -1.522374290715655e-23, -2.887477205174289e-26,  7.897115690992027e-29,
  1.777969840294841e+00, -1.192269322140660e-03, -4.094872817196698e-06, -9.229967363389253e-09, -5.753371030973477e-12,  6.077471343089565e-14,  3.229414120213357e-16,
  7.576008723204573e-19, -3.893373706085793e-22, -1.121390089300864e-23, -4.761155226029799e-26, -7.747050408791427e-29,  1.823519187393460e+00, -9.786874706984498e-04,
 -3.603856615059161e-06, -9.556618439503838e-09, -1.410368829432055e-11,  2.276476053184425e-14,  2.489125550657307e-16,  9.411892056047981e-19,  1.703994680898868e-21,
 -2.981546573617912e-24, -3.652423627324270e-26, -1.476776407450525e-28,  1.864545347266737e+00, -7.728966228634249e-04, -3.021661765188389e-06, -9.083762496980343e-09,
 -1.933800333655457e-11, -1.237614000496778e-14,  1.298187665374098e-16,  7.917016105500484e-19,  2.636158468311077e-21,  4.530275884956800e-24, -8.120609917263954e-27,
 -1.012424899898272e-28,  1.900688275651597e+00, -5.808646488377869e-04, -2.389028369247477e-06, -7.923491327698965e-09, -2.096898974124019e-11, -3.743519065382466e-14,
  6.467021640707492e-18,  4.220846319475289e-19,  2.226633612906435e-21,  7.488921481300571e-24,  1.560515685522433e-26, -2.874137463646594e-30,  1.931620354242131e+00,
 -4.083988621813613e-04, -1.751766565590629e-06, -6.273997076399235e-09, -1.919434836363283e-11, -4.824766319999633e-14, -8.297809697078634e-17,  2.156497600673956e-20,
  9.963811441188678e-22,  5.483720987598961e-24,  2.056655601698704e-26,  5.681789514170313e-29,  1.957053202583176e+00, -2.609039892332138e-04, -1.157411767051922e-06,
 -4.397184310887555e-09, -1.487700824575128e-11, -4.488378060114880e-14, -1.171238058024557e-16, -2.379293196126759e-19, -2.007306304429097e-22,  1.313789287232262e-24,
  1.001595973813355e-26,  4.577903910005704e-29,  1.976744083155107e+00, -1.431399611976421e-04, -6.514155542081498e-07, -2.584609413158562e-09, -9.372975275581004e-12,
 -3.156552961323743e-14, -9.885782206484223e-17, -2.848360213363138e-19, -7.325904994092074e-22, -1.548062416181662e-24, -1.856614512311968e-27,  4.926636034290219e-30,
  1.990501761574976e+00, -5.899484529820920e-05, -2.732422997324873e-07, -1.116332220211571e-09, -4.234264189957275e-12, -1.523348789039784e-14, -5.250210314268924e-17,
 -1.740747339556327e-19, -5.555019432904739e-22, -1.701388446055704e-24, -4.966985794941488e-27, -1.363385422505085e-29,  1.998193549202198e+00, -1.127700474812413e-05,
 -5.274221027116677e-08, -2.189548181384979e-10, -8.506565604757060e-13, -3.165939790556837e-15, -1.142705220400019e-17, -4.028669853089737e-20, -1.393554170572844e-22,
 -4.743243793279330e-25, -1.591621221691657e-27, -5.271608584835907e-30,  4.391814057311480e-04, -2.071281903436971e-06,  7.325046095630334e-09, -2.302121787696093e-11,
  6.780734197854995e-14, -1.916637822340971e-16,  5.264664727679538e-19, -1.415909899400590e-21,  3.746304593822126e-24, -9.783865305938924e-27,  2.527734959620704e-29,
 -6.471831089473720e-32,  3.951495740472239e-03, -1.861176461761566e-05,  6.563780819348067e-08, -2.053079230760963e-10,  6.003357289051102e-13, -1.679434029088684e-15,
  4.548924308278766e-18, -1.201221169806832e-20,  3.105045325607058e-23, -7.876570709110501e-26,  1.963360970184587e-28, -4.812207203005624e-31,  1.097005025766897e-02,
 -5.153394581420406e-05,  1.807333904933318e-07, -5.599048480919527e-10,  1.613090249141979e-12, -4.417057205045326e-15,  1.161551921307622e-17, -2.947777451351519e-20,
  7.229378681425212e-23, -1.711293698349142e-25,  3.893015301619399e-28, -8.440163099008757e-31,  2.148264558900264e-02, -1.005202739028012e-04,  3.495709933877395e-07,
 -1.067177302560281e-09,  3.004611582327192e-12, -7.952197215386887e-15,  1.991575056873419e-17, -4.715447526790712e-20,  1.046616759313526e-22, -2.134245885571271e-25,
  3.810812179464791e-28, -5.135993505386763e-31,  3.547085476343906e-02, -1.650944859548635e-04,  5.676374671753622e-07, -1.698467241440355e-09,  4.630477408515442e-12,
 -1.166362579836268e-14,  2.708416825055547e-17, -5.692313994161224e-20,  1.028820848522131e-22, -1.347554401555710e-25, -2.987825845464711e-30,  8.593627952139231e-31,
  5.290986898847696e-02, -2.446217479831458e-04,  8.290059133996685e-07, -2.417040931794970e-09,  6.312349970951323e-12, -1.482585681262496e-14,  3.057940916628032e-17,
 -5.111609763555658e-20,  4.774703851233753e-23,  9.924788626635629e-26, -7.676109436876845e-28,  2.947671835685537e-30,  7.376829085933609e-02, -3.383089485500746e-04,
  1.126415363859907e-06, -3.179342969902167e-09,  7.849577400527033e-12, -1.668856440313384e-14,  2.812319954528073e-17, -2.455518051206495e-20, -6.584675794243626e-23,
  4.599250420849611e-25, -1.680300769830973e-27,  4.664532419913473e-30,  9.800787405543865e-02, -4.452052403996159e-04,  1.451372806437052e-06, -3.936546454309554e-09,
  9.032937519169792e-12, -1.656514106830554e-14,  1.814751721835966e-17,  2.365210281532896e-20, -2.234673129128888e-22,  8.468554068359251e-25, -2.299697009095345e-27,
  4.511493696047264e-30,  1.255832084261142e-01, -5.642029526191877e-04,  1.794279069534386e-06, -4.636384021910362e-09,  9.659993086670278e-12, -1.392356732156481e-14,
  1.917257994158133e-19,  8.893053082764651e-20, -3.901703091332719e-22,  1.103623288643133e-24, -2.112064536550192e-27,  1.305574014015103e-30,  1.564413492689505e-01,
 -6.940390263169892e-04,  2.144580258932378e-06, -5.225237625757406e-09,  9.551399848737145e-12, -8.471789340977814e-15, -2.481025637279791e-17,  1.609939594869012e-19,
 -5.151152395318622e-22,  1.058736620935577e-24, -7.494811138688970e-28, -4.966619449759496e-30,  1.905213895837471e-01, -8.332971603563015e-04,  2.490946538860484e-06,
 -5.650456022095850e-09,  8.567375512633219e-12, -2.291321203887603e-16, -5.440874769272566e-17,  2.247615102513865e-19, -5.418397072075631e-22,  5.848053911146337e-25,
  1.776073499130050e-27, -1.256395630776801e-29,  2.277539741660357e-01, -9.804108906238235e-04,  2.821480033345880e-06, -5.862857614725724e-09,  6.623403656689560e-12,
  1.042496345558492e-14, -8.472845335149251e-17,  2.624946393801140e-19, -4.229317797716759e-22, -3.383840761772133e-25,  4.914997699804279e-27, -1.808167732979713e-29,
  2.680607546152866e-01, -1.133667866760877e-03,  3.123953457096129e-06, -5.819362314589173e-09,  3.704119532800041e-12,  2.273325252154229e-14, -1.107974133564431e-16,
  2.570114053014071e-19, -1.364631299135303e-22, -1.576651252349141e-24,  7.591746530471325e-27, -1.745249726202535e-29,  3.113537847091238e-01, -1.291215634148566e-03,
  3.386080721427276e-06, -5.485679263644783e-09, -1.257832972338832e-13,  3.558133734364401e-14, -1.271166516178534e-16,  1.956012648407230e-19,  2.996117084189102e-22,
 -2.830995649466739e-24,  8.445050102296258e-27, -7.744991688623346e-30,  3.575348561782494e-01, -1.451069275757784e-03,  3.595820144971251e-06, -4.838957686306268e-09,
 -4.714858855536276e-12,  4.756195009839815e-14, -1.284398987424067e-16,  7.403214378026832e-20,  8.194985852461284e-22, -3.680107567978233e-24,  6.286760066469544e-27,
  1.079102031529065e-29,  4.064947757576468e-01, -1.611121317315491e-03,  3.741709966821068e-06, -3.870286101000095e-09, -9.823675168442664e-12,  5.708509454124413e-14,
 -1.106949843591979e-16, -1.001480344499366e-19,  1.312197586802580e-21, -3.680404133957750e-24,  6.769458434022444e-28,  3.334782659327688e-29,  4.581125855472526e-01,
 -1.769154348505050e-03,  3.813234539116744e-06, -2.586901401552562e-09, -1.513021881568243e-11,  6.253204322936025e-14, -7.193876970818628e-17, -3.059103775737431e-19,
  1.637474637091949e-21, -2.510741107845265e-24, -7.577305563435555e-27,  5.085501888223202e-29,  5.122547302583420e-01, -1.922856860141327e-03,  3.801217789456666e-06,
 -1.013945236938494e-09, -2.024292770441463e-11,  6.244579849793139e-14, -1.320099288834000e-17, -5.094894295379347e-19,  1.655275241691670e-21, -1.287621222002821e-25,
 -1.624265866848192e-26,  5.258005759175399e-29,  5.687741769282965e-01, -2.069842838838491e-03,  3.698238213970047e-06,  8.044172223955542e-10, -2.472200264654498e-11,
  5.574425721435821e-14,  6.095368118053349e-17, -6.681700046706471e-19,  1.264980482387012e-21,  3.111520239737545e-24, -2.201444008023271e-26,  3.079144594866010e-29,
  6.275094952423483e-01, -2.207675691587589e-03,  3.499056722012970e-06,  2.804718584573301e-09, -2.810912286244241e-11,  4.193539738682150e-14,  1.423228051164449e-16,
 -7.372377256227488e-19,  4.467104604094682e-22,  6.438408540236084e-24, -2.148460022429570e-26, -1.395878894497735e-29,  6.882839097981213e-01, -2.333897086098466e-03,
  3.201045059480027e-06,  4.904961606983706e-09, -2.996495250502880e-11,  2.130708126641833e-14,  2.195772888336615e-16, -6.795198432192404e-19, -7.067868065188276e-22,
  8.784097376178773e-24, -1.256385945844942e-26, -6.943770287663954e-29,  7.509043395802769e-01, -2.446061279885691e-03,  2.804598289732497e-06,  7.006647778647800e-09,
 -2.991286482416011e-11, -4.941315567547584e-15,  2.794803452956006e-16, -4.761001460495952e-19, -1.980855561608440e-21,  9.061924170879006e-24,  4.085126326060524e-27,
 -1.129748337835264e-28,  8.151604446650901e-01, -2.541775460712836e-03,  2.313509980612104e-06,  8.998240366498574e-09, -2.768614752001483e-11, -3.466074694781741e-14,
  3.088031562364218e-16, -1.359523151935478e-19, -3.063704470086960e-21,  6.556738577131583e-24,  2.426540455226050e-26, -1.189201180098278e-28,  8.808237058177725e-01,
 -2.618746519525283e-03,  1.735283511232477e-06,  1.076018477563991e-08, -2.317465279600392e-11, -6.484088006198779e-14,  2.967792970830762e-16,  2.983626697675157e-19,
 -3.610231707233414e-21,  1.320680932820819e-24,  4.078068324424342e-26, -7.111656434855779e-29,  9.476465692152185e-01, -2.674834508453922e-03,  1.081347600851802e-06,
  1.217151750600457e-08, -1.646554756001358e-11, -9.184918033099290e-14,  2.377649585194892e-16,  7.518456944124079e-19, -3.338620068543295e-21, -5.584965464820692e-24,
  4.561725853089155e-26,  2.443007089587534e-29,  1.015361696005256e+00, -2.708112783156121e-03,  3.671392976834121e-07,  1.311796071698733e-08, -7.871710754894305e-12,
 -1.118276679982309e-13,  1.335986601807065e-16,  1.127176411010656e-18, -2.138988564566452e-21, -1.216768956350674e-23,  3.340679778744187e-26,  1.341503739861260e-28,
  1.083681364699533e+00, -2.716934472405497e-03, -3.879859885569074e-07,  1.350121900697964e-08,  2.059290945512111e-12, -1.212282686495026e-13, -4.970233025164530e-18,
  1.324092709146179e-18, -1.598924709846167e-22, -1.599953632862363e-23,  4.933449956983048e-27,  2.055309533144428e-28,  1.152297083272741e+00, -2.700004441692951e-03,
 -1.161059237331952e-06,  1.324897093183257e-08,  1.256247333553826e-11, -1.174340835131404e-13, -1.584291733889618e-16,  1.265540184103878e-18,  2.167848610633620e-21,
 -1.507813609724771e-23, -3.117989812446771e-26,  1.908085996361273e-28,  1.220879476930624e+00, -2.656455309644991e-03, -1.926057046378271e-06,  1.232479182606917e-08,
  2.270426936199562e-11, -9.937689606732252e-14, -3.007124895099366e-16,  9.248509389715797e-19,  4.202790100542101e-21, -8.798319607416943e-24, -6.031847329952986e-26,
  7.711953251459327e-29,  1.289078526237548e+00, -2.585925333609052e-03, -2.654747855459808e-06,  1.073698151494139e-08,  3.146512861077279e-11, -6.802843977741332e-14,
 -4.035858153322341e-16,  3.455071900187415e-19,  5.266692662380101e-21,  1.391321886465321e-24, -6.766147525646878e-26, -9.432524296650895e-29,  1.356524237845550e+00,
 -2.488635116397881e-03, -3.317843894232368e-06,  8.545041509729748e-09,  3.785318074173530e-11, -2.662541353291857e-14, -4.427365522316853e-16, -3.557164294274818e-19,
  4.885303793141337e-21,  1.209520320099583e-23, -4.605234145261439e-26, -2.379428867004024e-28,  1.422827835356176e+00, -2.365459134912878e-03, -3.886455840353009e-06,
  5.862409331463445e-09,  4.103976253084354e-11,  1.950109679459082e-14, -4.044094526055392e-16, -1.008876440725241e-18,  3.015667155242697e-21,  1.906484116892341e-23,
 -1.924655334254300e-27, -2.669693187147497e-28,  1.487583559516826e+00, -2.217987118001391e-03, -4.333816744062694e-06,  2.854084599585536e-09,  4.050023463869422e-11,
  6.357079617293306e-14, -2.908175858509854e-16, -1.434374030240398e-18,  1.535992965194541e-22,  1.903654186904979e-23,  4.517992956546313e-26, -1.508555093576859e-28,
  1.550371163412768e+00, -2.048569406417726e-03, -4.637203084576045e-06, -2.719515749718519e-10,  3.613666165911920e-11,  9.845843088921755e-14, -1.223125633538899e-16,
 -1.500475724945831e-18, -2.766860299798164e-21,  1.153318643903842e-23,  7.135748689671634e-26,  5.188510840942352e-29,  1.610759177836005e+00, -1.860339752144432e-03,
 -4.779936062236283e-06, -3.280053461565076e-09,  2.835464150850074e-11,  1.181116949829777e-13,  6.530247659700160e-17, -1.176092129718903e-18, -4.695592936253702e-21,
 -4.212252228285484e-25,  6.200026641309479e-26,  2.190088146832274e-28,  1.668309002905907e+00, -1.657208732935721e-03, -4.753299904797724e-06, -5.928600467894229e-09,
  1.806725226310918e-11,  1.189993773229463e-13,  2.287383658748243e-16, -5.557018443063838e-19, -4.909702854259451e-21, -1.140582815922863e-23,  2.218125252563181e-26,
  2.441132059083401e-28,  1.722579852906584e+00, -1.443821267832748e-03, -4.558173177133942e-06, -7.996527953524313e-09,  6.606864230843443e-12,  1.012057166066984e-13,
  3.290424468837573e-16,  1.613367797839474e-19, -3.377441828697041e-21, -1.629829833646403e-23, -2.457255071801222e-26,  1.174722859717610e-28,  1.773134541479672e+00,
 -1.225472812879385e-03, -4.206143254125901e-06, -9.311869048010455e-09, -4.458661491915973e-12,  6.877806704767870e-14,  3.439164657382575e-16,  7.383088920694413e-19,
 -8.281008883683783e-22, -1.318219360310351e-23, -5.068404921446714e-26, -6.110961817949871e-29,  1.819546044134340e+00, -1.007980840751082e-03, -3.719873889514782e-06,
 -9.778301438951384e-09, -1.358648806770055e-11,  2.906095349318851e-14,  2.760110212770528e-16,  9.937047594858879e-19,  1.568761000947393e-21, -4.576245157209374e-24,
 -4.330076594314513e-26, -1.600276474011300e-28,  1.861404716371927e+00, -7.975112151954808e-04, -3.132530962359646e-06, -9.394973738691053e-09, -1.955252415830581e-11,
 -8.984797287043399e-15,  1.531914291513582e-16,  8.785963277227129e-19,  2.792268680651239e-21,  4.109804590914195e-24, -1.307023919874705e-26, -1.242102594154450e-28,
  1.898325982289978e+00, -6.003629637668582e-04, -2.486147956769134e-06, -8.264972194733132e-09, -2.171514149708592e-11, -3.712985678190556e-14,  1.932430979117487e-17,
  4.977705622458289e-19,  2.507411078000136e-21,  8.107374883053313e-24,  1.523197446853637e-26, -1.462848196293434e-29,  1.929958246236376e+00, -4.227194414666561e-04,
 -1.828929381185320e-06, -6.588934207255901e-09, -2.017914804604156e-11, -5.022810057162954e-14, -8.189706031382727e-17,  5.677153534227249e-20,  1.209216986097773e-21,
  6.357635811516660e-24,  2.315928905978284e-26,  6.094585760131542e-29,  1.955990728047980e+00, -2.703784639897106e-04, -1.211636295819493e-06, -4.642552854716774e-09,
 -1.580333675027854e-11, -4.777537546720654e-14, -1.238680690483082e-16, -2.435145511411916e-19, -1.457154455889837e-22,  1.757129209156282e-24,  1.221306480465623e-26,
  5.429779652364294e-29,  1.976160900567582e+00, -1.484779451632007e-04, -6.833519311428268e-07, -2.739759172868696e-09, -1.002867166423733e-11, -3.403652328908333e-14,
 -1.071699088341619e-16, -3.091844657371838e-19, -7.895984259457828e-22, -1.617230391055128e-24, -1.581677183668360e-27,  7.689944237951021e-30,  1.990261323818683e+00,
 -6.123554297057514e-05, -2.870550562247908e-07, -1.186587962124536e-09, -4.551939880485587e-12, -1.655409416696784e-14, -5.763454880201251e-17, -1.928703439033281e-19,
 -6.204772342996903e-22, -1.912562957994897e-24, -5.604384357516969e-27, -1.537017022883884e-29,  1.998147580334154e+00, -1.170968855112868e-05, -5.545346997697632e-08,
 -2.330871671504144e-10, -9.168118919127279e-13, -3.454245512083134e-15, -1.262016833741740e-17, -4.503203875434319e-20, -1.576352598333612e-22, -5.428826824738490e-25,
 -1.842858902796341e-27, -6.173412797308272e-30,  4.310117549018346e-04, -2.013768396467675e-06,  7.055176675381943e-09, -2.196629333802426e-11,  6.409727565854126e-14,
 -1.794911045855927e-16,  4.884477494383078e-19, -1.301473951685784e-21,  3.411619453660773e-24, -8.827475844822225e-27,  2.259598290849171e-29, -5.732127387272767e-32,
  3.878083510741917e-03, -1.809635615581810e-05,  6.323065582706841e-08, -1.959654414302379e-10,  5.678121158079157e-13, -1.574186237261403e-15,  4.226077274976301e-18,
 -1.106249098239087e-20,  2.835129239897165e-23, -7.131985343896731e-26,  1.763379590006516e-28, -4.288449945088637e-31,  1.076676426658876e-02, -5.011452197931271e-05,
  1.741665220307327e-07, -5.347872626185635e-10,  1.527471301315573e-12, -4.147933448604112e-15,  1.082162400450167e-17, -2.726000965732981e-20,  6.640469305917955e-23,
 -1.562763842860427e-25,  3.539195004327179e-28, -7.655042666239158e-31,  2.108607766185515e-02, -9.777412513268663e-05,  3.370481429325001e-07, -1.020350340850396e-09,
  2.850242397976824e-12, -7.489691644073656e-15,  1.864117935740851e-17, -4.392533634465860e-20,  9.724734053816184e-23, -1.986312974698358e-25,  3.586436801310412e-28,
 -5.053409555693493e-31,  3.481943169059928e-02, -1.606336706571122e-04,  5.476928010550975e-07, -1.626211000549042e-09,  4.403577894888513e-12, -1.103236439531101e-14,
  2.553568245727718e-17, -5.370848479162180e-20,  9.803734722429659e-23, -1.341735218990387e-25,  3.078533649915486e-29,  6.810113790326436e-31,  5.194446479060274e-02,
 -2.381040239601193e-04,  8.005977505952019e-07, -2.318376077278986e-09,  6.023056867143625e-12, -1.410895025248690e-14,  2.917004541951603e-17, -4.953670515735539e-20,
  5.079743827556010e-23,  7.101717796656549e-26, -6.468063155552734e-28,  2.551903146687562e-30,  7.243283906198437e-02, -3.294481241462332e-04,  1.089005911342798e-06,
 -3.056383467003621e-09,  7.522498821925320e-12, -1.602208141162175e-14,  2.740855405759019e-17, -2.640993885131165e-20, -5.045109055936522e-23,  3.966777025699206e-25,
 -1.485468037603162e-27,  4.197464904517872e-30,  9.624997931685908e-02, -4.337807802431297e-04,  1.404990555230202e-06, -3.794646001226580e-09,  8.706039686005981e-12,
 -1.612243406170990e-14,  1.871412157867692e-17,  1.697156859259150e-20, -1.945890015486370e-22,  7.587777294113864e-25, -2.105726498809703e-27,  4.300305026161080e-30,
  1.233547563971059e-01, -5.500686601359410e-04,  1.739560634116371e-06, -4.484050831584468e-09,  9.381762311041438e-12, -1.389045996894367e-14,  2.512841617008858e-18,
  7.706458344596276e-20, -3.519454660299844e-22,  1.020424623630601e-24, -2.044769868474442e-27,  1.731439368982918e-30,  1.536991129802703e-01, -6.771306107506453e-04,
  2.082788649737364e-06, -5.073801567446410e-09,  9.376365256875457e-12, -9.014969179439995e-15, -2.052751086348271e-17,  1.451139141103041e-19, -4.775894663887148e-22,
  1.024773288131168e-24, -9.395041194078163e-28, -3.705632493762781e-30,  1.872276299411311e-01, -8.136384804070896e-04,  2.423963159356990e-06, -5.513483519306587e-09,
  8.550234488233663e-12, -1.461361572919995e-15, -4.835491296859409e-17,  2.077721513964240e-19, -5.196360288557879e-22,  6.453538599232596e-25,  1.264916041485107e-27,
 -1.070132592104913e-29,  2.238770312702846e-01, -9.581186508163495e-04,  2.751768118064595e-06, -5.755323176665386e-09,  6.812155488142990e-12,  8.478139515253668e-15,
 -7.756964656621594e-17,  2.488023305907297e-19, -4.317620140337228e-22, -1.571982546157669e-25,  4.156610376425685e-27, -1.639123641533441e-29,  2.635756255987924e-01,
 -1.108954527346718e-03,  3.054491247397182e-06, -5.756601124268484e-09,  4.132773340627454e-12,  2.015992659503945e-14, -1.036703531538612e-16,  2.517935450461767e-19,
 -1.879408305592515e-22, -1.288252289174964e-24,  6.830933716346811e-27, -1.707871441951777e-29,  3.062426825741074e-01, -1.264390282178840e-03,  3.320263446941231e-06,
 -5.482162662106926e-09,  5.557842848846604e-13,  3.259725126918284e-14, -1.215204507398382e-16,  2.036226769597622e-19,  2.036884033512512e-22, -2.500633946276221e-24,
  8.058706609124315e-27, -9.713670219740557e-30,  3.517877427201958e-01, -1.422536195798834e-03,  3.537330876693054e-06, -4.906952245058274e-09, -3.794262722655113e-12,
  4.450710997730905e-14, -1.260194291043834e-16,  9.818573504602023e-20,  6.916428875756764e-22, -3.420528024281816e-24,  6.659174416155107e-27,  6.253876525998708e-30,
  4.001098600470308e-01, -1.581375997526272e-03,  3.694360666976712e-06, -4.018476504436613e-09, -8.708743205865114e-12,  5.439938791448175e-14, -1.129311297976211e-16,
 -6.026963562818104e-20,  1.180527774844809e-21, -3.625763504327162e-24,  2.011625849260932e-27,  2.738237337824726e-29,  4.510967776158771e-01, -1.738776664453697e-03,
  3.780780180867703e-06, -2.819076390670987e-09, -1.389750682111369e-11,  6.070856247594535e-14, -7.978465188504638e-17, -2.550115789414902e-19,  1.542158922279290e-21,
 -2.770475212655183e-24, -5.444629465932696e-27,  4.602154072831448e-29,  5.046240375942574e-01, -1.892501198491251e-03,  3.787148271025979e-06, -1.327862709295948e-09,
 -1.899830459513334e-11,  6.196376304136412e-14, -2.672669825500455e-17, -4.567156576315790e-19,  1.639502418232401e-21, -7.322427369338765e-25, -1.393489716472020e-26,
  5.210015716673129e-29,  5.605540291391498e-01, -2.040224960268347e-03,  3.705554939883277e-06,  4.178574673879049e-10, -2.359397997109103e-11,  5.698731210385781e-14,
  4.282727612314407e-17, -6.260655745300211e-19,  1.361489495252065e-21,  2.260007282446166e-24, -2.051594885596465e-26,  3.700737766258081e-29,  6.187349798337746e-01,
 -2.179556192087999e-03,  3.530043128665658e-06,  2.361860884536370e-09, -2.723792026137435e-11,  4.510525635065940e-14,  1.219139314174872e-16, -7.194012995186771e-19,
  6.629111765381937e-22,  5.570556364885131e-24, -2.181637422783546e-26, -1.380323722822916e-30,  6.789998994902228e-01, -2.308061403717840e-03,  3.257042935713189e-06,
  4.429211317387721e-09, -2.948766546298040e-11,  2.634635037336225e-14,  2.002809074279824e-16, -6.971800882078000e-19, -4.003017658006586e-22,  8.224812507804938e-24,
 -1.529216799524472e-26, -5.458770592481985e-29,  7.411654890451131e-01, -2.423296315939743e-03,  2.885804334623763e-06,  6.527611115870328e-09, -2.994573138351573e-11,
  1.599382622362911e-15,  2.653113303737139e-16, -5.342458788937142e-19, -1.652858046312912e-21,  9.128682050045764e-24, -6.747138501524593e-28, -1.030277736921142e-28,
  8.050310321505424e-01, -2.522843046037854e-03,  2.418809419129745e-06,  8.550117475260929e-09, -2.830561434673988e-11, -2.730600498525052e-14,  3.036607128479990e-16,
 -2.300371459695067e-19, -2.811461122413490e-21,  7.421739350397842e-24,  1.896782514941648e-26, -1.212329368884022e-28,  8.703772930240695e-01, -2.604354162102426e-03,
  1.862139427683716e-06,  1.037940539651458e-08, -2.439963392051047e-11, -5.763092664364845e-14,  3.035254230253733e-16,  1.839043392417364e-19, -3.534129779189516e-21,
  2.883826838413300e-24,  3.724740233262402e-26, -8.885144867934112e-29,  9.369654512740906e-01, -2.665604110997520e-03,  1.225765521247475e-06,  1.189368985981581e-08,
 -1.824382552504220e-11, -8.590244676825509e-14,  2.572932307946072e-16,  6.421466723384117e-19, -3.506652468982792e-21, -3.747231830509887e-24,  4.606225879220377e-26,
 -3.997429892404617e-30,  1.004536112821060e+00, -2.704548316559079e-03,  5.237259290886567e-07,  1.297430571715688e-08, -1.007368565679835e-11, -1.082506987102346e-13,
  1.641373846740551e-16,  1.051989188318400e-18, -2.551618001884865e-21, -1.072088375904250e-23,  3.874172002159200e-26,  1.078383054102696e-28,  1.072808445674588e+00,
 -2.719389925921040e-03, -2.258536657915376e-07,  1.351477724610170e-08, -3.634694812761340e-13, -1.209037676738766e-13,  3.194651497437486e-17,  1.309816082169280e-18,
 -7.301615464405578e-22, -1.562332660806390e-23,  1.381559182464466e-26,  1.971016002383177e-28,  1.141479500066997e+00, -2.708653727775786e-03, -1.000943731165145e-06,
  1.343098664266658e-08,  1.017867726317336e-11, -1.208038329835004e-13, -1.221060741165558e-16,  1.326002418252198e-18,  1.604665573919698e-21, -1.615135718681749e-23,
 -2.234303723433780e-26,  2.097590571723598e-28,  1.210223783979614e+00, -2.671266154002809e-03, -1.776046768860743e-06,  1.267177677749152e-08,  2.064673524483915e-11,
 -1.062683577487961e-13, -2.729847076252835e-16,  1.053814104767905e-18,  3.843550900107111e-21, -1.113093710948717e-23, -5.601258255342415e-26,  1.182564211863231e-28,
  1.278693176890014e+00, -2.606639489629716e-03, -2.522930018637555e-06,  1.122901637871244e-08,  3.000858138157521e-11, -7.757933715083637e-14, -3.915483734446610e-16,
  5.143130116045698e-19,  5.267173668543656e-21, -1.385999381701945e-24, -7.089491101399105e-26, -5.183026223161378e-29,  1.346517275778326e+00, -2.514757453731108e-03,
 -3.211688942133366e-06,  9.145851943389827e-09,  3.721370188963509e-11, -3.735255712667982e-14, -4.504451890080890e-16, -1.927956178492728e-19,  5.285089953070643e-21,
  1.004821343100338e-23, -5.616864804416372e-26, -2.202986131568621e-28,  1.413304276860164e+00, -2.396258197003732e-03, -3.812155974427042e-06,  6.521628957313251e-09,
  4.133049711045656e-11,  9.467825165317363e-15, -4.312040362262698e-16, -9.014319975743402e-19,  3.697721540332117e-21,  1.874608714521203e-23, -1.416844012768830e-26,
 -2.882762029029412e-28,  1.478642502563645e+00, -2.252509545733213e-03, -4.295639015299303e-06,  3.511866818041493e-09,  4.169860678316632e-11,  5.611042521745500e-14,
 -3.308058132097885e-16, -1.418158867215992e-18,  8.697125354373554e-22,  2.069646794486009e-23,  3.745669417505498e-26, -2.002056285162381e-28,  1.542102683941820e+00,
 -2.085670107049011e-03, -4.636932957492886e-06,  3.218144055112382e-10,  3.807302217569221e-11,  9.500916799019536e-14, -1.654990697722101e-16, -1.581817547846979e-18,
 -2.299853389187217e-21,  1.442035650075232e-23,  7.266983710813337e-26,  6.423868386572972e-30,  1.603241101691874e+00, -1.898728790719796e-03, -4.816496459961820e-06,
 -2.807407673683624e-09,  3.072979287871367e-11,  1.192668117669721e-13,  3.026951269034910e-17, -1.326096371001439e-18, -4.663815416668628e-21,  2.249079489081497e-24,
  7.143747283653384e-26,  2.083456273728249e-28,  1.661603671780759e+00, -1.695514607914600e-03, -4.822629163649596e-06, -5.620191870965484e-09,  2.050078334706865e-11,
  1.242842560476055e-13,  2.109187841935517e-16, -7.191893081229231e-19, -5.301672316163246e-21, -1.029487654038953e-23,  3.358028624990011e-26,  2.734572447498644e-28,
  1.716731032071666e+00, -1.480668532897473e-03, -4.653429064309341e-06, -7.874194830627309e-09,  8.710249219956364e-12,  1.091441829954022e-13,  3.319572861042897e-16,
  4.369197248272167e-20, -3.980513980648240e-21, -1.716532708650981e-23, -1.846067712024345e-26,  1.611519226409147e-28,  1.768164642663459e+00, -1.259570033891644e-03,
 -4.318266848915179e-06, -9.371747705008384e-09, -2.998903102260720e-12,  7.727668699514319e-14,  3.641439651783113e-16,  7.038205496828769e-19, -1.339743512850084e-21,
 -1.525698108630652e-23, -5.288464446547292e-26, -3.765812576732326e-29,  1.815453854482224e+00, -1.038212839302636e-03, -3.838497437447406e-06, -9.990666017046855e-09,
 -1.293674400392963e-11,  3.602461092265321e-14,  3.045103288456469e-16,  1.040920949048926e-18,  1.371113914870088e-21, -6.452219217535620e-24, -5.056973125670229e-26,
 -1.698638869639415e-28,  1.858163829473255e+00, -8.230277522371705e-04, -3.247152949133664e-06, -9.709043383562181e-09, -1.969340875655281e-11, -5.002764949448906e-15,
  1.790645215083667e-16,  9.702041424022270e-19,  2.929427044429857e-21,  3.470303002650613e-24, -1.909259817341495e-26, -1.499864081568108e-28,  1.895884115516929e+00,
 -6.206548288543111e-04, -2.587436687420935e-06, -8.618325131479016e-09, -2.245192383663858e-11, -3.648948178739046e-14,  3.442991267309112e-17,  5.827936483673510e-19,
  2.810050407065023e-21,  8.699545973508529e-24,  1.426485111047713e-26, -2.997983426292778e-29,  1.928237596991091e+00, -4.376727111238879e-04, -1.909967284692218e-06,
 -6.919943243946692e-09, -2.120321307514015e-11, -5.216996425102903e-14, -7.973001520033131e-17,  9.931257725444668e-20,  1.455422678856580e-21,  7.338709040954460e-24,
  2.591926031391207e-26,  6.435590282484087e-29,  1.954889469011712e+00, -2.802987690804152e-04, -1.268896111726072e-06, -4.903214153713645e-09, -1.678912734963897e-11,
 -5.083049498180116e-14, -1.307415473321155e-16, -2.470662154475187e-19, -7.306430950902580e-23,  2.296232452669481e-24,  1.481384919083247e-26,  6.415154298002533e-29,
  1.975555843013953e+00, -1.540790495096169e-04, -7.172147186557594e-07, -2.905806508281185e-09, -1.073583912433868e-11, -3.671539648416063e-14, -1.161896493598872e-16,
 -3.353946309135657e-19, -8.488671062839821e-22, -1.672743023888931e-24, -1.167929681922082e-27,  1.126636301853043e-29,  1.990011696803470e+00, -6.359020342998861e-05,
 -3.017422722652206e-07, -1.262144688052301e-09, -4.897303356666502e-12, -1.800443661915495e-14, -6.332355931127506e-17, -2.138718732250887e-19, -6.935326636762399e-22,
 -2.150818346740801e-24, -6.322463136403364e-27, -1.730327096732779e-29,  1.998099836250690e+00, -1.216475922734442e-05, -5.834086423060928e-08, -2.483257325989599e-10,
 -9.890307996339236e-13, -3.772848906877602e-15, -1.395472869541300e-17, -5.040384346932040e-20, -1.785740795427138e-22, -6.223310777548768e-25, -2.137341997069017e-27,
 -7.242288524897026e-30,  4.230679189632688e-04, -1.958364199434840e-06,  6.797618059535400e-09, -2.096883074014196e-11,  6.062179181639174e-14, -1.681936049513191e-16,
  4.534883257045746e-19, -1.197217128273588e-21,  3.109509671494700e-24, -7.972106249825789e-27,  2.021978997961541e-29, -5.082608569275061e-32,  3.806695098167984e-03,
 -1.759976516296993e-05,  6.093255909767410e-08, -1.871269100709106e-10,  5.373180798152175e-13, -1.476377185969783e-15,  3.928652419473790e-18, -1.019500459109544e-20,
  2.590632223292097e-23, -6.462966556128969e-26,  1.585089190480392e-28, -3.824969320127301e-31,  1.056905277754250e-02, -4.874645033392772e-05,  1.678930194998687e-07,
 -5.109975350124848e-10,  1.447049215664797e-12, -3.897138818671159e-15,  1.008726637331948e-17, -2.522240700500046e-20,  6.102564436511666e-23, -1.427717656409615e-25,
  3.218304858518024e-28, -6.942284113536654e-31,  2.070029746466559e-02, -9.512595276810911e-05,  3.250726965288188e-07, -9.759209169742687e-10,  2.704824615155650e-12,
 -7.056717115480321e-15,  1.745378124459992e-17, -4.092510762903287e-20,  9.034951069204658e-23, -1.847266676403358e-25,  3.366842998682496e-28, -4.921146469561304e-31,
  3.418553816988618e-02, -1.563290051588787e-04,  5.285938376468038e-07, -1.557486138988072e-09,  4.188939173146549e-12, -1.043720401743027e-14,  2.407504148773468e-17,
 -5.064828013800525e-20,  9.323606638508949e-23, -1.323886570170893e-25,  5.737283036200523e-29,  5.319607844120725e-31,  5.100468434707787e-02, -2.318089069364027e-04,
  7.733462611536742e-07, -2.224227029962071e-09,  5.747767282441306e-12, -1.342532762270316e-14,  2.780612491281140e-17, -4.787506133861951e-20,  5.291444942301091e-23,
  4.728504637515569e-26, -5.423292054111446e-28,  2.204595430064511e-30,  7.113224123165969e-02, -3.208807612648469e-04,  1.053041010131144e-06, -2.938551532663919e-09,
  7.208574460624053e-12, -1.537331949095062e-14,  2.664854079468942e-17, -2.780700175383323e-20, -3.719690371122755e-23,  3.408232941791136e-25, -1.310391161642141e-27,
  3.766501343014740e-30,  9.453705096268467e-02, -4.227206551133543e-04,  1.360280021678993e-06, -3.657904403258062e-09,  8.388117354007632e-12, -1.566827166272949e-14,
  1.910614235623584e-17,  1.116588636638368e-20, -1.687441425475636e-22,  6.782649240168369e-25, -1.921632937209865e-27,  4.064425279607799e-30,  1.211819775136362e-01,
 -5.363648787522370e-04,  1.686643518180305e-06, -4.336161120269508e-09,  9.104724540964905e-12, -1.380549732206886e-14,  4.518389271486691e-18,  6.637446252022858e-20,
 -3.166631484707740e-22,  9.402553203501490e-25, -1.961474513634780e-27,  2.036694499937412e-30,  1.510235331289918e-01, -6.607093075265622e-04,  2.022797129105659e-06,
 -4.925247535430930e-09,  9.191459607528816e-12, -9.460564307314108e-15, -1.667278873617241e-17,  1.304137684937391e-19, -4.414103713871190e-22,  9.842582938320348e-25,
 -1.078516563995051e-27, -2.644071702251587e-30,  1.840114436851623e-01, -7.945090992986282e-04,  2.358621016210188e-06, -5.376974695689416e-09,  8.509863686239308e-12,
 -2.553925251237189e-15, -4.276653257799114e-17,  1.915243970462110e-19, -4.956013880540858e-22,  6.870402199574792e-25,  8.316133495975360e-28, -9.024623876227910e-30,
  2.200881501843911e-01, -9.363788962367727e-04,  2.683363481193470e-06, -5.645070996898278e-09,  6.963657760067241e-12,  6.698500213131967e-15, -7.079724069425070e-17,
  2.349261078696860e-19, -4.345977065534501e-22, -4.864667353297402e-27,  3.472209973505601e-27, -1.472479352624778e-29,  2.591882434739720e-01, -1.084793760330514e-03,
  2.985821654313701e-06, -5.687383964386453e-09,  4.511658368198427e-12,  1.775572015319384e-14, -9.671093589614058e-17,  2.450886800869653e-19, -2.295792028246118e-22,
 -1.029871567498122e-24,  6.092804258118255e-27, -1.643429498339446e-29,  3.012378292936417e-01, -1.238091118709790e-03,  3.254551856497002e-06, -5.468211065318030e-09,
  1.179029679903911e-12,  2.974983323011550e-14, -1.157408582386939e-16,  2.087616903264685e-19,  1.193606928308977e-22, -2.187282117422243e-24,  7.598764075872956e-27,
 -1.110459314084197e-29,  3.461538209335133e-01, -1.394474047944524e-03,  3.478112045576677e-06, -4.960702662075225e-09, -2.934130051519813e-12,  4.151802313599903e-14,
 -1.229785151219252e-16,  1.183999587648305e-19,  5.733539649631292e-22, -3.149837993433710e-24,  6.847340969315678e-27,  2.410748249941191e-30,  3.938431571870337e-01,
 -1.552016286113049e-03,  3.645338334764429e-06, -4.149260254362584e-09, -7.647974058151061e-12,  5.167293899452526e-14, -1.141093019083220e-16, -2.456340046907338e-20,
  1.051723809498073e-21, -3.522866311700012e-24,  3.092869877637945e-27,  2.184145828879177e-29,  4.442019439753022e-01, -1.708669427205933e-03,  3.745656827771238e-06,
 -3.031829497576463e-09, -1.270303383067325e-11,  5.871352982342662e-14, -8.624935987864687e-17, -2.072964478516700e-19,  1.438976142895143e-21, -2.949252605163316e-24,
 -3.531489337045141e-27,  4.091025815802471e-29,  4.971145190835783e-01, -1.862272823334602e-03,  3.769430852839244e-06, -1.621960473968398e-09, -1.776644905098890e-11,
  6.117476617016813e-14, -3.878494360138099e-17, -4.047764687963687e-19,  1.603657390106997e-21, -1.244205210879040e-24, -1.167544881723707e-26,  5.042602893672397e-29,
  5.524524409888177e-01, -2.010566794199079e-03,  3.708341983873103e-06,  4.952173389172615e-11, -2.244534935730186e-11,  5.780980143859838e-14,  2.591850817144592e-17,
 -5.813512573056656e-19,  1.428483831887695e-21,  1.473352686283673e-24, -1.878491696057813e-26,  4.138488435245735e-29,  6.100734048891978e-01, -2.151209816891501e-03,
  3.555800884764450e-06,  1.933423173876973e-09, -2.630817424009509e-11,  4.779204823316360e-14,  1.020966266256878e-16, -6.951478401979516e-19,  8.477594307370422e-22,
  4.700029152462336e-24, -2.163032292862267e-26,  9.555938823224872e-30,  6.698200919140146e-01, -2.281800437023718e-03,  3.307380872025018e-06,  3.961878592608029e-09,
 -2.891425857776076e-11,  3.091766140867531e-14,  1.806241748350087e-16, -7.053747471766410e-19, -1.157583450573194e-22,  7.569406912811184e-24, -1.737213907525652e-26,
 -4.004440336548358e-29,  7.315189612559974e-01, -2.399904696515022e-03,  2.961263039921805e-06,  6.049076091264636e-09, -2.985131028285000e-11,  7.781674455675394e-15,
  2.496612822670662e-16, -5.818930926824896e-19, -1.325773441796567e-21,  9.014385457724074e-24, -4.954201059370125e-27, -9.124135155055264e-29,  7.949789998051746e-01,
 -2.503089903117223e-03,  2.518676744138126e-06,  8.093252288839973e-09, -2.877942907433662e-11, -2.010535474765984e-14,  2.960012882047536e-16, -3.155929775819936e-19,
 -2.531906220363899e-21,  8.073928847290439e-24,  1.365208443798984e-26, -1.198070689487718e-28,  8.599904499596097e-01, -2.588965556942128e-03,  1.984313177498453e-06,
  9.980187624855930e-09, -2.547905485874718e-11, -5.029719803243317e-14,  3.071090661478919e-16,  7.275290802249853e-20, -3.404476126181433e-21,  4.291191471349723e-24,
  3.302072744265899e-26, -1.025929697974851e-28,  9.263235438238739e-01, -2.655232180397324e-03,  1.366682799657718e-06,  1.158838565394108e-08, -1.989873371138103e-11,
 -7.952443995442616e-14,  2.736846081939077e-16,  5.281301617947447e-19, -3.608503626383713e-21, -1.916274882628200e-24,  4.529102245751850e-26, -3.069744949082857e-29,
  9.937272811335054e-01, -2.699738645595903e-03,  6.783797986816376e-07,  1.279603051448274e-08, -1.219696990549950e-11, -1.039675054672586e-13,  1.923941193241790e-16,
  9.644700541944999e-19, -2.908607908476091e-21, -9.084654791178165e-24,  4.285979948421885e-26,  7.903433099131937e-29,  1.061928299053875e+00, -2.720548328244643e-03,
 -6.379085951096162e-08,  1.348967120516190e-08, -2.770922843641981e-12, -1.197001088402322e-13,  6.821055701964407e-17,  1.277575270181418e-18, -1.280598927838578e-21,
 -1.490117584953213e-23,  2.218381839017695e-26,  1.822671941029725e-28,  1.130629894476475e+00, -2.716014006259280e-03, -8.388749500135607e-07,  1.357437036027804e-08,
  7.736330206323957e-12, -1.232835824529269e-13, -8.434765132545553e-17,  1.367894350732345e-18,  1.009391650865959e-21, -1.685646039592029e-23, -1.282557178651865e-26,
  2.216345776128551e-28,  1.199511273382869e+00, -2.684860830746212e-03, -1.622074623147767e-06,  1.298477590957524e-08,  1.845831201204893e-11, -1.124523963671066e-13,
 -2.418192630892572e-16,  1.169974767942056e-18,  3.403867328754107e-21, -1.325586788853385e-23, -4.995581794220897e-26,  1.564179175726018e-28,  1.268227116820121e+00,
 -2.626275895870595e-03, -2.385353840341709e-06,  1.169623564593233e-08,  2.836428765656505e-11, -8.678470860875357e-14, -3.747993403010462e-16,  6.815132661642046e-19,
  5.165806095610744e-21, -4.253918404325152e-24, -7.216100109604016e-26, -5.171462872227296e-30,  1.336407568235465e+00, -2.540001902847738e-03, -3.098392762977749e-06,
  9.734705896494448e-09,  3.635820676945420e-11, -4.820859182614363e-14, -4.534245643408628e-16, -1.833712478927305e-20,  5.604113670010458e-21,  7.614934020877621e-24,
 -6.529684978645772e-26, -1.930548173803825e-28,  1.403658761105591e+00, -2.426431154017650e-03, -3.729924294709534e-06,  7.183861139912660e-09,  4.141439193020440e-11,
 -1.169962854496584e-15, -4.546870239892799e-16, -7.724416289760735e-19,  4.359281249532894e-21,  1.792126490526598e-23, -2.716476733180867e-26, -3.008959338516399e-28,
  1.469564017179444e+00, -2.286694663808804e-03, -4.249457948408237e-06,  4.187577388448832e-09,  4.273822471888324e-11,  4.769842754464372e-14, -3.700106634130699e-16,
 -1.378135827530116e-18,  1.639500209437938e-21,  2.200419264182252e-23,  2.757776545292554e-26, -2.484659083496600e-28,  1.533685851852780e+00, -2.122739624818979e-03,
 -4.629354209007691e-06,  9.459532142314365e-10,  3.992985732545599e-11,  9.049788308317685e-14, -2.107382538965663e-16, -1.646546062131400e-18, -1.728466958888422e-21,
  1.731767290487655e-23,  7.180832963154761e-26, -4.678251072060584e-29,  1.595568921262148e+00, -1.937386977986072e-03, -4.847156483197800e-06, -2.296621752988399e-09,
  3.311929944384114e-11,  1.195309423034471e-13, -8.934368709264356e-18, -1.473473874827244e-18, -4.529252130616078e-21,  5.284513121800283e-24,  8.018065503427180e-26,
  1.872438968023005e-28,  1.654744032271474e+00, -1.734359643556967e-03, -4.888020491917142e-06, -5.272026014227933e-09,  2.303535735969830e-11,  1.290851558247354e-13,
  1.883526053809442e-16, -8.944894276680787e-19, -5.645139433467291e-21, -8.703311195312068e-24,  4.617911389588982e-26,  2.982898802797537e-28,  1.710733308203245e+00,
 -1.518271388863542e-03, -4.747009780506319e-06, -7.716934751896034e-09,  1.097282489368275e-11,  1.171108691019741e-13,  3.313035606235445e-16, -9.369952496850575e-20,
 -4.609922671641872e-21, -1.774805199660216e-23, -1.032445018159455e-26,  2.093425294596837e-28,  1.763056557012694e+00, -1.294566707695969e-03, -4.430963157232080e-06,
 -9.406884434424816e-09, -1.364405789840838e-12,  8.624725917579055e-14,  3.831652376302937e-16,  6.517497332220928e-19, -1.927393190586593e-21, -1.739682900784800e-23,
 -5.387764854861500e-26, -6.049673464940880e-30,  1.811238822983191e+00, -1.069403832178632e-03, -3.959602267296625e-06, -1.019148290601523e-08, -1.214078383723991e-11,
  4.368733725301932e-14,  3.342325863581673e-16,  1.080674967232360e-18,  1.100602956250466e-21, -8.626582608828971e-24, -5.819228831251197e-26, -1.758590745342861e-28,
  1.854819018559496e+00, -8.494763725603660e-04, -3.365554556734528e-06, -1.002469543757863e-08, -1.974823293264573e-11, -3.685251953226797e-16,  2.075602740866159e-16,
  1.065783913127368e-18,  3.038946691121970e-21,  2.566433535603999e-24, -2.630770408543740e-26, -1.783774101314151e-28,  1.893359433527541e+00, -6.417741640272947e-04,
 -2.693035895705159e-06, -8.983343598594801e-09, -2.317207476101901e-11, -3.545689082593714e-14,  5.205488798337659e-17,  6.778334247676897e-19,  3.133137858712022e-21,
  9.238313350443123e-24,  1.253057267630370e-26, -4.961805531826590e-29,  1.926455812506926e+00, -4.532904539198203e-04, -1.995076878212565e-06, -7.267644772031588e-09,
 -2.226549406154328e-11, -5.404460137469627e-14, -7.625605767179362e-17,  1.503188823347568e-19,  1.738967623528930e-21,  8.432875919006169e-24,  2.880550612419980e-26,
  6.660147415720264e-29,  1.953747592403029e+00, -2.906899372779291e-04, -1.329380544611096e-06, -5.180145913286877e-09, -1.783767659276866e-11, -5.405148995587650e-14,
 -1.376788586981822e-16, -2.479615686275022e-19,  2.097544157881257e-23,  2.948462524977542e-24,  1.788014824284654e-26,  7.547998736303581e-29,  1.974927826341722e+00,
 -1.599592229273425e-04, -7.531397691166142e-07, -3.083609157907173e-09, -1.149880934573007e-11, -3.961976610735131e-14, -1.259701026769245e-16, -3.635298505696735e-19,
 -9.097958701219908e-22, -1.708275513963543e-24, -5.752711162364938e-28,  1.585938916458516e-29,  1.989752410273064e+00, -6.606608453316569e-05, -3.173703057248540e-07,
 -1.343466907651744e-09, -5.273088075508203e-12, -1.959864413355783e-14, -6.963467141646286e-17, -2.373541249412033e-19, -7.757033527151052e-22, -2.419558606870787e-24,
 -7.130145816200516e-27, -1.944471557603173e-29,  1.998050224499697e+00, -1.264368064811675e-05, -6.141827034327561e-08, -2.647725699173567e-10, -1.067954655812832e-12,
 -4.125365117810093e-15, -1.544952690879781e-17, -5.649382141474467e-20, -2.025969120900880e-22, -7.145557465448998e-25, -2.483131183104361e-27, -8.511542798489603e-30,
  4.153416533698255e-04, -1.904973521574811e-06,  6.551702659761150e-09, -2.002521289765215e-11,  5.736409863227531e-14, -1.577011658122221e-16,  4.213172494849865e-19,
 -1.102152924671116e-21,  2.836549020428710e-24, -7.206307601681648e-27,  1.811171869328026e-29, -4.511607580811219e-32,  3.737256940229331e-03, -1.712114284263912e-05,
  5.873766063697596e-08, -1.787610135790583e-10,  5.087107655773156e-13, -1.385423479076454e-15,  3.654457084903538e-18, -9.402037445477475e-21,  2.368983865408167e-23,
 -5.861346227087414e-26,  1.426001448359935e-28, -3.414480129646962e-31,  1.037671497666937e-02, -4.742744630159059e-05,  1.618974356547564e-07, -4.884553721846752e-10,
  1.371471299414835e-12, -3.663303147524997e-15,  9.407623158342625e-18, -2.334939696347143e-20,  5.611039545306203e-23, -1.304899759596167e-25,  2.927298647664794e-28,
 -6.295693292458070e-31,  2.032492167144286e-02, -9.257149026785028e-05,  3.136167239290939e-07, -9.337504219465485e-10,  2.567788024912094e-12, -6.651256550806519e-15,
  1.634737335821257e-17, -3.813776871918505e-20,  8.393658765541509e-23, -1.716876233701281e-25,  3.153906427523057e-28, -4.752812084707017e-31,  3.356856286959697e-02,
 -1.521738900638763e-04,  5.102993539749084e-07, -1.492102147168711e-09,  3.985859956225000e-12, -9.876088089085390e-15,  2.269794632572379e-17, -4.774049549916021e-20,
  8.851667313038089e-23, -1.296638295596819e-25,  7.796479408420796e-29,  4.078164633466871e-31,  5.008965539878873e-02, -2.257273565250839e-04,  7.471985779530862e-07,
 -2.134374998985228e-09,  5.485826614336685e-12, -1.277387387895952e-14,  2.648955599691380e-17, -4.615856540901801e-20,  5.424876414939142e-23,  2.743943589226344e-26,
 -4.521661173851409e-28,  1.900426886449884e-30,  6.986534625041316e-02, -3.125955460681151e-04,  1.018460380331138e-06, -2.825639589716126e-09,  6.907440005997571e-12,
 -1.474322118510988e-14,  2.585505478667513e-17, -2.881078768272577e-20, -2.583189427536291e-23,  2.916032308746192e-25, -1.153492076988489e-27,  3.371048749809905e-30,
  9.286765801168580e-02, -4.120117364367800e-04,  1.317180168015569e-06, -3.526176439045124e-09,  8.079359659495490e-12, -1.520656064718064e-14,  1.934675680638851e-17,
  6.142264845833570e-21, -1.456677445123218e-22,  6.049033600160246e-25, -1.748269767929258e-27,  3.814047709688805e-30,  1.190631782152729e-01, -5.230774107985137e-04,
  1.635474547428251e-06, -4.192687903526676e-09,  8.829843758193977e-12, -1.367586847440296e-14,  6.239990869595357e-18,  5.676786568830099e-20, -2.842039976399222e-22,
  8.636558411573046e-25, -1.866999802383461e-27,  2.242889781913085e-30,  1.484126898445295e-01, -6.447608568136652e-04,  1.964570227728612e-06, -4.779718400077140e-09,
  8.998534519268360e-12, -9.818455913309568e-15, -1.321368885674756e-17,  1.168470322295762e-19, -4.067791388970415e-22,  9.390634199376162e-25, -1.174782895836939e-27,
 -1.758934716813704e-30,  1.808707398363743e-01, -7.758959155067793e-04,  2.294912405444255e-06, -5.241279480943067e-09,  8.448946426684916e-12, -3.517738865806940e-15,
 -3.762211921258527e-17,  1.760665585258455e-19, -4.703607267399379e-22,  7.128162160365659e-25,  4.680793898303811e-28, -7.528892857117992e-30,  2.163851420764736e-01,
 -9.151810480872505e-04,  2.616295268381104e-06, -5.532670824074517e-09,  7.081161119918013e-12,  5.076730869099682e-15, -6.441385186209518e-17,  2.210417461528645e-19,
 -4.324246161359620e-22,  1.215448095549274e-25,  2.859993382224110e-27, -1.311470412203991e-29,  2.548964111049789e-01, -1.061178928174338e-03,  2.918017482551087e-06,
 -5.612480308444937e-09,  4.844113578037370e-12,  1.551614471904553e-14, -8.995655077780336e-17,  2.371945754938135e-19, -2.624399042444576e-22, -8.003856926320918e-25,
  5.387634664354279e-27, -1.559153734821922e-29,  2.963371225756085e-01, -1.212316813043792e-03,  3.189065662010012e-06, -5.444735548936852e-09,  1.746723939468255e-12,
  2.704255748415917e-14, -1.098534822808707e-16,  2.113790463118951e-19,  4.596912772994593e-23, -1.893400787448268e-24,  7.088774806191075e-27, -1.200210373927326e-29,
  3.406311964762528e-01, -1.366888001319800e-03,  3.418328822747571e-06, -5.001165060037020e-09, -2.133005624205998e-12,  3.860829152489044e-14, -1.194231228392227e-16,
  1.349859880981479e-19,  4.649064007244031e-22, -2.874807298888217e-24,  6.880976450077623e-27, -7.777882060735621e-31,  3.876930992776700e-01, -1.523054746600841e-03,
  3.594846627867048e-06, -4.263509134498196e-09, -6.641938059916043e-12,  4.892974919333644e-14, -1.143447899409107e-16,  7.088255249549489e-21,  9.273451559298579e-22,
 -3.381454770918258e-24,  3.940918481207858e-27,  1.679097129518668e-29,  4.374269615954459e-01, -1.678853067120410e-03,  3.708093763995363e-06, -3.225798224374192e-09,
 -1.154990675691176e-11,  5.657899792442676e-14, -9.142513489164223e-17, -1.629718144884402e-19,  1.330680264898892e-21, -3.056040803279096e-24, -1.845805753199351e-27,
  3.571111002026156e-29,  4.897256087147304e-01, -1.832199970450432e-03,  3.748301949281680e-06, -1.896490021468720e-09, -1.655315036495097e-11,  6.011367695228854e-14,
 -4.940759753747860e-17, -3.542619304282295e-19,  1.550988039316525e-21, -1.667558665238161e-24, -9.511322425072112e-27,  4.780755769869825e-29,  5.444695025444954e-01,
 -1.980903698356510e-03,  3.706819740193102e-06, -3.003259308153468e-10, -2.128422450633724e-11,  5.824172092386929e-14,  1.028759449773341e-17, -5.349325246051418e-19,
  1.468446730386475e-21,  7.592850144079413e-25, -1.689882212029692e-26,  4.408512818589060e-29,  6.015255953704354e-01, -2.122677687848182e-03,  3.576508334186741e-06,
  1.520265687042058e-09, -2.532939019564553e-11,  5.001201349116518e-14,  8.303653496253962e-17, -6.654783131595055e-19,  1.001514018501522e-21,  3.846060439324898e-24,
 -2.100112005232764e-26,  1.875372751371318e-29,  6.607460983234158e-01, -2.255159036061672e-03,  3.352168796566498e-06,  3.504426095591708e-09, -2.825415645010220e-11,
  3.501546402065288e-14,  1.608618129046921e-16, -7.048563466564878e-19,  1.438454620900123e-22,  6.843413794879590e-24, -1.882686181064695e-26, -2.622981866783402e-29,
  7.219671709636808e-01, -2.375932342184227e-03,  3.030992402368746e-06,  5.573020130917451e-09, -2.963710132874047e-11,  1.357353345097965e-14,  2.328227979611397e-16,
 -6.191714320362506e-19, -1.005755981210432e-21,  8.739688227076082e-24, -8.685749670907064e-27, -7.821928181591089e-29,  7.850075430193340e-01, -2.482559869126952e-03,
  2.613020918590233e-06,  7.629947386884415e-09, -2.911125778866984e-11, -1.311624635898746e-14,  2.860747789553374e-16, -3.918682449240129e-19, -2.232675459463513e-21,
  8.515752911763901e-24,  8.473696633666495e-27, -1.150676966001914e-28,  8.496670853554686e-01, -2.572619006666436e-03,  2.101597542171725e-06,  9.564876138694899e-09,
 -2.641119062456985e-11, -4.291429441951973e-14,  3.076459315611452e-16, -3.347270418692369e-20, -3.227335204982378e-21,  5.518612772257713e-24,  2.828046996449982e-26,
 -1.121862892964768e-28,  9.157253549468582e-01, -2.643748006478730e-03,  1.503781832153199e-06,  1.125764368124552e-08, -2.142240806621362e-11, -7.279165728840536e-14,
  2.868477475610228e-16,  4.119008347119251e-19, -3.645272422260611e-21, -1.389568541698839e-25,  4.339923933448015e-26, -5.480163674047705e-29,  9.829401482363403e-01,
 -2.693700871673412e-03,  8.306934744877288e-07,  1.258450406583145e-08, -1.422801360294503e-11, -9.903679239504818e-14,  2.180494541647095e-16,  8.664989938432549e-19,
 -3.204038408083899e-21, -7.309517985180458e-24,  4.567771015091931e-26,  4.893943586687833e-29,  1.051046108999044e+00, -2.720412085900159e-03,  9.774050542555925e-08,
  1.342628544173673e-08, -5.145682957739318e-12, -1.176389099941394e-13,  1.033296213376064e-16,  1.228199641870900e-18, -1.799186962778787e-21, -1.385908509173922e-23,
  2.977114559984392e-26,  1.617460881542360e-28,  1.119753450827255e+00, -2.722071519841024e-03, -6.753215057153030e-07,  1.367832936185878e-08,  5.253533978091569e-12,
 -1.248452274013307e-13, -4.568622404522790e-17,  1.390405743685591e-18,  3.956924887655732e-22, -1.717261934006709e-23, -2.951022995931660e-27,  2.259370317599551e-28,
  1.188746870569008e+00, -2.697209310747026e-03, -1.464560523352013e-06,  1.326181253985235e-08,  1.615394265555833e-11, -1.178510931615024e-13, -2.076094463170666e-16,
  1.270891566554325e-18,  2.892440587667404e-21, -1.510619871983068e-23, -4.231649487759949e-26,  1.899265607127152e-28,  1.257684747203113e+00, -2.644789727250569e-03,
 -2.242334883503406e-06,  1.213569677878550e-08,  2.654028318039775e-11, -9.553238617831752e-14, -3.534296800444248e-16,  8.438121312918803e-19,  4.960784504799460e-21,
 -7.130582111783821e-24, -7.131476759878988e-26,  4.386978369403249e-29,  1.326198740037618e+00, -2.564311966754134e-03, -2.978119636898533e-06,  1.030813275755725e-08,
  3.528527718652996e-11, -5.907644328910932e-14, -4.513898361722707e-16,  1.648605987918351e-19,  5.829281050510737e-21,  4.843253274750674e-24, -7.302171355694923e-26,
 -1.566199752953940e-28,  1.393893919570138e+00, -2.455914463991788e-03, -3.639744891572305e-06,  7.845704242368775e-09,  4.128019985630671e-11, -1.232564066457199e-14,
 -4.742670873842461e-16, -6.228576927556361e-19,  4.981682514830739e-21,  1.656839669138438e-23, -4.049609898424852e-26, -3.032734348815529e-28,  1.460349581955954e+00,
 -2.320477629582091e-03, -4.195074267707411e-06,  4.878525234703484e-09,  4.360029886947520e-11,  3.836178543200702e-14, -4.077434937866804e-16, -1.312806704482532e-18,
  2.448748773795786e-21,  2.287513694849288e-23,  1.564308211649238e-26, -2.932349258110233e-28,  1.525120911090683e+00, -2.159718056122410e-03, -4.614110708773376e-06,
  1.599020010054302e-09,  4.168547365442436e-11,  8.488127113256595e-14, -2.575182495756339e-16, -1.691332710509821e-18, -1.053980395275186e-21,  2.013166493273589e-23,
  6.845557427901626e-26, -1.065759206687030e-28,  1.587741657260389e+00, -1.976265277705839e-03, -4.871457677835868e-06, -1.747613981189924e-09,  3.550434838780503e-11,
  1.188052507611187e-13, -5.218763836517090e-17, -1.614731461086443e-18, -4.279372211180238e-21,  8.647761201356351e-24,  8.774360888957944e-26,  1.545348759323809e-28,
  1.647727993801619e+00, -1.773710401362406e-03, -4.948987442136459e-06, -4.882569946110320e-09,  2.566012972305913e-11,  1.332843809632902e-13,  1.607334688040177e-16,
 -1.079764459493123e-18, -5.921992088558298e-21, -6.587771894368166e-24,  5.972932600087926e-26,  3.163011162815356e-28,  1.704583688456045e+00, -1.556614714557660e-03,
 -4.838480916915243e-06, -7.522200994205352e-09,  1.339425395537730e-11,  1.250134092778922e-13,  3.265182165862897e-16, -2.515007236247813e-19, -5.253930230056244e-21,
 -1.796182562183566e-23,  1.157566202238256e-29,  2.609143179931396e-28,  1.757806679501211e+00, -1.330466180152774e-03, -4.543918195084983e-06, -9.414409646412374e-09,
  4.539386901463414e-13,  9.565464977595872e-14,  4.004536411722278e-16,  5.796367844834429e-19, -2.592433456054607e-21, -1.954596338128523e-23, -5.328258433687097e-26,
  3.466967703642149e-29,  1.806897074894616e+00, -1.101573074501972e-03, -4.083035303701615e-06, -1.037829927836705e-08, -1.118435100995867e-11,  5.207570250305026e-14,
  3.649345777011163e-16,  1.110460925283631e-18,  7.462763191823245e-22, -1.110964851290008e-23, -6.596527784210715e-26, -1.764157414279341e-28,  1.851366494737711e+00,
 -8.768873646651316e-04, -3.487746070637706e-06, -1.034044512495130e-08, -1.970331464645060e-11,  4.982091327669036e-15,  2.387760218276606e-16,  1.164289497938062e-18,
  3.110424794851695e-21,  1.348290172517859e-24, -3.482231325503323e-26, -2.089632896905917e-28,  1.890748556594451e+00, -6.637560079105898e-04, -2.803083701602320e-06,
 -9.359695356957115e-09, -2.386712220985711e-11, -3.396818140845402e-14,  7.248853036363310e-17,  7.835071665882985e-19,  3.474151129087219e-21,  9.689002342595006e-24,
  9.824283318891553e-27, -7.428864968172167e-29,  1.924610168461133e+00, -4.696060548952216e-04, -2.084462090258916e-06, -7.632637703297809e-09, -2.336431290206159e-11,
 -5.581766290336485e-14, -7.122081398821415e-17,  2.110513137759219e-19,  2.064000314314397e-21,  9.644001722390748e-24,  3.175449060060874e-26,  6.709848717892684e-29,
  1.952563161914643e+00, -3.015785638230784e-04, -1.393290974506164e-06, -5.474378868319615e-09, -1.895231086812618e-11, -5.743891862691363e-14, -1.445954057244285e-16,
 -2.454472909025358e-19,  1.408275385418503e-22,  3.733776713154651e-24,  2.147973214136335e-26,  8.841130988501727e-29,  1.974275700363105e+00, -1.661355433026850e-04,
 -7.912736554522455e-07, -3.274097055750784e-09, -1.232227922208353e-11, -4.276854137057184e-14, -1.365657955214300e-16, -3.936302660140037e-19, -9.715252062391185e-22,
 -1.715706914804271e-24,  2.463428887383557e-28,  2.171894618758270e-29,  1.989482963841656e+00, -6.867099806179927e-05, -3.340113606117299e-07, -1.431065214658585e-09,
 -5.682326443657024e-12, -2.135251467120933e-14, -7.664159900152637e-17, -2.636270564814696e-19, -8.681535050862954e-22, -2.722553830304004e-24, -8.036784710147525e-27,
 -2.180208807096739e-29,  1.997998646543534e+00, -1.314803278205348e-05, -6.470085433094511e-08, -2.825406003249016e-10, -1.154301862164856e-12, -4.515892750995901e-15,
 -1.712612553800599e-17, -6.340843413088026e-20, -2.302028706922276e-22, -8.217965938120662e-25, -2.889903650109088e-27, -1.002158429194137e-29,  4.078250863261166e-04,
 -1.853505743668707e-06,  6.316804727101071e-09, -1.913208041935524e-11,  5.430874378318979e-14, -1.479498530520829e-16,  3.916897158528308e-19, -1.015398157365253e-21,
  2.589697949585421e-24, -6.520015271748984e-27,  1.623949051214725e-29, -4.009052376154661e-32,  3.669698778198946e-03, -1.665968579218820e-05,  5.664046552354371e-08,
 -1.708386316652537e-10,  4.818584764583335e-13, -1.300791842238578e-15,  3.401503549880704e-18, -8.676651809771945e-21,  2.167890639065897e-23, -5.319890257585816e-26,
  1.283927895736176e-28, -3.050616487779880e-31,  1.018955894722799e-02, -4.615534512363232e-05,  1.561652537923101e-07, -4.670859110477906e-10,  1.300411140051639e-12,
 -3.445166955059185e-15,  8.778287092054924e-18, -2.162681977783325e-20,  5.161700754364473e-23, -1.193171288444753e-25,  2.663393881038736e-28, -5.709478937156029e-31,
  1.995958358579602e-02, -9.010668803152381e-05,  3.026539047590560e-07, -8.937090553044968e-10,  2.438601311728477e-12, -6.271435990771649e-15,  1.531620737572399e-17,
 -3.554829574528167e-20,  7.797792480408383e-23, -1.594846999559335e-25,  2.948965706962169e-28, -4.559297856798379e-31,  3.296792021025993e-02, -1.481620468028232e-04,
  4.927703471945845e-07, -1.429879412627351e-09,  3.793679062095498e-12, -9.347062398251180e-15,  2.140017066562321e-17, -4.498201326571556e-20,  8.390894286592723e-23,
 -1.262180958618749e-25,  9.357200148599409e-29,  3.048055167441198e-31,  4.919854101867435e-02, -2.198507449506075e-04,  7.221043972632064e-07, -2.048611486485294e-09,
  5.236602959802816e-12, -1.215343685757686e-14,  2.522154415000888e-17, -4.441013189757036e-20,  5.493043519030818e-23,  1.094428561388191e-26, -3.745274104240857e-28,
  1.634542648563550e-30,  6.863104730680299e-02, -3.045816370941111e-04,  9.852061974276831e-07, -2.717446025856406e-09,  6.618715009856117e-12, -1.413246431444164e-14,
  2.503829635951215e-17, -2.947806622673725e-20, -1.612994006136597e-23,  2.483213378173280e-25, -1.013232601184719e-27,  3.009921259873659e-30,  9.124042103142450e-02,
 -4.016413769257160e-04,  1.275631714802526e-06, -3.399314456775053e-09,  7.779882960257594e-12, -1.474068177038970e-14,  1.945666046382478e-17,  1.816148461205517e-21,
 -1.251102193442188e-22,  5.382535633807412e-25, -1.586091704006900e-27,  3.557169632232283e-30,  1.169967208838804e-01, -5.101924824528004e-04,  1.586000959304176e-06,
 -4.053589883099580e-09,  8.557947544878733e-12, -1.350803415414671e-14,  7.706740194780462e-18,  4.815658595598075e-20, -2.544324491838705e-22,  7.909918554534570e-25,
 -1.765285899811413e-27,  2.368576065877864e-30,  1.458647197179468e-01, -6.292712889042336e-04,  1.908070933222598e-06, -4.637328945048092e-09,  8.799251654219310e-12,
 -1.009776384714605e-14, -1.011919226653161e-17,  1.043617933131421e-19, -3.738352789573201e-22,  8.907497418699267e-25, -1.235583746233824e-27, -1.028556293763540e-30,
  1.778034796725481e-01, -7.577859052223818e-04,  2.232825674413263e-06, -5.106706589719437e-09,  8.369952970649656e-12, -4.363188362913888e-15, -3.289909728834788e-17,
  1.614285872912690e-19, -4.444384835738047e-22,  7.253155775473362e-25,  1.665235758273876e-28, -6.205855707959767e-30,  2.127658608541008e-01, -8.945143208826826e-04,
  2.550586094200130e-06, -5.418641888634683e-09,  7.167729674325239e-12,  3.603509608712924e-15, -5.841760038552971e-17,  2.072951461559422e-19, -4.261247052183741e-22,
  2.248604524275488e-25,  2.316936503975252e-27, -1.158437327741120e-29,  2.506979590137864e-01, -1.038102846936273e-03,  2.851142620560373e-06, -5.532606970691064e-09,
  5.133379845382150e-12,  1.343591072513057e-14, -8.343671858362490e-17,  2.283757436803233e-19, -2.875374877948778e-22, -5.983205551582314e-25,  4.722764132271451e-27,
 -1.461176422930323e-29,  2.915384672978988e-01, -1.187065119761140e-03,  3.123913910491658e-06, -5.412602391117284e-09,  2.261690259929886e-12,  2.447720244204080e-14,
 -1.039241377699174e-16,  2.118131412311950e-19, -1.721824930852556e-23, -1.620581478939398e-24,  6.548675412158991e-27, -1.248591329979808e-29,  3.352179569006233e-01,
 -1.339781949158882e-03,  3.358135054097767e-06, -5.029270237027001e-09, -1.389186905685314e-12,  3.578907923934321e-14, -1.154504174620167e-16,  1.482601092596958e-19,
  3.663520100985425e-22, -2.601055284319071e-24,  6.787809750724791e-27, -3.361928944648617e-30,  3.816580713569497e-01, -1.494502355218448e-03,  3.543078703167880e-06,
 -4.362100362811992e-09, -5.690752892486368e-12,  4.619109780986327e-14, -1.137489437269554e-16,  3.484736852176795e-20,  8.086157519278774e-22, -3.210412158666575e-24,
  4.578272252067261e-27,  1.226855137304204e-29,  4.307706293437586e-01, -1.649346211679688e-03,  3.668312346179392e-06, -3.401664777421992e-09, -1.044061401611332e-11,
  5.433474580601576e-14, -9.540882447152646e-17, -1.221615928171043e-19,  1.219698643427214e-21, -3.099967040205318e-24, -3.878911465356906e-28,  3.058011076498366e-29,
  4.824566312943864e-01, -1.802308997896237e-03,  3.723994423944352e-06, -2.151789938910612e-09, -1.536350937512933e-11,  5.881441298151133e-14, -5.864161371727305e-17,
 -3.056601949712654e-19,  1.484606289370377e-21, -2.006876466565794e-24, -7.478828362774437e-27,  4.447998724834413e-29,  5.366051659857953e-01, -1.951269256799032e-03,
  3.701211012777239e-06, -6.315464292936510e-10, -2.011810675931846e-11,  5.831421645407690e-14, -4.029450794121732e-18, -4.876315164216836e-19,  1.484085672347596e-21,
  1.225852574591952e-25, -1.492734960546613e-26,  4.529890031708445e-29,  5.930922146671682e-01, -2.093999461325280e-03,  3.592353242497576e-06,  1.123099377094709e-09,
 -2.431071122403088e-11,  5.178503327320288e-14,  6.487148949679906e-17, -6.313749072793619e-19,  1.125071571283010e-21,  3.024835501707922e-24, -2.000594616760594e-26,
  2.619345586419650e-29,  6.517793524385486e-01, -2.228181103814045e-03,  3.391533282075003e-06,  3.058165132426858e-09, -2.751683531370566e-11,  3.864005833442226e-14,
  1.412262663549420e-16, -6.964588548991002e-19,  3.764099893903205e-22,  6.071096872373510e-24, -1.969608517753574e-26, -1.347870992945698e-29,  7.125123496719149e-01,
 -2.351424936715827e-03,  3.095033407932450e-06,  5.101295919694086e-09, -2.931117504018153e-11,  1.894989034462121e-14,  2.150822024949890e-16, -6.463951102349485e-19,
 -6.981740384099472e-22,  8.327423440780881e-24, -1.182776399404776e-26, -6.453531637401819e-29,  7.751196805515468e-01, -2.461297400097946e-03,  2.701778147607431e-06,
  7.162437832174134e-09, -2.930585404053516e-11, -6.389907385062499e-15,  2.741487263559788e-16, -4.583531540367374e-19, -1.921209275173490e-21,  8.755476601875318e-24,
  3.567495472555243e-27, -1.075241301544109e-28,  8.394109515954470e-01, -2.555354358744032e-03,  2.213813556227367e-06,  9.135831445697403e-09, -2.719577691128298e-11,
 -3.555351779931825e-14,  3.052942164431918e-16, -1.333601595178217e-19, -3.009510707543532e-21,  6.549201904857188e-24,  2.320913395277279e-26, -1.176611941868490e-28,
  9.051752706421822e-01, -2.631183320014438e-03,  1.636770184448456e-06,  1.090361622068931e-08, -2.280853166071186e-11, -6.578208673924838e-14,  2.967494963217750e-16,
  2.955020167327733e-19, -3.619667116234968e-21,  1.542402777620728e-24,  4.051709568983483e-26, -7.561467512688596e-29,  9.721795866078965e-01, -2.686455286350562e-03,
  9.802772127607864e-07,  1.234130233552854e-08, -1.615451322475803e-11, -9.352427807801491e-14,  2.408389935446441e-16,  7.601157920732320e-19, -3.433855394322879e-21,
 -5.448261203945579e-24,  4.716512687699429e-26,  1.875133324469987e-29,  1.040167042690706e+00, -2.718987277659496e-03,  2.582847715996265e-07,  1.332527860023213e-08,
 -7.470912040198284e-12, -1.147532823169836e-13,  1.368398873548211e-16,  1.162886159449297e-18, -2.275027961255012e-21, -1.253302794394356e-23,  3.634768411134079e-26,
  1.364974040837910e-28,  1.108855400923590e+00, -2.726816293202139e-03, -5.107597687265675e-07,  1.374236434937301e-08,  2.748823145788028e-12, -1.254736611877450e-13,
 -6.670581067521828e-18,  1.393173121722603e-18, -2.222537856689672e-22, -1.709228253761084e-23,  6.943000731441156e-27,  2.225270401025670e-28,  1.177935614220198e+00,
 -2.708285014891247e-03, -1.303946619545497e-06,  1.350116100522914e-08,  1.375002878767993e-11, -1.223967549994457e-13, -1.708126556729110e-16,  1.354438678052542e-18,
  2.320242197408387e-21, -1.662317787828891e-23, -3.333303166760782e-26,  2.172888998494999e-28,  1.247070643245230e+00, -2.662138822078491e-03, -2.094223176515386e-06,
  1.254460360817081e-08,  2.454681772881345e-11, -1.037134961920112e-13, -3.276229986230480e-16,  9.979041194438943e-19,  4.653335003225492e-21, -9.929976993497757e-24,
 -6.829475605905981e-26,  9.329416374119120e-29,  1.315894639100852e+00, -2.587632629492595e-03, -2.851075549115814e-06,  1.086265829983451e-08,  3.399589821072593e-11,
 -6.983318688450400e-14, -4.441401033575512e-16,  3.536108424666598e-19,  5.949515448599560e-21,  1.797158968669428e-24, -7.895723820013626e-26, -1.119154370517387e-28,
  1.384012637891229e+00, -2.484644623887435e-03, -3.541643695111121e-06,  8.503591294707793e-09,  4.091854569442294e-11, -2.389877787341048e-14, -4.893880205029227e-16,
 -4.542390949647766e-19,  5.545786610021797e-21,  1.468347670823640e-23, -5.368402651562392e-26, -2.942175555219871e-28,  1.451000937832226e+00, -2.353792140437049e-03,
 -4.132322773473524e-06,  5.581723875936440e-09,  4.426674769885273e-11,  2.814445780184160e-14, -4.432805305621634e-16, -1.221175860356181e-18,  3.280297821650630e-21,
  2.323089269268734e-23,  1.862519503690513e-27, -3.319371040426580e-28,  1.516408350794851e+00, -2.196542723625630e-03, -4.590865773440959e-06,  2.279216626813357e-09,
  4.331744196752978e-11,  7.812942246523025e-14, -3.052350869243738e-16, -1.712946055565208e-18, -2.812527158658211e-22,  2.275735656918243e-23,  6.235797736640062e-26,
 -1.712110530353611e-28,  1.579758533879162e+00, -2.015310987352450e-03, -4.888942479804053e-06, -1.160619266261804e-09,  3.786418749586407e-11,  1.169950356527128e-13,
 -9.926557342799488e-17, -1.746000302897117e-18, -3.903349609922292e-21,  1.228114039990644e-23,  9.359702507534418e-26,  1.094521014914556e-28,  1.640553607444022e+00,
 -1.813529480800242e-03, -5.005026291426813e-06, -4.450483440401867e-09,  2.836183293117544e-11,  1.367575674610193e-13,  1.278148046960119e-16, -1.272574217593957e-18,
 -6.112761173079695e-21, -3.916935262711605e-24,  7.387597621099210e-26,  3.249738357033558e-28,  1.698279247613257e+00, -1.595679791530286e-03, -4.927377599784456e-06,
 -7.287467749414184e-09,  1.597221539026017e-11,  1.327457471153783e-13,  3.170253614656278e-16, -4.299490239625585e-19, -5.897638717887769e-21, -1.771612968865909e-23,
  1.266159268058754e-26,  3.142018027005056e-28,  1.752411396964656e+00, -1.367269145090766e-03, -4.656782694489590e-06, -9.391314350839232e-09,  2.464403916070341e-12,
  1.054502560900971e-13,  4.154133668793535e-16,  4.850129141782994e-19, -3.333956414491339e-21, -2.163260747029081e-23, -5.068138045361282e-26,  8.523530932320857e-29,
  1.802424661094532e+00, -1.134738475140963e-03, -4.208612652300180e-06, -1.054843029221326e-08, -1.005272182516850e-11,  6.120955764094334e-14,  3.962979716537225e-16,
  1.127418246942166e-18,  2.969748671138516e-22, -1.390211792563043e-23, -7.360928347473651e-26, -1.696667853205069e-28,  1.847802347914619e+00, -9.052910242462729e-04,
 -3.613718602799316e-06, -1.065457837388539e-08, -1.954366768460745e-11,  1.111519920158372e-14,  2.727748714977471e-16,  1.264312335365297e-18,  3.131590238163744e-21,
 -2.378518842604714e-25, -4.471844821983638e-26, -2.410273262787232e-28,  1.888047962654508e+00, -6.866364857373322e-04, -2.917713381492401e-06, -9.746902007141164e-09,
 -2.452724529454935e-11, -3.195231090221693e-14,  9.603608885744512e-17,  9.003298162560019e-19,  3.829164115468491e-21,  1.000807640333115e-23,  5.907509473861966e-27,
 -1.047692476610871e-28,  1.922697803683141e+00, -4.866545587558559e-04, -2.178333851409075e-06, -8.015488260057137e-09, -2.449724052538045e-11, -5.744825606727785e-14,
 -6.433273059763780e-17,  2.829051694495899e-19,  2.434756032066092e-21,  1.097284931007672e-23,  3.467340977447842e-26,  6.509544027027099e-29,  1.951334131556612e+00,
 -3.129929053770897e-04, -1.460841469585556e-06, -5.786996947445220e-09, -2.013634563145239e-11, -6.099103909977621e-14, -1.513834044024549e-16, -2.386164738455910e-19,
  2.916842731858112e-22,  4.674949634542860e-24,  2.568551349133083e-26,  1.030483732542262e-28,  1.973598244161086e+00, -1.726263070489595e-04, -8.317745734106520e-07,
 -3.478278383014290e-09, -1.321133699150563e-11, -4.618195022239612e-14, -1.480319466910484e-16, -4.257034277519697e-19, -1.032864425377945e-21, -1.684678855239705e-24,
  1.359146200249293e-27,  2.915086382325121e-29,  1.989202824681046e+00, -7.141335878761288e-05, -3.517440699160237e-07, -1.525501348139720e-09, -6.128385243593808e-12,
 -2.328372380981799e-14, -8.442727724349121e-17, -2.930401241214734e-19, -9.721898468485950e-22, -3.063953188501133e-24, -9.051934700988019e-27, -2.437653397433934e-29,
  1.997944997273162e+00, -1.367952254793166e-05, -6.820520902979363e-08, -3.017549244098604e-10, -1.248878218650600e-12, -4.949085567139574e-15, -1.900930434516258e-17,
 -7.127148329518597e-20, -2.619791231663248e-22, -9.467186069850296e-25, -3.369299734353712e-27, -1.182153291589701e-29,  4.005106987511520e-04, -1.803875095346417e-06,
  6.092337383053396e-09, -1.828631123277232e-11,  5.144149682292101e-14, -1.388813217881893e-16,  3.643843400430886e-19, -9.361613520195825e-22,  2.366257023933400e-24,
 -5.904371312183793e-27,  1.457495051316760e-29, -3.566236500381302e-32,  3.603953481205238e-03, -1.621463320560469e-05,  5.463581598028504e-08, -1.633326683897517e-10,
  4.566397195722851e-13, -1.221994455934006e-15,  3.167988454394295e-18, -8.012603844682236e-21,  1.985304340422550e-23, -4.832186349160492e-26,  1.156942178889795e-28,
 -2.727811578104135e-31,  1.000740120481111e-02, -4.492809466848686e-05,  1.506828250438932e-07, -4.468193152128510e-10,  1.233566488265457e-12, -3.241571925847907e-15,
  8.195229192828003e-18, -2.004179423451261e-20,  4.750744745991820e-23, -1.091499702709855e-25,  2.424053880394481e-28, -5.178259110943523e-31,  1.960393229827424e-02,
 -8.772770093303276e-05,  2.921594264566171e-07, -8.556752251549393e-10,  2.316769293181023e-12, -5.915514497618759e-15,  1.435494207958782e-17, -3.314262761393517e-20,
  7.244402170667266e-23, -1.480839678811335e-25,  2.752930832077267e-28, -4.349268617727257e-31,  3.238304911603546e-02, -1.442875003847044e-04,  4.759699076091074e-07,
 -1.370648594618492e-09,  3.611773386254085e-12, -8.848273016068322e-15,  2.017758770252421e-17, -4.236888170335889e-20,  7.943545422469490e-23, -1.222332371847388e-25,
  1.050513563419519e-28,  2.196939536127151e-31,  4.833053800152183e-02, -2.141708370294796e-04,  6.980158574304149e-07, -1.966737919339316e-09,  4.999487698787477e-12,
 -1.156284270975845e-14,  2.400270870205527e-17, -4.264880901055210e-20,  5.507145537801651e-23, -2.669017306841603e-27, -3.078270208534583e-28,  1.402541074458027e-30,
  6.742828004521803e-02, -2.968286459040665e-04,  9.532230193245845e-07, -2.613775411628016e-09,  6.342007791056932e-12, -1.354150017112453e-14,  2.420697390975346e-17,
 -2.985876029667869e-20, -7.888887483289662e-24,  2.103417915620580e-25, -8.881363239332472e-28,  2.681523641668918e-30,  8.965401024140221e-02, -3.915973964140017e-04,
  1.235577163448516e-06, -3.277169457633329e-09,  7.489740778733605e-12, -1.427354661773908e-14,  1.945429072310753e-17, -1.889287531316342e-21, -1.068380477562006e-22,
  4.778643478864293e-25, -1.435242898425669e-27,  3.299967451518413e-30,  1.149810221558536e-01, -4.976967397957340e-04,  1.538170562135547e-06, -3.918813516026410e-09,
  8.289741053641005e-12, -1.330778597493276e-14,  8.945323738620652e-18,  4.045693614310283e-20, -2.272024223375448e-22,  7.224869333375860e-25, -1.659517301431569e-27,
  2.429599979057195e-30,  1.433778146188362e-01, -6.142269352608610e-04,  1.853261009430154e-06, -4.498168786642702e-09,  8.595097601932171e-12, -1.030688140047307e-14,
 -7.359787984993642e-18,  9.290252022931380e-20, -3.426671192980444e-22,  8.406057231801827e-25, -1.267280609309150e-27, -4.328527140481343e-31,  1.748076763577246e-01,
 -7.401661520194283e-04,  2.172345696281858e-06, -4.973526844553878e-09,  8.275151336920354e-12, -5.100109622030388e-15, -2.857427369970412e-17,  1.476251104037059e-19,
 -4.182697976086446e-22,  7.268684272315517e-25, -8.042745551583015e-29, -5.044982555270696e-30,  2.092282038903118e-01, -8.743677723251586e-04,  2.486252630471295e-06,
 -5.303455883029289e-09,  7.226241858371210e-12,  2.269605596677718e-15, -5.280290133943782e-17,  1.938055908147300e-19, -4.164804507546585e-22,  3.077732709207262e-25,
  1.839154246274012e-27, -1.014977000305518e-29,  2.465907474271066e-01, -1.015557855100640e-03,  2.785252662536565e-06, -5.448429793741252e-09,  5.382585750302242e-12,
  1.150910536363097e-14, -7.717399991836134e-17,  2.188651320176578e-19, -3.058287765053194e-22, -4.219593726627225e-25,  4.103061554439125e-27, -1.354608024597488e-29,
  2.868397790000849e-01, -1.162332961877323e-03,  3.059195525546774e-06, -5.372632496975210e-09,  2.726772363877552e-12,  2.205407796360050e-14, -9.800949998470598e-17,
  2.103781791979839e-19, -7.097716595494779e-23, -1.369686687351991e-24,  5.995025080203625e-27, -1.262964042544498e-29,  3.299121765773654e-01, -1.313158598127911e-03,
  3.297673586351766e-06, -5.045920088004122e-09, -7.007706811318170e-13,  3.306932468993313e-14, -1.111487138802399e-16,  1.585372394165397e-19,  2.775597236033968e-22,
 -2.333138548293491e-24,  6.593200664633765e-27, -5.398550313878479e-30,  3.757364175818052e-01, -1.466368585046663e-03,  3.490217193215600e-06, -4.445909779067593e-09,
 -4.794136986027186e-12,  4.347565032807422e-14, -1.124280745593323e-16,  5.891020208722620e-20,  6.964562703018609e-22, -3.017695848877864e-24,  5.028555066138057e-27,
  8.288401377861107e-30,  4.242316750667218e-01, -1.620165750891527e-03,  3.626525524840602e-06, -3.560146540408734e-09, -9.377071924394106e-12,  5.200819499297473e-14,
 -9.829970764060641e-17, -8.491726829353622e-20,  1.108131393972898e-21, -3.090043466882715e-24,  8.480840448649414e-28,  2.564075304326688e-29,  4.753068098951827e-01,
 -1.772624418409261e-03,  3.696736609867567e-06, -2.388275065676888e-09, -1.420196088628958e-11,  5.730961203576604e-14, -6.654624655539288e-17, -2.593627279802971e-19,
  1.407435722417812e-21, -2.267983080104649e-24, -5.604361226369238e-27,  4.065799496895515e-29,  5.288592527287130e-01, -1.921695266469643e-03,  3.691739575287463e-06,
 -9.441156629047514e-10, -1.895386770950368e-11,  5.805903195355090e-14, -1.701839843213491e-17, -4.401815006715045e-19,  1.478232159325738e-21, -4.345792924868626e-25,
 -1.293137701079260e-26,  4.523377973202053e-29,  5.847737705984201e-01, -2.065213259895350e-03,  3.603531042639913e-06,  7.424922589945933e-10, -2.326085192699022e-11,
  5.313397046528784e-14,  4.771230704247905e-17, -5.937823928193028e-19,  1.219855795547147e-21,  2.249455051807424e-24, -1.872137937780879e-26,  3.191999262879383e-29,
  6.429211144887927e-01, -2.200909470313745e-03,  3.425615728400456e-06,  2.624255732524544e-09, -2.671171154033302e-11,  4.179703613806747e-14,  1.219258171103737e-16,
 -6.810697876920635e-19,  5.806771319197618e-22,  5.274861276418018e-24, -2.003234964183175e-26, -2.038042216608289e-30,  7.031565469428106e-01, -2.326427749292547e-03,
  3.153448484684079e-06,  4.635623373110886e-09, -2.888203541313018e-11,  2.389242345597305e-14,  1.967147434842566e-16, -6.640367041373426e-19, -4.075500097219741e-22,
  7.801596743745776e-24, -1.436284073823584e-26, -5.071237706567784e-29,  7.653182524834373e-01, -2.439347356505670e-03,  2.784910968055572e-06,  6.692874787512617e-09,
 -2.936893070367881e-11,  2.900029562922127e-17,  2.605016644711390e-16, -5.147702482241844e-19, -1.604559043557458e-21,  8.806292778162497e-24, -9.553330631737476e-28,
 -9.773656506395867e-29,  8.292256389893823e-01, -2.537212779098123e-03,  2.320810559299209e-06,  8.695407093402639e-09, -2.783393441092251e-11, -2.828192400212903e-14,
  3.002485339912699e-16, -2.257231628781263e-19, -2.758283696271088e-21,  7.373293849466236e-24,  1.798420728026974e-26, -1.192119760331874e-28,  8.946775454727878e-01,
 -2.617572086342567e-03,  1.765381804471307e-06,  1.052854412004652e-08, -2.405235070423418e-11, -5.857383654380400e-14,  3.034124801824369e-16,  1.808670547345241e-19,
 -3.535818868054402e-21,  3.091248048140537e-24,  3.680117275781127e-26, -9.263438372055408e-29,  9.614503814487332e-01, -2.678025220245471e-03,  1.126761318027485e-06,
  1.206818730420405e-08, -1.796553837868458e-11, -8.750132833061712e-14,  2.605569852635161e-16,  6.474594274655974e-19, -3.595914382905984e-21, -3.553845937737492e-24,
  4.734322756047708e-26, -1.039610623821550e-29,  1.029296235760318e+00, -2.716283591413301e-03,  4.173957779731663e-07,  1.318757283906504e-08, -9.730542935150218e-12,
 -1.110870283565296e-13,  1.683157247583986e-16,  1.083158101785555e-18, -2.698674094131558e-21, -1.096727125807234e-23,  4.172999138928525e-26,  1.076627682877481e-28,
  1.097941008818281e+00, -2.730242180894002e-03, -3.456703141164472e-07,  1.376627427676829e-08,  2.409021415591207e-13, -1.251670188039951e-13,  3.214668555472555e-17,
  1.376288447273866e-18, -8.302407682107209e-22, -1.662141787583823e-23,  1.652079590837119e-26,  2.116296024780250e-28,  1.167082642135941e+00, -2.718064979537117e-03,
 -1.140694152510690e-06,  1.370136828336292e-08,  1.126421149948335e-11, -1.260333390270907e-13, -1.319405931927850e-16,  1.418873244742044e-18,  1.700171908334637e-21,
 -1.775883033343906e-23, -2.330385695502869e-26,  2.372841527540282e-28,  1.236389542990665e+00, -2.678283950154757e-03, -1.941401246825774e-06,  1.292034111041192e-08,
  2.239626702373203e-11, -1.112246748614821e-13, -2.976544384625861e-16,  1.140572822012145e-18,  4.247802839393539e-21, -1.256543218642547e-23, -6.313037808735847e-26,
  1.409893349820690e-28,  1.305499329845888e+00, -2.609910689293728e-03, -2.717507999109607e-06,  1.139484395658657e-08,  3.249355419575573e-11, -8.035218490873688e-14,
 -4.315682879374779e-16,  5.444121917334253e-19,  5.956310562281986e-21, -1.444881653989402e-24, -8.276911348727249e-26, -6.036476866854089e-29,  1.374018055029077e+00,
 -2.512558511713969e-03, -3.435690270490162e-06,  9.153822101915343e-09,  4.032219245412027e-11, -3.577618814459266e-14, -4.995458357482604e-16, -2.687557002615083e-19,
  6.032666480277323e-21,  1.228254974976724e-23, -6.620794674616515e-26, -2.730198160379248e-28,  1.441520093367149e+00, -2.386570720356131e-03, -4.061075807487917e-06,
  6.293905512259120e-09,  4.472054448165036e-11,  1.710804408440491e-14, -4.758782214791838e-16, -1.102840110146102e-18,  4.114342891562429e-21,  2.300373508483350e-23,
 -1.343935442856686e-26, -3.619596361273919e-28,  1.507548916055550e+00, -2.233148348981086e-03, -4.559306467964203e-06,  2.984382063651872e-09,  4.480288705204888e-11,
  7.022798732003964e-14, -3.531970738164374e-16, -1.708372411689936e-18,  5.809154371615816e-22,  2.508133861094887e-23,  5.335176990611346e-26, -2.383533671620249e-28,
  1.571618993416156e+00, -2.054467760948724e-03, -4.899158197590166e-06, -5.362193733033616e-10,  4.017623342515273e-11,  1.140123258458200e-13, -1.498306154802223e-16,
 -1.863102508819038e-18, -3.392822751688597e-21,  1.610527162917861e-23,  9.718942864286312e-26,  5.177873978547485e-29,  1.633219082029712e+00, -1.853775391025656e-03,
 -5.055618590928718e-06, -3.974658746245250e-09,  3.112465892351036e-11,  1.393753248826264e-13,  8.942723937795432e-17, -1.469840421450231e-18, -6.197132544069909e-21,
 -6.759279151616274e-25,  8.815082831411189e-26,  3.216977968278369e-28,  1.691817142960701e+00, -1.635444061900478e-03, -5.013204940915580e-06, -7.010264066859041e-09,
  1.870212859405789e-11,  1.401879819291740e-13,  3.022496250875109e-16, -6.287522258568976e-19, -6.522828532393874e-21, -1.691751486372033e-23,  2.765364516686546e-26,
  3.669473026818594e-28,  1.746867099283404e+00, -1.404973355591876e-03, -4.769170519974991e-06, -9.334465757099471e-09,  4.674142846357093e-12,  1.155703522726499e-13,
  4.273802982706121e-16,  3.654830145127948e-19, -4.148162222839663e-21, -2.356770695371180e-23, -4.563076652825152e-26,  1.460338530706952e-28,  1.797817563977542e+00,
 -1.168916338904419e-03, -4.336116775471700e-06, -1.069895279342126e-08, -8.730858662214934e-12,  7.110011223840236e-14,  4.279193541051501e-16,  1.128331182138571e-18,
 -2.582641041537744e-22, -1.699179683284669e-23, -8.075716661160203e-26, -1.534978245651846e-28,  1.844122547092524e+00, -9.347174894415894e-04, -3.743441213773882e-06,
 -1.096513068677890e-08, -1.925297182809210e-11,  1.809790811375392e-14,  3.095746977956135e-16,  1.364019677323642e-18,  3.088187298090041e-21, -2.248262847109926e-24,
 -5.603861488657644e-26, -2.734761670618510e-28,  1.885253983051486e+00, -7.104527632066493e-04, -3.037051479966738e-06, -1.014431624601088e-08, -2.514112792593935e-11,
 -2.933075338926852e-14,  1.230152228684731e-16,  1.028663695760580e-18,  4.192503432140952e-21,  1.014177410771137e-23,  5.075208699008756e-28, -1.418316781383584e-28,
  1.920715713406651e+00, -5.044727241053792e-04, -2.276909625460031e-06, -8.416716862892503e-09, -2.566095678824405e-11, -5.888800667847255e-14, -5.525928957215812e-17,
  3.674109311613946e-19,  2.855422222422048e-21,  1.241575152811487e-23,  3.743210650196812e-26,  5.964027374217837e-29,  1.950058338803611e+00, -3.249629840733567e-04,
 -1.532259421821545e-06, -6.119136698353876e-09, -2.139303347523283e-11, -6.470319838866109e-14, -1.579072238237770e-16, -2.263823664361562e-19,  4.796113088769542e-22,
  5.797751364653343e-24,  3.057402635560295e-26,  1.194491267126933e-28,  1.972894161023252e+00, -1.794511259533779e-04, -8.748133189688078e-07, -3.697246041176589e-09,
 -1.417148869693198e-11, -4.988154373156899e-14, -1.604233933260407e-16, -4.597123099329476e-19, -1.092201715456097e-21, -1.602055639495863e-24,  2.840258235330385e-27,
  3.852786915276650e-29,  1.988911425001795e+00, -7.430223845307785e-05, -3.706541427333302e-07, -1.627393855335272e-09, -6.615005491378273e-12, -2.541205985442599e-14,
 -9.308503448942392e-17, -3.259870630042611e-19, -1.089275342540191e-21, -3.448286437135469e-24, -1.018499828658040e-26, -2.715931563908740e-29,  1.997889164476557e+00,
 -1.423999583851327e-05, -7.194950901931911e-08, -3.225543136923494e-10, -1.352588839731094e-12, -5.430235853767985e-15, -2.112758767948625e-17, -8.022718925496259e-20,
 -2.986177057496542e-22, -1.092498603939162e-24, -3.935348542667090e-27, -1.397121470757140e-29,  3.933913054872936e-04, -1.756000355190202e-06,  5.877749885455936e-09,
 -1.748500189870549e-11,  4.874924281640478e-14, -1.304422839109078e-16,  3.392007356571651e-19, -8.637325241202740e-22,  2.163826313446516e-24, -5.351570932096590e-27,
  1.309351053190630e-29, -3.175624300913182e-32,  3.539956881089836e-03, -1.578526427080730e-05,  5.271886803257027e-08, -1.562178959413052e-10,  4.329423394043454e-13,
 -1.148584755332916e-15,  2.952274426682531e-18, -7.404269641817519e-21,  1.819394309542623e-23, -4.392545873044478e-26,  1.043347242476729e-28, -2.441193622540059e-31,
  9.830066260349652e-03, -4.374374872387534e-05,  1.454373103094022e-07, -4.275904040829581e-10,  1.170657322617617e-12, -3.051452246098876e-15,  7.654764659263914e-18,
 -1.858259861999532e-20,  4.374722212675474e-23, -9.989493130424828e-26,  2.206969826416700e-28, -4.697057170769546e-31,  1.925763189198433e-02, -8.543087664245402e-05,
  2.821098891517132e-07, -8.195349908064319e-10,  2.201830355053017e-12, -5.581874703806229e-15,  1.345861693489944e-17, -3.090762707079543e-20,  6.730665624323394e-23,
 -1.374485638690781e-25,  2.566371942168595e-28, -4.129568268266186e-31,  3.181341183312715e-02, -1.405445631344243e-04,  4.598630989989335e-07, -1.314250030782418e-09,
  3.439555921700470e-12, -8.377963653385230e-15,  1.902619045710053e-17, -3.989652492195654e-20,  7.511282569505680e-23, -1.178594623945196e-25,  1.131279684050577e-28,
  1.497138921315788e-31,  4.748487533192599e-02, -2.086797711036817e-04,  6.748874220279195e-07, -1.888565273896011e-09,  4.773895795680576e-12, -1.100090873317917e-14,
  2.283318335503294e-17, -4.089031923127276e-20,  5.476804394939262e-23, -1.380938776139727e-26, -2.506629688195757e-28,  1.200452358379206e-30,  6.625602079143011e-02,
 -2.893266183225206e-04,  9.224577112154039e-07, -2.514438645785881e-09,  6.076919623093268e-12, -1.297058710967660e-14,  2.336848519661890e-17, -2.999667886773803e-20,
 -9.284273128307930e-25,  1.770863338167424e-25, -7.768033300432563e-28,  2.383994861058329e-30,  8.810714367314634e-02, -3.818680675619791e-04,  1.196960806640391e-06,
 -3.159592028974064e-09,  7.208932660691941e-12, -1.380764926088525e-14,  1.935603605579934e-17, -5.043655751048110e-21, -9.063399571387640e-23,  4.232837336480957e-25,
 -1.295629789930550e-27,  3.047119054761766e-30,  1.130145512525271e-01, -4.855772436880490e-04,  1.491931870748130e-06, -3.788294869549513e-09,  8.025819822543847e-12,
 -1.308030265866953e-14,  9.980151238201161e-18,  3.359000916574406e-20, -2.023619193014260e-22,  6.582504794984405e-25, -1.552235340421299e-27,  2.439397235591073e-30,
  1.409502204729050e-01, -5.996144371451411e-04,  1.800101282094449e-06, -4.362305060705298e-09,  8.387398041339257e-12, -1.045351253824371e-14, -4.907552851955444e-18,
  8.241154971870803e-20, -3.133209747888950e-22,  7.896825436099422e-25, -1.275388661380454e-27,  4.654760461577778e-32,  1.718813944598881e-01, -7.230238728839283e-04,
  2.113454305680669e-06, -4.841976323066145e-09,  8.166618418403601e-12, -5.737778471368164e-15, -2.462422851547312e-17,  1.346581166383033e-19, -3.922111162902856e-22,
  7.195196863151972e-25, -2.796502623879537e-28, -4.034346412106553e-30,  2.057701125593243e-01, -8.547303486144834e-04,  2.423306158969928e-06, -5.187539913312629e-09,
  7.259393087100980e-12,  1.065959373942181e-15, -4.756116608366249e-17,  1.806688425711850e-19, -4.041804026626795e-22,  3.728066986369571e-25,  1.422197088416504e-27,
 -8.820793577147136e-30,  2.425726680578064e-01, -9.935358775168374e-04,  2.720395508915118e-06, -5.360565536242931e-09,  5.594736712856036e-12,  9.729349241004391e-15,
 -7.118485198252333e-17,  2.088660917656818e-19, -3.182057998598438e-22, -2.694327712841659e-25,  3.531355361547532e-27, -1.243628910481949e-29,  2.822389870511577e-01,
 -1.138116509648936e-03,  2.994999852889332e-06, -5.325601293451652e-09,  3.144807267042409e-12,  1.977223644526209e-14, -9.215779780744470e-17,  2.073631658631189e-19,
 -1.161032395795838e-22, -1.140979319134993e-24,  5.441294920580489e-27, -1.249992989012628e-29,  3.247119212683068e-01, -1.287019554879661e-03,  3.237076631737661e-06,
 -5.051984738519442e-09, -6.569545191701456e-14,  3.045595192340470e-14, -1.065975913155140e-16,  1.661256677181718e-19,  1.982520788486291e-22, -2.074650545117584e-24,
  6.319922534393991e-27, -6.947845369574441e-30,  3.699264470725472e-01, -1.438661490042132e-03,  3.436434259387825e-06, -4.515805868138758e-09, -3.951460514504545e-12,
  4.079958977619202e-14, -1.104826276725227e-16,  7.949808000950725e-20,  5.915180242267727e-22, -2.810311625412419e-24,  5.315585541032212e-27,  4.845907065331140e-30,
  4.178087624027913e-01, -1.591326906074370e-03,  3.582937475603492e-06, -3.701987300454363e-09, -8.360672273127523e-12,  4.962437431053575e-14, -1.001976125562460e-16,
 -5.122825859057561e-20,  9.977596185137380e-22, -3.034949442728383e-24,  1.872710448756909e-27,  2.098641826438577e-29,  4.682752731589693e-01, -1.743168939131894e-03,
  3.666751457558693e-06, -2.606426056789009e-09, -1.307230200275345e-11,  5.563036862569750e-14, -7.319043460697335e-17, -2.156709809762145e-19,  1.322173449155865e-21,
 -2.457576806088515e-24, -3.905396026255951e-27,  3.653186747222618e-29,  5.212314605811073e-01, -1.892211734786045e-03,  3.678628851888896e-06, -1.238114387715223e-09,
 -1.779774226652957e-11,  5.750801676557390e-14, -2.868427365032018e-17, -3.932243408112002e-19,  1.453754108091554e-21, -9.122913547486661e-25, -1.096248584095788e-26,
  4.410307055141131e-29,  5.765706216597213e-01, -2.036355617737408e-03,  3.610243162667710e-06,  3.788767077442240e-10, -2.218804516686714e-11,  5.408403567704200e-14,
  3.164405538017240e-17, -5.535930217630915e-19,  1.287707511293388e-21,  1.530012269465461e-24, -1.722084304202901e-26,  3.602971692717094e-29,  6.341724757303540e-01,
 -2.173385781264498e-03,  3.454570556321127e-06,  2.203708421111767e-09, -2.584804171161164e-11,  4.449668596153564e-14,  1.031434512716185e-16, -6.596044401806088e-19,
  7.561551510675614e-22,  4.474818329311404e-24, -1.989719251088099e-26,  7.929286119677021e-30,  6.939016323880115e-01, -2.300985469455227e-03,  3.206319872354731e-06,
  4.177583765419999e-09, -2.835848797064459e-11,  2.838924271060677e-14,  1.779805409800827e-16, -6.726995895939935e-19, -1.375349359233426e-22,  7.186468273206584e-24,
 -1.629517675788622e-26, -3.720732117212719e-29,  7.556059190165260e-01, -2.416754796894267e-03,  2.862407154024085e-06,  6.223311229219836e-09, -2.930702654177542e-11,
  6.102567818154847e-15,  2.454168143738938e-16, -5.610593061090965e-19, -1.289227159960350e-21,  8.685340870257141e-24, -5.008787343184846e-27, -8.628458792235195e-29,
  8.191145709511602e-01, -2.518236526369611e-03,  2.422465982600028e-06,  8.245928233936193e-09, -2.832807567170164e-11, -2.116152614766077e-14,  2.927334091014331e-16,
 -3.096126293332880e-19, -2.481157835541881e-21,  7.988109447174466e-24,  1.277149075113684e-26, -1.171707589342403e-28,  8.842362940554048e-01, -2.602950290482527e-03,
  1.889377935280505e-06,  1.013473183804905e-08, -2.515066383807829e-11, -5.124383842746812e-14,  3.069114188126456e-16,  6.977729075065563e-20, -3.399057324851185e-21,
  4.477669216511766e-24,  3.242573714247121e-26, -1.055593106086991e-28,  9.507572188597723e-01, -2.668436874102022e-03,  1.269798239985108e-06,  1.176708417241304e-08,
 -1.965163048545533e-11, -8.104352232234753e-14,  2.770582443447031e-16,  5.307072555816789e-19, -3.689950506131519e-21, -1.677419615925643e-24,  4.628068536879527e-26,
 -3.748581978575947e-29,  1.018438778025359e+00, -2.712314235776766e-03,  5.746399411895882e-07,  1.301433984281364e-08, -1.190948306402431e-11, -1.066936213236469e-13,
  1.973781385835166e-16,  9.908142650851270e-19, -3.062390747183954e-21, -9.212375893329455e-24,  4.578765160415392e-26,  7.649935342115114e-29,  1.087015555448618e+00,
 -2.732346886632982e-03, -1.805343349798121e-07,  1.375015694852402e-08, -2.251619451496476e-12, -1.239366154720200e-13,  7.022187255341820e-17,  1.340292284206567e-18,
 -1.414515267178856e-21, -1.577911917578073e-23,  2.546430108489864e-26,  1.938169876137148e-28,  1.156193176486902e+00, -2.726529995835065e-03, -9.752800709698471e-07,
  1.386127189323210e-08,  8.715126225359672e-12, -1.287176206831673e-13, -9.154773920517865e-17,  1.462890431339835e-18,  1.046629633453312e-21, -1.847809541311647e-23,
 -1.257374089344107e-26,  2.490370684255442e-28,  1.225646335090184e+00, -2.693189063499656e-03, -1.784281747122512e-06,  1.326050842250291e-08,  2.010300082723751e-11,
 -1.179702239470799e-13, -2.638867883706812e-16,  1.268790391293873e-18,  3.751609754581612e-21, -1.495331951669050e-23, -5.594432025678461e-26,  1.848480147886430e-28,
  1.295017085280795e+00, -2.631095088294213e-03, -2.577705330722006e-06,  1.190132727854289e-08,  3.078427985934307e-11, -9.050543432203873e-14, -4.136687200679428e-16,
  7.335386775299495e-19,  5.844209247236224e-21, -4.792420433575525e-24, -8.419592787313661e-26, -3.847359444841933e-30,  1.363913561035054e+00, -2.539593741403700e-03,
 -3.321999203192429e-06,  9.792599422263609e-09,  3.948628255654819e-11, -4.783338627538971e-14, -5.043056652603418e-16, -6.916972697218056e-20,  6.424353540023726e-21,
  9.402943238096021e-24, -7.752857317247187e-26, -2.395536429072141e-28,  1.431909328811457e+00, -2.418745033441764e-03, -3.981246515892517e-06,  7.011540744200074e-09,
  4.494607346875243e-11,  5.332050663764798e-15, -5.047909448616099e-16, -9.580662917816589e-19,  4.928902624705446e-21,  2.214119694672281e-23, -2.982513738985709e-26,
 -3.808149663860442e-28,  1.498543617910354e+00, -2.269467260326765e-03, -4.519147991799797e-06,  3.711987950383331e-09,  4.611881936056209e-11,  6.118019350965334e-14,
 -4.006326991876585e-16, -1.674946090905282e-18,  1.519549048459605e-21,  2.698587119910374e-23,  4.138817781414544e-26, -3.051213416622086e-28,  1.563322710742974e+00,
 -2.093675665183431e-03, -4.901661345389313e-06,  1.246290041774091e-10,  4.241623404413634e-11,  1.097786828241004e-13, -2.034249391634651e-16, -1.961642604009884e-18,
 -2.742685323961158e-21,  2.001871967167383e-23,  9.797452609273853e-26, -1.801063493843497e-29,  1.625722800726135e+00, -1.894402444928665e-03, -5.100234202376068e-06,
 -3.454261934452849e-09,  3.393017854391993e-11,  1.410053059426643e-13,  4.549674518357724e-17, -1.667830010226995e-18, -6.154621396393749e-21,  3.129102693175527e-24,
  1.019715244265910e-25,  3.039249020786420e-28,  1.685194630119716e+00, -1.675880891509109e-03, -5.095438921994565e-06, -6.688212215930274e-09,  2.157687787635089e-11,
  1.472065713223971e-13,  2.816324873760544e-16, -8.469812637372830e-19, -7.107921296243510e-21, -1.547357855968811e-23,  4.490282898177166e-26,  4.162728496458253e-28,
  1.741170191744374e+00, -1.443573323437318e-03, -4.880657300824902e-06, -9.240627711910614e-09,  7.088869186491311e-12,  1.259344857518586e-13,  4.356254646901649e-16,
  2.188283153781134e-19, -5.027723043579394e-21, -2.524427221407672e-23, -3.768089522525556e-26,  2.169509156405463e-28,  1.793071704427571e+00, -1.204121085885094e-03,
 -4.465293608525438e-06, -1.082670178976946e-08, -7.203604024483204e-12,  8.174777430684130e-14,  4.593004459253200e-16,  1.109643218125965e-18, -9.296769772738077e-22,
 -2.034988262434808e-23, -8.694421087667812e-26, -1.255994172755901e-28,  1.840322941371915e+00, -9.651965520362648e-04, -3.876857779085738e-06, -1.126986570006611e-08,
 -1.881356480526733e-11,  2.599708751119689e-14,  3.491353656182769e-16,  1.461089954559297e-18,  2.963916685772325e-21, -4.739821032843135e-24, -6.876733634127203e-26,
 -3.047528601822588e-28,  1.882362798495347e+00, -7.352429841038062e-04, -3.161215634457087e-06, -1.055109673157240e-08, -2.569580655040083e-11, -2.601725976596572e-14,
  1.537508887900849e-16,  1.168656440986596e-18,  4.556355847020763e-21,  1.002475916574162e-23, -6.681242560632829e-27, -1.861852059290225e-28,  1.918660742313354e+00,
 -5.230990732585130e-04, -2.380412769150035e-06, -8.836782621780620e-09, -2.685109071060215e-11, -6.008003089503632e-14, -4.362327102207662e-17,  4.662298759956700e-19,
  3.329949900839784e-21,  1.396293029903155e-23,  3.985347373480711e-26,  4.954503879565635e-29,  1.948733497315891e+00, -3.375206966117710e-04, -1.607786170334450e-06,
 -6.471985778123442e-09, -2.272549879899764e-11, -6.856710040573639e-14, -1.639979429304945e-16, -2.074486781249661e-19,  7.116575820032631e-22,  7.131045381324409e-24,
  3.622288247326338e-26,  1.375993746266843e-28,  1.972162072972083e+00, -1.866310321611026e-04, -9.205743459556654e-07, -3.932184547619019e-09, -1.520868444755618e-11,
 -5.389017033015328e-14, -1.737931382237219e-16, -4.955601137948779e-19, -1.147392698504880e-21, -1.451266375167744e-24,  4.784897845063786e-27,  5.030213233051949e-29,
  1.988608159307666e+00, -7.734742521214208e-05, -3.908350833286426e-07, -1.737424431416778e-09, -7.146347288954243e-12, -2.775968872874313e-14, -1.027199041055994e-16,
 -3.629111038857422e-19, -1.221042670094356e-21, -3.880447829119749e-24, -1.144469129486063e-26, -3.012703980984066e-29,  1.997831028256425e+00, -1.483145085871330e-05,
 -7.595368464550857e-08, -3.450929069050086e-10, -1.466451871949185e-12, -5.965371552906257e-15, -2.351386608813671e-17, -9.044386103445036e-20, -3.409357886567909e-22,
 -1.262930895496906e-24, -4.604991562218505e-27, -1.654363870751775e-29,  3.864600376664295e-04, -1.709804571842469e-06,  5.672525108724928e-09, -1.672545054551803e-11,
  4.621988606450644e-14, -1.225840304545328e-16,  3.159573616170430e-19, -7.974741748758575e-22,  1.980269928019464e-24, -4.854729623287704e-27,  1.177367141588870e-29,
 -2.830685308254228e-32,  3.477647617314216e-03, -1.537089574641798e-05,  5.088506996053526e-08, -1.494708116292920e-10,  4.106627311878362e-13, -1.080153647244774e-15,
  2.752873661827411e-18, -6.846579606777174e-21,  1.668522958051668e-23, -3.995917992658945e-26,  9.416467759406846e-29, -2.186495834440403e-31,  9.657386209046326e-03,
 -4.260046073622747e-05,  1.404166264620104e-07, -4.093383115696210e-10,  1.111424079546174e-12, -2.873826720434772e-15,  7.153521938977404e-18, -1.723856284374420e-20,
  4.030504588625701e-23, -9.146725203783549e-26,  2.010043154844003e-28, -4.261290354935379e-31,  1.892036069344029e-02, -8.321274468281383e-05,  2.724832169944597e-07,
 -7.851815449614820e-10,  2.093354069223332e-12, -5.269013981323320e-15,  1.262262680868104e-17, -2.883103835206356e-20,  6.253896758687494e-23, -1.275399004091060e-25,
  2.389591826009029e-28, -3.905555428370177e-31,  3.125849281137191e-02, -1.369278193598805e-04,  4.444168458825109e-07, -1.260533175045672e-09,  3.276473836210548e-12,
 -7.934472595764778e-15,  1.794210674566902e-17, -3.755991639298912e-20,  7.095276210017355e-23, -1.132202889472914e-25,  1.184142276401038e-28,  9.249975855648783e-32,
  4.666081272667439e-02, -2.033700408908057e-04,  6.526757675300792e-07, -1.813913697810727e-09,  4.559265867090212e-12, -1.046645396471555e-14,  2.171270254978200e-17,
 -3.914753107350759e-20,  5.410266764383342e-23, -2.283303347457480e-26, -2.017989214389167e-28,  1.024712290808182e-30,  6.511328485197414e-02, -2.820660162843899e-04,
  8.928593690905208e-07, -2.419253038804650e-09,  5.823048291760862e-12, -1.241982002506497e-14,  2.252907905313074e-17, -2.993018345268929e-20,  4.911920091918301e-24,
  1.480310125340729e-25, -6.779193471362548e-28,  2.115319048738038e-30,  8.659858538757632e-02, -3.724421015204672e-04,  1.159728728394510e-06, -3.046433143748747e-09,
  6.937412049815629e-12, -1.334511306748831e-14,  1.917643066222202e-17, -7.709876566751027e-21, -7.629698697081103e-23,  3.740672211913716e-25, -1.166980825797940e-27,
  2.802078791310816e-30,  1.110958283331071e-01, -4.738214636487837e-04,  1.447234221015560e-06, -3.661961279808705e-09,  7.766681497441294e-12, -1.283020305376585e-14,
  1.083349158599955e-17,  2.748180638482430e-20, -1.797566969169003e-22,  5.983014222455476e-25, -1.445438003444972e-27,  2.409275010896219e-30,  1.385802360094177e-01,
 -5.854207520861345e-04,  1.748551893625523e-06, -4.229784888991413e-09,  8.177331142129420e-12, -1.054471057841367e-14, -2.736193633127582e-18,  7.283030089874205e-20,
 -2.858090986417620e-22,  7.388264265801111e-25, -1.264653344708865e-27,  4.262594549274877e-31,  1.690227493712705e-01, -7.063464409055581e-04,  2.056130697667480e-06,
 -4.712259326185815e-09,  8.046251210356312e-12, -6.284909215326115e-15, -2.102563511257158e-17,  1.225193142822286e-19, -3.665500921351126e-22,  7.050499658061202e-25,
 -4.374785408589408e-28, -3.161296090753018e-30,  2.023895725996223e-01, -8.355909254778903e-04,  2.361753089017974e-06, -5.071279396344211e-09,  7.269699852325461e-12,
 -1.625262210579975e-17, -4.268141969259348e-17,  1.679600486575526e-19, -3.898255619518094e-22,  4.222989900702026e-25,  1.061290982775360e-27, -7.602482108966684e-30,
  2.386416456400297e-01, -9.720284846275501e-04,  2.656611943273281e-06, -5.269583910407079e-09,  5.772707060299803e-12,  8.089933154218186e-15, -6.548042751791480e-17,
  1.985545243899014e-19, -3.254916736466500e-22, -1.387925097069893e-25,  3.008820964556142e-27, -1.131589246694570e-29,  2.777340375107679e-01, -1.114411255017524e-03,
  2.931407204641781e-06, -5.272239027043469e-09,  3.518602098724654e-12,  1.762966701405583e-14, -8.640952511268773e-17,  2.030315940775605e-19, -1.533925400667324e-22,
 -9.342399250327789e-25,  4.898185481984759e-27, -1.215603530972331e-29,  3.196152523587345e-01, -1.261365409564519e-03,  3.176466163122502e-06, -5.048300323154397e-09,
  5.182203560390984e-13,  2.795407755365787e-14, -1.018681394208883e-16,  1.713229052926703e-19,  1.280380040131930e-22, -1.828327125435079e-24,  5.988077624777569e-27,
 -8.070645319068808e-30,  3.642264394225101e-01, -1.411387788362683e-03,  3.381891711969357e-06, -4.572644577232321e-09, -3.161793585006613e-12,  3.817676499036438e-14,
 -1.080065960469334e-16,  9.684931624515647e-20,  4.942171769239800e-22, -2.594321165297415e-24,  5.462644502727579e-27,  1.921907239805407e-30,  4.115004973149458e-01,
 -1.562843301184809e-03,  3.537743331133047e-06, -3.827949238691732e-09, -7.392330179868043e-12,  4.720592641868352e-14, -1.012013194826387e-16, -2.103189612751630e-20,
  8.900605025022010e-22, -2.942866723438933e-24,  2.700080665253424e-27,  1.668345134438497e-29,  4.613610624283086e-01, -1.713963507660052e-03,  3.634255805366582e-06,
 -2.806779438409005e-09, -1.197772511813323e-11,  5.380603097443017e-14, -7.865038588456059e-17, -1.748040751464037e-19,  1.231264807524470e-21, -2.582895172602537e-24,
 -2.391611590381096e-27,  3.226549252210667e-29,  5.137213708874846e-01, -1.862846887296471e-03,  3.662100720105631e-06, -1.513718034927942e-09, -1.665533096143607e-11,
  5.669269431554373e-14, -3.904879221320384e-17, -3.473105544707821e-19,  1.413481578126552e-21, -1.312509604562641e-24, -9.062917287589929e-27,  4.211668973147136e-29,
  5.684829834624854e-01, -2.007461439052380e-03,  3.612695445755592e-06,  3.255750880416041e-11, -2.110000116542008e-11,  5.466218832025361e-14,  1.672769455712324e-17,
 -5.116348839630069e-19,  1.330779163741685e-21,  8.737605059356676e-25, -1.557262381616769e-26,  3.865765767570123e-29,  6.255343633806234e-01, -2.145650400999237e-03,
  3.478563431825667e-06,  1.797387494150952e-09, -2.493483480420885e-11,  4.675337933557054e-14,  8.503641175752137e-17, -6.329827467072301e-19,  9.030304945691964e-22,
  3.688497788222610e-24, -1.935759333789664e-26,  1.633741931977015e-29,  6.847492982936078e-01, -2.275142055336697e-03,  3.253747933871374e-06,  3.728615913317934e-09,
 -2.774951504172913e-11,  3.243448578375313e-14,  1.591213156869944e-16, -6.730900723478886e-19,  1.090858381265401e-22,  6.505750028825155e-24, -1.764742991976086e-26,
 -2.440127761909569e-29,  7.459851600759845e-01, -2.393564780906062e-03,  2.934278463773963e-06,  5.755689817456673e-09, -2.912737050517367e-11,  1.179968093768429e-14,
  2.291762674659459e-16, -5.973576965995417e-19, -9.810432222840985e-22,  8.412691016844425e-24, -8.532269034420754e-27, -7.373899931919334e-29,  8.090810000746659e-01,
 -2.498468728890924e-03,  2.518684887606721e-06,  7.789671797879946e-09, -2.868179760618454e-11, -1.424865704625921e-14,  2.829965733153479e-16, -3.843199426748504e-19,
 -2.185621296786888e-21,  8.397175479055184e-24,  7.719701028310325e-27, -1.119766682769711e-28,  8.738554834227896e-01, -2.587355716140695e-03,  2.008547730356173e-06,
  9.724522860125819e-09, -2.610178646889071e-11, -4.386665253088731e-14,  3.073683696301595e-16, -3.617234213609456e-20, -3.215660749838519e-21,  5.678933953689651e-24,
  2.757396000331091e-26, -1.142845665494804e-28,  9.401046747279499e-01, -2.657719134200168e-03,  1.409064388322326e-06,  1.144005721671461e-08, -2.120487245753685e-11,
 -7.422919279320140e-14,  2.902583978922310e-16,  4.120162619276725e-19, -3.717480371646441e-21,  1.334680733101071e-25,  4.408755269432143e-26, -6.166001926413167e-29,
  1.007599699626246e+00, -2.707095827770297e-03,  7.295991501495431e-07,  1.280698374499592e-08, -1.399379605430377e-11, -1.016349996596211e-13,  2.237016850855079e-16,
  8.878709327382940e-19, -3.360343889229890e-21, -7.322994682029271e-24,  4.844680821326919e-26,  4.430915027721322e-29,  1.076084323252489e+00, -2.733131953945568e-03,
 -1.583007398625538e-08,  1.369440540905652e-08, -4.710487363495389e-12, -1.218065846527909e-13,  1.070324533501660e-16,  1.286151900009688e-18, -1.962233539165396e-21,
 -1.459660473692011e-23,  3.348760624278735e-26,  1.699704372688791e-28,  1.145272508566856e+00, -2.733664721194600e-03, -8.081934582613521e-07,  1.398001370218154e-08,
  6.122137129982530e-12, -1.304200682195011e-13, -5.021848789643065e-17,  1.485663664531471e-18,  3.750209861268075e-22, -1.876035953682831e-23, -1.517373473661480e-27,
  2.520693956257590e-28,  1.214846045607270e+00, -2.706821526545583e-03, -1.623304699401555e-06,  1.356294940796588e-08,  1.768320908009892e-11, -1.238641399168677e-13,
 -2.267638471505874e-16,  1.379813518184749e-18,  3.175077670576500e-21, -1.701674390106123e-23, -4.694961752615193e-26,  2.228909539409941e-28,  1.284452377778620e+00,
 -2.651137234943153e-03, -2.431995573445178e-06,  1.237886282400931e-08,  2.887666280130549e-11, -1.001660645903392e-13, -3.905419989178113e-16,  9.171436495212062e-19,
  5.611177701042746e-21, -8.146323807175565e-24, -8.306755153509451e-26,  5.538324701009730e-29,  1.353702793381235e+00, -2.565689026968898e-03, -3.200731028006737e-06,
  1.041606875001537e-08,  3.840854590050040e-11, -5.993644192362675e-14, -5.033178015120375e-16,  1.412072754574525e-19,  6.704610916501869e-21,  6.103479614469695e-24,
 -8.711518740506485e-26, -1.943434650996952e-28,  1.422171198875069e+00, -2.450246222497018e-03, -3.892791841121535e-06,  7.730864009622683e-09,  4.492948696500132e-11,
 -7.086291917239523e-15, -5.292906568026752e-16, -7.878512812409722e-19,  5.700447481237023e-21,  2.061042004653439e-23, -4.675399803601686e-26, -3.863195418649312e-28,
  1.489393742440122e+00, -2.305429634999667e-03, -4.470138086386807e-06,  4.459139631045968e-09,  4.724250485121323e-11,  5.100862994211701e-14, -4.467022639308229e-16,
 -1.610484543755807e-18,  2.517431215590845e-21,  2.835394151062611e-23,  2.655564311379348e-26, -3.681789948972270e-28,  1.554869607478064e+00, -2.132871271491912e-03,
 -4.896022295643854e-06,  8.205692275420467e-10,  4.455848837853981e-11,  1.042281477001287e-13, -2.594659369274409e-16, -2.037124301151979e-18, -1.951868887011926e-21,
  2.389884676313755e-23,  9.544441251949095e-26, -9.862797532309984e-29,  1.618063337987426e+00, -1.935360679478899e-03, -5.138334837113094e-06, -2.888775177565939e-09,
  3.675730677184289e-11,  1.415147147025957e-13, -3.937069234531797e-18, -1.862162662039700e-18, -5.965410028451401e-21,  7.466532800440772e-24,  1.146484782934751e-25,
  2.693645233619583e-28,  1.678409079810277e+00, -1.716959342062601e-03, -5.173527765515859e-06, -6.319070401871036e-09,  2.458654517727869e-11,  1.536549616536991e-13,
  2.546516031258960e-16, -1.082964254109727e-18, -7.628105442609399e-21, -1.329802827756877e-23,  6.418411649338572e-26,  4.586934758051887e-28,  1.735317108625264e+00,
 -1.483060008681657e-03, -4.990779340202255e-06, -9.106486486290825e-09,  9.712507757890214e-12,  1.364439933335514e-13,  4.393616564679357e-16,  4.312961565707239e-20,
 -5.961138394055146e-21, -2.653760496862365e-23, -2.640106048350361e-26,  2.972019722107192e-28,  1.788182949959562e+00, -1.240364947619522e-03, -4.595849653673850e-06,
 -1.092827038807494e-08, -5.455920095041106e-12,  9.313976224683323e-14,  4.898389823490322e-16,  1.067490657051380e-18, -1.726103789437265e-21, -2.392691297991096e-23,
 -9.160138336231129e-26, -8.355801541471502e-29,  1.836399261761012e+00, -9.967574425689006e-04, -4.013883598417042e-06, -1.156625383024561e-08, -1.820646216590245e-11,
  3.487780272871918e-14,  3.913441276899512e-16,  1.552647521376290e-18,  2.740460558193323e-21, -7.767259233836414e-24, -8.280878502856815e-26, -3.327474499349230e-28,
  1.879370435307810e+00, -7.610461892691634e-04, -3.290312083490556e-06, -1.096618048050559e-08, -2.617651446341025e-11, -2.191776288137367e-14,  1.885683057304984e-16,
  1.320165612716254e-18,  4.910328807876966e-21,  9.578884108475344e-24, -1.599274006394265e-26, -2.383958879513567e-28,  1.916529577388877e+00, -5.425739361425186e-04,
 -2.489071689742438e-06, -9.276065101640222e-09, -2.806203926274638e-11, -6.095781949848817e-14, -2.899923252595122e-17,  5.811426072711883e-19,  3.861797257988923e-21,
  1.559640050166586e-23,  4.170228889036906e-26,  3.335032802805556e-29,  1.947357189214038e+00, -3.506999282484590e-04, -1.687677599848085e-06, -6.846780273765377e-09,
 -2.413665646359682e-11, -7.256993293372679e-14, -1.694470261402116e-16, -1.802763307780287e-19,  9.959665845621608e-22,  8.706758060401768e-24,  4.270682057196168e-26,
  1.573756455196339e-28,  1.971400514857863e+00, -1.941885919583652e-04, -9.692569089202146e-07, -4.184377345266443e-09, -1.632934377983279e-11, -5.823190966040504e-14,
 -1.881904179791739e-16, -5.330711000788028e-19, -1.195622853102431e-21, -1.211507059154136e-24,  7.310182334075561e-27,  6.501929238070192e-29,  1.988292381400282e+00,
 -8.055948914039282e-05, -4.123889907637593e-07, -1.856345021026058e-09, -7.727040301205917e-12, -3.035145215171937e-14, -1.134500883133139e-16, -4.043106072473339e-19,
 -1.369306676947220e-21, -4.365653967764006e-24, -1.283826115413754e-26, -3.323509494244370e-29,  1.997770460391646e+00, -1.545605294125894e-05, -8.023961778308992e-08,
 -3.695421421422879e-10, -1.591614311968825e-12, -6.561369617481405e-15, -2.620613036817830e-17, -1.021182799666629e-19, -3.899001502626747e-22, -1.462556239883863e-24,
 -5.398728043127369e-27, -1.962807771968673e-29,  3.797103261526622e-04, -1.665214804477956e-06,  5.476177219946478e-09, -1.600514127012149e-11,  4.384226288442903e-14,
 -1.152620027398068e-16,  2.944896060395094e-19, -7.368133490143616e-22,  1.813685008748834e-24, -4.407768013866992e-27,  1.059661258559768e-29, -2.525753224894526e-32,
  3.416966991225079e-03, -1.497087970425946e-05,  4.913014239439213e-08, -1.430695068773254e-10,  3.897051261454992e-13, -1.016326099988848e-15,  2.568433232481727e-18,
 -6.334960200022210e-21,  1.531224192005633e-23, -3.637814451938595e-26,  8.505203500746825e-29, -1.959978438541110e-31,  9.489200343516187e-03, -4.149647796455332e-05,
  1.356093964834713e-07, -3.920061719070040e-10,  1.055626033851012e-12, -2.707791595951546e-15,  6.688414673538761e-18, -1.599997071589456e-20,  3.715253809750008e-23,
 -8.379017478152983e-26,  1.831368572238239e-28, -3.866753370321811e-31,  1.859181056580546e-02, -8.107000617201816e-05,  2.632585754740391e-07, -7.525147326422029e-10,
  1.990938982198712e-12, -4.975536203252045e-15,  1.184269790593698e-17, -2.690144282408646e-20,  5.811550052337377e-23, -1.183186130049255e-25,  2.222684979685179e-28,
 -3.681380804660264e-31,  3.071779764539980e-02, -1.334321108944887e-04,  4.295998273397834e-07, -1.209356065776840e-09,  3.122006614126947e-12, -7.516229333884600e-15,
  1.692160973518773e-17, -3.535372164918430e-20,  6.696293844118152e-23, -1.084167146071921e-25,  1.214262521038240e-28,  4.603255905493969e-32,  4.585763924796341e-02,
 -1.982344782146401e-04,  6.313396755245750e-07, -1.742612132382563e-09,  4.355060057459041e-12, -9.958307851799962e-15,  2.064067549236447e-17, -3.743087004647539e-20,
  5.314582312027112e-23, -3.004973234733737e-26, -1.601469771947038e-28,  8.721332862662691e-31,  6.399912488491101e-02, -2.750377002970663e-04,  8.643792425648467e-07,
 -2.328042343975938e-09,  5.579991100598511e-12, -1.188915616650841e-14,  2.169399932052905e-17, -2.969279204112126e-20,  9.774696752075792e-24,  1.227026465592920e-25,
 -5.902606124137352e-28,  1.873410051319836e-30,  8.512714374965666e-02, -3.633086336306267e-04,  1.123828795240769e-06, -2.937544841182275e-09,  6.675093271634445e-12,
 -1.288773301325671e-14,  1.892833466547521e-17, -9.944689564007384e-21, -6.364171793887121e-23,  3.297839058081345e-25, -1.048895031864555e-27,  2.567310294364808e-30,
  1.092234228738020e-01, -4.624172708935977e-04,  1.404027865595517e-06, -3.539732831281673e-09,  7.512736526807720e-12, -1.256159586090891e-14,  1.152561081147233e-17,
  2.206326135943325e-20, -1.592331544509238e-22,  5.425881537867718e-25, -1.340667675212554e-27,  2.348677505135398e-30,  1.362662114866580e-01, -5.716331584255045e-04,
  1.698572529530988e-06, -4.100637637344197e-09,  7.965940185032988e-12, -1.058691750192605e-14, -8.210585216694991e-19,  6.410025297300647e-20, -2.601165252519387e-22,
  6.887078841217741e-25, -1.239127452151891e-27,  7.211593475063834e-31,  1.662299066440503e-01, -6.901214049170422e-04,  2.000351792147301e-06, -4.584551166886050e-09,
  7.915777996400770e-12, -6.749660088006979e-15, -1.775551860980477e-17,  1.111921845730030e-19, -3.415147008585174e-22,  6.849977555190652e-25, -5.596831659301704e-28,
 -2.412973962876661e-30,  1.990846143209871e-01, -8.169383451968761e-04,  2.301595440742945e-06, -4.955020881895999e-09,  7.259504968113115e-12, -9.855674031606606e-16,
 -3.815083997685195e-17,  1.557364338918945e-19, -3.739362322207271e-22,  4.583941968739805e-25,  7.515275733201948e-28, -6.496062806633679e-30,  2.347956392364790e-01,
 -9.510269471814965e-04,  2.593936184106453e-06, -5.176009725602366e-09,  5.919234643009224e-12,  6.583936426003953e-15, -6.006731218864075e-17,  1.880811201625957e-19,
 -3.284388656055141e-22, -2.807059475318665e-26,  2.535323572677973e-27, -1.021111102772501e-29,  2.733228957013685e-01, -1.091212081719330e-03,  2.868489397961525e-06,
 -5.213231402265620e-09,  3.850914635001362e-12,  1.562347260916128e-14, -8.079815286674239e-17,  1.976216864990289e-19, -1.836261410328882e-22, -7.488709784569654e-25,
  4.373954368382995e-27, -1.164976107679004e-29,  3.146202307622012e-01, -1.236195816083814e-03,  3.115954332273829e-06, -5.035667342542071e-09,  1.053244254658291e-12,
  2.556721050695644e-14, -9.702330646825111e-17,  1.744125230886122e-19,  6.644176761272999e-23, -1.596153292756400e-24,  5.615116426740148e-27, -8.826362279297569e-30,
  3.586346498766936e-01, -1.384552944496135e-03,  3.326741187897701e-06, -4.617264879728282e-09, -2.423951338772972e-12,  3.561885035829011e-14, -1.050871449660728e-16,
  1.112122283170817e-19,  4.047681986663344e-22, -2.374875191469129e-24,  5.491920790770185e-27, -5.134819991252063e-31,  4.053054343342275e-01, -1.534727035918144e-03,
  3.491129004598129e-06, -3.938805683429183e-09, -6.472531447638434e-12,  4.477314938073690e-14, -1.014072356857181e-16,  5.777157988415291e-21,  7.862274723593508e-22,
 -2.821362177981240e-24,  3.346674600901908e-27,  1.277460702827917e-29,  4.545631386828487e-01, -1.685027363460494e-03,  3.599459765898955e-06, -2.989918220586313e-09,
 -1.092085440380038e-11,  5.186405328733034e-14, -8.300738790541203e-17, -1.369071107704038e-19,  1.136889281394774e-21, -2.651426566110925e-24, -1.066068095785143e-27,
  2.799585416419266e-29,  5.063284556247785e-01, -1.833627184425294e-03,  3.642374435336200e-06, -1.771186633869481e-09, -1.553161026454197e-11,  5.564389203371339e-14,
 -4.814782933369316e-17, -3.029015337587572e-19,  1.360145905652737e-21, -1.638700283039200e-24, -7.265885303147625e-27,  3.947403294624708e-29,  5.605109353150707e-01,
 -1.978563968721815e-03,  3.611096670351927e-06, -2.962795306558639e-10, -2.000387816268709e-11,  5.489658061562192e-14,  3.001997966765294e-18, -4.686635281117415e-19,
  1.351436664470196e-21,  2.853491191553283e-25, -1.383844181328140e-26,  3.996534741290199e-29,  6.170075459125738e-01, -2.117742329464087e-03,  3.497769537718038e-06,
  1.406015599729174e-09, -2.398077670639675e-11,  4.858495376168736e-14,  6.773635800178179e-17, -6.021091013674263e-19,  1.022071735142795e-21,  2.930695336860178e-24,
 -1.848278307028785e-26,  2.316819180907501e-29,  6.757010628248566e-01, -2.248940595553259e-03,  3.295849432790854e-06,  3.290014286573766e-09, -2.706415983954663e-11,
  3.602784503873068e-14,  1.403578908133598e-16, -6.659901373864768e-19,  3.303604575443890e-22,  5.781935750617502e-24, -1.845727057067523e-26, -1.259515914256978e-29,
  7.364582756813540e-01, -2.369822182880794e-03,  3.000559254160584e-06,  5.291832937068148e-09, -2.883774654478857e-11,  1.709592905037955e-14,  2.120557688322703e-16,
 -6.239773561937833e-19, -6.850766552380191e-22,  8.010343004159422e-24, -1.148965657005615e-26, -6.063806980066530e-29,  7.991280050929933e-01, -2.477953166271862e-03,
  2.609399277543591e-06,  7.328848481267802e-09, -2.889976285972548e-11, -7.593492776053939e-15,  2.713022717737018e-16, -4.493729679530961e-19, -1.878933093042106e-21,
  8.609556690337482e-24,  2.956478049327341e-27, -1.041431981968305e-28,  8.635389262779324e-01, -2.570827720962317e-03,  2.122708578070906e-06,  9.300275869505905e-09,
 -2.690549241539474e-11, -3.651339712681530e-14,  3.049471226074754e-16, -1.355994892929060e-19, -2.992593277317806e-21,  6.679674116761894e-24,  2.242955205066991e-26,
 -1.188873874139993e-28,  9.294972043774047e-01, -2.645903374423307e-03,  1.544261652086750e-06,  1.108928476422360e-08, -2.261892925458543e-11, -6.713797971914871e-14,
  3.001325382943743e-16,  2.934684321781386e-19, -3.681644530496835e-21,  1.836370397013061e-24,  4.090754428057758e-26, -8.225026389210855e-29,  9.967839576574749e-01,
 -2.700648258210801e-03,  8.818734390469234e-07,  1.256712134611198e-08, -1.597085773461905e-11, -9.598021572411591e-14,  2.470196909033198e-16,  7.764991389373503e-19,
 -3.588706374229952e-21, -5.355591335963753e-24,  4.969059302069580e-26,  1.236942339117953e-29,  1.065152580878623e+00, -2.732602728509367e-03,  1.479706770294392e-07,
  1.359970023840175e-08, -7.118052971053683e-12, -1.188132301156998e-13,  1.420885546264380e-16,  1.215225453651796e-18, -2.461871482953757e-21, -1.311567478339864e-23,
  4.034936714030037e-26,  1.412238797420819e-28,  1.134325983156876e+00, -2.739457761575352e-03, -6.399318193522402e-07,  1.405704936036160e-08,  3.505057174146336e-12,
 -1.311253967889360e-13, -8.553385055341517e-18,  1.486868297656829e-18, -2.987800566631543e-22, -1.860029402054974e-23,  9.478775681371505e-27,  2.463260458798370e-28,
  1.203993823949841e+00, -2.719152322864951e-03, -1.458934390244229e-06,  1.382578012581411e-08,  1.515468926370895e-11, -1.288319523430889e-13, -1.868011985774607e-16,
  1.471271675363655e-18,  2.531122930083184e-21, -1.868900904119453e-23, -3.644137528461728e-26,  2.533856774759293e-28,  1.273809868587039e+00, -2.669991315179152e-03,
 -2.280744794452704e-06,  1.282436268428311e-08,  2.678179514027928e-11, -1.092109160487288e-13, -3.623967962837111e-16,  1.091373590764638e-18,  5.258848727971085e-21,
 -1.140272208915513e-23, -7.931921089451387e-26,  1.148126628656139e-28,  1.343389631821544e+00, -2.590784552127513e-03, -3.072092661937896e-06,  1.102036111013170e-08,
  3.708946711622418e-11, -7.194420105780885e-14, -4.963321872419184e-16,  3.585820994604623e-19,  6.859694084669132e-21,  2.463548862340994e-24, -9.447509390485691e-26,
 -1.385944154227137e-28,  1.412308534094317e+00, -2.481005270224089e-03, -3.795715174515781e-06,  8.447904678490417e-09,  4.465905391191917e-11, -2.003270103435742e-14,
 -5.486879141664922e-16, -5.939594705106545e-19,  6.404676416463299e-21,  1.840197080781547e-23, -6.359907975645093e-26, -3.767763361492079e-28,  1.480100858823837e+00,
 -2.340963777353907e-03, -4.412061392994320e-06,  5.222583433809496e-09,  4.815186739996057e-11,  3.975670552367265e-14, -4.905132974370946e-16, -1.513422584758333e-18,
  3.553232589446477e-21,  2.907511341002981e-23,  9.096816743630399e-27, -4.238810516531897e-28,  1.546259865715073e+00, -2.171987786493476e-03, -4.881830208708263e-06,
  1.549823691682514e-09,  4.657612630188634e-11,  9.731025456712437e-14, -3.172453174686932e-16, -2.085091556910982e-18, -1.024069634342200e-21,  2.760409255305922e-23,
  8.916742279194002e-26, -1.878854837886406e-28,  1.610239476763453e+00, -1.976595806417450e-03, -5.169378104077494e-06, -2.278039161180709e-09,  3.958232247377468e-11,
  1.407732480334922e-13, -5.870327809024471e-17, -2.047847617394280e-18, -5.611338872068817e-21,  1.227526516889523e-23,  1.254011469556782e-25,  2.162130779914825e-28,
  1.671457995500238e+00, -1.758643956365999e-03, -5.246893843454916e-06, -5.900779631036445e-09,  2.771816026874490e-11,  1.593747172689943e-13,  2.208430082942634e-16,
 -1.334187686044396e-18, -8.055663369126769e-21, -1.031680506446514e-23,  8.510692614021177e-26,  4.901854472462628e-28,  1.729304328035847e+00, -1.523420501834941e-03,
 -5.099032868230231e-06, -8.928682384216416e-09,  1.254681706796838e-11,  1.469807197905602e-13,  4.377537766328962e-16, -1.630892004832960e-19, -6.932118993966142e-21,
 -2.730670548528024e-23, -1.141306357566498e-26,  3.851557759853303e-28,  1.783147124122943e+00, -1.277657640065490e-03, -4.727449097862432e-06, -1.100001395782786e-08,
 -3.473178152987483e-12,  1.052475117440565e-13,  5.188208549491248e-16,  9.977600111389682e-19, -2.654168601928245e-21, -2.764853866011918e-23, -9.405361654782013e-26,
 -2.499467510355075e-29,  1.832347123900751e+00, -1.029428587293974e-03, -4.154401751551560e-06, -1.185145150777206e-08, -1.741141208431957e-11,  4.480137892274606e-14,
  4.359992224267152e-16,  1.635199967164893e-18,  2.397623707024033e-21, -1.137943852354606e-23, -9.796055834475312e-26, -3.547125778573614e-28,  1.876272762034066e+00,
 -7.879022142658272e-04, -3.424432828738134e-06, -1.138825276945440e-08, -2.656652609347793e-11, -1.693047845781762e-14,  2.277836070572544e-16,  1.482668573984352e-18,
  5.240970580670934e-21,  8.712210395461413e-24, -2.778072602891441e-26, -2.987766040031607e-28,  1.914318740618066e+00, -5.629394865330725e-04, -2.603118765648773e-06,
 -9.734843005494844e-09, -2.928676302416804e-11, -6.144404253108563e-14, -1.091043653501554e-17,  7.140280842745276e-19,  4.453589393281870e-21,  1.728739651477544e-23,
  4.267253411851525e-26,  9.292678036920950e-30,  1.945926856888421e+00, -3.645366714210400e-04, -1.772204698578788e-06, -7.244800572983968e-09, -2.562911138959960e-11,
 -7.669333124194019e-14, -1.739990185728412e-16, -1.430467010490765e-19,  1.341883278813060e-21,  1.055965396266768e-23,  5.009185456426531e-26,  1.784954140510315e-28,
  1.970607927977605e+00, -2.021480290561724e-04, -1.021076296097551e-06, -4.455214504708950e-09, -1.754037918561168e-11, -6.293195309161586e-14, -2.036581682643000e-16,
 -5.719665288037138e-19, -1.233238324329607e-21, -8.567779754706918e-25,  1.055957170298976e-26,  8.333369410212944e-29,  1.987963401108404e+00, -8.394985449730820e-05,
 -4.354274487920829e-07, -1.984985777118511e-09, -8.362240560870359e-12, -3.321520288264765e-14, -1.254085850856039e-16, -4.507450650892975e-19, -1.536074680524378e-21,
 -4.909363958206083e-24, -1.437036603490907e-26, -3.640868237536874e-29,  1.997707323636179e+00, -1.611615102567125e-05, -8.483136238014069e-08, -3.960929612359731e-10,
 -1.729370278333208e-12, -7.226088550846506e-15, -2.924834005968863e-17, -1.154809460367177e-19, -4.466567928862882e-22, -1.696819534169720e-24, -6.341411979182374e-27,
 -2.333390679447296e-29,  3.731358859870778e-04, -1.622161881141525e-06,  5.288249534058220e-09, -1.532172986828412e-11,  4.160606252485034e-14, -1.084354069432884e-16,
  2.746480792014208e-19, -6.812346215862380e-22,  1.662374583335587e-24, -4.005311962279521e-27,  9.545838939469603e-30, -2.255905707224950e-32,  3.357858829040930e-03,
 -1.458460142499145e-05,  4.745005991538985e-08, -1.369935471259982e-10,  3.699809415361365e-13, -9.567580669881055e-16,  2.397721938123516e-18, -5.865282167751945e-21,
  1.406184371341400e-23, -3.314243654583888e-26,  7.688017499782135e-29, -1.758361108375018e-31,  9.325354789537096e-03, -4.043013601858138e-05,  1.310049032187974e-07,
 -3.755408302659363e-10,  1.003039816180662e-12, -2.552514027830502e-15,  6.256616248439692e-18, -1.485797144999813e-20,  3.426394857703564e-23, -7.679420363620448e-26,
  1.669217869856625e-28, -3.509598785764809e-31,  1.827168624187974e-02, -7.899952420372950e-05,  2.544162943035178e-07, -7.214406042122558e-10,  1.894210562740781e-12,
 -4.700144067828282e-15,  1.111486496284091e-17, -2.510821370704267e-20,  5.401221964159461e-23, -1.097452941087671e-25,  2.065585558445642e-28, -3.460216124028082e-31,
  3.019085207196487e-02, -1.300525234640908e-04,  4.153823770417024e-07, -1.160584823122081e-09,  2.975664267767059e-12, -7.121750985502863e-15,  1.596112487692684e-17,
 -3.327241498176443e-20,  6.314774483000570e-23, -1.035307781115423e-25,  1.225980450865460e-28,  8.591342284595936e-33,  4.507467198399594e-02, -1.932662365799775e-04,
  6.108399294391739e-07, -1.674497938176313e-09,  4.160763758120262e-12, -9.475317278985328e-15,  1.961624943888954e-17, -3.574867606783878e-20,  5.195760547365252e-23,
 -3.572844711328654e-26, -1.247517557160222e-28,  7.398742377007604e-31,  6.291262933950616e-02, -2.682329125206054e-04,  8.369706576044490e-07, -2.240636744366664e-09,
  5.347347393261986e-12, -1.137843769305510e-14,  2.086761270062817e-17, -2.931372456282604e-20,  1.378626909268859e-23,  1.006751634124074e-25, -5.126955039078205e-28,
  1.656174722689724e-30,  8.369166976006027e-02, -3.544572092251871e-04,  1.089210639881809e-06, -2.832780802245874e-09,  6.421857713310706e-12, -1.243701383960544e-14,
  1.862310018743685e-17, -1.179914952218332e-20, -5.249808504661957e-23,  2.900208427229364e-25, -9.408811719168040e-28,  2.344482232464387e-30,  1.073959520762236e-01,
 -4.513529306753790e-04,  1.362264052907092e-06, -3.421523672883272e-09,  7.264317895169855e-12, -1.227812604910566e-14,  1.207490953722527e-17,  1.727018202177244e-20,
 -1.406405639431737e-22,  4.910051886209368e-25, -1.239087636559027e-27,  2.265431160145904e-30,  1.340065474026678e-01, -5.582392581562275e-04,  1.650122618934192e-06,
 -3.974876978241977e-09,  7.754145395240249e-12, -1.058600323401527e-14,  8.608758245644066e-19,  5.616372022218356e-20, -2.362069153934194e-22,  6.398479090832930e-25,
 -1.202246353033073e-27,  9.444487922198798e-31,  1.635010812531170e-01, -6.743365063490012e-04,  1.946092565896835e-06, -4.459000781131716e-09,  7.776769367935183e-12,
 -7.139644251418299e-15, -1.479146076936626e-17,  1.006537562495515e-19, -3.172815514515112e-22,  6.606819957674982e-25, -6.514720728861793e-28, -1.776704032822601e-30,
  1.958533126709410e-01, -7.987614499019260e-04,  2.242831295006382e-06, -4.839074783404764e-09,  7.230983705984127e-12, -1.850196832287273e-15, -3.395522421504837e-17,
  1.440397704088439e-19, -3.569590697745248e-22,  4.830398740744253e-25,  4.880115842817490e-28, -5.499849918264149e-30,  2.310326433355095e-01, -9.305222866361552e-04,
  2.532396410439586e-06, -5.080325100101064e-09,  6.036917645236136e-12,  5.204328299535312e-15, -5.494819880586665e-17,  1.775736207714888e-19, -3.277293532070563e-22,
  6.467442082388716e-26,  2.109716423112441e-27, -9.141884136963394e-30,  2.690035485084817e-01, -1.068513331121719e-03,  2.806310284250927e-06, -5.149220504174359e-09,
  4.144437203485867e-12,  1.375003010706470e-14, -7.535082805935490e-17,  1.913470750243289e-19, -2.075581893514700e-22, -5.839880830757571e-25,  3.874740212686752e-27,
 -1.102567205937124e-29,  3.097249205111214e-01, -1.211509568927191e-03,  3.055643904690030e-06, -5.014849535113301e-09,  1.541699460787738e-12,  2.329744244929406e-14,
 -9.211832368240036e-17,  1.756618549337907e-19,  1.292811921982805e-23, -1.379467543951008e-24,  5.215935174844995e-27, -9.271478478678026e-30,  3.531493141850525e-01,
 -1.358161249766231e-03,  3.271124377519640e-06, -4.650485034652173e-09, -1.736535782470069e-12,  3.313551234580027e-14, -1.018044174101945e-16,  1.228391985583215e-19,
  3.232157705110169e-22, -2.156265571877935e-24,  5.424114511789339e-27, -2.497539891664722e-30,  3.992220825085882e-01, -1.506988759886175e-03,  3.443271095583234e-06,
 -4.035334612771080e-09, -5.601378795778823e-12,  4.234406694785863e-14, -1.009083243127522e-16,  2.933820431036163e-20,  6.871938096681886e-22, -2.677312004825687e-24,
  3.830400135245301e-27,  9.282629245992115e-30,  4.478803892609104e-01, -1.656378093756341e-03,  3.562566221495466e-06, -3.156463114681133e-09, -9.903784745439576e-12,
  4.982989774701479e-14, -8.634585521543797e-17, -1.020597702580157e-19,  1.040955950809356e-21, -2.670669035569172e-24,  7.362042579358375e-29,  2.383371466508804e-29,
  4.990520844146997e-01, -1.804577346342174e-03,  3.619665675069054e-06, -2.010854956000275e-09, -1.443094970352752e-11,  5.439143106994138e-14, -5.602897605433529e-17,
 -2.603735040824360e-19,  1.296331803815243e-21, -1.895487041431737e-24, -5.596161440718432e-27,  3.635873419684079e-29,  5.526544268981937e-01, -1.949694774384890e-03,
  3.605657176125045e-06, -6.075585874279976e-10, -1.890626371745275e-11,  5.481605017403558e-14, -9.514334585049007e-18, -4.253565779453173e-19,  1.352170626149179e-21,
 -2.328938684812636e-25, -1.207253076022986e-26,  4.012984853424238e-29,  6.085926386539410e-01, -2.089699132790012e-03,  3.512371907039460e-06,  1.030179428851579e-09,
 -2.299416699293694e-11,  5.001210594358938e-14,  5.135004698398050e-17, -5.678553165753231e-19,  1.114530212589430e-21,  2.213439002035133e-24, -1.734149892437272e-26,
  2.846036439999254e-29,  6.667582737556761e-01, -2.222423184936598e-03,  3.332755798867875e-06,  2.862928894715560e-09, -2.631142053930648e-11,  3.917404352821525e-14,
  1.218884390766524e-16, -6.522315879492941e-19,  5.251167448891854e-22,  5.035771299367576e-24, -1.877383800449010e-26, -2.009710981088254e-30,  7.270273870399931e-01,
 -2.345571516980903e-03,  3.061304988443038e-06,  4.833434880269647e-09, -2.844636144386283e-11,  2.197339703337727e-14,  1.943201790202181e-16, -6.413795377632924e-19,
 -4.055844672025582e-22,  7.501281694470793e-24, -1.386744431693317e-26, -4.746888773203286e-29,  7.892584886989736e-01, -2.456734057325269e-03,  2.694567204384506e-06,
  6.865586698237836e-09, -2.898757324385764e-11, -1.239734807398418e-15,  2.579247731810779e-16, -5.045256970782287e-19, -1.567939588600918e-21,  8.638956870492010e-24,
 -1.414172201110444e-27, -9.422593166364899e-29,  8.532902751506620e-01, -2.553407010313992e-03,  2.231706146498092e-06,  8.864342015678200e-09, -2.756293554912609e-11,
 -2.925082070053864e-14,  2.998469806006157e-16, -2.273520917916931e-19, -2.737241289681490e-21,  7.471753215287085e-24,  1.716922322621554e-26, -1.196044535356451e-28,
  9.189391330347924e-01, -2.633023247380793e-03,  1.675118615801274e-06,  1.071703374742323e-08, -2.388905995619343e-11, -5.984943403880977e-14,  3.067124250754541e-16,
  1.770219684936093e-19, -3.587001597346236e-21,  3.395117521475291e-24,  3.690928706199099e-26, -9.879430457028206e-29,  9.859964233784048e-01, -2.692994536708548e-03,
  1.031083408958109e-06,  1.229656005817739e-08, -1.782948399495170e-11, -8.980398061117642e-14,  2.671276803155102e-16,  6.589598419401514e-19, -3.745682540527105e-21,
 -3.366202008047234e-24,  4.955660629349236e-26, -1.813108702166506e-29,  1.054225568102787e+00, -2.730768292927665e-03,  3.104059614681446e-07,  1.346699796083279e-08,
 -9.457508006239730e-12, -1.150041160317906e-13,  1.749432553890704e-16,  1.129214036472873e-18, -2.903571000102142e-21, -1.138672619987748e-23,  4.586242819315862e-26,
  1.088941619091578e-28,  1.123358982620377e+00, -2.743901723698220e-03, -4.709972818181683e-07,  1.409215318570246e-08,  8.838604453172975e-13, -1.308327862536183e-13,
  3.284505254151165e-17,  1.466687739865577e-18, -9.589853857400524e-22, -1.800795218356667e-23,  2.003515395369966e-26,  2.321740992779287e-28,  1.193094928026740e+00,
 -2.730156235802354e-03, -1.291655958052406e-06,  1.404741261601076e-08,  1.253659940204035e-11, -1.328123124667301e-13, -1.445746707881901e-16,  1.541243653871700e-18,
  1.834832962636478e-21, -1.991665079321516e-23, -2.478352839278526e-26,  2.749518776498134e-28,  1.263094396122723e+00, -2.687614588495513e-03, -2.124354970675143e-06,
  1.323493582146324e-08,  2.451317341241466e-11, -1.175231225653055e-13, -3.295483865008563e-16,  1.252487343644343e-18,  4.792613970648229e-21, -1.445741410121899e-23,
 -7.299999984252566e-26,  1.718038744704503e-28,  1.332978191770793e+00, -2.614822341296023e-03, -2.936337309049525e-06,  1.160163815540698e-08,  3.553240508017969e-11,
 -8.371082971608402e-14, -4.832106764304516e-16,  5.787711292722280e-19,  6.879056710000350e-21, -1.419010098903547e-24, -9.918338529936195e-26, -7.417589873920031e-29,
  1.402324440714428e+00, -2.510953380057527e-03, -3.690068602869085e-06,  9.158523589704602e-09,  4.412548991339639e-11, -3.337702827372154e-14, -5.623535794192935e-16,
 -3.789333440192387e-19,  7.017416473831608e-21,  1.553280139016456e-23, -7.967274703079208e-26, -3.511461940233239e-28,  1.470666826213143e+00, -2.375996430981091e-03,
 -4.344743683804350e-06,  5.998720591532270e-09,  4.882591638975151e-11,  2.748969363182674e-14, -5.311396419439629e-16, -1.382938988580031e-18,  4.601861959076476e-21,
  2.905191391146045e-23, -1.058196073817127e-26, -4.684684117921208e-28,  1.537493941149097e+00, -2.210955222794481e-03, -4.858698185930933e-06,  2.310177760653555e-09,
  4.844144837630803e-11,  8.899301555167292e-14, -3.759324648773975e-16, -2.101291272664697e-18,  3.163496556550899e-23,  3.097782978425804e-23,  7.882868382030163e-26,
 -2.826618362684061e-28,  1.602250225838117e+00, -2.018049197358345e-03, -5.192822062808412e-06, -1.622294685977579e-09,  4.237895112480878e-11,  1.386564453340730e-13,
 -1.184834533071680e-16, -2.219354372093919e-18, -5.077027197952368e-21,  1.746159258391068e-23,  1.333849603123628e-25,  1.434065501764412e-28,  1.664339031879465e+00,
 -1.800894561140985e-03, -5.314936171462871e-06, -5.431514362382688e-09,  3.095547908686369e-11,  1.641972144906608e-13,  1.798259118940857e-16, -1.597211797028142e-18,
 -8.360536450687548e-21, -6.475145079656630e-24,  1.070941408116363e-25,  5.063221930660097e-28,  1.723128388039942e+00, -1.564637701691219e-03, -5.204873711408627e-06,
 -8.703847580279706e-09,  1.559098907317837e-11,  1.574060352863432e-13,  4.299334775786128e-16, -4.006990137345469e-19, -7.919047163678377e-21, -2.739716905606454e-23,
  7.567738907687917e-27,  4.781645588704614e-28,  1.777960017258864e+00, -1.316006013804739e-03, -4.859711010090161e-06, -1.103805935002946e-08, -1.241501591721249e-12,
  1.180239164619374e-13,  5.454142507676636e-16,  8.961740613035714e-19, -3.717308067955558e-21, -3.141136555496750e-23, -9.352539651791954e-26,  5.224035545314998e-29,
  1.828162031821783e+00, -1.063237335013063e-03, -4.298259211734933e-06, -1.212228161954312e-08, -1.640699295936185e-11,  5.582305093247785e-14,  4.827918014272052e-16,
  1.704582301768736e-18,  1.913628634275420e-21, -1.561450258309995e-23, -1.138840448174158e-25, -3.671950382097461e-28,  1.873065486511576e+00, -8.158515628568339e-04,
 -3.563652421038495e-06, -1.181571457408735e-08, -2.684700576161425e-11, -1.094626242073129e-14,  2.716917487576589e-16,  1.655156523911433e-18,  5.531262561751207e-21,
  7.318479302638265e-24, -4.240456188508997e-26, -3.672423459645009e-28,  1.912024581554290e+00, -5.842397685744964e-04, -2.722788990831714e-06, -1.021326939313552e-08,
 -3.051655725203485e-11, -6.144928855642160e-14,  1.117346797438080e-17,  8.668301805684647e-19,  5.106675945476488e-21,  1.899326478489254e-23,  4.237343455889667e-26,
 -2.472012293869225e-29,  1.944439794325579e+00, -3.790691486098450e-04, -1.861654056219155e-06, -7.667365452806313e-09, -2.720503558954225e-11, -8.091215365977240e-14,
 -1.773431657303890e-16, -9.362162063807208e-20,  1.760048141249976e-21,  1.272682881744313e-23,  5.842689445048867e-26,  2.004514250455055e-28,  1.969782653180512e+00,
 -2.105353581136385e-04, -1.076265156968885e-06, -4.746200780110638e-09, -1.884921658440548e-11, -6.801641467434627e-14, -2.202297341615468e-16, -6.118345948647655e-19,
 -1.255538716325380e-21, -3.547296727553099e-25,  1.470800010071376e-26,  1.060242600992357e-28,  1.987620480713287e+00, -8.753087950566630e-05, -4.600725169411007e-07,
 -2.124263984503457e-09, -9.057694382599339e-12, -3.638218106265146e-14, -1.387449872102425e-16, -5.028413768704286e-19, -1.723552984143757e-21, -5.517145950354406e-24,
 -1.604149182997757e-26, -3.953062311803315e-29,  1.997641470948335e+00, -1.681429601259262e-05, -8.975539330057770e-08, -4.249583288696204e-10, -1.881182154927002e-12,
 -7.968523665475405e-15, -3.269145300363275e-17, -1.308023692591037e-19, -5.125668523773225e-22, -1.972263027340494e-24, -7.463238136904212e-27, -2.779539376571649e-29,
  3.667307017659024e-04, -1.580580173580495e-06,  5.108312532922495e-09, -1.467303077078909e-11,  3.950175539539652e-14, -1.020668673740448e-16,  2.562970912355480e-19,
 -6.302738984742650e-22,  1.524823776127249e-24, -3.642605771138639e-27,  8.606876677438163e-30, -2.016861744971537e-32,  3.300269352970622e-03, -1.421147743534660e-05,
  4.584103403752267e-08, -1.312238616593231e-10,  3.514081891871396e-13, -9.011337092537246e-16,  2.239618521995976e-18, -5.433814502215092e-21,  1.292225493384241e-23,
 -3.021652843024755e-26,  6.954600780216780e-29, -1.578764402866527e-31,  9.165702162929147e-03, -3.939985375336234e-05,  1.265930464654581e-07, -3.598925760749912e-10,
  9.534580552945498e-13, -2.407226126984736e-15,  5.855536701898827e-18, -1.380449953750896e-20,  3.161590855067511e-23, -7.041642702534379e-26,  1.522024644751778e-28,
 -3.186315594898535e-31,  1.795970469436271e-02, -7.699831482425693e-05,  2.459377954763417e-07, -6.918710000379174e-10,  1.802819297641041e-12, -4.441631954625375e-15,
  1.043544971029781e-17, -2.344147073215736e-20,  5.020650032341652e-23, -1.017810541563917e-25,  1.918106167006570e-28, -3.244442874421134e-31,  2.967720102024615e-02,
 -1.267843738299811e-04,  4.017363891423960e-07, -1.114093174377671e-09,  2.836985621804614e-12, -6.749638587647183e-15,  1.505723388783183e-17, -3.131037424555457e-20,
  5.950891293436829e-23, -9.862859433190309e-26,  1.222936595276009e-28, -2.128897260590573e-32,  4.431125479365580e-02, -1.884587755557237e-04,  5.911392157296797e-07,
 -1.609416526184547e-09,  3.975885200228578e-12, -9.016352190275459e-15,  1.863836364594424e-17, -3.410751379799316e-20,  5.058908575858956e-23, -4.010233019825530e-26,
 -9.477581848804941e-29,  6.254103198177726e-31,  6.185292096235286e-02, -2.616432604648250e-04,  8.105889396374621e-07, -2.156872802866652e-09,  5.124720654266243e-12,
 -1.088741133773006e-14,  2.005352210470573e-17, -2.881839408330194e-20,  1.705845757563788e-23,  8.156592223419954e-26, -4.441837746752972e-28,  1.461559228389325e-30,
  8.229105544332431e-02, -3.458777695863997e-04,  1.055825638515300e-06, -2.731996832146775e-09,  6.177559279016554e-12, -1.199420438993306e-14,  1.827072381551572e-17,
 -1.331910183858305e-20, -4.271048116091047e-23,  2.543860083067551e-25, -8.423890210646768e-28,  2.134631771564001e-30,  1.056120793075920e-01, -4.406170940536264e-04,
  1.321895091219310e-06, -3.307243185577905e-09,  7.021689961036904e-12, -1.198301799973673e-14,  1.249805790295162e-17,  1.304313050637828e-20, -1.238327533878265e-22,
  4.434069713634451e-25, -1.141548256100996e-27,  2.165967738106583e-30,  1.317996931976853e-01, -5.452269782530006e-04,  1.603161511451963e-06, -3.852502770272227e-09,
  7.542754994957001e-12, -1.054730437429362e-14,  2.331036464523261e-18,  4.896445446073670e-20, -2.140275118951487e-22,  5.926412238151566e-25, -1.156899723969407e-27,
  1.107747755971037e-30,  1.608345367965354e-01, -6.589796935509509e-04,  1.893326354307367e-06, -4.335733164527476e-09,  7.630648978276421e-12, -7.461945144359408e-15,
 -1.211175881184162e-17,  9.087612715161692e-20, -2.939833874029110e-22,  6.332243452869930e-25, -7.175047873132867e-28, -1.240273278771263e-30,  1.926937871750057e-01,
 -7.810491113971639e-04,  2.185455211175834e-06, -4.723718004971269e-09,  7.186150595512608e-12, -2.617999423472410e-15, -3.007938989626825e-17,  1.328986215285223e-19,
 -3.392741193301101e-22,  4.979899343085732e-25,  2.659718677642413e-28, -4.610000605900116e-30,  2.273506887548539e-01, -9.105053214624796e-04,  2.472015260655593e-06,
 -4.982971708487378e-09,  6.128213267067283e-12,  3.944053909917590e-15, -5.012249850486368e-17,  1.671390524290282e-19, -3.239762439078403e-22,  1.413222035461957e-25,
  1.730096081086040e-27, -8.122817448877721e-30,  2.647740064260103e-01, -1.046308863874330e-03,  2.744926265854636e-06, -5.080805953698460e-09,  4.401783624598044e-12,
  1.200513394084084e-14, -7.008904874234538e-17,  1.843978119405815e-19, -2.259070276790409e-22, -4.384984670833348e-25,  3.404872987139517e-27, -1.032149325392955e-29,
  3.049273920470507e-01, -1.187304676485113e-03,  2.995628705191210e-06, -4.986573202674657e-09,  1.985938365236549e-12,  2.114562734543840e-14, -8.720118318504061e-17,
  1.753204458710283e-19, -3.307624115548053e-23, -1.179061122844016e-24,  4.803029271643311e-27, -9.458502702545117e-30,  3.477686531376598e-01, -1.332215900856090e-03,
  3.215173292328923e-06, -4.673099488604290e-09, -1.097974255110141e-12,  3.073457881209790e-14, -9.823149174442619e-17,  1.319817234806586e-19,  2.494645607201777e-22,
 -1.941990510925380e-24,  5.278175439966958e-27, -4.072125270301882e-30,  3.932489110539953e-01, -1.479637747248304e-03,  3.394336869581308e-06, -4.118312884371008e-09,
 -4.778636447339083e-12,  3.993452171166466e-14, -9.979326620390269e-17,  4.981658760778364e-20,  5.936583408056442e-22, -2.516861175417224e-24,  4.169790703845417e-27,
  6.213777905899698e-30,  4.413116343501110e-01, -1.628031693037963e-03,  3.523770421297112e-06, -3.307064386989539e-09, -8.928122190672285e-12,  4.772698046841346e-14,
 -8.875161859525986e-17, -7.028493682667165e-20,  9.451067909047567e-22, -2.647935114909822e-24,  1.034164123258098e-27,  1.986518227615042e-29,  4.918915314220587e-01,
 -1.775720385009498e-03,  3.594185699532013e-06, -2.233122979313931e-09, -1.335713461057841e-11,  5.296387316339804e-14, -6.274922607426645e-17, -2.200228190071118e-19,
  1.224441596602589e-21, -2.088328267671816e-24, -4.070851532316434e-27,  3.293515392221638e-29,  5.449132849907400e-01, -1.920883739071774e-03,  3.596587599310704e-06,
 -9.013046071307549e-10, -1.781316563836118e-11,  5.444966478905454e-14, -2.082045125931829e-17, -3.823110199423471e-19,  1.335518322631364e-21, -6.806515596698498e-25,
 -1.032116949643417e-26,  3.933424779920110e-29,  6.002901096379100e-01, -2.061556886907636e-03,  3.522559830452334e-06,  6.703363217975165e-10, -2.198286763509833e-11,
  5.105780672959042e-14,  3.596044687232833e-17, -5.310467601750198e-19,  1.182041327044069e-21,  1.546055672822786e-24, -1.599972870097754e-26,  3.229826520681204e-29,
  6.579221126674902e-01, -2.195630814118592e-03,  3.364611402079151e-06,  2.448366782587357e-09, -2.550015519927021e-11,  4.188227740170245e-14,  1.038874270368487e-16,
 -6.326721843164077e-19,  6.928918614589008e-22,  4.285865573067734e-24, -1.865428445238518e-26,  7.210698971424701e-30,  7.176944383156041e-01, -2.320856774593984e-03,
  3.116590662817955e-06,  4.382056105044916e-09, -2.796171784398681e-11,  2.642035680992118e-14,  1.762196612568602e-16, -6.501484157511390e-19, -1.459914883064441e-22,
  6.908621738070213e-24, -1.567217805461890e-26, -3.465403149923041e-29,  7.794751761985423e-01, -2.434855855872106e-03,  2.774171695619966e-06,  6.401918601257441e-09,
 -2.895163834299561e-11,  4.775556223886858e-15,  2.431422469079204e-16, -5.497425575007815e-19, -1.258924873218213e-21,  8.502745529402301e-24, -5.313056547954701e-27,
 -8.279243541859320e-29,  8.431130174581433e-01, -2.535135411776125e-03,  2.335414163549978e-06,  8.419043576804391e-09, -2.807655440478049e-11, -2.214052830858760e-14,
  2.922961605774805e-16, -3.105178002088651e-19, -2.457159736430125e-21,  8.053854135995770e-24,  1.195627890407396e-26, -1.168033117106009e-28,  9.084346471476319e-01,
 -2.619114467024063e-03,  1.801391469987674e-06,  1.032563428511803e-08, -2.501210268736181e-11, -5.244170414594023e-14,  3.100824189031960e-16,  6.446970141522529e-20,
 -3.439286552008636e-21,  4.780629510894873e-24,  3.227711812036225e-26, -1.110398903069001e-28,  9.752418700810769e-01, -2.684160618382531e-03,  1.176872373464241e-06,
  1.199727404017399e-08, -1.956002886779065e-11, -8.318514850819096e-14,  2.838849882718214e-16,  5.375395747031284e-19, -3.831454694194728e-21, -1.408351222353101e-24,
  4.813178799882965e-26, -4.614639948041496e-29,  1.043308481058085e+00, -2.727641375047527e-03,  4.710268813813299e-07,  1.329751585667111e-08, -1.171309871057062e-11,
 -1.104369271875779e-13,  2.052013992494504e-16,  1.030103841158737e-18, -3.279408723524050e-21, -9.466446542000676e-24,  4.990017682305888e-26,  7.440318086270030e-29,
  1.112376910850366e+00, -2.746993236708341e-03, -3.018927659037422e-07,  1.408541842984178e-08, -1.721606461085253e-12, -1.295557586013129e-13,  7.338644156580199e-17,
  1.425801937706446e-18, -1.590437108832039e-21, -1.700812745113762e-23,  2.979718396598597e-26,  2.103750254146844e-28,  1.182154708738005e+00, -2.739812000732419e-03,
 -1.121971719567782e-06,  1.422657449453753e-08,  9.849182227317132e-12, -1.357582806989539e-13, -1.007068579376035e-16,  1.588318916733808e-18,  1.102944348445078e-21,
 -2.066185395687568e-23, -1.239141056934156e-26,  2.866452161706369e-28,  1.252310963118431e+00, -2.703967665124954e-03, -1.963261400126842e-06,  1.360792539446958e-08,
  2.208654744111414e-11, -1.249946186780218e-13, -2.924138209436918e-16,  1.396975696673504e-18,  4.221552962415900e-21, -1.721048529580446e-23, -6.427493000684580e-26,
  2.237509686922038e-28,  1.322472816204729e+00, -2.637746627627830e-03, -2.793763814396008e-06,  1.215613875376391e-08,  3.374365883180262e-11, -9.508861889497095e-14,
 -4.639364371525254e-16,  7.973127299931486e-19,  6.755959095809994e-21, -5.431189744716292e-24, -1.009109033853651e-25, -3.555813435899992e-30,  1.392222299015624e+00,
 -2.540022373128293e-03, -3.575954685724961e-06,  9.858454650202421e-09,  4.332225831960047e-11, -4.697496684917461e-14, -5.697404040308711e-16, -1.460737717723508e-19,
  7.515609042981352e-21,  1.204805700540207e-23, -9.425882777027122e-26, -3.091917853213791e-28,  1.461093799291538e+00, -2.410453123993459e-03, -4.268055884293981e-06,
  6.783628144795304e-09,  4.924519032925643e-11,  1.429527751009096e-14, -5.676438895302407e-16, -1.219068133338734e-18,  5.635051380515125e-21,  2.820641359685700e-23,
 -3.191075185927800e-26, -4.983060615710659e-28,  1.528572575436179e+00, -2.249700611690235e-03, -4.826268580932045e-06,  3.098969612398863e-09,  5.012632420827195e-11,
  7.926576848920185e-14, -4.345826065497625e-16, -2.081853192041898e-18,  1.200337716761712e-21,  3.385385279626650e-23,  6.427070719456725e-26, -3.789364942384688e-28,
  1.594094837151273e+00, -2.059657907283238e-03, -5.208130265460330e-06, -9.222223898926805e-10,  4.511851822728723e-11,  1.350493987908602e-13, -1.827979762049308e-16,
 -2.370720809502052e-18, -4.351084637243931e-21,  2.289736387549464e-23,  1.377295594260314e-25,  5.087864855897136e-29,  1.657050014078846e+00, -1.843666092286228e-03,
 -5.377033530934327e-06, -4.909736401504269e-09,  3.427880207459630e-11,  1.679459567624317e-13,  1.313295649397144e-16, -1.867608245646270e-18, -8.511157732168621e-21,
 -1.745338519028922e-24,  1.293687882816571e-25,  5.024879670646682e-28,  1.716785904068322e+00, -1.606689992438815e-03, -5.307717455087243e-06, -8.428650497686826e-09,
  1.884123318071217e-11,  1.675602604040985e-13,  4.150185616483463e-16, -6.697880520688617e-19, -8.894572797264154e-21, -2.664586764281125e-23,  3.068441636374272e-26,
  5.724206709649167e-28,  1.772617398700627e+00, -1.355413682364265e-03, -4.992206684129252e-06, -1.103832005256981e-08,  1.251834683948883e-12,  1.314004606381672e-13,
  5.686666583829761e-16,  7.584113356247496e-19, -4.914656562945725e-21, -3.507920933173210e-23, -8.915625378002837e-26,  1.498114598807134e-28,  1.823839382857775e+00,
 -1.098209651904469e-03, -4.445262735343231e-06, -1.237521591308471e-08, -1.517076247489972e-11,  6.798916188360305e-14,  5.312864542352456e-16,  1.755913608595052e-18,
  1.265607064614949e-21, -2.049379433472454e-23, -1.300723988358151e-25, -3.659983772434151e-28,  1.869744153498914e+00, -8.449352531671102e-04, -3.708024341461178e-06,
 -1.224664766229179e-08, -2.699686673926457e-11, -3.849295881649450e-15,  3.205512212951981e-16,  1.836012103415928e-18,  5.760104394365618e-21,  5.277288987145467e-24,
 -6.020780806770321e-26, -4.431260903424399e-28,  1.909643269806334e+00, -6.065207112015026e-04, -2.848318299013632e-06, -1.071134303248619e-08, -3.174079726304170e-11,
 -6.087076122296375e-14,  3.783761170235042e-17,  1.041508186907389e-18,  5.820566575321263e-21,  2.065378003176563e-23,  4.031471175493198e-26, -7.111860649571907e-29,
  1.942893137935686e+00, -3.943379388638787e-04, -1.956328278335864e-06, -8.115823993505414e-09, -2.886601860797282e-11, -8.519304226187433e-14, -1.791038742917541e-16,
 -2.950072984624102e-20,  2.262466175112047e-21,  1.524680405706519e-23,  6.773206010857145e-26,  2.224263983644240e-28,  1.968922923417497e+00, -2.193785292737324e-04,
 -1.135074928318312e-06, -5.058963957837451e-09, -2.026381115299520e-11, -7.351205225192980e-14, -2.379246393295232e-16, -6.520930272952560e-19, -1.256524477145438e-21,
  3.347102590271784e-25,  1.996770150543921e-26,  1.340099527489805e-28,  1.987262831038356e+00, -9.131594450591609e-05, -4.864578350692495e-07, -2.275194068630211e-09,
 -9.819810249961147e-12, -3.988743586105819e-14, -1.536274591823566e-16, -5.613002437461467e-19, -1.934147308811843e-21, -6.194468452128344e-24, -1.784574234878106e-26,
 -4.242485610812345e-29,  1.997572744642460e+00, -1.755326123576774e-05, -9.504088753278147e-08, -4.563761162346378e-10, -2.048705101674581e-12, -8.798989301507971e-15,
 -3.659464824821942e-17, -1.484006294964334e-19, -5.892502271084012e-22, -2.296763522899632e-24, -8.800964218712984e-27, -3.317768749105986e-29,  3.604890138886000e-04,
 -1.540407387316326e-06,  4.935962034498205e-09, -1.405700507437296e-11,  3.752052787885675e-14, -9.612211428583596e-17,  2.393132932076831e-19, -5.835129304559616e-22,
  1.399678933917621e-24, -3.315436710752584e-27,  7.767010906689005e-30, -1.804893958536812e-32,  3.244147059918814e-03, -1.385095367638125e-05,  4.429949745632492e-08,
 -1.257426424651870e-10,  3.339109368507486e-13, -8.491628857830825e-16,  2.093101104848897e-18, -5.037183464348162e-21,  1.188290327846503e-23, -2.756877344563233e-26,
  6.295832583406551e-29, -1.418658983236998e-31,  9.010101246188881e-03, -3.840412849471905e-05,  1.223643031362137e-07, -3.450148971423581e-10,  9.066881340075925e-13,
 -2.271219535850522e-15,  5.482801769191440e-18, -1.283220221319936e-20,  2.918720491707633e-23, -6.459989942542901e-26,  1.388369985111227e-28, -2.893706968607365e-31,
  1.765559454108891e-02, -7.506353856556532e-05,  2.378055261287194e-07, -6.637231645013902e-10,  1.716438925306057e-12, -4.198879282427300e-15,  9.801040600235518e-18,
 -2.189203538201168e-20,  4.667710213858911e-23, -9.438794302400150e-26,  1.779969100706006e-28, -3.035807744683513e-31,  2.917640771210636e-02, -1.236231976624730e-04,
  3.886352297046284e-07, -1.069762006214867e-09,  2.705536672559267e-12, -6.398573322937808e-15,  1.420667634221371e-17, -2.946195727572036e-20,  5.604604148378333e-23,
 -9.376293826737159e-26,  1.208176327981793e-28, -4.485416368169369e-32,  4.356675711209670e-02, -1.838058459309185e-04,  5.722020294513698e-07, -1.547220996334877e-09,
  3.799954947513878e-12, -8.580310016098760e-15,  1.770579522249584e-17, -3.251244166643567e-20,  4.908351851639585e-23, -4.337317181268576e-26, -6.948640440942663e-29,
  5.265035258367977e-31,  6.081915536748146e-02, -2.552607012985742e-04,  7.851913374535871e-07, -2.076593381627393e-09,  4.911720242564334e-12, -1.041574551058028e-14,
  1.925466695915681e-17, -2.822884795934514e-20,  1.969003496235806e-23,  6.503210391554592e-26, -3.837740574751023e-28,  1.287581879297674e-30,  8.092423229177628e-02,
 -3.375606381071380e-04,  1.023626882868051e-06, -2.635051260831345e-09,  5.942029194112981e-12, -1.156032844380480e-14,  1.787998608711456e-17, -1.454563396031297e-20,
 -3.413700626634868e-23,  2.225101456872917e-25, -7.528340756579904e-28,  1.938300142305161e-30,  1.038705125748040e-01, -4.301987892048297e-04,  1.282874399548843e-06,
 -3.196797015313394e-09,  6.785056464029210e-12, -1.167911545845811e-14,  1.281012644171715e-17,  9.327256578636430e-21, -1.086693381867643e-22,  3.996192265479144e-25,
 -1.048643864938153e-27,  2.055524737979311e-30,  1.296441459539547e-01, -5.325845706748948e-04,  1.557648632554313e-06, -3.733502766914071e-09,  7.332475490358866e-12,
 -1.047566196922225e-14,  3.609301126024875e-18,  4.244810175787267e-20, -1.935133089614751e-22,  5.473767481214601e-25, -1.105498718257800e-27,  1.221206897839256e-30,
  1.582285846433714e-01, -6.440391338124162e-04,  1.842025124909502e-06, -4.214851639548505e-09,  7.478703955023346e-12, -7.723135157999376e-15, -9.695544867394010e-18,
  8.182775847163633e-20, -2.717157994744634e-22,  6.035706472066039e-25, -7.619173632039210e-28, -7.921265236943573e-31,  1.896042017641494e-01, -7.637902577670331e-04,
  2.129458614042676e-06, -4.609196455539399e-09,  7.126866697717694e-12, -3.296461030373003e-15, -2.650751576503030e-17,  1.223303629215134e-19, -3.212016746729398e-22,
  5.048113178262706e-25,  8.084208574959495e-29, -3.821141580106527e-30,  2.237478433679370e-01, -8.909667095670952e-04,  2.412810304282554e-06, -4.884353037174829e-09,
  6.195437984160064e-12,  2.796106330790716e-15, -4.558689029797417e-17,  1.568658887287910e-19, -3.177264899108216e-22,  2.036648024972953e-25,  1.394017567750816e-27,
 -7.164058766116208e-30,  2.606323053631199e-01, -1.024592117485461e-03,  2.684386797731262e-06, -5.008546249801101e-09,  4.625478865659373e-12,  1.038412388782899e-14,
 -6.502930718684331e-17,  1.769416223015693e-19, -2.393489239724227e-22, -3.111674579376555e-25,  2.967163756446866e-27, -9.568635001659190e-30,  3.002257252248856e-01,
 -1.163578430771215e-03,  2.935994069172613e-06, -4.951526932389063e-09,  2.388319475154818e-12,  1.911154910033624e-14, -8.231315029532645e-17,  1.736191316110515e-19,
 -7.216464638612130e-23, -9.952703385335712e-25,  4.386683795885483e-27, -9.435315556379760e-30,  3.424908767902809e-01, -1.306719076051265e-03,  3.159010566299775e-06,
 -4.685876366059234e-09, -5.065545091914960e-13,  2.842220778250716e-14, -9.443446505059611e-17,  1.388863766522906e-19,  1.833064944408702e-22, -1.734827875606870e-24,
  5.071154243201541e-27, -5.281360018829231e-30,  3.873843547071066e-01, -1.452681971241685e-03,  3.344484302513968e-06, -4.188511162659530e-09, -4.003772669725539e-12,
  3.755828580712351e-14, -9.814583170618922e-17,  6.739661895740254e-20,  5.061120458521637e-22, -2.345411918069904e-24,  4.383354311148935e-27,  3.561166500484350e-30,
  4.348556332341015e-01, -1.600002625417366e-03,  3.483259672160509e-06, -3.442394366028619e-09, -7.995025086447512e-12,  4.557665563512624e-14, -9.031045311592746e-17,
 -4.155710370539305e-20,  8.507262078810686e-22, -2.590199945381715e-24,  1.825558759509573e-27,  1.615389212279652e-29,  4.848459821121847e-01, -1.747077642493466e-03,
  3.566140624427748e-06, -2.438446754227918e-09, -1.231339338960655e-11,  5.138832113053438e-14, -6.837282515347432e-17, -1.820722200401167e-19,  1.146670476797931e-21,
 -2.223228108674117e-24, -2.700292788099627e-27,  2.934637849309721e-29,  5.372872202055095e-01, -1.892159063510102e-03,  3.584097719220817e-06, -1.177634013881421e-09,
 -1.673001148029322e-11,  5.382632128385859e-14, -3.093107988057639e-17, -3.400428067924344e-19,  1.303997057412086e-21, -1.059297126189161e-24, -8.622596380592341e-27,
  3.775977137456278e-29,  5.921002856543793e-01, -2.033350133572830e-03,  3.528527347443183e-06,  3.268216030849385e-10, -2.095426311494425e-11,  5.174674708628128e-14,
  2.162819508515521e-17, -4.924515964185925e-19,  1.226529730307018e-21,  9.353178326076884e-25, -1.451895515697450e-26,  3.480052002849548e-29,  6.491935995622696e-01,
 -2.168603272827126e-03,  3.391571853349973e-06,  2.047194956801109e-09, -2.463899803421650e-11,  4.416564072799631e-14,  8.650519411434450e-17, -6.081742312489686e-19,
  8.338504013191936e-22,  3.548435418744984e-24, -1.816055225198843e-26,  1.499141651093493e-29,  7.084611990215871e-01, -2.295721274564534e-03,  3.166509176024627e-06,
  3.939119471058499e-09, -2.739249429476901e-11,  3.043087632010755e-14,  1.579866120926354e-16, -6.509645307825996e-19,  9.110057478297100e-23,  6.254865046481468e-24,
 -1.692741926095206e-26, -2.254343049025972e-29,  7.697806149627013e-01, -2.412363055767472e-03,  2.848219525964899e-06,  5.939768222411937e-09, -2.879904222785248e-11,
  1.042198557440977e-14,  2.272311411640254e-16, -5.851785000670531e-19, -9.574967141648481e-22,  8.220962943942061e-24, -8.685723408813016e-27, -7.039573950623907e-29,
  8.330104714623017e-01, -2.516055652391420e-03,  2.433733950704620e-06,  7.966654263470861e-09, -2.844996291811475e-11, -1.523836856911206e-14,  2.825450423398061e-16,
 -3.844255550071928e-19, -2.159837591618965e-21,  8.430837056976428e-24,  6.935558301771073e-27, -1.109503441595271e-28,  8.979877865848324e-01, -2.604214585192633e-03,
  1.922864618957488e-06,  9.917454709058587e-09, -2.598643433935997e-11, -4.499033304086163e-14,  3.103743633027009e-16, -4.259436675112131e-20, -3.245146405704922e-21,
  5.971361517029859e-24,  2.720198336773854e-26, -1.189366286942243e-28,  9.645249616836545e-01, -2.674175214580701e-03,  1.318908209488591e-06,  1.167137900820000e-08,
 -2.115445205399575e-11, -7.620518370216991e-14,  2.972146065886039e-16,  4.144889644144505e-19, -3.848058802334610e-21,  4.687827957415188e-25,  4.554516684296726e-26,
 -7.081514849376230e-29,  1.032406457882305e+00, -2.723238231276061e-03,  6.294006188568887e-07,  1.309271354092364e-08, -1.387031521418936e-11, -1.051781380288184e-13,
  2.325266798341442e-16,  9.201011019301642e-19, -3.583577991896434e-21, -7.415323508658754e-24,  5.239939888749057e-26,  3.919766090348531e-29,  1.101385177191217e+00,
 -2.748732943263975e-03, -1.331181789590106e-07,  1.403725296401376e-08, -4.291907259857205e-12, -1.273217226675395e-13,  1.125060746414077e-16,  1.365358943850164e-18,
 -2.179116151717180e-21, -1.563902096388009e-23,  3.845155316609031e-26,  1.820326540339519e-28,  1.171178593916268e+00, -2.748102427066101e-03, -9.503972885217252e-07,
  1.436232394723858e-08,  7.113466959532578e-12, -1.376382719901967e-13, -5.585216986144383e-17,  1.611640999865884e-18,  3.532472454881824e-22, -2.090410597693205e-23,
  2.887640338099003e-28,  2.880129691037811e-28,  1.241464722705566e+00, -2.719014760768165e-03, -1.797929681460251e-06,  1.394094327326044e-08,  1.951972049139788e-11,
 -1.315284911487812e-13, -2.515038109093929e-16,  1.521676038477635e-18,  3.558196101821250e-21, -1.957087050960119e-23, -5.342008131521823e-26,  2.682370565840856e-28,
  1.311878066101837e+00, -2.659504213633325e-03, -2.644715454466834e-06,  1.268022617028134e-08,  3.173247540158603e-11, -1.059309752603548e-13, -4.386199542068806e-16,
  1.009597008165635e-18,  6.487939236150198e-21, -9.449140382429181e-24, -9.944823103095220e-26,  7.031353933408429e-29,  1.382005760026216e+00, -2.568145097370312e-03,
 -3.453527705797427e-06,  1.054335095031840e-08,  4.224583204587003e-11, -6.067026678249026e-14, -5.704036103020862e-16,  1.006120381586141e-19,  7.878336544172139e-21,
  8.021478498688229e-24, -1.066502920564122e-25, -2.515782497891590e-28,  1.451384232389828e+00, -2.444258545361436e-03, -4.181917801931334e-06,  7.573086999819351e-09,
  4.939220575327351e-11,  2.835219968671271e-16, -5.991026474992071e-16, -1.022789151250911e-18,  6.622175521160173e-21,  2.648658430687670e-23, -5.416727617291423e-26,
 -5.101497693823580e-28,  1.519496807616413e+00, -2.288148258731957e-03, -4.784218392662362e-06,  3.913086900406626e-09,  5.160264538194354e-11,  6.814176669605725e-14,
 -4.921501872239885e-16, -2.023480678498005e-18,  2.461079484899928e-21,  3.606343660595546e-23,  4.553073902122290e-26, -4.719044391439393e-28,  1.585772822943052e+00,
 -2.101354740231420e-03, -5.214777258251233e-06, -1.789794052086567e-10,  4.777017995174599e-11,  1.298507513946566e-13, -2.509959273434162e-16, -2.495700840611458e-18,
 -3.427358484015478e-21,  2.841990335302887e-23,  1.375881016306113e-25, -6.019858703919778e-29,  1.649588957534154e+00, -1.886908447746853e-03, -5.432548253599712e-06,
 -4.334251295192938e-09,  3.766484540052239e-11,  1.704395523186576e-13,  7.522145890040479e-17, -2.139928982565546e-18, -8.475571046767959e-21,  3.865190912699167e-24,
  1.509519368786093e-25,  4.741742481648068e-28,  1.710273587617060e+00, -1.649550924314390e-03, -5.406940178703940e-06, -8.099846907212094e-09,  2.229035381614889e-11,
  1.772626176939128e-13,  3.921375023685709e-16, -9.694746232189096e-19, -9.825413852160468e-21, -2.488766527999327e-23,  5.788516881512299e-26,  6.628646147799020e-28,
  1.767115030502042e+00, -1.395880630119850e-03, -5.124457203353420e-06, -1.099651819743655e-08,  4.017947086404271e-12,  1.452843241227083e-13,  5.875057381196445e-16,
  5.802632782228996e-19, -6.239810521593026e-21, -3.848021376393578e-23, -8.002891532106923e-26,  2.685785903272383e-28,  1.819374473846431e+00, -1.134369782670557e-03,
 -4.595174556643760e-06, -1.260636025970150e-08, -1.367946745055421e-11,  8.133388181033045e-14,  5.809007742878418e-16,  1.783573179823352e-18,  4.303337949648991e-22,
 -2.601447198901816e-23, -1.458179053280646e-25, -3.461961907988710e-28,  1.866304142980578e+00, -8.751946331812561e-04, -3.857576950477584e-06, -1.267877756302662e-08,
 -2.699264796222310e-11,  4.481819989258688e-15,  3.745651059900548e-16,  2.022870808495508e-18,  5.901822937727123e-21,  2.455302228789354e-24, -8.148779005085184e-26,
 -5.249524123809142e-28,  1.907170787496688e+00, -6.298301277082286e-04, -2.979941518794376e-06, -1.122887546751771e-08, -3.294665758998781e-11, -5.959096663769267e-14,
  6.972141165362414e-17,  1.239967013442925e-18,  6.592223171081890e-21,  2.218686975377316e-23,  3.589192882003812e-26, -1.326559323188935e-28,  1.941283856867964e+00,
 -4.103861072108808e-04, -2.056546288385453e-06, -8.591544856424424e-09, -3.061288678791822e-11, -8.949274006717357e-14, -1.788299534774976e-16,  5.222275776932067e-20,
  2.862533947404344e-21,  1.815807217412760e-23,  7.798273614255957e-26,  2.431840480697696e-28,  1.968026855689089e+00, -2.287075845120575e-04, -1.197777361789813e-06,
 -5.395263407846419e-09, -2.179265647212015e-11, -7.944587350452827e-14, -2.567431870162555e-16, -6.919427675882877e-19, -1.228590493223527e-21,  1.260956567784377e-24,
  2.659467626308498e-26,  1.683630815843686e-28,  1.986889607167807e+00, -9.531954944763634e-05, -5.147298552161669e-07, -2.438898824668265e-09, -1.065573962430249e-11,
 -4.377029670963208e-14, -1.702448920694418e-16, -6.269024378486713e-19, -2.170453932140481e-21, -6.946387157002965e-24, -1.976778307869976e-26, -4.483419572529101e-29,
  1.997500975453996e+00, -1.833606532906369e-05, -1.007200424807541e-07, -4.906124076820871e-10, -2.233815521102451e-12, -9.729333101150298e-15, -4.102678153008460e-17,
 -1.686504790097232e-19, -6.786386934886143e-22, -2.679824156525996e-24, -1.039942842897372e-26, -3.968431444585062e-29,  3.544053056172758e-04, -1.501584365805693e-06,
  4.770817499583844e-09, -1.347174956743986e-11,  3.565422307307508e-14, -9.056970253321325e-17,  2.235844628428219e-19, -5.405744537185163e-22,  1.285729288919766e-24,
 -3.020069305427156e-27,  7.015058974810163e-30, -1.616753565103872e-32,  3.189442607273892e-03, -1.350250379302397e-05,  4.282208946124324e-08, -1.205332513259681e-10,
  3.174188173066781e-13, -8.005788843006317e-16,  1.957237702109487e-18, -4.672336083181945e-21,  1.093429265394378e-23, -2.517095989352605e-26,  5.703636241326723e-29,
 -1.275821563585919e-31,  8.858416683602502e-03, -3.744153157192200e-05,  1.183096902565516e-07, -3.308642528413760e-10,  8.625510487499889e-13, -2.143840483539238e-15,
  5.136233860086025e-18, -1.193437379887668e-20,  2.695857576203864e-23, -5.929307839086168e-26,  1.266969138018476e-28, -2.628867953591394e-31,  1.735909548308555e-02,
 -7.319249249732855e-05,  2.300028958685687e-07, -6.369193872400222e-10,  1.634764797420439e-12, -3.970844338740952e-15,  9.208473771132125e-18, -2.045138720214386e-20,
  4.340412915947340e-23, -8.752925935032223e-26,  1.650831372221057e-28, -2.835550526836028e-31,  2.868805280947254e-02, -1.205647381020096e-04,  3.760536533435497e-07,
 -1.027478942550957e-09,  2.580909022977881e-12, -6.067312731569172e-15,  1.340634934576930e-17, -2.772156289919452e-20,  5.275703589075540e-23, -8.897544233288560e-26,
  1.184239229203242e-28, -6.316236409771861e-32,  4.284057281422338e-02, -1.793014756089774e-04,  5.539945841169136e-07, -1.487771784764184e-09,  3.632525310911695e-12,
 -8.166119086007097e-15,  1.681719796667038e-17, -3.096724471948457e-20,  4.747739841180354e-23, -4.571534305425382e-26, -4.824343556063180e-29,  4.411744624335008e-31,
  5.981051966802070e-02, -2.490775267634942e-04,  7.607369482258741e-07, -1.999647536373335e-09,  4.707962806165716e-12, -9.963045137313997e-15,  1.847341181062936e-17,
 -2.756416310763188e-20,  2.176809673554845e-23,  5.076722662537508e-26, -3.306001672782815e-28,  1.132355368289678e-30,  7.959016976434008e-02, -3.294965066936888e-04,
  9.925691478654941e-07, -2.541805271377160e-09,  5.715080225112620e-12, -1.113621235228060e-14,  1.745857869631035e-17, -1.551550067435303e-20, -2.664862812346166e-23,
  1.940477339464945e-25, -6.716168382170444e-28,  1.755644281558173e-30,  1.021700030339982e-01, -4.200874123731311e-04,  1.245156546905368e-06, -3.090087984064080e-09,
  6.554567763979946e-12, -1.136891840613067e-14,  1.302471179894531e-17,  6.072097772058706e-21, -9.501658289478027e-23,  3.594482031937941e-25, -9.607613060981528e-28,
  1.938323517649131e-30,  1.275384490978840e-01, -5.203006112044111e-04,  1.513543619381564e-06, -3.617854166707802e-09,  7.123921215325467e-12, -1.037545801868816e-14,
  4.714056185284888e-18,  3.656253702112243e-20, -1.745905317852065e-22,  5.042554827110337e-25, -1.050037948667535e-27,  1.293629839419164e-30,  1.556815830376420e-01,
 -6.295032233018723e-04,  1.792159724677924e-06, -4.096439959305356e-09,  7.322094913053215e-12, -7.929296766981398e-15, -7.522872080509859e-18,  7.347456635422695e-20,
 -2.505431855252533e-22,  5.725112474749928e-25, -7.883543205777706e-28, -4.214924043840397e-31,  1.865827645018101e-01, -7.469738970063105e-04,  2.074830151279382e-06,
 -4.495727444037169e-09,  7.054847187285702e-12, -3.892683065597252e-15, -2.322342930696271e-17,  1.123429886457877e-19, -3.030088474275317e-22,  5.048933732691204e-25,
 -7.168359437399444e-29, -3.126880588343350e-30,  2.202222126678804e-01, -8.718969870482874e-04,  2.354794486784923e-06, -4.784836624936623e-09,  6.240769121368818e-12,
  1.753586147762219e-15, -4.133581141222762e-17,  1.468261133344355e-19, -3.094643872262996e-22,  2.533886708904676e-25,  1.098672753199736e-27, -6.272090669721048e-30,
  2.565765082287366e-01, -1.003356159952110e-03,  2.624734872107573e-06, -4.932960257556586e-09,  4.817951099332275e-12,  8.881997862875515e-15, -6.018369550889190e-17,
  1.691253208602101e-19, -2.485139912778127e-22, -2.006738542207875e-25,  2.563169532930978e-27, -8.792791921050630e-30,  2.956180120454063e-01, -1.140327473527308e-03,
  2.876817295089195e-06, -4.910361661531385e-09,  2.751187584524711e-12,  1.719407665813315e-14, -7.748929402309721e-17,  1.707696428648786e-19, -1.049356257989513e-22,
 -8.280607850226289e-25,  3.975185637027739e-27, -9.244829467479000e-30,  3.373141883899742e-01, -1.281672008960947e-03,  3.102749784079973e-06, -4.689555494105416e-09,
  3.954355495947285e-14,  2.620305296091742e-14, -9.047263768558384e-17,  1.437916010117810e-19,  1.244452998077700e-22, -1.536912574494572e-24,  4.818145207227749e-27,
 -6.169780214963583e-30,  3.816268187809065e-01, -1.426128178123128e-03,  3.293862182116626e-06, -4.246689508256318e-09, -3.275999966079486e-12,  3.522718441017130e-14,
 -9.604443871998066e-17,  8.227535120961171e-20,  4.248646480648140e-22, -2.167635381985602e-24,  4.489063448979241e-27,  1.307817122454377e-30,  4.285110902854949e-01,
 -1.572303889106812e-03,  3.441213115531082e-06, -3.563140608718019e-09, -7.105245199312290e-12,  4.339823217620231e-14, -9.110683661430698e-17, -1.581039852833330e-20,
  7.589553191075172e-22, -2.503988894712977e-24,  2.460152174225142e-27,  1.274356356244831e-29,  4.779145398441477e-01, -1.718668834662561e-03,  3.535730800538178e-06,
 -2.627329734928402e-09, -1.130242827218817e-11,  4.969026878395506e-14, -7.296930536176069e-17, -1.466777287833015e-19,  1.064991503596530e-21, -2.306484745869805e-24,
 -1.489010127722697e-27,  2.571348700154182e-29,  5.297758336979858e-01, -1.863547277213893e-03,  3.568395416029290e-06, -1.436745473137541e-09, -1.566165551971240e-11,
  5.297439870045734e-14, -3.987427664314234e-17, -2.989884081342260e-19,  1.260049072561954e-21, -1.371575780226931e-24, -7.007234201130667e-27,  3.557955277374612e-29,
  5.840233584535552e-01, -2.005111848100564e-03,  3.530471829014966e-06, -1.435320403598750e-13, -1.991523124755944e-11,  5.210482234321672e-14,  8.393316015897347e-18,
 -4.527729637119416e-19,  1.250120945389399e-21,  3.856507498763880e-25, -1.295488410365716e-26,  3.610941094614076e-29,  6.405735978354525e-01, -2.141379066613739e-03,
  3.413802348055082e-06,  1.660144559434230e-09, -2.373628724649191e-11,  4.604054710496521e-14,  6.986809325898615e-17, -5.795859090850870e-19,  9.486955458902399e-22,
  2.837172941825652e-24, -1.735649138881506e-26,  2.131883371416902e-29,  6.993292669871394e-01, -2.270207526617514e-03,  3.211169665025952e-06,  3.505908328458234e-09,
 -2.674743380078046e-11,  3.400436369310104e-14,  1.398333276915150e-16, -6.445789276752285e-19,  3.038796119426942e-22,  5.561285416044441e-24, -1.767045800603969e-26,
 -1.141098681388834e-29,  7.601771746388762e-01, -2.389300006285941e-03,  2.916739859550766e-06,  5.480941744153486e-09, -2.853741096978553e-11,  1.567572159712236e-14,
  2.104611644376404e-16, -6.111560076769088e-19, -6.685080056916498e-22,  7.815350107412770e-24, -1.150132203807603e-26, -5.755236399231831e-29,  8.229857831093403e-01,
 -2.496211140558376e-03,  2.526593731243081e-06,  7.509381359911973e-09, -2.868783052325885e-11, -8.593982388519261e-15,  2.708594743320667e-16, -4.486400676836808e-19,
 -1.852489726333669e-21,  8.612923574689569e-24,  2.229814739675698e-27, -1.025776309446321e-28,  8.876024377388805e-01, -2.588362764483755e-03,  2.039350993560632e-06,
  9.494877420512913e-09, -2.681190753288893e-11, -3.756718859403101e-14,  3.077616499201147e-16, -1.427998728128004e-19, -3.011866278321073e-21,  6.953395214298608e-24,
  2.187292504686276e-26, -1.226177061962965e-28,  9.538502421086580e-01, -2.663069590018659e-03,  1.456884900382795e-06,  1.132110620970822e-08, -2.260635596256324e-11,
 -6.894665142633555e-14,  3.071013738910277e-16,  2.919662272724407e-19, -3.799199766068710e-21,  2.221879969176984e-24,  4.195907263320807e-26, -9.148839946306173e-29,
  1.021524564878887e+00, -2.717578506659254e-03,  7.851132190748533e-07,  1.285427173341539e-08, -1.591605274602143e-11, -9.930153408908130e-14,  2.566468365923146e-16,
  8.015626612606129e-19, -3.812479955420339e-21, -5.295110230177422e-24,  5.335965613161720e-26,  4.672171521941367e-30,  1.090389180456556e+00, -2.749125460464082e-03,
  3.483331156103310e-08,  1.394837053004812e-08, -6.808286512202594e-12, -1.241712051809249e-13,  1.496774469989665e-16,  1.286931098931663e-18, -2.712591773741176e-21,
 -1.395030960280252e-23,  4.573975885532501e-26,  1.485213143633563e-28,  1.160172071843248e+00, -2.755014488568913e-03, -7.774575435479230e-07,  1.445405982074683e-08,
  4.350955853756884e-12, -1.384366300113011e-13, -1.068094112607554e-17,  1.610931064755382e-18, -3.960544377250289e-22, -2.064099025830723e-23,  1.280216539082621e-26,
  2.791172680791856e-28,  1.230560963528673e+00, -2.732723925559972e-03, -1.628852300049607e-06,  1.423190099093013e-08,  1.683230459626266e-11, -1.370410981901860e-13,
 -2.074115307255744e-16,  1.623876849774221e-18,  2.818128522449551e-21, -2.146058523125797e-23, -4.081093549462313e-26,  3.031841894523829e-28,  1.301198709465586e+00,
 -2.680044819861230e-03, -2.489578162690890e-06,  1.317043488939419e-08,  2.951099668677721e-11, -1.160955107689872e-13, -4.075012120920847e-16,  1.211007979413677e-18,
  6.077112173129471e-21, -1.334334273102059e-23, -9.472369577567216e-26,  1.441522631578296e-28,  1.371678740582851e+00, -2.595255844349176e-03, -3.322994342420332e-06,
  1.120883468754300e-08,  4.089590628561459e-11, -7.429742284420479e-14, -5.640195558481043e-16,  3.564953743297948e-19,  8.087835553072866e-21,  3.554225140168945e-24,
 -1.161901460831036e-25, -1.799166779545006e-28,  1.441540882038889e+00, -2.477336949612127e-03, -4.086301475209647e-06,  8.362617130526307e-09,  4.925189930802180e-11,
 -1.441378789892972e-14, -6.246338992596203e-16, -7.960853083555272e-19,  7.531288907337073e-21,  2.387196757404631e-23, -7.650019045454204e-26, -5.014224946608235e-28,
  1.510267984428411e+00, -2.326220042471437e-03, -4.732264653392779e-06,  4.748971057395122e-09,  5.284282654241990e-11,  5.566038310478712e-14, -5.475076441439867e-16,
 -1.923644260658340e-18,  3.786906557650195e-21,  3.744376360369903e-23,  2.287115477740406e-26, -5.561781178123534e-28,  1.577283972544706e+00, -2.143068360692048e-03,
 -5.212254497976996e-06,  6.057683259893682e-10,  5.030123580650978e-11,  1.229768834948832e-13, -3.222496666858324e-16, -2.587951603488854e-18, -2.306145945795520e-21,
  3.383410291536402e-23,  1.321962571200362e-25, -1.872198206208267e-28,  1.641954088373549e+00, -1.930566373397849e-03, -5.480830693130345e-06, -3.704266273078322e-09,
  4.108667854717141e-11,  1.714953747603931e-13,  1.153585071421418e-17, -2.407715576366499e-18, -8.222839147352288e-21,  1.030600728013905e-23,  1.706754223175942e-25,
  4.173562976162826e-28,  1.703588266207434e+00, -1.693188902706415e-03, -5.501879844687159e-06, -7.714337759054044e-09,  2.592733333459051e-11,  1.863118351345651e-13,
  3.604592592367781e-16, -1.297717749008172e-18, -1.067243774913656e-20, -2.196432469553302e-23,  8.886764943485985e-26,  7.431738620336317e-28,  1.761448682771269e+00,
 -1.437402801903306e-03, -5.255931315443804e-06, -1.090821434314725e-08,  7.065828863354016e-12,  1.595555656651248e-13,  6.007451604458614e-16,  3.578323733358306e-19,
 -7.679512848587373e-21, -4.140539348342787e-23, -6.521279234090190e-26,  4.082208785231286e-28,  1.814762508755843e+00, -1.171739876598055e-03, -4.747707928111859e-06,
 -1.281144382708165e-08, -1.190932426348820e-11,  9.587543074978094e-14,  6.308846271595007e-16,  1.781204637588112e-18, -6.147504573144851e-22, -3.214085152851809e-23,
 -1.601814820976081e-25, -3.022203408337884e-28,  1.862740669277471e+00, -9.066711620254944e-04, -4.012308981729068e-06, -1.310943476383051e-08, -2.680841751175451e-11,
  1.417246615215370e-14,  4.338580393175578e-16,  2.212467641360574e-18,  5.925749141625620e-21, -1.291116780336021e-24, -1.064542755520231e-25, -6.101693990923963e-28,
  1.904602921756899e+00, -6.542176972990976e-04, -3.117889905760729e-06, -1.176545338400264e-08, -3.411880517638272e-11, -5.747643873832848e-14,  1.075157824006978e-16,
  1.463962168635227e-18,  7.415187843471111e-21,  2.348377669822642e-23,  2.837332720244761e-26, -2.123531783021481e-28,  1.939608742804500e+00, -4.272593359170393e-04,
 -2.162643482556324e-06, -9.095902386364731e-09, -3.244548619865042e-11, -9.375613512283765e-14, -1.759826145191135e-16,  1.549061851087362e-19,  3.575001551275724e-21,
  2.149690047419264e-23,  8.908823411165031e-26,  2.609322777652305e-28,  1.967092442342864e+00, -2.385548266183956e-04, -1.264666154654928e-06, -5.756998710887104e-09,
 -2.344478438727333e-11, -8.584459568977975e-14, -2.766596176694638e-16, -7.303108592795192e-19, -1.162156599722000e-21,  2.484654885966093e-24,  3.489564725448422e-26,
  2.103176904602209e-28,  1.986499903754649e+00, -9.955742179750714e-05, -5.450492162798360e-07, -2.616622017795652e-09, -1.157346770946837e-11, -4.807489831669344e-14,
 -1.888092280716665e-16, -7.005145819945270e-19, -2.435237097939828e-21, -7.777087858721298e-24, -2.177864630477831e-26, -4.639046300065563e-29,  1.997425981507726e+00,
 -1.916599780661987e-05, -1.068284368157030e-07, -5.279652991115760e-10, -2.438644181385131e-12, -1.077318847528700e-14, -4.606812108914892e-17, -1.919943251608407e-19,
 -7.830407023661423e-22, -3.132934001256647e-24, -1.231343711957221e-26, -4.756657655415622e-29,  3.484742908931545e-04, -1.464054907636539e-06,  4.612520464743842e-09,
 -1.291548666042863e-11,  3.389528687898230e-14, -8.538075780158526e-17,  2.090084184454690e-19, -5.011178809947817e-22,  1.181890831885882e-24, -2.753188059133673e-27,
  6.341174383596092e-30, -1.449606124558153e-32,  3.136108705311162e-03, -1.316562753599553e-05,  4.140564241725399e-08, -1.155801344124543e-10,  3.018665806544338e-13,
 -7.551363677835936e-16,  1.831177706486987e-18, -4.336507617672461e-21,  1.006788671903962e-23, -2.299791923605527e-26,  5.170853117241430e-29, -1.148296697589463e-31,
  8.710518693653184e-03, -3.651070413580111e-05,  1.144207305775983e-07, -3.173998647761303e-10,  8.208803636037135e-13, -2.024485276191372e-15,  4.813834786021746e-18,
 -1.110489627647019e-20,  2.491252520353105e-23, -5.444931295663556e-26,  1.156659149141223e-28, -2.389163673353131e-31,  1.706995777344592e-02, -7.138260276356710e-05,
  2.225142182563059e-07, -6.113866696360482e-10,  1.557512359549616e-12, -3.756558551609611e-15,  8.654815217496993e-18, -1.911162154248588e-20,  4.036898081292240e-23,
 -8.116977030650279e-26,  1.530304626288058e-28, -2.644509303972941e-31,  2.821173360617003e-02, -1.176049349672826e-04,  3.639677247882476e-07, -9.871379468555161e-10,
  2.462718393167488e-12, -5.754686950095830e-15,  1.265330568681647e-17, -2.608367907752112e-20,  4.963847487992404e-23, -8.429846275418704e-26,  1.153235481881970e-28,
 -7.711143890443976e-32,  4.213211913318022e-02, -1.749399562063031e-04,  5.364847257287110e-07, -1.430936320956288e-09,  3.473169703751617e-12, -7.772741183835915e-15,
  1.597113513547447e-17, -2.947463583665646e-20,  4.580138325879447e-23, -4.727928361326954e-26, -3.048873001507756e-29,  3.676757294004861e-31,  5.882623116701292e-02,
 -2.430863486821687e-04,  7.371866439271423e-07, -1.925890390341590e-09,  4.513073420375668e-12, -9.528864499386347e-15,  1.771162445894404e-17, -2.684079939656117e-20,
  2.336930895406134e-23,  3.849782622094461e-26, -2.838766147928700e-28,  9.941007409400691e-31,  7.828787383918981e-02, -3.216764224418435e-04,  9.626088557478771e-07,
 -2.452123165125448e-09,  5.496510376516812e-12, -1.072250976011812e-14,  1.701322017267540e-17, -1.626152212008184e-20, -2.012832079435341e-23,  1.686772779213982e-25,
 -5.981376508186458e-28,  1.586528080518055e-30,  1.005093435368794e-01, -4.102727185488397e-04,  1.208697281275572e-06, -2.987016890785670e-09,  6.330327372322633e-12,
 -1.105461698246948e-14,  1.315405651663058e-17,  3.231356914730054e-21, -8.274796328522244e-23,  3.226881277808621e-25, -8.781211201236486e-28,  1.817726088849114e-30,
  1.254811911089055e-01, -5.083639972718660e-04,  1.470806438851808e-06, -3.505525016487139e-09,  6.917623159654396e-12, -1.025065049065665e-14,  5.662262549354646e-18,
  3.125809706528176e-20, -1.571795156736796e-22,  4.634060223670591e-25, -9.921519936763990e-28,  1.332598901844386e-30,  1.531919361663105e-01, -6.153605951255368e-04,
  1.743700103037946e-06, -3.980564254584134e-09,  7.161865526598065e-12, -8.086045381147580e-15, -5.574772711812554e-18,  6.578083422833467e-20, -2.305040030481984e-22,
  5.406999417998609e-25, -8.000048898544056e-28, -1.184554343106999e-31,  1.836277272219384e-01, -7.305891379033510e-04,  2.021556022889608e-06, -4.383501951675362e-09,
  6.971669105384804e-12, -4.413377036239878e-15, -2.021084655466626e-17,  1.029367127741055e-19, -2.849157631616644e-22,  4.994590468527842e-25, -1.956150414851281e-28,
 -2.520217162138982e-30,  2.167719401834290e-01, -8.532866035006919e-04,  2.297976547656742e-06, -4.684756269346262e-09,  6.266247504769162e-12,  8.097499435978808e-16,
 -3.736189152711340e-17,  1.370771616536416e-19, -2.996156016842188e-22,  2.920631516153704e-25,  8.410358050103217e-28, -5.450434991545838e-30,  2.526047063091625e-01,
 -9.825937395862255e-04,  2.566007484585285e-06, -4.854528806021113e-09,  4.981525875856445e-12,  7.493510665635091e-15, -5.556047007840619e-17,  1.610763296659318e-19,
 -2.539839166794478e-22, -1.056552427040806e-25,  2.193430920684501e-27, -8.014575011348819e-30,  2.911023591306281e-01, -1.117547858716776e-03,  2.818168094359627e-06,
 -4.863691035394924e-09,  3.076856918681774e-12,  1.539130628731733e-14, -7.275902243805921e-17,  1.669646375936441e-19, -1.319809450236262e-22, -6.771028536975474e-25,
  3.575044918102268e-27, -8.924895992471749e-30,  3.322367880111966e-01, -1.257075059527194e-03,  3.046495829948910e-06, -4.684846908721679e-09,  5.422194139738779e-13,
  2.408042382121703e-14, -8.639877707927098e-17,  1.469252417962119e-19,  7.251824559553288e-23, -1.349814728990658e-24,  4.532300810177793e-27, -6.780911121628772e-30,
  3.759746839265164e-01, -1.399981960098953e-03,  3.242610258475500e-06, -4.293593590165946e-09, -2.594312704257031e-12,  3.295122784639290e-14, -9.356187321004785e-17,
  9.465719491891648e-20,  3.500704477061732e-22, -1.987501112996415e-24,  4.503972116345899e-27, -5.706239347894139e-31,  4.222766606978128e-01, -1.544947082365571e-03,
  3.397801582390574e-06, -3.669999720273989e-09, -6.259168222098197e-12,  4.120901759843692e-14, -9.122292589588215e-17,  7.053906983799739e-21,  6.707096345317169e-22,
 -2.395300201554996e-24,  2.951827858890650e-27,  9.660736924909151e-30,  4.710962322799062e-01, -1.690512099441664e-03,  3.503150294309212e-06, -2.800314624326234e-09,
 -1.032644861922135e-11,  4.789349566741257e-14, -7.661171771961466e-17, -1.139358815951062e-19,  9.811489688915227e-22, -2.344477251948984e-24, -4.366815068596923e-28,
  2.213583457066762e-29,  5.223786238147733e-01, -1.835073257469200e-03,  3.549685738514680e-06, -1.678910818716186e-09, -1.461239213041810e-11,  5.192146481019712e-14,
 -4.768924121300789e-17, -2.595079432671854e-19,  1.205997683012354e-21, -1.621300750862431e-24, -5.498153926534216e-27,  3.295399198191831e-29,  5.760593910565419e-01,
 -1.976873418051512e-03,  3.528592657485367e-06, -3.104437444832645e-10, -1.887212389000958e-11,  5.215865997891655e-14, -3.722880627146794e-18, -4.126438522739760e-19,
  1.255061250329197e-21, -1.006185427829416e-25, -1.135661945586248e-26,  3.638125451216646e-29,  6.320628195557965e-01, -2.113995346614161e-03,  3.431476066151473e-06,
  1.287816104243221e-09, -2.280000435044115e-11,  4.752616059320422e-14,  5.407911398175528e-17, -5.477255028375204e-19,  1.038577421331561e-21,  2.163220080324894e-24,
 -1.630538735910797e-26,  2.623053296357286e-29,  6.903000718429282e-01, -2.244357108158610e-03,  3.250695828144465e-06,  3.083566314194807e-09, -2.603524198720027e-11,
  3.714506395915299e-14,  1.219503760886377e-16, -6.317886951765784e-19,  4.912698200557545e-22,  4.847446343376996e-24, -1.794897050988211e-26, -1.455320249760108e-30,
  7.506670480783167e-01, -2.365710738800526e-03,  2.979782787996839e-06,  5.027119867052463e-09, -2.817478336204154e-11,  2.051928047699703e-14,  1.930909407061830e-16,
 -6.281401384631684e-19, -3.960120992870138e-22,  7.308442177258000e-24, -1.375060533500464e-26, -4.472541468801627e-29,  8.130419237293051e-01, -2.475645754282872e-03,
  2.613947735961712e-06,  7.049349847216617e-09, -2.879575481487886e-11, -2.250509769842309e-15,  2.575143226211234e-16, -5.029501368781006e-19, -1.541880408518267e-21,
  8.614765053363331e-24, -2.062460701775649e-27, -9.225079529639277e-29,  8.772823275397444e-01, -2.571599549760239e-03,  2.150692080944754e-06,  9.060275918627724e-09,
 -2.748976766200008e-11, -3.023954358849911e-14,  3.024527118352860e-16, -2.350161493651126e-19, -2.747098096202217e-21,  7.720208308670599e-24,  1.646955510007598e-26,
 -1.223737616041890e-28,  9.432221254953446e-01, -2.650877348830701e-03,  1.590523764135082e-06,  1.094877604368693e-08, -2.391099312623404e-11, -6.149177041807027e-14,
  3.135886738526409e-16,  1.719873753752640e-19, -3.690018850028656e-21,  3.814618516870274e-24,  3.755944478990564e-26, -1.077429311959601e-28,  1.010667783280426e+00,
 -2.710685073756948e-03,  9.377721041245110e-07,  1.258406869224043e-08, -1.783874218432966e-11, -9.288663229398098e-14,  2.773568793016478e-16,  6.769250698905158e-19,
 -3.964724678107289e-21, -3.166381115286899e-24,  5.283944077436630e-26, -2.789963580234925e-29,  1.079394293162295e+00, -2.748179311452159e-03,  2.014788746966791e-07,
  1.381977780171205e-08, -9.252921883930789e-12, -1.201567974493499e-13,  1.844233660032052e-16,  1.192458039813638e-18, -3.180392584310643e-21, -1.200074002822148e-23,
  5.146816050544157e-26,  1.113999888417413e-28,  1.149140674470141e+00, -2.760539381024071e-03, -6.036825054067006e-07,  1.450152662720223e-08,  1.583303119021207e-12,
 -1.381538143719614e-13,  3.413682969493764e-17,  1.586490693007267e-18, -1.126995242532228e-21, -1.988807841813623e-23,  2.470788879092843e-26,  2.605244183100132e-28,
  1.219605094000963e+00, -2.745067244308150e-03, -1.456544867486855e-06,  1.447903645752000e-08,  1.404543641476056e-11, -1.414638864271857e-13, -1.607986947330322e-16,
  1.701407184659323e-18,  2.019451582342057e-21, -2.281836332026021e-23, -2.690451053457235e-26,  3.269833343405003e-28,  1.290439708983879e+00, -2.699321417155672e-03,
 -2.328778200218911e-06,  1.362351609128924e-08,  2.709414433801389e-11, -1.254471360072897e-13, -3.709477920800873e-16,  1.397072211262509e-18,  5.530271938612551e-21,
 -1.698435215570118e-23, -8.681371006007976e-26,  2.145424170422386e-28,  1.361245416716552e+00, -2.621290769028493e-03, -3.184613727341638e-06,  1.185055004015151e-08,
  3.927555319605258e-11, -8.768477832464796e-14, -5.504015774682634e-16,  6.164422802339574e-19,  8.130437815169314e-21, -1.227957394275671e-24, -1.223127888913762e-25,
 -9.674042004886833e-29,  1.431566807852873e+00, -2.509612586511385e-03, -3.981234058369916e-06,  9.147519711963326e-09,  4.881204992682094e-11, -2.964448110275073e-14,
 -6.434255338932199e-16, -5.419671307124237e-19,  8.330347559604035e-21,  2.037817081408477e-23, -9.796432167532807e-26, -4.704771764316088e-28,  1.500887769343108e+00,
 -2.363835755963570e-03, -4.670169715585262e-06,  5.602629942673737e-09,  5.382034561895911e-11,  4.188879925991105e-14, -5.994695286253088e-16, -1.780768272630431e-18,
  5.145250873940634e-21,  3.784736256632765e-23, -3.200949258598304e-27, -6.260756745836563e-28,  1.568628368626895e+00, -2.184723453788188e-03, -5.200076623513970e-06,
  1.429819414127552e-09,  5.267752589226758e-11,  1.143661622337617e-13, -3.955551837732980e-16, -2.641257778616967e-18, -9.952867136770101e-22,  3.891702532363504e-23,
  1.209382121204607e-25, -3.260281202048757e-28,  1.634143864185574e+00, -1.974579387492688e-03, -5.521224395498714e-06, -3.019448565150157e-09,  4.451374190831628e-11,
  1.709338997487949e-13, -5.949864590933275e-17, -2.663558005773518e-18, -7.724722120554234e-21,  1.747664531189063e-23,  1.872126946666160e-25,  3.289372073599474e-28,
  1.696726904562657e+00, -1.737566891258067e-03, -5.591838420852121e-06, -7.269233550887387e-09,  2.973693458322978e-11,  1.944875281711332e-13,  3.192283070169358e-16,
 -1.651135963686756e-18, -1.139110334051640e-20, -1.773562005255234e-23,  1.230251565669874e-25,  8.058643283150271e-28,  1.755614150677775e+00, -1.479971677181083e-03,
 -5.386043715703368e-06, -1.076884592998033e-08,  1.040178115702512e-11,  1.740645176859645e-13,  6.070965865301172e-16,  8.777283865042024e-20, -9.212320299745771e-21,
 -4.360926135719787e-23, -4.382503222308831e-26,  5.668180916558460e-28,  1.809998607878659e+00, -1.210339577503364e-03, -4.902522560319521e-06, -1.298581336987977e-08,
 -9.836379754217426e-12,  1.116118096537628e-13,  6.803000409167154e-16,  1.741757999236653e-18, -1.890183765575894e-21, -3.879463509148812e-23, -1.719682224446667e-25,
 -2.280521756261013e-28,  1.859048781107348e+00, -9.394061533136273e-04, -4.172184562055219e-06, -1.353551465120246e-08, -2.641571393579158e-11,  2.534980207411195e-14,
  4.984487105598980e-16,  2.400472083110551e-18,  5.795922543420097e-21, -6.111365651471357e-24, -1.351755371630200e-25, -6.948449355566207e-28,  1.901935257339184e+00,
 -6.797349250047498e-04, -3.262388192704754e-06, -1.232039586704315e-08, -3.523906798029301e-11, -5.437656683991424e-14,  1.519572692246193e-16,  1.714973951563308e-18,
  8.278528009128876e-21,  2.440375827001486e-23,  1.689025166326239e-26, -3.133875994652504e-28,  1.937864399227708e+00, -4.450060562562329e-04, -2.274971695657741e-06,
 -9.630258911806412e-09, -3.436242346596159e-11, -9.791400196470679e-14, -1.699222646685320e-16,  2.823989219622523e-19,  4.415838607747241e-21,  2.529415188872974e-23,
  1.008637535269130e-25,  2.731548459049454e-28,  1.966117541668189e+00, -2.489550016375771e-04, -1.336058683706473e-06, -6.146218187543247e-09, -2.522975228543112e-11,
 -9.273392057616244e-14, -2.976134913165724e-16, -7.657803717673291e-19, -1.045225026377767e-21,  4.079853579337032e-24,  4.523520242549416e-26,  2.612687944225095e-28,
  1.986092749874116e+00, -1.040466360750185e-04, -5.775922789670749e-07, -2.809742522809669e-09, -1.258191528731604e-11, -5.285076331455113e-14, -2.095579340731726e-16,
 -7.830939081007478e-19, -2.731386608825179e-21, -8.689232516423365e-24, -2.383001004521344e-26, -4.657451808643735e-29,  1.997347567177616e+00, -2.004664772154185e-05,
 -1.134054402623605e-07, -5.687692690959750e-10, -2.665614831491261e-12, -1.194627266664552e-14, -5.181242208288700e-17, -2.189555091529631e-19, -9.052205859694187e-22,
 -3.670012114293701e-24, -1.461011667558884e-26, -5.713534697592324e-29,  3.426909028599472e-04, -1.427765595791667e-06,  4.460733091057982e-09, -1.238655513954457e-11,
  3.223671891284636e-14, -8.052874751188003e-17,  1.954920465427818e-19, -4.648354772296059e-22,  1.087192112476633e-24, -2.511847487306795e-27,  5.736676899462746e-30,
 -1.300976478755570e-32,  3.084100015778410e-03, -1.283984926789523e-05,  4.004716922969363e-08, -1.108687437233345e-10,  2.871936857026150e-13, -7.126095148807301e-16,
  1.714144231526358e-18, -4.027192528866281e-21,  9.276005665897708e-24, -2.102718144332243e-26,  4.691132219535724e-29, -1.034363633269976e-31,  8.566282797621231e-03,
 -3.561035324218384e-05,  1.106894206035375e-07, -3.045835234828898e-10,  7.815212505178485e-13, -1.912596182563656e-15,  4.513770070991841e-18, -1.033818550075297e-20,
  2.303315578718165e-23, -5.002637958817505e-26,  1.056387442822989e-28, -2.172208438735077e-31,  1.678794171514474e-02, -6.963141757183553e-05,  2.153246561456015e-07,
 -5.870564147230290e-10,  1.484415742121906e-12, -3.555121175344480e-15,  8.137344119488375e-18, -1.786540898362334e-20,  3.755429614806224e-23, -7.527586038714085e-26,
  1.417970850328193e-28, -2.463206967787461e-31,  2.774706326169857e-02, -1.147399145721679e-04,  3.523547450751091e-07, -9.486389476891802e-10,  2.350603205606227e-12,
 -5.459595009499041e-15,  1.194475079408602e-17, -2.454292033592060e-20,  4.668591514759426e-23, -7.975666333709567e-26,  1.116911058798145e-28, -8.746264718636973e-32,
  4.144083563109562e-02, -1.707158303223601e-04,  5.196418508621236e-07, -1.376588695564555e-09,  3.321481953267645e-12, -7.399173380775184e-15,  1.516610697567927e-17,
 -2.803642933811875e-20,  4.408109897815560e-23, -4.819458090664596e-26, -1.573634761894078e-29,  3.044670600963000e-31,  5.786553610502924e-02, -2.372800850486011e-04,
  7.145029993602427e-07, -1.855182991965636e-09,  4.326686487206252e-12, -9.112718313231559e-15,  1.697074473636925e-17, -2.607291498310914e-20,  2.456103996250432e-23,
  2.798032640808551e-26, -2.428936519448007e-28,  8.711549751567731e-31,  7.701638561910654e-02, -3.140917746118166e-04,  9.337040373439244e-07, -2.365872571472590e-09,
  5.286106120084966e-12, -1.031972368229539e-14,  1.654976080248410e-17, -1.681295417467917e-20, -1.447020249661097e-23,  1.461010796677644e-25, -5.318079044545112e-28,
  1.430596342351170e-30,  9.888736721473357e-02, -4.007448119517928e-04,  1.173453549600803e-06, -2.887483213141623e-09,  6.112397833239822e-12, -1.073812261141871e-14,
  1.320916237463198e-17,  7.626656577494907e-22, -7.174448815424071e-23,  2.891271417910315e-25, -8.008122767071811e-28,  1.696371926120143e-30,  1.234710042388256e-01,
 -4.967639448999250e-04,  1.429397489754258e-06, -3.396475478874451e-09,  6.714037113270861e-12, -1.010480668624427e-14,  6.469526855550798e-18,  2.648773005949677e-20,
 -1.411970660522539e-22,  4.248979194161606e-25, -9.331663862616778e-28,  1.344599491662075e-30,  1.507580931984697e-01, -6.016001256929995e-04,  1.696615512411189e-06,
 -3.867274831457123e-09,  6.998951632315813e-12, -8.198553303536707e-15, -3.833292947198355e-18,  5.870996768643719e-20, -2.116153663570109e-22,  5.086714223886651e-25,
 -7.996414769733139e-28,  1.260132182389419e-31,  1.807373850886096e-01, -7.146252083946867e-04,  1.969620284137593e-06, -4.272686779624688e-09,  6.878779167733908e-12,
 -4.864864318635256e-15, -1.745356976155415e-17,  9.410537943104842e-20, -2.671013332623893e-22,  4.895771549381936e-25, -2.946468182996987e-28, -1.993866672465120e-30,
  2.133952077601832e-01, -8.351259540803552e-04,  2.242361412322383e-06, -4.584414183576137e-09,  6.273780983496070e-12, -4.195100079413276e-17, -3.365633450379092e-17,
  1.276637281111296e-19, -2.885515119761439e-22,  3.211341869031547e-25,  6.179795891462936e-28, -4.700268985285471e-30,  2.487150204537209e-01, -9.622973311902202e-04,
  2.508236080576782e-06, -4.773696364269609e-09,  5.118422138251250e-12,  6.213259698738679e-15, -5.116457265046571e-17,  1.529042440130745e-19, -2.562911572893878e-22,
 -2.474436855540142e-26,  1.857681797052475e-27, -7.250146259586642e-30,  2.866768899563424e-01, -1.095235111440289e-03,  2.760109035448925e-06, -4.812092012817015e-09,
  3.367596996336744e-12,  1.370069106863639e-14, -6.814661217428340e-17,  1.623780742018046e-19, -1.538762044306597e-22, -5.418383666336846e-25,  3.191216164618508e-27,
 -8.508400932283555e-30,  3.272568759135578e-01, -1.232927782178306e-03,  2.990345252071225e-06, -4.672429791408820e-09,  1.003426579542995e-12,  2.205643861465021e-14,
 -8.225944129361939e-17,  1.485027302758531e-19,  2.711508926888406e-23, -1.174616121251418e-24,  4.224900595847978e-27, -7.156215407911932e-30,  3.704263106059686e-01,
 -1.374247826878759e-03,  3.190859436494150e-06, -4.329951478585107e-09, -1.957522048290784e-12,  3.073874869072500e-14, -9.076514907628862e-17,  1.047493412496134e-19,
  2.817528468269932e-22, -1.808319565572683e-24,  4.443944314030951e-27, -2.103537120016225e-30,  4.161509559517794e-01, -1.517942470321402e-03,  3.353187518510255e-06,
 -3.763671813932541e-09, -5.456853174941993e-12,  3.902438393283763e-14, -9.073773491228119e-17,  2.716049163814711e-20,  5.866989642530335e-22, -2.269557851993727e-24,
  3.315309935053705e-27,  6.917532362866632e-30,  4.643900175927355e-01, -1.662624048839253e-03,  3.468586463036871e-06, -2.957975766446426e-09, -9.387205920220663e-12,
  4.602000175941098e-14, -7.937506928091272e-17, -8.389106117391294e-20,  8.966587469472021e-22, -2.343490566371240e-24,  4.609271098238810e-28,  1.869211020615614e-29,
  5.150949926518590e-01, -1.806760255346387e-03,  3.528170079209997e-06, -1.904466237967043e-09, -1.358597451259542e-11,  5.069403386058853e-14, -5.442423757982647e-17,
 -2.218895464016284e-19,  1.144013976612800e-21, -1.813071453244994e-24, -4.111709943764978e-27,  3.002757557298794e-29,  5.682083241306983e-01, -1.948664632078612e-03,
  3.523090007110971e-06, -6.040610425563617e-10, -1.783075662882317e-11,  5.193519440691676e-14, -1.471579255938058e-17, -3.726243965399597e-19,  1.243647020442767e-21,
 -5.229873782499055e-25, -9.766234329222748e-27,  3.577805241080241e-29,  6.236618310010088e-01, -2.086487851840816e-03,  3.444772640598055e-06,  9.306855935924125e-10,
 -2.183772469458178e-11,  4.864384656991658e-14,  3.921890590931409e-17, -5.133685602757643e-19,  1.105002214239640e-21,  1.535233204980925e-24, -1.506793540712055e-26,
  2.980496258231006e-29,  6.813748789727548e-01, -2.218210554472257e-03,  3.285224255191891e-06,  2.673098695271528e-09, -2.526449566746369e-11,  3.986152470663648e-14,
  1.045056280352748e-16, -6.134144630296563e-19,  6.528634438555513e-22,  4.130850836261618e-24, -1.781778628031576e-26,  7.196128326158916e-30,  7.412522529328607e-01,
 -2.341638805488617e-03,  3.037417789145478e-06,  4.579852206141124e-09, -2.771948693172701e-11,  2.494121520920751e-14,  1.753643786616229e-16, -6.367126449318285e-19,
 -1.432491665281502e-22,  6.722755155072654e-24, -1.544330325709573e-26, -3.231286837028668e-29,  8.031816885671762e-01, -2.454403637311101e-03,  2.695775130753918e-06,
  6.588588602560971e-09, -2.878012986508822e-11,  3.755553086891854e-15,  2.427874209508733e-16, -5.473518671795454e-19, -1.234181574255019e-21,  8.454451532063774e-24,
 -5.867854684144347e-27, -8.053955065391393e-29,  8.670310183815110e-01, -2.553966640498939e-03,  2.256757687198027e-06,  8.615993294660217e-09, -2.802255313185442e-11,
 -2.306931634656547e-14,  2.946841871827981e-16, -3.183597883069723e-19, -2.458602713493704e-21,  8.272167722002425e-24,  1.115580420654820e-26, -1.186214553815162e-28,
  9.326448872855317e-01, -2.637634212061262e-03,  1.719574365248886e-06,  1.055677178901790e-08, -2.506524556911705e-11, -5.392106057339827e-14,  3.167738490511037e-16,
  5.638444688191994e-20, -3.526827147087667e-21,  5.218419930824656e-24,  3.254586686105459e-26, -1.193805898822898e-28,  9.998409966950609e-01, -2.702583852571569e-03,
  1.087008292544456e-06,  1.228415481468604e-08, -1.962844839995337e-11, -8.601704762355046e-14,  2.945203398636358e-16,  5.486350239909490e-19, -4.041047718447257e-21,
 -1.086298683690618e-24,  5.094956067152136e-26, -5.742158715358665e-29,  1.068405846089714e+00, -2.745906828935250e-03,  3.663494338436191e-07,  1.365275759237240e-08,
 -1.160915280693176e-11, -1.153418558256402e-13,  2.163253122269704e-16,  1.084179291203436e-18, -3.574284642430349e-21, -9.855398818863354e-24,  5.551406928335970e-26,
  7.231917281756294e-29,  1.138089960473565e+00, -2.764672546760704e-03, -4.296031850314118e-07,  1.450481440290555e-08, -1.168006010406147e-12, -1.368061989914236e-13,
  7.794752862135004e-17,  1.539184045050593e-18, -1.822480454574179e-21, -1.867794007537857e-23,  3.560029906357424e-26,  2.332616224264787e-28,  1.208602625820958e+00,
 -2.756021005445859e-03, -1.281542068927611e-06,  1.468093585581575e-08,  1.118146028475389e-11, -1.447448457036597e-13, -1.123793886867720e-16,  1.752706972856631e-18,
  1.182127562981138e-21, -2.360247399149381e-23, -1.221641135738705e-26,  3.385939300264508e-28,  1.279606208400155e+00, -2.717290538132632e-03, -2.162779294069760e-06,
  1.403648079545343e-08,  2.449944357409370e-11, -1.338610577408329e-13, -3.294487931812790e-16,  1.563607356322783e-18,  4.858781331532869e-21, -2.024878299333948e-23,
 -7.594429617408928e-26,  2.781366603769055e-28,  1.350710215362860e+00, -2.646188307407414e-03, -3.038696853296581e-06,  1.246421799970766e-08,  3.739131098681835e-11,
 -1.006579666978961e-13, -5.295121757940331e-16,  8.749579778458026e-19,  7.997379972745438e-21, -6.179181462295232e-24, -1.245827531340481e-25, -5.409622977478682e-30,
  1.421465371650916e+00, -2.541010151688687e-03, -3.866800160995019e-06,  9.922925757739621e-09,  4.806366744755444e-11, -4.523802250259581e-14, -6.547639536973773e-16,
 -2.644541425372615e-19,  8.988564421319990e-21,  1.605973261845952e-23, -1.175666926930483e-25, -4.168202190795630e-28,  1.491358150148139e+00, -2.400913489807477e-03,
 -4.597746334125942e-06,  6.469659370112431e-09,  5.451031162410457e-11,  2.692305437861772e-14, -6.468216311955608e-16, -1.594399765092179e-18,  6.498660891790806e-21,
  3.715205423253944e-23, -3.192857376486593e-26, -6.759851444131808e-28,  1.559806402705027e+00, -2.226240936796997e-03, -5.177788006040240e-06,  2.290417417778725e-09,
  5.486391253284154e-11,  1.039831034271790e-13, -4.697391896041329e-16, -2.649787696992817e-18,  4.889586973673350e-22,  4.342522219796511e-23,  1.034156176817442e-25,
 -4.709042701921918e-28,  1.626156995002222e+00, -2.018881749262455e-03, -5.553071964482705e-06, -2.279982708545613e-09,  4.791195757638425e-11,  1.685836778425107e-13,
 -1.374339033513393e-16, -2.899210925706631e-18, -6.957581359520221e-21,  2.522123275083376e-23,  1.991302569485954e-25,  2.072346830704515e-28,  1.689686626933185e+00,
 -1.782642135144649e-03, -5.676084812302894e-06, -6.761924786418261e-09,  3.369933991278516e-11,  2.015524813570462e-13,  2.678044776381685e-16, -2.024847060491429e-18,
 -1.193234024088830e-20, -1.209247253643612e-23,  1.594003473824794e-25,  8.425356477084839e-28,  1.749607273186899e+00, -1.523573832503835e-03, -5.514153848114743e-06,
 -1.057377523709499e-08,  1.402879540475751e-11,  1.886295542345882e-13,  6.051889782578595e-16, -2.324269067237111e-19, -1.080734191019138e-20, -4.481327303641537e-23,
 -1.511043341318459e-26,  7.404174618523677e-28,  1.805077818739725e+00, -1.250185577027751e-03, -5.059220030859162e-06, -1.312443400357709e-08, -7.436962218366762e-12,
  1.285160680350517e-13,  7.280029355932591e-16,  1.657580910462979e-18, -3.412760678194212e-21, -4.584436633297905e-23, -1.797141717058995e-25, -1.175469581184128e-28,
  1.855223362754614e+00, -9.734404767179835e-04, -4.337127746748437e-06, -1.395343690215258e-08, -2.578353862227230e-11,  3.813984569808826e-14,  5.682176339830192e-16,
  2.581316666519693e-18,  5.471001216754977e-21, -1.215363459276976e-23, -1.675105119186001e-25, -7.733416580728295e-28,  1.899163169438946e+00, -7.064350758562160e-04,
 -3.413651094372832e-06, -1.289270617758700e-08, -3.628608184297020e-11, -5.012261025068262e-14,  2.038181568859156e-16,  1.994044770726545e-18,  9.165585137805338e-21,
  2.476852293382989e-23,  4.341553490845900e-28, -4.389011250169595e-28,  1.936047230162689e+00, -4.636775790827563e-04, -2.393898928183700e-06, -1.019594251944149e-08,
 -3.636075817113755e-11, -1.018804127982882e-13, -1.598942189025572e-16,  4.390774847489061e-19,  5.401963753819272e-21,  2.957082620705335e-23,  1.129941941683755e-25,
  2.764090710598913e-28,  1.965099867732832e+00, -2.599454955862570e-04, -1.412297839762481e-06, -6.565127095757174e-09, -2.715761363470454e-11, -1.001375773333965e-13,
 -3.194988974017501e-16, -7.965048565703265e-19, -8.628545578073331e-22,  6.136456621228805e-24,  5.804259136182768e-26,  3.227561706243594e-28,  1.985667103373270e+00,
 -1.088057463750901e-04, -6.125528405906803e-07, -3.019790189597149e-09, -1.369105280973118e-11, -5.815344569422824e-14, -2.327565855555655e-16, -8.756912340775394e-19,
 -3.061847301328128e-21, -9.683037647451604e-24, -2.584643855916147e-26, -4.466296762922523e-29,  1.997265521825119e+00, -2.098193582367425e-05, -1.204946797516955e-07,
 -6.134002183753759e-10, -2.917489307113948e-12, -1.326673936241801e-14, -5.836941082878960e-17, -2.501543943851921e-19, -1.048495576533731e-21, -4.307956879397973e-24,
 -1.737184842516210e-26, -6.877589130817672e-29,  3.370502830476272e-04, -1.392665638091530e-06,  4.315136819260785e-09, -1.188340167047233e-11,  3.067202777547903e-14,
 -7.598927382652521e-17,  1.829504305089670e-19, -4.314489621182792e-22,  1.000761721783500e-24, -2.293428483719870e-27,  5.193905116783242e-30, -1.168701552901238e-32,
  3.033373056262351e-03, -1.252471656590604e-05,  3.874385171378455e-08, -1.063854647746409e-10,  2.733439267762474e-13, -6.727903346945475e-16,  1.605427223505463e-18,
 -3.742118564789501e-21,  8.551734647962840e-24, -1.923867171276766e-26,  4.258833406670247e-29, -9.325075810001448e-32,  8.425589563353268e-03, -3.473924818209073e-05,
  1.071082008491212e-07, -2.923794098497515e-10,  7.443296081657055e-13, -1.807657678673411e-15,  4.234354695833614e-18, -9.629142516753577e-21,  2.130601678718712e-23,
 -4.598606200623950e-26,  9.652012956433526e-29, -1.975846067623859e-31,  1.651281718604521e-02, -6.793660060517476e-05,  2.084201706134318e-07, -5.638641388076505e-10,
  1.415226453786026e-12, -3.365694362918696e-15,  7.653537282904756e-18, -1.670595662077735e-20,  3.494389379135852e-23, -6.981562450021134e-26,  1.313394625504269e-28,
 -2.291922469181388e-31,  2.729367007458775e-02, -1.119659801155205e-04,  3.411931821013256e-07, -9.118874862910428e-10,  2.244223243583419e-12, -5.181001217791792e-15,
  1.127803877476299e-17, -2.309405630715347e-20,  4.389414345710643e-23, -7.536835833237028e-26,  1.076703221072324e-28, -9.486109863283607e-32,  4.076618321946050e-02,
 -1.666238794493287e-04,  5.034368286676422e-07, -1.324609339509337e-09,  3.177075581675406e-12, -7.044449263220303e-15,  1.440057373817165e-17, -2.665369053465845e-20,
  4.233784039850977e-23, -4.857268438417386e-26, -3.563989539744954e-30,  2.501922848135421e-31,  5.692770846228255e-02, -2.316519466873905e-04,  6.926502219754283e-07,
 -1.787392159854348e-09,  4.148446429015189e-12, -8.714091260756152e-15,  1.625184494780732e-17, -2.527264719895651e-20,  2.540238306005411e-23,  1.899811221376214e-26,
 -2.070120964242614e-28,  7.619736619408511e-31,  7.577477998830101e-02, -3.067342819221999e-04,  9.058142911228689e-07, -2.282924609392187e-09,  5.083645206930594e-12,
 -9.928226183767064e-15,  1.607327756355161e-17, -1.719583146193331e-20, -9.578689012118759e-24,  1.260446221535631e-25, -4.720583244561184e-28,  1.287334142129448e-30,
  9.730294610077837e-02, -3.914941363870274e-04,  1.139383509878541e-06, -2.791385719965682e-09,  5.900806008964662e-12, -1.042109648676536e-14,  1.319989699688348e-17,
 -1.372659130728715e-21, -6.189483098026742e-23,  2.585519648326311e-25, -7.288212982556897e-28,  1.576296334386385e-30,  1.215065632449363e-01, -4.854899848900632e-04,
  1.389277690392783e-06, -3.290658974712922e-09,  6.513551160520414e-12, -9.941134853894343e-15,  7.150175867700071e-18,  2.220707676859992e-20, -1.265583727863899e-22,
  3.887531159063731e-25, -8.741432246233719e-28,  1.335139704004188e-30,  1.483785473021390e-01, -5.882109395623329e-04,  1.650874688047887e-06, -3.756607827116066e-09,
  6.834189846475786e-12, -8.271574286215613e-15, -2.281508537602117e-18,  5.222511200408517e-20, -1.938770436216373e-22,  4.768571687579993e-25, -7.896587707627609e-28,
  3.200557476131299e-31,  1.779100760869029e-01, -6.990714715971567e-04,  1.919005123454363e-06, -4.163426571972499e-09,  6.777501532826603e-12, -5.253080223968451e-15,
 -1.493564811312648e-17,  8.583769532182093e-20, -2.497085743022812e-22,  4.761751676747347e-25, -3.721514354555280e-28, -1.540510947535304e-30,  2.100902357196769e-01,
 -8.174054085371041e-04,  2.187950558517768e-06, -4.484083091135435e-09,  6.265148638003587e-12, -8.078405755192742e-16, -3.020925148427425e-17,  1.186194316682113e-19,
 -2.765937016431121e-22,  3.419221671513071e-25,  4.263668465339376e-28, -4.020956477950298e-30,  2.449056020827137e-01, -9.424591787424217e-04,  2.451446981300260e-06,
 -4.690872768139029e-09,  5.230749830371646e-12,  5.035758706723095e-15, -4.699810747546519e-17,  1.447024047327431e-19, -2.559193012854266e-22,  4.340232771389328e-26,
  1.555031438857893e-27, -6.511833492051865e-30,  2.823397468560509e-01, -1.073384283331584e-03,  2.702695979410779e-06, -4.756105677880542e-09,  3.625620955287524e-12,
  1.211915783213937e-14, -6.367172362190049e-17,  1.571658488960994e-19, -1.711736785392796e-22, -4.215384905139751e-25,  2.827312109937702e-27, -8.023496204973338e-30,
  3.223726556328612e-01, -1.209228991023785e-03,  2.934386637177591e-06, -4.652951787248303e-09,  1.425150235237977e-12,  2.013216906748524e-14, -7.809534535790264e-17,
  1.487258304087057e-19, -1.220566725076140e-23, -1.011983059706445e-24,  3.905459089089585e-27, -7.334361510167911e-30,  3.649800432820746e-01, -1.348929275544816e-03,
  3.138732003583847e-06, -4.356470974536538e-09, -1.364288124155244e-12,  2.859654077955560e-14, -8.771548543987085e-17,  1.127579432871915e-19,  2.198271720452464e-22,
 -1.632793517315867e-24,  4.323477724641577e-27, -3.323351160360427e-30,  4.101325490135387e-01, -1.491299052134684e-03,  3.307524972451762e-06, -3.844855589530252e-09,
 -4.698070305422971e-12,  3.685785115798762e-14, -8.972649715285944e-17,  4.465373844032886e-20,  5.074485512012675e-22, -2.131589850368647e-24,  3.565587746681969e-27,
  4.514311210952727e-30,  4.577947904613142e-01, -1.635019824017552e-03,  3.432219617948115e-06, -3.100912107285433e-09, -8.486029740037198e-12,  4.408997723024369e-14,
 -8.133496444694593e-17, -5.654272325375397e-20,  8.128142846377654e-22, -2.309576761036059e-24,  1.211086233063225e-27,  1.544194694152723e-29,  5.079242524962901e-01,
 -1.778629927893535e-03,  3.504045453381215e-06, -2.113803792703198e-09, -1.258563777841660e-11,  4.931737264374289e-14, -6.013465056544076e-17, -1.863546403263470e-19,
  1.076093172602512e-21, -1.952019473335798e-24, -2.858286229482526e-27,  2.692698274131742e-29,  5.604699823907479e-01, -1.920513678118030e-03,  3.514163727534249e-06,
 -8.810661736321330e-10, -1.679640648515013e-11,  5.146129059956034e-14, -2.459547199868772e-17, -3.332012682466489e-19,  1.218164153881327e-21, -8.824933685479190e-25,
 -8.218678919091319e-27,  3.446054494834852e-29,  6.153710584001855e-01, -2.058890863421717e-03,  3.453876703570533e-06,  5.891113406156142e-10, -2.085657869361019e-11,
  4.941665113703709e-14,  2.534712165204746e-17, -4.772379063466117e-19,  1.149744961944848e-21,  9.595196640740739e-25, -1.370066807875410e-26,  3.215124420615478e-29,
  6.725547938778461e-01, -2.191807262190095e-03,  3.314902782139002e-06,  2.275375088362723e-09, -2.444356228065187e-11,  4.216604578275536e-14,  8.764388562628293e-17,
 -5.902802604852436e-19,  7.888421866497523e-22,  3.426716120304041e-24, -1.733589469497825e-26,  1.448045210339073e-29,  7.319346338718342e-01, -2.317127130603792e-03,
  3.089732130236461e-06,  4.140553616814668e-09, -2.718002098476006e-11,  2.893572615769383e-14,  1.575077674576572e-16, -6.375461039899382e-19,  8.734016031398253e-23,
  6.080086450000495e-24, -1.660509147751920e-26, -2.064082960510993e-29,  7.934076961112730e-01, -2.432529004468318e-03,  2.772078791293531e-06,  6.129018720514053e-09,
 -2.864801309378528e-11,  9.394357603446848e-15,  2.269540487704711e-16, -5.820279273082711e-19, -9.348670630586962e-22,  8.152512835121873e-24, -9.137635014318253e-27,
 -6.799223213384786e-29,  8.568519039542353e-01, -2.535506666042144e-03,  2.357445451972046e-06,  8.164322434935321e-09, -2.841398206215830e-11, -1.611247705689669e-14,
  2.847139834532424e-16, -3.921942896549942e-19, -2.154014436919799e-21,  8.615801385495867e-24,  6.075123124613241e-27, -1.118693007087636e-28,  9.221226562120574e-01,
 -2.623377789114756e-03,  1.843815114214595e-06,  1.014751387296732e-08, -2.606757831773443e-11, -4.631211371776785e-14,  3.168025681609972e-16, -5.322738224011317e-20,
 -3.316819357495601e-21,  6.412799689907407e-24,  2.712190923503276e-26, -1.264152431077903e-28,  9.890489793066923e-01, -2.693303613963948e-03,  1.232478305714278e-06,
  1.195672592697550e-08, -2.127693578826551e-11, -7.877885273065437e-14,  3.080686254061591e-16,  4.190837023669499e-19, -4.044151640130025e-21,  8.933094806588299e-25,
  4.784435711851967e-26, -8.301660171805038e-29,  1.057429113287802e+00, -2.742324032226259e-03,  5.289928620489497e-07,  1.344884862354789e-08, -1.386168106099591e-11,
 -1.097990010700162e-13,  2.450308035644457e-16,  9.645595694336273e-19, -3.888447890890007e-21, -7.582821603605410e-24,  5.782770609103060e-26,  3.292734272517453e-29,
  1.127025498279703e+00, -2.767413666060062e-03, -2.557474638798402e-07,  1.446435348509010e-08, -3.881968371612869e-12, -1.344254935450977e-13,  1.201291985522247e-16,
  1.470400516303791e-18, -2.466867922387854e-21, -1.705834574353372e-23,  4.512782269459367e-26,  1.987451126241490e-28,  1.197559156879711e+00, -2.765565836600129e-03,
 -1.104393379004643e-06,  1.483655025492922e-08,  8.263586206827565e-12, -1.468495546778067e-13, -6.290224020480473e-17,  1.776874914849826e-18,  3.272404383752292e-22,
 -2.379254404192962e-23,  2.705678761006865e-27,  3.376050543906397e-28,  1.268703517687564e+00, -2.733912563743098e-03, -1.992079276416770e-06,  1.440663971498204e-08,
  2.174678883869111e-11, -1.412255812574280e-13, -2.836046759264932e-16,  1.706863717710188e-18,  4.078247395221834e-21, -2.302516817435263e-23, -6.248330455848031e-26,
  3.318698442362935e-28,  1.340077804415092e+00, -2.669889586775892e-03, -2.885605318357371e-06,  1.304569206385554e-08,  3.525320159299390e-11, -1.130435944212981e-13,
 -5.014708194518340e-16,  1.126354352829781e-18,  7.685426602173660e-21, -1.113930658053591e-23, -1.227276889516197e-25,  9.005409849021599e-29,  1.411240234742735e+00,
 -2.571455253541786e-03, -3.743143568101996e-06,  1.068385061477704e-08,  4.700133399086378e-11, -6.100821043885376e-14, -6.580615502963522e-16,  3.148804623351632e-20,
  9.477832583575239e-21,  1.101096763642238e-23, -1.343210449124578e-25, -3.412701987493847e-28,  1.481681444920596e+00, -2.437370054656374e-03, -4.514862435148800e-06,
  7.345273849211486e-09,  5.489004607596428e-11,  1.088834162824794e-14, -6.883544548928987e-16, -1.365348292414391e-18,  7.805890197839589e-21,  3.527076553127068e-23,
 -6.231697062106184e-26, -7.007840447603137e-28,  1.550818789692425e+00, -2.267538223875415e-03, -5.144969485562598e-06,  3.184239599551230e-09,  5.682484284535681e-11,
  9.182227427448847e-14, -5.434737296420186e-16, -2.608372808977700e-18,  2.121343470831789e-21,  4.710478149374787e-23,  7.951413382299034e-26, -6.146906454152726e-28,
  1.617992464309452e+00, -2.063402477151843e-03, -5.575721600830696e-06, -1.486625254512019e-09,  5.124394532435186e-11,  1.642868649925777e-13, -2.215812574031557e-16,
 -3.105773518651090e-18, -5.904434886796340e-21,  3.332560324826480e-23,  2.049607908446303e-25,  5.247272032492668e-29,  1.682464740476521e+00, -1.828365911282624e-03,
 -5.753858671813842e-06, -6.190157791277260e-09,  3.778984572895547e-11,  2.072559364180598e-13,  2.057068217484829e-16, -2.412343876246538e-18, -1.224393132698659e-20,
 -4.971673206378481e-24,  1.966533977792136e-25,  8.442860819504031e-28,  1.743423953559909e+00, -1.568190496837608e-03, -5.639565342557113e-06, -1.031834755041878e-08,
  1.794589639680374e-11,  2.030354217209270e-13,  5.935963592801727e-16, -6.041240420612576e-19, -1.242316352334966e-20, -4.471284477647525e-23,  2.146000458835975e-26,
  9.226280481688574e-28,  1.799995128863752e+00, -1.291291131371082e-03, -5.217339249046826e-06, -1.322189797422601e-08, -4.688231189824091e-12,  1.465311703569704e-13,
  7.726282364111144e-16,  1.520571137717294e-18, -5.193424628622585e-21, -5.309468814464361e-23, -1.816908519447797e-25,  3.507933120830225e-29,  1.851259136524357e+00,
 -1.008814213875845e-03, -4.507016568842789e-06, -1.435910526459099e-08, -2.487841469720098e-11,  5.266372227019759e-14,  6.428701223224102e-16,  2.748027233251140e-18,
  4.904474916893872e-21, -1.955493651265382e-23, -2.030266375804401e-25, -8.379963147667961e-28,  1.896281816840333e+00, -7.343730786848993e-04, -3.571879199028161e-06,
 -1.348101773571068e-08, -3.723492041682215e-11, -4.452700964828791e-14,  2.638914325895309e-16,  2.301573213204873e-18,  1.005252334850792e-20,  2.435674476133704e-23,
 -2.213571738185443e-26, -5.917016060116135e-28,  1.934153428403497e+00, -4.833282220660083e-04, -2.519808775371662e-06, -1.079421947393303e-08, -3.843563997043112e-11,
 -1.055497950973426e-13, -1.450135756903879e-16,  6.298691342398740e-19,  6.550785322701885e-21,  3.433196570063314e-23,  1.249883168198732e-25,  2.660897555046305e-28,
  1.964036979402737e+00, -2.715665462296384e-04, -1.493753957032663e-06, -7.016095188931090e-09, -2.923886658796637e-11, -1.080760757313742e-13, -3.421510201828304e-16,
 -8.201045131569816e-19, -5.965417261911028e-22,  8.762927604903818e-24,  7.381730684222959e-26,  3.964235414117467e-28,  1.985221844661826e+00, -1.138549334026439e-04,
 -6.501440516406912e-07, -3.248463640419335e-09, -1.491202798477319e-11, -6.404523696641280e-14, -2.587014968264868e-16, -9.794510883071396e-19, -3.429509147962152e-21,
 -1.075499063012368e-23, -2.771490994131486e-26, -3.965736160940757e-29,  1.997179618400992e+00, -2.197615070131771e-05, -1.281445706213747e-07, -6.622812908631232e-10,
 -3.197420323453804e-12, -1.475559670432485e-14, -6.586776612737046e-17, -2.863278998197555e-19, -1.216854881091661e-21, -5.067326847968569e-24, -2.069993643947973e-26,
 -8.296650560135763e-29,  3.315477711735463e-04, -1.358706717999943e-06,  4.175431122675229e-09, -1.140457298576721e-11,  2.919519025967030e-14, -7.173988647074726e-17,
  1.713060689390273e-19, -4.007064891704211e-22,  9.218172443052198e-25, -2.095600190081628e-27,  4.706088267237222e-30, -1.050889904690399e-32,  2.983886109963541e-03,
 -1.221979891417163e-05,  3.749302979714469e-08, -1.021175499993815e-10,  2.602650926324346e-13, -6.354871384917879e-16,  1.504377259520548e-18, -3.479223608186155e-21,
  7.888842458466429e-24, -1.761444349540728e-26,  3.868942366930365e-29, -8.413948398525717e-32,  8.288324363248006e-03, -3.389621704153289e-05,  1.036699281579756e-07,
 -2.807539300518489e-10,  7.091712525953254e-13, -1.709193018757433e-15,  3.974040139886720e-18, -8.973109497477192e-21,  1.971796689612212e-23, -4.229377142652717e-26,
  8.822381450426333e-29, -1.798131640878102e-31,  1.624436318946261e-02, -6.629592482912977e-05,  2.017874732284183e-07, -5.417492032293106e-10,  1.349712169672991e-12,
 -3.187498599012854e-15,  7.201054635884755e-18, -1.562697131397610e-20,  3.252270936049741e-23, -6.475891793895281e-26,  1.216132524829001e-28, -2.130749685600824e-31,
  2.685119679310837e-02, -1.092796026099839e-04,  3.304626052809312e-07, -8.767943850576479e-10,  2.143258380976452e-12, -4.917931646433177e-15,  1.065066775926651e-17,
 -2.173203294068735e-20,  4.125738417774991e-23, -7.114665046802131e-26,  1.033787635993262e-28, -9.985346265865364e-32,  4.010764322664417e-02, -1.626591124905357e-04,
  4.878419266541503e-07, -1.274884714745992e-09,  3.039583067889353e-12, -6.707639656081241e-15,  1.367297480463725e-17, -2.532686435101355e-20,  4.058918029523013e-23,
 -4.850929555539055e-26,  6.394628357732522e-30,  2.036580924287232e-31,  5.601204881299283e-02, -2.261954244667522e-04,  6.715940836085253e-07, -1.722390318121493e-09,
  3.978008205422171e-12, -8.332446160043382e-15,  1.555568288877229e-17, -2.445036235678043e-20,  2.594507755822289e-23,  1.135881166341709e-26, -1.756581240211925e-28,
  6.651299581265653e-31,  7.456216431939400e-02, -2.995959801785176e-04,  8.789007405655878e-07, -2.203154006991786e-09,  4.888899108044360e-12, -9.548275892996811e-15,
  1.558815983133571e-17, -1.743328368420655e-20, -5.367674653589601e-24,  1.082556699998805e-25, -4.183449221705332e-28,  1.156113896597765e-30,  9.575498979124000e-02,
 -3.825114655316409e-04,  1.106446536403334e-06, -2.698623003580596e-09,  5.695547820401357e-12, -1.010497558138429e-14,  1.313509360134556e-17, -3.209860713550074e-21,
 -5.309531347118674e-23,  2.307514919164185e-25, -6.620565512563598e-28,  1.459031994591618e-30,  1.195865841396994e-01, -4.745319583607235e-04,  1.350408553219165e-06,
 -3.188023210550635e-09,  6.316492560183308e-12, -9.762513997299741e-15,  7.717332348944751e-18,  1.837449677913827e-20, -1.131785445343626e-22,  3.549556546460171e-25,
 -8.159216705000432e-28,  1.308862787444225e-30,  1.460518346444349e-01, -5.751824129237171e-04,  1.606446008800191e-06, -3.648586731774172e-09,  6.668325688602124e-12,
 -8.309468267913836e-15, -9.035248550369943e-19,  4.628965060594419e-20, -1.772749099260473e-22,  4.455997813583356e-25, -7.721123334682538e-28,  4.709499049603411e-31,
  1.751441804539490e-01, -6.839174397117846e-04,  1.869691116810863e-06, -4.055845715236612e-09,  6.669045452969945e-12, -5.583581525635420e-15, -1.264150624107725e-17,
  7.811829943636565e-20, -2.328494648216829e-22,  4.600520608072512e-25, -4.311822433436399e-28, -1.152987650608272e-30,  2.068552829080323e-01, -8.001153374152236e-04,
  2.134742357957266e-06, -4.384008248873739e-09,  6.242005514690849e-12, -1.493995161909012e-15, -2.700994937536139e-17,  1.099683370192588e-19, -2.640184682731066e-22,
  3.556229832391458e-25,  2.631197695925412e-28, -3.410499606153113e-30,  2.411746340313207e-01, -9.230713347579794e-04,  2.395661788871017e-06, -4.606434974051753e-09,
  5.320508868791617e-12,  3.955500590401257e-15, -4.306077469156001e-17,  1.365494438478084e-19, -2.533043315840953e-22,  1.000829266926341e-25,  1.284120321479160e-27,
 -5.808710198595904e-30,  2.780890928102184e-01, -1.051990004510861e-03,  2.645978504643743e-06, -4.696238220359444e-09,  3.853076094797379e-12,  1.064321196779556e-14,
 -5.934989536658703e-17,  1.514666304537820e-19, -1.843970891282496e-22, -3.153533328967884e-25,  2.485805087920708e-27, -7.493925829371075e-30,  3.175823368174027e-01,
 -1.185976822024990e-03,  2.878700991375865e-06, -4.627028658108836e-09,  1.809387676813508e-12,  1.830777592190125e-14, -7.394175580309534e-17,  1.477818646001005e-19,
 -4.590306027820865e-23, -8.622343666621135e-25,  3.581859826104704e-27, -7.350759790570878e-30,  3.596342143326499e-01, -1.324028858480292e-03,  3.086341886402185e-06,
 -4.373837431918522e-09, -8.131494080805777e-13,  2.652999756564898e-14, -8.446838091505670e-17,  1.188849968665918e-19,  1.641215394591996e-22, -1.463074901863968e-24,
  4.155606505986913e-27, -4.263922207458554e-30,  4.042199792643837e-01, -1.465024628032478e-03,  3.260959639044160e-06, -3.914244004366190e-09, -3.982337180976250e-12,
  3.472118390422980e-14, -8.826019337882330e-17,  5.969217281088752e-20,  4.333205995591288e-22, -1.985627213153711e-24,  3.717453777358426e-27,  2.442154194077345e-30,
  4.513093878386608e-01, -1.607713152729972e-03,  3.394222768286092e-06, -3.229740733951451e-09, -7.623863960612740e-12,  4.212180240536224e-14, -8.256644524081910e-17,
 -3.185235831447614e-20,  7.306969739246324e-22, -2.248449791471694e-24,  1.823306682843549e-27,  1.242788864493967e-29,  5.008656321281768e-01, -1.750702375697592e-03,
  3.477503877418469e-06, -2.307363338047918e-09, -1.161412546220303e-11,  4.781535135940383e-14, -6.488119925369094e-17, -1.530638261954782e-19,  1.004039570378335e-21,
 -2.043585731482303e-24, -1.743101206684075e-27,  2.376027777822234e-29,  5.528440809899141e-01, -1.892447150099293e-03,  3.502012330511290e-06, -1.141610036618913e-09,
 -1.577381665445895e-11,  5.076341697624450e-14, -3.338458134873820e-17, -2.947888441272993e-19,  1.180837720805632e-21, -1.181432324466756e-24, -6.741962488330017e-27,
  3.258269538490986e-29,  6.071907938365657e-01, -2.031237170132408e-03,  3.458976517926292e-06,  2.633413302115270e-10, -1.986322312891837e-11,  4.986881580294732e-14,
  1.250400101886916e-17, -4.399963583851060e-19,  1.174768283786996e-21,  4.402284038497130e-25, -1.225481949848770e-26,  3.339958069476038e-29,  6.638407669011811e-01,
 -2.165185405770459e-03,  3.339888885790662e-06,  1.891133380088290e-09, -2.358053037981346e-11,  4.407412655799045e-14,  7.148703862320079e-17, -5.631959969378010e-19,
  8.998925900111875e-22,  2.747861667084267e-24, -1.656378497642648e-26,  2.039089818666558e-29,  7.227158653680811e-01, -2.292217874667392e-03,  3.136829237951164e-06,
  3.710502326160390e-09, -2.656494807834925e-11,  3.250221053222911e-14,  1.397275870895652e-16, -6.313788624484270e-19,  2.940782095308037e-22,  5.400941265676409e-24,
 -1.727436428789258e-26, -9.961279550856057e-30,  7.837223881798607e-01, -2.410065957324512e-03,  2.842883950334026e-06,  5.672443958032146e-09, -2.840699333900993e-11,
  1.464258143346985e-14,  2.102820320441826e-16, -6.073239940148351e-19, -6.486422699782604e-22,  7.730956587318250e-24, -1.184633709608216e-26, -5.511513923528037e-29,
  8.467482059655600e-01, -2.516262965650573e-03,  2.452680136779257e-06,  7.707488122509830e-09, -2.866882877661952e-11, -9.418619614411493e-15,  2.728144529325544e-16,
 -4.561226286832519e-19, -1.840634855986295e-21,  8.762908421374152e-24,  1.347203232124484e-27, -1.026831499231611e-28,  9.116594072090973e-01, -2.608147345630283e-03,
  1.963053563452809e-06,  9.723435072537134e-09, -2.691796974855803e-11, -3.873850957065262e-14,  3.138624018764987e-16, -1.554733986264955e-19, -3.067781728005021e-21,
  7.385346337552358e-24,  2.148627879377882e-26, -1.290495572958062e-28,  9.782963848899928e-01, -2.682875769115431e-03,  1.373865748510330e-06,  1.160409578650314e-08,
 -2.277770129445242e-11, -7.125897451308154e-14,  3.179986137357602e-16,  2.905472118955970e-19, -3.978485014410429e-21,  2.727490618336794e-24,  4.371144821851468e-26,
 -1.040519807315215e-28,  1.046469297616931e+00, -2.737450479747216e-03,  6.889769162935057e-07,  1.320982233313573e-08, -1.599673974779457e-11, -1.036084666132386e-13,
  2.702586045145790e-16,  8.362101126271763e-19, -4.119548089721445e-21, -5.252104828650213e-24,  5.843015632609211e-26, -5.216471192079102e-30,  1.115952849188206e+00,
 -2.768766615939409e-03, -8.263606657631800e-08,  1.438090439123906e-08, -6.538360828516196e-12, -1.310578129628854e-13,  1.601055159921134e-16,  1.381999948734322e-18,
 -3.046472477407799e-21, -1.508978837939455e-23,  5.300805985885600e-26,  1.586859213791674e-28,  1.186480353695427e+00, -2.773686805184679e-03, -9.256586118255620e-07,
  1.494520660798432e-08,  5.315531289967312e-12, -1.477617851417806e-13, -1.313158770468797e-17,  1.773691881192942e-18, -5.237893342004341e-22, -2.339027836346432e-23,
  1.731026132664644e-26,  3.242535431784923e-28,  1.257737097133611e+00, -2.749151981105415e-03, -1.817206269922365e-06,  1.473163892758723e-08,  1.885815616189269e-11,
 -1.474446227607974e-13, -2.341133188826239e-16,  1.823652132731058e-18,  3.207993770415606e-21, -2.521932430660401e-23, -4.692357187675627e-26,  3.731564353004169e-28,
  1.329353081160897e+00, -2.692338823252328e-03, -2.725749402731932e-06,  1.359101361408784e-08,  3.287467320978740e-11, -1.246730527116027e-13, -4.665568141186634e-16,
  1.364933745541124e-18,  7.197259420393573e-21, -1.594098357983527e-23, -1.166626863693856e-25,  1.851940122396668e-28,  1.400895353323358e+00, -2.600874891197817e-03,
 -3.610468275419564e-06,  1.142525345337625e-08,  4.562348496362513e-11, -7.675650732310993e-14, -6.528817801002018e-16,  3.400562490723259e-19,  9.774138204195693e-21,
  5.364515075860134e-24, -1.473074995935441e-25, -2.460294704303674e-28,  1.471860306235997e+00, -2.473121440244146e-03, -4.421445460099259e-06,  8.224346631427134e-09,
  5.493966201712514e-11, -6.061541665247941e-15, -7.229000626735997e-16, -1.095785341862380e-18,  9.023326134556393e-21,  3.216047853683230e-23, -9.316493502616452e-26,
 -6.962839206167603e-28,  1.541666581286166e+00, -2.308529545058987e-03, -5.101245185859408e-06,  4.107395285785806e-09,  5.852498521456663e-11,  7.791174976208702e-14,
 -6.152988173209985e-16, -2.512798960643551e-18,  3.867476918923433e-21,  4.970388365309242e-23,  4.946120322950148e-26, -7.490680912346057e-28,  1.609649549876073e+00,
 -2.108065421927079e-03, -5.588534273441996e-06, -6.407551092134243e-10,  5.446935379633756e-11,  1.579051896447289e-13, -3.109964525663672e-16, -3.273936172969836e-18,
 -4.557058826839259e-21,  4.151775762094745e-23,  2.032971192635882e-25, -1.327721714360177e-28,  1.675058759569344e+00, -1.874683312738564e-03, -5.824375146966444e-06,
 -5.552114831717256e-09,  4.197863358570413e-11,  2.113379692331893e-13,  1.326602477296992e-16, -2.805423003220119e-18, -1.227244329766091e-20,  3.628539376523951e-24,
  2.330524485458536e-25,  8.023118019898844e-28,  1.737060181637067e+00, -1.613797105365777e-03, -5.761526214080152e-06, -9.997960069377825e-09,  2.214745935663561e-11,
  2.170323471270892e-13,  5.708749798774926e-16, -1.027171566603305e-18, -1.400710004112222e-20, -4.298864980492325e-23,  6.607432437229051e-26,  1.104300541258743e-27,
  1.794745480547736e+00, -1.333665542321602e-03, -5.376352082088244e-06, -1.327244306392170e-08, -1.568833082181845e-12,  1.655645643537522e-13,  8.125802586191939e-16,
  1.322402611060253e-18, -7.234782525650627e-21, -6.027626302055761e-23, -1.759352227281849e-25,  2.345776028192961e-28,  1.847150666670999e+00, -1.045566264781684e-03,
 -4.681676614058270e-06, -1.474786893015352e-08, -2.366453021202835e-11,  6.903296862280389e-14,  7.218946615967333e-16,  2.892066415762352e-18,  4.045299617489636e-21,
 -2.842757815882251e-23, -2.409043947331103e-25, -8.788442619949860e-28,  1.893286135516572e+00, -7.636053943606849e-04, -3.737254175900328e-06, -1.408353409423588e-08,
 -3.805671542473698e-11, -3.738313396558775e-14,  3.329693035528637e-16,  2.637058596554002e-18,  1.090668957484642e-20,  2.289918664345238e-23, -5.206857013184875e-26,
 -7.738252999195404e-28,  1.932178963241830e+00, -5.040154309304930e-04, -2.653099488455456e-06, -1.142626034088760e-08, -4.057988319266349e-11, -1.087936201688447e-13,
 -1.242496734263042e-16,  8.602568899386604e-19,  7.879487035256744e-21,  3.955851033932985e-23,  1.361218501374175e-25,  2.361641197920048e-28,  1.962926268483263e+00,
 -2.838614706399244e-04, -1.580826827365591e-06, -7.501663233649565e-09, -3.148437417870497e-11, -1.165650996913378e-13, -3.653295046276191e-16, -8.335409564306561e-19,
 -2.235011626433052e-22,  1.208917111553342e-23,  9.313209743288894e-26,  4.839400774193727e-28,  1.984755769882769e+00, -1.192161677298158e-04, -6.906005586485038e-07,
 -3.497650224984082e-09, -1.625730811533063e-11, -7.059593504657912e-14, -2.877222979384518e-16, -1.095607490669465e-18, -3.837042798622708e-21, -1.189607850076797e-23,
 -2.927074661962472e-26, -3.019048956154021e-29,  1.997089611893579e+00, -2.303398946697903e-05, -1.364089230254103e-07, -7.158896102996332e-10, -3.509013390347663e-12,
 -1.643720386791719e-14, -7.445870476122301e-17, -3.283532659049402e-19, -1.415106117025939e-21, -5.973186029942281e-24, -2.471919724655058e-26, -1.003019670021229e-28,
  3.261788955209542e-04, -1.325842855042128e-06,  4.041332350101979e-09, -1.094870869597009e-11,  2.780061412025685e-14, -6.775991333658187e-17,  1.604881738587065e-19,
 -3.723799573034028e-22,  8.496554944481979e-25, -1.916286655036086e-27,  4.267234516623933e-30, -9.458870931085943e-33,  2.935599140533945e-03, -1.192468647944700e-05,
  3.629219148974070e-08, -9.805305736786738e-11,  2.479086545043649e-13, -6.005231527661158e-16,  1.410399958802277e-18, -3.236634979123881e-21,  7.281709233256019e-24,
 -1.613844344424988e-26,  3.516995780754587e-29, -7.598513170292179e-32,  8.154377145572156e-03, -3.308014347505516e-05,  1.003678499261964e-07, -2.696755629039939e-10,
  6.759211734482189e-13, -1.616761102910304e-15,  3.731402596883117e-18, -8.365829864138413e-21,  1.825704990726914e-23, -3.891820400576375e-26,  8.067166656443170e-29,
 -1.637314879636906e-31,  1.598236742875599e-02, -6.470726666806791e-05,  1.954139814246797e-07, -5.206545647953704e-10,  1.287655607598486e-12, -3.019808469019516e-15,
  6.777725726342098e-18, -1.462262496299856e-20,  3.027673169635887e-23, -6.007737363316199e-26,  1.125740147509032e-28, -1.979646376310590e-31,  2.641929996124778e-02,
 -1.066774123179796e-04,  3.201436240594492e-07, -8.432754357896392e-10,  2.047407381137749e-12, -4.669470734880468e-15,  1.006027473924209e-17, -2.045198769123102e-20,
  3.876946906577531e-23, -6.710039537891633e-26,  9.891182304164857e-29, -1.029033446144651e-31,  3.946471651017243e-02, -1.588167548579771e-04,  4.728307401116974e-07,
 -1.227307016937413e-09,  2.908655099083502e-12, -6.387852928143881e-15,  1.298174447311427e-17, -2.405588577953423e-20,  3.884949765901106e-23, -4.808647113038068e-26,
  1.445650562329745e-29,  1.638144981657343e-31,  5.511788322982091e-02, -2.209042770496011e-04,  6.513018542395968e-07, -1.660055324685051e-09,  3.815037678985667e-12,
 -7.967230944319564e-15,  1.488274826699974e-17, -2.361487760839286e-20,  2.623433570921855e-23,  4.891783953835102e-27, -1.483181720887228e-28,  5.793107105153870e-31,
  7.337767722919232e-02, -2.926692102479128e-04,  8.529259903241396e-07, -2.126439184714594e-09,  4.701635124413682e-12, -9.180033561900735e-15,  1.509818658949882e-17,
 -1.754582630539134e-20, -1.759749419633309e-24,  9.250317040268055e-26, -3.701531095200838e-28,  1.036232092955960e-30,  9.424244414532759e-02, -3.737878932040268e-04,
  1.074603219058278e-06, -2.609093940300652e-09,  5.496592490945044e-12, -9.790996344748703e-15,  1.302264390576277e-17, -4.780985413160461e-21, -4.524977606459838e-23,
  2.055195038426017e-25, -6.003684102303767e-28,  1.345695285373142e-30,  1.177098229593965e-01, -4.638800117359012e-04,  1.312752247777667e-06, -3.088511100714599e-09,
  6.123134047572024e-12, -9.571521858802529e-15,  8.182991031869401e-18,  1.495105091655972e-20, -1.009738214910703e-22,  3.234598668131497e-25, -7.591536856152671e-28,
  1.269650928357877e-30,  1.437765333802671e-01, -5.625041758677582e-04,  1.563297640396195e-06, -3.543223784543397e-09,  6.502021211419005e-12, -8.316225957538706e-15,
  3.155355369072717e-19,  4.086760099445005e-20, -1.617839118197075e-22,  4.151657960311162e-25, -7.487558583335589e-28,  5.851463542046357e-31,  1.724381200582899e-01,
 -6.691527859817772e-04,  1.821657460025952e-06, -3.950050116824582e-09,  6.554512746269802e-12, -5.861556728656995e-15, -1.055604489221947e-17,  7.092868470140906e-20,
 -2.166093433933091e-22,  4.418909006981530e-25, -4.744835138638998e-28, -8.244294337890631e-31,  2.036886466451260e-01, -7.832461356165840e-04,  2.082732394192839e-06,
 -4.284409390963841e-09,  6.205887748253736e-12, -2.106227381477503e-15, -2.404717874987696e-17,  1.017263325995579e-19, -2.510612493104406e-22,  3.633114862189017e-25,
  1.252713215084597e-28, -2.865918204639836e-30,  2.375203312424032e-01, -9.041256964934163e-04,  2.340897770287832e-06, -4.520728819789064e-09,  5.389589270439832e-12,
  2.967010333901532e-15, -3.935026111449988e-17,  1.285107783966538e-19, -2.488365675810533e-22,  1.465339808361159e-25,  1.043251361403587e-27, -5.147130737351609e-30,
  2.739231130344300e-01, -1.031046532189611e-03,  2.590000319041263e-06, -4.632962051352942e-09,  4.052036397504163e-12,  9.269030667353142e-15, -5.519301317139360e-17,
  1.454028352093243e-19, -1.940380224503347e-22, -2.223537893959627e-25,  2.168212662608564e-27, -6.939411347358471e-30,  3.128841378216998e-01, -1.163168792107768e-03,
  2.823362123333796e-06, -4.595244227642531e-09,  2.158131367131844e-12,  1.658263479528317e-14, -6.982890109000115e-17,  1.458433403257761e-19, -7.444229381375391e-23,
 -7.254036642583924e-25,  3.260504815789971e-27, -7.237317170395597e-30,  3.543871476972885e-01, -1.299548249146805e-03,  3.033794930996741e-06, -4.382712027755842e-09,
 -3.025493722855882e-13,  2.454324771603875e-14, -8.107376618250596e-17,  1.233258557249635e-19,  1.143956198598606e-22, -1.300824203783913e-24,  3.951867973059754e-27,
 -4.959245861230380e-30,  3.984117571633596e-01, -1.439125865796655e-03,  3.213628951411461e-06, -3.972520505505476e-09, -3.308952746090690e-12,  3.262449770123048e-14,
 -8.640522546133275e-17,  7.244358693281886e-20,  3.645355323775976e-22, -1.835319332625465e-24,  3.785145496487816e-27,  6.851001261799092e-31,  4.449325944877033e-01,
 -1.580716408505589e-03,  3.354761439451188e-06, -3.345090992231915e-09, -6.801302760713670e-12,  4.013207326381736e-14, -8.314302133607768e-17, -9.750066722208593e-21,
  6.511897615393083e-22, -2.165410296665644e-24,  2.308634710938768e-27,  9.677547957106555e-30,  4.939182829631083e-01, -1.722996185037907e-03,  3.448731841565069e-06,
 -2.485624887033212e-09, -1.067371859815858e-11,  4.621033532945877e-14, -6.872832091583602e-17, -1.221231328673333e-19,  9.294589348341378e-22, -2.093330277057590e-24,
 -7.670280372099430e-28,  2.061698192102211e-29,  5.453302318686537e-01, -1.864490062351154e-03,  3.486832079027514e-06, -1.385915219958367e-09, -1.476720730138255e-11,
  4.986736679017601e-14, -4.111640262094950e-17, -2.577318242096796e-19,  1.133791581694184e-21, -1.423087896694062e-24, -5.357547408925839e-27,  3.028755265252331e-29,
  5.991212012668319e-01, -2.003558044515790e-03,  3.460262699442920e-06, -4.647903629007856e-11, -1.886382176023380e-11,  5.002533234580174e-14,  7.121238871720157e-19,
 -4.022419241701587e-19,  1.182148693024845e-21, -2.042216723024988e-26, -1.077559205418259e-26,  3.369260215366828e-29,  6.552335982605404e-01, -2.138381866614219e-03,
  3.360348131813580e-06,  1.520984671402500e-09, -2.268315109934037e-11,  4.560392251981063e-14,  5.613467294577379e-17, -5.329426951143892e-19,  9.871192056260470e-22,
  2.104695906286868e-24, -1.556117921277835e-26,  2.496749808251003e-29,  7.135974550010448e-01, -2.266952311760628e-03,  3.178827056145401e-06,  3.290839726024150e-09,
 -2.588279497337749e-11,  3.564476758245876e-14,  1.222090009866999e-16, -6.189914584105450e-19,  4.759953777063223e-22,  4.704088871879967e-24, -1.749899538100307e-26,
 -4.536567102723642e-31,  7.741280307227760e-01, -2.387058311104674e-03,  2.908236742912743e-06,  5.220543264745016e-09, -2.806506247629833e-11,  1.948319762968199e-14,
  1.930275300293149e-16, -6.237234863497197e-19, -3.794072061244188e-22,  7.212379432808559e-24, -1.398955522086250e-26, -4.235708004703896e-29,  8.367229717294229e-01,
 -2.496279375074935e-03,  2.542412710621355e-06,  7.247631174695408e-09, -2.879279334651375e-11, -3.030694037101684e-15,  2.592658636464207e-16, -5.099737605314263e-19,
 -1.525260705001394e-21,  8.729568146982815e-24, -2.933815512305244e-27, -9.165340680099476e-29,  9.012589552538642e-01, -2.591983570158590e-03,  2.077126413048228e-06,
  9.286956995118788e-09, -2.761782184469580e-11, -3.126889276474098e-14,  3.081758682777579e-16, -2.492336842085693e-19, -2.787806847851262e-21,  8.131369396619097e-24,
  1.582516590038489e-26, -1.276442561569795e-28,  9.675877366907559e-01, -2.671334147671220e-03,  1.510882557864489e-06,  1.122866830852582e-08, -2.412597607805981e-11,
 -6.354366755764509e-14,  3.243686880273038e-16,  1.651349107980196e-19, -3.849973595123194e-21,  4.379279022699484e-24,  3.876072188273395e-26, -1.201483227303648e-28,
  1.035531516927652e+00, -2.731309099214901e-03,  8.458918783615065e-07,  1.293765725037290e-08, -1.800222815925778e-11, -9.685634839479947e-14,  2.918017159587685e-16,
  7.018093494770242e-19, -4.266707145636627e-21, -2.930173200371777e-24,  5.740771641363123e-26, -4.071845289844396e-29,  1.104877550724534e+00, -2.768739397282356e-03,
  8.922131706590369e-08,  1.425554309766777e-08, -9.118016396211142e-12, -1.267624316325708e-13,  1.973580219174106e-16,  1.276243236817278e-18, -3.549971293842888e-21,
 -1.284248826165902e-23,  5.903839975092776e-26,  1.149810911718742e-28,  1.175371933517613e+00, -2.780373482963094e-03, -7.459033737383308e-07,  1.500661294096990e-08,
  2.361153668622673e-12, -1.474836493890948e-13,  3.617165172826702e-17,  1.743618989081086e-18, -1.349995538780699e-21, -2.241904698833543e-23,  3.107011228371114e-26,
  2.993981542922852e-28,  1.246712540457090e+00, -2.762977609190025e-03, -1.638714474229911e-06,  1.500949056177129e-08,  1.585726889973568e-11, -1.524398462330771e-13,
 -1.817527588235165e-16,  1.911452028138297e-18,  2.270354055380500e-21, -2.675887720927002e-23, -2.985800809163764e-26,  4.000574092450404e-28,  1.318541159163610e+00,
 -2.713483701298914e-03, -2.559585489069157e-06,  1.409646576221547e-08,  3.027246632621029e-11, -1.353863352578043e-13, -4.252068904095434e-16,  1.585180971819373e-18,
  6.541597926415398e-21, -2.041745772234256e-23, -1.065035682101569e-25,  2.753902238979511e-28,  1.390434971944076e+00, -2.629197937829945e-03, -3.469038786109587e-06,
  1.214210068886531e-08,  4.393261770417786e-11, -9.227593056465520e-14, -6.389605796867610e-16,  6.547621243324644e-19,  9.858877724068450e-21, -7.125327735128647e-25,
 -1.557331422680156e-25, -1.346525075257111e-28,  1.461897723474910e+00, -2.508083307085876e-03, -4.317486174176929e-06,  9.101458883934219e-09,  5.464262299677988e-11,
 -2.374565610083657e-14, -7.493710223245184e-16, -7.892931719607495e-19,  1.010671334930533e-20,  2.782953752954440e-23, -1.231155095435669e-25, -6.596612767061392e-28,
  1.532351177968018e+00, -2.349126319680787e-03, -5.046289285827534e-06,  5.055434930574459e-09,  5.992992880147669e-11,  6.231592785722089e-14, -6.836532228974370e-16,
 -2.360095060622657e-18,  5.684157169558969e-21,  5.098737829056540e-23,  1.386814871798795e-26, -8.649911883335860e-28,  1.601127844171766e+00, -2.152789399470379e-03,
 -5.590891458847552e-06,  2.555823963953818e-10,  5.754531405479239e-11,  1.493261907138637e-13, -4.044724279220055e-16, -3.394293380354828e-18, -2.918000121481578e-21,
  4.947244980778921e-23,  1.929037099251874e-25, -3.432303852206173e-28,  1.667466430899878e+00, -1.921533075016103e-03, -5.886830607598197e-06, -4.846497134138028e-09,
  4.623064013492462e-11,  2.135350026044384e-13,  4.864320737237624e-17, -3.194184270524969e-18, -1.196571805620511e-20,  1.363310109316012e-23,  2.664944621770589e-25,
  7.086876198406858e-28,  1.730512057896799e+00, -1.660362858379495e-03, -5.879229955041410e-06, -9.608141831191862e-09,  2.662251891060955e-11,  2.303361579970323e-13,
  5.356105430105194e-16, -1.499552010996226e-18, -1.549494000168225e-20, -3.932274589334080e-23,  1.184539584091919e-25,  1.273365301220557e-27,  1.789323787777569e+00,
 -1.377313604365157e-03, -5.535659268671389e-06, -1.326998236582590e-08,  1.940332789090414e-12,  1.854826038501976e-13,  8.460305875454346e-16,  1.054836513395881e-18,
 -9.528285701873513e-21, -6.703754109099570e-23, -1.603135334975899e-25,  4.837973040438363e-28,  1.842892365007043e+00, -1.083733900971296e-03, -4.860874149243943e-06,
 -1.511448700506215e-08, -2.210398557653200e-11,  8.734378863447359e-14,  8.045172662898120e-16,  3.003205976209469e-18,  2.839090511852208e-21, -3.884159620885716e-23,
 -2.798317691867484e-25, -8.834482214932688e-28,  1.890170832838738e+00, -7.941898427049009e-04, -3.909933225793791e-06, -1.469796282655044e-08, -3.871827762356911e-11,
 -2.846563476967600e-14,  4.118138025275648e-16,  2.998790460892462e-18,  1.168482034847791e-20,  2.007520722813674e-23, -9.067537384220996e-26, -9.859270453243065e-28,
  1.930119567728536e+00, -5.257998914388727e-04, -2.794182586304012e-06, -1.209309875329320e-08, -4.278347148085379e-11, -1.114567198576405e-13, -9.641077381497636e-17,
  1.136256532776082e-18,  9.403976647584332e-21,  4.519663789138811e-23,  1.453685051515299e-25,  1.788900559305920e-28,  1.961764946917517e+00, -2.968769091573008e-04,
 -1.673947783913470e-06, -8.024547970572751e-09, -3.390524809783152e-11, -1.256134568417006e-13, -3.886979776807451e-16, -8.329672801528646e-19,  2.841589840670615e-22,
  1.626945058744198e-23,  1.166313721636975e-25,  5.868659119842837e-28,  1.984267583394079e+00, -1.249133911938295e-04, -7.341809006945762e-07, -3.769448379266833e-09,
 -1.774083842103278e-11, -7.788367291089462e-14, -3.201843093897575e-16, -1.225473333517554e-18, -4.286660161215806e-21, -1.308936330245381e-23, -3.027879576450298e-26,
 -1.440289842722377e-29,  1.996995237604117e+00, -2.416060363538514e-05, -1.453476354710348e-07, -7.747640919126036e-10, -3.856399576264902e-12, -1.833986223815425e-14,
 -8.432030288255239e-17, -3.772770308730344e-19, -1.649055746517263e-21, -7.056155093535600e-24, -2.958370967019652e-26, -1.215230456836210e-28,  3.209393638578629e-04,
 -1.294030274144469e-06,  3.912572651510084e-09, -1.051453467018806e-11,  2.648310406960007e-14, -6.403030706076700e-17,  1.504320400102339e-19, -3.462626164968143e-22,
  7.836438764079595e-25, -1.753637671915485e-27,  3.872033362459133e-30, -8.522461013061660e-33,  2.888473711655975e-03, -1.163898896412607e-05,  3.513896356134151e-08,
 -9.418079378452091e-11,  2.362294805884048e-13, -5.677352597287069e-16,  1.322950942401636e-18, -3.012650921317425e-21,  6.725262098594423e-24, -1.479630449859869e-26,
  3.199015259828485e-29, -6.868440574075102e-32,  8.023642218281061e-03, -3.228996367836087e-05,  9.719558008832759e-08, -2.591147186276347e-10,  6.444628500853250e-13,
 -1.529953614580115e-15,  3.505132253581777e-18, -7.803412193997470e-21,  1.691238210354421e-23, -3.583103257122671e-26,  7.379285381548035e-29, -1.491825316002315e-31,
  1.572662590451914e-02, -6.316860052682657e-05,  1.892877767653112e-07, -5.005265435374885e-10,  1.228853485722096e-12, -2.861948740672644e-15,  6.381537163077051e-18,
 -1.368752182780778e-20,  2.819293893074324e-23, -5.574439532814714e-26,  1.041777177225289e-28, -1.838475383116120e-31,  2.599764929798070e-02, -1.041561906649356e-04,
  3.102178300564909e-07, -8.112511066198107e-10,  1.956386762420407e-12, -4.434758023549808e-15,  9.504630051329235e-18, -1.924925980030757e-20,  3.642397503786072e-23,
 -6.323501955235805e-26,  9.434607216244295e-29, -1.044047085751684e-31,  3.883692261150849e-02, -1.550922381203914e-04,  4.583781250302144e-07, -1.181773890130870e-09,
  2.783959819692565e-12, -6.084234953848421e-15,  1.232532487648765e-17, -2.284027459035498e-20,  3.713043489424253e-23, -4.737447367328884e-26,  2.089526283174268e-29,
  1.297368700097349e-31,  5.424456223625128e-02, -2.157725191662342e-04,  6.317422378427062e-07, -1.600270294773874e-09,  3.659211851953524e-12, -7.617884598438069e-15,
  1.423330326917687e-17, -2.277365774901356e-20,  2.630958283069055e-23, -5.541926006942501e-28, -1.245340631354002e-28,  5.033104183431747e-31,  7.222048738185903e-02,
 -2.859466063880009e-04,  8.278540815755039e-07, -2.052662307170894e-09,  4.521618203829196e-12, -8.823575867613573e-15,  1.460659584590457e-17, -1.755162684466324e-20,
  1.314541685801341e-24,  7.857601911903178e-26, -3.270003947309505e-28,  9.269372925692869e-31,  9.276429002408600e-02, -3.653148236597617e-04,  1.043815357472600e-06,
 -2.522698086705842e-09,  5.303886338100676e-12, -9.480216251773405e-15,  1.286958430303688e-17, -6.115119983518763e-21, -3.826936449475206e-23,  1.826566428497407e-25,
 -5.435659305993218e-28,  1.237058884107397e-30,  1.158750745537639e-01, -4.535245912727597e-04,  1.276271653171576e-06, -2.992061592929740e-09,  5.933699595132198e-12,
 -9.370461089540968e-15,  8.558093595394916e-18,  1.190044930354176e-20, -8.986251803284350e-23,  2.941972186555841e-25, -7.043354108969408e-28,  1.220719403983746e-30,
  1.415512626341509e-01, -5.501661135725780e-04,  1.521397662679754e-06, -3.440521251146170e-09,  6.335862142953000e-12, -8.295492996654105e-15,  1.389555137770134e-18,
  3.592392290972764e-20, -1.473705969484438e-22,  3.857570442002736e-25, -7.210765563063825e-28,  6.683155179199416e-31,  1.697903577349921e-01, -6.547673548754115e-04,
  1.774882180443007e-06, -3.846128865707103e-09,  6.434905041077242e-12, -6.091838460959824e-15, -8.664717693996336e-18,  6.424798605437066e-20, -2.010508622448738e-22,
  4.222709161902656e-25, -5.045057224369157e-28, -5.483626805182112e-31,  2.005886625844422e-01, -7.667882435127911e-04,  2.031913757646876e-06, -4.185482588637199e-09,
  6.158217952604246e-12, -2.650075347372717e-15, -2.130934512509243e-17,  9.390236932475897e-20, -2.379208902102569e-22,  3.659466854787247e-25,  1.000131009981875e-29,
 -2.383564732157540e-30,  2.339409413204994e-01, -8.856140391636933e-04,  2.287168220335637e-06, -4.434070775249632e-09,  5.439772248336102e-12,  2.064889047155771e-15,
 -3.586259015019479e-17,  1.206400338448578e-19, -2.428630957140204e-22,  1.839192583440616e-25,  8.304986915793015e-28, -4.531215848766808e-30,  2.698400163796367e-01,
 -1.010547796033693e-03,  2.534799658095776e-06, -4.566717024252584e-09,  4.224496805883588e-12,  7.992545249843380e-15, -5.120975027031303e-17,  1.390816939854660e-19,
 -2.005537234840442e-22, -1.415663160399395e-25,  1.875265506696275e-27, -6.376069325963790e-30,  3.082762880698980e-01, -1.140801855211406e-03,  2.768437026576379e-06,
 -4.558150577802824e-09,  2.473354409127043e-12,  1.495545210287256e-14, -6.578238772668723e-17,  1.430679059075241e-19, -9.828550157184934e-23, -6.012955202416177e-25,
  2.946470823355423e-27, -7.022365429680435e-30,  3.492371622656307e-01, -1.275488305544856e-03,  2.981189201236516e-06, -4.383730437308207e-09,  1.691395393362145e-13,
  2.263928627912573e-14, -7.757621805415123e-17,  1.262673127778995e-19,  7.035725456270649e-23, -1.147270143806904e-24,  3.722319207330128e-27, -5.442470039275955e-30,
  3.927063686456609e-01, -1.413608366344046e-03,  3.165662215014387e-06, -4.020355789618141e-09, -2.677029186939898e-12,  3.057637149147179e-14, -8.422321731622884e-17,
  8.308083291639195e-20,  3.011924612576128e-22, -1.683761774958387e-24,  3.782079811406549e-27, -7.778869829692946e-31,  4.386631482776335e-01, -1.554040671015886e-03,
  3.313993558297971e-06, -3.447599174553830e-09, -6.018625867551061e-12,  3.813564805828989e-14, -8.313587772285880e-17,  9.859339701077806e-21,  5.749929814902692e-22,
 -2.065296669645844e-24,  2.679043748804783e-27,  7.205820717088672e-30,  4.870812850180877e-01, -1.695528473899509e-03,  3.417909871415082e-06, -2.649101455720350e-09,
 -9.766266590244509e-12,  4.452311337702875e-14, -7.174273234448742e-17, -9.359040666748521e-20,  8.537571412157261e-22, -2.106774617878952e-24,  7.260386545940524e-29,
  1.756882282973235e-29,  5.379279500318301e-01, -1.836665870891702e-03,  3.468816176745567e-06, -1.614267754350346e-09, -1.378029145574551e-11,  4.879802627210729e-14,
 -4.783293682024462e-17, -2.223089899765109e-19,  1.079017414489098e-21, -1.611480236827626e-24, -4.080896881440655e-27,  2.770438114287380e-29,  5.911623226160811e-01,
 -1.975883228847668e-03,  3.457927033567757e-06, -3.402989551435259e-10, -1.786403440975733e-11,  4.991154110049374e-14, -1.002173421569969e-17, -3.645052218134879e-19,
  1.174011551040076e-21, -4.218942694285643e-25, -9.301779060375612e-27,  3.317786513675863e-29,  6.467339433406565e-01, -2.111432174343972e-03,  3.376452687360153e-06,
  1.165419072488177e-09, -2.175879031256263e-11,  4.677572111802203e-14,  4.166505378331941e-17, -5.002604937329792e-19,  1.051958820268072e-21,  1.505285228797803e-24,
 -1.438518723724601e-26,  2.828736015543866e-29,  7.045807472244273e-01, -2.241370719938570e-03,  3.215856410275288e-06,  2.882571669924795e-09, -2.514196379229205e-11,
  3.837167532421185e-14,  1.051149819901183e-16, -6.011850299883545e-19,  6.327615698513699e-22,  4.006246092985900e-24, -1.733323859131531e-26,  7.770492360490129e-30,
  7.646267152916163e-01, -2.363549433561438e-03,  2.968202674073595e-06,  4.774865325147721e-09, -2.763049260799719e-11,  2.390515128767410e-14,  1.754315413622144e-16,
 -6.318216115188554e-19, -1.302498152213548e-22,  6.619178660002585e-24, -1.558116892503184e-26, -3.009912033739003e-29,  8.267790725926933e-01, -2.475600021168017e-03,
  2.626619257941169e-06,  6.786794702323210e-09, -2.879236731587770e-11,  3.015109543325193e-15,  2.443503198476633e-16, -5.537841982750704e-19, -1.214048351437509e-21,
  8.535105361661560e-24, -6.699763009829257e-27, -7.936561125009777e-29,  8.909249501399374e-01, -2.574928341896336e-03,  2.185899243446189e-06,  8.840468133529993e-09,
 -2.816985368930790e-11, -2.396622057457622e-14,  2.999932023423922e-16, -3.336485815149070e-19, -2.485026289173211e-21,  8.653269802594862e-24,  1.030605747561871e-26,
 -1.226826896249102e-28,  9.569274182115419e-01, -2.658714767226517e-03,  1.643269918872887e-06,  1.083291000482584e-08, -2.531869771012834e-11, -5.571709910909473e-14,
  3.272934504093235e-16,  4.474688949057599e-20, -3.665719430967529e-21,  5.820364743813378e-24,  3.321327762283317e-26, -1.311732127322619e-28,  1.024620790958995e+00,
 -2.723925997963516e-03,  9.993528764280528e-07,  1.263451149607588e-08, -1.986781110415855e-11, -8.963280940527327e-14,  3.095281713977201e-16,  5.640260415300947e-19,
 -4.331379903605077e-21, -6.793355254600811e-25,  5.490324318433759e-26, -7.240989819664537e-29,  1.093805100344582e+00, -2.767344031725115e-03,  2.593297077293596e-07,
  1.408964211470737e-08, -1.160307267850698e-11, -1.216102687422732e-13,  2.314362447471793e-16,  1.155711759599977e-18, -3.968694957655477e-21, -1.039307138339151e-23,
  6.310168603516944e-26,  6.959890729685940e-29,  1.164239646245976e+00, -2.785619974084717e-03, -5.656944889911107e-07,  1.502085768556559e-08, -5.759119549194370e-13,
 -1.460352918949738e-13,  8.426871013655520e-17,  1.687770827476036e-18, -2.131622221960530e-21, -2.092238370452006e-23,  4.350831434687886e-26,  2.644526642145595e-28,
  1.235635557091898e+00, -2.775362789417232e-03, -1.457179617645231e-06,  1.523859781642233e-08,  1.276922511010648e-11, -1.561523524533821e-13, -1.273612449696196e-16,
  1.968494462183525e-18,  1.289821844530815e-21, -2.759665625230788e-23, -1.194827388484093e-26,  4.114026919978840e-28,  1.307647353670856e+00, -2.733275730057003e-03,
 -2.387612851971792e-06,  1.455862444751994e-08,  2.746640442004914e-11, -1.450357333507027e-13, -3.780074039590770e-16,  1.781954631066013e-18,  5.733032527956671e-21,
 -2.441065525768756e-23, -9.256758808274134e-26,  3.561564341579455e-28,  1.379863615050257e+00, -2.656355623252880e-03, -3.319179629053130e-06,  1.282943209263291e-08,
  4.193541753903220e-11, -1.073554016348931e-13, -6.162229475312201e-16,  9.686240546170440e-19,  9.719992719533772e-21, -7.024865155225775e-24, -1.589887880042551e-25,
 -1.190357928494206e-29,  1.451797023105796e+00, -2.542171506136071e-03, -4.203041832161375e-06,  9.970957522035547e-09,  5.398626338682637e-11, -4.195832691300191e-14,
 -7.667999101559203e-16, -4.508547161941652e-19,  1.101309943887500e-20,  2.234256224063889e-23, -1.507245551362986e-25, -5.898314249937446e-28,  1.522874339404320e+00,
 -2.389237583331775e-03, -4.979832613187684e-06,  6.023370779479514e-09,  6.100693132013879e-11,  4.513751047579902e-14, -7.469131149541934e-16, -2.148802419969796e-18,
  7.520253899488857e-21,  5.075261705802892e-23, -2.625018669633815e-26, -9.532703109163759e-28,  1.592427274126942e+00, -2.197488387472714e-03, -5.582203361849516e-06,
  1.199639697825588e-09,  6.042701887206802e-11,  1.384695164701356e-13, -5.005417347116055e-16, -3.457717511173249e-18, -1.002340662492738e-21,  5.682048720437828e-23,
  1.728396477669083e-25, -5.707692440966522e-28,  1.659685759157131e+00, -1.968847452174011e-03, -5.940409378131167e-06, -4.072609041354582e-09,  5.050554872853554e-11,
  2.135864541440769e-13, -4.606580174215225e-17, -3.567118576363887e-18, -1.127589396210928e-20,  2.487631386512406e-23,  2.945639763326235e-25,  5.573020564247212e-28,
  1.723775819255487e+00, -1.707850292928954e-03, -5.991817652385929e-06, -9.144644607377127e-09,  3.135409262478984e-11,  2.426296592765948e-13,  4.864757066192856e-16,
 -2.017013244910151e-18, -1.681136235686567e-20, -3.341980661622527e-23,  1.777259598430106e-25,  1.414912509209959e-27,  1.783724955419031e+00, -1.422235020749203e-03,
 -5.694586767078788e-06, -1.320814720751045e-08,  5.855236891403543e-12,  2.061050356765452e-13,  8.709259726699381e-16,  7.101267499053870e-19, -1.205117020668377e-20,
 -7.293990252067929e-23, -1.326275382291815e-25,  7.826333805533156e-28,  1.838478498411624e+00, -1.123352262104504e-03, -5.044308852212255e-06, -1.545309791968881e-08,
 -2.015716710190827e-11,  1.076701752477518e-13,  8.896528954232610e-16,  3.069448264958496e-18,  1.230024694821653e-21, -5.080286886172427e-23, -3.178949043798089e-25,
 -8.369113322750979e-28,  1.886930382570839e+00, -8.261853817324665e-04, -4.090042702329095e-06, -1.532144344795016e-08, -3.918173264806610e-11, -1.753161702526903e-14,
  5.011178797243613e-16,  3.383479082337963e-18,  1.233116343244785e-20,  1.551172965011946e-23, -1.392509711828410e-25, -1.226466450615866e-27,  1.927970725512721e+00,
 -5.487456281484550e-04, -2.943480922208045e-06, -1.279558164321530e-08, -4.503298516533579e-11, -1.133532475553684e-13, -6.012992181625560e-17,  1.464353267563171e-18,
  1.113739818030483e-20,  5.114409655300922e-23,  1.513186375637348e-25,  8.454155626410088e-29,  1.960550032975159e+00, -3.106630862234515e-04, -1.773581831726369e-06,
 -8.587644859500895e-09, -3.651268619083241e-11, -1.352204831275868e-13, -4.117989862635235e-16, -8.135500782358503e-19,  9.603639021003367e-22,  2.148510221010729e-23,
  1.450220081762723e-25,  7.064364939697092e-28,  1.983755889484766e+00, -1.309727185844988e-04, -7.811701899775142e-07, -4.066192653045960e-09, -1.937821747428723e-11,
 -8.599579972509313e-14, -3.564904980101853e-16, -1.370420548096647e-18, -4.779772739826794e-21, -1.430668536509720e-23, -3.040836564094737e-26,  1.021904050515006e-29,
  1.996896209226804e+00, -2.536165094548022e-05, -1.550274894900554e-07, -8.395145188124023e-10, -4.244321202192907e-12, -2.049652072338770e-14, -9.566271559256604e-17,
 -4.343504334847583e-19, -1.925731826079159e-21, -8.353720646818458e-24, -3.548402453318789e-26, -1.475536360414014e-28,  };
  constexpr double w[17664] = {  6.753257840753607e-02, -1.909157118462466e-04,  5.641814726984915e-07, -1.725592537778228e-09,  5.405587075663942e-12,
 -1.718852610032908e-14,  5.510301108067322e-17, -1.772672756028853e-19,  5.705295959542973e-22, -1.833679861647983e-24,  5.878884048613919e-27, -1.879073411350058e-29,
  6.730484818788803e-02, -2.649599281120348e-04,  1.214728901405342e-06, -5.647005976231581e-09,  2.564532228544390e-11, -1.133099114336619e-13,  4.885542932662288e-16,
 -2.063113995455754e-18,  8.558567112587076e-21, -3.495860764262585e-23,  1.408525522405833e-25, -5.605928640764504e-28,  6.685265625355148e-02, -4.112309369816489e-04,
  2.740634588494330e-06, -1.699122402051842e-08,  9.881354027164045e-11, -5.472282346949445e-13,  2.915216815618052e-15, -1.504024178339508e-17,  7.551051331056945e-20,
 -3.702506584613940e-22,  1.778037597305471e-24, -8.381273804357013e-27,  6.618243768544349e-02, -6.261604395245036e-04,  5.574861150155816e-06, -4.375928404948985e-08,
  3.147579699001367e-10, -2.121777226532727e-12,  1.358652802062188e-14, -8.339521343192912e-17,  4.938837818173499e-19, -2.835826901549543e-21,  1.584705520343784e-23,
 -8.644200117524924e-26,  6.530359538564265e-02, -9.045587216442164e-04,  1.032645760258989e-05, -1.002757440367324e-07,  8.743004769676777e-10, -7.037463198833296e-12,
  5.318661202982699e-14, -3.817240111828199e-16,  2.622866480523762e-18, -1.735824515652654e-20,  1.111632782121015e-22, -6.914001946910648e-25,  6.422821433953273e-02,
 -1.239800026363846e-03,  1.773547938330882e-05, -2.095164475377197e-07,  2.180236645690672e-09, -2.065579655102535e-11,  1.817907057636225e-13, -1.506366572500599e-15,
  1.186494701850198e-17, -8.946613426908516e-20,  6.493513784981913e-22, -4.555997459383365e-24,  6.297070278408774e-02, -1.624053996767278e-03,  2.861820990216669e-05,
 -4.055130876188221e-07,  4.972947252356976e-09, -5.481999712636524e-11,  5.558833179510957e-13, -5.265095456994601e-15,  4.708965459223006e-17, -4.009056042817564e-19,
  3.269231289743095e-21, -2.565877536310476e-23,  6.154737726006827e-02, -2.048551223531001e-03,  4.380663194437668e-05, -7.353598559788451e-07,  1.051358367387673e-08,
 -1.335532597942546e-10,  1.546462613076203e-12, -1.660361367377338e-14,  1.672945437128836e-16, -1.596101229562677e-18,  1.451847313191630e-20, -1.265867668098119e-22,
  5.997601047890290e-02, -2.503869652663822e-03,  6.408639114361504e-05, -1.260363566158651e-06,  2.080956249875027e-08, -3.020410734357948e-10,  3.962998865118554e-12,
 -4.788436728618561e-14,  5.398606558526357e-16, -5.734816726162671e-18,  5.783060850820901e-20, -5.568359018669635e-22,  5.827536167464145e-02, -2.980228228417849e-03,
  9.013743832334249e-05, -2.055955809914646e-06,  3.886634903342657e-08, -6.396982728077113e-10,  9.444961333073579e-12, -1.276117047783390e-13,  1.600193987522016e-15,
 -1.881887305385326e-17,  2.092417000571271e-19, -2.213374371665959e-21,  5.646470866126491e-02, -3.467774636752531e-03,  1.224811562838269e-04, -3.210113316883354e-06,
  6.893817184053569e-08, -1.277745211999606e-09,  2.109601498578247e-11, -3.168719605312798e-13,  4.395367218144539e-15, -5.693315259279834e-17,  6.945612424885944e-19,
 -8.033765956907534e-21,  5.456339929210776e-02, -3.956855279239003e-03,  1.614371229936692e-04, -4.820193936617011e-06,  1.167406771782321e-07, -2.421033458682523e-09,
  4.443884727333064e-11, -7.380938630040414e-13,  1.126883516833683e-14, -1.600109210578370e-16,  2.132259636236804e-18, -2.685289533661502e-20,  5.259043761242092e-02,
 -4.438257492991223e-03,  2.070918126074312e-04, -6.988270146120291e-06,  1.895827846875517e-07, -4.372898756857234e-09,  8.875288026489434e-11, -1.621917867622277e-12,
  2.712884892582933e-14, -4.204363635752436e-16,  6.094415102914090e-18, -8.323455270408589e-20,  5.056411695062387e-02, -4.903416349390363e-03,  2.592805760972910e-04,
 -9.815208620238875e-06,  2.963747971962414e-07, -7.560684323698067e-09,  1.688158009216844e-10, -3.378477590709775e-12,  6.163988212369793e-14, -1.038353752362862e-15,
  1.630905326538205e-17, -2.406632537856233e-19,  4.850170877569546e-02, -5.344580907545438e-03,  3.175832644675971e-04, -1.339388421645620e-05,  4.474759528860909e-07,
 -1.255844774804811e-08,  3.069994122743262e-10, -6.698578103805573e-12,  1.327604623247060e-13, -2.421484114463416e-15,  4.106021129377688e-17, -6.523658381525360e-19,
  4.641921262315667e-02, -5.754937366743294e-03,  3.813329420798394e-04, -1.780201513847255e-05,  6.543568836294154e-07, -2.010246098995778e-08,  5.355732922451491e-10,
 -1.268742369876631e-11,  2.720827897935042e-13, -5.353543846322072e-15,  9.766090202352023e-17, -1.665080456720626e-18,  4.433116900169297e-02, -6.128688976846907e-03,
  4.496363532224321e-04, -2.309515433269395e-05,  9.290696698222765e-07, -3.109466058361799e-08,  8.989561967479612e-10, -2.302821234739181e-11,  5.323572161059484e-13,
 -1.126006781517718e-14,  2.202478584723879e-16, -4.016896825025485e-18,  4.225053413639861e-02, -6.461094683112669e-03,  5.214041995311403e-04, -2.930036801837111e-05,
  1.283538376862971e-06, -4.658938803963770e-08,  1.455542561672477e-09, -4.016501965634180e-11,  9.973529141734807e-13, -2.260048275059039e-14,  4.724874796290264e-16,
 -9.189875334038903e-18,  4.018861282988445e-02, -6.748470201492908e-03,  5.953888850405815e-04, -3.641107938074326e-05,  1.728703662364657e-06, -6.775967985989789e-08,
  2.278642790996809e-09, -6.748453095980791e-11,  1.793773486348712e-12, -4.340674532118917e-14,  9.669287172098015e-16, -1.999764627424986e-17,  3.815504371894285e-02,
 -6.988156486678009e-03,  6.702271939463339e-04, -4.438346254450119e-05,  2.273573699069283e-06, -9.584101320662965e-08,  3.456035884383853e-09, -1.094656846391401e-10,
  3.104306009603629e-12, -7.996785349906597e-14,  1.892459929241883e-15, -4.149964991744761e-17,  3.615782980655909e-02, -7.178461355256118e-03,  7.444853693510205e-04,
 -5.313465104039198e-05,  2.924247982935543e-06, -1.320526588901745e-07,  5.087662757354971e-09, -1.717571828516737e-10,  5.180081695734704e-12, -1.416235437959659e-13,
  3.550358368238251e-15, -8.232475013400592e-17,  3.420340634239490e-02, -7.318580384512249e-03,  8.167042307646097e-04, -6.254288971304927e-05,  3.682988884834503e-06,
 -1.774994038629096e-07,  7.281101513008463e-09, -2.611375424972759e-10,  8.349979707962523e-12, -2.415800483703888e-13,  6.397540587369311e-15, -1.564423034646603e-16,
  3.229673785603360e-02, -7.408503175897012e-03,  8.854422660314129e-04, -7.244962288486735e-05,  4.547417129479480e-06, -2.330590727506489e-07,  1.014466287086230e-08,
 -3.853133055976719e-10,  1.302348960169063e-11, -3.976010434572183e-13,  1.109275978947646e-14, -2.853239767574997e-16,  3.044143633537758e-02, -7.448910722135588e-03,
  9.493150175696222e-04, -8.266338649271231e-05,  5.509901663978762e-06, -2.992636646910444e-07,  1.377821159237793e-08, -5.525200366263769e-10,  1.968348034026913e-11,
 -6.323683722147330e-13,  1.853785547577664e-14, -5.002875864614416e-16,  2.863989309096250e-02, -7.441069028712874e-03,  1.007029511623400e-03, -9.296526713547462e-05,
  6.557202320363482e-06, -3.761837102848427e-07,  1.826213090688421e-08, -7.709085310144268e-10,  2.886542350855029e-11, -9.732650546540056e-13,  2.990230895337155e-14,
 -8.446129987853531e-16,  2.689341765385445e-02, -7.386723395446293e-03,  1.057412914966988e-03, -1.031156126154405e-04,  7.670406630531953e-06, -4.633263912517459e-07,
  2.364516374571187e-08, -1.047724472471542e-09,  4.112055158162650e-11, -1.451325316156409e-12,  4.661623789922740e-14, -1.374799578052520e-15,  2.520237802225274e-02,
 -7.287996937763914e-03,  1.099435015040789e-03, -1.128616294449200e-04,  8.825181888807119e-06, -5.595578990366106e-07,  2.993214359351410e-08, -1.388321194829655e-09,
  5.696215865345683e-11, -2.099139367838025e-12,  7.031578379715954e-14, -2.160149013420582e-15,  2.356633761230085e-02, -7.147296085498914e-03,  1.132224483623552e-03,
 -1.219454827313302e-04,  9.992342025822122e-06, -6.630594023371120e-07,  3.707282636576660e-08, -1.795078343505195e-09,  7.679668177552737e-11, -2.947604828664634e-12,
  1.027268421600477e-13, -3.279780009019889e-15,  2.198418530881708e-02, -6.967224991756116e-03,  1.155079185852163e-03, -1.301125201959535e-04,  1.113870795341915e-05,
 -7.713239302826837e-07,  4.495311766915958e-08, -2.266329217158083e-09,  1.008440807969183e-10, -4.021581575215459e-12,  1.454791684217942e-13, -4.816290510893686e-15,
  2.045425599512994e-02, -6.750510053904230e-03,  1.167471028379604e-03, -1.371192704077337e-04,  1.222822141363060e-05, -8.811986448284864e-07,  5.338993470027495e-08,
 -2.795421255967076e-09,  1.290549584995215e-10, -5.334718043753448e-12,  1.998532695980122e-13, -6.845639279961056e-15,  1.897443982806691e-02, -6.499935117592736e-03,
  1.169046001976128e-03, -1.427409101849360e-04,  1.322325728497891e-05, -9.889736371097756e-07,  6.213074297655673e-08, -3.370042954980316e-09,  1.610343282520451e-10,
 -6.883945714144363e-12,  2.664763597614491e-13, -9.423438049753839e-15,  1.754227928997965e-02, -6.218287415344515e-03,  1.159620169323330e-03, -1.467779517626090e-04,
  1.408606858424332e-05, -1.090514845535992e-06,  7.085847688514127e-08, -3.971943229746266e-09,  1.959834237535795e-10, -8.644344250254273e-12,  3.449990833063455e-13,
 -1.256867815340275e-14,  1.615505368339244e-02, -5.908313886154778e-03,  1.139172386101191e-03, -1.490619612133939e-04,  1.478029240806494e-05, -1.181435273228999e-06,
  7.920211796841015e-08, -4.577144778764249e-09,  2.326710142890444e-10, -1.056521690262904e-11,  4.337987886252379e-13, -1.624683515466400e-14,  1.480985123503205e-02,
 -5.572687226376959e-03,  1.107834532804566e-03, -1.494601808829835e-04,  1.527244372185464e-05, -1.257295668590493e-06,  8.675270727350090e-08, -5.156712470361879e-09,
  2.694440713412267e-10, -1.256824220588726e-11,  5.297644456854292e-13, -2.035510941982164e-14,  1.350362935220735e-02, -5.213980824413295e-03,  1.065879986951792e-03,
 -1.478789863361708e-04,  1.553332681413221e-05, -1.313823463296805e-06,  9.308405734713269e-08, -5.678084779671492e-09,  3.042843042921837e-10, -1.454845478505120e-11,
  6.282196100503185e-13, -2.471304397834242e-14,  1.223326383875415e-02, -4.834651618584243e-03,  1.013710991177902e-03, -1.442661596405635e-04,  1.553930073458217e-05,
 -1.347137205753822e-06,  9.777695715935149e-08, -6.106916343214095e-09,  3.349122976714345e-10, -1.637854772111515e-11,  7.230309057333806e-13, -2.906170534731851e-14,
  1.099558804631952e-02, -4.437029873910633e-03,  9.518454819418886e-04, -1.386120039379278e-04,  1.527334431831020e-05, -1.353963076629484e-06,  1.004452774273215e-07,
 -6.409319617315837e-09,  3.589352576535591e-10, -1.791660031014406e-11,  8.069298172786357e-13, -3.307388691390996e-14,  9.787423027687488e-03, -4.023314884482668e-03,
  8.809038446930066e-04, -1.309493583362004e-04,  1.472587760927942e-05, -1.331830341397980e-06,  1.007621238817265e-07, -6.554340685112438e-09,  3.740284328236802e-10,
 -1.901686360608226e-11,  8.720468066180584e-13, -3.637639518404496e-14,  8.605599791667107e-03, -3.595575660353278e-03,  8.015959613679468e-04, -1.213525972076163e-04,
  1.389530880412354e-05, -1.279233728718761e-06,  9.848407892444768e-08, -6.516465204327868e-09,  3.781349396694458e-10, -1.954274859149452e-11,  9.106227434400352e-13,
 -3.858356068841718e-14,  7.446974757559977e-03, -3.155755742184435e-03,  7.147088209877526e-04, -1.099357147340214e-04,  1.278828851121914e-05, -1.195752612922887e-06,
  9.347163016417128e-08, -6.277930682968460e-09,  3.696648048350536e-10, -1.938073619549169e-11,  9.158288915122522e-13, -3.933898091273029e-14,  6.308439513588879e-03,
 -2.705681404715537e-03,  6.210948804358129e-04, -9.684960552385813e-05,  1.141966559187539e-05, -1.082119376173692e-06,  8.570410474862738e-08, -5.830623998941187e-09,
  3.476721987000254e-10, -1.845364088137561e-11,  8.825995156154975e-13, -3.836055802999390e-14,  5.186926125856606e-03, -2.247072703881501e-03,  5.216613046756100e-04,
 -8.227865863072145e-05,  9.812150877347954e-06, -9.402322752262147e-07,  7.528779549563019e-08, -5.177369205567994e-09,  3.119904959600736e-10, -1.673157089197514e-11,
  8.083664022768456e-13, -3.548256815281772e-14,  4.079410117208949e-03, -1.781557343921331e-03,  4.173602464341105e-04, -6.643679673263715e-05,  7.995707511059747e-06,
 -7.731114679906050e-07,  6.245645835881085e-08, -4.332458961128688e-09,  2.633080831395784e-10, -1.423907323775122e-11,  6.935864370359018e-13, -3.068814978104477e-14,
  2.982918758218411e-03, -1.310689916040051e-03,  3.091808568332328e-04, -4.956318260651207e-05,  6.006707472130322e-06, -5.848011760515052e-07,  4.756400701329128e-08,
 -3.321353639219753e-09,  2.031737533029978e-10, -1.105734265071372e-11,  5.419740066688341e-13, -2.412645048353636e-14,  1.894602936294087e-03, -8.360015860725614e-04,
  1.981490078478800e-04, -3.191867095426040e-05,  3.887006993672467e-06, -3.802343495907970e-07,  3.107066140587519e-08, -2.179606648120644e-09,  1.339314233072460e-10,
 -7.321131789933105e-12,  3.603955130651848e-13, -1.611104349831191e-14,  8.129868354418024e-04, -3.595727521869651e-04,  8.545182035132247e-05, -1.380204235858401e-05,
  1.685295236418714e-06, -1.652944284620196e-07,  1.354203932391459e-08, -9.523956159837303e-10,  5.866861348791322e-11, -3.214873466338411e-12,  1.586374381977114e-13,
 -7.108306587123993e-15,  6.677781336055903e-02, -1.864836438547446e-04,  5.439821824089089e-07, -1.641783105650828e-09,  5.074649643140942e-12, -1.592361201601388e-14,
  5.038551519706437e-17, -1.600227111514299e-19,  5.085581078870721e-22, -1.614248747594753e-24,  5.111961032831783e-27, -1.614108911520441e-29,  6.626402459123645e-02,
 -2.555063458473232e-04,  1.149354007384625e-06, -5.254192429274468e-09,  2.349185309033192e-11, -1.022479920668774e-13,  4.344396254517444e-16, -1.808335068940704e-18,
  7.395799011885026e-21, -2.978818580793257e-23,  1.183666631898916e-25, -4.646747597103206e-28,  6.525032820403688e-02, -3.900953695243692e-04,  2.545876763619139e-06,
 -1.549410087473190e-08,  8.853587695395299e-11, -4.820553488817876e-13,  2.526008800200161e-15, -1.282413306858808e-17,  6.337756600611801e-20, -3.059871766614664e-22,
  1.447222794406391e-24, -6.720270531945639e-27,  6.376378475551912e-02, -5.835794956013050e-04,  5.078621428714574e-06, -3.904568701365592e-08,  2.754028965127753e-10,
 -1.822025596294363e-12,  1.145820545694120e-14, -6.910909655496993e-17,  4.023434568323891e-19, -2.271919400118978e-21,  1.248946612998245e-23, -6.703888078859885e-26,
  6.184328503887244e-02, -8.265327505281973e-04,  9.202651920281489e-06, -8.734704565899988e-08,  7.454969229070013e-10, -5.880307626042797e-12,  4.358523148215159e-14,
 -3.069885958791420e-16,  2.071182255790184e-18, -1.346528791580840e-20,  8.474433079054610e-23, -5.181673155536792e-25,  5.953765632769591e-02, -1.107409881280632e-03,
  1.541768238383270e-05, -1.777141387251057e-07,  1.807543770915101e-09, -1.675886115471090e-11,  1.444773389267092e-13, -1.173575145424890e-15,  9.067111078052691e-18,
 -6.709882148909029e-20,  4.781770288690802e-22, -3.295502881598628e-24,  5.690336455637533e-02, -1.413299158029973e-03,  2.419549270332349e-05, -3.340394818597411e-07,
  3.998844609385110e-09, -4.309007856173186e-11,  4.275550213726198e-13, -3.965963748175634e-15,  3.476200968955246e-17, -2.902127540474973e-19,  2.321877618409235e-21,
 -1.788742064972081e-23,  5.400197630037989e-02, -1.730726388425390e-03,  3.590959771004591e-05, -5.866422770345861e-07,  8.178927381234468e-09, -1.014613737841577e-10,
  1.148611429616367e-12, -1.206751786077557e-14,  1.190715748770822e-16, -1.113216278078929e-18,  9.928381065324191e-21, -8.491852512842796e-23,  5.089755177117752e-02,
 -2.046443430193547e-03,  5.077597289437672e-05, -9.709924206306714e-07,  1.562059295409048e-08, -2.212420243287569e-10,  2.835982713216467e-12, -3.350952870945832e-14,
  3.697443562788931e-16, -3.846677750144388e-18,  3.801313399623583e-20, -3.588786166500606e-22,  4.765413177031446e-02, -2.348140912283431e-03,  6.881174751727703e-05,
 -1.525247965686007e-06,  2.807719506963088e-08, -4.506830607896189e-10,  6.497372457574428e-12, -8.580292344251916e-14,  1.052504593916290e-15, -1.211715487771594e-17,
  1.319739645686059e-19, -1.368283733139893e-21,  4.433345982487290e-02, -2.625036984383426e-03,  8.981605520785173e-05, -2.286785772319995e-06,  4.780239653934374e-08,
 -8.637341378886240e-10,  1.391916587895324e-11, -2.042747921210507e-13,  2.770895451710884e-15, -3.512453168344842e-17,  4.196274476933265e-19, -4.755972172029351e-21,
  4.099304907442015e-02, -2.868309753128164e-03,  1.133741559599208e-04, -3.288116555563717e-06,  7.750131253590939e-08, -1.566539223843443e-09,  2.805987613367687e-11,
 -4.552613575241552e-13,  6.795716656705423e-15, -9.441597600514690e-17,  1.231884963128273e-18, -1.519923198006041e-20,  3.768466617007920e-02, -3.071358399102552e-03,
  1.388829964130003e-04, -4.552715293167119e-06,  1.202002278603999e-07, -2.702161327941086e-09,  5.351552462837442e-11, -9.552618724175635e-13,  1.562076870376952e-14,
 -2.368556250515628e-16,  3.361444861994750e-18, -4.497581346652121e-20,  3.445326586061844e-02, -3.229894648090118e-03,  1.655939685323749e-04, -6.091340502049990e-06,
  1.790347539500487e-07, -4.451887138898225e-09,  9.700382428101687e-11, -1.896367929334733e-12,  3.382724638813865e-14, -5.575543929623720e-16,  8.574450626298211e-18,
 -1.239640685198408e-19,  3.133637399639039e-02, -3.341880511620275e-03,  1.926670374037726e-04, -7.899357348318835e-06,  2.569709033666963e-07, -7.031589337587477e-09,
  1.677820763873072e-10, -3.576865084153863e-12,  6.932196290734677e-14, -1.237357860121538e-15,  2.054673016451229e-17, -3.198842714941789e-19,  2.836388641181907e-02,
 -3.407338801567569e-03,  2.192297518767111e-04, -9.955436398509611e-06,  3.564870159979757e-07, -1.068212250380416e-08,  2.778893549563853e-10, -6.433950352884075e-12,
  1.349635879123396e-13, -2.599504383468698e-15,  4.645098789008582e-17, -7.762542293989195e-19,  2.555822846683741e-02, -3.428069291476322e-03,  2.444348853146739e-04,
 -1.222180329746010e-05,  4.792538649446348e-07, -1.565355069385011e-08,  4.420959268267098e-10, -1.107333412363737e-11,  2.505006472889428e-13, -5.188564246509955e-15,
  9.944952716560131e-17, -1.778407265328299e-18,  2.293480569999544e-02, -3.407305584556334e-03,  2.675114108384245e-04, -1.464600274090168e-05,  6.258535907723396e-07,
 -2.218401481695612e-08,  6.774587060556582e-10, -1.828861145821324e-11,  4.446201389347343e-13, -9.871135545849557e-15,  2.023132294901228e-16, -3.859990839092821e-18,
  2.050266980719869e-02, -3.349346288838137e-03,  2.878049524050403e-04, -1.716394915947405e-05,  7.955746880572407e-07, -3.047505095036915e-08,  1.002422810032276e-09,
 -2.906230451352298e-11,  7.567650754151338e-13, -1.795176153749832e-14,  3.922524455021443e-16, -7.961986291468024e-18,  1.826532495836465e-02, -3.259189853141292e-03,
  3.048055014959356e-04, -1.970389457609979e-05,  9.863108384270413e-07, -4.066596043411148e-08,  1.435471765689949e-09, -4.454093557805596e-11,  1.238254987605365e-12,
 -3.128958435456420e-14,  7.267802264313998e-16, -1.565141084346974e-17,  1.622160575090537e-02, -3.142196388547762e-03,  3.181618022351470e-04, -2.219086690746045e-05,
  1.194577833380246e-06, -5.281024196148712e-08,  1.993402631468682e-09, -6.597868392735443e-11,  1.952174738223498e-12, -5.239265568742725e-14,  1.290032232982838e-15,
 -2.939560086703335e-17,  1.436656811792617e-02, -3.003792979370808e-03,  3.276831929341529e-04, -2.455112223050517e-05,  1.415647681599806e-06, -6.685703635691509e-08,
  2.689373577550808e-09, -9.464802643028535e-11,  2.971520717475183e-12, -8.445966843950079e-14,  2.198484434137759e-15, -5.286952569466764e-17,  1.269234654474533e-02,
 -2.849232229250196e-03,  3.333307280258981e-04, -2.671620365981606e-05,  1.643784829680239e-06, -8.264001394257085e-08,  3.530926102058713e-09, -1.317207634297358e-10,
  4.375232379071765e-12, -1.313356489264815e-13,  3.604534214467884e-15, -9.124921006942363e-17,  1.118894350532129e-02, -2.683407736597716e-03,  3.352000424752903e-04,
 -2.862629125659555e-05,  1.872558366234823e-06, -9.987524959912213e-08,  4.518210693615418e-09, -1.781281522984682e-10,  6.241990265605660e-12, -1.973511299232302e-13,
  5.696079264100652e-15, -1.514180806868128e-16,  9.844928943758720e-03, -2.510725258094289e-03,  3.334986748806439e-04, -3.023264216828857e-05,  2.095197456548691e-06,
 -1.181685419109751e-07,  5.642637472110808e-09, -2.344135145342921e-10,  8.642000580415152e-12, -2.870248310986359e-13,  8.690192018598944e-15, -2.419916469534079e-16,
  8.648038094483893e-03, -2.335024684719594e-03,  3.285204946600701e-04, -3.149903882481693e-05,  2.304955482279764e-06, -1.370315250371891e-07,  6.886132886341649e-09,
 -3.005937170740703e-10,  1.162735790519676e-11, -4.046276705023813e-13,  1.281936814790350e-14, -3.730577735636744e-16,  7.585664506826083e-03, -2.159545621983885e-03,
  3.206195676054590e-04, -3.240226975748143e-05,  2.495451017731840e-06, -1.559049661310409e-07,  8.221116868249616e-09, -3.760467027068389e-10,  1.522191447905509e-11,
 -5.536289731411067e-13,  1.830967628863347e-14, -5.555428799384745e-16,  6.645251661616389e-03, -1.986928200786447e-03,  3.101853348414138e-04, -3.293175178611669e-05,
  2.660959829916465e-06, -1.741869638757046e-07,  9.611233295179230e-09, -4.594405293025877e-10,  1.941181953662807e-11, -7.360703895145285e-13,  2.535139845795718e-14,
 -8.001536486969812e-16,  5.814591110962804e-03, -1.819240533287440e-03,  2.976204583462557e-04, -3.308845872129031e-05,  2.796640192682668e-06, -1.912634305545187e-07,
  1.101278336676063e-08, -5.487154076716181e-10,  2.413797398476614e-11, -9.519347237782699e-13,  3.406425809718978e-14, -1.115908734491456e-15,  5.082037860511426e-03,
 -1.658024721987429e-03,  2.833221713640027e-04, -3.288334999966105e-05,  2.898682568325256e-06, -2.065382535067637e-07,  1.237673887604406e-08, -6.411246347496112e-10,
  2.929154960043101e-11, -1.198591077582669e-12,  4.446082497095780e-14, -1.508358236174600e-15,  4.436655051956423e-03, -1.504354286488053e-03,  2.676675138804972e-04,
 -3.233549612797857e-05,  2.964382935288051e-06, -2.194608415449800e-07,  1.365115965524927e-08, -7.333339832866082e-10,  3.471345550904333e-11, -1.470400977473901e-12,
  5.641285983673198e-14, -1.977676602755014e-15,  3.868300225451017e-03, -1.358897076684888e-03,  2.510024611783393e-04, -3.147008200660489e-05,  2.992145858370819e-06,
 -2.295492828112282e-07,  1.478381177386267e-08, -8.215729758107822e-10,  4.019823544265777e-11, -1.758560854981489e-12,  6.962593625705273e-14, -2.516889279167421e-15,
  3.367664867355210e-03, -1.221979021370728e-03,  2.336346789093023e-04, -3.031644056501601e-05,  2.981428317626034e-06, -2.364079730407747e-07,  1.572478096094483e-08,
 -9.018263703325040e-10,  4.550240614319803e-11, -2.051234996121435e-12,  8.362745926216733e-14, -3.110536392918511e-15,  2.926277860841241e-03, -1.093645291984160e-03,
  2.158294590476966e-04, -2.890623388257991e-05,  2.932638198904878e-06, -2.397392215648840e-07,  1.642889598027417e-08, -9.700507039212594e-10,  5.035676849401552e-11,
 -2.334002583542834e-12,  9.777213331868468e-14, -3.734073610629059e-15,  2.536482086795757e-03, -9.737165612622358e-04,  1.978082962777819e-04, -2.727186235163889e-05,
  2.847002351078221e-06, -2.393489281980602e-07,  1.685781343358309e-08, -1.022399152936671e-09,  5.448180320334958e-11, -2.590606984714238e-12,  1.112671115771668e-13,
 -4.354254041970064e-15,  2.191391947588895e-03, -8.618389622179256e-04,  1.797495376138618e-04, -2.544514840280657e-05,  2.726418568745842e-06, -2.351468936542670e-07,
  1.698166159896804e-08, -1.055438241403554e-09,  5.760495263141027e-11, -2.803959980539132e-12,  1.232167201250574e-13, -4.930628680495670e-15,  1.884838133068299e-03,
 -7.575270898090769e-04,  1.617905615692002e-04, -2.345631238317754e-05,  2.573304193577056e-06, -2.271426518367632e-07,  1.678018940155911e-08, -1.066341775384644e-09,
  5.947841946421427e-11, -2.957322990999620e-12,  1.326841264217174e-13, -5.418159259929920e-15,  1.611304599098094e-03, -6.601999422876854e-04,  1.440310000600676e-04,
 -2.133323560960432e-05,  2.390451682566501e-06, -2.154378902381043e-07,  1.624341151404996e-08, -1.053050351604589e-09,  5.989608871567257e-11, -3.035565398801822e-12,
  1.387649773575109e-13, -5.770777405019183e-15,  1.365861531437838e-03, -5.692100910443960e-04,  1.265365919119377e-04, -1.910098964278283e-05,  2.180898861048576e-06,
 -2.002165687430728e-07,  1.537177762638090e-08, -1.014388368941043e-09,  5.870828925067750e-11, -3.026389201837216e-12,  1.406662087253924e-13, -5.945572605864837e-15,
  1.144097043153394e-03, -4.838666234401150e-04,  1.093433399202822e-04, -1.678160095944849e-05,  1.947818976096233e-06, -1.817337828554443e-07,  1.417592072233055e-08,
 -9.501341720983573e-10,  5.583332729044334e-11, -2.921410200774352e-12,  1.377821821413386e-13, -5.907173561174977e-15,  9.420495075176139e-04, -4.034525526595938e-04,
  9.246172596467741e-05, -1.439401555997283e-05,  1.694433317303658e-06, -1.603042759850153e-07,  1.267605516645951e-08, -8.610423802446855e-10,  5.126501205504692e-11,
 -2.716997987083224e-12,  1.297601795889514e-13, -5.631822871043207e-15,  7.561417659824783e-04, -3.272374664038655e-04,  7.588081690514448e-05, -1.195422776140396e-05,
  1.423947236591143e-06, -1.362913206940470e-07,  1.090110156413567e-08, -7.488203419838587e-10,  4.507571719824182e-11, -2.414798226215495e-12,  1.165480956229348e-13,
 -5.110646027971778e-15,  5.831180357415940e-04, -2.544862524315142e-04,  5.957217334636724e-05, -9.475541696001530e-06,  1.139509093736489e-06, -1.100965042631604e-07,
  8.887614800914827e-09, -6.160629657847780e-10,  3.741485403377492e-11, -2.021888726044340e-12,  9.841882185876011e-14, -4.351684991995243e-15,  4.199846940365305e-04,
 -1.844650534859549e-04,  4.349360951167022e-05, -6.968950987171365e-06,  8.441920945260111e-07, -8.215090163099881e-08,  6.678595722786082e-09, -4.661525207452210e-10,
  2.850298753173312e-11, -1.550554678917870e-12,  7.596822246122882e-14, -3.380401294945355e-15,  2.639628080392280e-04, -1.164486583900904e-04,  2.759363398356563e-05,
 -4.443745921130795e-06,  5.410127490710265e-07, -5.290935530244273e-08,  4.322371563087025e-09, -3.031390477103342e-10,  1.862259273235751e-11, -1.017727599991884e-12,
  5.008758915042329e-14, -2.238586568728150e-15,  1.126060795842068e-04, -4.979810547211111e-05,  1.183280215308729e-05, -1.910945818491331e-06,  2.333026190902597e-07,
 -2.287919724199181e-08,  1.874157673030768e-09, -1.317891217399866e-10,  8.117247742325437e-12, -4.447422207986298e-13,  2.194281651848402e-14, -9.830959894978479e-16,
  6.604045964182577e-02, -1.822092354642972e-04,  5.247576506669864e-07, -1.563072277576857e-09,  4.767916276062084e-12, -1.476634065516244e-14,  4.612425052530793e-17,
 -1.446405420360320e-19,  4.539609274862237e-22, -1.423285371569734e-24,  4.452593388879579e-27, -1.389033719454891e-29,  6.525999837384171e-02, -2.465574770607444e-04,
  1.088493221620985e-06, -4.894132695873706e-09,  2.154719157894919e-11, -9.240325759685359e-14,  3.869646383646431e-16, -1.587952222479267e-18,  6.403943823014642e-21,
 -2.543817914366119e-23,  9.970527925684362e-26, -3.861404224019720e-28,  6.372953626046661e-02, -3.704487024124707e-04,  2.368139186708160e-06, -1.415147987300940e-08,
  7.947306957255937e-11, -4.255206658784958e-13,  2.193746649642855e-15, -1.096168044846144e-17,  5.333653286612623e-20, -2.536029202817681e-22,  1.181554518398198e-24,
 -5.405870874608088e-27,  6.150785946555529e-02, -5.447524831287087e-04,  4.635355988480629e-06, -3.491645594377647e-08,  2.415628248746804e-10, -1.568866711322865e-12,
  9.691760403168150e-15, -5.745179797196275e-17,  3.288788251806334e-19, -1.826678222908983e-21,  9.880554862808700e-24, -5.219807460773691e-26,  5.867803302677506e-02,
 -7.569100009895656e-04,  8.222350504862270e-06, -7.630590227441591e-08,  6.376918631169517e-10, -4.930346420828977e-12,  3.584898460523829e-14, -2.478546595016503e-16,
  1.642326929619877e-18, -1.049102257384082e-20,  6.489961060877845e-23, -3.901929177692893e-25,  5.534185543519209e-02, -9.921313515876531e-04,  1.344815717813411e-05,
 -1.512970676324533e-07,  1.504539874503300e-09, -1.365504628422324e-11,  1.153409250048026e-13, -9.186510148863532e-16,  6.963545149517753e-18, -5.058527379181106e-20,
  3.540312258812990e-22, -2.397128880919054e-24,  5.161336235546424e-02, -1.234743479145712e-03,  2.054417656776586e-05, -2.764304610568290e-07,  3.231272321591711e-09,
 -3.404467136263144e-11,  3.306301884683654e-13, -3.004250861549181e-15,  2.581232391123160e-17, -2.113621697567639e-19,  1.659430435767689e-21, -1.255080754725878e-23,
  4.761198847465896e-02, -1.469528798514172e-03,  2.959265840624562e-05, -4.706230545768860e-07,  6.400075017807400e-09, -7.755328300559674e-11,  8.585471303342417e-13,
 -8.828549836158532e-15,  8.532662652047775e-17, -7.818773605099086e-19,  6.838516136798410e-21, -5.738850886568723e-23,  4.345598157587630e-02, -1.682908234871039e-03,
  4.048878310111966e-05, -7.530600338416903e-07,  1.180679139519589e-08, -1.632188262268459e-10,  2.044469145896777e-12, -2.362827362208120e-14,  2.552102054834442e-16,
 -2.600831729224178e-18,  2.519125107073656e-20, -2.332301157529566e-22,  3.925658041655050e-02, -1.863855624148435e-03,  5.293209907692825e-05, -1.140402758769088e-06,
  2.044638485689268e-08, -3.201394041704550e-10,  4.507468822049128e-12, -5.819061982194270e-14,  6.983820485632835e-16, -7.872277183867607e-18,  8.400259403201501e-20,
 -8.537495270788321e-22,  3.511333583656653e-02, -2.004475932082025e-03,  6.644747587849438e-05, -1.643772631345206e-06,  3.345223416514500e-08, -5.893528789199164e-10,
  9.271661782825737e-12, -1.329679431049389e-13,  1.764059616115242e-15, -2.188709864247806e-17,  2.561008809925019e-19, -2.844540144636450e-21,  3.111079606184543e-02,
 -2.100229011552854e-03,  8.043063283438429e-05, -2.266080860741280e-06,  5.198717803367678e-08, -1.024327157565593e-09,  1.790696661428321e-11, -2.838431858331609e-13,
  4.142986035955719e-15, -5.632677084294312e-17,  7.196531111461375e-19, -8.700063912411121e-21,  2.731661650925878e-02, -2.149825548402069e-03,  9.420965277421446e-05,
 -3.000243580201935e-06,  7.709577478942067e-08, -1.689310653845871e-09,  3.264919106533789e-11, -5.693120144200447e-13,  9.102194760970647e-15, -1.350445657840481e-16,
  1.876574840165555e-18, -2.459997768627563e-20,  2.378101233767099e-02, -2.154856294470048e-03,  1.071122116869835e-04, -3.828662365516406e-06,  1.095382669058397e-07,
 -2.655075498568466e-09,  5.645917002559410e-11, -1.078240376544809e-12,  1.880550097463349e-14, -3.032943871038787e-16,  4.567098086544939e-18, -6.469320491635782e-20,
  2.053736318930417e-02, -2.119236260858979e-03,  1.185285860089320e-04, -4.724107697488245e-06,  1.496339663197930e-07, -3.992081372528150e-09,  9.297851827347887e-11,
 -1.936666298162488e-12,  3.670371174628019e-14, -6.411380160296966e-16,  1.042587406780518e-17, -1.590553378554778e-19,  1.760371131112509e-02, -2.048551742454915e-03,
  1.279624634151991e-04, -5.651880506799222e-06,  1.971429441646423e-07, -5.761688077122911e-09,  1.463489723575536e-10, -3.311550004987545e-12,  6.794672746685930e-14,
 -1.281046163898840e-15,  2.242249242463080e-17, -3.672633280507734e-19,  1.498486674391801e-02, -1.949391789335655e-03,  1.350645456360518e-04, -6.572906105948578e-06,
  2.512094968696534e-07, -8.006593238626105e-09,  2.208836913942907e-10, -5.409183031712278e-12,  1.197344001123144e-13, -2.428451868925152e-15,  4.560824481373815e-17,
 -7.996427577097896e-19,  1.267484110503024e-02, -1.828730535612296e-03,  1.396471836440493e-04, -7.447279464320899e-06,  3.103801919637483e-07, -1.074201112200119e-08,
  3.206087277901843e-10, -8.466342238127959e-12,  2.014946975910034e-13, -4.382337368282299e-15,  8.804508067680342e-17, -1.647665624449732e-18,  1.065936573035550e-02,
 -1.693406764804391e-03,  1.416812059307001e-04, -8.237748867516173e-06,  3.726960389095775e-07, -1.394913424747218e-08,  4.487243082587911e-10, -1.273327746030289e-11,
  3.247686430602113e-13, -7.551191425234707e-15,  1.618219977658727e-16, -3.223362699584579e-18,  8.918300299473551e-03, -1.549726123314315e-03,  1.412782646665108e-04,
 -8.912688493607882e-06,  4.358456298223035e-07, -1.757211141740194e-08,  6.070603503857586e-10, -1.844911945183759e-11,  5.027014685607860e-13, -1.245840935733492e-14,
  2.839785607673525e-16, -6.004807596761331e-18,  7.427794771999918e-03, -1.403192550532619e-03,  1.386632425175211e-04, -9.448242028455376e-06,  4.973566738000988e-07,
 -2.151920364023427e-08,  7.956117385784045e-10, -2.581197635263925e-11,  7.490914881325845e-13, -1.973102035355990e-14,  4.770757128988323e-16, -1.068095835344726e-17,
  6.162122526057463e-03, -1.258360718305253e-03,  1.341415593360070e-04, -9.829482671706601e-06,  5.547988476405886e-07, -2.566807858943035e-08,  1.012232676381011e-09,
 -3.494744143098552e-11,  1.077025996322188e-12, -3.006695713820645e-14,  7.691087380897614e-16, -1.818513867618555e-17,  5.095150445506957e-03, -1.118791380952247e-03,
  1.280657716866970e-04, -1.005059424924865e-05,  6.059716123736047e-07, -2.987453347764196e-08,  1.252546820627948e-09, -4.588007349567267e-11,  1.497221706759365e-12,
 -4.417901451864570e-14,  1.192473716383078e-15, -2.970338898361888e-17,  4.201449277753400e-03, -9.870864141134988e-04,  1.208049271211040e-04, -1.011420657544644e-05,
  6.490557214910122e-07, -3.398343360645942e-08,  1.510095941386684e-09, -5.851238649376831e-11,  2.016265274435116e-12, -6.271779123279462e-14,  1.781793839359726e-15,
 -4.664318672077552e-17,  3.457073964728509e-03, -8.649792147874350e-04,  1.127189867318030e-04, -1.003010072653998e-05,  6.827149344055963e-07, -3.784040407885451e-08,
  1.776712148827323e-09, -7.261496457603356e-11,  2.634997276511530e-12, -8.618046322581496e-14,  2.570582764816938e-15, -7.055074629330659e-17,  2.840059528655292e-03,
 -7.534579707658174e-04,  1.041394901231761e-04, -9.813533606468479e-06,  7.061430718390203e-07, -4.130283351794177e-08,  2.043065248786026e-09, -8.782969359094363e-11,
  3.347287145780939e-12, -1.148161538460393e-13,  3.586943193800255e-15, -1.029716644397622e-16,  2.330685160495438e-03, -6.529029519699114e-04,  9.535666455971154e-05,
 -9.483422658366395e-06,  7.190593568365709e-07, -4.424899953583837e-08,  2.299313809167693e-09, -1.036861217686300e-10,  4.139403926431867e-12, -1.485409615332485e-13,
  4.848725694454233e-15, -1.452594456595564e-16,  1.911559548890362e-03, -5.632234243268629e-04,  8.661245880174465e-05, -9.060592900748035e-06,  7.216608446478388e-07,
 -4.658452507969908e-08,  2.535779320710121e-09, -1.196290437732659e-10,  4.990106551903780e-12, -1.868757329324980e-13,  6.358753211756735e-15, -1.983477435469542e-16,
  1.567576361815691e-03, -4.839842648424529e-04,  7.809853198235323e-05, -8.566233429351255e-06,  7.145441481501572e-07, -4.824582782440127e-08,  2.743567384604509e-09,
 -1.350539085459363e-10,  5.871474515342704e-12, -2.289173088192822e-13,  8.100804773359334e-15, -2.625125925823370e-16,  1.285782061485473e-03, -4.145163509553021e-04,
  6.995802265557139e-05, -8.020651577881042e-06,  6.986096648305460e-07, -4.920064599335905e-08,  2.915075376604065e-09, -1.493458191482453e-10,  6.750396113132059e-12,
 -2.733496549323597e-13,  1.003702101588803e-14, -3.371579750353098e-16,  1.055190411813726e-03, -3.540080339403983e-04,  6.228991040329297e-05, -7.442359413279176e-06,
  6.749605557488305e-07, -4.944605256518528e-08,  3.044348116988268e-09, -1.619177942080348e-10,  7.590546254762404e-12, -3.184958775650580e-13,  1.210724443304458e-14,
 -4.206598339600545e-16,  8.665702142606882e-04, -3.015774006708444e-04,  5.515490067340843e-05, -6.847484774299327e-06,  6.448064658337502e-07, -4.900457558964601e-08,
  3.127266943933629e-09, -1.722445135065001e-10,  8.354632760467868e-12, -3.624066628782006e-13,  1.423056527811849e-14, -5.102992817714758e-16,  7.122256737143143e-04,
 -2.563266268049615e-04,  4.858195488454766e-05, -6.249469835659878e-06,  6.093790817429121e-07, -4.791912354065966e-08,  3.161579149764302e-09, -1.798887836751614e-10,
  9.006674716735791e-12, -4.029761475829369e-13,  1.630905546955782e-14, -6.023057810718475e-16,  5.857827182159904e-04, -2.173806492220758e-04,  4.257480511066482e-05,
 -5.659003757402359e-06,  5.698636709497505e-07, -4.624739049768629e-08,  3.146791219576056e-09, -1.845191945058219e-10,  9.514096465522145e-12, -4.380733236985526e-13,
  1.823339047390179e-14, -6.920172071814121e-16,  4.819897012424601e-04, -1.839127890472746e-04,  3.711800228127826e-05, -5.084130275558490e-06,  5.273481406911318e-07,
 -4.405631722400449e-08,  3.083959446424406e-09, -1.859186619748017e-10,  9.849467707330801e-12, -4.656761038493990e-13,  1.988983052492410e-14, -7.741484117206767e-16,
  3.965371686442281e-04, -1.551599915104512e-04,  3.218222842878801e-05, -4.530473275237537e-06,  4.827891266810447e-07, -4.141704442246169e-08,  2.975415366242546e-09,
 -1.839845917981555e-10,  9.991782298890511e-12, -4.839960311320307e-13,  2.116789029526875e-14, -8.431458197565341e-16,  3.258986462063965e-04, -1.304301490941444e-04,
  2.772874766409669e-05, -4.001530575206404e-06,  4.369932430257529e-07, -3.840064339251748e-08,  2.824462095372167e-09, -1.787221398091667e-10,  9.927233597217436e-12,
 -4.915839037162551e-13,  2.196798316816951e-14, -8.935949152298225e-16,  2.671925269403017e-04, -1.091036466323504e-04,  2.371297582260791e-05, -3.498995841896608e-06,
  3.906108575149428e-07, -3.507476937812415e-08,  2.635072603686159e-09, -1.702324575563133e-10,  9.649502592278165e-12, -4.874097201645378e-13,  2.220837620151988e-14,
 -9.206415818089663e-16,  2.180639298688044e-04, -9.063088925116555e-05,  2.008721869742293e-05, -3.023078832102579e-06,  3.441394939458728e-07, -3.150126794410262e-08,
  2.411613853537797e-09, -1.586979168522453e-10,  9.159619830544336e-12, -4.709137280111053e-13,  2.183091368266170e-14, -9.203875667970326e-16,  1.765846971046081e-04,
 -7.452719847269244e-05,  1.680266967441203e-05, -2.572803761268018e-06,  2.979340712870059e-07, -2.773468081253317e-08,  2.158613020557641e-09, -1.443661673981102e-10,
  8.465490154113938e-12, -4.420284532556955e-13,  2.080513186981727e-14, -8.902243209850054e-16,  1.411693500841076e-04, -6.036611974127987e-05,  1.381077645604570e-05,
 -2.146273798184515e-06,  2.522215362961251e-07, -2.382154481337868e-08,  1.880574774384500e-09, -1.275345762635340e-10,  7.581180683959366e-12, -4.011740393121329e-13,
  1.913056521496043e-14, -8.290769917623840e-16,  1.105047243638458e-04, -4.777189242600537e-05,  1.106409028456301e-05, -1.740896252073777e-06,  2.071179221436445e-07,
 -1.980035241347615e-08,  1.581852544023452e-09, -1.085362075235933e-10,  6.526069815508454e-12, -3.492308562557233e-13,  1.683721008463829e-14, -7.375399696346238e-16,
  8.349106625983711e-05, -3.641160055961585e-05,  8.516706500916233e-06, -1.353568153607917e-06,  1.626464066791274e-07, -1.570204093670753e-08,  1.266572309476308e-09,
 -8.772810364818502e-11,  5.323942770513429e-12, -2.874941831480982e-13,  1.398425049367464e-14, -6.178957611708004e-16,  5.919261156643492e-05, -2.598738020317581e-05,
  6.124404748189685e-06, -9.808271093186754e-07,  1.187556461405770e-07, -1.155090876768094e-08,  9.386060068756029e-10, -6.548236311856514e-11,  4.002106959001470e-12,
 -2.176162266828241e-13,  1.065726794340504e-14, -4.740195531162119e-16,  3.679680213704664e-05, -1.622934392191489e-05,  3.844685320605235e-06, -6.189909663419602e-07,
  7.534009487360214e-08, -7.366072142079863e-09,  6.016058493931732e-10, -4.218131000948306e-11,  2.590647906416435e-12, -1.415440830635912e-13,  6.964405749341514e-15,
 -3.111886472272388e-16,  1.560166466488087e-05, -6.898714588594592e-06,  1.639009759013187e-06, -2.646545449184498e-07,  3.230632244058394e-08, -3.167714133680412e-09,
  2.594473173656195e-10, -1.824152510809173e-11,  1.123387567966457e-12, -6.154164959306493e-14,  3.035944600809857e-15, -1.360000315064761e-16,  6.531990183065831e-02,
 -1.780849269158494e-04,  5.064489486499727e-07, -1.489089433681566e-09,  4.483339525434422e-12, -1.370636248611928e-14,  4.227022534532072e-17, -1.309003906393636e-19,
  4.057866064903075e-22, -1.256818915588256e-24,  3.884675310910344e-27, -1.197472868656877e-29,  6.429082049604537e-02, -2.380787260690538e-04,  1.031772767724677e-06,
 -4.563672261200631e-09,  1.978851264836794e-11, -8.362732101851332e-14,  3.452385728068115e-16, -1.396940710102896e-18,  5.556045404121761e-21, -2.176987299681869e-23,
  8.417929085559234e-26, -3.216687579407472e-28,  6.228458585304532e-02, -3.521618719881427e-04,  2.205678988645595e-06, -1.294523441101616e-08,  7.146525646685876e-11,
 -3.763691268957676e-13,  1.909404300536757e-15, -9.392310550965774e-18,  4.500321096339328e-20, -2.107732715836719e-22,  9.675222669590384e-25, -4.362244776372197e-27,
  5.940045129454024e-02, -5.092822252177350e-04,  4.238552589732789e-06, -3.129035766184829e-08,  2.123871102935247e-10, -1.354437182613773e-12,  8.221080675698542e-15,
 -4.790783849161691e-17,  2.697118349159534e-19, -1.473817274801060e-21,  7.845412166235963e-24, -4.080009506877088e-26,  5.577638674437870e-02, -6.946276297827052e-04,
  7.364789294497221e-06, -6.684719784876083e-08,  5.471558302311786e-10, -4.147643159497983e-12,  2.959142585026720e-14, -2.008737454675963e-16,  1.307517330819417e-18,
 -8.208391168242901e-21,  4.992289405900126e-23, -2.951890089050473e-25,  5.157755352523390e-02, -8.914189387163552e-04,  1.176848021344648e-05, -1.292671456458211e-07,
  1.257160604737250e-09, -1.117194047207889e-11,  9.248295058155957e-14, -7.224152829631849e-16,  5.373854980002057e-18, -3.832839502339494e-20,  2.634943559878875e-22,
 -1.753170835484723e-24,  4.698326249509631e-02, -1.082828904936740e-03,  1.751606598480329e-05, -2.297731165316711e-07,  2.623370630167853e-09, -2.703223588302592e-11,
  2.570166332304494e-13, -2.288197561892736e-15,  1.927595790710388e-17, -1.548449808381336e-19,  1.193236545516758e-21, -8.861935231098157e-24,  4.217389935416047e-02,
 -1.253747620688524e-03,  2.451181331265614e-05, -3.795896463723325e-07,  5.036528235404773e-09, -5.963023986048873e-11,  6.456921437546237e-13, -6.500238570541541e-15,
  6.154928396402101e-17, -5.529029705320671e-19,  4.743314851935363e-21, -3.906303788034056e-23,  3.731916385369460e-02, -1.392165229286027e-03,  3.248584914331021e-05,
 -5.878097775839437e-07,  8.983924596660009e-09, -1.212478541606492e-10,  1.484414287819613e-12, -1.678359598993328e-14,  1.774889737933411e-16, -1.772144562498452e-18,
  1.682698147809937e-20, -1.528053937975068e-22,  3.256865570494188e-02, -1.490027748678547e-03,  4.101645529203149e-05, -8.591168467038976e-07,  1.500543204327237e-08,
 -2.292272271046477e-10,  3.152631908453616e-12, -3.979533161918848e-14,  4.673792689997789e-16, -5.159207835413395e-18,  5.394515258721095e-20, -5.375381841139829e-22,
  2.804542140060228e-02, -1.543521319415102e-03,  4.958060785167680e-05, -1.191902865539734e-06,  2.361892055859188e-08, -4.057943750945757e-10,  6.233198856560103e-12,
 -8.736938618518900e-14,  1.133848088611191e-15, -1.377145624883912e-17,  1.578465313441442e-19, -1.718389602740151e-21,  2.384263427766017e-02, -1.552832985910067e-03,
  5.762123150347887e-05, -1.577282516275589e-06,  3.522469169291395e-08, -6.766423475109282e-10,  1.154622991111159e-11, -1.788279903792765e-13,  2.552622587010205e-15,
 -3.396508342121540e-17,  4.249874554275271e-19, -5.034684076427550e-21,  2.002318791552572e-02, -1.521505803925317e-03,  6.461738985386128e-05, -1.999306870759093e-06,
  5.000693772821702e-08, -1.068127562900388e-09,  2.014756242703937e-11, -3.432240190803743e-13,  5.365749753902626e-15, -7.790243236332356e-17,  1.060046117350568e-18,
 -1.361589417747071e-20,  1.662169195375165e-02, -1.455543785572915e-03,  7.014470961750942e-05, -2.436398691474089e-06,  6.785431700928805e-08, -1.603297182292252e-09,
  3.327427036265779e-11, -6.208149018647836e-13,  1.058722360517133e-14, -1.670880713109766e-16,  2.463784060488027e-18, -3.419582265002576e-20,  1.364819383178715e-02,
 -1.362427259157772e-03,  7.391694975218059e-05, -2.863749874546333e-06,  8.831972619414354e-08, -2.297351768276467e-09,  5.222842202209114e-11, -1.062922512889487e-12,
  1.969936853998519e-14, -3.367596797451068e-16,  5.362950984484726e-18, -8.017409577539113e-20,  1.109290764596028e-02, -1.250177606044842e-03,  7.580450572752586e-05,
 -3.256220675187550e-06,  1.106315542109967e-07, -3.153424719378068e-09,  7.820482586594210e-11, -1.729418375611081e-12,  3.470778463460112e-14, -6.405280236117351e-16,
  1.098159718535377e-17, -1.762940724132260e-19,  8.931290077697841e-03, -1.126571902739985e-03,  7.583046130343131e-05, -3.591205911897465e-06,  1.337573953762095e-07,
 -4.159621439790164e-09,  1.120851525182397e-10, -2.683445924242759e-12,  5.811800409040578e-14, -1.154169189448172e-15,  2.123827758683783e-17, -3.650687761731575e-19,
  7.128929834499974e-03, -9.985634682527142e-04,  7.414854107473475e-05, -3.850988928731025e-06,  1.565097154258576e-07, -5.288068627651147e-09,  1.542343299475237e-10,
 -3.983607696224520e-12,  9.280261191138910e-14, -1.977088151166429e-15,  3.893401579462025e-17, -7.145926846416208e-19,  5.645875696620276e-03, -8.719228171980938e-04,
  7.100943718157187e-05, -4.024256999697452e-06,  1.776744762511105e-07, -6.496323587893963e-09,  2.043406703788013e-10, -5.674556103931175e-12,  1.417451767120846e-13,
 -3.229895161316124e-15,  6.787663406541508e-17, -1.326649828959377e-18,  4.440188217125818e-03, -7.510811270550258e-04,  6.672243949539102e-05, -4.106649557477516e-06,
  1.961402200386858e-07, -7.730998027427174e-09,  2.613362950563233e-10, -7.777519382904287e-12,  2.076744820064397e-13, -5.046919260444151e-15,  1.128757201353339e-16,
 -2.343212033361368e-18,  3.470639252608429e-03, -6.391377222746252e-04,  6.161842180293890e-05, -4.100399647611652e-06,  2.110069257277480e-07, -8.932998196170030e-09,
  3.234198929624001e-10, -1.028256840583373e-11,  2.926326934590653e-13, -7.563352161919758e-15,  1.795467523132815e-16, -3.948778112360798e-18,  2.698589553524330e-03,
 -5.379840275286645e-04,  5.601855141977951e-05, -4.013269633312800e-06,  2.216599203074021e-07, -1.004348900920918e-08,  3.881835405463700e-10, -1.314427182875574e-11,
  3.975454430007320e-13, -1.089792342109739e-14,  2.738871634951769e-16, -6.365851617717368e-18,  2.089144169788720e-03, -4.484967651686829e-04,  5.021113742115003e-05,
 -3.857055491128769e-06,  2.278022060459192e-07, -1.100961321030454e-08,  4.528247194969531e-10, -1.628181499530860e-11,  5.218723368878364e-13, -1.513325507716650e-14,
  4.016297671880257e-16, -9.841444097725452e-18,  1.611721450687467e-03, -3.707597884671443e-04,  4.443724564480276e-05, -3.645941304984960e-06,  2.294465672175656e-07,
 -1.178913053997197e-08,  5.144090530688815e-10, -1.958381697077358e-11,  6.634088096930587e-13, -2.029696884971327e-14,  5.674314923136222e-16, -1.462388655729041e-17,
  1.240180727442374e-03, -3.042837550628752e-04,  3.888435126583799e-05, -3.394942336972231e-06,  2.268750439178403e-07, -1.235342545583521e-08,  5.701420483367429e-10,
 -2.291718987208086e-11,  8.182856061265369e-13, -2.634691987527153e-14,  7.740043040888157e-16, -2.093123237762194e-17,  9.526445105690343e-04, -2.482033115245060e-04,
  3.368646831732708e-05, -3.118603307298798e-06,  2.205769128642892e-07, -1.268867773107444e-08,  6.176100680458082e-10, -2.613866651462655e-11,  9.811765378980177e-13,
 -3.316347468380268e-14,  1.021326230901377e-15, -2.891469228758831e-17,  7.311309615725899e-04, -2.014408461268089e-04,  2.892885592218687e-05, -2.830039629919030e-06,
  2.111771263616078e-07, -1.279531312367013e-08,  6.549602000387351e-10, -2.910723225322893e-11,  1.145687513893822e-12, -4.055062149759735e-14,  1.306073292520876e-15,
 -3.862228155392661e-17,  5.610878328871902e-04, -1.628332496542251e-04,  2.465544177047078e-05, -2.540339512031257e-06,  1.993657752676744e-07, -1.268609006488808e-08,
  6.810024250894720e-10, -3.169568847790305e-11,  1.304869167874306e-12, -4.824617052758743e-14,  1.621385160097461e-15, -4.996866223027491e-17,  4.308945185183811e-04,
 -1.312232385531401e-04,  2.087738578770132e-05, -2.258293244446988e-06,  1.858364115281735e-07, -1.238330506262710e-08,  6.952318896498974e-10, -3.379990046676830e-11,
  1.451778098252732e-12, -5.593974142164672e-14,  1.957024455428996e-15, -6.271673932390588e-17,  3.313770724069111e-04, -1.055198205949274e-04,  1.758160167224484e-05,
 -1.990385377910438e-06,  1.712378624948079e-07, -1.191561757127663e-08,  6.977811642176880e-10, -3.534482191551636e-11,  1.580010125823233e-12, -6.329599831842470e-14,
  2.299924196816079e-15, -7.647495745488866e-17,  2.553633440659762e-04, -8.473383637349764e-05,  1.473846155080474e-05, -1.740973735750752e-06,  1.561411871173889e-07,
 -1.131492942113377e-08,  6.893203079202627e-10, -3.628699662891174e-11,  1.684141339868909e-12, -6.997992041669754e-14,  2.635055133728643e-15, -9.071179831156204e-17,
  1.972920323942657e-04, -6.799467923053931e-05,  1.230826605546096e-05, -1.512581684891962e-06,  1.410210916713289e-07, -1.061363911485352e-08,  6.709258800230518e-10,
 -3.661378406589650e-11,  1.760034407945905e-12, -7.568086489725045e-14,  2.946497908488251e-15, -1.047862560159322e-16,  1.528801111253643e-04, -5.455373608939597e-05,
  1.024633811020186e-05, -1.306241371795016e-06,  1.262496061886067e-07, -9.842461074925730e-09,  6.439393194219855e-10, -3.633995195581403e-11,  1.804992855299816e-12,
 -8.013270928557725e-14,  3.218582327633765e-15, -1.179906598659042e-16,  1.188470556238796e-04, -4.377916727812068e-05,  8.506787709604395e-06, -1.121840880294480e-06,
  1.120990864974713e-07, -9.028880268525175e-09,  6.098315614421768e-10, -3.550249033936516e-11,  1.817769426855520e-12, -8.312826239000695e-14,  3.436959180051446e-15,
 -1.296005892057330e-16,  9.269082893749613e-05, -3.514561425578490e-05,  7.045106430276586e-06, -9.584438518767644e-07,  9.875149398863940e-08, -8.196219170441549e-09,
  5.700857641515307e-10, -3.415453718510018e-11,  1.798452463770882e-12, -8.452717498367434e-14,  3.589494787742819e-15, -1.389260218870472e-16,  7.250893808681423e-05,
 -2.822145233112958e-05,  5.819801127999538e-06, -8.145637580419133e-07,  8.631121291590336e-08, -7.363232547621307e-09,  5.261047977069147e-10, -3.235920668032817e-11,
  1.748264708528903e-12, -8.425755180427110e-14,  3.666916806903927e-15, -1.453582606249192e-16,  5.685743734551109e-05, -2.265537560204674e-05,  4.793284566612892e-06,
 -6.883856549520746e-07,  7.481919850833803e-08, -6.544114457922655e-09,  4.791455820313405e-10, -3.018393076667278e-11,  1.669312189716237e-12, -8.231221566674961e-14,
  3.663182506436447e-15, -1.484083679049130e-16,  4.464105914266094e-05, -1.816344343241157e-05,  3.932222972971315e-06, -5.779356839969226e-07,  6.426685290287186e-08,
 -5.748795178101248e-09,  4.302789141644059e-10, -2.769571403941537e-11,  1.564318215866795e-12, -7.874103087813211e-14,  3.575579722260276e-15, -1.477344697404449e-16,
  3.502835221628047e-05, -1.451722774672238e-05,  3.207509544874624e-06, -4.812031479107992e-07,  5.460859430584709e-08, -4.983415888026437e-09,  3.803712356299784e-10,
 -2.495750216598323e-11,  1.436371040626568e-12, -7.364085637937444e-14,  3.404600339148572e-15, -1.431570023672393e-16,  2.738656911062461e-05, -1.153335616871527e-05,
  2.593997747016687e-06, -3.962222860685451e-07,  4.577255927422828e-08, -4.250888522872770e-09,  3.300837383843457e-10, -2.202570003748731e-11,  1.288705505616703e-12,
 -6.714461961511096e-14,  3.153643920850265e-15, -1.346624754333491e-16,  2.123192586668372e-05, -9.064518562222690e-06,  2.070094418853597e-06, -3.211215461405269e-07,
  3.766923702308208e-08, -3.551471366125560e-09,  2.798840500306840e-10, -1.894875925487605e-11,  1.124530627662899e-12, -5.941075648306308e-14,  2.828615123961107e-15,
 -1.223974184819681e-16,  1.619167340077189e-05, -6.991864856988193e-06,  1.617283287449809e-06, -2.541477940222190e-07,  3.019808199654516e-08, -2.883313647896404e-09,
  2.300661928292865e-10, -1.576668570478860e-11,  9.469078514269098e-13, -5.061393165680030e-14,  2.437474855188239e-15, -1.066547908863855e-16,  1.197513379889612e-05,
 -5.218645198262375e-06,  1.219625727946553e-06, -1.936720140129537e-07,  2.325230684342370e-08, -2.242942557529063e-09,  1.807753365816883e-10, -1.251129168290555e-11,
  7.586792449560186e-13, -4.093761084259212e-14,  1.989795028495765e-15, -8.785530548948012e-17,  8.351462302568226e-06, -3.664913263042661e-06,  8.632686315829015e-07,
 -1.381821408055685e-07,  1.672216650598565e-08, -1.625684764379349e-09,  1.320350238856986e-10, -9.207035026034523e-12,  5.624421543500775e-13, -3.056879105675640e-14,
  1.496355380516191e-15, -6.652602482859755e-17,  5.132505886320172e-06, -2.263161581142727e-06,  5.359896690083218e-07, -8.626977545450156e-08,  1.049735022552590e-08,
 -1.026053495208863e-09,  8.377767654736666e-11, -5.872464790582044e-12,  3.605743114567457e-13, -1.969545848728371e-14,  9.688317712797683e-16, -4.327930043071016e-17,
  2.162292627642163e-06, -9.559967916771911e-07,  2.270945153977483e-07, -3.666399207741437e-08,  4.474897528498835e-09, -4.387095815945209e-10,  3.592663029046929e-11,
 -2.525604265356148e-12,  1.555146715130254e-13, -8.518227702543311e-15,  4.201584299047331e-16, -1.881907731623416e-17,  6.461555382995486e-02, -1.741036126327546e-04,
  4.890014050478474e-07, -1.419495119196487e-09,  4.219067657465819e-12, -1.273443304429636e-14,  3.878021289586811e-17, -1.186101575495039e-19,  3.632156953715445e-22,
 -1.111470016826585e-24,  3.394661502904399e-27, -1.034127752521045e-29,  6.335467455176619e-02, -2.300383419736089e-04,  9.788546265734826e-07, -4.259999185563402e-09,
  1.819575606483170e-11, -7.579157827545149e-14,  3.085000005038043e-16, -1.231063529495263e-18,  4.829678487706307e-21, -1.866940210917886e-23,  7.123049128515020e-26,
 -2.686047285213171e-28,  6.091027209936029e-02, -3.351189291178789e-04,  2.056956264578514e-06, -1.185960607894873e-08,  6.437564141229707e-11, -3.335432615384383e-13,
  1.665491494345193e-15, -8.066503625742530e-18,  3.806810991001181e-20, -1.756527500439398e-22,  7.945536195067057e-25, -3.530892131847536e-27,  5.742884009533782e-02,
 -4.768199636643341e-04,  3.882597052414803e-06, -2.809859270067307e-08,  1.871676109775808e-10, -1.172299945610364e-12,  6.992928104932308e-15, -4.006875529752727e-17,
  2.218958332159312e-19, -1.193152257999765e-21,  6.251779673616721e-24, -3.201118301642534e-26,  5.311083456750631e-02, -6.387752174170586e-04,  6.612532401984160e-06,
 -5.871957087379032e-08,  4.708726520412681e-10, -3.500474403221771e-12,  2.451091230823865e-14, -1.633998557022128e-16,  1.045035969755555e-18, -6.448876457020622e-21,
  3.856823948512776e-23, -2.243247010932252e-25,  4.819081045879030e-02, -8.031502029282262e-04,  1.033096106689850e-05, -1.108260321123390e-07,  1.054374535215143e-09,
 -9.176855129598325e-12,  7.446905005805874e-14, -5.706367276932164e-16,  4.166522901707267e-18, -2.918375992925414e-20,  1.971121381285804e-22, -1.289004393108368e-24,
  4.291569699279141e-02, -9.530549446699928e-04,  1.499381988996380e-05, -1.918097869984651e-07,  2.139559785583321e-09, -2.156780856136018e-11,  2.008062185513398e-13,
 -1.752057897635055e-15,  1.447431599383141e-17, -1.140910602101297e-19,  8.631102862336328e-22, -6.295670038820219e-24,  3.752407013379400e-02, -1.074588940939277e-03,
  2.040345577771150e-05, -3.077621518612656e-07,  3.985223712279380e-09, -4.611230758627445e-11,  4.885100465633379e-13, -4.815632034692195e-15,  4.468258474213901e-17,
 -3.935724377530430e-19,  3.312473102375790e-21, -2.677557616157741e-23,  3.222882475344387e-02, -1.158222147607527e-03,  2.622042481689372e-05, -4.616799093678709e-07,
  6.880244434750058e-09, -9.067400961520939e-11,  1.085252992965993e-12, -1.200690380823130e-14,  1.243440827829913e-16, -1.216605974364823e-18,  1.132678137018732e-20,
 -1.009050995832697e-22,  2.720484931915563e-02, -1.199375718363740e-03,  3.200863487641652e-05, -6.519457642873783e-07,  1.109532023285610e-08, -1.654030462567969e-10,
  2.222547956860208e-12, -2.743670212424501e-14,  3.153886664620014e-16, -3.409903430961391e-18,  3.494310130946685e-20, -3.414343486327561e-22,  2.258235950419687e-02,
 -1.198231296535310e-03,  3.730158750854678e-05, -8.715626044268265e-07,  1.682024007552391e-08, -2.818716501301917e-10,  4.228188917437359e-12, -5.793407803982984e-14,
  7.355777036749632e-16, -8.747225320330034e-18,  9.822492106019350e-20, -1.048226184547584e-21,  1.844565252062293e-02, -1.158930079869663e-03,  4.167331771970691e-05,
 -1.108443717040118e-06,  2.410066211666526e-08, -4.514111720376636e-10,  7.519900962418852e-12, -1.138166468535356e-13,  1.589024352435807e-15, -2.069553686700722e-17,
  2.536345072490818e-19, -2.944775274402253e-21,  1.483635454887105e-02, -1.088399303079436e-03,  4.479835787985630e-05, -1.346772802019184e-06,  3.279162720234944e-08,
 -6.828321728206138e-10,  1.257172689564203e-11, -2.092531937684678e-13,  3.199083432139413e-15, -4.545463628993245e-17,  6.057281171222076e-19, -7.624138793259449e-21,
  1.175983130302669e-02, -9.950587568853979e-04,  4.648968065380285e-05, -1.569153952789009e-06,  4.254271930274493e-08, -9.799695281407964e-10,  1.985050743608214e-11,
 -3.618480530562501e-13,  6.034279304731503e-15, -9.319674438380081e-17,  1.345756259709655e-18, -1.830269284572753e-20,  9.193323668414468e-03, -8.876236754994373e-04,
  4.671015587336571e-05, -1.759072308941518e-06,  5.282229769262547e-08, -1.339655176572795e-09,  2.972882652807329e-11, -5.911616781653321e-13,  1.071432512904734e-14,
 -1.792551159600308e-16,  2.795701074671199e-18, -4.095694689215420e-20,  7.094504435109283e-03, -7.741524574259879e-04,  4.555947296326927e-05, -1.903136613572480e-06,
  6.297804097939288e-08, -1.750703581343825e-09,  4.239015285584062e-11, -9.161144492297013e-13,  1.798297582832419e-14, -3.248511867633238e-16,  5.455284955090930e-18,
 -8.583524725218125e-20,  5.409443148818444e-03, -6.614101458438724e-04,  4.324313025109979e-05, -1.992673188746517e-06,  7.232162516255630e-08, -2.194286239729598e-09,
  5.774799263129832e-11, -1.351554526281570e-12,  2.863915105843304e-14, -5.568617364308231e-16,  1.003956310482030e-17, -1.691825046489879e-19,  4.079322417476641e-03,
 -5.545495512586919e-04,  4.003223321902534e-05, -2.024437119797311e-06,  8.021971278830106e-08, -2.645733232121384e-09,  7.540085369466356e-11, -1.904600724328274e-12,
  4.342745226420024e-14, -9.061865577622358e-16,  1.749003167868863e-17, -3.148130680083596e-19,  3.045593530376014e-03, -4.570624596377743e-04,  3.622258625668216e-05,
 -2.000429453145001e-06,  8.617299926896974e-08, -3.077442468044537e-09,  9.463802411097019e-11, -2.571572752663535e-12,  6.290162123160726e-14, -1.404521486972940e-15,
  2.894146604932605e-17, -5.549750879101064e-19,  2.253540607394065e-03, -3.709270826565280e-04,  3.209960428084037e-05, -1.926994161207028e-06,  8.986939374114138e-08,
 -3.462314805551358e-09,  1.144994537541031e-10, -3.336301484844114e-12,  8.728565789836839e-14, -2.079740204696348e-15,  4.563206062865127e-17, -9.298585756689748e-19,
  1.654417094397531e-03, -2.968723366256097e-04,  2.791283370390341e-05, -1.813476182461297e-06,  9.120461525950384e-08, -3.777039206685206e-09,  1.338800730177804e-10,
 -4.170354761227232e-12,  1.163629952108102e-13, -2.950535555153400e-15,  6.875608665480533e-17, -1.485194565601497e-18,  1.206425705489149e-03, -2.346888057135738e-04,
  2.386118808150093e-05, -1.670743719795113e-06,  9.027113289698558e-08, -4.004637576239868e-09,  1.516586980758533e-10, -5.035289334455124e-12,  1.494216258061923e-13,
 -4.021318984833147e-15,  9.927384956630277e-17, -2.267712602020244e-18,  8.748474108277983e-04, -1.835335373119430e-04,  2.008792643610734e-05, -1.509830931644376e-06,
  8.732240327571405e-08, -4.135897343459710e-09,  1.668270884818091e-10, -5.886575994168872e-12,  1.852724730554494e-13, -5.278490807665126e-15,  1.377086966040469e-16,
 -3.318725494940340e-18,  6.316081642060292e-04, -1.421952013955593e-04,  1.668316198533006e-05, -1.340870926873874e-06,  8.272261461189165e-08, -4.169592383252296e-09,
  1.785965120392293e-10, -6.678480552334014e-12,  2.223425210882204e-13, -6.689010652463886e-15,  1.839700663309754e-16, -4.666667839217985e-18,  4.545254781210421e-04,
 -1.093035063688347e-04,  1.369124941562164e-05, -1.172394119571303e-06,  7.689251612707144e-08, -4.111640161651895e-09,  1.864660643920958e-10, -7.369014958464760e-12,
  2.588279090399680e-13, -8.201752645221955e-15,  2.372413477244166e-16, -6.319855089992892e-18,  3.264187047675424e-04, -8.347995555873852e-05,  1.112056299075499e-05,
 -1.010986449464455e-06,  7.026005963039273e-08, -3.973509727742455e-09,  1.902464299946718e-10, -7.924127139325240e-12,  2.928799709824885e-13, -9.751547438881405e-15,
  2.959608507908717e-16, -8.260895811636993e-18,  2.342096035112006e-04, -6.343552499025632e-05,  8.953694766792438e-06, -8.612477185499721e-07,  6.322153557929863e-08,
 -3.770260663193821e-09,  1.900419644490180e-10, -8.320533022439527e-12,  3.227920701303069e-13, -1.126525826098813e-14,  3.579060608717180e-16, -1.044400183397431e-17,
  1.680907682111336e-04, -4.802517648191330e-05,  7.156745120886067e-06, -7.259642612528666e-07,  5.611565241406417e-08, -3.518567937021424e-09,  1.862007912517030e-10,
 -8.546923392417150e-12,  3.471576251612004e-13, -1.266885801005981e-14,  4.203705498850556e-16, -1.279593144317661e-17,  1.208017463901676e-04, -3.627033070768824e-05,
  5.686984288052431e-06, -6.064074533871736e-07,  4.921031050027184e-08, -3.235001784427119e-09,  1.792460225374454e-10, -8.603606301701529e-12,  3.649783036669108e-13,
 -1.389435193960556e-14,  4.804050548539109e-16, -1.522060242077071e-17,  8.702626977119347e-05, -2.735964355328500e-05,  4.498644032411407e-06, -5.026821966212189e-07,
  4.270002106993713e-08, -2.934720710242406e-09,  1.698013240301176e-10, -8.500897935699123e-12,  3.757129599466596e-13, -1.488552622709103e-14,  5.350836469891191e-16,
 -1.760671097053922e-17,  6.290735001536470e-05, -2.063662691376463e-05,  3.546924143996659e-06, -4.140694578719904e-07,  3.671105545477874e-08, -2.630629596194766e-09,
  1.585217075248759e-10, -8.256712960009750e-12,  3.792693182373753e-13, -1.560182792351611e-14,  5.817544644148783e-16, -1.983716522277309e-17,  4.566783767945540e-05,
 -1.558053868890049e-05,  2.790480753078426e-06, -3.393279019427165e-07,  3.131130936731076e-08, -2.332972737388200e-09,  1.460368208119705e-10, -7.893828518425672e-12,
  3.759491881641614e-13, -1.602009103650268e-14,  6.182413472267670e-16, -2.179890021641543e-17,  3.332014854575161e-05, -1.178497400613505e-05,  2.192734427994884e-06,
 -2.769376964805739e-07,  2.652226921551842e-08, -2.049280836809464e-09,  1.329102055907779e-10, -7.437230124768343e-12,  3.663629094567539e-13, -1.613421196255699e-14,
  6.429750863509858e-16, -2.339170842007643e-17,  2.444831310264932e-05, -8.936938886515269e-06,  1.722332690882044e-06, -2.252829296153682e-07,  2.233111362525577e-08,
 -1.784569842330610e-09,  1.196147826863374e-10, -6.911830832148041e-12,  3.513297357000909e-13, -1.595316883989492e-14,  6.550472491073003e-16, -2.453503796821246e-17,
  1.804684144667006e-05, -6.797944006368430e-06,  1.353056825954078e-06, -1.827775853146787e-07,  1.870167148767791e-08, -1.541691057984688e-09,  1.065225891961525e-10,
 -6.340724489111757e-12,  3.317788306154325e-13, -1.549793830001129e-14,  6.541923714629079e-16, -2.517217133746125e-17,  1.340310363649504e-05, -5.187794610161923e-06,
  1.063401354506944e-06, -1.479444109488090e-07,  1.558356058262395e-08, -1.321747546068768e-09,  9.390559014424215e-11, -5.744017542865932e-12,  3.086617138114087e-13,
 -1.479789272096910e-14,  6.407134980376821e-16, -2.527168016791404e-17,  1.001236362875848e-05, -3.971204932428532e-06,  8.359922967726187e-07, -1.194573928287693e-07,
  1.291928892086714e-08, -1.124513598163778e-09,  8.194405471110502e-11, -5.138197354782303e-12,  2.828825863525659e-13, -1.388719107991399e-14,  6.153707434686647e-16,
 -2.482645881737406e-17,  7.516910756066478e-06, -3.047052370433771e-06,  6.569560125653196e-07, -9.615803170519216e-08,  1.064940505052640e-08, -9.488161818396664e-10,
  7.073926125780937e-11, -4.535942756785732e-12,  2.552489326632458e-13, -1.280154797889792e-14,  5.792530544547250e-16, -2.385091149295330e-17,  5.662733388884330e-06,
 -2.339935167798069e-06,  5.153074447140393e-07, -7.705408669477079e-08,  8.715953863587349e-09, -7.928562751931731e-10,  6.032790659502875e-11, -3.946261073449359e-12,
  2.264416870180173e-13, -1.157561810022481e-14,  5.336507351436159e-16, -2.237698974000426e-17,  4.268820316025877e-06, -1.793648604239570e-06,  4.023951564775512e-07,
 -6.130757721933518e-08,  7.064563691605881e-09, -6.544623741106947e-10,  5.069632255524298e-11, -3.374837391539900e-12,  1.970022597541413e-13, -1.024109754051610e-14,
  4.799419061756627e-16, -2.044976698879888e-17,  3.205468139394253e-06, -1.366205243708387e-06,  3.114191362292113e-07, -4.821699790366900e-08,  5.645492600940688e-09,
 -5.312780801551472e-10,  4.179329658475952e-11, -2.824497811419376e-12,  1.673327652895038e-13, -8.825537137623617e-15,  4.195011508345398e-16, -1.812313275030503e-17,
  2.378960983896987e-06, -1.026065102571235e-06,  2.370237912867149e-07, -3.719711863178193e-08,  4.413925626829345e-09, -4.208912354149792e-10,  3.354087097806980e-11,
 -2.295711180478605e-12,  1.377056598504717e-13, -7.351792666286607e-15,  3.536340971803639e-16, -1.545603453619405e-17,  1.720726167485520e-06, -7.492930342236825e-07,
  1.749607346792232e-07, -2.775848943970853e-08,  3.329761978532336e-09, -3.209146091297002e-10,  2.584293189221482e-11, -1.787078011814538e-12,  1.082794245888551e-13,
 -5.838001493028930e-15,  2.835381705783272e-16, -1.250953054423286e-17,  1.179610337702089e-06, -5.174129229798582e-07,  1.218121839279748e-07, -1.948786719812119e-08,
  2.357078992210051e-09, -2.290289666711174e-10,  1.859172416046039e-11, -1.295779136991567e-12,  7.911777058759050e-14, -4.297973740775180e-15,  2.102876884259118e-16,
 -9.344780253164080e-18,  7.163258143259991e-07, -3.157823111565842e-07,  7.476615306557592e-08, -1.203043498602370e-08,  1.463446599398524e-09, -1.430023449783955e-10,
  1.167291282120332e-11, -8.179958552643312e-13,  5.021196950752609e-14, -2.741968225260251e-15,  1.348436788731833e-16, -6.022138109888553e-18,  2.997755685659304e-07,
 -1.325199720169426e-07,  3.147506167903905e-08, -5.080812253156899e-09,  6.200259198353614e-10, -6.077677304756679e-11,  4.976355493157574e-12, -3.497802919583121e-13,
  2.153462411649390e-14, -1.179374851117047e-15,  5.816385600569371e-17, -2.604815190849844e-18,  6.392685711528487e-02, -1.702586086049943e-04,  4.723642501649963e-07,
 -1.353978082570303e-09,  3.973423874064548e-12, -1.184228361632001e-14,  3.561601565503273e-17, -1.076021194018696e-19,  3.255411858202212e-22, -9.843572275004059e-25,
  2.971137080772527e-27, -8.945849245861630e-30,  6.244986593646569e-02, -2.224071483228014e-04,  9.294326783082518e-07, -3.980602870339327e-09,  1.675126013889342e-11,
 -6.878435340782235e-14,  2.760966695154100e-16, -1.086739791353614e-18,  4.206141691830679e-21, -1.604305696958588e-23,  6.040546994831725e-26, -2.248196293017646e-28,
  5.960183042220657e-02, -3.192155231657401e-04,  1.920607745666976e-06, -1.088086532657812e-08,  5.808688670747323e-11, -2.961497875074141e-13,  1.455775307590529e-15,
 -6.943657455858372e-18,  3.228114656536289e-20, -1.467714394358472e-22,  6.543467148325266e-25, -2.866518855209844e-27,  5.558161589593458e-02, -4.470587345931881e-04,
  3.562636842230908e-06, -2.528272764884193e-08,  1.653130233138614e-10, -1.017168426809821e-12,  5.964283733031457e-15, -3.360970566234864e-17,  1.831238027087974e-19,
 -9.691220300330439e-22,  4.999230209811172e-24, -2.520766794853985e-26,  5.065724558151288e-02, -5.885705407624607e-04,  5.950890454594507e-06, -5.171521234313166e-08,
  4.063938486771949e-10, -2.963540338489974e-12,  2.037100718352458e-14, -1.333937926098187e-16,  8.384213005182134e-19, -5.086810546345397e-21,  2.992129818520538e-23,
 -1.712209151900598e-25,  4.513546949822133e-02, -7.255487178901645e-04,  9.096512252827335e-06, -9.533240205178799e-08,  8.874897347010996e-10, -7.567184710444441e-12,
  6.021012037812475e-14, -4.527005165978203e-16,  3.245147331774196e-18, -2.232672582820734e-20,  1.481854223469239e-22, -9.526170566266535e-25,  3.932958120400566e-02,
 -8.417604560500923e-04,  1.288407022793491e-05, -1.607816128058755e-07,  1.752678657185299e-09, -1.728838129763447e-11,  1.576601726412724e-13, -1.348439481170719e-15,
  1.092704246135543e-17, -8.453156044389422e-20,  6.279216119256545e-22, -4.499227994497210e-24,  3.353022260504077e-02, -9.251160655638041e-04,  1.706440216000670e-05,
 -2.507826216418330e-07,  3.170080746218659e-09, -3.585677809838885e-11,  3.717299232651420e-13, -3.589054012375187e-15,  3.263986288933349e-17, -2.819571563482944e-19,
  2.328572103872167e-21, -1.847818811394212e-23,  2.798284651709618e-02, -9.688771248182796e-04,  2.128521471000027e-05, -3.647953756427250e-07,  5.302156044080828e-09,
 -6.825017445570132e-11,  7.987580598539888e-13, -8.649220265784467e-15,  8.773361391239615e-17, -8.413394154683008e-19,  7.681695443745347e-21, -6.714508898329011e-23,
  2.287388809238334e-02, -9.718159103472373e-04,  2.514999119881311e-05, -4.982289682882790e-07,  8.263889949900981e-09, -1.202446449698053e-10,  1.578925487493531e-12,
 -1.906549570458634e-14,  2.145453997825918e-16, -2.272344612584663e-18,  2.282531727461951e-20, -2.187366825379213e-22,  1.832595706327581e-02, -9.374736758903063e-04,
  2.828800447293436e-05, -6.425318243762530e-07,  1.207878167240904e-08, -1.974670521082078e-10,  2.893158536098949e-12, -3.875761552986217e-14,  4.815274815588797e-16,
 -5.607216860573722e-18,  6.169640126554253e-20, -6.455085127141766e-22,  1.440088774783376e-02, -8.728208810488255e-04,  3.041675967984155e-05, -7.862412943156955e-07,
  1.664608925983466e-08, -3.040542442807875e-10,  4.945530450758149e-12, -7.315876474249768e-14,  9.991348680948925e-16, -1.273876687301862e-17,  1.529332819834732e-19,
 -1.740387358308191e-21,  1.110852295801683e-02, -7.866787166367045e-04,  3.138253294093844e-05, -9.167681955938407e-07,  2.173154062261764e-08, -4.412116638813024e-10,
  7.929712355472540e-12, -1.289745301907694e-13,  1.928432163612105e-15, -2.681845298849617e-17,  3.500274652813441e-19, -4.317655940299428e-21,  8.418740750718834e-03,
 -6.882260975021879e-04,  3.117245572348568e-05, -1.022469075591085e-06,  2.698762948852638e-08, -6.060826184658618e-10,  1.198357783730563e-11, -2.134390844124074e-13,
  3.480839239457394e-15, -5.261411236690931e-17,  7.440573230294190e-19, -9.916579234493298e-21,  6.274387339965107e-03, -5.858200012382435e-04,  2.989977896678794e-05,
 -1.094494236556934e-06,  3.200083698533896e-08, -7.913209623811701e-10,  1.714178020224457e-11, -3.330682945218470e-13,  5.903582106587050e-15, -9.666681831877474e-17,
  1.476549222836573e-18, -2.119857308505949e-20,  4.603287681587810e-03, -4.862381311105048e-04,  2.777002877930740e-05, -1.128000212680417e-06,  3.635501695006794e-08,
 -9.855929374850655e-10,  2.329945571249316e-11, -4.920920212759136e-13,  9.448058198867937e-15, -1.670619640078340e-16,  2.748002813131188e-18, -4.237819280021446e-20,
  3.328170169279493e-03, -3.943450699350732e-04,  2.503848732739971e-05, -1.122525873194803e-06,  3.969573820661562e-08, -1.174972753517270e-09,  3.019926564389509e-11,
 -6.909150532422788e-13,  1.432327714320815e-14, -2.726731810797959e-16,  4.816295180462251e-18, -7.956558594287793e-20,  2.373992200701161e-03, -3.131073780406282e-04,
  2.196889210112684e-05, -1.081566357329222e-06,  4.178091555652546e-08, -1.344937300874626e-09,  3.744857725569056e-11, -9.250324073032753e-13,  2.064236790960766e-14,
 -4.218599282455262e-16,  7.979600017778301e-18, -1.408469513833683e-19,  1.672675049620127e-03, -2.438460518880481e-04,  1.880047531378339e-05, -1.011561858545577e-06,
  4.250788698901419e-08, -1.482501922263858e-09,  4.456542440744101e-11, -1.184763009400036e-12,  2.837459848667463e-14, -6.207756323335843e-16,  1.254127523560054e-17,
 -2.359218657606258e-19,  1.165599668133826e-03, -1.866115352575460e-04,  1.572682909268399e-05, -9.206064428742959e-07,  4.191406687715633e-08, -1.578022511942727e-09,
  5.104388928591125e-11, -1.455973565987183e-12,  3.731633896873799e-14, -8.716147989366408e-16,  1.875910262923093e-17, -3.751775317701979e-19,  8.043827897180885e-04,
 -1.405859569701484e-04,  1.288676066296994e-05, -8.171735793831383e-07,  4.015491673814813e-08, -1.626311073878969e-09,  5.642449756326499e-11, -1.721703873240049e-12,
  4.709101613100511e-14, -1.171224446767589e-15,  2.678692814442584e-17, -5.682122654778226e-19,  5.504809832843819e-04, -1.044471783799938e-04,  1.036500023182254e-05,
 -7.090777589988931e-07,  3.746735019734286e-08, -1.626916001682022e-09,  6.035463321173900e-11, -1.964365963010084e-12,  5.718118585188508e-14, -1.510477559591624e-15,
  3.662108761691189e-17, -8.219935744367443e-19,  3.741078261984315e-04, -7.665959942726897e-05,  8.199536772211822e-06, -6.027853452169474e-07,  3.412809455640194e-08,
 -1.583629942699973e-09,  6.262761660226372e-11, -2.168051545039504e-12,  6.698764932513142e-14, -1.874649443142404e-15,  4.806511717145101e-17, -1.138993322092152e-18,
  2.528423718209632e-04, -5.568133967190777e-05,  6.392298748708859e-06, -5.030882232043393e-07,  3.041532905902470e-08, -1.503444657526270e-09,  6.319529210928078e-11,
 -2.320482380665785e-12,  7.590379130707223e-14, -2.244797710812362e-15,  6.072330291433325e-17, -1.515721983721371e-18,  1.701909589983763e-04, -4.009394765602598e-05,
  4.920499126889281e-06, -4.130828955580457e-07,  2.657913561108317e-08, -1.395242493765944e-09,  6.215551434560140e-11, -2.414262057722773e-12,  8.339010356184145e-14,
 -2.599900797284370e-15,  7.402729051626769e-17, -1.942046109885030e-18,  1.142611924907871e-04, -2.866948625746552e-05,  3.746843944048057e-06, -3.343622185346791e-07,
  2.282309586613428e-08, -1.268500398589830e-09,  5.972091263563882e-11, -2.447281904724853e-12,  8.903485941808848e-14, -2.919335966926693e-15,  8.729219700708462e-17,
 -2.401519201854509e-18,  7.662683809699219e-05, -2.039245960263912e-05,  2.827668611918849e-06, -2.673222982093631e-07,  1.929665381559010e-08, -1.132210762527061e-09,
  5.617775537868755e-11, -2.422332264528023e-12,  9.259133873343503e-14, -3.185223468239576e-15,  9.979187649228855e-17, -2.872730057801177e-18,  5.140716471943332e-05,
 -1.445278544586511e-05,  2.118748517743218e-06, -2.115027127599579e-07,  1.609610504800584e-08, -9.941281647750327e-10,  5.184362489257003e-11, -2.346119044106306e-12,
  9.398811959323596e-14, -3.384232417014494e-15,  1.108391577122839e-16, -3.331443254926888e-18,  3.455074821370960e-05, -1.022283294080158e-05,  1.578974489108780e-06,
 -1.659030376805017e-07,  1.327133267773896e-08, -8.603620548410795e-10,  4.703065975316766e-11, -2.227957335626111e-12,  9.331482197299478e-14, -3.508600732138394e-15,
  1.198568295710157e-16, -3.753141035157508e-18,  2.329671249814519e-05, -7.227856547674213e-06,  1.172308483855745e-06, -1.292439127534932e-07,  1.083547490992818e-08,
 -7.352707587763747e-10,  4.201832119668162e-11, -2.078410337172122e-12,  9.078986216465477e-14, -3.556310262468798e-15,  1.264284585676381e-16, -4.115516003000799e-18,
  1.578047043485677e-05, -5.115805157377661e-06,  8.684961367566253e-07, -1.001614493137808e-07,  8.775261208101832e-09, -6.215776801503186e-10,  3.703689274477073e-11,
 -1.908084068148471e-12,  8.671862623320791e-14, -3.530525257423773e-15,  1.303234140017774e-16, -4.400514346487939e-18,  1.075174893738257e-05, -3.629849142710987e-06,
  6.429733311998574e-07, -7.733771328745001e-08,  7.060491075374023e-09, -5.206226027638198e-10,  3.226081332231609e-11, -1.726705386528644e-12,  8.145015435413637e-14,
 -3.438511829277230e-15,  1.314960782877969e-16, -4.595661526490645e-18,  7.376744777995682e-06, -2.585115120156250e-06,  4.763167267552882e-07, -5.957763850393934e-08,
  5.651833779064837e-09, -4.326712733640955e-10,  2.780970012299149e-11, -1.542528548073271e-12,  7.533861546468494e-14, -3.290296468936182e-15,  1.300637290116454e-16,
 -4.694570344062976e-18,  5.101506595003853e-06, -1.849949225611379e-06,  3.534899267258079e-07, -4.584546393365394e-08,  4.506680692820886e-09, -3.572258786029260e-10,
  2.375448164911262e-11, -1.362051060025174e-12,  6.871337864456653e-14, -3.097302173773926e-15,  1.262702142469032e-16, -4.696688578205772e-18,  3.558830840200155e-06,
 -1.331381071135189e-06,  2.630487418532072e-07, -3.527337382384406e-08,  3.583148536008118e-09, -2.933003089197026e-10,  2.012621864482024e-11, -1.189979814116417e-12,
  6.185907646188369e-14, -2.871142466943660e-15,  1.204431958309140e-16, -4.606456917131839e-18,  2.505488852501031e-06, -9.641670806182447e-07,  1.963997666599444e-07,
 -2.715296297363290e-08,  2.842528830166935e-09, -2.396425992181760e-10,  1.692568354611079e-11, -1.029372337221413e-12,  5.500516883778375e-14, -2.622680213718268e-15,
  1.129518081503280e-16, -4.432103744674277e-18,  1.780262588374416e-06, -7.027167803768213e-07,  1.471575055310035e-07, -2.091754272394711e-08,  2.250548218222890e-09,
 -1.949005758876635e-10,  1.413237533566140e-11, -8.818797439688190e-13,  4.832333660121048e-14, -2.361388991410971e-15,  1.041697199591413e-16, -4.184305058114556e-18,
  1.276072704844659e-06, -5.152489976350196e-07,  1.106138326629169e-07, -1.612080920564176e-08,  1.777792060326753e-09, -1.577352954762956e-10,  1.171221423689826e-11,
 -7.480304580676061e-13,  4.193052728130585e-14, -2.095001600979361e-15,  9.444644363193497e-17, -3.874900278915928e-18,  9.215519142677546e-07, -3.796210554821809e-07,
  8.331546359297966e-08, -1.241533395527776e-08,  1.399589025304005e-09, -1.268911526931618e-10,  9.623609881714683e-12, -6.275106028227629e-13,  3.589548335604454e-14,
 -1.829397323707925e-15,  8.408780379624911e-17, -3.515796884695710e-18,  6.688973872989859e-07, -2.803838431998697e-07,  6.273621636878159e-08, -9.532798764149079e-09,
  1.095585087188274e-09, -1.012327758792249e-10,  7.821904530664625e-12, -5.194135845457072e-13,  3.024690827373795e-14, -1.568665312492435e-15,  7.334503412674314e-17,
 -3.118135700544188e-18,  4.858711154500803e-07, -2.067185359878214e-07,  4.702773190841242e-08, -7.266843241548413e-09,  8.491683042122353e-10, -7.975819625254263e-11,
  6.262372214079894e-12, -4.224452248309354e-13,  2.498189115167769e-14, -1.315281572612384e-15,  6.241109864256222e-17, -2.691736281246435e-18,  3.505272488663949e-07,
 -1.509979165773132e-07,  3.483249672779039e-08, -5.458730691111649e-09,  6.468493195959663e-10, -6.159621376966774e-11,  4.902034564946911e-12, -3.350808835482977e-13,
  2.007368860785364e-14, -1.070345984047005e-15,  5.142247564583334e-17, -2.244804165343274e-18,  2.477252389271976e-07, -1.077846074688039e-07,  2.514478747149882e-08,
 -3.985660346063244e-09,  4.776593070740560e-10, -4.599403810937737e-11,  3.700567604784714e-12, -2.556775015767129e-13,  1.547837787676270e-14, -8.338390829241521e-16,
  4.046467494790364e-17, -1.783860191673878e-18,  1.668079675981771e-07, -7.313139678569961e-08,  1.720752050161725e-08, -2.751371256964290e-09,  3.325967937419621e-10,
 -3.229957976625966e-11,  2.620552472484393e-12, -1.825472890027507e-13,  1.114023179892286e-14, -6.048731383471192e-16,  2.958007494321778e-17, -1.313846040666908e-18,
  1.000377152742541e-07, -4.408874092909925e-08,  1.043557585581837e-08, -1.678656422420429e-09,  2.041394828549178e-10, -1.994180475974065e-11,  1.627322515377235e-12,
 -1.140041529804949e-13,  6.996070163498367e-15, -3.819344358122906e-16,  1.877753796421108e-17, -8.383838509917600e-19,  4.157384777567798e-08, -1.837582251918859e-08,
  4.363803634154871e-09, -7.043090898212558e-10,  8.593526926152109e-11, -8.422308105607940e-12,  6.895050240678848e-13, -4.845679491342359e-14,  2.982845541614500e-15,
 -1.633353858035850e-16,  8.054107062126757e-18, -3.606433592647196e-19,  6.325327910897008e-02, -1.665436224838773e-04,  4.564902936520631e-07, -1.292252626284670e-09,
  3.744887951580671e-12, -1.102250833804473e-14,  3.274383060282856e-17, -9.772960184505755e-20,  2.921520302617534e-22, -8.730191065551497e-25,  2.604463488545271e-27,
 -7.751605029396866e-30,  6.157481203773449e-02, -2.151583017547557e-04,  8.832293057724446e-07, -3.723238253407663e-09,  1.543944794458893e-11, -6.250848595133928e-14,
  2.474686978049841e-16, -9.609363989542976e-19,  3.669802099136064e-21, -1.381352105652691e-23,  5.133495227376174e-26, -1.886019272679032e-28,  5.835489283473557e-02,
 -3.043575812371118e-04,  1.795424217511204e-06, -9.997024838593991e-09,  5.249811200705055e-11, -2.634322279259856e-13,  1.275055161495466e-15, -5.990386198957929e-18,
  2.743962850945200e-20, -1.229548088522704e-22,  5.403606657204918e-25, -2.333931926936221e-27,  5.384852316330156e-02, -4.197277427482787e-04,  3.274467176204282e-06,
 -2.279299724892987e-08,  1.463281463390368e-10, -8.846872115357822e-13,  5.100269640148426e-15, -2.827143282536675e-17,  1.515827797445218e-19, -7.896827911755586e-22,
  4.011195389942135e-24, -1.992104502529603e-26,  4.839439763586876e-02, -5.433395462799601e-04,  5.367448483354151e-06, -4.566173087835330e-08,  3.517245258365670e-10,
 -2.516586048641590e-12,  1.698562923989424e-14, -1.092772873540876e-16,  6.751399785132793e-19, -4.028043367725364e-21,  2.330782017928858e-23, -1.312465630658250e-25,
  4.237189980902707e-02, -6.571221905496723e-04,  8.032971140970816e-06, -8.226890957100660e-08,  7.496273810493081e-10, -6.263218459063375e-12,  4.887520453317759e-14,
 -3.606492225595765e-16,  2.538695661552819e-18, -1.715984510081033e-20,  1.119406082138870e-22, -7.075462690976385e-25,  3.615710509170353e-02, -7.459536866547261e-04,
  1.111217021062819e-05, -1.353114670893710e-07,  1.441884086012079e-09, -1.392074830392917e-11,  1.243741385331720e-13, -1.042979099792532e-15,  8.292043796565432e-18,
 -6.296942040059808e-20,  4.593816684008276e-22, -3.234040187933019e-24,  3.008487852219080e-02, -7.998276665741328e-04,  1.433715466881667e-05, -2.053458368552258e-07,
  2.534592785099603e-09, -2.803192994252386e-11,  2.844526261520469e-13, -2.690487386645656e-15,  2.398688839337744e-17, -2.032564474742021e-19,  1.647454167198669e-21,
 -1.283649537740341e-23,  2.442208431131087e-02, -8.147607587122603e-04,  1.737479403546151e-05, -2.899162979921655e-07,  4.110766148454437e-09, -5.169487514657455e-11,
  5.917227557372038e-13, -6.272387807579057e-15,  6.233097526246534e-17, -5.859662980921757e-19,  5.247679772031842e-21, -4.501438561439172e-23,  1.935410708737023e-02,
 -7.924534359797329e-04,  1.989142060356526e-05, -3.833554091660798e-07,  6.198408821204528e-09, -8.805036759566234e-11,  1.130065088660919e-12, -1.334995486746610e-14,
  1.470917272899936e-16, -1.526437829032809e-18,  1.503206411236072e-20, -1.413035076812149e-22,  1.498410932532600e-02, -7.390030905685206e-04,  2.161814042107048e-05,
 -4.774332452308033e-07,  8.744161561659188e-09, -1.394833737637195e-10,  1.996422270933359e-12, -2.615273290962104e-14,  3.179965150943259e-16, -3.626618166082115e-18,
  3.910580308385406e-20, -4.011946605171478e-22,  1.134234966988040e-02, -6.631221248224139e-04,  2.239834524391616e-05, -5.627400851061704e-07,  1.160302386610110e-08,
 -2.067149528361212e-10,  3.283377595470892e-12, -4.747853870840067e-14,  6.343793695825699e-16, -7.918958505361213e-18,  9.314121493948707e-20, -1.039057824845308e-21,
  8.401792715448757e-03, -5.743214319547998e-04,  2.220676187474008e-05, -6.304299925498221e-07,  1.455050137845729e-08, -2.880647470116232e-10,  5.054528010484403e-12,
 -8.034267833837210e-14,  1.175011604442301e-15, -1.599540085148568e-17,  2.044925524438872e-19, -2.472290126754269e-21,  6.096153261325107e-03, -4.814132932404975e-04,
  2.113919136016475e-05, -6.738396805805423e-07,  1.731626420407940e-08, -3.791696902657409e-10,  7.318436603451955e-12, -1.273718468014387e-13,  2.031556188074399e-15,
 -3.005548823131550e-17,  4.162929350555845e-19, -5.437417677839144e-21,  4.337190195612336e-03, -3.915251619394681e-04,  1.938024187460520e-05, -6.895635733935772e-07,
  1.963107788135991e-08, -4.733308802065319e-10,  1.000929838414292e-11, -1.900415474574295e-13,  3.294382241049712e-15, -5.279712414784540e-17,  7.898618079820853e-19,
 -1.111347622988196e-20,  3.029135798848977e-03, -3.096550429175182e-04,  1.716057122227581e-05, -6.777667630425372e-07,  2.127444341538301e-08, -5.624649717779399e-10,
  1.298190296679139e-11, -2.679515913385989e-13,  5.031995733928826e-15, -8.709466965344443e-17,  1.403273444788637e-18, -2.121040781649189e-20,  2.079268782673176e-03,
 -2.386805207919196e-04,  1.471508895803108e-05, -6.417598899591454e-07,  2.211064184731799e-08, -6.384378198190674e-10,  1.602479243436200e-11, -3.583738821229761e-13,
  7.268284333840140e-15, -1.354668681219289e-16,  2.344209737147369e-18, -3.796384318741049e-20,  1.404566709309315e-03, -1.796728885031265e-04,  1.225040602536804e-05,
 -5.870523775996395e-07,  2.210522140993131e-08, -6.944372330820246e-10,  1.888995619300244e-11, -4.562604983643320e-13,  9.963854634069173e-15, -1.994178030091737e-16,
  3.696500396680057e-18, -6.397886796888959e-20,  9.349871229443840e-04, -1.323602422343705e-04,  9.925393492148132e-06, -5.201897261359801e-07,  2.132030336577437e-08,
 -7.260422971953814e-10,  2.133216978379371e-11, -5.547759020713930e-13,  1.300780683503840e-14, -2.788069972226335e-16,  5.521847069665465e-18, -1.018931462052685e-19,
  6.142205689840679e-04, -9.561164163100372e-05,  7.844669418500654e-06, -4.476631140699864e-07,  1.989290284134194e-08, -7.317583886062113e-10,  2.314821940057373e-11,
 -6.462596309957000e-13,  1.622397375894838e-14, -3.714349618452752e-16,  7.840440229999587e-18, -1.538825147075117e-19,  3.987982535268132e-04, -6.785849792489541e-05,
  6.062152678777629e-06, -3.750891105350330e-07,  1.800394264108610e-08, -7.129566475931842e-10,  2.420671205230237e-11, -7.233958123962363e-13,  1.939163783791058e-14,
 -4.729968999678468e-16,  1.061555908489957e-17, -2.210946765527920e-19,  2.563160651482035e-04, -4.741307900540747e-05,  4.590736663714867e-06, -3.067415790741138e-07,
  1.584620937191993e-08, -6.733178531956987e-10,  2.446248757548549e-11, -7.803112639795648e-13,  2.227650520195105e-14, -5.774652428325718e-16,  1.374704033775053e-17,
 -3.031444376940364e-19,  1.633435704253209e-04, -3.267789078924502e-05,  3.414336186157445e-06, -2.454173942495342e-07,  1.359772993216663e-08, -6.179829917800702e-10,
  2.395432445683985e-11, -8.133593954192541e-13,  2.466483200988052e-14, -6.778425066528640e-16,  1.707656367268078e-17, -3.978140207958134e-19,  1.033868581034377e-04,
 -2.226056132318505e-05,  2.499504281652594e-06, -1.925545591657312e-07,  1.140410584852636e-08, -5.526378835058713e-10,  2.278892142191764e-11, -8.214510661491377e-13,
  2.639302795765141e-14, -7.671228458002095e-16,  2.040461629534157e-17, -5.010645054794838e-19,  6.510570969816815e-05, -1.501798352616512e-05,  1.804979387920735e-06,
 -1.484989440066787e-07,  9.370412518251735e-09, -4.827190955614551e-10,  2.111678230459903e-11, -8.059224405119343e-13,  2.736680129585626e-14, -8.392493643995006e-16,
  2.351584382226948e-17, -6.073887389542895e-19,  4.086319269247044e-05, -1.005424201301563e-05,  1.288546745351815e-06, -1.128246707228069e-07,  7.561136077631987e-09,
 -4.128525944282182e-10,  1.910621950517876e-11, -7.700392163809581e-13,  2.756711113629205e-14, -8.898683281584988e-16,  2.620736141352432e-17, -7.104473694516986e-19,
  2.560852631089594e-05, -6.692940859157382e-06,  9.113113715421227e-07, -8.463887837893926e-08,  6.005559503303494e-09, -3.465566484355293e-10,  1.692058016806426e-11,
 -7.182978992863616e-13,  2.704363471410621e-14, -9.167493079359481e-16,  2.831413351784462e-17, -8.038581393993460e-19,  1.605314194559390e-05, -4.438919291623311e-06,
  6.398652209015793e-07, -6.283134140102608e-08,  4.705894170432147e-09, -2.861787284302064e-10,  1.470177215027682e-11, -6.556919484816304e-13,  2.589907572354200e-14,
 -9.198334712176452e-16,  2.972671944820331e-17, -8.819766282229152e-19,  1.008416762525625e-05, -2.938882113089233e-06,  4.469556794796633e-07, -4.625475118990975e-08,
  3.645949126863726e-09, -2.330019011181899e-10,  1.256103717731529e-11, -5.870759479579386e-13,  2.426887526849678e-14, -9.009589831123475e-16,  3.039894795527632e-17,
 -9.405207332483257e-19,  6.359085934063290e-06, -1.946103464776433e-06,  3.112218611148743e-07, -3.383876795383025e-08,  2.798879085043765e-09, -1.874477968090714e-10,
  1.057625891796938e-11, -5.167056021765970e-13,  2.230074752804596e-14, -8.633698382776218e-16,  3.034559546203564e-17, -9.769414835251131e-19,  4.032481751915491e-06,
 -1.291325227506377e-06,  2.164455568648932e-07, -2.465012499373576e-08,  2.133281919505147e-09, -1.493128018669123e-10,  8.794145383239807e-12, -4.479756940246566e-13,
  2.013736016647648e-14, -8.111339574294493e-16,  2.963215883416361e-17, -9.905093823866247e-19,  2.575654007945993e-06, -8.601212400008379e-07,  1.506261206621268e-07,
 -1.791395197025668e-08,  1.617478233846381e-09, -1.179924029981548e-10,  7.235351184200928e-12, -3.833357535458914e-13,  1.790397542556378e-14, -7.485829106438706e-16,
  2.835991333872235e-17, -9.821472729487869e-19,  1.659605257065164e-06, -5.760403950989517e-07,  1.050673278401594e-07, -1.301044143782763e-08,  1.222156414701259e-09,
 -9.266806064006569e-11,  5.900810950867608e-12, -3.243392987973064e-13,  1.570145003365885e-14, -6.798518773320266e-16,  2.664958107406113e-17, -9.540827235421059e-19,
  1.080239586358252e-06, -3.884704344769986e-07,  7.357289737924675e-08, -9.458080384812362e-09,  9.217311718622492e-10, -7.244705301834666e-11,  4.778006469943252e-12,
 -2.717756904323862e-13,  1.360395808444547e-14, -6.085586071164286e-16,  2.462633657263071e-17, -9.094094848078146e-19,  7.111074612616267e-07, -2.641315088437064e-07,
  5.178664346618950e-08, -6.891340740978049e-09,  6.947957791329941e-10, -5.645665088623403e-11,  3.846392388468617e-12, -2.258388384915249e-13,  1.166024381091799e-14,
 -5.376252392727376e-16,  2.240790064485564e-17, -8.516414890912600e-19,  4.738322291709876e-07, -1.812402769099072e-07,  3.667763930329456e-08, -5.037771123213939e-09,
  5.240041766037765e-10, -4.389993145388502e-11,  3.081636344831157e-12, -1.862983794313140e-13,  9.897072839222078e-15, -4.692227902343867e-16,  2.009645769953895e-17,
 -7.843220352944680e-19,  3.197336549915005e-07, -1.255739558039599e-07,  2.615311496505951e-08, -3.697176753393260e-09,  3.956430946987506e-10, -3.408266920711789e-11,
  2.458636650721252e-12, -1.526517109304037e-13,  8.323698311367914e-15, -4.048060669347357e-16,  1.777430698016185e-17, -7.107243209839762e-19,  2.184662283234218e-07,
 -8.785120743101337e-08,  1.877549773980572e-08, -2.724039267509728e-09,  2.990750748200186e-10, -2.642043865962014e-11,  1.953461711989660e-12, -1.242464009793577e-13,
  6.936449420201534e-15, -3.452046498600955e-16,  1.550262748718631e-17, -6.336547599720374e-19,  1.510158920856276e-07, -6.200713747709188e-08,  1.356003307845453e-08,
 -2.013392877796143e-09,  2.261655713183667e-10, -2.043352773673605e-11,  1.544434718813617e-12, -1.003706303868925e-13,  5.722870692235263e-15, -2.907399767221302e-16,
  1.332249771674645e-17, -5.553519591244753e-19,  1.053883939655574e-07, -4.406565260093688e-08,  9.832437420450850e-09, -1.489875038650505e-09,  1.707563957458511e-10,
 -1.573533623421323e-11,  1.212597724790661e-12, -8.031435164443757e-14,  4.665120013520093e-15, -2.413460386027085e-16,  1.125730002263120e-17, -4.774632442462496e-19,
  7.395311994588136e-08, -3.140591157259683e-08,  7.130015182601621e-09, -1.099457071499061e-09,  1.282131310148477e-10, -1.201811827151141e-11,  9.417612919301616e-13,
 -6.340628963035826e-14,  3.742540685094596e-15, -1.966791761909984e-16,  9.315769321688517e-18, -4.010764898888893e-19,  5.180268180487324e-08, -2.228624041101745e-08,
  5.133554796901704e-09, -8.033152494651262e-10,  9.505276452031787e-11, -9.038448294990101e-12,  7.183019955171583e-13, -4.903254296304239e-14,  2.933454607796016e-15,
 -1.562093682686082e-16,  7.495138447782076e-18, -3.267858866220884e-19,  3.573501361316238e-08, -1.553495780521545e-08,  3.620635734932022e-09, -5.733440941600280e-10,
  6.864601178353637e-11, -6.603701567910053e-12,  5.308246051669787e-13, -3.664210660299503e-14,  2.216292708602244e-15, -1.192905871238559e-16,  5.784031319816349e-18,
 -2.547741332091232e-19,  2.361671766123321e-08, -1.034868830583087e-08,  2.433603848988670e-09, -3.888903848709183e-10,  4.698339164233872e-11, -4.560108824728632e-12,
  3.697665995996977e-13, -2.574372778080545e-14,  1.570204937730244e-15, -8.521132321776502e-17,  4.164932485580634e-18, -1.848988508770444e-19,  1.397976107350320e-08,
 -6.159505094513721e-09,  1.457474163264145e-09, -2.343743873616335e-10,  2.849310888981619e-11, -2.782552763489831e-12,  2.269973236990561e-13, -1.589784057605660e-14,
  9.753135462945486e-16, -5.322967789932983e-17,  2.616259786874801e-18, -1.167790462346351e-19,  5.767539571322107e-09, -2.548923915755790e-09,  6.052105237050481e-10,
 -9.766390833269520e-11,  1.191438723873096e-11, -1.167511925887603e-12,  9.556486736903340e-14, -6.715014193422890e-15,  4.132903689500305e-16, -2.262757117982765e-17,
  1.115601442628964e-18, -4.994645743640017e-20,  6.259431166882518e-02, -1.629527261325497e-04,  4.413356323372495e-07, -1.234056234182904e-09,  3.532079992498541e-12,
 -1.026846546547718e-14,  3.013370066041483e-17, -8.886413761198258e-20,  2.625192268141464e-22, -7.753491943762624e-25,  2.286486344231299e-27, -6.727732506773032e-30,
  6.072803333956831e-02, -2.082670761757107e-04,  8.399923990075600e-07, -3.485894659984958e-09,  1.424655799102028e-11, -5.687928754526080e-14,  2.221345254314428e-16,
 -8.510786843937275e-19,  3.207561509295335e-21, -1.191684581413431e-23,  4.371740134230250e-26, -1.585717113247742e-28,  5.716544916800699e-02, -2.904601550935849e-04,
  1.680331107127235e-06, -9.197596825335781e-09,  4.752239045494526e-11, -2.347483977643690e-13,  1.118980488024426e-15, -5.179161255612174e-18,  2.337878777259980e-20,
 -1.032614242327512e-22,  4.474251048459742e-25, -1.905692634954633e-27,  5.222032586927899e-02, -3.945875707631719e-04,  3.014435648874732e-06, -2.058690571827341e-08,
  1.297970724223928e-10, -7.712570201448871e-13,  4.372516077264917e-15, -2.384631064789528e-17,  1.258428804373869e-19, -6.454775682196249e-22,  3.229065172532351e-24,
 -1.579791142576516e-26,  4.630357852909401e-02, -5.024997387250730e-04,  4.851681327390078e-06, -4.041564102502222e-08,  3.052335859866422e-10, -2.143334633809351e-12,
  1.420774844688724e-14, -8.982373882034809e-17,  5.456080203961029e-19, -3.201718505067034e-21,  1.822826628985023e-23, -1.010231532398414e-25,  3.986596195496320e-02,
 -5.966125528544423e-04,  7.113772180389743e-06, -7.121652840244169e-08,  6.353202373038881e-10, -5.202753116836513e-12,  3.982731863581073e-14, -2.884882587787490e-16,
  1.994561065970613e-18, -1.324798127754568e-20,  8.495756728195856e-23, -5.280861468852986e-25,  3.334132845298347e-02, -6.631792359522811e-04,  9.618165252791670e-06,
 -1.143158729115469e-07,  1.191099950314013e-09, -1.125820031122729e-11,  9.856852817565613e-14, -8.106184060475040e-16,  6.324253678964972e-18, -4.715386250243448e-20,
  3.379116320337220e-22, -2.337735384265844e-24,  2.710027604247175e-02, -6.943379399190704e-04,  1.209895957928393e-05, -1.689306701390169e-07,  2.036541939316472e-09,
 -2.202866642278968e-11,  2.188497377955620e-13, -2.028292529410621e-15,  1.773122086183919e-17, -1.474114186681334e-19,  1.172857969179242e-21, -8.974732828659102e-24,
  2.142048525208313e-02, -6.886341042896057e-04,  1.425865891586083e-05, -2.316995074198220e-07,  3.205743441928818e-09, -3.939379612766447e-11,  4.411167696780971e-13,
 -4.578382349169262e-15,  4.458119464589694e-17, -4.109289321425116e-19,  3.610351853625162e-21, -3.039739594840875e-23,  1.647563613252519e-02, -6.501620204875726e-04,
  1.583253752823036e-05, -2.969134561269785e-07,  4.680886972170944e-09, -6.492941547418829e-11,  8.146642442456523e-13, -9.417363143259795e-15,  1.016145194588740e-16,
 -1.033379029580870e-18,  9.978605389743363e-21, -9.202470204628262e-23,  1.234080040925266e-02, -5.867926091875466e-04,  1.664412119517991e-05, -3.574703972012285e-07,
  6.379788556367071e-09, -9.931732183350565e-11,  1.388948540764234e-12, -1.779534324554511e-14,  2.117997508011007e-16, -2.366070050257917e-18,  2.500693327680883e-20,
 -2.515995658628984e-22,  9.009540243117510e-03, -5.080793418215009e-04,  1.663564908484860e-05, -4.062984343735904e-07,  8.159878542445437e-09, -1.418125257283253e-10,
  2.199974090662548e-12, -3.110154285140729e-14,  4.066212422057332e-16, -4.970325618825060e-18,  5.728164295811528e-20, -6.265017759826469e-22,  6.416962264475808e-03,
 -4.233687856195642e-04,  1.586775800555774e-05, -4.378159451322997e-07,  9.839966523741910e-09, -1.899828593592325e-10,  3.254902595206192e-12, -5.056790574658347e-14,
  7.234639350914697e-16, -9.641450360595346e-18,  1.207496095704061e-19, -1.430964081476537e-21,  4.463476276388455e-03, -3.404539038912192e-04,  1.449311677080523e-05,
 -4.489955383737482e-07,  1.123452301299936e-08, -2.398735285453748e-10,  4.519959916992153e-12, -7.687677755199939e-14,  1.199314822351494e-15, -1.736765268837061e-17,
  2.356256583287483e-19, -3.016393723256690e-21,  3.035453184011687e-03, -2.648854731997014e-04,  1.271547083621033e-05, -4.397625438978172e-07,  1.219051432163675e-08,
 -2.866089940299257e-10,  5.916772804608515e-12, -1.097790646222226e-13,  1.861275669110510e-15, -2.919738394715611e-17,  4.278357963085473e-19, -5.899798096929495e-21,
  2.020741244311094e-03, -1.998730463235195e-04,  1.074706948068703e-05, -4.126988290360483e-07,  1.261610806393665e-08, -3.252860355182244e-10,  7.330034213224296e-12,
 -1.478587381892138e-13,  2.715974108355794e-15, -4.601516185284574e-17,  7.262242839339290e-19, -1.075886907151610e-20,  1.318577863831726e-03, -1.466000531504288e-04,
  8.774613670003881e-06, -3.722341586623604e-07,  1.249387119934023e-08, -3.519061713787868e-10,  8.625626796257083e-12, -1.885552515433102e-13,  3.741129550868135e-15,
 -6.826488411605086e-17,  1.157301879351223e-18, -1.837280696014799e-20,  8.445405439308683e-04, -1.047502423551050e-04,  6.938866470522615e-06, -3.236175980415613e-07,
  1.187664234772530e-08, -3.640873949111250e-10,  9.674634445824685e-12, -2.284797120715934e-13,  4.882567034553189e-15, -9.569494195764276e-17,  1.738232628322670e-18,
 -2.949933950239625e-20,  5.317493799444019e-04, -7.307309196677942e-05,  5.328159398908688e-06, -2.719550845646112e-07,  1.086960441656881e-08, -3.613813586584122e-10,
  1.037665081200887e-11, -2.639625378218891e-13,  6.058630950869442e-15, -1.272123482756940e-16,  2.469713152494575e-18, -4.469981680370878e-20,  3.296530684039502e-04,
 -4.987415654572165e-05,  3.982671675074585e-06, -2.215089768616188e-07,  9.605294302852059e-09, -3.451585368016265e-10,  1.067623376913732e-11, -2.916913728852696e-13,
  7.171657918248704e-15, -1.609125557137376e-16,  3.330930943349022e-18, -6.414880809459069e-20,  2.015586968397562e-04, -3.337678445051158e-05,  2.904991486345387e-06,
 -1.753347890006441e-07,  8.218710790459277e-09, -3.181519857533290e-10,  1.056888732222596e-11, -3.092707977705337e-13,  8.123845951716906e-15, -1.943018402060520e-16,
  4.278549233081019e-18, -8.748139872580806e-20,  1.217610090149956e-04, -2.194855751589009e-05,  2.072734460258356e-06, -1.352266354600534e-07,  6.827882679156207e-09,
 -2.838259571630884e-10,  1.009636870273948e-11, -3.155677811508229e-13,  8.833459312973765e-15, -2.246687432232316e-16,  5.250635207532063e-18, -1.137308247211209e-19,
  7.280824966383732e-05, -1.421385056306789e-05,  1.450181337780073e-06, -1.018815517950479e-07,  5.522443678648549e-09, -2.457446603953662e-10,  9.334047769974446e-12,
 -3.107807829250016e-13,  9.247350297379589e-15, -2.495142980465228e-16,  6.174979572496652e-18, -1.413884567243196e-19,  4.317723270734205e-05, -9.085009240474188e-06,
  9.973131714741820e-07, -7.517627961340668e-08,  4.360113508956116e-09, -2.070729070948087e-10,  8.374578235907486e-12, -2.962535623783352e-13,  9.347128924642570e-15,
 -2.669354486228110e-16,  6.979917514483506e-18, -1.685837943927818e-19,  2.544465913469090e-05, -5.744109396664007e-06,  6.758078774604986e-07, -5.446585116536659e-08,
  3.369236614993302e-09, -1.702727719564857e-10,  7.312094843250952e-12, -2.741169143064538e-13,  9.148327322987057e-15, -2.758757685728925e-16,  7.605062872298760e-18,
 -1.933468485014846e-19,  1.493128871727883e-05, -3.600731235211662e-06,  4.523249019840112e-07, -3.884421557904812e-08,  2.554860425820910e-09, -1.369965749975810e-10,
  6.229954872576772e-12, -2.468668012427486e-13,  8.693793542083374e-15, -2.762015377005134e-16,  8.009527050807156e-18, -2.138922793715573e-19,  8.743158445645119e-06,
 -2.242977497592303e-06,  2.997548430349914e-07, -2.733888321346949e-08,  1.906021759288128e-09, -1.081336342763618e-10,  5.193390945307993e-12, -2.169767468615507e-13,
  8.043720001125307e-15, -2.686110447635666e-16,  8.176071653774008e-18, -2.288615508861686e-19,  5.119594324832789e-06, -1.391634843049854e-06,  1.971605421315608e-07,
 -1.903584347042209e-08,  1.402564251405479e-09, -8.395079060391779e-11,  4.246957638092526e-12, -1.866088825201276e-13,  7.264964498903218e-15, -2.544235545044265e-16,
  8.110848985450885e-18, -2.374753942103955e-19,  3.004216765873404e-06, -8.619665392704195e-07,  1.290188990223717e-07, -1.314533033566673e-08,  1.020571289389899e-09,
 -6.426975134595913e-11,  3.415693694763015e-12, -1.574482118735370e-13,  6.421818913390706e-15, -2.353122772730354e-16,  7.839478657159584e-18, -2.395763361865540e-19,
  1.770456893285080e-06, -5.342071777695717e-07,  8.419621959758616e-08, -9.024645144151942e-09,  7.361346315943013e-10, -4.863894453037892e-11,  2.708552866461461e-12,
 -1.306515706972197e-13,  5.569482431588709e-15, -2.130427508740254e-16,  7.400883257466625e-18, -2.355694911384147e-19,  1.050059909038775e-06, -3.320119048507442e-07,
  5.492119327305704e-08, -6.174058115530603e-09,  5.275942232884043e-10, -3.647540350983498e-11,  2.122749446048342e-12, -1.068828801390727e-13,  4.750571824968319e-15,
 -1.892608409889429e-16,  6.840465641015654e-18, -2.262905904259591e-19,  6.280678177488123e-07, -2.073772022964481e-07,  3.588901045368650e-08, -4.218673975715501e-09,
  3.765859096015012e-10, -2.716760472519289e-11,  1.648012584621025e-12, -8.639986130700054e-14,  3.994302927986200e-15, -1.653520284862288e-16,  6.203947456230386e-18,
 -2.128391898948830e-19,  3.795841133543524e-07, -1.304436610950713e-07,  2.354353569028215e-08, -2.885185420173618e-09,  2.682773416520340e-10, -2.014070004944480e-11,
  1.270158083081011e-12, -6.916079984375062e-14,  3.317601448467420e-15, -1.423733516387874e-16,  5.532696006366454e-18, -1.964127592802947e-19,  2.322196986039781e-07,
 -8.278712138803808e-08,  1.553508932466276e-08, -1.978871327637420e-09,  1.911250719314835e-10, -1.489112506367551e-11,  9.737441420583117e-13, -5.492845653653790e-14,
  2.727318430381591e-15, -1.210455923683980e-16,  4.860842159918952e-18, -1.781676791897522e-19,  1.440351606721387e-07, -5.310179381938951e-08,  1.032841163609339e-08,
 -1.363518715497617e-09,  1.364020430649091e-10, -1.099927647182914e-11,  7.438249609298379e-13, -4.335776345588839e-14,  2.222840886797633e-15, -1.017869611530399e-16,
  4.214074710167274e-18, -1.591207522381027e-19,  9.069391055753490e-08, -3.447158302068478e-08,  6.928586347445049e-09, -9.451998076861866e-10,  9.765921503282019e-11,
 -8.128316303160130e-12,  5.669509349331311e-13, -3.406199720355005e-14,  1.798595115958074e-15, -8.476926434421694e-17,  3.609746277290644e-18, -1.400935497591214e-19,
  5.802477360116629e-08, -2.266936395454146e-08,  4.694398286076888e-09, -6.598449009404270e-10,  7.021507105826911e-11, -6.015448232580385e-12,  4.316114601951233e-13,
 -2.665765416322299e-14,  1.446155890227929e-15, -6.998098628155780e-17,  3.057836783318634e-18, -1.216939648354025e-19,  3.773230198475989e-08, -1.510827125060627e-08,
  3.213818222163569e-09, -4.640877236863655e-10,  5.071707403353225e-11, -4.460082217053089e-12,  3.283084101901808e-13, -2.079129578683483e-14,  1.155850694041188e-15,
 -5.728662955103434e-17,  2.562349439163680e-18, -1.043252649459759e-19,  2.492653102429606e-08, -1.020003616581603e-08,  2.222245094821487e-09, -3.287173996353091e-10,
  3.678799351932022e-11, -3.311620298194893e-12,  2.494134208242942e-13, -1.615275070989921e-14,  9.178671087166700e-16, -4.647641219548408e-17,  2.122807647409996e-18,
 -8.821212503630419e-20,  1.669985957604505e-08, -6.964361561492240e-09,  1.549461132070513e-09, -2.340986230858001e-10,  2.675294504217641e-11, -2.458330556948738e-12,
  1.889198190443140e-13, -1.247895611679688e-14,  7.229364662850749e-16, -3.730415883241112e-17,  1.735633853846244e-18, -7.343445385538297e-20,  1.130524589310466e-08,
 -4.791726676943234e-09,  1.085506448696693e-09, -1.670218191767681e-10,  1.943530782476492e-11, -1.817927718526618e-12,  1.421614089166985e-13, -9.551999276294737e-15,
  5.626910008849366e-16, -2.951369382576253e-17,  1.395293473021321e-18, -5.996217340123002e-20,  7.679605586868283e-09, -3.299371086256477e-09,  7.588391809939051e-10,
 -1.185625937474246e-10,  1.400759728129133e-11, -1.329969438147722e-12,  1.055400120217892e-13, -7.194005809266689e-15,  4.297898882488879e-16, -2.285537793604112e-17,
  1.095164456227634e-18, -4.768661439190803e-20,  5.165627635000461e-09, -2.243628439511341e-09,  5.223833516271761e-10, -8.263766703083122e-11,  9.884173637668150e-12,
 -9.499092614004105e-13,  7.628230860350970e-14, -5.260660051004470e-15,  3.178944801073440e-16, -1.709492159275126e-17,  8.281433578435116e-19, -3.644634453495137e-20,
  3.347884250714667e-09, -1.466238566059432e-09,  3.445941613351393e-10, -5.503261261681398e-11,  6.644682434059147e-12, -6.445342397027516e-13,  5.223289764476783e-14,
 -3.634448806077488e-15,  2.215538309300652e-16, -1.201658753640722e-17,  5.870266136696370e-19, -2.604687746063645e-20,  1.954924351680300e-09, -8.610994410564218e-10,
  2.036897737691946e-10, -3.274438941195279e-11,  3.979473759619924e-12, -3.884990952393751e-13,  3.168329151949228e-14, -2.218262721655617e-15,  1.360463164074602e-16,
 -7.422777977952395e-18,  3.647253908477992e-19, -1.627516115343559e-20,  8.004084495788794e-10, -3.536843585714111e-10,  8.396428209894019e-11, -1.354720337800543e-11,
  1.652397950787559e-12, -1.618945193896567e-13,  1.324944536139219e-14, -9.308416871040759e-16,  5.728151729647787e-17, -3.135656014955086e-18,  1.545723113966337e-19,
 -6.919275103585017e-21,  6.194946968219583e-02, -1.594803304042412e-04,  4.268593850327490e-07, -1.179147443664097e-09,  3.333746026250581e-12, -9.574190904502741e-15,
  2.775903980582703e-17, -8.089303456837215e-20,  2.361840476036493e-22, -6.895416285159703e-25,  2.010293858118827e-27, -5.848408091074345e-30,  5.990814534427017e-02,
 -2.017106694775444e-04,  7.994927089745601e-07, -3.266768653273397e-09,  1.316041258341896e-11, -5.182280749530256e-14,  1.996791453173917e-16, -7.549765019191285e-19,
  2.808420639922994e-21, -1.030001200421352e-23,  3.730596431701904e-26, -1.336134423432177e-28,  5.602981261780057e-02, -2.774464123703012e-04,  1.574371756185285e-06,
 -8.473386998635615e-09,  4.308465424289434e-11, -2.095518418720622e-13,  9.839025274524268e-16, -4.487222003427658e-18,  1.996429905891670e-20, -8.693439161638805e-23,
  3.714399331458934e-25, -1.560336202862508e-27,  5.068869029357820e-02, -3.714260886044176e-04,  2.779362137917452e-06, -1.862807101829897e-08,  1.153695162249445e-10,
 -6.738945592520380e-13,  3.757873821276352e-15, -2.016750337042343e-17,  1.047723703142818e-19, -5.292098668908731e-22,  2.607802019353764e-24, -1.257061089310953e-26,
  4.436824794778336e-02, -4.655463569462235e-04,  4.394639218087060e-06, -3.585713122977717e-08,  2.655827947324656e-10, -1.830658206604618e-12,  1.192074355795027e-14,
 -7.407600335477076e-17,  4.424657778103064e-19, -2.554275065325230e-21,  1.431084094782900e-23, -7.807427548967620e-26,  3.758815358794401e-02, -5.429555455648196e-04,
  6.316891792217712e-06, -6.183453235285179e-08,  5.402049263074896e-10, -4.337035501142269e-12,  3.257593816879370e-14, -2.316801569417625e-16,  1.573589505567176e-18,
 -1.027258189772647e-20,  6.477283786203762e-23, -3.960145274798577e-25,  3.083424997494400e-02, -5.914134107442794e-04,  8.353686176900689e-06, -9.693837726194538e-08,
  9.878657642111068e-10, -9.143534925946582e-12,  7.846677700738091e-14, -6.329829213016449e-16,  4.847105429033878e-18, -3.549091715434973e-20,  2.498782192227149e-22,
 -1.699109352042668e-24,  2.450440901579871e-02, -6.051327169110738e-04,  1.025363495123991e-05, -1.396034212661204e-07,  1.644204053744410e-09, -1.739826082680639e-11,
  1.692636844338792e-13, -1.537467733604818e-15,  1.318161964335714e-17, -1.075397404726965e-19,  8.400606961374098e-22, -6.314058479860995e-24,  1.887763473242165e-02,
 -5.848707937245101e-04,  1.176176709470467e-05, -1.861762551488620e-07,  2.514130332294948e-09, -3.019685831511838e-11,  3.308550166537544e-13, -3.363028955551961e-15,
  3.209409620904321e-17, -2.901141453973247e-19,  2.501029325498607e-21, -2.067208113157243e-23,  1.410741875205176e-02, -5.365725754798428e-04,  1.267929897182690e-05,
 -2.314291061898761e-07,  3.558222039941511e-09, -4.820607379735533e-11,  5.914152526494091e-13, -6.691171057610775e-15,  7.071757905375374e-17, -7.048902795142833e-19,
  6.675386330626564e-21, -6.040628105517684e-23,  1.023503282839971e-02, -4.692028997845407e-04,  1.290682182287510e-05, -2.696299399121276e-07,  4.690077573157817e-09,
 -7.126822783543521e-11,  9.740203852576207e-13, -1.220731904017174e-14,  1.422415382948587e-16, -1.556759238716763e-18,  1.612927986052364e-20, -1.591711376872168e-22,
  7.215385586793899e-03, -3.924752733423759e-04,  1.245836297629349e-05, -2.958332212119503e-07,  5.788034414043076e-09, -9.814368612476053e-11,  1.487263449645369e-12,
 -2.055920977669949e-14,  2.630478717496810e-16, -3.148956281000197e-18,  3.556418397745271e-20, -3.814037896730313e-22,  4.947527093798101e-03, -3.150288266774060e-04,
  1.144575305328061e-05, -3.069674887066747e-07,  6.719069332755530e-09, -1.265301687782535e-10,  2.116928044604566e-12, -3.214908091074357e-14,  4.499965230809096e-16,
 -5.871619648400886e-18,  7.204620181791629e-20, -8.369931229640656e-22,  3.303304374395439e-03, -2.433346204737245e-04,  1.004263345679946e-05, -3.023895588149032e-07,
  7.367665227412836e-09, -1.534069482678839e-10,  2.822314079895744e-12, -4.691502056721272e-14,  7.159330666408521e-16, -1.014920609146233e-17,  1.348829797050721e-19,
 -1.692506158370602e-21,  2.150101020244722e-03, -1.813447442264938e-04,  8.441851133872699e-06, -2.837916625598520e-07,  7.660435921326566e-09, -1.756264439809473e-10,
  3.539692606090169e-12, -6.418231405519908e-14,  1.064383290701563e-15, -1.634382561101706e-17,  2.345870577433467e-19, -3.170656052298724e-21,  1.366100258004537e-03,
 -1.307131209301007e-04,  6.818643302505451e-06, -2.545772276666718e-07,  7.579175182649188e-09, -1.905757747171785e-10,  4.192885783927119e-12, -8.265829063077838e-14,
  1.485150207527532e-15, -2.463093425446866e-17,  3.807860271771589e-19, -5.529385194166315e-21,  8.484563553645254e-04, -9.134188713165705e-05,  5.307015490235680e-06,
 -2.189672814858376e-07,  7.159581731947519e-09, -1.967043654592629e-10,  4.708221696744697e-12, -1.006008040525058e-13,  1.952669982996575e-15, -3.488293105778922e-17,
  5.793554070506639e-19, -9.016254959864449e-21,  5.158889656920497e-04, -6.202359518717800e-05,  3.990922045153553e-06, -1.811235762545112e-07,  6.477916433800253e-09,
 -1.937696534016070e-10,  5.029404722534651e-12, -1.161277804236048e-13,  2.428293179238115e-15, -4.660436842938608e-17,  8.295062068646558e-19, -1.380274717598046e-20,
  3.075859300911930e-04, -4.101756192461633e-05,  2.907476257877987e-06, -1.444982350115429e-07,  5.631180191660539e-09, -1.827597027379427e-10,  5.127940651282192e-12,
 -1.275817618153988e-13,  2.866344324216433e-15, -5.895261266731363e-17,  1.121821543690822e-18, -1.991361373171192e-20,  1.801403744447674e-04, -2.647887075713437e-05,
  2.057366406361575e-06, -1.114986649700929e-07,  4.717128939706404e-09, -1.655583515462739e-10,  5.006509536276585e-12, -1.338435742601115e-13,  3.222439502515664e-15,
 -7.085149845052515e-17,  1.438118507358889e-18, -2.717351334912328e-20,  1.038216104974525e-04, -1.672421116074419e-05,  1.417700671220516e-06, -8.344615806388830e-08,
  3.818937566637730e-09, -1.444835051927451e-10,  4.695184340651896e-12, -1.345104862876531e-13,  3.461726709824311e-15, -8.117330961004167e-17,  1.753497487620820e-18,
 -3.519232866961817e-20,  5.899842208840577e-05, -1.035913000846533e-05,  9.538049312237180e-07, -6.073972487339488e-08,  2.996740621978968e-09, -1.218370476378056e-10,
  4.242547875920872e-12, -1.299041913754264e-13,  3.564796956517821e-15, -8.894036931564076e-17,  2.040220630000625e-18, -4.340060546918790e-20,  3.312512839420369e-05,
 -6.307632854428465e-06,  6.281548079998087e-07, -4.311870748891097e-08,  2.285822644761847e-09, -9.956708594877412e-11,  3.704820253326414e-12, -1.209291983417818e-13,
  3.529898995702503e-15, -9.349180473195395e-17,  2.272438198621933e-18, -5.113085075592165e-20,  1.841495558534985e-05, -3.784692381457741e-06,  4.060177385597857e-07,
 -2.993522576172318e-08,  1.699660614625972e-09, -7.908575013085715e-11,  3.135942750509258e-12, -1.088410711770466e-13,  3.371338697570145e-15, -9.457493248646784e-17,
  2.430517133295495e-18, -5.772536199095791e-20,  1.015900376869583e-05, -2.243333275183530e-06,  2.582526877603957e-07, -2.038094051664162e-08,  1.235507467613831e-09,
 -6.123364491646270e-11,  2.580550523047902e-12, -9.499592231219062e-14,  3.115032778816354e-15, -9.234680226408100e-17,  2.503908043761753e-18, -6.264302108911776e-20,
  5.574509013934140e-06, -1.316908868601073e-06,  1.620795700077243e-07, -1.364571781145327e-08,  8.804978420685391e-10, -4.634995584362953e-11,  2.070489031547850e-12,
 -8.064012102354251e-14,  2.792759365814409e-15, -8.729834102063148e-17,  2.492003712647027e-18, -6.553900315411739e-20,  3.049835299497995e-06, -7.676008441533689e-07,
  1.006393634179407e-07, -9.009664225152698e-09,  6.169444484173849e-10, -3.439761071993645e-11,  1.624477030246117e-12, -6.677319017093277e-14,  2.436629271565188e-15,
 -8.013164594434970e-17,  2.403060398797804e-18, -6.630118429714103e-20,  1.667727185420765e-06, -4.454176832335673e-07,  6.199316407820208e-08, -5.882636052021711e-09,
  4.262167063929934e-10, -2.509990247079274e-11,  1.249934147220986e-12, -5.408967372862030e-14,  2.074854257989403e-15, -7.162614015280899e-17,  2.251740961536903e-18,
 -6.504059019899320e-20,  9.137656205484852e-07, -2.579857877786331e-07,  3.798732968041525e-08, -3.808857344063794e-09,  2.911427362330096e-10, -1.805986595772171e-11,
  9.458711719023732e-13, -4.298598883182932e-14,  1.729277803244761e-15, -6.252315600964112e-17,  2.056062580694807e-18, -6.204526786768335e-20,  5.029170796069854e-07,
 -1.495429655511635e-07,  2.321832711876704e-08, -2.452310404918934e-09,  1.971892890382714e-10, -1.284909447030253e-11,  7.059375697988239e-13, -3.360901778306410e-14,
  1.414595178591899e-15, -5.344615280064571e-17,  1.834485763685235e-18, -5.771389574581132e-20,  2.787384320302179e-07, -8.697906032608740e-08,  1.419332574453528e-08,
 -1.574323915827609e-09,  1.327855608926990e-10, -9.064359253024058e-12,  5.210503263837181e-13, -2.592304334617332e-14,  1.138852727078482e-15, -4.486078702407700e-17,
  1.603653798019111e-18, -5.248634610693443e-20,  1.559572113949450e-07, -5.089278615028240e-08,  8.700323288674915e-09, -1.010414541714888e-09,  8.913791726270135e-11,
 -6.357144509818540e-12,  3.813483752551328e-13, -1.977699024516885e-14,  9.046996605103614e-16, -3.706932060192667e-17,  1.377003813041434e-18, -4.678463833759951e-20,
  8.829897226857237e-08, -3.003069242175888e-08,  5.361397506712822e-09, -6.499708267619996e-10,  5.980288650742432e-11, -4.443740140788223e-12,  2.774520234422550e-13,
 -1.496112802516792e-14,  7.109146730416919e-16, -3.022884752178843e-17,  1.164222011164995e-18, -4.097173230351587e-20,  5.070170432522342e-08, -1.791247279074964e-08,
  3.329206129031170e-09, -4.200597276868146e-10,  4.019419536274908e-11, -3.103311203190448e-12,  2.011397480311474e-13, -1.124884312605425e-14,  5.538643785288296e-16,
 -2.438205191614048e-17,  9.713588105523362e-19, -3.532974987921409e-20,  2.958654630666450e-08, -1.082307467392973e-08,  2.087658892240667e-09, -2.733317646789462e-10,
  2.712202806162300e-11, -2.169808015122871e-12,  1.456032947133904e-13, -8.423601642929251e-15,  4.287018320738519e-16, -1.949118559081295e-17,  8.013605702941698e-19,
 -3.005496452963304e-20,  1.757656544293651e-08, -6.636626571339405e-09,  1.324466922235478e-09, -1.794065380755256e-10,  1.840776757166738e-11, -1.521705647894443e-12,
  1.054364159216413e-13, -6.293666385238089e-15,  3.302385107959864e-16, -1.546905903768217e-17,  6.547895850994050e-19, -2.526473757888887e-20,  1.064458315736626e-08,
 -4.135842286857041e-09,  8.513565452486818e-10, -1.189544009473305e-10,  1.258400960240187e-11, -1.071920433408865e-12,  7.648094017259410e-14, -4.697950853999370e-15,
  2.535057969010488e-16, -1.220387544550519e-17,  5.305594528141472e-19, -2.101122380366494e-20,  6.576809213833117e-09, -2.621602189382588e-09,  5.549363235382837e-10,
 -7.974196621017815e-11,  8.672389660721400e-12, -7.590483506131109e-13,  5.561585818934182e-14, -3.506204634255897e-15,  1.940641022053550e-16, -9.577062456271923e-18,
  4.265791695402654e-19, -1.729747785949867e-20,  4.145434658226182e-09, -1.690282923303750e-09,  3.668128084771753e-10, -5.404586643902119e-11,  6.025004752471091e-12,
 -5.403031932455212e-13,  4.054153293690586e-14, -2.616066673804115e-15,  1.481298659837863e-16, -7.474701676003232e-18,  3.402573173734945e-19, -1.409290462006730e-20,
  2.662132747344382e-09, -1.107142254143829e-09,  2.455731182796252e-10, -3.698864586371648e-11,  4.214324486343495e-12, -3.861082281185352e-13,  2.958606701960556e-14,
 -1.948760063430060e-15,  1.125849001923622e-16, -5.793837341273236e-18,  2.688591031885952e-19, -1.134631748596171e-20,  1.736113664937867e-09, -7.343541798470852e-10,
  1.659822723651612e-10, -2.548062059037687e-11,  2.958336743099114e-12, -2.761026425246431e-13,  2.154438877120013e-14, -1.444530726302427e-15,  8.491886218765880e-17,
 -4.445093360522723e-18,  2.097331362489849e-19, -8.995926472451580e-21,  1.142208300109510e-09, -4.900223406343285e-10,  1.125224889711680e-10, -1.755234081419098e-11,
  2.070410357094634e-12, -1.962692808532149e-13,  1.555105762656445e-14, -1.058426168647109e-15,  6.314049358038233e-17, -3.352872701926794e-18,  1.604351496287418e-19,
 -6.976285060270393e-21,  7.483421768798800e-10, -3.247287762802313e-10,  7.552691274103336e-11, -1.193513984943996e-11,  1.426038933402572e-12, -1.369059919116905e-13,
  1.098303798604568e-14, -7.566703001951833e-16,  4.568007578090107e-17, -2.454131656935256e-18,  1.187770639554564e-19, -5.222611461873024e-21,  4.752197340754974e-10,
 -2.080109691334386e-10,  4.885579523523645e-11, -7.797421224645112e-12,  9.408708606928990e-13, -9.120758468032242e-14,  7.386918086154800e-15, -5.136854398602092e-16,
  3.129557444008921e-17, -1.696427087426402e-18,  8.282616805741138e-20, -3.673052562059749e-21,  2.735687103619471e-10, -1.204652874836520e-10,  2.848609733150183e-11,
 -4.577761890404516e-12,  5.561542672317543e-13, -5.427687277465356e-14,  4.424992761389684e-15, -3.097099713600017e-16,  1.898853538350352e-17, -1.035705241440982e-18,
  5.087486336716770e-20, -2.269514667347502e-21,  1.111189200150269e-10, -4.909397446810485e-11,  1.165289645634201e-11, -1.879811116304709e-12,  2.292474028751780e-13,
 -2.245678955912672e-14,  1.837552417935301e-15, -1.290759281115945e-16,  7.941677869822107e-18, -4.346657688259821e-19,  2.142342748113940e-20, -9.588468330470588e-22,
  6.131828975679712e-02, -1.561211619437134e-04,  4.130234515476555e-07, -1.127303935025795e-09,  3.148745230767420e-12, -8.934322361520735e-15,  2.559622129216616e-17,
 -7.371729090905449e-20,  2.127480614452163e-22, -6.140455675709839e-25,  1.770016643175540e-27, -5.091946691075677e-30,  5.911385122711980e-02, -1.954680301828242e-04,
  7.615215059270468e-07, -3.064240328493055e-09,  1.217021820814284e-11, -4.727435746366846e-14,  1.797442206776756e-16, -6.707629574261025e-19,  2.463122392383924e-21,
 -8.918958469014112e-24,  3.189805195572183e-26, -1.128229313404841e-28,  5.494458907381952e-02, -2.652467522609115e-04,  1.476692977123725e-06, -7.816319272162291e-09,
  3.911993817699255e-11, -1.873764893933501e-13,  8.667535206532562e-16, -3.895700152227150e-18,  1.708634747503583e-20, -7.336337762937253e-23,  3.091436204028453e-25,
 -1.281016156420425e-27,  4.924608299035322e-02, -3.500549518108421e-04,  2.566471353438331e-06, -1.688526701786108e-08,  1.027496606819550e-10, -5.901199215361566e-13,
  3.237395170360403e-15, -1.710051384817790e-17,  8.747241318669276e-20, -4.351693887985146e-22,  2.112667143746948e-24, -1.003563039426192e-26,  4.257375004375266e-02,
 -4.320408319762083e-04,  3.988689850558294e-06, -3.188584464663154e-08,  2.316705267954003e-10, -1.567931117706217e-12,  1.003176680576014e-14, -6.128426483632073e-17,
  3.600384440115831e-19, -2.045052221210283e-21,  1.127758992280185e-23, -6.057633035548027e-26,  3.551290133195064e-02, -4.952478598997125e-04,  5.624006445005115e-06,
 -5.384480761944822e-08,  4.607850105472918e-10, -3.627692056128272e-12,  2.674164370774188e-14, -1.867744445593590e-16,  1.246498842697188e-18, -7.999274471904055e-21,
  4.960282818859448e-23, -2.983450528764688e-25,  2.859524981331949e-02, -5.289815260394645e-04,  7.279541735998616e-06, -8.249889507920901e-08,  8.224772998597207e-10,
 -7.456602461262215e-12,  6.273563220727064e-14, -4.965265406094741e-16,  3.732675041648697e-18, -2.684524895310840e-20,  1.857317910627713e-22, -1.241535480552834e-24,
  2.223792467734654e-02, -5.293824587103287e-04,  8.725431579020434e-06, -1.158729810809800e-07,  1.333607105952906e-09, -1.380821493476262e-11,  1.315812183466780e-13,
 -1.171620508321639e-15,  9.853560563337073e-18, -7.890162406602422e-20,  6.052521340768948e-22, -4.469245563161922e-24,  1.671309869388203e-02, -4.990725208644141e-04,
  9.750393440330904e-06, -1.503802774871321e-07,  1.982532222666505e-09, -2.327926506377966e-11,  2.496262595816075e-13, -2.485464783442391e-15,  2.325106692949253e-17,
 -2.061566701918906e-19,  1.744186402592354e-21, -1.415507707879494e-23,  1.214768432096125e-02, -4.453475057267045e-04,  1.021425754623237e-05, -1.814987023772629e-07,
  2.722093037287573e-09, -3.602635245241184e-11,  4.322684186588709e-13, -4.787477871562806e-15,  4.956917561715099e-17, -4.843657267597630e-19,  4.499321237655185e-21,
 -3.995717425904994e-23,  8.545906404687725e-03, -3.777154785840180e-04,  1.007829059813386e-05, -2.048290746373758e-07,  3.473245358152810e-09, -5.152670177330401e-11,
  6.883287191155212e-13, -8.440289788549700e-15,  9.629959821875455e-17, -1.032721234106009e-18,  1.049071555610978e-20, -1.015592005185056e-22,  5.824375666362714e-03,
 -3.055715036869666e-04,  9.405026658104727e-06, -2.171681308065420e-07,  4.139980273563063e-09, -6.850176343389659e-11,  1.014191249942151e-12, -1.371071605107972e-14,
  1.717013874920902e-16, -2.013284510922859e-18,  2.228572973912777e-20, -2.343806135773275e-22,  3.849561734097167e-03, -2.365454548182958e-04,  8.331834958596783e-06,
 -2.172258358066554e-07,  4.631262360967939e-09, -8.507587702930027e-11,  1.390158691489158e-12, -2.063994476741386e-14,  2.826846648050497e-16, -3.611825592705186e-18,
  4.342503866840616e-20, -4.946148412661371e-22,  2.470215802110258e-03, -1.757155568214222e-04,  7.030810500333688e-06, -2.057757692782742e-07,  4.882549927781045e-09,
 -9.914973340476767e-11,  1.781161130014106e-12, -2.894002336667724e-14,  4.320401794340287e-16, -5.996206173870843e-18,  7.807012424774845e-20, -9.602926428080424e-22,
  1.540847532473859e-03, -1.255880349705023e-04,  5.669274414455095e-06, -1.852573072252749e-07,  4.869667691761979e-09, -1.088753561197273e-10,  2.142463643748420e-12,
 -3.796707311594191e-14,  6.158997634577792e-16, -9.257984186981283e-18,  1.301701574588433e-19, -1.724519021979944e-21,  9.355670979659264e-04, -8.657984672899437e-05,
  4.381309624609004e-06, -1.590348616555667e-07,  4.611108936824311e-09, -1.130743219395749e-10,  2.428986093751732e-12, -4.679978484535471e-14,  8.225214653281090e-16,
 -1.335387725584827e-17,  2.022330718607905e-19, -2.878471114505415e-21,  5.537596325091285e-04, -5.771217514508314e-05,  3.254450053734290e-06, -1.305912677392560e-07,
  4.159398544192008e-09, -1.114658354467092e-10,  2.605297033612271e-12, -5.441203723298500e-14,  1.033199682466900e-15, -1.806997982044997e-17,  2.940173499038659e-19,
 -4.485458665343358e-21,  3.200308230784123e-04, -3.728498772068421e-05,  2.329995720342830e-06, -1.028870937714703e-07,  3.585752156004674e-09, -1.046498286053294e-10,
  2.653057952695783e-12, -5.988973574872076e-14,  1.225361815292867e-15, -2.302815213549615e-17,  4.016169578278518e-19, -6.552182932370256e-21,  1.808977414642800e-04,
 -2.340168844074708e-05,  1.612210735884372e-06, -7.800455409724412e-08,  2.963585792023671e-09, -9.388104769060227e-11,  2.573765644670627e-12, -6.262353898767687e-14,
  1.377054464187898e-15, -2.774052388277527e-17,  5.173801909116230e-19, -9.006902907374188e-21,  1.001950733032194e-04, -1.430361853547995e-05,  1.081070116755016e-06,
 -5.707670097217986e-08,  2.355465545649799e-09, -8.073229557048977e-11,  2.386466562418328e-12, -6.241949190034684e-14,  1.471460512835107e-15, -3.170005991448487e-17,
  6.308580439638735e-19, -1.169415569292938e-20,  5.448631413529143e-05, -8.534657611103171e-06,  7.044144821924812e-07, -4.042369198397055e-08,  1.805824468408293e-09,
 -6.675901570758474e-11,  2.121809383734809e-12, -5.950212850674820e-14,  1.500088555048233e-15, -3.448105686992231e-17,  7.306106238785097e-19, -1.439117634920991e-20,
  2.915192354340097e-05, -4.983647782326620e-06,  4.472298376181402e-07, -2.779130944343446e-08,  1.339440661150332e-09, -5.324942064192701e-11,  1.814690048554744e-12,
 -5.442277999666153e-14,  1.463808885627402e-15, -3.581986672894718e-17,  8.063771081925031e-19, -1.684376694308568e-20,  1.537981192367024e-05, -2.855207903735471e-06,
  2.774354282389545e-07, -1.860123224835038e-08,  9.641165432287950e-10, -4.109649399573153e-11,  1.497656350528778e-12, -4.791308525628840e-14,  1.371694291324894e-15,
 -3.565422212881211e-17,  8.509841961173033e-19, -1.881230558764986e-20,  8.019685933158672e-06, -1.609151948711471e-06,  1.686326116662429e-07, -1.215650815516653e-08,
  6.754719390832229e-10, -3.078374378481073e-11,  1.196460558403287e-12, -4.073161462875463e-14,  1.238303458621275e-15, -3.411479826364335e-17,  8.614800011195230e-19,
 -2.011503148090092e-20,  4.143390702712411e-06, -8.945369213692284e-07,  1.007190389988043e-07, -7.780355505100240e-09,  4.620390969417558e-10, -2.244967023585712e-11,
  9.281595338065684e-13, -3.354180244937047e-14,  1.080376474509887e-15, -3.147797383046521e-17,  8.392678741637351e-19, -2.065709792644704e-20,  2.126494932903468e-06,
 -4.918667867242434e-07,  5.928391518182890e-08, -4.891233632917435e-09,  3.095108758920421e-10, -1.598898490587447e-11,  7.013706226847887e-13, -2.684038691184589e-14,
  9.138526105293316e-16, -2.809827222417483e-17,  7.893411798285832e-19, -2.043920203240366e-20,  1.087036925384299e-06, -2.682762506314614e-07,  3.449091893739546e-08,
 -3.029607073461741e-09,  2.036766979780261e-10, -1.115605268367333e-11,  5.178901419305132e-13, -2.093664432669663e-14,  7.517948282087176e-16, -2.434047372527021e-17,
  7.189559008525359e-19, -1.954631494583696e-20,  5.550029639481473e-07, -1.455686027911140e-07,  1.989400537754544e-08, -1.854544316877539e-09,  1.320766379430069e-10,
 -7.649614438290213e-12,  3.748501723403350e-13, -1.597005933665317e-14,  6.034028124907881e-16, -2.052640968606446e-17,  6.361577077394053e-19, -1.812243433800490e-20,
  2.838229425221893e-07, -7.881180858535661e-08,  1.141067129784763e-08, -1.125419547842050e-09,  8.466139911422291e-11, -5.170934036217081e-12,  2.667900391185448e-13,
 -1.194939760151962e-14,  4.739727278704106e-16, -1.690351518742048e-17,  5.485152461943908e-19, -1.633973442713871e-20,  1.457981411116739e-07, -4.270260467412734e-08,
  6.528318084069025e-09, -6.791471339687507e-10,  5.381128910532926e-11, -3.456642719074906e-12,  1.872950300409633e-13, -8.797766059671349e-15,  3.654901875494430e-16,
 -1.363480661547098e-17,  4.622638729729069e-19, -1.436989046646771e-20,  7.545165280936821e-08, -2.322531434594891e-08,  3.736972767472823e-09, -4.088126583978317e-10,
  3.401986908482886e-11, -2.292119056555009e-12,  1.300957239173677e-13, -6.393110687177883e-15,  2.775170710527654e-16, -1.080515792746259e-17,  3.819060015485459e-19,
 -1.236274014364258e-20,  3.945041019903969e-08, -1.271764997653594e-08,  2.146736798731828e-09, -2.462151959436411e-10,  2.145766504805572e-11, -1.512277664814559e-12,
  8.967798301973625e-14, -4.598962896057462e-15,  2.081019287468396e-16, -8.437017628586713e-18,  3.101967905561282e-19, -1.043423562169288e-20,  2.089915374113351e-08,
 -7.031615369846877e-09,  1.241242211320849e-09, -1.488050311457838e-10,  1.354260165917345e-11, -9.956557451908103e-13,  6.152550384073477e-14, -3.284446472445364e-15,
  1.545488884486717e-16, -6.509328060564110e-18,  2.483863042191405e-19, -8.662981351877471e-21,  1.124810622470752e-08, -3.936579534982777e-09,  7.243959076189548e-10,
 -9.050150413172542e-11,  8.576477779412027e-12, -6.559601726053055e-13,  4.212743824963420e-14, -2.335056056488985e-15,  1.139776467943269e-16, -4.975243916009144e-18,
  1.965844399105294e-19, -7.093099687554848e-21,  6.165989198209218e-09, -2.237324362346574e-09,  4.278333424574652e-10, -5.553470332802829e-11,  5.464242061243985e-12,
 -4.335618225892870e-13,  2.886124031340114e-14, -1.656713581558639e-15,  8.367593741793856e-17, -3.776298648123895e-18,  1.541427871344840e-19, -5.740720891747564e-21,
  3.450465392012716e-09, -1.293876962685430e-09,  2.563098356744116e-10, -3.446289367267098e-11,  3.510451785655036e-12, -2.881469622466058e-13,  1.982771030022162e-14,
 -1.175605148261562e-15,  6.128262017027668e-17, -2.852327689690778e-18,  1.199872330675455e-19, -4.601730546712363e-21,  1.974733912411877e-09, -7.628566679085247e-10,
  1.560567258547901e-10, -2.166934466912165e-11,  2.278372442410409e-12, -1.929158512387907e-13,  1.368426791740263e-14, -8.358026922340470e-16,  4.485112378135090e-17,
 -2.147509620069372e-18,  9.287170377251415e-20, -3.659116163988081e-21,  1.157307411521125e-09, -4.591534213150087e-10,  9.669554410021448e-11, -1.382353159053532e-11,
  1.495804525290243e-12, -1.302736419217657e-13,  9.499215442649968e-15, -5.960465016696076e-16,  3.283925463864608e-17, -1.613377608746441e-18,  7.154975286446775e-20,
 -2.889005528553327e-21,  6.948414989401631e-10, -2.822599617712320e-10,  6.100267822375270e-11, -8.951062389849552e-12,  9.938099362722250e-13, -8.876744823292343e-14,
  6.634780408692587e-15, -4.265071003609642e-16,  2.406090144460128e-17, -1.209748267403272e-18,  5.487564857299440e-20, -2.265091240266768e-21,  4.270304212435423e-10,
 -1.770837684110124e-10,  3.915349259464803e-11, -5.878469048798262e-12,  6.676496899985622e-13, -6.097922498759558e-14,  4.658461839706075e-15, -3.059337277105741e-16,
  1.762357645054953e-17, -9.043903432724680e-19,  4.185238942105492e-20, -1.761525202253520e-21,  2.678810196410401e-10, -1.130682261743057e-10,  2.549554704255268e-11,
 -3.904559877427824e-12,  4.522535861447092e-13, -4.211113049671684e-14,  3.278494651708808e-15, -2.193329593650064e-16,  1.286592548563939e-17, -6.720478395317254e-19,
  3.164397678071820e-20, -1.354561586164563e-21,  1.704662600309910e-10, -7.302241713552926e-11,  1.673980152556348e-11, -2.606810992930364e-12,  3.069748248153053e-13,
 -2.905251797285295e-14,  2.298220184768206e-15, -1.561738497523995e-16,  9.302242763815742e-18, -4.932243186289697e-19,  2.356623306464867e-20, -1.023281252471233e-21,
  1.086601496082918e-10, -4.710461007357217e-11,  1.094371083307073e-11, -1.727448253972529e-12,  2.061714155338984e-13, -1.977185208667128e-14,  1.584472800755698e-15,
 -1.090476852033572e-16,  6.576490663538183e-18, -3.529660920111588e-19,  1.706653716408399e-20, -7.497028967642754e-22,  6.754886813856185e-11, -2.954989130217037e-11,
  6.935846306446780e-12, -1.106226708175084e-12,  1.333937139932299e-13, -1.292269343202524e-14,  1.045941652494359e-15, -7.268908154179432e-17,  4.425765075212266e-18,
 -2.397617340946169e-19,  1.169922661089195e-20, -5.185228961612087e-22,  3.831085677597789e-11, -1.686491201417823e-11,  3.986613547098042e-12, -6.404287471871574e-13,
  7.777860683487613e-14, -7.588028399324299e-15,  6.184126556653477e-16, -4.326884299140487e-17,  2.651969572851666e-18, -1.446015375695949e-19,  7.100719122155533e-21,
 -3.166630941533905e-22,  1.543207699542294e-11, -6.817082568420108e-12,  1.617815385480328e-12, -2.609349487886832e-13,  3.181598719563332e-14, -3.116105527174559e-15,
  2.549344599377384e-16, -1.790438078364309e-17,  1.101418917897459e-18, -6.027301456105341e-20,  2.970192768341811e-21, -1.329151052401770e-22,  6.070032900063074e-02,
 -1.528702418282583e-04,  3.997922934504023e-07, -1.078320813643738e-09,  2.976038576735814e-12, -8.344032710964468e-15,  2.362422000650213e-17, -6.724980485177179e-20,
  1.918646617106777e-22, -5.475269214424697e-25,  1.560661479203207e-27, -4.440103433997623e-30,  5.834393514872468e-02, -1.895197017371182e-04,  7.258885040265115e-07,
 -2.876852577030561e-09,  1.126639318461834e-11, -4.317725398105431e-14,  1.620197683252578e-16, -5.968434941120364e-19,  2.163859109704972e-21, -7.736984520696962e-24,
  2.732699702732130e-26, -9.546541402876721e-29,  5.390664976772969e-02, -2.537980287946473e-04,  1.386532553880992e-06, -7.219286258974628e-09,  3.557190304230576e-11,
 -1.678239336001547e-13,  7.649479552227416e-16, -3.388913733919434e-18,  1.465491014379083e-20, -6.205480569308263e-23,  2.579337931116344e-25, -1.054468406244140e-27,
  4.788568175133166e-02, -3.303065962333098e-04,  2.373335880745430e-06, -1.533162735720197e-08,  9.168702844121518e-11, -5.178658228953634e-13,  2.795524753102830e-15,
 -1.453657015958861e-17,  7.322674965559092e-20, -3.588714772613676e-22,  1.716766828928613e-24, -8.037633978200636e-27,  4.090706835224903e-02, -4.016011204020080e-04,
  3.627306085433489e-06, -2.841746461798692e-08,  2.025869864233850e-10, -1.346523366555509e-12,  8.466628582062536e-15, -5.085887842483131e-17,  2.939328199632359e-19,
 -1.643053245952334e-21,  8.919811049745247e-24, -4.718037868306954e-26,  3.361797173664384e-02, -4.527203216290533e-04,  5.019818124190211e-06, -4.701950735490126e-08,
  3.942477727881028e-10, -3.044394487379461e-12,  2.202968703019356e-14, -1.511354030892399e-16,  9.912869677365079e-19, -6.254780408349576e-21,  3.814966396540935e-23,
 -2.257744644261718e-25,  2.658982799119299e-02, -4.744922503490076e-04,  6.363844098458501e-06, -7.045500246355964e-08,  6.873418255584854e-10, -6.105127095423722e-12,
  5.036947664440264e-14, -3.912103694870840e-16,  2.887777150758363e-18, -2.040365628113157e-20,  1.387444661928576e-22, -9.118989853769047e-25,  2.025168117435681e-02,
 -4.647980946517667e-04,  7.454395462201231e-06, -9.658354470485759e-08,  1.086538649352904e-09, -1.101076628912465e-11,  1.027944345285686e-13, -8.974406304801518e-16,
  7.405310027023427e-18, -5.821199822264644e-20,  4.385833250311675e-22, -3.182198987395453e-24,  1.486210317285508e-02, -4.277817591666943e-04,  8.121782117074724e-06,
 -1.220811640199342e-07,  1.571627266117110e-09, -1.804567985504074e-11,  1.894233815335250e-13, -1.847842455697746e-15,  1.694830490429505e-17, -1.474256536539979e-19,
  1.224312570528570e-21, -9.757544318257427e-24,  1.051690595639210e-02, -3.716562855020080e-04,  8.275525362595752e-06, -1.431882989608572e-07,  2.095314649621282e-09,
 -2.709621104863418e-11,  3.180336956969727e-13, -3.448694923363846e-15,  3.498808730162191e-17, -3.352175689171677e-19,  3.054872589997252e-21, -2.662894093300656e-23,
  7.181967484987429e-03, -3.060490906334326e-04,  7.922467760846763e-06, -1.566783403671329e-07,  2.590431398574102e-09, -3.752619006321442e-11,  4.900841749343004e-13,
 -5.880565992535821e-15,  6.570851305855710e-17, -6.905818177146922e-19,  6.879135780271938e-21, -6.533986776536272e-23,  4.737527859121363e-03, -2.397254219801757e-04,
  7.155188464373045e-06, -1.606863799974878e-07,  2.985200462327012e-09, -4.820838576243143e-11,  6.974363845086181e-13, -9.222219529512154e-15,  1.130578089250385e-16,
 -1.298658317250161e-18,  1.409136223747432e-20, -1.453546023860596e-22,  3.021801752679173e-03, -1.791763556573693e-04,  6.118952316175536e-06, -1.551045421574313e-07,
  3.221384975186235e-09, -5.773403630711920e-11,  9.214999217965880e-13, -1.337762926610968e-14,  1.793007613631385e-16, -2.243553885917823e-18,  2.643395769350622e-20,
 -2.952262977560496e-22,  1.865901254422055e-03, -1.281551356982708e-04,  4.971620559221362e-06, -1.414460538397021e-07,  3.268697882751121e-09, -6.474325086933028e-11,
  1.135804127444390e-12, -1.803988511407501e-14,  2.634925414306844e-16, -3.580607450872718e-18,  4.567619465141581e-20, -5.508003473616402e-22,  1.116796849236966e-03,
 -8.795062481938079e-05,  3.849967766230284e-06, -1.222939053049846e-07,  3.130565556649110e-09, -6.826146495681427e-11,  1.311591553181624e-12, -2.271787797598099e-14,
  3.605142988755762e-16, -5.305307914676974e-18,  7.307693609434633e-20, -9.490240940500376e-22,  6.488295428961437e-04, -5.806212889033008e-05,  2.850088790438004e-06,
 -1.005788219355204e-07,  2.840108696504590e-09, -6.792311140256036e-11,  1.424652672947941e-12, -2.682809505038299e-14,  4.612432966003177e-16, -7.330902849289671e-18,
  1.087587826268976e-19, -1.517416000907334e-21,  3.664559921850610e-04, -3.696327839409219e-05,  2.022825541769981e-06, -7.893587478900169e-08,  2.448971816322273e-09,
 -6.401367056104781e-11,  1.461027429508822e-12, -2.982564666513219e-14,  5.540428710985682e-16, -9.486574208571958e-18,  1.512208650265524e-19, -2.261529194760629e-21,
  2.015438062086589e-04, -2.274740680147930e-05,  1.380335076472936e-06, -5.929870020015052e-08,  2.013671467489199e-09, -5.733618005906662e-11,  1.419692618160845e-12,
 -3.133069497065242e-14,  6.272136871272777e-16, -1.154165033878240e-17,  1.972288215412794e-19, -3.154732959069112e-21,  1.081321405120261e-04, -1.356565320911926e-05,
  9.081338878311491e-07, -4.276910272665559e-08,  1.583921369687039e-09, -4.896983628242756e-11,  1.311626929651294e-12, -3.120821187826854e-14,  6.716246237643656e-16,
 -1.325110277478684e-17,  2.422124572915528e-19, -4.135020377570930e-21,  5.670488752313913e-05, -7.859151151379829e-06,  5.776519428902815e-07, -2.970494645084415e-08,
  1.195590392051182e-09, -4.001167717947524e-11,  1.156014226180163e-12, -2.957878993070975e-14,  6.826595280123671e-16, -1.440855206990106e-17,  2.811110184349884e-19,
 -5.111673026675032e-21,  2.912539958253487e-05, -4.434453984455126e-06,  3.562495794846384e-07, -1.992690139573702e-08,  8.687404529795570e-10, -3.137629514681622e-11,
  9.751850489693022e-13, -2.676511084955411e-14,  6.609055520395520e-16, -1.488978392032308e-17,  3.094230096290236e-19, -5.981058519494201e-21,  1.468513893892235e-05,
 -2.443261644221552e-06,  2.136252845429863e-07, -1.295001366352205e-08,  6.095547226843790e-10, -2.369008791575361e-11,  7.899591102919777e-13, -2.319967184172902e-14,
  6.115052373645315e-16, -1.467379321844391e-17,  3.241332036694599e-19, -6.647230861161082e-21,  7.285715576653179e-06, -1.318071083344577e-06,  1.249177163115394e-07,
 -8.177922847340993e-09,  4.143006113186672e-10, -1.727739050767032e-11,  6.165043198515506e-13, -1.932670914074662e-14,  5.425516828638011e-16, -1.383725838422398e-17,
  3.242423315427788e-19, -7.041098433551052e-21,  3.565754858336932e-06, -6.981720904494438e-07,  7.144324012065222e-08, -5.033875390495391e-09,  2.736395815899127e-10,
 -1.221073945921231e-11,  4.650569720719461e-13, -1.552515052612663e-14,  4.631390867620627e-16, -1.252763005669353e-17,  3.107816670180017e-19, -7.132580058029639e-21,
  1.726139151529511e-06, -3.641675118548764e-07,  4.008573827456565e-08, -3.029831122709398e-09,  1.761985749809488e-10, -8.390312951803914e-12,  3.402112529859984e-13,
 -1.206587795514514e-14,  3.816460024773244e-16, -1.092578187007566e-17,  2.863758559962831e-19, -6.932924600776296e-21,  8.288305057852712e-07, -1.876119690960640e-07,
  2.213458057162054e-08, -1.788910189879740e-09,  1.109705312033487e-10, -5.623721486582022e-12,  2.421642985101850e-13, -9.102879653799695e-15,  3.046089070557131e-16,
 -9.209888795833863e-18,  2.545450010373082e-19, -6.487821932416015e-21,  3.959122332921507e-07, -9.576137925078789e-08,  1.206706129817067e-08, -1.039534039749591e-09,
  6.858658174432414e-11, -3.689215056355918e-12,  1.682870256387573e-13, -6.688930040536442e-15,  2.362742907482402e-16, -7.528873135769063e-18,  2.189726960717052e-19,
 -5.864589070291538e-21,  1.887144084830222e-07, -4.858273923893932e-08,  6.516430719969707e-09, -5.965152532372765e-10,  4.174099138440105e-11, -2.376734562789238e-12,
  1.145626949526189e-13, -4.803554391252923e-15,  1.787092608920870e-16, -5.988755126711099e-18,  1.829198842042304e-19, -5.137725950848143e-21,  9.004483156762777e-08,
 -2.457891925027937e-08,  3.497470641891388e-09, -3.391661338041710e-10,  2.509933702592267e-11, -1.508862105508725e-12,  7.666031230405074e-14, -3.382776375346002e-15,
  1.322518406927042e-16, -4.650831910077895e-18,  1.488749999145536e-19, -4.376533468615446e-21,  4.314896258373861e-08, -1.244195351693483e-08,  1.872035977783847e-09,
 -1.917358203676191e-10,  1.496349772247525e-11, -9.471829245282311e-13,  5.059637694006445e-14, -2.344041332948472e-15,  9.608268899689724e-17, -3.538041861044530e-18,
  1.184426270621342e-19, -3.636930743427517e-21,  2.083403662070513e-08, -6.323139735139225e-09,  1.002724551988066e-09, -1.081414993124210e-10,  8.875101507381823e-12,
 -5.899640752705091e-13,  3.305001597877127e-14, -1.603642614793169e-15,  6.875923813612554e-17, -2.645272388789570e-18,  9.241416105251467e-20, -2.957912916171504e-21,
  1.016972971999395e-08, -3.237217704672416e-09,  5.393193114476866e-10, -6.106211867818389e-11,  5.254971793409966e-12, -3.658497084357367e-13,  2.143839244109516e-14,
 -1.086798920775332e-15,  4.862844749971890e-17, -1.950133762958450e-18,  7.094211467010903e-20, -2.361842982714973e-21,  5.035094095288149e-09, -1.675199822808297e-09,
  2.922647337570106e-10, -3.463454060424203e-11,  3.116621203926441e-12, -2.266273895455657e-13,  1.385517838444686e-14, -7.319857156787366e-16,  3.409692786839748e-17,
 -1.422051035644043e-18,  5.374674951414511e-20, -1.857188499281698e-21,  2.536644925029522e-09, -8.790976685109333e-10,  1.601024693542042e-10, -1.979817280981228e-11,
  1.857475731618485e-12, -1.406851160102213e-13,  8.949657241687150e-15, -4.914982399649257e-16,  2.377591034568707e-17, -1.028798760252145e-18,  4.030562451929554e-20,
 -1.442308083974460e-21,  1.304329177840577e-09, -4.692790862402202e-10,  8.893245753568082e-11, -1.144090571861228e-11,  1.115874926440070e-12, -8.778493687189016e-14,
  5.795146956867275e-15, -3.299695811176788e-16,  1.653477848736446e-17, -7.405031244759756e-19,  3.000094165876876e-20, -1.109228411581361e-21,  6.864341384550488e-10,
 -2.555535710207125e-10,  5.023373849894196e-11, -6.702506284912203e-12,  6.775902548084819e-13, -5.520956821218765e-14,  3.771815182490409e-15, -2.220743021949171e-16,
  1.149775686973477e-17, -5.316086227152654e-19,  2.221876229811268e-20, -8.467927943760010e-22,  3.706236991856994e-10, -1.423150518097825e-10,  2.892426258248447e-11,
 -3.990267241076407e-12,  4.168760487150765e-13, -3.507834726269888e-14,  2.473140186158302e-15, -1.501600510633842e-16,  8.011504037404273e-18, -3.814441661063615e-19,
  1.640580750093808e-20, -6.429472662502982e-22,  2.056734487151283e-10, -8.119841148410078e-11,  1.700850381535442e-11, -2.418502614921091e-12,  2.603204190813281e-13,
 -2.255515699341675e-14,  1.636390339331208e-15, -1.021748388069844e-16,  5.602424857673229e-18, -2.739623532555744e-19,  1.209447238964631e-20, -4.861900681372036e-22,
  1.174229987123720e-10, -4.751289896967239e-11,  1.022447921777469e-11, -1.493794793997343e-12,  1.651474843638773e-13, -1.468971694203095e-14,  1.093502222721110e-15,
 -7.001580661751989e-17,  3.934608429687157e-18, -1.970819089722117e-19,  8.907070497113306e-21, -3.663435709464587e-22,  6.894789220217421e-11, -2.850524597112354e-11,
  6.281505426151232e-12, -9.399329152870438e-13,  1.063998284239595e-13, -9.686411722430353e-15,  7.376400663750899e-16, -4.829290658927759e-17,  2.773557235386667e-18,
 -1.419118597008157e-19,  6.548391266941869e-21, -2.748458084937515e-22,  4.154005896624562e-11, -1.749404311387937e-11,  3.934872573095338e-12, -6.011005671661259e-13,
  6.945119183073382e-14, -6.451164756134853e-15,  5.010518779702820e-16, -3.344285469290287e-17,  1.957293797968957e-18, -1.020128191640193e-19,  4.793014648804583e-21,
 -2.047411308516089e-22,  2.553224389991469e-11, -1.091995787038951e-11,  2.498903449418258e-12, -3.884507846479794e-13,  4.566311140538239e-14, -4.314167392607279e-15,
  3.406994460095033e-16, -2.311380549912595e-17,  1.374519889037404e-18, -7.276537608048690e-20,  3.471393382791407e-21, -1.505081229973612e-22,  1.581542579367014e-11,
 -6.848968653270024e-12,  1.589362431269240e-12, -2.505845571331338e-13,  2.987266204267912e-14, -2.861527345429631e-15,  2.290607120639906e-16, -1.574737688397582e-17,
  9.486865056682085e-19, -5.086381901160440e-20,  2.456854332723706e-21, -1.078183756498505e-22,  9.615442143114213e-12, -4.203788730639161e-12,  9.860173442695853e-13,
 -1.571539519784695e-13,  1.893717784119591e-14, -1.833312544724114e-15,  1.482860146643526e-16, -1.029857642143819e-17,  6.266394845974902e-19, -3.392631869138213e-20,
  1.654426553567740e-21, -7.328218455825431e-23,  5.369201754773516e-12, -2.362832343234907e-12,  5.583358966554916e-13, -8.966070948644567e-14,  1.088509882585373e-14,
 -1.061559007308696e-15,  8.648466693469437e-17, -6.049010803991404e-18,  3.706199433717011e-19, -2.020166562167662e-20,  9.916843173725227e-22, -4.421082380666570e-23,
  2.144004815892888e-12, -9.469604161283113e-13,  2.246904316919091e-13, -3.623334530968056e-14,  4.417149997279073e-15, -4.325437762961850e-16,  3.538086748934063e-17,
 -2.484404060612099e-18,  1.528056697158135e-19, -8.360551073145608e-21,  4.119293416254154e-22, -1.843061355957955e-23,  6.009516388395674e-02, -1.497228658831310e-04,
  3.871327343974051e-07, -1.032009063632116e-09,  2.814678722579625e-12, -7.798971374071413e-15,  2.182430136013804e-17, -6.141383462141138e-20,  1.732318592707425e-22,
 -4.888361547815583e-25,  1.377972989840990e-27, -3.877498985909897e-30,  5.759725615850789e-02, -1.838476824541006e-04,  6.924200190384801e-07, -2.703292917337269e-09,
  1.044041858125629e-11, -3.948174445971862e-14,  1.462371446375773e-16, -5.318534866066918e-19,  1.904031762147211e-21, -6.723451809392358e-24,  2.345535880955338e-26,
 -8.094230533476574e-29,  5.291310683892185e-02, -2.430428673145338e-04,  1.303208402895682e-06, -6.676021482362838e-09,  3.239159118698403e-11, -1.505528607162124e-13,
  6.763016179652785e-16, -2.953796214302145e-18,  1.259599186132911e-20, -5.260839312653633e-23,  2.157278448832390e-25, -8.702168789419830e-28,  4.660129773584556e-02,
 -3.120316525693468e-04,  2.197827957060936e-06, -1.394398184219540e-08,  8.196898845970768e-11, -4.554042086973427e-13,  2.419454792387774e-15, -1.238743247175822e-17,
  6.146274615684976e-20, -2.967819660460220e-22,  1.399206025735144e-24, -6.457613798859087e-27,  3.935661622318153e-02, -3.738935836746267e-04,  3.304890639942350e-06,
 -2.538094182116172e-08,  1.775784317584240e-10, -1.159402292112955e-12,  7.165838087347281e-15, -4.233442936123322e-17,  2.407346115134233e-19, -1.324552396526964e-21,
  7.080136090691196e-24, -3.688420300587716e-26,  3.188397957442626e-02, -4.147159253287765e-04,  4.491511793451342e-06, -4.117129628109833e-08,  3.383219119596375e-10,
 -2.563076991432946e-12,  1.821013382083676e-14, -1.227408430791316e-16,  7.913462833652196e-19, -4.910381436969809e-21,  2.946427005398773e-23, -1.716041431728448e-25,
  2.478857813564361e-02, -4.267852515222616e-04,  5.580542518782014e-06, -6.037221657864154e-08,  5.764919130668189e-10, -5.017906406949024e-12,  4.060609083073649e-14,
 -3.095567279468487e-16,  2.244172828463510e-18, -1.558048981256446e-20,  1.041496401493375e-22, -6.731691276499764e-25,  1.850481498654901e-02, -4.095193086203346e-04,
  6.392845497707640e-06, -8.083469051515542e-08,  8.890891859562982e-10, -8.820284071684427e-12,  8.069127379851471e-14, -6.908710559073400e-16,  5.594389588939754e-18,
 -4.317989328517256e-20,  3.195877202854893e-22, -2.278868321804008e-24,  1.327221574304703e-02, -3.682658231919735e-04,  6.796528799539486e-06, -9.959197696363918e-08,
  1.252281460738636e-09, -1.406369442235470e-11,  1.445415820354306e-13, -1.381742596304116e-15,  1.242794443972701e-17, -1.060765540147365e-19,  8.648484646068293e-22,
 -6.770046209859078e-24,  9.152560415244926e-03, -3.117938414525259e-04,  6.741791332672613e-06, -1.136146327384356e-07,  1.622506312499609e-09, -2.050600788593751e-11,
  2.354864405542342e-13, -2.500693953000519e-15,  2.486378388151371e-17, -2.336123783803303e-19,  2.088953887159980e-21, -1.787613250567746e-23,  6.073547486750155e-03,
 -2.495384609051217e-04,  6.268168639616562e-06, -1.206485434828900e-07,  1.945327648425996e-09, -2.752364137819759e-11,  3.514766792850115e-13, -4.127719517382765e-15,
  4.517757629358335e-17, -4.653963113087386e-19,  4.546812554771535e-21, -4.237867678935376e-23,  3.881953674131002e-03, -1.894526618630877e-04,  5.484436268159876e-06,
 -1.198080150759836e-07,  2.169444224408167e-09, -3.419935930985759e-11,  4.835444659872925e-13, -6.255006041714717e-15,  7.507777753985085e-17, -8.449541260564629e-19,
  8.988543705246690e-21, -9.095053977680155e-23,  2.392342050774203e-03, -1.368740752458566e-04,  4.532416870494837e-06, -1.117147717082763e-07,  2.260582527047618e-09,
 -3.953248707794140e-11,  6.164307679039941e-13, -8.751199007979392e-15,  1.147988375852453e-16, -1.406945452316829e-18,  1.624682702502873e-20, -1.779419961830697e-22,
  1.423213333750522e-03, -9.437207115536865e-05,  3.549698916894339e-06, -9.818072746218382e-08,  2.209972520828509e-09, -4.270014489120939e-11,  7.316173418843854e-13,
 -1.136048354141691e-14,  1.623631082783867e-16, -2.160513154343112e-18,  2.700589544721981e-20, -3.192935946432790e-22,  8.183776315495786e-04, -6.226310770601626e-05,
  2.642923752828900e-06, -8.161127292091327e-08,  2.034649932806730e-09, -4.327101503335139e-11,  8.118825455517726e-13, -1.374587438615711e-14,  2.134092178551179e-16,
 -3.074797334651238e-18,  4.149477982998369e-20, -5.282772646992398e-22,  4.555067324776296e-04, -3.940902207354340e-05,  1.876349957616614e-06, -6.437528230021157e-08,
  1.770401651709527e-09, -4.129461509872787e-11,  8.457335018670345e-13, -1.556669216918980e-14,  2.618147018510877e-16, -4.073890346003161e-18,  5.921047813465658e-20,
 -8.098210418076066e-22,  2.457951149791305e-04, -2.398967484493776e-05,  1.273921579312365e-06, -4.834089623080327e-08,  1.460853102166966e-09, -3.724519845629679e-11,
  8.300949135747089e-13, -1.656370155747693e-14,  3.010101207361885e-16, -5.045992173269212e-18,  7.880304962424708e-20, -1.155306073798590e-21,  1.288047115435596e-04,
 -1.407979919159117e-05,  8.294915459975510e-07, -3.466436159941343e-08,  1.146886845217806e-09, -3.185820055607859e-11,  7.704216930925696e-13, -1.662119879917292e-14,
  3.255606984987678e-16, -5.865893761081716e-18,  9.821535459175780e-20, -1.540222750236904e-21,  6.567169789284981e-05, -7.987309821049909e-06,  5.194636047715694e-07,
 -2.380963423159718e-08,  8.594335561142413e-10, -2.592996438300006e-11,  6.784859458965126e-13, -1.578558644844092e-14,  3.324584248914166e-16, -6.423943269528122e-18,
  1.150732143642677e-19, -1.926419061929553e-21,  3.264288594396266e-05, -4.390833298824212e-06,  3.137700598191282e-07, -1.571255935105617e-08,  6.166903169763846e-10,
 -2.014868250167372e-11,  5.689058221723822e-13, -1.423850540121995e-14,  3.216933610524984e-16, -6.651577873824059e-18,  1.272132168027642e-19, -2.268982471563929e-21,
  1.585290010703008e-05, -2.345191539034753e-06,  1.833316383111214e-07, -9.993023481858046e-09,  4.250793035243516e-10, -1.499622766816934e-11,  4.557091927048653e-13,
 -1.223949160473001e-14,  2.959798968572463e-16, -6.534958627697370e-18,  1.331726877429892e-19, -2.525848647022054e-21,  7.539753103335862e-06, -1.220331785438621e-06,
  1.039239392488385e-07, -6.143997354756944e-09,  2.823681692496433e-10, -1.072600645881279e-11,  3.498975647345674e-13, -1.006093897698968e-14,  2.598354333347036e-16,
 -6.113282185182810e-18,  1.324821254548414e-19, -2.667032859683759e-21,  3.520675096309983e-06, -6.204066814107248e-07,  5.732748636783015e-08, -3.663389663680594e-09,
  1.813502045687820e-10, -7.397029140046582e-12,  2.583832835420443e-13, -7.935455807754076e-15,  2.183971183071010e-16, -5.464216126563081e-18,  1.256832788684506e-19,
 -2.680541528121586e-21,  1.618386068155627e-06, -3.090702534201349e-07,  3.086998892074377e-08, -2.125196572746037e-09,  1.129837675101085e-10, -4.935172116873493e-12,
  1.841354610816048e-13, -6.026357407058002e-15,  1.763633740215699e-16, -4.682855425226419e-18,  1.141008719599532e-19, -2.573400732744203e-21,  7.344587238433550e-07,
 -1.513420178003910e-07,  1.627939756940915e-08, -1.203488451583497e-09,  6.851406149098045e-11, -3.196397743113086e-12,  1.270748203430648e-13, -4.421753061359493e-15,
  1.373075019596617e-16, -3.861329543885573e-18,  9.947326220567387e-20, -2.368086495482134e-21,  3.300632578642780e-07, -7.307701056846261e-08,  8.435642634996321e-09,
 -6.675668768412385e-10,  4.058011825904908e-11, -2.016739569809430e-12,  8.522254037032888e-14, -3.145700623131493e-15,  1.034263584014608e-16, -3.074191809842544e-18,
  8.357012074195737e-20, -2.096089909946997e-21,  1.473527447434223e-07, -3.491213493248867e-08,  4.309971362083245e-09, -3.639841837802418e-10,  2.355901012742197e-11,
 -1.243990889928767e-12,  5.574071579448618e-14, -2.177570857872659e-15,  7.564214010055239e-17, -2.371545280190391e-18,  6.789751701603178e-20, -1.790882094524741e-21,
  6.556988288702062e-08, -1.655990866896221e-08,  2.178978181957350e-09, -1.957811554262906e-10,  1.345508789735276e-11, -7.529072311012361e-13,  3.568536282151950e-14,
 -1.472075097341591e-15,  5.390816342581484e-17, -1.779060687962601e-18,  5.353726075079097e-20, -1.482169454233096e-21,  2.918437985365915e-08, -7.826878010456061e-09,
  1.094066080861163e-09, -1.042709726292231e-10,  7.587696952527609e-12, -4.487754165647872e-13,  2.244436446625494e-14, -9.753957691587994e-16,  3.757351710501706e-17,
 -1.302487790106349e-18,  4.111568195471755e-20, -1.192439857770620e-21,  1.303956862240711e-08, -3.699780750524403e-09,  5.476131254462333e-10, -5.519445140118893e-11,
  4.240942124900775e-12, -2.644288487644271e-13,  1.392010891389928e-14, -6.358139707795096e-16,  2.570603756406844e-17, -9.340114978536186e-19,  3.086467036039879e-20,
 -9.358742399027408e-22,  5.870155147124716e-09, -1.755746714847763e-09,  2.742830624156844e-10, -2.914906386080431e-11,  2.358285792954632e-12, -1.546049170891177e-13,
  8.545242921870036e-15, -4.092501750642127e-16,  1.732633123717505e-17, -6.584125014065193e-19,  2.272838436568085e-20, -7.190658676031983e-22,  2.672641674221233e-09,
 -8.396673038974159e-10,  1.380028762206351e-10, -1.541763665063677e-11,  1.309693921660648e-12, -9.003593574770947e-14,  5.211687203626859e-15, -2.610733973349153e-16,
  1.154727020530718e-17, -4.578999533707112e-19,  1.647642766169702e-20, -5.427499044400994e-22,  1.235297664668482e-09, -4.062309983382112e-10,  7.001733895978057e-11,
 -8.198465982228208e-12,  7.291668648265915e-13, -5.242197074918545e-14,  3.169641978728974e-15, -1.656661187271042e-16,  7.636784099334762e-18, -3.152830483988851e-19,
  1.179909316929878e-20, -4.038188808556193e-22,  5.817739848664586e-10, -1.995696277449585e-10,  3.595719722445532e-11, -4.399394426809326e-12,  4.084840238297081e-13,
 -3.062683857132237e-14,  1.929223922379766e-15, -1.049394153231880e-16,  5.029316885521009e-18, -2.156592650116028e-19,  8.374823264454275e-21, -2.971322395680630e-22,
  2.801841206844240e-10, -9.991875237015227e-11,  1.875859845147924e-11, -2.390872764197865e-12,  2.310747235890123e-13, -1.801760386783492e-14,  1.179190541118557e-15,
 -6.657902795004839e-17,  3.309062449360262e-18, -1.470186417607797e-19,  5.910331890535794e-21, -2.168828934637562e-22,  1.384495575634036e-10, -5.115666285893247e-11,
  9.975025163521957e-12, -1.320296790715132e-12,  1.324296734398537e-13, -1.070775803690748e-14,  7.260835410198950e-16, -4.243970154440244e-17,  2.181770745713179e-18,
 -1.001824804928878e-19,  4.159130747576632e-21, -1.574800140420639e-22,  7.040244474391896e-11, -2.686378970144701e-11,  5.422818733141713e-12, -7.430501757672385e-13,
  7.711339084455729e-14, -6.446672055565044e-15,  4.516371442177919e-16, -2.725279649256069e-17,  1.445295621418936e-18, -6.841133486468748e-20,  2.925604702841973e-21,
 -1.140208411395449e-22,  3.692956127499316e-11, -1.450445073190910e-11,  3.021220820672328e-12, -4.271940080147243e-13,  4.572881193718805e-14, -3.940795580187459e-15,
  2.844058459002710e-16, -1.766717309023319e-17,  9.638910737411338e-19, -4.690592708273352e-20,  2.060930234136434e-21, -8.246692408003456e-23,  2.001348500131904e-11,
 -8.064774076570333e-12,  1.727678846734474e-12, -2.512747947001444e-13,  2.765645716772134e-14, -2.449322332498211e-15,  1.815536881165685e-16, -1.157657909488403e-17,
  6.479328104536994e-19, -3.232691466733543e-20,  1.455409079705390e-21, -5.963730308853848e-23,  1.120837959302717e-11, -4.619176498848875e-12,  1.014331327899096e-12,
 -1.512453431048280e-13,  1.706149282232964e-14, -1.547964539244711e-15,  1.174894206636332e-16, -7.667060568631798e-18,  4.389438764464847e-19, -2.238985882722916e-20,
  1.030058327258820e-21, -4.310692504791594e-23,  6.475217378734889e-12, -2.720522612441925e-12,  6.103173557305241e-13, -9.298807909931678e-14,  1.071593314412831e-14,
 -9.928437624691180e-16,  7.692063899136297e-17, -5.121612138841966e-18,  2.990393268470643e-19, -1.554967932218382e-20,  7.289450603643791e-22, -3.106972712409165e-23,
  3.838588858998321e-12, -1.639014435265655e-12,  3.743754085249022e-13, -5.808750972886783e-14,  6.815707109354086e-15, -6.427709476150082e-16,  5.067125341782132e-17,
 -3.431709078040856e-18,  2.037308225406817e-19, -1.076750095278611e-20,  5.128564403405205e-22, -2.220100773193431e-23,  2.307715816593268e-12, -9.982862338049465e-13,
  2.313791950986946e-13, -3.643522230165499e-14,  4.338229795272975e-15, -4.150663284049993e-16,  3.318654514750523e-17, -2.278887298647510e-18,  1.371361647238103e-19,
 -7.344534327045806e-21,  3.543822190129455e-22, -1.553584103879966e-23,  1.370811301716799e-12, -5.989218043637921e-13,  1.403781262168210e-13, -2.235742297214673e-14,
  2.692130667895941e-15, -2.604395967721024e-16,  2.105069231404736e-17, -1.460984011694964e-18,  8.883714257062604e-20, -4.806495855105939e-21,  2.342398072740594e-22,
 -1.036907544557344e-23,  7.530853875746995e-13, -3.313006460812791e-13,  7.825654898854551e-14, -1.256204607069302e-14,  1.524490338993154e-15, -1.486184703223079e-16,
  1.210338520208746e-17, -8.462411309655982e-19,  5.183028493760814e-20, -2.824164858974166e-21,  1.385885510675392e-22, -6.176421621818574e-24,  2.979870286021159e-13,
 -1.315931024413617e-13,  3.121804803732354e-14, -5.033240107543277e-15,  6.134786204387424e-16, -6.006286811634171e-17,  4.912064867203253e-18, -3.448565529871298e-19,
  2.120691173460942e-20, -1.160100634166034e-21,  5.714883529249410e-23, -2.556522754351090e-24,  5.950238917692266e-02, -1.466745865227922e-04,  3.750137780851152e-07,
 -9.881941541962285e-10,  2.663801010561542e-12, -7.295212671868450e-15,  2.017975023746572e-17, -5.614167153516534e-20,  1.565861407280165e-22, -4.369811487793990e-25,
  1.218318315246942e-27, -3.391145594762243e-30,  5.687274263026429e-02, -1.784352993659456e-04,  6.609573304260776e-07, -2.542377548092589e-09,  9.684709019591248e-12,
 -3.614408812437209e-14,  1.321631176752885e-16, -4.746228423980645e-19,  1.678051377738848e-21, -5.852726879684205e-24,  2.016953462039528e-26, -6.876476366307239e-29,
  5.196129147019161e-02, -2.329290618567961e-04,  1.226109154761969e-06, -6.180989906311917e-09,  2.953637533009147e-11, -1.352702425313798e-13,  5.989650655120324e-16,
 -2.579433560449786e-18,  1.084861295037055e-20, -4.469862237775809e-23,  1.808542873408907e-25, -7.199622964703160e-28,  4.538730721884806e-02, -2.950967167628675e-04,
  2.038078537981223e-06, -1.270230178376275e-08,  7.341458682577187e-11, -4.012867209826221e-13,  2.098609720136293e-15, -1.058130114244645e-17,  5.172113685084509e-20,
 -2.461064139595106e-22,  1.143693502407709e-24, -5.204060945053676e-27,  3.791205712792693e-02, -3.486261459507597e-04,  3.016630865828432e-06, -2.271623493511330e-08,
  1.560184913232302e-10, -1.000818231434102e-12,  6.081526748902039e-15, -3.534222783874610e-17,  1.977802291592568e-19, -1.071317311149543e-21,  5.639414184248829e-24,
 -2.893999447967253e-26,  3.029397601000271e-02, -3.806717768425423e-04,  4.028317357204191e-06, -3.614561101965394e-08,  2.911665520474455e-10, -2.164568752480378e-12,
  1.510287841107943e-14, -1.000326631119898e-16,  6.340852826872288e-19, -3.870018396590778e-21,  2.284930652677472e-23, -1.309869887445998e-25,  2.316634925459387e-02,
 -3.848892692305209e-04,  4.908271130721252e-06, -5.190106800139380e-08,  4.852170121445546e-10, -4.139747253323254e-12,  3.286498383238902e-14, -2.459680779383054e-16,
  1.751634281644900e-18, -1.195173570042972e-20,  7.855171702610040e-23, -4.993828237104267e-25,  1.696320440096074e-02, -3.620275319766732e-04,  5.502684092552420e-06,
 -6.792151827966937e-08,  7.305812738195162e-10, -7.096949611947957e-12,  6.363599733627541e-14, -5.344385926530122e-16,  4.247737359102740e-18, -3.219795538531912e-20,
  2.341448264176197e-22, -1.641131761452903e-24,  1.190078207991207e-02, -3.183536015649207e-04,  5.712938511860572e-06, -8.162957110789285e-08,  1.002781864937852e-09,
 -1.101732601326482e-11,  1.108908493495161e-13, -1.039013983437471e-15,  9.166183702321852e-18, -7.678252968569514e-20,  6.146975780806617e-22, -4.727053605291782e-24,
  8.005203323486651e-03, -2.629009774889587e-04,  5.521575714837137e-06, -9.065070189539379e-08,  1.263664988674681e-09, -1.561188927478620e-11,  1.754483147945019e-13,
 -1.824909401133003e-15,  1.778565337850224e-17, -1.639070178397033e-19,  1.438371331739083e-21, -1.208566134575383e-23,  5.167210427024774e-03, -2.046941547881454e-04,
  4.990355902083027e-06, -9.350530157247395e-08,  1.470630436886733e-09, -2.032606344574318e-11,  2.538519664576605e-13, -2.918354327443629e-15,  3.129220582950069e-17,
 -3.160200513086199e-19,  3.028538174019071e-21, -2.770355002451807e-23,  3.203557951035671e-03, -1.507860310294395e-04,  4.234325960884525e-06, -8.999326343198167e-08,
  1.588613588064605e-09, -2.445029949736919e-11,  3.379190461443783e-13, -4.276960868137822e-15,  5.026960908113455e-17, -5.543956609705991e-19,  5.782780087047621e-21,
 -5.740538936719546e-23,  1.909669045694059e-03, -1.054174230953820e-04,  3.385157012362806e-06, -8.114322470470839e-08,  1.599990401233006e-09, -2.730610742799657e-11,
  4.160253633175696e-13, -5.776485682802123e-15,  7.417536724041815e-17, -8.905160696747207e-19,  1.007983238545506e-20, -1.082761045864503e-22,  1.095828755558173e-03,
 -7.014524520085319e-05,  2.558323853315836e-06, -6.879760264774806e-08,  1.508546587418003e-09, -2.843638800495709e-11,  4.759107646725154e-13, -7.225548813367487e-15,
  1.010569148857817e-16, -1.316933520791227e-18,  1.613167040290970e-20, -1.870173021977429e-22,  6.061120488974069e-04, -4.454312520360170e-05,  1.833458609693136e-06,
 -5.503972446093105e-08,  1.336498318651772e-09, -2.772462092544997e-11,  5.080094140886640e-13, -8.408105951649886e-15,  1.277208645499349e-16, -1.801840370872971e-18,
  2.382513089032104e-20, -2.973779010073588e-22,  3.236050062579119e-04, -2.706296161564394e-05,  1.249755654646092e-06, -4.168590778919015e-08,  1.116552270838192e-09,
 -2.540144435107713e-11,  5.080061497271950e-13, -9.139804964225319e-15,  1.503888884270959e-16, -2.291091886931701e-18,  3.262399505899492e-20, -4.374213619441868e-22,
  1.670395718116599e-04, -1.577160352191955e-05,  8.126092033959233e-07, -2.998409253521092e-08,  8.825903925781456e-10, -2.194820505553876e-11,  4.776764833811836e-13,
 -9.316863541826740e-15,  1.656430083977495e-16, -2.718617802303418e-18,  4.159575934413140e-20, -5.978285693344003e-22,  8.350680591133731e-05, -8.838407908989403e-06,
  5.054618658626266e-07, -2.054616497883884e-08,  6.622723328834383e-10, -1.794654945344877e-11,  4.238561897574731e-13, -8.939282584925588e-15,  1.713132169957906e-16,
 -3.022308689017508e-18,  4.958193783262758e-20, -7.623188042216561e-22,  4.050882844840780e-05, -4.775029795302651e-06,  3.016418150631664e-07, -1.345385075765869e-08,
  4.732790916723982e-10, -1.393369148249116e-11,  3.561505119547397e-13, -8.101966066983313e-15,  1.669801187239929e-16, -3.159723651127347e-18,  5.546670020390019e-20,
 -9.105162688978531e-22,  1.910749188355713e-05, -2.493538987273943e-06,  1.732009991795577e-07, -8.444596356683586e-09,  3.231478903039531e-10, -1.030628633774782e-11,
  2.843588828180915e-13, -6.960758217356448e-15,  1.539398481518865e-16, -3.117926349783989e-18,  5.845093621257387e-20, -1.022524347808376e-21,  8.783389285969502e-06,
 -1.262024444893728e-06,  9.597293378407717e-08, -5.096632418565106e-09,  2.114929744515496e-10, -7.286792321971479e-12,  2.164704493576436e-13, -5.688659819989640e-15,
  1.347051303585008e-16, -2.914384764112995e-18,  5.823454310021146e-20, -1.083664926951645e-21,  3.944426222387105e-06, -6.208021280092618e-07,  5.147606963638524e-08,
 -2.967163149220475e-09,  1.331150282221323e-10, -4.941149824932822e-12,  1.576575646045042e-13, -4.437705931028185e-15,  1.122770431554885e-16, -2.589621049667082e-18,
  5.505028365057997e-20, -1.087742130303467e-21,  1.735045818900143e-06, -2.976812133478347e-07,  2.680911794963701e-08, -1.671744237943847e-09,  8.084418753590892e-11,
 -3.224469563835983e-12,  1.102343979206843e-13, -3.316043387571667e-15,  8.945463562587266e-17, -2.195211949545916e-18,  4.955422320754314e-20, -1.037833938870942e-21,
  7.496717443095758e-07, -1.395739813362679e-07,  1.360170570278307e-08, -9.145927855379101e-10,  4.753912494220007e-11, -2.032069431816985e-12,  7.425607156466214e-14,
 -2.381947803237779e-15,  6.836990922674507e-17, -1.781635504580767e-18,  4.262848780097029e-20, -9.446270553717508e-22,  3.191383662596338e-07, -6.419810305871131e-08,
  6.745399495080452e-09, -4.875545011813677e-10,  2.716230983175015e-11, -1.241129010989271e-12,  4.836344124662394e-14, -1.650662377749071e-15,  5.030881026108968e-17,
 -1.389412299619304e-18,  3.517100884413889e-20, -8.231705718927815e-22,  1.342877501850012e-07, -2.906602022665821e-08,  3.281374772861799e-09, -2.541657738662211e-10,
  1.513473343066092e-11, -7.373659935629207e-13,  3.056801134707283e-14, -1.107626952460576e-15,  3.577120035034290e-17, -1.044968639520973e-18,  2.793318701615349e-20,
 -6.892799488691676e-22,  5.604427300901636e-08, -1.300013945316438e-08,  1.571560528899277e-09, -1.300547259119090e-10,  8.254761642491012e-12, -4.277314446932866e-13,
  1.881983752739639e-14, -7.223841086732519e-16,  2.466932549398938e-17, -7.607659167187573e-19,  2.143450742851033e-20, -5.566399222326844e-22,  2.328277564348896e-08,
 -5.765469127599637e-09,  7.438573833381937e-10, -6.557270291408526e-11,  4.424206393398581e-12, -2.431982328955765e-13,  1.133020057835612e-14, -4.596722880758425e-16,
  1.656421015041274e-17, -5.381676464720076e-19,  1.595120479317448e-20, -4.351523863278428e-22,  9.664875854384531e-09, -2.545300729617841e-09,  3.493398444487790e-10,
 -3.270653332011964e-11,  2.339349145572509e-12, -1.360734724559508e-13,  6.696463618097952e-15, -2.865064581251468e-16,  1.087074923256404e-17, -3.713402392774409e-19,
  1.155612046400829e-20, -3.305446739984717e-22,  4.024717402252061e-09, -1.123096830044322e-09,  1.634473746782763e-10, -1.620450595930031e-11,  1.225334679370819e-12,
 -7.522663783640817e-14,  3.901099066774167e-15, -1.756131171951797e-16,  7.000596486571118e-18, -2.509027674860302e-19,  8.181613075204174e-21, -2.448998450839259e-22,
  1.688225857009333e-09, -4.973671993332095e-10,  7.650616371828423e-11, -8.008336744310477e-12,  6.384407320563000e-13, -4.126165886459014e-14,  2.249238488586177e-15,
 -1.062841576058351e-16,  4.441474827510539e-18, -1.666569726645472e-19,  5.682698580822921e-21, -1.776525247207467e-22,  7.163141152124639e-10, -2.220062401268754e-10,
  3.597932548767661e-11, -3.964572978336719e-12,  3.322928314076145e-13, -2.254800595431232e-14,  1.288778998750493e-15, -6.377225969190225e-17,  2.787225508216762e-18,
 -1.092532974135673e-19,  3.887218939758902e-21, -1.266571775668479e-22,  3.087439677823737e-10, -1.003103958842424e-10,  1.707302186216855e-11, -1.974461995740508e-12,
  1.734955240614578e-13, -1.232723448990912e-14,  7.368846393476728e-16, -3.808923273645388e-17,  1.736982140684430e-18, -7.096321202611744e-20,  2.628784530745326e-21,
 -8.908298611325343e-23,  1.357546190013636e-10, -4.607611999076737e-11,  8.209536867149272e-12, -9.934209035803799e-13,  9.125026748649548e-14, -6.770247217774045e-15,
  4.221382109186954e-16, -2.273549388019560e-17,  1.079167020657849e-18, -4.584346762588009e-20,  1.764110962061469e-21, -6.203759570554018e-23,  6.114626493480377e-11,
 -2.160568964368167e-11,  4.016805530605360e-12, -5.070293468724250e-13,  4.854182509333709e-14, -3.750185819870121e-15,  2.432426785010414e-16, -1.361444785815060e-17,
  6.709316840675192e-19, -2.956358087694351e-20,  1.178975309611155e-21, -4.292659830009893e-23,  2.832394514170075e-11, -1.038353972425856e-11,  2.007735902559858e-12,
 -2.635330308528099e-13,  2.621757983036963e-14, -2.102988306273303e-15,  1.414968290946201e-16, -8.208138958376504e-18,  4.188729282146339e-19, -1.909640882685173e-20,
  7.872856759134464e-22, -2.960817161624687e-23,  1.354137603652703e-11, -5.133067178331131e-12,  1.028844826914553e-12, -1.399806140620398e-13,  1.442652847135175e-14,
 -1.197901169860325e-15,  8.336877717799690e-17, -4.998370975052984e-18,  2.634218278911565e-19, -1.239289916087014e-20,  5.268417943644582e-22, -2.041464781558246e-23,
  6.702131603226674e-12, -2.618124211403869e-12,  5.421524900401262e-13, -7.621065381040538e-14,  8.111029978676751e-15, -6.950599335812663e-16,  4.988727112098593e-17,
 -3.082424531761927e-18,  1.672969613524163e-19, -8.099938380246239e-21,  3.541349094178138e-22, -1.410254544814314e-23,  3.441526150947038e-12, -1.380840080819375e-12,
  2.944162646637945e-13, -4.261784550676694e-14,  4.668912421432963e-15, -4.116098876509341e-16,  3.037479369168234e-17, -1.928437136132657e-18,  1.074782055318986e-19,
 -5.340318549224700e-21,  2.394674869192904e-22, -9.774331694718161e-24,  1.835087978450524e-12, -7.537491297938492e-13,  1.649087386678128e-13, -2.449857043210684e-14,
  2.753558587356664e-15, -2.489373047240265e-16,  1.882850223979412e-17, -1.224534954874018e-18,  6.987369083533494e-20, -3.552670671498014e-21,  1.629296028266410e-22,
 -6.797637700549675e-24,  1.014868116091525e-12, -4.253338993171614e-13,  9.515669275483587e-14, -1.445803623829609e-14,  1.661600999601670e-15, -1.535381250670523e-16,
  1.186433229912889e-17, -7.879516126096466e-19,  4.589242129692535e-20, -2.380569647301254e-21,  1.113339127463598e-22, -4.734474866226217e-24,  5.793821002801907e-13,
 -2.469552710790452e-13,  5.629867353129121e-14, -8.718100750691833e-15,  1.020960371611673e-15, -9.610129871489549e-17,  7.561848597718543e-18, -5.111978858518122e-19,
  3.029469615585298e-20, -1.598360986693932e-21,  7.600187682085789e-23, -3.284655048485755e-24,  3.376197923726287e-13, -1.458831026588224e-13,  3.376906400829969e-14,
 -5.310742024687409e-15,  6.315265931124111e-16, -6.034649216186622e-17,  4.819073798322777e-18, -3.305243567691675e-19,  1.986661539304118e-20, -1.062770494096749e-21,
  5.122268740725813e-23, -2.243124566793734e-24,  1.957378309529027e-13, -8.546223509653087e-14,  2.001584182162420e-14, -3.185387707976652e-15,  3.832710196831414e-16,
 -3.705029741928474e-17,  2.992487617164473e-18, -2.075389105252571e-19,  1.261082867037272e-20, -6.818352345478841e-22,  3.320627386536064e-23, -1.468978721332900e-24,
  1.057159245301460e-13, -4.649078679458545e-14,  1.097725735677968e-14, -1.761405416525733e-15,  2.136734395252921e-16, -2.082226575380800e-17,  1.695096026359815e-18,
 -1.184723366560117e-19,  7.253456050035255e-21, -3.950874074918805e-22,  1.938096572955687e-23, -8.634426013429980e-25,  4.143283674070150e-14, -1.829396417291497e-14,
  4.339080476847299e-15, -6.994473373495397e-16,  8.523584294935376e-17, -8.343437916464023e-18,  6.822132694124644e-19, -4.788645871724444e-20,  2.944224771065567e-21,
 -1.610310550835951e-22,  7.931273899189465e-24, -3.547383915991557e-25,  5.892161695701728e-02, -1.437211959840110e-04,  3.634064420944417e-07, -9.467147821251870e-10,
  2.522615433671202e-12, -6.829210258877951e-15,  1.867563448767805e-17, -5.137349484370638e-20,  1.416972253820725e-22, -3.911042843895557e-25,  1.078590769062739e-27,
 -2.970055395631786e-30,  5.616938717727279e-02, -1.732670944453178e-04,  6.313552229852681e-07, -2.393037328855473e-09,  8.992500513828592e-12, -3.312576800258170e-14,
  1.195948469409324e-16, -4.241463878193694e-19,  1.481174926022395e-21, -5.103317672696443e-24,  1.737541202054397e-26, -5.853261300082228e-29,  5.104873429114114e-02,
 -2.234090428955627e-04,  1.154685954148444e-06, -5.729293958393583e-09,  2.696906854624883e-11, -1.217239804800624e-13,  5.313688021996402e-16, -2.256687813069679e-18,
  9.362391999415089e-21, -3.806006412892805e-23,  1.519677918061619e-25, -5.971103108576899e-28,  4.423859164229390e-02, -2.793824228402199e-04,  1.892442464839379e-06,
 -1.158923515387685e-08,  6.586945328810879e-11, -3.542962628058019e-13,  1.824232877633501e-15, -9.059581732217579e-18,  4.363243589702088e-20, -2.046280678562394e-22,
  9.374840996979264e-25, -4.206360409936463e-27,  3.656415017250874e-02, -3.255425126120923e-04,  2.758378080796218e-06, -2.037246371288255e-08,  1.373850873120483e-10,
 -8.660555439637169e-13,  5.175048490770789e-15, -2.958917619496944e-17,  1.629840415576388e-19, -8.692829337316363e-22,  4.507067407874669e-24, -2.278743821122657e-26,
  2.883310253967662e-02, -3.501041967705624e-04,  3.621154686922811e-06, -3.181449568259376e-08,  2.512843193469390e-10, -1.833540486886340e-12,  1.256628475554429e-14,
 -8.180535210915280e-17,  5.099160031606425e-19, -3.061681947969424e-21,  1.779000548980012e-23, -1.003987141743257e-25,  2.170155839896558e-02, -3.479883975848730e-04,
  4.329439601875860e-06, -4.475933197718256e-08,  4.097829307458092e-10, -3.427675905677755e-12,  2.670201379138318e-14, -1.962340696891111e-16,  1.373005924184643e-18,
 -9.208815839027244e-21,  5.951884147387834e-23, -3.722365385518065e-25,  1.559824215367435e-02, -3.210778464295907e-04,  4.753333221900479e-06, -5.728957311899186e-08,
  6.027778755745023e-10, -5.734906963031702e-12,  5.041256095371630e-14, -4.153817850957210e-16,  3.241129624383212e-18, -2.413182049815974e-20,  1.724535300566494e-22,
 -1.188326289299313e-24,  1.071293495825809e-02, -2.763114098790328e-04,  4.822822025876815e-06, -6.721255798133062e-08,  8.068537110909716e-10, -8.674303392520858e-12,
  8.552097551421083e-14, -7.855563762206841e-16,  6.798656059370591e-18, -5.590241128747329e-20,  4.395260622486362e-22, -3.320967035654378e-24,  7.035510905293339e-03,
 -2.227582140422785e-04,  4.545471548710558e-06, -7.271746195323339e-08,  9.897065131394433e-10, -1.195506586783002e-11,  1.315052851298088e-13, -1.340037744243962e-15,
  1.280406111868851e-17, -1.157580965715246e-19,  9.971004372815803e-22, -8.227418542570582e-24,  4.421699638290538e-03, -1.688884256596031e-04,  3.997058584279564e-06,
 -7.292223561850608e-08,  1.118957857478952e-09, -1.511076233807567e-11,  1.846004804239666e-13, -2.077844426532652e-15,  2.183091845708940e-17, -2.161728185187813e-19,
  2.032464357884482e-21, -1.824961122474084e-23,  2.661887958185604e-03, -1.208334883353657e-04,  3.292100011318527e-06, -6.808451525244998e-08,  1.171874646234471e-09,
 -1.761248600432127e-11,  2.379763178752427e-13, -2.947537227458682e-15,  3.393007610693220e-17, -3.667394684804575e-19,  3.751443016184128e-21, -3.654053884449691e-23,
  1.536558784113137e-03, -8.183407976996066e-05,  2.548633237112311e-06, -5.942037875629157e-08,  1.141883194177438e-09, -1.902123433859438e-11,  2.831999527593825e-13,
 -3.846452403657417e-15,  4.835516414077003e-17, -5.687551098493583e-19,  6.311214129167812e-21, -6.649900016772584e-23,  8.514793261382168e-04, -5.261012265403642e-05,
  1.860642058517121e-06, -4.865282481632148e-08,  1.039367543985451e-09, -1.911661485065059e-11,  3.125442235523041e-13, -4.640248675348018e-15,  6.351724305456982e-17,
 -8.107118954340842e-19,  9.732913670882730e-21, -1.106524989856321e-22,  4.535544961774171e-04, -3.219203926209333e-05,  1.284933073394663e-06, -3.750169029792926e-08,
  8.870131386335946e-10, -1.794962326862756e-11,  3.212263657406082e-13, -5.197860855751702e-15,  7.725923327156774e-17, -1.067318863144856e-18,  1.382904264115320e-20,
 -1.692411288886471e-22,  2.325639111961251e-04, -1.879683948939751e-05,  8.418784867426400e-07, -2.730098422829728e-08,  7.122328727056678e-10, -1.580452376116649e-11,
  3.086650765345915e-13, -5.428588200127749e-15,  8.739235186561594e-17, -1.303580758347917e-18,  1.818710819327784e-20, -2.390691645795502e-22,  1.149756530471005e-04,
 -1.049961643683869e-05,  5.248419338256011e-07, -1.883044412927042e-08,  5.398878361746256e-10, -1.309557979788087e-11,  2.783212308712435e-13, -5.306401316536206e-15,
  9.229878617408761e-17, -1.483180304282087e-18,  2.223374724854123e-20, -3.132757740209433e-22,  5.490146059028361e-05, -5.624860008751596e-06,  3.122234152234412e-07,
 -1.234366907559402e-08,  3.876124876315470e-10, -1.024644779709056e-11,  2.363382415472852e-13, -4.872642495436606e-15,  9.136282920290738e-17, -1.578202390402768e-18,
  2.536804728142689e-20, -3.823926462632821e-22,  2.536968316026327e-05, -2.897453169556113e-06,  1.777512832756428e-07, -7.713833096888451e-09,  2.644307235593595e-10,
 -7.596077096533270e-12,  1.896534839611885e-13, -4.218272021737805e-15,  8.507256727954245e-17, -1.576444849420168e-18,  2.711808426714061e-20, -4.364960735170320e-22,
  1.136887464780537e-05, -1.438924352383006e-06,  9.712745936637988e-08, -4.609869175648973e-09,  1.719704372211564e-10, -5.353366265761197e-12,  1.443180298780426e-13,
 -3.454931281576895e-15,  7.478557779594745e-17, -1.483661315298298e-18,  2.726154236471251e-20, -4.677235561609607e-22,  4.952145114381842e-06, -6.908323817781038e-07,
  5.109245856328604e-08, -2.642847043641423e-09,  1.069660146419581e-10, -3.598713799379454e-12,  1.044976896870408e-13, -2.686584136975992e-15,  6.228753371432331e-17,
 -1.320385270773221e-18,  2.586743036239318e-20, -4.722252150427651e-22,  2.102002611776249e-06, -3.215684871969917e-07,  2.595395320264841e-08, -1.458234361625659e-09,
  6.384651168486166e-11, -2.315429495826777e-12,  7.224799080778649e-14, -1.990424594727481e-15,  4.932715810354099e-17, -1.115167192731347e-18,  2.325126616943224e-20,
 -4.508723865245605e-22,  8.718066979110384e-07, -1.455656373794157e-07,  1.277266201124196e-08, -7.769724006882170e-10,  3.669563592211698e-11, -1.430842534092289e-12,
  4.786404011160614e-14, -1.410009766658622e-15,  3.727625346801346e-17, -8.970632759999983e-19,  1.987057009482092e-20, -4.085932876164388e-22,  3.543507859134344e-07,
 -6.428663392919449e-08,  6.110137935904015e-09, -4.011538570470027e-10,  2.038029557414176e-11, -8.522767359329152e-13,  3.049464186773670e-14, -9.585294268448389e-16,
  2.697879501071291e-17, -6.898238428557424e-19,  1.620454341628791e-20, -3.527422747514544e-22,  1.415960299862864e-07, -2.779267900173471e-08,  2.851288250229960e-09,
 -2.014225086597418e-10,  1.097772124977802e-11, -4.911323390553288e-13,  1.875327194383039e-14, -6.276374141762930e-16,  1.877033051316177e-17, -5.089796477992878e-19,
  1.265726946317261e-20, -2.911820545450478e-22,  5.581518840166596e-08, -1.180439853148778e-08,  1.302729908823571e-09, -9.872504602029210e-11,  5.756602540874500e-12,
 -2.748528855450315e-13,  1.117448410297013e-14, -3.973645055560618e-16,  1.260184114055911e-17, -3.617083163246747e-19,  9.505233598692832e-21, -2.307005065768421e-22,
  2.178301417535902e-08, -4.944292633846970e-09,  5.850202758757634e-10, -4.742089504685361e-11,  2.950415471433371e-12, -1.499681621146712e-13,  6.477174390320827e-15,
 -2.442031151209498e-16,  8.196071173945890e-18, -2.485419478462026e-19,  6.889403761695986e-21, -1.761061181393540e-22,  8.449453135130773e-09, -2.050418783550068e-09,
  2.592685700231460e-10, -2.241340415304580e-11,  1.484018718411627e-12, -8.010661014677387e-14,  3.667055132425016e-15, -1.462684429478347e-16,  5.184772152182615e-18,
 -1.657876917806940e-19,  4.838485863735382e-21, -1.300287119398723e-22,  3.270857427602118e-09, -8.454281318428106e-10,  1.138749881814202e-10, -1.046851986443348e-11,
  7.356587887191643e-13, -4.206699893248496e-14,  2.036310302010161e-15, -8.574185967891990e-17,  3.203272577256906e-18, -1.077917193662138e-19,  3.305945102146437e-21,
 -9.323349830625678e-23,  1.269066337042219e-09, -3.481012738728951e-10,  4.978713752069388e-11, -4.853030430630496e-12,  3.609918116495412e-13, -2.181263906935028e-14,
  1.113877505341781e-15, -4.940036755979264e-17,  1.941013571638850e-18, -6.859712553964464e-20,  2.206596042360796e-21, -6.518245683659737e-23,  4.957283214118197e-10,
 -1.437808578720568e-10,  2.176670786883759e-11, -2.243165623315745e-12,  1.761404474020618e-13, -1.121777924914703e-14,  6.028569682605058e-16, -2.809663357948613e-17,
  1.158508219489712e-18, -4.290932343185316e-20,  1.444776081977834e-21, -4.461658224053859e-23,  1.958626372987355e-10, -5.985410168726561e-11,  9.560581282090914e-12,
 -1.038598135453876e-12,  8.585396031928379e-14, -5.747949532504408e-15,  3.242823378841227e-16, -1.584473761727516e-17,  6.840609363650284e-19, -2.649599508157444e-20,
  9.318671649900053e-22, -3.002350572716180e-23,  7.864366251471414e-11, -2.523217017235323e-11,  4.238917284632353e-12, -4.839689816037659e-13,  4.199750564112138e-14,
 -2.947956008915011e-15,  1.741518952742964e-16, -8.899245528217693e-18,  4.013393983735393e-19, -1.622005601900031e-20,  5.945767149671703e-22, -1.994410500156131e-23,
  3.224422583652904e-11, -1.082346341134768e-11,  1.906231207566851e-12, -2.280448193727679e-13,  2.071426621981242e-14, -1.520267632208211e-15,  9.379576639032575e-17,
 -5.000070999662747e-18,  2.349792516724750e-19, -9.885723153547130e-21,  3.768453789320761e-22, -1.313159069165841e-23,  1.356334165344660e-11, -4.746660684541130e-12,
  8.735527990761543e-13, -1.091622298338686e-13,  1.034864444612317e-14, -7.918801174421325e-16,  5.088613933641170e-17, -2.822442414109095e-18,  1.378725534161249e-19,
 -6.023326474763906e-21,  2.382129706971766e-22, -8.603458195353368e-24,  5.880133145325713e-12, -2.137995976562250e-12,  4.097910519423841e-13, -5.332259315766000e-14,
  5.259776400586822e-15, -4.184104612119031e-16,  2.792539208782179e-17, -1.607235406066613e-18,  8.139401010930443e-20, -3.683218811715440e-21,  1.507512968307377e-22,
 -5.629680543273631e-24,  2.638481893353239e-12, -9.932749024830422e-13,  1.976152317237815e-13, -2.668882385454084e-14,  2.730712561566010e-15, -2.251455162377937e-16,
  1.556156525834788e-17, -9.267558628140283e-19,  4.852367298411360e-20, -2.268380045713772e-21,  9.583798931870259e-23, -3.691398270078975e-24,  1.229921003173173e-12,
 -4.777397948673366e-13,  9.832288399988141e-14, -1.373676489631398e-14,  1.453208099991107e-15, -1.237990896106800e-16,  8.834716428836832e-18, -5.428349659930848e-19,
  2.930217582145762e-20, -1.411212591743360e-21,  6.138172081395600e-23, -2.432155623012997e-24,  5.973121538038436e-13, -2.385741247856338e-13,  5.061636295320861e-14,
 -7.290667835017843e-15,  7.948289380760613e-16, -6.973853754812252e-17,  5.122478635713554e-18, -3.237453698930853e-19,  1.796390569611004e-20, -8.887503534417090e-22,
  3.968625631829266e-23, -1.613293074354866e-24,  3.026927144276634e-13, -1.238928845355798e-13,  2.700137378910569e-14, -3.995762339284109e-15,  4.473995295615331e-16,
 -4.029664019251281e-17,  3.036763309044165e-18, -1.967986883688192e-19,  1.119076774611745e-20, -5.670678117498524e-22,  2.592099352032517e-23, -1.078007016771231e-24,
  1.599721260460446e-13, -6.687001961237202e-14,  1.491717219195218e-14, -2.259929865200123e-15,  2.589813781214151e-16, -2.386380329317538e-17,  1.838978309746862e-18,
 -1.218068724202437e-19,  7.075891960630617e-21, -3.661151574043503e-22,  1.708004037259793e-23, -7.245826887964056e-25,  8.781174913694757e-14, -3.736013563560747e-14,
  8.499638988635915e-15, -1.313497987009062e-15,  1.535087298560009e-16, -1.442073694125436e-17,  1.132503730085749e-18, -7.641424526594749e-20,  4.520075687506861e-21,
 -2.380497749453969e-22,  1.129927572675989e-23, -4.874955312028696e-25,  4.953065158706191e-14, -2.137616628212831e-14,  4.941517717327239e-15, -7.760813979599986e-16,
  9.216398170305347e-17, -8.795286162015008e-18,  7.014588773487305e-19, -4.805025090209039e-20,  2.884579905632459e-21, -1.541265666121073e-22,  7.419801846382149e-24,
 -3.245555292757927e-25,  2.799586537224132e-14, -1.221478220709066e-14,  2.858507480034268e-15, -4.545456908277633e-16,  5.464802068006775e-17, -5.278606664792273e-18,
  4.260160858506256e-19, -2.952340431671036e-20,  1.792631858902354e-21, -9.685338025760584e-23,  4.713575972677975e-24, -2.083765222065888e-25,  1.485300227595171e-14,
 -6.529535735537000e-15,  1.541097560013899e-15, -2.471802079535447e-16,  2.997258699098000e-17, -2.919601517391766e-18,  2.375827559084895e-19, -1.659838728799371e-20,
  1.015840763854889e-21, -5.531067208465630e-23,  2.712249290834213e-24, -1.207896902522594e-25,  5.763329291722803e-15, -2.544260370584744e-15,  6.033453401669204e-16,
 -9.723797868720185e-17,  1.184720422377791e-17, -1.159450202817399e-18,  9.478545075588798e-20, -6.651962971980728e-21,  4.089072693111154e-22, -2.236049831416018e-23,
  1.101118256744487e-24, -4.924020152564769e-26,  5.835247568102629e-02, -1.408587108299704e-04,  3.522836060831869e-07, -9.074217358216495e-10,  2.390399459579585e-12,
 -6.397756866471694e-15,  1.729859825096067e-17, -4.705638186073919e-20,  1.283635817939162e-22, -3.504630553771856e-25,  9.561292000457518e-28, -2.604916046373164e-30,
  5.548624200021078e-02, -1.683287218507037e-04,  6.034806864444984e-07, -2.254305435476411e-09,  8.357752929940916e-12, -3.039281401653584e-14,  1.083556232499499e-16,
 -3.795590402125432e-19,  1.309369368697562e-21, -4.457166708545710e-24,  1.499485183192919e-26, -4.991749236926802e-29,  5.017314778621549e-02, -2.144394064086688e-04,
  1.088445306633555e-06, -5.316592684012185e-09,  2.465716902195188e-11, -1.096967472459502e-13,  4.721779899704853e-16, -1.977890174620392e-18,  8.095600495866620e-21,
 -3.247571689502925e-23,  1.279825489337736e-25, -4.964060366098411e-28,  4.315048485131861e-02, -2.647817734099738e-04,  1.759468751524840e-06, -1.058971599701027e-08,
  5.920158422403790e-11, -3.134074749946958e-13,  1.589054050075410e-15, -7.774319119688425e-18,  3.689848672064988e-20, -1.705828431973269e-22,  7.705736365948955e-25,
 -3.409830826055490e-27,  3.530461693798188e-02, -3.044172713982972e-04,  2.526547002436114e-06, -1.830639438403433e-08,  1.212418073392365e-10, -7.512347117941934e-13,
  4.415101009392244e-15, -2.484146922404307e-17,  1.347070797322135e-19, -7.075581269078484e-22,  3.613968526200070e-24, -1.800499096905526e-26,  2.748829927422503e-02,
 -3.225963899891635e-04,  3.262344925838295e-06, -2.807167348718913e-08,  2.174529977649184e-10, -1.557689534052391e-12,  1.048853875848323e-14, -6.712242566934393e-17,
  4.115067612443802e-19, -2.431154503837647e-21,  1.390464235288379e-23, -7.726477287851156e-26,  2.037562489468030e-02, -3.153948605207063e-04,  3.829512405045431e-06,
 -3.871819639797554e-08,  3.472172532989120e-10, -2.848088086441904e-12,  2.177582771936627e-14, -1.571728950038367e-16,  1.080668310506842e-18, -7.126028669138476e-21,
  4.530029996838753e-23, -2.787573340801132e-25,  1.438585058094403e-02, -2.856454333558792e-04,  4.120142605736619e-06, -4.850072765618520e-08,  4.992939944707869e-10,
 -4.653611391644702e-12,  4.011222643867229e-14, -3.243301680299938e-16,  2.484902717974568e-18, -1.817634091136975e-20,  1.276707152596202e-22, -8.650352575679144e-25,
  9.680039634724975e-03, -2.407480680645897e-04,  4.088346067887916e-06, -5.558632667501776e-08,  6.522306178898893e-10, -6.862907924634377e-12,  6.629128239677483e-14,
 -5.970726078944378e-16,  5.070307241522750e-18, -4.093120886628928e-20,  3.161109975347123e-22, -2.347163723292474e-24,  6.212036486179140e-03, -1.896327973579914e-04,
  3.760506011122587e-06, -5.863545631185221e-08,  7.793511495815165e-10, -9.206484157615695e-12,  9.914499989630618e-14, -9.899432931212984e-16,  9.275200008293641e-18,
 -8.227717624694580e-20,  6.957517446185990e-22, -5.638643434693653e-24,  3.804958037765284e-03, -1.401293649242703e-04,  3.220167540052592e-06, -5.721436056790591e-08,
  8.567135614921994e-10, -1.130623230391291e-11,  1.351345433313086e-13, -1.489526983437761e-15,  1.533711760196811e-17, -1.489346500775659e-19,  1.374011361484526e-21,
 -1.211199634468376e-23,  2.226470266197557e-03, -9.747088077720470e-05,  2.576895086364613e-06, -5.186819740322999e-08,  8.706400804963753e-10, -1.277997239438868e-11,
  1.688507414720410e-13, -2.046934140231668e-15,  2.308097277914617e-17, -2.445411490186268e-19,  2.453467314131337e-21, -2.345193044133344e-23,  1.245887827556430e-03,
 -6.401328264543815e-05,  1.933758723235223e-06, -4.385805108367489e-08,  8.215320362018826e-10, -1.335930027632305e-11,  1.944010981809715e-13, -2.583170860522918e-15,
  3.179682304799218e-17, -3.664593330784666e-19,  3.987000559169558e-21, -4.121220716058761e-23,  6.674753879308807e-04, -3.980422684325058e-05,  1.365179207283321e-06,
 -3.471440855174044e-08,  7.226034248384528e-10, -1.296949824482034e-11,  2.071705524431955e-13, -3.008126612160959e-15,  4.030453711105884e-17, -5.039139526078446e-19,
  5.929828085058536e-21, -6.611849003123355e-23,  3.428029329933227e-04, -2.349617696378833e-05,  9.094521308718173e-07, -2.580741795163000e-08,  5.946322370867912e-10,
 -1.173932092774293e-11,  2.052063670504886e-13, -3.246635777771577e-15,  4.722400821829658e-17, -6.389049927434319e-19,  8.112451691884866e-21, -9.735174211468973e-23,
  1.690165659999658e-04, -1.320017463756357e-05,  5.733852056857956e-07, -1.807798736147452e-08,  4.593759237683556e-10, -9.943365955820677e-12,  1.896545550073861e-13,
 -3.260794058860325e-15,  5.136259550765079e-17, -7.502019014156815e-19,  1.025564817828869e-20, -1.321743558370519e-22,  8.012730897066400e-05, -7.075668575768707e-06,
  3.431135407625654e-07, -1.196968945882092e-08,  3.342743110621801e-10, -7.908876374694415e-12,  1.641482155079120e-13, -3.059305812309859e-15,  5.206278613746326e-17,
 -8.191523833102582e-19,  1.203143783212114e-20, -1.662011395721609e-22,  3.659005328169365e-05, -3.627918851651292e-06,  1.954320434777616e-07, -7.514169219626084e-09,
  2.298612740025736e-10, -5.927402909803886e-12,  1.335196139986320e-13, -2.691051387411339e-15,  4.936801096295945e-17, -8.350009158831678e-19,  1.315086942189119e-20,
 -1.943523841483772e-22,  1.612576370723220e-05, -1.783900049657618e-06,  1.062605882214379e-07, -4.486234003479973e-09,  1.498508254156328e-10, -4.199901086736760e-12,
  1.024223181008724e-13, -2.227252017673843e-15,  4.395333056821772e-17, -7.975807518072897e-19,  1.344441273767277e-20, -2.121874641387276e-22,  6.873537277730422e-06,
 -8.434624171360154e-07,  5.531516726273780e-08, -2.555281117752614e-09,  9.291632377572291e-11, -2.822884538146821e-12,  7.434957871902542e-14, -1.740580573731396e-15,
  3.687464325940230e-17, -7.165075989578553e-19,  1.290334518722855e-20, -2.171075098908353e-22,  2.840279576594992e-06, -3.845516367920558e-07,  2.765205005496202e-08,
 -1.392943734527049e-09,  5.497875254178407e-11, -1.805904700232539e-12,  5.125033034515046e-14, -1.288914060358751e-15,  2.925544132186655e-17, -6.075776422657152e-19,
  1.166902585435583e-20, -2.089658084142711e-22,  1.140713148970930e-06, -1.695557465240582e-07,  1.331642548687025e-08, -7.291062304640494e-10,  3.114818105295361e-11,
 -1.103417791077907e-12,  3.366430507651693e-14, -9.076124010415685e-16,  2.202867260013682e-17, -4.880838816594732e-19,  9.980014144158463e-21, -1.899013420162437e-22,
  4.465204413021383e-07, -7.252515367909785e-08,  6.198019394266430e-09, -3.676950440622256e-10,  1.695573307949215e-11, -6.461956423741379e-13,  2.114712866582856e-14,
 -6.099471519664337e-16,  1.579988187314797e-17, -3.728125059840979e-19,  8.102016269376098e-21, -1.635471715219281e-22,  1.708744627784595e-07, -3.019366211492472e-08,
  2.797835785365696e-09, -1.792937070927479e-10,  8.900493403935557e-12, -3.640429743806918e-13,  1.275088031809504e-14, -3.926507830716067e-16,  1.083469869338177e-17,
 -2.717742735916549e-19,  6.266756319491633e-21, -1.339817345971434e-22,  6.413812482037292e-08, -1.227772224875960e-08,  1.229347091933900e-09, -8.484673081993651e-11,
  4.522286866431981e-12, -1.980390793988201e-13,  7.407775162670027e-15, -2.430515390839520e-16,  7.130721668007364e-18, -1.898032604370391e-19,  4.635901738016741e-21,
 -1.048062877653164e-22,  2.369767074987180e-08, -4.894589138562737e-09,  5.278078073824711e-10, -3.911917377050181e-11,  2.232822717221006e-12, -1.044409044080962e-13,
  4.163009372083341e-15, -1.452375591538322e-16,  4.521790589795743e-18, -1.274903364735255e-19,  3.292769580723952e-21, -7.858773099972226e-23,  8.651859475203628e-09,
 -1.920591749081574e-09,  2.223230410951791e-10, -1.764433124949674e-11,  1.075688288439481e-12, -5.361622615530587e-14,  2.272370401876374e-15, -8.412419283093263e-17,
  2.774028395064943e-18, -8.269539606240501e-20,  2.254573689413037e-21, -5.671208103126462e-23,  3.134075191520910e-09, -7.449091402483929e-10,  9.226873763714592e-11,
 -7.818914087178248e-12,  5.078325937367207e-13, -2.690842704664904e-14,  1.209912218549707e-15, -4.743102018647871e-17,  1.653325392844710e-18, -5.201436404667994e-20,
  1.494287006100903e-21, -3.954785463308191e-23,  1.131366276341119e-09, -2.868502343698335e-10,  3.789977024261116e-11, -3.419536961251299e-12,  2.359964130142697e-13,
 -1.326125292096007e-14,  6.311814571936672e-16, -2.614618596289109e-17,  9.614743411733367e-19, -3.186156199779225e-20,  9.627470065278651e-22, -2.676187954552810e-23,
  4.088836408476660e-10, -1.101861561343255e-10,  1.548013538709686e-11, -1.482888706535847e-12,  1.084601975299098e-13, -6.447594770472290e-15,  3.240951481505175e-16,
 -1.415558442800219e-17,  5.480162577398352e-19, -1.909110808928072e-20,  6.056067837490207e-22, -1.764905552920268e-23,  1.486654738569915e-10, -4.242773135696946e-11,
  6.318305293603282e-12, -6.407542630593248e-13,  4.953583742742349e-14, -3.107488585105304e-15,  1.645753312846887e-16, -7.562209687160279e-18,  3.075556541218523e-19,
 -1.124042899567374e-20,  3.735989589792733e-22, -1.139309905440610e-23,  5.465553872625146e-11, -1.646027147274369e-11,  2.590127400762584e-12, -2.772723742014475e-13,
  2.259540331000468e-14, -1.491968508697042e-15,  8.305001118412305e-17, -4.005409166318867e-18,  1.707535818462131e-19, -6.533233467372466e-21,  2.270527922341110e-22,
 -7.231221420356921e-24,  2.042397383188782e-11, -6.467935269136020e-12,  1.072014618328557e-12, -1.207802152234308e-13,  1.034631036406450e-14, -7.171807358127810e-16,
  4.185450533410685e-17, -2.113632138617395e-18,  9.423229956549505e-20, -3.766128686382887e-21,  1.365658542616146e-22, -4.532923451087633e-24,  7.798967431286638e-12,
 -2.587912811693835e-12,  4.503342636511698e-13, -5.323863413620422e-14,  4.780241623255772e-15, -3.469069103845880e-16,  2.117037474173060e-17, -1.116632890685851e-18,
  5.193791079107118e-20, -2.163269755240575e-21,  8.166463239159050e-23, -2.818904814214067e-24,  3.059395845131905e-12, -1.059991041645159e-12,  1.930253674646749e-13,
 -2.387029175015659e-14,  2.239921112389941e-15, -1.697033253594177e-16,  1.080020523489054e-17, -5.934405425942332e-19,  2.872526821812186e-20, -1.243847907042808e-21,
  4.876936649618580e-23, -1.746685636304888e-24,  1.239359004015553e-12, -4.467711764884175e-13,  8.485433274804943e-14, -1.094174939146292e-14,  1.069770263221326e-15,
 -8.436681371855659e-17,  5.583616328049452e-18, -3.187450159003304e-19,  1.601407886334994e-20, -7.190804981337286e-22,  2.921077356535078e-23, -1.082910470176476e-24,
  5.210297980611804e-13, -1.947328784186294e-13,  3.844369111810074e-14, -5.152113274639981e-15,  5.231779944529313e-16, -4.281881054754135e-17,  2.938369462593656e-18,
 -1.737737680774955e-19,  9.036922880921115e-21, -4.196727067544070e-22,  1.761724507875558e-23, -6.743375707571294e-25,  2.283261683776191e-13, -8.816327080212569e-14,
  1.802847948499475e-14, -2.502667810271330e-15,  2.630945550990715e-16, -2.227568609351799e-17,  1.580170693476348e-18, -9.652627465345364e-20,  5.180975222710919e-21,
 -2.481440752540709e-22,  1.073530338166372e-23, -4.231532316077094e-25,  1.046750807733742e-13, -4.160990251473688e-14,  8.782333433997407e-15, -1.258435434104151e-15,
  1.364960823578636e-16, -1.191659938213348e-17,  8.710568308971127e-19, -5.479126169238356e-20,  3.026243753453597e-21, -1.490497258379829e-22,  6.626607099850307e-24,
 -2.682368894978043e-25,  5.031799698962288e-14, -2.051937770328735e-14,  4.453926387287383e-15, -6.564340413677940e-16,  7.320637444150985e-17, -6.567830046225763e-18,
  4.930657504037256e-19, -3.183456250810470e-20,  1.803686594353076e-21, -9.107551857074079e-23,  4.148811639436290e-24, -1.719656349538994e-25,  2.536738556876898e-14,
 -1.057476112916957e-14,  2.351838814062557e-15, -3.552148610108925e-16,  4.058438175075656e-17, -3.728649399278311e-18,  2.865101893231001e-19, -1.892420879219292e-20,
  1.096327839053220e-21, -5.657448760063636e-23,  2.632480563639005e-24, -1.113959620619271e-25,  1.336663738039612e-14, -5.675951169085806e-15,  1.288537548619867e-15,
 -1.986943720218126e-16,  2.317187692434901e-17, -2.172231602226200e-18,  1.702431329053850e-19, -1.146402236997836e-20,  6.768035461881362e-22, -3.557624673928553e-23,
  1.685540465025706e-24, -7.259018272137131e-26,  7.287533345392946e-15, -3.141143152291269e-15,  7.251113432340177e-16, -1.137187997758354e-16,  1.348572330286053e-17,
 -1.285176042791100e-18,  1.023593825068167e-19, -7.002410859273114e-21,  4.198312513469900e-22, -2.240389807620116e-23,  1.077223144525223e-24, -4.706350096858748e-26,
  4.011164281939700e-15, -1.748795495809778e-15,  4.089114661268332e-16, -6.496805787908518e-17,  7.804281169471362e-18, -7.532172659648503e-19,  6.074028171333340e-20,
 -4.206053376966915e-21,  2.551906639102827e-22, -1.377721735766462e-23,  6.700047880724888e-25, -2.959819377325903e-26,  2.088731601759448e-15, -9.178780631770353e-16,
  2.165437086907958e-16, -3.471674743518243e-17,  4.207855677155783e-18, -4.097077932262659e-19,  3.332597834735281e-20, -2.327312796076818e-21,  1.423767132051698e-22,
 -7.749082998926982e-24,  3.798416454873767e-25, -1.690979779784613e-26,  8.020283054089543e-16, -3.539975277813527e-16,  8.392982050572350e-17, -1.352371434614089e-17,
  1.647349600490111e-18, -1.611879674143346e-19,  1.317449208651967e-20, -9.243892735933258e-22,  5.681251602513144e-23, -3.106104416129068e-24,  1.529273573344843e-25,
 -6.837371746554287e-27,  5.779460931662604e-02, -1.380833576161987e-04,  3.416198729469453e-07, -8.701768679675761e-10,  2.266491612288509e-12, -5.997948689388502e-15,
  1.603668109311757e-17, -4.314345099125343e-20,  1.164085875039289e-22, -3.144136385117202e-25,  8.486503712961877e-28, -2.287821588988856e-30,  5.482241462618281e-02,
 -1.636068550079421e-04,  5.772117542648620e-07, -2.125306473185960e-09,  7.775065014363370e-12, -2.791522044476941e-14,  9.829124651561275e-17, -3.401149491085971e-19,
  1.159198792566826e-21, -3.899071160886330e-24,  1.296283617710067e-26, -4.264934982934622e-29,  4.933241047789118e-02, -2.059804964846138e-04,  1.026942827067612e-06,
 -4.939032055464501e-09,  2.257221777147373e-11, -9.900081887097370e-14,  4.202549398939607e-16, -1.736590117350921e-18,  7.013592892254977e-21, -2.776771619396496e-23,
  1.080198375534942e-25, -4.136500899622082e-28,  4.211872656114878e-02, -2.511986902095610e-04,  1.637875178275562e-06, -9.690635400629858e-09,  5.329784177235223e-11,
 -2.777543927143582e-13,  1.387021214608902e-15, -6.686155841095025e-18,  3.127798134819515e-20, -1.425625291999366e-22,  6.350838940590730e-25, -2.771985335788875e-27,
  3.412602641556169e-02, -2.850517301492046e-04,  2.318031692090444e-06, -1.648119374798246e-08,  1.072228179362531e-10, -6.531544962018225e-13,  3.776249627205839e-15,
 -2.091197480951632e-17,  1.116568533266670e-19, -5.776784657564709e-22,  2.907159032381651e-24, -1.427424958885539e-26,  2.624805827442893e-02, -2.977882055908734e-04,
  2.945374876542816e-06, -2.482859202762209e-08,  1.886715832556673e-10, -1.327106920915444e-12,  8.781036925810290e-15, -5.525352264373947e-17,  3.332281509637931e-19,
 -1.937439784769055e-21,  1.090889472213585e-23, -5.969578221834895e-26,  1.917250291567060e-02, -2.865269433768953e-04,  3.396435222019670e-06, -3.359144765915465e-08,
  2.951444554395503e-10, -2.374595723329286e-12,  1.782292098639359e-14, -1.263690363191558e-16,  8.539932446291794e-19, -5.537479676083077e-21,  3.462934303362168e-23,
 -2.097023119025636e-25,  1.330568788710520e-02, -2.548832678279795e-04,  3.583156084309920e-06, -4.120722860060946e-08,  4.151571149678439e-10, -3.791478623695660e-12,
  3.205246603404486e-14, -2.543671483590772e-16,  1.913987699215509e-18, -1.375684944688745e-20,  9.499108623509251e-23, -6.329619494313366e-25,  8.778473716593880e-03,
 -2.105419334125449e-04,  3.479660008852684e-06, -4.616762911985745e-08,  5.296174850855720e-10, -5.455478350606392e-12,  5.163952230966453e-14, -4.561474015054729e-16,
  3.801508038385885e-18, -3.013474897247141e-20,  2.286435022935388e-22, -1.668625369209549e-24,  5.509498923099600e-03, -1.621644660130104e-04,  3.126016383980699e-06,
 -4.751844441223450e-08,  6.169334585991869e-10, -7.128642182861849e-12,  7.517224909945348e-14, -7.356078202544539e-16,  6.759604498248495e-18, -5.884452382630133e-20,
  4.885864348557411e-22, -3.889801689399836e-24,  3.291922648517962e-03, -1.168973949938312e-04,  2.608911935151441e-06, -4.515296775080298e-08,  6.599098580730676e-10,
 -8.512624536493854e-12,  9.956277011590924e-14, -1.074879944473058e-15,  1.084844219662289e-17, -1.033272054132540e-19,  9.355162390668335e-22, -8.097257836605973e-24,
  1.874185487064101e-03, -7.912666550476379e-05,  2.030286764175091e-06, -3.978065348982666e-08,  6.513214971404417e-10, -9.339367737639562e-12,  1.206775866933563e-13,
 -1.432108298319203e-15,  1.582052031480334e-17, -1.643276559424318e-19,  1.617301099988076e-21, -1.517303761916332e-23,  1.017732256112374e-03, -5.044371596879923e-05,
  1.478270663820206e-06, -3.262019669293235e-08,  5.956898960236206e-10, -9.457813353167489e-12,  1.345344860050559e-13, -1.749203670125754e-15,  2.108539514849402e-17,
 -2.381461790998360e-19,  2.540708443626648e-21, -2.576719760609124e-23,  5.277165910898684e-04, -3.037062737869901e-05,  1.010219079591953e-06, -2.498393803326508e-08,
  5.067995787369753e-10, -8.877650516461951e-12,  1.385683765222085e-13, -1.968004518705428e-15,  2.581339985776425e-17, -3.161747189626080e-19,  3.647306240748598e-21,
 -3.988994608553431e-23,  2.616149253271133e-04, -1.731382312353468e-05,  6.498890417192906e-07, -1.793209189817503e-08,  4.025318470392538e-10, -7.753680542233032e-12,
  1.324013940072355e-13, -2.048373148577375e-15,  2.915986217367867e-17, -3.863944385296736e-19,  4.808454191260608e-21, -5.658666793208368e-23,  1.241744285725921e-04,
 -9.369534875220708e-06,  3.947105040363443e-07, -1.209959677997622e-08,  2.994936553490105e-10, -6.323938764561578e-12,  1.178073980803691e-13, -1.980274549186178e-15,
  3.052235583457736e-17, -4.365634319580288e-19,  5.848198359651936e-21, -7.390260362639120e-23,  5.651885741412222e-05, -4.825145518315916e-06,  2.269689788539584e-07,
 -7.698727977238323e-09,  2.094222150055308e-10, -4.833237478121692e-12,  9.796610315686839e-14, -1.784900132862971e-15,  2.971982579790426e-17, -4.578700740160983e-19,
  6.589437247497893e-21, -8.924534835556719e-23,  2.471188595797673e-05, -2.370614115112234e-06,  1.239176177454817e-07, -4.633393944886575e-09,  1.380713409297420e-10,
 -3.473131949630713e-12,  7.640515387404825e-14, -1.505392136727639e-15,  2.702074534560020e-17, -4.475000942288034e-19,  6.905744970863423e-21, -1.000611511379201e-22,
  1.039948250714770e-05, -1.114006012888599e-06,  6.442043050946869e-08, -2.645696899475513e-09,  8.610375778149767e-11, -2.354414293702865e-12,  5.607984188010984e-14,
 -1.192259271673546e-15,  2.302243998673473e-17, -4.090913401947152e-19,  6.757217625517829e-21, -1.045674085048357e-22,  4.221255347312938e-06, -5.020557140099123e-07,
  3.198260671414576e-08, -1.437774630379298e-09,  5.095449117058539e-11, -1.510677737308087e-12,  3.887015006691054e-14, -8.898169549731382e-16,  1.844867084791378e-17,
 -3.510847804096024e-19,  6.196393924454589e-21, -1.022412135548910e-22,  1.656615828733153e-06, -2.176070979840048e-07,  1.520981704833139e-08, -7.459956398088003e-10,
  2.870888276666272e-11, -9.205700360700941e-13,  2.553001374926606e-14, -6.280112789860991e-16,  1.395378112453320e-17, -2.838870351976825e-19,  5.344707064887672e-21,
 -9.388069698602965e-23,  6.302036787874370e-07, -9.097885212397111e-08,  6.950754745839725e-09, -3.707750681823507e-10,  1.545243605619450e-11, -5.346151503051481e-13,
  1.594553158770618e-14, -4.206487383813378e-16,  9.997673899270443e-18, -2.170726561486708e-19,  4.352338666994577e-21, -8.125731847007306e-23,  2.330542633461075e-07,
 -3.680660550731607e-08,  3.062567026473643e-09, -1.771369185098574e-10,  7.973561365955335e-12, -2.969452278158733e-13,  9.504936356628484e-15, -2.683741572033793e-16,
  6.810547559559928e-18, -1.575422861879105e-19,  3.358547318279081e-21, -6.654410120864353e-23,  8.404355209052421e-08, -1.445751079971916e-08,  1.305610957861316e-09,
 -8.163952240770257e-11,  3.958917153290365e-12, -1.583336009135577e-13,  5.427557484478881e-15, -1.637049810029700e-16,  4.427702464983454e-18, -1.089340624082347e-19,
  2.465222468235171e-21, -5.175668300484456e-23,  2.965512777077383e-08, -5.533637629057253e-09,  5.405508921495475e-10, -3.643646913434430e-11,  1.898626734110871e-12,
 -8.136033924043061e-14,  2.980518057280877e-15, -9.584575006047447e-17,  2.757898441200882e-18, -7.204335449074127e-20,  1.727920950629984e-21, -3.838113558432040e-23,
  1.027657307460311e-08, -2.071834790782906e-09,  2.182097429972357e-10, -1.581103781335599e-11,  8.830753861295712e-13, -4.045348983027006e-14,  1.580417540137527e-15,
 -5.407930713818774e-17,  1.652471187059574e-18, -4.575448211421347e-20,  1.161162934018059e-21, -2.724546248516694e-23,  3.511460207907111e-09, -7.619423628572344e-10,
  8.624897459402898e-11, -6.699094506750216e-12,  4.000366646130919e-13, -1.954565823752714e-14,  8.126178580524166e-16, -2.953041696828245e-17,  9.564614956133922e-19,
 -2.802160672526610e-20,  7.512100221125730e-22, -1.859000874751627e-23,  1.188205313322290e-09, -2.764582253398393e-10,  3.352866200576481e-11, -2.783888629323331e-12,
  1.772935040826444e-13, -9.217972521343621e-15,  4.069709807144677e-16, -1.567479822943407e-17,  5.371264263217489e-19, -1.662080714390948e-20,  4.698836450048601e-22,
 -1.224382961395045e-23,  4.000082934282162e-10, -9.943054731948248e-11,  1.288002583313573e-11, -1.140050178926802e-12,  7.723698659553599e-14, -4.263303040018897e-15,
  1.994437914393682e-16, -8.125042545093910e-18,  2.939927264149635e-19, -9.590993392118481e-21,  2.854362993560349e-22, -7.818303687199797e-24,  1.346366208717496e-10,
 -3.562536434548617e-11,  4.913899587475521e-12, -4.623771826479050e-13,  3.323890840685687e-14, -1.943177273321546e-15,  9.610899612182548e-17, -4.132580895234640e-18,
  1.575800055514861e-19, -5.409443469739955e-21,  1.691664401394989e-22, -4.862196223152270e-24,  4.554532426739611e-11, -1.278299853090358e-11,  1.871656060125635e-12,
 -1.866965384529783e-13,  1.420375564844436e-14, -8.773124651981794e-16,  4.577044248724902e-17, -2.072759337908220e-18,  8.311837649188197e-20, -2.996486630079638e-21,
  9.827983324197954e-23, -2.958706502032051e-24,  1.557023571100706e-11, -4.618838462837540e-12,  7.156449089967840e-13, -7.545779698937714e-14,  6.059373494772464e-15,
 -3.944328346266102e-16,  2.165459581011603e-17, -1.030475422771896e-18,  4.336263144364443e-20, -1.638306217944424e-21,  5.624353661414713e-23, -1.770085345888481e-24,
  5.410004836665410e-12, -1.690217081706071e-12,  2.762523344408575e-13, -3.069993299301479e-14,  2.594921288742754e-15, -1.775558000318077e-16,  1.023256850610304e-17,
 -5.104709668307260e-19,  2.249037949760062e-20, -8.885801216593805e-22,  3.186326058811134e-23, -1.046204462003779e-24,  1.921762939224657e-12, -6.300993857902659e-13,
  1.082864592572930e-13, -1.264519380776740e-14,  1.121869858436662e-15, -8.047229690578659e-17,  4.855677088355738e-18, -2.533160152072522e-19,  1.165750525933677e-20,
 -4.805438276733124e-22,  1.795908213027507e-23, -6.138850650515053e-25,  7.020691226552570e-13, -2.407166885630645e-13,  4.335571517406495e-14, -5.303631087948088e-15,
  4.924281721907023e-16, -3.692493218938819e-17,  2.326520844031738e-18, -1.265965320077767e-19,  6.070137445351549e-21, -2.604397569226545e-22,  1.012054406045822e-23,
 -3.593371864414775e-25,  2.653335669888398e-13, -9.479421099614212e-14,  1.783349518506293e-14, -2.277985116745925e-15,  2.206714341256056e-16, -1.724736751444510e-17,
  1.131538449683281e-18, -6.404799888341319e-20,  3.191358583370394e-21, -1.421550471244384e-22,  5.729741223221705e-24, -2.108098367193375e-25,  1.043263369827293e-13,
 -3.869773771801305e-14,  7.578037263940899e-15, -1.007448241366384e-15,  1.014994389472882e-16, -8.243487124675316e-18,  5.614794778552418e-19, -3.296487641489447e-20,
  1.702214576568243e-21, -7.850822377121956e-23,  3.273667199005735e-24, -1.244946580365230e-25,  4.289861699092833e-14, -1.646144148013642e-14,  3.343626481796029e-15,
 -4.610511007890141e-16,  4.815040165792809e-17, -4.050697394810208e-18,  2.855523032118412e-19, -1.733735131104067e-20,  9.250722562380166e-22, -4.405188976513843e-23,
  1.895129517390083e-24, -7.429453958491658e-26,  1.852906371332547e-14, -7.328829072765429e-15,  1.538453912996694e-15, -2.192516722593390e-16,  2.365434143659651e-17,
 -2.054353416319772e-18,  1.494027763188367e-19, -9.351272088574555e-21,  5.140054105131927e-22, -2.519737226864875e-23,  1.115141371753423e-24, -4.493960441441389e-26,
  8.432824127303156e-15, -3.425529956135528e-15,  7.403857243961861e-16, -1.086559277906302e-16,  1.206669878915905e-17, -1.078149707279134e-18,  8.061639340114204e-20,
 -5.184696696158648e-21,  2.926413786064416e-22, -1.472210427333121e-23,  6.682328723997455e-25, -2.760111653046689e-26,  4.047875176631153e-15, -1.682546496910386e-15,
  3.730082802687513e-16, -5.615780462519279e-17,  6.395974368324649e-18, -5.858106695296291e-19,  4.487823932109783e-20, -2.955536622249030e-21,  1.707319065557297e-22,
 -8.785828732532910e-24,  4.077055456633927e-25, -1.720695175375017e-26,  2.043932575162122e-15, -8.661620553284372e-16,  1.961893302736124e-16, -3.018387611031468e-17,
  3.512167951644614e-18, -3.285221692368785e-19,  2.569181505314221e-20, -1.726440747417709e-21,  1.017160768204609e-22, -5.336075549793127e-24,  2.523236544697596e-25,
 -1.084619486933023e-26,  1.075501028296368e-15, -4.629566778969691e-16,  1.067116368185175e-16, -1.671044587061795e-17,  1.978730809049131e-18, -1.882973611239951e-19,
  1.497588389120419e-20, -1.023081386379796e-21,  6.125616524508024e-23, -3.264566947489387e-24,  1.567649060121514e-25, -6.840439824124523e-27,  5.757607069796096e-16,
 -2.508249430819940e-16,  5.859751529752362e-17, -9.301729212174789e-18,  1.116386813056343e-18, -1.076531792895491e-19,  8.673932547634080e-21, -6.001431760909188e-22,
  3.638262361615199e-23, -1.962673700781765e-24,  9.537398942299684e-26, -4.210091820179824e-27,  2.940109627663541e-16, -1.291494153989891e-16,  3.045489745370604e-17,
 -4.880359529946582e-18,  5.912570730186949e-19, -5.754338832966432e-20,  4.678572192940020e-21, -3.265864444337110e-22,  1.997096934522226e-23, -1.086503392489706e-24,
  5.323628073355920e-26, -2.369038398784670e-27,  1.116605606913826e-16, -4.927538972662692e-17,  1.168032070688200e-17, -1.881659940685393e-18,  2.291594297325343e-19,
 -2.241776036485096e-20,  1.831902086787173e-21, -1.285089281841792e-22,  7.896484088805848e-24, -4.316367949827287e-25,  2.124719422517086e-26, -9.497759479106515e-28,
  5.724767652916801e-02, -1.353915596195951e-04,  3.313914417146154e-07, -8.348521654133715e-10,  2.150285724516182e-12, -5.627153838436414e-15,  1.487915950028538e-17,
 -3.959311868495400e-20,  1.056772342611533e-22, -2.823969457549619e-25,  7.541921508686856e-28, -2.012048702449595e-30,  5.417706400163990e-02, -1.590891024810384e-04,
  5.524364652956554e-07, -2.005246860549915e-09,  7.239600249400521e-12, -2.566644369808310e-14,  8.926694000453314e-17, -3.051699360217048e-19,  1.027730502004757e-21,
 -3.416205950161113e-24,  1.122515019726263e-26, -3.650558971751477e-29,  4.852455268447062e-02, -1.979960347646115e-04,  9.697777658254753e-07, -4.593184777303436e-09,
  2.068925124949783e-11, -8.947372814976873e-14,  3.746279728640850e-16, -1.527349759231735e-18,  6.087536222027336e-21, -2.378991071366614e-23,  9.136665024342894e-26,
 -3.454772717201974e-28,  4.113942123905050e-02, -2.385467530134138e-04,  1.526526518005511e-06, -8.880563635882220e-09,  4.806103982736357e-11, -2.466039033846562e-13,
  1.213083459306223e-15, -5.762702501002362e-18,  2.657505854330740e-20, -1.194395915273562e-22,  5.247911348688710e-25, -2.259702587535267e-27,  3.302169533508310e-02,
 -2.672703710680659e-04,  2.130135099549922e-06, -1.486540120738012e-08,  9.502060749167170e-11, -5.691656203839038e-13,  3.237763376228642e-15, -1.765042794097294e-17,
  9.281061330705507e-20, -4.730419623236061e-22,  2.345915770784166e-24, -1.135378127868998e-26,  2.510221435809031e-02, -2.753676056610223e-04,  2.664704057924198e-06,
 -2.201123846253615e-08,  1.641175431664104e-10, -1.133783823785904e-12,  7.373311018422112e-15, -4.562685105675768e-17,  2.707404971363514e-19, -1.549409534838129e-21,
  8.590072949860699e-24, -4.629897078894945e-26,  1.807829391565733e-02, -2.608910359411917e-04,  3.020176610338365e-06, -2.922698034327505e-08,  2.516586482363669e-10,
 -1.986392645413124e-12,  1.463901447365445e-14, -1.019805585267594e-16,  6.775029175450403e-19, -4.320649984134283e-21,  2.658486548562442e-23, -1.584525368951534e-25,
  1.234050571396162e-02, -2.280885464263685e-04,  3.126151108722171e-06, -3.513185759736788e-08,  3.464771477077294e-10, -3.101198498569651e-12,  2.571812926124525e-14,
 -2.003613634909104e-16,  1.480915069569735e-18, -1.046095190615042e-20,  7.102143130871825e-23, -4.654884221759419e-25,  7.988664769563104e-03, -1.847845190182857e-04,
  2.973097950836692e-06, -3.850339541468278e-08,  4.319338688909508e-10, -4.356591764717991e-12,  4.041918052347738e-14, -3.502258782801405e-16,  2.864995518613690e-18,
 -2.230513378376728e-20,  1.662941701473870e-22, -1.193012356012585e-24,  4.907469297939498e-03, -1.392796461139919e-04,  2.610615158621615e-06, -3.869665425122648e-08,
  4.908520791352508e-10, -5.549060099857676e-12,  5.731013622650560e-14, -5.497341833512969e-16,  4.955289215311120e-18, -4.234072461207425e-20,  3.452444805515885e-22,
 -2.700525533145616e-24,  2.862881383872985e-03, -9.802609025904556e-05,  2.125203537445346e-06, -3.583616880847888e-08,  5.113036425858077e-10, -6.448244876011713e-12,
  7.381474437521014e-14, -7.806679180265463e-16,  7.724341466937881e-18, -7.217328171632336e-20,  6.413934638141954e-22, -5.451787485646572e-24,  1.587372685014397e-03,
 -6.462992050763581e-05,  1.609756626669296e-06, -3.070911511561902e-08,  4.905227270286517e-10, -6.872137180527299e-12,  8.685878912360283e-14, -1.009217784088741e-15,
  1.092433178478298e-17, -1.112613440824722e-19,  1.074338387930097e-21, -9.893912915763922e-24,  8.373417205606535e-04, -4.003460598362190e-05,  1.138298243945112e-06,
 -2.444235118691048e-08,  4.352175274925507e-10, -6.747745028208509e-12,  9.384215538194148e-14, -1.194051946352438e-15,  1.409739858278497e-17, -1.560564671562762e-19,
  1.632835113200757e-21, -1.624963786496822e-23,  4.206770007754950e-04, -2.336266099445127e-05,  7.537432218809252e-07, -1.813205721960003e-08,  3.584807255296209e-10,
 -6.129507242927509e-12,  9.349997970426830e-14, -1.299045955888232e-15,  1.668246589042771e-17, -2.002050325517291e-19,  2.264283135234933e-21, -2.429302122254573e-23,
  2.015353558559711e-04, -1.287671607248752e-05,  4.687397803399199e-07, -1.257727577101850e-08,  2.750837299235458e-10, -5.170495661332395e-12,  8.625827225261980e-14,
 -1.305081693495758e-15,  1.818472704283483e-17, -2.360306177772816e-19,  2.879017974747656e-21, -3.322851890575844e-23,  9.219557218564390e-05, -6.719869668701571e-06,
  2.745434454997538e-07, -8.182945491776942e-09,  1.973115798487848e-10, -4.064617021610789e-12,  7.395946516475201e-14, -1.215553522137936e-15,  1.833455108712738e-17,
 -2.568215557356598e-19,  3.371543646497061e-21, -4.177837264517934e-23,  4.033635924313417e-05, -3.328563475902339e-06,  1.518704810917483e-07, -5.008780124851378e-09,
  1.327180088336870e-10, -2.987896168727146e-12,  5.914791753235223e-14, -1.053538649149963e-15,  1.716456590992599e-17, -2.589463113416784e-19,  3.651664244798951e-21,
 -4.849198429974850e-23,  1.690676910532434e-05, -1.568817154684980e-06,  7.956689958670010e-08, -2.893068233071748e-09,  8.397981790272874e-11, -2.060686278324620e-12,
  4.427296780160868e-14, -8.527524797438443e-16,  1.497626531094926e-17, -2.428641332856303e-19,  3.672319800744261e-21, -5.217045390197964e-23,  6.801994342633617e-06,
 -7.053702210699711e-07,  3.959324227192122e-08, -1.581625090995092e-09,  5.014922559569946e-11, -1.337792201590467e-12,  3.112213453969041e-14, -6.468664273056673e-16,
  1.222216064245245e-17, -2.126664696214483e-19,  3.442104399528059e-21, -5.222763313821644e-23,  2.632391244217697e-06, -3.033529976214083e-07,  1.876753028617599e-08,
 -8.209297415392020e-10,  2.835247108587550e-11, -8.202259341652246e-13,  2.061619649314656e-14, -4.614643258871698e-16,  9.362951334506867e-18, -1.744999941962309e-19,
  3.018222831443796e-21, -4.883565781701313e-23,  9.822684373581889e-07, -1.251368876728709e-07,  8.499796676424313e-09, -4.058323653974528e-10,  1.522584346494757e-11,
 -4.765509818188408e-13,  1.291369271128451e-14, -3.106818814077258e-16,  6.756879419117825e-18, -1.346558881184266e-19,  2.484954702038532e-21, -4.281080969059507e-23,
  3.543325427541804e-07, -4.966200789003331e-08,  3.689839148652109e-09, -1.917176269624356e-10,  7.793100107658362e-12, -2.632815212783686e-13,  7.675795363179497e-15,
 -1.981058330059448e-16,  4.610163666058671e-18, -9.807864032683588e-20,  1.928091671012437e-21, -3.531566251752448e-23,  1.239211457195007e-07, -1.902175669138254e-08,
  1.540506514555288e-09, -8.684761149758424e-11,  3.815175859606460e-12, -1.388117297835464e-13,  4.345148102527262e-15, -1.200808512476257e-16,  2.984882578491573e-18,
 -6.767957614225890e-20,  1.415154730881604e-21, -2.751776590816144e-23,  4.215131781516787e-08, -7.055889968233793e-09,  6.207644028207295e-10, -3.786361723619550e-11,
  1.793108079010822e-12, -7.010599030995805e-14,  2.351438952434913e-15, -6.945335785700696e-17,  1.840911402972568e-18, -4.441542046930906e-20,  9.863023382642486e-22,
 -2.033092192106304e-23,  1.399328828495687e-08, -2.544066562233026e-09,  2.423534591276001e-10, -1.594911660126688e-11,  8.122418021954634e-13, -3.404995166191703e-14,
  1.221307810916077e-15, -3.848329319378146e-17,  1.085800237980658e-18, -2.783033814022621e-20,  6.553296329812415e-22, -1.429915353510666e-23,  4.551183031616450e-09,
 -8.951687687759269e-10,  9.204402584195314e-11, -6.517607639019524e-12,  3.560807706932814e-13, -1.597023061255125e-14,  6.113343996168795e-16, -2.051194502348258e-17,
  6.149910895024147e-19, -1.671842209480998e-20,  4.168012883047660e-22, -9.612596008484447e-24,  1.456216784333718e-09, -3.087010489264914e-10,  3.415490073873105e-11,
 -2.595241931871926e-12,  1.517402384777079e-13, -7.265092231617318e-15,  2.962031782140689e-16, -1.056287673291714e-17,  3.359410805972864e-19, -9.669968171377209e-21,
  2.548386405661793e-22, -6.202715101865457e-24,  4.604472927710898e-10, -1.048153477597610e-10,  1.244051829444628e-11, -1.011645818099404e-12,  6.314831602083865e-14,
 -3.220451791861278e-15,  1.395580984626351e-16, -5.279342124458477e-18,  1.777856928264358e-19, -5.409451599066550e-21,  1.504509143982334e-22, -3.858696639683620e-24,
  1.445764925816870e-10, -3.521331047657582e-11,  4.469964623853988e-12, -3.879629775444105e-13,  2.579119270907109e-14, -1.397855491737805e-15,  6.425093272735259e-17,
 -2.573252236561339e-18,  9.158601983949717e-20, -2.940456398844983e-21,  8.616435482192427e-23, -2.324887050081198e-24,  4.531560883576254e-11, -1.176716945769223e-11,
  1.592719094036467e-12, -1.471440362319076e-13,  1.039182371148264e-14, -5.971963878330301e-16,  2.905204366563993e-17, -1.229350150007969e-18,  4.615475833259375e-20,
 -1.560757523081396e-21,  4.810151780749771e-23, -1.363106071183121e-24,  1.425776588123687e-11, -3.933254064722461e-12,  5.659369662140382e-13, -5.549990545490281e-14,
  4.153410970946087e-15, -2.524843449860493e-16,  1.297082262449241e-17, -5.786899624737377e-19,  2.287228332131073e-20, -8.130734833393518e-22,  2.630667941388316e-23,
 -7.815650148108532e-25,  4.529734633730051e-12, -1.322860055284365e-12,  2.017168523326087e-13, -2.093944687636730e-14,  1.656172004516388e-15, -1.062362943641848e-16,
  5.750055677618462e-18, -2.698814231170047e-19,  1.120588588618507e-20, -4.179202237069876e-22,  1.416779887091630e-23, -4.404724993865820e-25,  1.462183083450027e-12,
 -4.504479423293014e-13,  7.256466604970287e-14, -7.950466295585589e-15,  6.628052428298735e-16, -4.474893595002759e-17,  2.545630932735188e-18, -1.254051010354540e-19,
  5.458047170129186e-21, -2.131026169144469e-22,  7.554088379724411e-24, -2.452770442822148e-25,  4.826454458189195e-13, -1.562880649518761e-13,  2.651359551407962e-14,
 -3.056936590600981e-15,  2.678633523886553e-16, -1.898375106024267e-17,  1.132152043579965e-18, -5.839652881271326e-20,  2.657931358392074e-21, -1.083984541062949e-22,
  4.009205156826624e-24, -1.356685594490733e-25,  1.639845893024229e-13, -5.561562246169296e-14,  9.903196561559882e-15, -1.197853752681163e-15,  1.100001818882661e-16,
 -8.160600012798916e-18,  5.088554124213933e-19, -2.741099028479329e-20,  1.301496447873713e-21, -5.531138378936476e-23,  2.129561564658468e-24, -7.493530290843448e-26,
  5.772764339741447e-14, -2.043154361611620e-14,  3.805814153559778e-15, -4.813881117457939e-16,  4.618704760287330e-17, -3.576324544585087e-18,  2.325072294168054e-19,
 -1.304479502085992e-20,  6.444366658569275e-22, -2.846718517982647e-23,  1.138139806447645e-24, -4.154642105595483e-26,  2.119136525853002e-14, -7.798517195180731e-15,
  1.514302265951380e-15, -1.996330945125813e-16,  1.994820628516383e-17, -1.607208892086849e-18,  1.086201858925757e-19, -6.329027639990950e-21,  3.244144479028415e-22,
 -1.485559434120030e-23,  6.151542483581013e-25, -2.323612556242170e-26,  8.160957899064253e-15, -3.111190483587730e-15,  6.275076671947468e-16, -8.592204187504959e-17,
  8.911871851148814e-18, -7.447066545786590e-19,  5.215599181242897e-20, -3.146597698761120e-21,  1.668589487086948e-22, -7.898182717599734e-24,  3.378013871852211e-25,
 -1.316781461931761e-26,  3.314479529603161e-15, -1.304111701019574e-15,  2.721991353470535e-16, -3.857179939682472e-17,  4.138158889701710e-18, -3.574356039572178e-19,
  2.585642509264590e-20, -1.610011669500941e-21,  8.805116115922854e-23, -4.295273664529927e-24,  1.891869347272398e-25, -7.588860891701660e-27,  1.425312461999237e-15,
 -5.766221433232571e-16,  1.240738215668691e-16, -1.812721903576259e-17,  2.004260777177314e-18, -1.783101017981296e-19,  1.327693939543569e-20, -8.503996110218258e-22,
  4.780875856592077e-23, -2.395850137491108e-24,  1.083379014968182e-25, -4.458508327267255e-27,  6.501719724268787e-16, -2.694305664258268e-16,  5.953072311316400e-17,
 -8.932436738889921e-18,  1.013972386088483e-18, -9.256940860822814e-20,  7.069212011406778e-21, -4.641212998430088e-22,  2.673034831914840e-23, -1.371518424440119e-24,
  6.346406995397872e-26, -2.671057933923007e-27,  3.140392802220929e-16, -1.327960854070204e-16,  3.000735469602281e-17, -4.605609418927329e-18,  5.346403983552156e-19,
 -4.989383333427345e-20,  3.893106673690374e-21, -2.610338660707863e-22,  1.534626741262633e-23, -8.033912206940979e-25,  3.791215603520338e-26, -1.626441864274371e-27,
  1.592326384117495e-16, -6.844678035180502e-17,  1.575233350507904e-17, -2.462838101490079e-18,  2.911776010790222e-19, -2.766637403283376e-20,  2.197112274867686e-21,
 -1.498777989355935e-22,  8.961070235489465e-24, -4.769073757447435e-25,  2.287024538143165e-26, -9.966344901925062e-28,  8.280347527407168e-17, -3.604289561138335e-17,
  8.412532138331798e-18, -1.334152431599247e-18,  1.599761127105857e-19, -1.541250750252438e-20,  1.240728788686921e-21, -8.577067401880530e-23,  5.195291517159479e-24,
 -2.800301020340841e-25,  1.359677387081276e-26, -5.997306024820326e-28,  4.142628219872862e-17, -1.818960320595735e-17,  4.287290020685314e-18, -6.867039276187673e-19,
  8.315487560620189e-20, -8.089163921277829e-21,  6.573885594821485e-22, -4.586818468713326e-23,  2.803633174813863e-24, -1.524634780418203e-25,  7.467223080899006e-27,
 -3.321579503239508e-28,  1.555286637384846e-17, -6.862108937830322e-18,  1.626251692208691e-18, -2.619253865235992e-19,  3.189171044613100e-20, -3.119154040803844e-21,
  2.548311843911890e-22, -1.787272016621327e-23,  1.097992914831585e-24, -6.000591320044559e-26,  2.953169627999433e-27, -1.319838633080792e-28,  5.671134991958194e-02,
 -1.327799245411624e-04,  3.215759910736401e-07, -8.013289061811167e-10,  2.041225784613015e-12, -5.282984359123197e-15,  1.381640777536130e-17, -3.636845420842683e-20,
  9.603329673771848e-23, -2.539267634574853e-25,  6.710656986302169e-28, -1.771870340211763e-30,  5.354939690590541e-02, -1.547639317075936e-04,  5.290519340234674e-07,
 -1.893406323244680e-09,  6.747022050672836e-12, -2.362296857742450e-14,  8.116471666599841e-17, -2.741666815890653e-19,  9.124567199506748e-22, -2.997730673931565e-24,
  9.736493123213349e-27, -3.130233022458619e-29,  4.774774367690131e-02, -1.904527909278117e-04,  9.165882075880706e-07, -4.275998193170390e-09,  1.898633386605126e-11,
 -8.097460063544064e-14,  3.344655066452160e-16, -1.345574917339609e-18,  5.293379391156752e-21, -2.042191382597720e-23,  7.744294902265642e-26, -2.891835501851623e-28,
  4.020900170231577e-02, -2.267481001472683e-04,  1.424415833840855e-06, -8.149514943912196e-09,  4.340751226813976e-11, -2.193339058525765e-13,  1.063014804967315e-15,
 -4.977233138505674e-18,  2.263029759704131e-20, -1.003085594304833e-22,  4.347634088734099e-25, -1.847078623642533e-27,  3.198560162278188e-02, -2.509178224361831e-04,
  1.960509845368251e-06, -1.343207813286416e-08,  8.437599707828606e-11, -4.970693511239794e-13,  2.782694120606230e-15, -1.493578354871436e-17,  7.735635389238315e-20,
 -3.884812775998412e-22,  1.898809996443914e-24, -9.059822880127597e-27,  2.404176717142475e-02, -2.550635356440065e-04,  2.415606182219316e-06, -1.955756577796809e-08,
  1.431128288544528e-10, -9.712252472914257e-13,  6.209116217184952e-15, -3.779308779687098e-17,  2.206853138006538e-19, -1.243332211660154e-21,  6.788401724792018e-24,
 -3.604316168236121e-26,  1.708092415389834e-02, -2.380669669049120e-04,  2.692360342008587e-06, -2.550010407031412e-08,  2.152249438593882e-10, -1.667008623519367e-12,
  1.206508468052530e-14, -8.259682324409325e-17,  5.395317062986328e-19, -3.384633127818970e-21,  2.049386447080392e-23, -1.202445369650461e-25,  1.147562702060681e-02,
 -2.046759299683202e-04,  2.735887476874505e-06, -3.005269392250568e-08,  2.901973762254259e-10, -2.546259143933407e-12,  2.071853505606036e-14, -1.584869992393167e-16,
  1.150876782878159e-18, -7.991136869747339e-21,  5.335259279905656e-23, -3.440102099935949e-25,  7.294327546681909e-03, -1.627367077951149e-04,  2.549809556069204e-06,
 -3.223995841927950e-08,  3.537588764913848e-10, -3.494545982089191e-12,  3.178424929775700e-14, -2.702060742855179e-16,  2.170083749169678e-18, -1.659601163990924e-20,
  1.215992241014267e-22, -8.577046492021711e-25,  4.389357558601793e-03, -1.201266262567010e-04,  2.189943244346943e-06, -3.166106642672196e-08,  3.924654698843823e-10,
 -4.341727774794548e-12,  4.392613669574618e-14, -4.131041788500685e-16,  3.653390227739973e-18, -3.064539879016551e-20,  2.454364880164360e-22, -1.886538001267213e-24,
  2.502240893994531e-03, -8.261473440350606e-05,  1.740291452495460e-06, -2.859773381985906e-08,  3.984185029031348e-10, -4.913298914982555e-12,  5.505870465082814e-14,
 -5.705433175479591e-16,  5.535375385660055e-18, -5.074603026861138e-20,  4.427217762972111e-22, -3.696064173505748e-24,  1.352450677275578e-03, -5.310223758837222e-05,
  1.284144069262295e-06, -2.385597127557657e-08,  3.718266513376982e-10, -5.090545303842427e-12,  6.294718497814254e-14, -7.162147840353314e-16,  7.597822714376695e-18,
 -7.588674259070935e-20,  7.190254802300204e-22, -6.500981607240145e-24,  6.937129877381096e-04, -3.199258819225876e-05,  8.826848013250661e-07, -1.844665234973686e-08,
  3.203195946774286e-10, -4.850531309851593e-12,  6.596212784127120e-14, -8.214960637950173e-16,  9.500798723993870e-18, -1.030969275296435e-19,  1.058071521549611e-21,
 -1.033385408646807e-23,  3.380345129543927e-04, -1.811412919665208e-05,  5.668908013740338e-07, -1.326652395700313e-08,  2.556699612419614e-10, -4.267746178073419e-12,
  6.363040267971963e-14, -8.649427006538520e-16,  1.087668008681839e-17, -1.279082338940283e-19,  1.418460937490811e-21, -1.493062855217976e-23,  1.566685762455073e-04,
 -9.662869871091446e-06,  3.411410323632474e-07, -8.902069236265348e-09,  1.897250771723873e-10, -3.480170807134200e-12,  5.672864151628834e-14, -8.394762430242632e-16,
  1.145032035947644e-17, -1.455932678398431e-19,  1.740856797474374e-21, -1.970743717152914e-23,  6.915523153118528e-05, -4.868239333414754e-06,  1.928907995909737e-07,
 -5.590336019724686e-09,  1.313221429057549e-10, -2.639412373976613e-12,  4.691454579675748e-14, -7.539674450407137e-16,  1.112984724044368e-17, -1.526927085910431e-19,
  1.964595280739790e-21, -2.387341149529860e-23,  2.911691721318229e-05, -2.322007890087528e-06,  1.027589390182892e-07, -3.295240691879268e-09,  8.505374302591158e-11,
 -1.867968334391427e-12,  3.611627250563762e-14, -6.289432481498513e-16,  1.002695047021886e-17, -1.481329169246028e-19,  2.047067220705854e-21, -2.665487147282698e-23,
  1.171324398857042e-05, -1.051100563990478e-06,  5.171905573185112e-08, -1.828607231433959e-09,  5.170651931841520e-11, -1.237671909651780e-12,  2.596964528442539e-14,
 -4.890108883737995e-16,  8.403186870184592e-18, -1.334383372064187e-19,  1.977107303757434e-21, -2.753949628388078e-23,  4.510676557690011e-06, -4.526991079420136e-07,
  2.466149124611500e-08, -9.581460928039388e-10,  2.959712201215661e-11, -7.702375138450725e-13,  1.750067323274462e-14, -3.556127404069372e-16,  6.574483237108602e-18,
 -1.120196710210690e-19,  1.776630052340039e-21, -2.643149368077159e-23,  1.666308785149614e-06, -1.859971658980654e-07,  1.117325985197538e-08, -4.754937697709613e-10,
  1.600231110024124e-11, -4.516978612790499e-13,  1.108995494806324e-14, -2.427084856971224e-16,  4.818960004570550e-18, -8.795434413761617e-20,  1.490833212455017e-21,
 -2.365382580719510e-23,  5.918879134873701e-07, -7.310507034779969e-08,  4.824376928188173e-09, -2.241969747506092e-10,  8.198981223440660e-12, -2.504534029618456e-13,
  6.630922012677907e-15, -1.560101429018060e-16,  3.320909661229843e-18, -6.482354845795719e-20,  1.172502633749499e-21, -1.981097645397302e-23,  2.026881283409622e-07,
 -2.756945198641966e-08,  1.991509185093256e-09, -1.007669762232956e-10,  3.994387462429215e-12, -1.317527360391861e-13,  3.754133568341293e-15, -9.478176725962914e-17,
  2.159415036462241e-18, -4.500929599195985e-20,  8.674609718401897e-22, -1.558656064102610e-23,  6.710893852112027e-08, -1.000782025741303e-08,  7.886181587190554e-10,
 -4.332300105302029e-11,  1.856915592476769e-12, -6.599438476062791e-14,  2.019833394504136e-15, -5.462530047057503e-17,  1.329830290433725e-18, -2.955172192675315e-20,
  6.059898374422495e-22, -1.156305497975552e-23,  2.155201708818158e-08, -3.508997338236866e-09,  3.006470934614151e-10, -1.788255879290085e-11,  8.268146062933610e-13,
 -3.159417184217659e-14,  1.036669914956033e-15, -2.997900751205531e-17,  7.785760912951547e-19, -1.841804117689175e-20,  4.012669563593595e-22, -8.119887823146291e-24,
  6.737324175746309e-09, -1.192844058692798e-09,  1.107714280703910e-10, -7.114672193420742e-12,  3.540118660255862e-13, -1.451404640070301e-14,  5.095868461454790e-16,
 -1.573007036974192e-17,  4.350974033618598e-19, -1.094004491170444e-20,  2.528642586206088e-22, -5.418933586607802e-24,  2.058114929424711e-09, -3.947319541553341e-10,
  3.960763153888313e-11, -2.739772912321901e-12,  1.463696288538170e-13, -6.425161222769868e-15,  2.409237402333257e-16, -7.924297481255664e-18,  2.330629734594871e-19,
 -6.219043495285513e-21,  1.522767801875829e-22, -3.451136515815980e-24,  6.170050235629291e-10, -1.277165533595095e-10,  1.380533969463294e-11, -1.025788264836013e-12,
  5.870282243034395e-14, -2.753220505717527e-15,  1.100434473052189e-16, -3.849786337516604e-18,  1.201927909310445e-19, -3.398293005454215e-21,  8.801615275214180e-23,
 -2.106547433916730e-24,  1.823772047548585e-10, -4.059607405742251e-11,  4.713203804154749e-12, -3.752081292648028e-13,  2.294694111833590e-14, -1.147444395975114e-15,
  4.878988387758191e-17, -1.812171098904572e-18,  5.995487726794584e-20, -1.793222350110636e-21,  4.905204654447696e-23, -1.237954612739332e-24,  5.342183366469820e-11,
 -1.274217382133716e-11,  1.584255019702168e-12, -1.347698408277842e-13,  8.787608214614197e-15, -4.674773655295861e-16,  2.110376075848029e-17, -8.306318633114686e-19,
  2.907012564112060e-20, -9.182338584469400e-22,  2.648510365906546e-23, -7.037528526062478e-25,  1.559257576255271e-11, -3.971239192331604e-12,  5.271965499887507e-13,
 -4.779752221776250e-14,  3.314842672899671e-15, -1.871842435913172e-16,  8.952985247331296e-18, -3.726903849047813e-19,  1.377202013690512e-20, -4.586044844176131e-22,
  1.392462889780620e-23, -3.889311979709324e-25,  4.561755919478791e-12, -1.236237927572116e-12,  1.747101709621700e-13, -1.683638366748236e-14,  1.238831991734827e-15,
 -7.408606856440862e-17,  3.746257114160475e-18, -1.645981063440322e-19,  6.409815166255627e-21, -2.246048999938704e-22,  7.166287068268993e-24, -2.100462796958828e-25,
  1.346166241233071e-12, -3.868180919396587e-13,  5.801994698686740e-14, -5.926646835992307e-15,  4.614979419084359e-16, -2.915905682985189e-17,  1.555313387800859e-18,
 -7.197199898980586e-20,  2.947614254942985e-21, -1.084753105971499e-22,  3.630134667340758e-24, -1.114527901454953e-25,  4.033795979953145e-13, -1.224692798854246e-13,
  1.943607837716701e-14, -2.098492012450357e-15,  1.724698060504892e-16, -1.148447768158165e-17,  6.446303047194901e-19, -3.134695784876934e-20,  1.347263078881824e-21,
 -5.196376602036724e-23,  1.820306411333113e-24, -5.842844065421654e-26,  1.235970927156009e-13, -3.950744848831748e-14,  6.612896820958978e-15, -7.524506343785576e-16,
  6.509176675917921e-17, -4.555955532947759e-18,  2.684412572545110e-19, -1.368472033818070e-20,  6.158118052435328e-22, -2.483859427124817e-23,  9.088656160586191e-25,
 -3.043668753123306e-26,  3.900399554651507e-14, -1.307888311659455e-14,  2.301398662234046e-15, -2.751273870561006e-16,  2.497834488574698e-17, -1.832618554046286e-18,
  1.130484061232023e-19, -6.026315372550393e-21,  2.832431633678058e-22, -1.191920406780591e-23,  4.545282426555886e-25, -1.584597866652850e-26,  1.276985655308813e-14,
 -4.475585304908737e-15,  8.251013331175710e-16, -1.033032563598206e-16,  9.812979610758510e-18, -7.524831367642462e-19,  4.846127388489965e-20, -2.694086973305471e-21,
  1.319120796015428e-22, -5.776818559118241e-24,  2.290263053103985e-25, -8.292347202297894e-27,  4.368906060982231e-15, -1.594507842206519e-15,  3.068978700914718e-16,
 -4.010604184815558e-17,  3.973371932365653e-18, -3.174696885045044e-19,  2.128211116570474e-20, -1.230309062466320e-21,  6.258163406789055e-23, -2.844458248825325e-24,
  1.169355132566861e-25, -4.386036097076293e-27,  1.572738400617250e-15, -5.954762358531073e-16,  1.192221607177035e-16, -1.620532342457526e-17,  1.668787482134088e-18,
 -1.384758410458879e-19,  9.632322796712721e-21, -5.772811792571912e-22,  3.041548654454544e-23, -1.430701428828655e-24,  6.081837507965041e-26, -2.356768130722758e-27,
  5.994037467594742e-16, -2.345426444823213e-16,  4.866259271123375e-17, -6.854641819089002e-18,  7.310995762654230e-19, -6.278885539648203e-20,  4.516825033612853e-21,
 -2.797299272126125e-22,  1.521788316698936e-23, -7.385532186614909e-25,  3.236790562556450e-26, -1.292100663598850e-27,  2.430528602049216e-16, -9.790750394516820e-17,
  2.096840371993300e-17, -3.049125655506565e-18,  3.355770984343356e-19, -2.972036204334429e-20,  2.203260353566177e-21, -1.405176682171255e-22,  7.866928583392678e-24,
 -3.926413279820220e-25,  1.768490984728147e-26, -7.250171939524987e-28,  1.051515177908606e-16, -4.343524542513544e-17,  9.563210380821155e-18, -1.429863477002984e-18,
  1.617473423896183e-19, -1.471629011788819e-20,  1.120103494449931e-21, -7.330138369002884e-23,  4.208388591119167e-24, -2.152681335975388e-25,  9.931351486290633e-27,
 -4.167771034662038e-28,  4.849289686260776e-17, -2.045962685763762e-17,  4.611599141754791e-18, -7.060186726335045e-19,  8.175456063922984e-20, -7.610988258762411e-21,
  5.924608925073261e-22, -3.963285764609141e-23,  2.324782551082227e-24, -1.214376064206567e-25,  5.718420297056156e-27, -2.448129309748964e-28,  2.365460281041635e-17,
 -1.015301503318312e-17,  2.332765823332560e-18, -3.641167662471933e-19,  4.297845728876280e-20, -4.077063379423813e-21,  3.232703538276454e-22, -2.201840972365556e-23,
  1.314498759437411e-24, -6.985579316705873e-26,  3.345210152928059e-27, -1.455761029495116e-28,  1.193253042735163e-17, -5.189519897200612e-18,  1.210073950164742e-18,
 -1.917184494672664e-19,  2.296633730451270e-20, -2.210527382136726e-21,  1.777847129013554e-22, -1.227893437054753e-23,  7.430969589416344e-25, -4.001873046314788e-26,
  1.941451941636000e-27, -8.556361972856223e-29,  5.843057874848516e-18, -2.564466602417419e-18,  6.041459458857077e-19, -9.671876014280412e-20,  1.170611868686453e-20,
 -1.138193944622128e-21,  9.245411086349684e-23, -6.447796735363664e-24,  3.939317560434385e-25, -2.141262636392069e-26,  1.048266716530530e-27, -4.660908636602863e-29,
  2.167347954639772e-18, -9.560700922055865e-19,  2.265280512188300e-19, -3.647639361034216e-20,  4.440300763728273e-21, -4.341828176973260e-22,  3.546425827338839e-23,
 -2.486754207312896e-24,  1.527379986315293e-25, -8.345424493874235e-27,  4.106303747314024e-28, -1.834820308197423e-29,  5.618531530966658e-02, -1.302452331014341e-04,
  3.121525725344098e-07, -7.694968946155548e-10,  1.938801311132055e-12, -4.963271381832255e-15,  1.283977579404341e-17, -3.343661854027642e-20,  8.735689569553589e-23,
 -2.285796495927617e-25,  5.978151529458261e-28, -1.562400220031972e-30,  5.293866465550555e-02, -1.506205997809300e-04,  5.069635169504375e-07, -1.789130358572962e-09,
  6.293437039510512e-12, -2.176393303330168e-14,  7.388112717096143e-17, -2.466222057328470e-19,  8.112291672725902e-22, -2.634464924028615e-24,  8.458935616892731e-27,
 -2.688734383568967e-29,  4.700028008062140e-02, -1.833202892075971e-04,  8.670468526763665e-07, -3.984749118396355e-09,  1.744415792693074e-11, -7.338105932802123e-14,
  2.990544421393067e-16, -1.187375956192275e-18,  4.611014766276953e-21, -1.756432431061466e-23,  6.577567736313551e-26, -2.425904015192031e-28,  3.932419683193659e-02,
 -2.157324679615973e-04,  1.330648379473684e-06, -7.488747953859269e-09,  3.926507852005309e-11, -1.954152901967907e-13,  9.332708201586446e-16, -4.307637656124321e-18,
  1.931358233259288e-20, -8.444019147171331e-23,  3.610805998198158e-25, -1.513790045376028e-27,  3.101230908574069e-02, -2.358562658088837e-04,  1.807108315075573e-06,
 -1.215810195931894e-08,  7.506997493509280e-11, -4.350358119477895e-13,  2.397145531115766e-15, -1.267023201114977e-17,  6.464728736064245e-20, -3.199381755025350e-22,
  1.541499800536341e-24, -7.251988028029185e-27,  2.305872942590903e-02, -2.366399480426175e-04,  2.194038493464781e-06, -1.741540581346253e-08,  1.250967523254285e-10,
 -8.341464960303679e-13,  5.243404278045030e-15, -3.139786179287204e-17,  1.804535722958136e-19, -1.001043701319893e-21,  5.383361853158776e-24, -2.816163962580477e-26,
  1.616987547369730e-02, -2.176959833833443e-04,  2.405969357949564e-06, -2.230824608816751e-08,  1.846026869294433e-10, -1.403355353058517e-12,  9.976836972255644e-15,
 -6.713294136931403e-17,  4.312486776787326e-19, -2.661671768350825e-21,  1.586230030379488e-23, -9.163352924085279e-26,  1.069852004103796e-02, -1.841561277597847e-04,
  2.401517132503648e-06, -2.579135758625194e-08,  2.439056241965611e-10, -2.098356156249337e-12,  1.675601741083876e-14, -1.258778392116558e-16,  8.982214367385378e-19,
 -6.131664066681165e-21,  4.026498543104467e-23, -2.554526729198628e-25,  6.681856596181830e-03, -1.437945815912451e-04,  2.194712059963263e-06, -2.709993503061958e-08,
  2.909216778008046e-10, -2.815186445073911e-12,  2.510714748016111e-14, -2.094531049880640e-16,  1.651785870242826e-18, -1.241091272739257e-20,  8.938382831467655e-23,
 -6.199767479168662e-25,  3.941626356425242e-03, -1.040263067696472e-04,  1.844996935282850e-06, -2.602272316744316e-08,  3.153004500600594e-10, -3.414048297965451e-12,
  3.384270898252224e-14, -3.121039405193028e-16,  2.708534377864890e-18, -2.230788862720763e-20,  1.755131122476417e-22, -1.325897287143082e-24,  2.197596894667925e-03,
 -6.996375150631002e-05,  1.432342594661381e-06, -2.294246098954747e-08,  3.121693243958112e-10, -3.765149899560577e-12,  4.131134351653781e-14, -4.195178759005867e-16,
  3.991606702566493e-18, -3.590996244495537e-20,  3.076052108172874e-22, -2.522684409167013e-24,  1.158908190956901e-03, -4.388027109696593e-05,  1.030456394375911e-06,
 -1.864550353793274e-08,  2.836306513280019e-10, -3.795326168301201e-12,  4.592285071243787e-14, -5.117595576544620e-16,  5.321313228841810e-18, -5.213039281563703e-20,
  4.847482039157887e-22, -4.303493164351679e-24,  5.785775878961187e-04, -2.573627260229470e-05,  6.891329563500635e-07, -1.401885300549548e-08,  2.374407210366161e-10,
 -3.512266016710931e-12,  4.671209474727187e-14, -5.694999402556596e-16,  6.452862610756521e-18, -6.865045659139315e-20,  6.911646731626241e-22, -6.625709048916942e-24,
  2.737302503005787e-04, -1.415223978857640e-05,  4.296679853882332e-07, -9.783247464371169e-09,  1.838111824031620e-10, -2.995800046639724e-12,  4.366372862390703e-14,
 -5.807819824795496e-16,  7.152425626996024e-18, -8.243253351781780e-20,  8.964668615205837e-22, -9.258833000679746e-24,  1.228652365787008e-04, -7.314281822625838e-06,
  2.504523483109036e-07, -6.356625701374984e-09,  1.320276587475297e-10, -2.363744503814625e-12,  3.765190804441329e-14, -5.450202464598258e-16,  7.277985451871569e-18,
 -9.066601185706331e-20,  1.062815393512803e-21, -1.180237589933985e-23,  5.238926024891787e-05, -3.561376795073691e-06,  1.368518468402076e-07, -3.856824951939499e-09,
  8.827165193320756e-11, -1.731134623299388e-12,  3.006053949505929e-14, -4.724395820364260e-16,  6.825939021053783e-18, -9.172707129267235e-20,  1.156769205467621e-21,
 -1.378612595959233e-23,  2.125185971582075e-05, -1.637533928338153e-06,  7.028598899032197e-08, -2.191553319881159e-09,  5.510420084535222e-11, -1.180659825696058e-12,
  2.229687346445734e-14, -3.796448687391119e-16,  5.922945943188895e-18, -8.569465667131756e-20,  1.160541068082258e-21, -1.481822669206251e-23,  8.214998879586105e-06,
 -7.127394130724528e-07,  3.402090892271695e-08, -1.169626633703772e-09,  3.221673598477339e-11, -7.522686438897806e-13,  1.541626261418865e-14, -2.838009995858106e-16,
  4.771991356267527e-18, -7.420423500381960e-20,  1.077373979278378e-21, -1.471462100498019e-23,  3.031634784501976e-06, -2.943854913308891e-07,  1.556231213858273e-08,
 -5.880103055270061e-10,  1.769467522326908e-11, -4.492208020616946e-13,  9.968638720828949e-15, -1.980320626401577e-16,  3.582387212047826e-18, -5.977089641624275e-20,
  9.289101670977330e-22, -1.355034818095218e-23,  1.070300178837759e-06, -1.156851030007031e-07,  6.746646902502107e-09, -2.792980256965776e-10,  9.158472546968421e-12,
 -2.522232632850166e-13,  6.048586860637220e-15, -1.294253187623974e-16,  2.514598963279041e-18, -4.494520254296044e-20,  7.465545857430240e-22, -1.161480026368058e-23,
  3.623279098795356e-07, -4.337248209660261e-08,  2.780232708540395e-09, -1.257330111057423e-10,  4.481469974274057e-12, -1.335927272079043e-13,  3.455407287677746e-15,
 -7.949874427794182e-17,  1.656192549600950e-18, -3.166344223621448e-20,  5.613115511830684e-22, -9.301035687296032e-24,  1.179212000939092e-07, -1.556014840324820e-08,
  1.092502484729853e-09, -5.382072567472741e-11,  2.080137340060582e-12, -6.697905630109128e-14,  1.865016014510071e-15, -4.605653019609774e-17,  1.027191903915324e-18,
 -2.097422286503858e-20,  3.962696866955168e-22, -6.984197072622621e-24,  3.700258272329613e-08, -5.358767077070819e-09,  4.107443790912021e-10, -2.198223260661242e-11,
  9.191164062322752e-13, -3.190133169698393e-14,  9.545016268124599e-16, -2.525805719278215e-17,  6.021327472240001e-19, -1.311233671865579e-20,  2.636617871881674e-22,
 -4.936318514806207e-24,  1.123104093547391e-08, -1.777765798929373e-09,  1.482842851988669e-10, -8.598405638414307e-12,  3.880436292866698e-13, -1.448879156821001e-14,
  4.649783244680331e-16, -1.316273452004675e-17,  3.348878312670278e-19, -7.766282234288300e-21,  1.659780093870910e-22, -3.296655396836168e-24,  3.309081960820092e-09,
 -5.702726284121696e-10,  5.160375104080958e-11, -3.233729783840853e-12,  1.571641880866011e-13, -6.300127812344598e-15,  2.164689579807927e-16, -6.544505478234947e-18,
  1.774273480937183e-19, -4.375546065160018e-21,  9.925376978850659e-23, -2.088681253784940e-24,  9.501946782046520e-10, -1.776136407834123e-10,  1.738422185437099e-11,
 -1.174285482133606e-12,  6.132572582341047e-14, -2.633998934759244e-15,  9.672055745634967e-17, -3.117749049969251e-18,  8.992886011800874e-20, -2.354907641637887e-21,
  5.661946845215535e-23, -1.260725623095171e-24,  2.670739486464070e-10, -5.395169752404427e-11,  5.694994333344286e-12, -4.136328713168414e-13,  2.315988318563938e-14,
 -1.063688924382853e-15,  4.166558609311625e-17, -1.429563861022094e-18,  4.380131688143162e-20, -1.216121941502900e-21,  3.094798566557692e-23, -7.281660237292094e-25,
  7.383291170759441e-11, -1.606174065497174e-11,  1.823205282402919e-12, -1.420268600424090e-13,  8.506894246454424e-15, -4.169376499726965e-16,  1.738925769121822e-17,
 -6.339511966126427e-19,  2.059954818110784e-20, -6.054736315604151e-22,  1.628470866687238e-23, -4.043101186189219e-25,  2.018145146911077e-11, -4.711377276932670e-12,
  5.734522592110642e-13, -4.779132297175350e-14,  3.055214271143320e-15, -1.594633291434189e-16,  7.067776426506862e-18, -2.732919462485992e-19,  9.401861036201112e-21,
 -2.920821091013481e-22,  8.290078364912293e-24, -2.168684706819311e-25,  5.485655274597760e-12, -1.369536041469336e-12,  1.782283640256549e-13, -1.585017921422458e-14,
  1.078970486295805e-15, -5.984367275594294e-17,  2.813114542334483e-18, -1.151567807735291e-19,  4.186929749554293e-21, -1.372502016738988e-22,  4.104321794240676e-24,
 -1.129575753088960e-25,  1.492025065248885e-12, -3.969806231804842e-13,  5.507570681657431e-14, -5.212999980423611e-15,  3.769694001257482e-16, -2.216868884040765e-17,
  1.102945495667388e-18, -4.770499439117066e-20,  1.829713273909863e-21, -6.317692878511711e-23,  1.987132077638765e-24, -5.744197298520635e-26,  4.087877812460639e-13,
 -1.155130437103093e-13,  1.703408593879131e-14, -1.711387873854523e-15,  1.311387541963798e-16, -8.157987592003545e-18,  4.286415334721903e-19, -1.954854695166899e-20,
  7.893922263464073e-22, -2.865565740029406e-23,  9.463144172784260e-25, -2.868213895897959e-26,  1.136293518021999e-13, -3.398132499594987e-14,  5.310086611588013e-15,
 -5.647065898466805e-16,  4.573444090953485e-17, -3.002307412232201e-18,  1.662120295409121e-19, -7.975191827599735e-21,  3.383525276545789e-22, -1.288716330668264e-23,
  4.459651039097026e-25, -1.414621769340162e-26,  3.228665882971765e-14, -1.018227439076381e-14,  1.680792299085100e-15, -1.886539030258242e-16,  1.610430082026759e-17,
 -1.112745476769368e-18,  6.474955146934178e-20, -3.261064589529295e-21,  1.450324960288063e-22, -5.783474533425667e-24,  2.092905629101916e-25, -6.933944249450749e-27,
  9.451519853575015e-15, -3.132015877510007e-15,  5.443591655155925e-16, -6.429060018944584e-17,  5.768096767617871e-18, -4.183538371454449e-19,  2.552035607094524e-20,
 -1.345763377495933e-21,  6.259065598878567e-23, -2.607134654108050e-24,  9.843973280335815e-26, -3.399000583157474e-27,  2.873524257846136e-15, -9.968648908740097e-16,
  1.818098112072676e-16, -2.252175990979130e-17,  2.117278237760967e-18, -1.607262211697638e-19,  1.024999761475274e-20, -5.644211265321528e-22,  2.738159670010959e-23,
 -1.188395139301786e-24,  4.670530967096012e-26, -1.676797555134757e-27,  9.146497260356857e-16, -3.309340956593254e-16,  6.311110487512135e-17, -8.172468049824788e-18,
  8.024581920968321e-19, -6.356056980191225e-20,  4.225012926704528e-21, -2.422477491005043e-22,  1.222436353766089e-23, -5.513292242137811e-25,  2.249493044791894e-26,
 -8.375967294492988e-28,  3.071869061288386e-16, -1.154749156614824e-16,  2.294199438925923e-17, -3.094579218582442e-18,  3.162885072533038e-19, -2.605419426803703e-20,
  1.799460249070477e-21, -1.071006975680411e-22,  5.605025597598415e-24, -2.619338073880849e-25,  1.106410087681721e-26, -4.261075205617136e-28,  1.096386153331080e-16,
 -4.265275095357078e-17,  8.794175548164845e-18, -1.231024462349186e-18,  1.304945781492866e-19, -1.114031642031257e-20,  7.967388529068583e-22, -4.906349531617691e-23,
  2.654474493867444e-24, -1.281377361721148e-25,  5.586566324435987e-27, -2.218855835088837e-28,  4.183297791971975e-17, -1.677529248299786e-17,  3.575003972821557e-18,
 -5.173011153493293e-19,  5.665721757243400e-20, -4.994145437504695e-21,  3.685275490025261e-22, -2.339837181239496e-23,  1.304257586216667e-24, -6.482004729649051e-26,
  2.907512751222413e-27, -1.187204714048586e-28,  1.712901943993088e-17, -7.051677400767219e-18,  1.546823375295789e-18, -2.304168295546114e-19,  2.596963034374555e-20,
 -2.354353953465218e-21,  1.785727910147485e-22, -1.164642635502027e-23,  6.664369947969903e-25, -3.398007808719830e-26,  1.562758902025908e-27, -6.538324936412532e-29,
  7.527637469642786e-18, -3.168420892855820e-18,  7.122785529757917e-19, -1.087581616043489e-19,  1.256094380957055e-20, -1.166381003428975e-21,  9.056807823095715e-23,
 -6.043862866041982e-24,  3.536819453515970e-25, -1.843241451070615e-26,  8.660243280388743e-28, -3.699489046055866e-29,  3.526445976810163e-18, -1.511262390765555e-18,
  3.466264281352900e-19, -5.400964323365410e-20,  6.364024926474089e-21, -6.026904370654140e-22,  4.770849022187792e-23, -3.244265812188462e-24,  1.933789051890195e-25,
 -1.026094333942068e-26,  4.906381992525557e-28, -2.132060958698872e-29,  1.723213839601864e-18, -7.487505745516009e-19,  1.744123639051681e-19, -2.760452192690215e-20,
  3.303424106910250e-21, -3.176385499958763e-22,  2.552148954310467e-23, -1.760988647909142e-24,  1.064720637661982e-25, -5.728721860900364e-27,  2.776739039169142e-28,
 -1.222706368476008e-29,  8.250451984206536e-19, -3.619385728635783e-19,  8.522254050261658e-20, -1.363625407771067e-20,  1.649571146884388e-21, -1.603067577703376e-22,
  1.301498024847850e-23, -9.072247401537965e-25,  5.540071807429363e-26, -3.009953371875405e-27,  1.472860313300838e-28, -6.545838454555624e-30,  3.021772868925890e-19,
 -1.332703971167455e-19,  3.156926841142161e-20, -5.082190320398727e-21,  6.185120521722293e-22, -6.046529611797879e-23,  4.937686887729687e-24, -3.461514215379157e-25,
  2.125604600047865e-26, -1.161147783067549e-27,  5.712094248669783e-29, -2.551789656271497e-30,  5.566927107134584e-02, -1.277844284550953e-04,  3.031015123447110e-07,
 -7.392537667201988e-10,  1.842543196285789e-12, -4.666043025808660e-15,  1.194148143263836e-17, -3.076837572404837e-20,  7.954239740379303e-23, -2.059863145359306e-25,
  5.331835810595312e-28, -1.379462825785147e-30,  5.234416007258518e-02, -1.466490905543664e-04,  4.860840641909385e-07, -1.691823550404171e-09,  5.875345306905156e-12,
 -2.007080299176742e-14,  6.732533087372065e-17, -2.221172655923595e-19,  7.222042910145700e-22, -2.318619515483453e-24,  7.360657050248876e-27, -2.313434312610027e-29,
  4.628057538712634e-02, -1.765705465934613e-04,  8.208573039435237e-07, -3.717004605218493e-09,  1.604570059364071e-11, -6.658660421716599e-14,  2.677820947912301e-16,
 -1.049452901904844e-18,  4.023594460418396e-21, -1.513487628315905e-23,  5.597807711105728e-26, -2.039381325085928e-28,  3.848200288521275e-02, -2.054363500494214e-04,
  1.244427710507527e-06, -6.890595946084492e-09,  3.557133735657968e-11, -1.743970311404435e-13,  8.208716047428510e-16, -3.735578227787533e-18,  1.651842981538405e-20,
 -7.124552028902278e-23,  3.006176239189613e-25, -1.243842478554275e-27,  3.009690171972803e-02, -2.219632106771870e-04,  1.668140491321318e-06, -1.102357875964695e-08,
  6.691700200591844e-11, -3.815379844719565e-13,  2.069690877297694e-15, -1.077449983749868e-17,  5.416658988313453e-20, -2.642148643703214e-22,  1.255066648668446e-24,
 -5.822640625578881e-27,  2.214599709851875e-02, -2.198907781756129e-04,  1.996533734015951e-06, -1.554077139681654e-08,  1.096042653183791e-10, -7.182338255157623e-13,
  4.439972536450683e-15, -2.616069655320682e-17,  1.480109401741029e-19, -8.085874812456394e-22,  4.283680271176917e-24, -2.208195365092913e-26,  1.533595980103125e-02,
 -1.994708640403470e-04,  2.155106509347409e-06, -1.956674230104616e-08,  1.587854620332044e-10, -1.184992886073700e-12,  8.276738487546325e-15, -5.475112138717877e-17,
  3.459402059767041e-19, -2.101038999954537e-21,  1.232584397957831e-23, -7.011656676659541e-26,  9.998449287434551e-03, -1.661186867994060e-04,  2.114118504591931e-06,
 -2.220389716687430e-08,  2.056904135411764e-10, -1.735452094716180e-12,  1.360275163125079e-14, -1.003764712057446e-16,  7.039534191800123e-19, -4.725302307027821e-21,
  3.052485383058374e-23, -1.905783210401353e-25,  6.139840396376330e-03, -1.274626271531004e-04,  1.895684149521948e-06, -2.286476988657428e-08,  2.401978271254500e-10,
 -2.277407716236790e-12,  1.991991981877165e-14, -1.631046383190277e-16,  1.263274976999566e-18, -9.327091459159558e-21,  6.603925717341211e-23, -4.505032112661363e-25,
  3.553177930968484e-03, -9.043457698223789e-05,  1.560875066115370e-06, -2.148283687373142e-08,  2.544815184600626e-10, -2.697592434667504e-12,  2.620552906882799e-14,
 -2.370316610319983e-16,  2.018914762359707e-18, -1.632944679365089e-20,  1.262325083093383e-22, -9.373763174280433e-25,  1.939028488676495e-03, -5.952673068256477e-05,
  1.184680498948295e-06, -1.850005442813878e-08,  2.458994012921131e-10, -2.901316700490734e-12,  3.117448911864406e-14, -3.102972670632800e-16,  2.895938665751840e-18,
 -2.557059370629838e-20,  2.150990579131724e-22, -1.733143814767374e-24,  9.985591211307907e-04, -3.645985926713348e-05,  8.316154328234236e-07, -1.465932863695514e-08,
  2.176774869442473e-10, -2.847495995425239e-12,  3.372008004087769e-14, -3.681039251447243e-16,  3.752335114956831e-18, -3.606097714392943e-20,  3.291357033572008e-22,
 -2.869544277856383e-24,  4.856777982244344e-04, -2.083649822715018e-05,  5.415663823127024e-07, -1.072588078012708e-08,  1.772262301315099e-10, -2.561300220420056e-12,
  3.332041753000657e-14, -3.977378709690170e-16,  4.415965549323077e-18, -4.606650847484214e-20,  4.550434133691763e-22, -4.282184083440739e-24,  2.233174666400799e-04,
 -1.113870451435145e-05,  3.281080376966881e-07, -7.269755621960007e-09,  1.331801329563827e-10, -2.119663134621635e-12,  3.020507391588814e-14, -3.931905615731640e-16,
  4.742786111729259e-18, -5.357704849232233e-20,  5.714597740528824e-22, -5.791903522467039e-24,  9.717857753841334e-05, -5.583167414048239e-06,  1.854333493100276e-07,
 -4.578035240897973e-09,  9.267732625697325e-11, -1.619654221089122e-12,  2.521428832602592e-14, -3.570625224229368e-16,  4.668559890381138e-18, -5.698689906198997e-20,
  6.549787373498328e-22, -7.135570386597682e-24,  4.007098662030085e-05, -2.630077033062092e-06,  9.801715340223874e-08, -2.686350832528213e-09,  5.990768605822615e-11,
 -1.146497827766433e-12,  1.945121880284879e-14, -2.989803847198817e-16,  4.228434004241992e-18, -5.566225741896756e-20,  6.880867468403710e-22, -8.043223494982116e-24,
  1.567875354313183e-05, -1.167074433391803e-06,  4.858327743377566e-08, -1.472979045421599e-09,  3.608088352135521e-11, -7.542373855942522e-13,  1.391368980667920e-14,
 -2.316494017258829e-16,  3.536914822935126e-18, -5.011915723617824e-20,  6.652209492825293e-22, -8.329538832303262e-24,  5.830497375109881e-06, -4.889763639279804e-07,
  2.264011852834081e-08, -7.568392950770278e-10,  2.030730001981609e-11, -4.625795511616409e-13,  9.258776872755949e-15, -1.666434086191567e-16,  2.741905162695176e-18,
 -4.175346328337513e-20,  5.940689838429286e-22, -7.955988957829642e-24,  2.064391551192924e-06, -1.939053931342051e-07,  9.945858024796907e-09, -3.654470910191773e-10,
  1.071295491180548e-11, -2.653163782966070e-13,  5.750245382432882e-15, -1.116777262678877e-16,  1.976794445531744e-18, -3.229754798763466e-20,  4.918598960884096e-22,
 -7.035206278084441e-24,  6.973486767547632e-07, -7.296477779436870e-08,  4.130354985839050e-09, -1.663166726216652e-10,  5.313457833265034e-12, -1.427626320072697e-13,
  3.343912511528374e-15, -6.995502638888296e-17,  1.329966644951566e-18, -2.327871180895038e-20,  3.789114102602496e-22, -5.780431920497609e-24,  2.252519262252261e-07,
 -2.612399429931278e-08,  1.626246944527245e-09, -7.155967043626654e-11,  2.485597849467887e-12, -7.230183864536869e-14,  1.826851348046882e-15, -4.109786668610997e-17,
  8.379007739949374e-19, -1.568882282832117e-20,  2.725722947928970e-22, -4.429208284150800e-24,  6.975235721556632e-08, -8.925667216409946e-09,  6.089639195388354e-10,
 -2.920279776063150e-11,  1.100294515376971e-12, -3.458091450591321e-14,  9.408588096467991e-16, -2.272393073988198e-17,  4.960825454001589e-19, -9.922490715009850e-21,
  1.837594230448714e-22, -3.176646841327329e-24,  2.076668501473679e-08, -2.919415164037564e-09,  2.175960932097275e-10, -1.134214401727721e-11,  4.625213533898595e-13,
 -1.567539482283238e-14,  4.584367057397105e-16, -1.186828459951626e-17,  2.770228075126980e-19, -5.910903845160638e-21,  1.165353952126665e-22, -2.140509557344559e-24,
  5.963317680053170e-09, -9.172946838734968e-10,  7.446072133385519e-11, -4.208013868392605e-12,  1.853183448582792e-13, -6.759738322741622e-15,  2.121358136751687e-16,
 -5.877435529731543e-18,  1.464670928778622e-19, -3.329349200793347e-21,  6.978818330053159e-23, -1.360353766382182e-24,  1.657595666431697e-09, -2.779234397992225e-10,
  2.449700203711236e-11, -1.497235161492651e-12,  7.105646439487761e-14, -2.784288049464572e-15,  9.360017782658978e-17, -2.770984903849444e-18,  7.361725360022600e-20,
 -1.780284309634195e-21,  3.962540762001599e-23, -8.186990988388571e-25,  4.477897271483330e-10, -8.153589805885006e-11,  7.781243116489296e-12, -5.130892838630517e-13,
  2.618511987320704e-14, -1.100120971077255e-15,  3.954892954666548e-17, -1.249079460116983e-18,  3.532580068152638e-20, -9.076022136893952e-22,  2.142290251028995e-23,
 -4.685677657984733e-25,  1.180869337460511e-10, -2.326801587603707e-11,  2.397401214426855e-12, -1.701379890938602e-13,  9.317238770527896e-15, -4.189087554065294e-16,
  1.607645167402619e-17, -5.408125929275829e-19,  1.625759708540656e-20, -4.431432383091337e-22,  1.107767425250467e-23, -2.561743687538395e-25,  3.054890746190263e-11,
 -6.491233834097390e-12,  7.200686615743987e-13, -5.486585374807569e-14,  3.217224656397696e-15, -1.544964150083587e-16,  6.318216278455868e-18, -2.260153319105419e-19,
  7.210861207462156e-21, -2.082235722570340e-22,  5.505025734160370e-24, -1.344215027503534e-25,  7.794873723561552e-12, -1.780035596838302e-12,  2.119966981287449e-13,
 -1.730088523584726e-14,  1.083913136922793e-15, -5.548485766402196e-17,  2.413578180132213e-18, -9.165410669323909e-20,  3.098464972759712e-21, -9.464293692935930e-23,
  2.642523686749694e-24, -6.803820167812453e-26,  1.973447577021494e-12, -4.826776192013323e-13,  6.154510279027485e-14, -5.366239480070340e-15,  3.584038999079041e-16,
 -1.951665726068389e-17,  9.013166317368946e-19, -3.626957423037769e-20,  1.297043003655075e-21, -4.184122180603219e-23,  1.231907241924065e-24, -3.339676355276125e-26,
  4.989599292078514e-13, -1.302661678772789e-13,  1.773246612882469e-14, -1.647717372628547e-15,  1.170465515088397e-16, -6.765763293519236e-18,  3.310613685460993e-19,
 -1.409075902896766e-20,  5.321002886490835e-22, -1.809752230812395e-23,  5.609643828691846e-25, -1.598748189031414e-26,  1.268784602713937e-13, -3.523700575160691e-14,
  5.105936648791085e-15, -5.043004256302171e-16,  3.800957349900646e-17, -2.327038259756940e-18,  1.203930737548858e-19, -5.409099296175520e-21,  2.152836138847957e-22,
 -7.706002167650351e-24,  2.510366389233561e-25, -7.508902645920942e-27,  3.269507072472090e-14, -9.625617957584824e-15,  1.480280340894022e-15, -1.549798348504621e-16,
  1.236259093211242e-17, -7.997315473561845e-19,  4.364936115449760e-20, -2.065748333773245e-21,  8.647912814211010e-23, -3.251472232049291e-24,  1.111144745415893e-25,
 -3.481952963740148e-27,  8.607013943807461e-15, -2.676677487321013e-15,  4.355145621525072e-16, -4.819611529161137e-17,  4.058061966133249e-18, -2.766847085307514e-19,
  1.589343520758159e-20, -7.905052369462791e-22,  3.473281787729029e-23, -1.368831836946333e-24,  4.897192652498600e-26, -1.604592133296947e-27,  2.334443490615713e-15,
 -7.641028841550802e-16,  1.311128302805034e-16, -1.529071524660295e-17,  1.355120445837669e-18, -9.712034932136478e-20,  5.856389990017414e-21, -3.053795441747803e-22,
  1.404927967908073e-23, -5.790558461318056e-25,  2.164077472296357e-26, -7.398330811965096e-28,  6.580942875516619e-16, -2.258762187429695e-16,  4.073621665078654e-17,
 -4.990649073373997e-18,  4.641327769182416e-19, -3.486521466343199e-20,  2.200917556475900e-21, -1.200018620965387e-22,  5.765993956788974e-24, -2.479294284882141e-25,
  9.656092857732704e-27, -3.436390007339532e-28,  1.945489152125157e-16, -6.975452985367333e-17,  1.317519335183021e-17, -1.689915229847710e-18,  1.643952892351385e-19,
 -1.290384175176564e-20,  8.502277243264315e-22, -4.833404679704219e-23,  2.418872548381491e-24, -1.082167517243427e-25,  4.380911060114117e-27, -1.618875931471556e-28,
  6.084138532256854e-17, -2.269907771676828e-17,  4.473490637259581e-18, -5.985971753431531e-19,  6.070273115218803e-20, -4.962293468760495e-21,  3.401877353999293e-22,
 -2.010163656410501e-23,  1.044644424868591e-24, -4.848646678919980e-26,  2.034541500713450e-27, -7.785339785637460e-29,  2.029329686303577e-17, -7.846731341276772e-18,
  1.607230476533232e-18, -2.235121690667682e-19,  2.354152380745979e-20, -1.997177516302928e-21,  1.419663096021580e-22, -8.690629123421770e-24,  4.674839464987400e-25,
 -2.244040235258719e-26,  9.730425539104572e-28, -3.844325711624797e-29,  7.270189715499128e-18, -2.901545873807184e-18,  6.151536446293314e-19, -8.855230074689651e-20,
  9.649439131910128e-21, -8.463523249386289e-22,  6.215262991720403e-23, -3.927639760689060e-24,  2.179325060147889e-25, -1.078289725671953e-26,  4.815800774950793e-28,
 -1.958165425455337e-29,  2.811447523964061e-18, -1.153303298989332e-18,  2.519959747283015e-19, -3.739086807635359e-20,  4.198017203657290e-21, -3.791540330009641e-22,
  2.865274575615487e-23, -1.862056853562362e-24,  1.061819114807159e-25, -5.395703173891270e-27,  2.473363054718251e-28, -1.031518450839587e-29,  1.175010144746534e-18,
 -4.933250850356691e-19,  1.105939666465855e-19, -1.683950357257122e-20,  1.939520242564543e-21, -1.796153231610854e-22,  1.391034328332993e-23, -9.259053195987465e-25,
  5.404848900081048e-26, -2.809962225140842e-27,  1.317116356609051e-28, -5.613603381026524e-30,  5.276879691120958e-19, -2.257696583779143e-19,  5.168826633238178e-20,
 -8.038976293919354e-21,  9.455221059630863e-22, -8.938425105003166e-23,  7.063299901811803e-24, -4.795044201707651e-25,  2.853437960602581e-26, -1.511640250255071e-27,
  7.216765641309781e-29, -3.131270595129141e-30,  2.494115430440062e-19, -1.082670688125792e-19,  2.519231380987977e-20, -3.982888902527386e-21,  4.761187257143827e-22,
 -4.573262943603861e-23,  3.670720265351660e-24, -2.530257935455095e-25,  1.528331596266526e-26, -8.215309499061597e-28,  3.978285277375361e-29, -1.750205230930486e-30,
  1.166303383578886e-19, -5.113979579811340e-20,  1.203489520457127e-20, -1.924613656793616e-21,  2.326924990915620e-22, -2.260111980234130e-23,  1.833973387737579e-24,
 -1.277734517500363e-25,  7.798700804979734e-27, -4.234992288618397e-28,  2.071310476935980e-29, -9.201211425926759e-31,  4.215196192974965e-20, -1.858647920927227e-20,
  4.401723893580111e-21, -7.084381507912512e-22,  8.619701172948751e-23, -8.424504234645910e-24,  6.877922290383171e-25, -4.820553981755554e-26,  2.959457083627947e-27,
 -1.616283106022713e-28,  7.949271015520030e-30, -3.550428067535021e-31,  5.516292749674823e-02, -1.253946063580414e-04,  2.944043213552539e-07, -7.105043585985224e-10,
  1.752019966576070e-12, -4.389504728010510e-15,  1.111451578176227e-17, -2.833766672719092e-20,  7.249660015138503e-23, -1.858242559390780e-25,  4.760841700251716e-28,
 -1.219484547037866e-30,  5.176521469342157e-02, -1.428400574248859e-04,  4.663332467210470e-07, -1.600943630281727e-09,  5.489596741031187e-12, -1.852709010447919e-14,
  6.141744048159073e-17, -2.002873606169687e-19,  6.437973167577327e-22, -2.043573530487802e-24,  6.414909628396561e-27, -1.993834475143101e-29,  4.558715045617361e-02,
 -1.701778389439508e-04,  7.777507932086634e-07, -3.470587799875183e-09,  1.477592916432204e-11, -6.049838921921124e-14,  2.401210562429770e-16, -9.290003684836016e-19,
  3.516971395789627e-21, -1.306532961912697e-23,  4.773318267544941e-26, -1.718017556172011e-28,  3.767965796154332e-02, -1.958022598683722e-04,  1.165043678214276e-06,
 -6.348322174427333e-09,  3.227223256103750e-11, -1.558938257809579e-13,  7.233060365000411e-16, -3.245808049482488e-18,  1.415746978020828e-20, -6.024755974859777e-23,
  2.508759922803886e-25, -1.024610428279719e-27,  2.923492628590475e-02, -2.091295800011640e-04,  1.542038233680310e-06, -1.001135308679076e-08,  5.975950775390371e-11,
 -3.352982234160419e-13,  1.790907865826839e-15, -9.184147236159083e-18,  4.550000617310942e-20, -2.187833791323689e-22,  1.024757210014939e-24, -4.688963401168449e-27,
  2.129723812155266e-02, -2.046357082688471e-04,  1.820110548802525e-06, -1.389647059366100e-08,  9.624850580774907e-11, -6.199550310291175e-13,  3.769631069322732e-15,
 -2.185883340618736e-17,  1.217654547097824e-19, -6.551995426985465e-22,  3.419962176689857e-24, -1.737496002527909e-26,  1.457112966077561e-02, -1.831277595183661e-04,
  1.934800499831339e-06, -1.720548049127569e-08,  1.369540262873343e-10, -1.003563249891561e-12,  6.887962486835807e-15, -4.480179952572723e-17,  2.784810683949616e-19,
 -1.664593730065521e-21,  9.614619680643273e-24, -5.386662892321171e-26,  9.366188586996003e-03, -1.502181052438127e-04,  1.866327572949673e-06, -1.917369661822062e-08,
  1.740308961040669e-10, -1.440316200519081e-12,  1.108359790314990e-14, -8.035155978764083e-17,  5.539391488467035e-19, -3.656899640314992e-21,  2.324253470899040e-23,
 -1.428267048346555e-25,  5.658670987253064e-03, -1.133326293891412e-04,  1.642942901772701e-06, -1.936148868596037e-08,  1.990828871647769e-10, -1.849857741415711e-12,
  1.587188090458679e-14, -1.275788177766951e-16,  9.706285360339305e-19, -7.043274496979867e-21,  4.903465188028669e-23, -3.290388282055507e-25,  3.214873510036189e-03,
 -7.891342267027993e-05,  1.325835666541385e-06, -1.781070718634760e-08,  2.063169541610156e-10, -2.141512218589682e-12,  2.039124842564977e-14, -1.809329689935438e-16,
  1.512805875506258e-18, -1.201821613060915e-20,  9.129758395505732e-23, -6.665191040153686e-25,  1.718559376604801e-03, -5.087456449435304e-05,  9.844953597793724e-07,
 -1.499199911566401e-08,  1.947019052289779e-10, -2.247711834635270e-12,  2.365618591908533e-14, -2.308338526336304e-16,  2.113489714366462e-18, -1.831924815873831e-20,
  1.513537287127683e-22, -1.198345717509081e-24,  8.649896435519271e-04, -3.045543427745626e-05,  6.748545949007250e-07, -1.159139197436885e-08,  1.680508721416112e-10,
 -2.149442998496526e-12,  2.491583323832115e-14, -2.664874479245432e-16,  2.663530688362617e-18, -2.511456662014922e-20,  2.250303325468414e-22, -1.926969865929783e-24,
  4.102449565076893e-04, -1.697423249374824e-05,  4.283101234904330e-07, -8.260136948082947e-09,  1.331715091087705e-10, -1.880697312004786e-12,  2.393585875288967e-14,
 -2.797866528206263e-16,  3.044333184140227e-18, -3.114469897114311e-20,  3.018854870637810e-22, -2.789170288804764e-24,  1.835070702180033e-04, -8.829546882478410e-06,
  2.523753397850396e-07, -5.442088174858859e-09,  9.722593934439108e-11, -1.511339456253728e-12,  2.105933033603363e-14, -2.683248800378678e-16,  3.170601808263751e-18,
 -3.511111709780114e-20,  3.673485145850187e-22, -3.654103069922769e-24,  7.749750298424118e-05, -4.296502059255943e-06,  1.384228767174942e-07, -3.324581396389526e-09,
  6.560566779353732e-11, -1.119331755609060e-12,  1.703241778577852e-14, -2.359933033232928e-16,  3.021556796209472e-18, -3.614365803981742e-20,  4.073537739575531e-22,
 -4.354214075725271e-24,  3.093568884204050e-05, -1.960180731971374e-06,  7.085039155651406e-08, -1.888496301658358e-09,  4.103973865880941e-11, -7.665134437580965e-13,
  1.270706775552574e-14, -1.910432407739932e-16,  2.645041372837142e-18, -3.411157999252182e-20,  4.133880882536935e-22, -4.739966762051292e-24,  1.168832157722706e-05,
 -8.403358550097577e-07,  3.392675349606107e-08, -1.000214323264892e-09,  2.386967944459011e-11, -4.868534242637721e-13,  8.773638344397546e-15, -1.428422915015269e-16,
  2.134598674184668e-18, -2.962721415307215e-20,  3.854248525138089e-22, -4.733084632642868e-24,  4.186275024642614e-06, -3.392920058042429e-07,  1.523741322880199e-08,
 -4.952861475647169e-10,  1.294576195202505e-11, -2.876867868639131e-13,  5.624279283994814e-15, -9.897411024575007e-17,  1.593623433385417e-18, -2.376611349226360e-20,
  3.313829572186460e-22, -4.351936242914382e-24,  1.423767309630029e-06, -1.293254304399674e-07,  6.435493906093794e-09, -2.299392181838088e-10,  6.566234599184371e-12,
 -1.586383379002724e-13,  3.358002098470084e-15, -6.376005072652135e-17,  1.104358586244322e-18, -1.766925949602607e-20,  2.636864607521667e-22, -3.698209297382116e-24,
  4.607214857955766e-07, -4.665153374775971e-08,  2.562917088443048e-09, -1.003713356622147e-10,  3.123999347701209e-12, -8.188535753946704e-14,  1.873297938017233e-15,
 -3.831440033344146e-17,  7.127727916772531e-19, -1.221713513044508e-20,  1.948704843533591e-22, -2.915002480194976e-24,  1.421643083298107e-07, -1.596896422825338e-08,
  9.651946584282403e-10, -4.131893926454576e-11,  1.398485948895564e-12, -3.969156198363429e-14,  9.796295632628322e-16, -2.154815685302230e-17,  4.299189879010396e-19,
 -7.883473258839294e-21,  1.342266628953619e-22, -2.138875769479550e-24,  4.193578309001052e-08, -5.201958324928807e-09,  3.447876867732823e-10, -1.609198841442366e-11,
  5.909796716449355e-13, -1.812709609034728e-14,  4.818548047271583e-16, -1.138116485358326e-17,  2.431826574331394e-19, -4.764311345473346e-21,  8.648157231266534e-23,
 -1.466252324695035e-24,  1.185903998578824e-08, -1.617701867863626e-09,  1.172128369209281e-10, -5.949263077286360e-12,  2.365675990515036e-13, -7.827444738897165e-15,
  2.237238492606323e-16, -5.665665604832792e-18,  1.294682987663481e-19, -2.706485691934455e-21,  5.231218634927864e-23, -9.425925145003627e-25,  3.225283261339462e-09,
 -4.819080745243403e-10,  3.805705152869434e-11, -2.095527842838435e-12,  9.003519437428380e-14, -3.207711559282506e-15,  9.842015596860474e-17, -2.668373512992749e-18,
  6.512257332324203e-20, -1.450756549876689e-21,  2.982249676390574e-23, -5.704340234508573e-25,  8.466296570245297e-10, -1.380403473730252e-10,  1.184732596386250e-11,
 -7.060170967752747e-13,  3.270946609745137e-14, -1.252543575503430e-15,  4.118846161629011e-17, -1.193771182644453e-18,  3.107321800974549e-20, -7.367447214789497e-22,
  1.608785583315501e-23, -3.262906000389747e-25,  2.153614861890986e-10, -3.817989936824766e-11,  3.551219279619474e-12, -2.285036122375425e-13,  1.139228957328718e-14,
 -4.680442058647710e-16,  1.646871207478620e-17, -5.094993295550322e-19,  1.412511566068043e-20, -3.559854994410836e-22,  8.247429828745915e-24, -1.771611763931480e-25,
  5.332596972998552e-11, -1.024352230581138e-11,  1.029747190820404e-12, -7.137733693830844e-14,  3.821716573719104e-15, -1.681533736439657e-16,  6.320564556969526e-18,
 -2.084122859470288e-19,  6.145346368980792e-21, -1.644089885693364e-22,  4.036249433499871e-24, -9.171856162175792e-26,  1.291742575477273e-11, -2.679512235320015e-12,
  2.903353899729710e-13, -2.162906406059628e-14,  1.241162503190620e-15, -5.837795134915503e-17,  2.340173966919301e-18, -8.211570520778904e-20,  2.571558728566636e-21,
 -7.293307307674186e-23,  1.894891557872432e-24, -4.549450838700989e-26,  3.078150643457979e-12, -6.872034883512759e-13,  8.004237614763727e-14, -6.393677806926433e-15,
  3.924014999995661e-16, -1.969267713707251e-17,  8.404282804976754e-19, -3.133220593902010e-20,  1.040529421804800e-21, -3.124023721652838e-23,  8.578192613949728e-25,
 -2.173225653165853e-26,  7.260146253882518e-13, -1.738644049553394e-13,  2.170976080622450e-14, -1.855005460415040e-15,  1.215024120586220e-16, -6.493278751995241e-18,
  2.944908969956671e-19, -1.164507283604502e-20,  4.094587499872837e-22, -1.299421586469912e-23,  3.765584851982474e-25, -1.005264066810335e-26,  1.706371665322510e-13,
 -4.368759219281911e-14,  5.831928246515912e-15, -5.317398653732978e-16,  3.708810018403725e-17, -2.106352829118034e-18,  1.013269628139875e-19, -4.242292686909404e-21,
  1.576671802117948e-22, -5.280388115176843e-24,  1.612445641265267e-25, -4.529318316445202e-27,  4.026041671506797e-14, -1.098285532327139e-14,  1.562961365243649e-15,
 -1.516806880999337e-16,  1.123963515592046e-17, -6.769085507556458e-19,  3.446938486437431e-20, -1.525063345720161e-21,  5.980220078348516e-23, -2.109981556867600e-24,
  6.778267380040220e-26, -2.000213358425873e-27,  9.612440695488527e-15, -2.784392904272653e-15,  4.211818129386769e-16, -4.339048357415123e-17,  3.407520565957602e-18,
 -2.171214970736133e-19,  1.167828547709347e-20, -5.449093185753788e-22,  2.250071122696929e-23, -8.348055936288985e-25,  2.816234927790612e-26, -8.715367900756629e-28,
  2.342459793130650e-15, -7.179619913625803e-16,  1.150855476130396e-16, -1.255090681174879e-17,  1.041863058383077e-18, -7.006447647880278e-20,  3.971361095794560e-21,
 -1.949916420139150e-22,  8.460836724895055e-24, -3.294196042058484e-25,  1.164738705626195e-26, -3.772977919932042e-28,  5.879702816296776e-16, -1.899974708104683e-16,
  3.217050706423545e-17, -3.703021167608533e-18,  3.240231384964957e-19, -2.293734416470657e-20,  1.366663338526683e-21, -7.044155146491349e-23,  3.204444443412904e-24,
 -1.306394677551723e-25,  4.830820849896013e-27, -1.634618578053186e-28,  1.534704105030113e-16, -5.209107837161569e-17,  9.285414248619622e-18, -1.124541899294456e-18,
  1.034154618446628e-19, -7.684221161887379e-21,  4.799721962554309e-22, -2.590253671666587e-23,  1.232261548860377e-24, -5.247570494252745e-26,  2.024672884938939e-27,
 -7.140080967356467e-29,  4.206510470631389e-17, -1.493958705176825e-17,  2.793569198700548e-18, -3.547725680608173e-19,  3.417896909529217e-20, -2.657596276449467e-21,
  1.735097363646931e-22, -9.776349661556631e-24,  4.850476980080565e-25, -2.151903066252823e-26,  8.640801744839136e-28, -3.167904122168425e-29,  1.222561847037772e-17,
 -4.525260321915004e-18,  8.843277978831098e-19, -1.173438318344299e-19,  1.180245838902081e-20, -9.571485684376330e-22,  6.510966453846224e-23, -3.818427869139736e-24,
  1.969890787321883e-25, -9.078326245248116e-27,  3.783130002622384e-28, -1.437979537953496e-29,  3.802760604211902e-18, -1.461007031457307e-18,  2.971958582874737e-19,
 -4.104687961186496e-20,  4.294262404352849e-21, -3.619260763024270e-22,  2.556321546369047e-23, -1.555199690538383e-24,  8.315390983663386e-26, -3.968274989154663e-27,
  1.710920454024101e-28, -6.722330002363886e-30,  1.276353972933339e-18, -5.068475958121321e-19,  1.068719814498175e-19, -1.530086640697612e-20,  1.658435514336432e-21,
 -1.447053400610338e-22,  1.057279526164180e-23, -6.648435374037552e-25,  3.671360035519455e-26, -1.808072275653393e-27,  8.038604522589868e-29, -3.254263401658633e-30,
  4.651216779799289e-19, -1.900855868266598e-19,  4.136288694357205e-20, -6.112124215672614e-21,  6.834571323202254e-22, -6.148431672715988e-23,  4.628506892547099e-24,
 -2.996668138067660e-25,  1.702597134269501e-26, -8.621219520181536e-28,  3.938313529064010e-29, -1.636990386592413e-30,  1.844800834304397e-19, -7.724805337442507e-20,
  1.726677208254993e-20, -2.621377228288853e-21,  3.010478051439265e-22, -2.780056827368472e-23,  2.147079584615723e-24, -1.425306994359213e-25,  8.298284071805788e-27,
 -4.303273149449109e-28,  2.012084880954118e-29, -8.554991939367126e-31,  7.927219985186343e-20, -3.385750602063632e-20,  7.736457319268115e-21, -1.200898835611361e-21,
  1.409759734812468e-22, -1.330209107241648e-23,  1.049232514409849e-24, -7.110205370551571e-26,  4.223802731163874e-27, -2.233825361176649e-28,  1.064702863362608e-29,
 -4.612245019308372e-31,  3.618394654918729e-20, -1.569114323220365e-20,  3.646972116604353e-21, -5.759229234342339e-22,  6.876849956361551e-23, -6.598091479383918e-24,
  5.290202849268522e-25, -3.642722704703505e-26,  2.198014911411996e-27, -1.180320645189337e-28,  5.710131504541066e-30, -2.509720070458716e-31,  1.650691759723448e-20,
 -7.234243951934349e-21,  1.701486005927362e-21, -2.719433425314038e-22,  3.286006990363486e-23, -3.189859291406664e-24,  2.586991407433122e-25, -1.801391619381206e-26,
  1.098906004833329e-27, -5.964401558229092e-29,  2.915684457731414e-30, -1.294574432065101e-31,  5.883080952642887e-21, -2.593511128096390e-21,  6.140513423577124e-22,
 -9.880355919391323e-23,  1.201854684454769e-23, -1.174341427800579e-24,  9.585153773304615e-26, -6.716332947905642e-27,  4.122327325298204e-28, -2.250840641284312e-29,
  1.106759420740934e-30, -4.942051321843961e-32,  5.466600620622260e-02, -1.230730060261867e-04,  2.860436121175211e-07, -6.831601316973473e-10,  1.666834415031927e-12,
 -4.132021709968379e-15,  1.035255951787521e-17, -2.612123730267192e-20,  6.613716626604395e-23, -1.678114555741440e-25,  4.255758096589697e-28, -1.079402366742287e-30,
  5.120119619547463e-02, -1.391847712252051e-04,  4.476369508816884e-07, -1.515996194205861e-09,  5.133352622059014e-12, -1.711810636340503e-14,  5.608709914928295e-17,
 -1.808150871751156e-19,  5.746436282556869e-22, -1.803688986457967e-24,  5.599166757612431e-27, -1.721189961358008e-29,  4.491862490364450e-02, -1.641184917261868e-04,
  7.374832905181301e-07, -3.243548178386503e-09,  1.362154738834119e-11, -5.503533241182813e-14,  2.156164836085765e-16, -8.236286995151484e-19,  3.079241268532894e-21,
 -1.129895207789199e-23,  4.078061378836312e-26, -1.450244642560860e-28,  3.691461923609850e-02, -1.867780828402967e-04,  1.091862029499232e-06, -5.855996278570891e-09,
  2.932084431734121e-11, -1.395758159509295e-13,  6.384532118219919e-16, -2.825619673507425e-18,  1.215883086606894e-20, -5.105897419142945e-23,  2.098525352417469e-25,
 -8.460982611907285e-28,  2.842234200911496e-02, -1.972580593968795e-04,  1.427424945380249e-06, -9.106597898153016e-09,  5.346335194780084e-11, -2.952447845286308e-13,
  1.553005839988732e-15, -7.846641607468034e-18,  3.831448878673353e-20, -1.816389400043916e-22,  8.390282368915553e-25, -3.787015496940869e-27,  2.050679668153635e-02,
 -1.907165862705806e-04,  1.662198960723789e-06, -1.245097215144022e-08,  8.470672719936476e-11, -5.364090358527420e-13,  3.208768636168286e-15, -1.831475726753188e-17,
  1.004669340312859e-19, -5.325475825127088e-22,  2.739245062509607e-24, -1.371767106273613e-26,  1.386831846439870e-02, -1.684394361957861e-04,  1.740847940199524e-06,
 -1.516621336778868e-08,  1.184392403995288e-10, -8.523513950133238e-13,  5.749766345649564e-15, -3.677938558685839e-17,  2.249427515107362e-19, -1.323537157347216e-21,
  7.527845127062637e-24, -4.154407216614222e-26,  8.793784261537095e-03, -1.361625847311327e-04,  1.652044381351622e-06, -1.660593026794017e-08,  1.477122564944458e-10,
 -1.199420450557197e-12,  9.063339282661903e-15, -6.456405714047537e-17,  4.376139613542671e-19, -2.841718504566153e-21,  1.777332503301548e-23, -1.075149337600129e-25,
  5.230228986024502e-03, -1.010669701872261e-04,  1.428559958562480e-06, -1.645259707529035e-08,  1.656228270243544e-10, -1.508510712497961e-12,  1.269894069168218e-14,
 -1.002236931990171e-16,  7.491438363847331e-19, -5.343601306637510e-21,  3.658525974467601e-23, -2.415276823737955e-25,  2.919154718037724e-03, -6.910862358423858e-05,
  1.130581862268348e-06, -1.482731663471501e-08,  1.679969157112492e-10, -1.707821353467996e-12,  1.594253102188811e-14, -1.387944811475402e-16,  1.139379291840066e-18,
 -8.892048818079979e-21,  6.639127634549118e-23, -4.765873352180300e-25,  1.529744153358620e-03, -4.366848513984442e-05,  8.218934975107049e-07, -1.220762231538659e-08,
  1.549386773126129e-10, -1.750451183167354e-12,  1.804830667488132e-14, -1.726815154822192e-16,  1.551352665077538e-18, -1.320217971110736e-20,  1.071488391913500e-22,
 -8.337487647536971e-25,  7.531451095622055e-04, -2.557034248910981e-05,  5.505708501160437e-07, -9.216372455165612e-09,  1.304838632622032e-10, -1.632148629463981e-12,
  1.852301345620234e-14, -1.941365701244380e-16,  1.902872238029198e-18, -1.760670961116416e-20,  1.548948868373576e-22, -1.302956261338624e-24,  3.486208272684715e-04,
 -1.391068376735144e-05,  3.408259613967693e-07, -6.401570023508453e-09,  1.007203944470979e-10, -1.390194963561852e-12,  1.731246012584566e-14, -1.981974592435317e-16,
  2.113813534132209e-18, -2.121070659668382e-20,  2.017740651517433e-22, -1.830532582044339e-24,  1.518478056813271e-04, -7.047449655867787e-06,  1.954889285642889e-07,
 -4.103188297972695e-09,  7.149947039497975e-11, -1.085681614834785e-12,  1.479517387290600e-14, -1.845410652876190e-16,  2.136412318874127e-18, -2.319553120804795e-20,
  2.380789541688614e-22, -2.324579200111446e-24,  6.229671108539605e-05, -3.332421702467255e-06,  1.041535330787566e-07, -2.433837968190930e-09,  4.682332657103426e-11,
 -7.800200105250073e-13,  1.160307462901490e-14, -1.573177455531660e-16,  1.972672083703888e-18, -2.312689225038780e-20,  2.556196370480144e-22, -2.681122231203016e-24,
  2.409939500350025e-05, -1.473928437101555e-06,  5.167144185175560e-08, -1.339592759951100e-09,  2.837088064902375e-11, -5.171998160594777e-13,  8.378812166485286e-15,
 -1.232268464509486e-16,  1.670379389916358e-18, -2.110650449660784e-20,  2.507773997112893e-22, -2.820828510204918e-24,  8.802066251047766e-06, -6.111114768446532e-07,
  2.392800053515575e-08, -6.859878171436077e-10,  1.595038443723567e-11, -3.174508330148899e-13,  5.589076968314217e-15, -8.898991817708526e-17,  1.301671532800084e-18,
 -1.769725265561853e-20,  2.256705722696864e-22, -2.718073498123645e-24,  3.039713295629961e-06, -2.380391122895127e-07,  1.036831092859392e-08, -3.276976354545760e-10,
  8.344112377328388e-12, -1.809044294578701e-13,  3.454600835165238e-15, -5.944239483392179e-17,  9.366649347021273e-19, -1.368085073293302e-20,  1.869546593145364e-22,
 -2.407722787996492e-24,  9.941941138520468e-07, -8.730797301932345e-08,  4.214564037399186e-09, -1.464247847603371e-10,  4.073166407031356e-12, -9.599845354465999e-14,
  1.984702278158542e-15, -3.684350709986507e-17,  6.244544099916058e-19, -9.784116899296369e-21,  1.430873889114863e-22, -1.967820992886256e-24,  3.085473087331990e-07,
 -3.022652764748149e-08,  1.611338085461614e-09, -6.136932746679378e-11,  1.860760007746247e-12, -4.758069005674873e-14,  1.063124876675443e-15, -2.125821959550221e-17,
  3.869739752729218e-19, -6.495311968693830e-21,  1.015255531502911e-22, -1.489153477460367e-24,  9.105813881739011e-08, -9.903275125528060e-09,  5.810637227285482e-10,
 -2.419657438712443e-11,  7.979376855545351e-13, -2.209533764613076e-14,  5.326609616839843e-16, -1.145546027619188e-17,  2.236539586037034e-19, -4.016310293287571e-21,
  6.701410636492790e-23, -1.047138517234868e-24,  2.561672660317135e-08, -3.079276778625689e-09,  1.982273837258090e-10, -9.002656370391731e-12,  3.222203385016746e-13,
 -9.644709570368623e-15,  2.504592904299205e-16, -5.784751382998747e-18,  1.209693714951717e-19, -2.321218638471754e-21,  4.129604203879748e-23, -6.866496587943114e-25,
  6.888747227349691e-09, -9.114569266838778e-10,  6.418170842911775e-11, -3.171376820317633e-12,  1.229469336917623e-13, -3.970954089060012e-15,  1.109076420398285e-16,
 -2.747131588910749e-18,  6.145126898277798e-20, -1.258446103591264e-21,  2.384433615629015e-23, -4.214348537922387e-25,  1.776363721869492e-09, -2.577001671870193e-10,
  1.979231998383210e-11, -1.061570884204339e-12,  4.448863643245725e-14, -1.547818145285405e-15,  4.642361314703473e-17, -1.231467309381234e-18,  2.942921576906377e-20,
 -6.424328929325536e-22,  1.294940858611265e-23, -2.430251285968328e-25,  4.407979231116528e-10, -6.985768606252676e-11,  5.835738427112137e-12, -3.389812508620690e-13,
  1.532723571295504e-14, -5.734432789503265e-16,  1.844173500028182e-17, -5.231803278594612e-19,  1.334007939258905e-20, -3.100540090322341e-22,  6.641196512655433e-24,
 -1.322034559782494e-25,  1.056820895540120e-10, -1.823233473641371e-11,  1.652158479410193e-12, -1.037023246135327e-13,  5.049290185065833e-15, -2.028043159490212e-16,
  6.982643557453533e-18, -2.115593433448780e-19,  5.748220948815187e-21, -1.420765506609164e-22,  3.230195067592017e-24, -6.813255609998371e-26,  2.459084242063421e-11,
 -4.602635692358463e-12,  4.512285799883607e-13, -3.053715913419481e-14,  1.598048045506098e-15, -6.878856959052987e-17,  2.531752733697648e-18, -8.180568692832617e-20,
  2.365435622334740e-21, -6.209817792473396e-23,  1.496861014231025e-24, -3.341637214841452e-26,  5.581491676491315e-12, -1.129632288399643e-12,  1.195016719929284e-13,
 -8.700405329511203e-15,  4.884021478941932e-16, -2.249209920179707e-17,  8.835120749923962e-19, -3.040144904076059e-20,  9.342478773849407e-22, -2.601708160373356e-23,
  6.641060625616545e-25, -1.567366677657591e-26,  1.242756981725908e-12, -2.710865376540937e-13,  3.086456703268926e-14, -2.412057774844272e-15,  1.449583430472623e-16,
 -7.129295714997480e-18,  2.983992695817376e-19, -1.091800556934887e-20,  3.560728082883008e-22, -1.050478793137453e-23,  2.835931005428602e-25, -7.067421631641820e-27,
  2.731582774385415e-13, -6.401150569734569e-14,  7.823203211234325e-15, -6.547610234369768e-16,  4.204069587479324e-17, -2.204036865972988e-18,  9.812888821582474e-20,
 -3.811677415844505e-21,  1.317321744499456e-22, -4.111312870020352e-24,  1.172294250158526e-25, -3.080890010444078e-27,  5.968477676863776e-14, -1.497644105136292e-14,
  1.959508116008340e-15, -1.752241653775383e-16,  1.199472355192332e-17, -6.690200069930514e-19,  3.162713981773097e-20, -1.302024808793022e-21,  4.760840927748103e-23,
 -1.569482659413572e-24,  4.719920143895492e-26, -1.306312071027021e-27,  1.306382012257956e-14, -3.498453891039811e-15,  4.886865897043938e-16, -4.657599364656062e-17,
  3.391546781569043e-18, -2.008400442244739e-19,  1.006183613474891e-20, -4.382172546732441e-22,  1.692377010790495e-23, -5.883615780198118e-25,  1.863224911086591e-26,
 -5.422455124683920e-28,  2.888566418742275e-15, -8.227685432285537e-16,  1.223505174080297e-16, -1.239665529085602e-17,  9.579684722538686e-19, -6.009652957651797e-20,
  3.184068512082847e-21, -1.464185746197804e-22,  5.961248763480095e-24, -2.181648743228953e-25,  7.262831176940427e-27, -2.218901413937122e-28,  6.511079268266997e-16,
 -1.965735258654264e-16,  3.102607961024359e-17, -3.332797247320876e-18,  2.726262197334674e-19, -1.807508282945619e-20,  1.010519433395410e-21, -4.895909258688932e-23,
  2.097117710845358e-24, -8.063471376689202e-26,  2.816608987120324e-27, -9.017165257410162e-29,  1.510833585113738e-16, -4.817293842283614e-17,  8.044675107339856e-18,
 -9.135069531099149e-19,  7.888620509679977e-20, -5.513304921198009e-21,  3.244492505592191e-22, -1.652331324735945e-23,  7.429567033808670e-25, -2.994883344038406e-26,
  1.095383677881332e-27, -3.667311337907784e-29,  3.646228807900167e-17, -1.223280616805228e-17,  2.154186305894080e-18, -2.577839729293548e-19,  2.343147066625791e-20,
 -1.721455396354444e-21,  1.063511452626061e-22, -5.678622667893917e-24,  2.673728704064773e-25, -1.127248771804324e-26,  4.307159465526518e-28, -1.504677373931606e-29,
  9.250491899646816e-18, -3.252836916021165e-18,  6.019048487265830e-19, -7.565130500211182e-20,  7.214938803130697e-21, -5.555117089821577e-22,  3.592391971479684e-23,
 -2.005465107290446e-24,  9.860985890555872e-26, -4.336812466214989e-27,  1.726728297176604e-28, -6.278800055901721e-30,  2.493726054026616e-18, -9.154117675945260e-19,
  1.773154781987150e-19, -2.332311895100114e-20,  2.325828944508867e-21, -1.870526177835135e-22,  1.262153672154958e-23, -7.344053728072304e-25,  3.759909102830285e-26,
 -1.719970814296325e-27,  7.116054893470314e-29, -2.686019078014309e-30,  7.218091282052747e-19, -2.754545092476417e-19,  5.562807237622481e-20, -7.627845891294461e-21,
  7.924034684219764e-22, -6.632739384120159e-23,  4.653573440696619e-24, -2.812793473685052e-25,  1.494499525217307e-26, -7.088506455036351e-28,  3.038075028709869e-29,
 -1.186815166361469e-30,  2.264606095551175e-19, -8.945511490668063e-20,  1.875435273635845e-20, -2.669749534440394e-21,  2.877514260518870e-22, -2.497056446337208e-23,
  1.814774318565076e-24, -1.135287047936511e-25,  6.237779721252620e-27, -3.057014034795899e-28,  1.352697758298320e-29, -5.450972985182573e-31,  7.759057622321220e-20,
 -3.158426330675234e-20,  6.843028712893925e-21, -1.006803515028882e-21,  1.121017977812187e-22, -1.004288661282615e-23,  7.529661917687998e-25, -4.855809130781634e-26,
  2.748341832863389e-27, -1.386468094740067e-28,  6.310720251838567e-30, -2.613905550042685e-31,  2.914150281340820e-20, -1.216834490437491e-20,  2.711505093546606e-21,
 -4.103740114693383e-22,  4.698497859686116e-23, -4.325943273600692e-24,  3.331285928831846e-25, -2.205172159846473e-26,  1.280342501113881e-27, -6.621759088520580e-29,
  3.088085690552214e-30, -1.309680128860126e-31,  1.195801548940559e-20, -5.097955235388253e-21,  1.162511405822712e-21, -1.800820810236380e-22,  2.109752436507356e-23,
 -1.986770647324520e-24,  1.564091242556458e-25, -1.057929393716845e-26,  6.273125446800254e-28, -3.311743027865239e-29,  1.575736784380574e-30, -6.814558182702593e-32,
  5.262498256035111e-21, -2.279632431708955e-21,  5.292022955786422e-22, -8.346959812469817e-23,  9.954858664941694e-24, -9.540167153375733e-25,  7.640360967228519e-26,
 -5.255133765109455e-27,  3.167500136583971e-28, -1.699129315215008e-29,  8.211543332257900e-31, -3.605529014297496e-32,  2.339198684962297e-21, -1.024619583737011e-21,
  2.408447521827086e-22, -3.847010784750087e-23,  4.645712121032119e-24, -4.507116042661825e-25,  3.653178312767904e-26, -2.542366841727529e-27,  1.550066723224881e-28,
 -8.408567630764309e-30,  4.108340289330607e-31, -1.823180349877936e-32,  8.215455281948664e-22, -3.620888655746705e-22,  8.570743097379031e-23, -1.378703700268010e-23,
  1.676622415578863e-24, -1.637811465247437e-25,  1.336461446533644e-26, -9.362226585071912e-28,  5.744877811332428e-29, -3.136001698862334e-30,  1.541628758536499e-31,
 -6.882258256645738e-33,  5.417823959163456e-02, -1.208170016307906e-04,  2.780030225666171e-07, -6.571386492347322e-10,  1.586620564854917e-12, -3.892103332156139e-15,
  9.649909025048115e-18, -2.409831257627875e-20,  6.039126439387423e-23, -1.517009769943649e-25,  3.808423624039722e-28, -9.565871461388708e-31,  5.065150602356819e-02,
 -1.356750727163089e-04,  4.299267327496276e-07, -1.436529996422869e-09,  4.804051799820084e-12, -1.583075043012637e-14,  5.127225530026654e-17, -1.634236285271188e-19,
  5.135662438307223e-22, -1.594156468193976e-24,  4.894421396405499e-27, -1.488202052474774e-29,  4.427370928236442e-02, -1.583706925188479e-04,  6.998329474191257e-07,
 -3.034135554791654e-09,  1.257077669624577e-11, -5.012650640569527e-14,  1.938754045136158e-16, -7.312984131834853e-19,  2.700366313635222e-21, -9.788475474100237e-24,
  3.490598014161851e-26, -1.226648829763613e-28,  3.618454262764088e-02, -1.783165060326959e-04,  1.024315380356488e-06, -5.408388487148169e-09,  2.667636848597460e-11,
 -1.251600230019515e-13,  5.645178280615041e-16, -2.464397073773852e-18,  1.046324358846478e-20, -4.336440126415326e-23,  1.759367739949961e-25, -7.003695617902642e-28,
  2.765547642360310e-02, -1.862616704772283e-04,  1.323089752457395e-06, -8.296470595505011e-09,  4.791407267553164e-11, -2.604763890334529e-13,  1.349526095639458e-15,
 -6.719037004071621e-18,  3.234148753643659e-20, -1.511867525555282e-22,  6.888188991814496e-25, -3.067263726358043e-27,  1.976961073158085e-02, -1.779943900151571e-04,
  1.520578203442605e-06, -1.117747376786495e-08,  7.470891810155130e-11, -4.652060454226371e-13,  2.738226670196787e-15, -1.538654206585293e-17,  8.313022094310045e-20,
 -4.341585061274794e-22,  2.200956773129884e-24, -1.086605431082518e-26,  1.322130548630940e-02, -1.552096639853596e-04,  1.569684359288594e-06, -1.340040009926580e-08,
  1.026927649722144e-10, -7.259435168534584e-13,  4.813949432838272e-15, -3.028885531794462e-17,  1.823021043010193e-19, -1.056035070934966e-21,  5.915506128443013e-24,
 -3.216229321547192e-26,  8.274358993017822e-03, -1.237048858738808e-04,  1.466198647353091e-06, -1.442321018626607e-08,  1.257604117889027e-10, -1.002101259882413e-12,
  7.437144515919293e-15, -5.206877596340686e-17,  3.470452996444636e-19, -2.217111748365326e-21,  1.364778596227222e-23, -8.128375817738710e-26,  4.847628373318998e-03,
 -9.038535566689629e-05,  1.246084113836463e-06, -1.402834171265633e-08,  1.382863321075662e-10, -1.234870536062335e-12,  1.020127351866101e-14, -7.906611817657460e-17,
  5.807405242994272e-19, -4.072597624084644e-21,  2.742568784559079e-23, -1.781569122305038e-25,  2.659743908258135e-03, -6.073245181838510e-05,  9.677185059131608e-07,
 -1.239307915526398e-08,  1.373720113663724e-10, -1.367993986103202e-12,  1.252203334012333e-14, -1.069820084705965e-16,  8.624097409815911e-19, -6.612972039720800e-21,
  4.853617969263410e-23, -3.426433641268332e-25,  1.367348901137460e-03, -3.763967526162074e-05,  6.891928204636057e-07, -9.986689026252562e-09,  1.238968359388680e-10,
 -1.370114388329672e-12,  1.384228645021823e-14, -1.298822968437757e-16,  1.145125763542818e-18, -9.569453075332886e-21,  7.630510134658256e-23, -5.836138407759738e-25,
  6.590194509377541e-04, -2.157500259189404e-05,  4.514970872035201e-07, -7.367351902715448e-09,  1.018793349552604e-10, -1.246490946391827e-12,  1.385230585655993e-14,
 -1.422941598996603e-16,  1.367987896617338e-18, -1.242281160846556e-20,  1.073217954719129e-22, -8.869569909358628e-25,  2.979808529069326e-04, -1.146593075409139e-05,
  2.728270349931743e-07, -4.991657300417452e-09,  7.665867363887134e-11, -1.034300245318338e-12,  1.260538255203883e-14, -1.413601364256839e-16,  1.477972316331955e-18,
 -1.454841921678214e-20,  1.358438614647481e-22, -1.210293857140389e-24,  1.264994155879668e-04, -5.662576491174681e-06,  1.524560770588872e-07, -3.115240041072817e-09,
  5.295501606590114e-11, -7.855884727530752e-13,  1.047163182916157e-14, -1.278816263897105e-16,  1.450685621518832e-18, -1.544430012465118e-20,  1.555338639579438e-22,
 -1.490815220305950e-24,  5.046504146109596e-05, -2.604375991124283e-06,  7.897291159446766e-08, -1.795716068234857e-09,  3.368470810971221e-11, -5.479758612404575e-13,
  7.969608496993010e-15, -1.057498324663233e-16,  1.298846823752620e-18, -1.492568681420007e-20,  1.618078236531638e-22, -1.665540455111684e-24,  1.893855603296202e-05,
 -1.117861045781180e-06,  3.801101138053200e-08, -9.585574769543760e-10,  1.978679150175180e-11, -3.521108948049515e-13,  5.575074735452334e-15, -8.021546495444844e-17,
  1.064691277917144e-18, -1.318263005090532e-20,  1.535797157632097e-22, -1.694865091610962e-24,  6.693876953241167e-06, -4.487154443576056e-07,  1.703934809269940e-08,
 -4.750551159308127e-10,  1.076295418111375e-11, -2.090384906450745e-13,  3.595915455273862e-15, -5.599788580261321e-17,  8.018087339508023e-19, -1.067927109101344e-20,
  1.334953949836058e-22, -1.577133085632837e-24,  2.231420122145391e-06, -1.688008009531096e-07,  7.130758106963667e-09, -2.191420618171339e-10,  5.436058535039929e-12,
 -1.149878599130626e-13,  2.145000468602934e-15, -3.609074628094792e-17,  5.565887414771915e-19, -7.962439866795054e-21,  1.066464727100835e-22, -1.346975161722157e-24,
  7.026579159249376e-07, -5.964264213559000e-08,  2.792646047429309e-09, -9.433975978789604e-11,  2.556384923527038e-12, -5.877678211186498e-14,  1.186879457283489e-15,
 -2.154189076391273e-17,  3.572866811877165e-19, -5.482337802301513e-21,  7.857261166895301e-23, -1.059622137803137e-24,  2.093879506868601e-07, -1.983965115305500e-08,
  1.026128607537753e-09, -3.800348124460291e-11,  1.122490144850155e-12, -2.800007434253422e-14,  6.110296559806612e-16, -1.194516921456979e-17,  2.127722606101500e-19,
 -3.497329185960102e-21,  5.356910853665595e-23, -7.704665153663428e-25,  5.917033560017237e-08, -6.228721844028648e-09,  3.547075332122453e-10, -1.436628706327662e-11,
  4.615621137719513e-13, -1.246889131621957e-14,  2.935929064919650e-16, -6.173137594889646e-18,  1.179358274483369e-19, -2.073988217456583e-21,  3.391208403037223e-23,
 -5.196077846510763e-25,  1.589383427242270e-08, -1.850723920363902e-09,  1.156876110082672e-10, -5.111774131874237e-12,  1.782868237273225e-13, -5.207064523703634e-15,
  1.320886576094914e-16, -2.983045788533792e-18,  6.104766232993774e-20, -1.147252462639062e-21,  2.000315512241775e-23, -3.261717720391450e-25,  4.069098693144049e-09,
 -5.219993078686243e-10,  3.571284991337824e-11, -1.717587830170793e-12,  6.490731875039177e-14, -2.046078794809002e-15,  5.583555750488510e-17, -1.352576632415511e-18,
  2.961490910175410e-20, -5.940695592457062e-22,  1.103330574447158e-23, -1.912674541703124e-25,  9.959753136221760e-10, -1.402267653932606e-10,  1.047095426188377e-11,
 -5.469185231378979e-13,  2.235178615986236e-14, -7.592624200153005e-16,  2.225724575951281e-17, -5.775823554137562e-19,  1.351397324720905e-20, -2.890445688404979e-22,
  5.712280374668793e-24, -1.051726616888302e-25,  2.338832721302625e-10, -3.601087824178347e-11,  2.927027816520130e-12, -1.656772952557631e-13,  7.309215378290016e-15,
 -2.671207107357535e-16,  8.399632745728599e-18, -2.332031992494921e-19,  5.823845379111500e-21, -1.326686000640659e-22,  2.787019979852780e-24, -5.444584904712700e-26,
  5.290233334700553e-11, -8.877143845371540e-12,  7.833870388188933e-13, -4.794989091724605e-14,  2.279423121806113e-15, -8.948041964106529e-17,  3.013951429204370e-18,
 -8.940891200774470e-20,  2.380374964398249e-21, -5.768977551729953e-23,  1.286902208385459e-24, -2.664841633796925e-26,  1.157788457295955e-11, -2.110353592491807e-12,
  2.016809679216079e-13, -1.332095797868493e-14,  6.811049743652883e-16, -2.867397845655282e-17,  1.033062611156314e-18, -3.270177250393475e-20,  9.270397185087029e-22,
 -2.387565887357280e-23,  5.649551046696895e-25, -1.238797268933622e-26,  2.464161933632316e-12, -4.863195546856597e-13,  5.020509172499201e-14, -3.570767175880032e-15,
  1.960130644704472e-16, -8.835308664564391e-18,  3.399778215695737e-19, -1.146854570525737e-20,  3.457432009540096e-22, -9.451587676182935e-24,  2.369705676865751e-25,
 -5.496452773141257e-27,  5.129559033308883e-13, -1.092640292964351e-13,  1.215432833754183e-14, -9.288846477682983e-16,  5.464074729972267e-17, -2.632611512130833e-18,
  1.080293501926843e-19, -3.877935258807563e-21,  1.241635405075611e-22, -3.598353531584088e-24,  9.548117417707797e-26, -2.340039108561857e-27,  1.051112612515428e-13,
 -2.408871531294661e-14,  2.880023413984364e-15, -2.359918749944676e-16,  1.484713745182745e-17, -7.632839522532477e-19,  3.334802904352496e-20, -1.271989935393058e-21,
  4.319372519616168e-23, -1.325313660060369e-24,  3.717195238133570e-26, -9.614330730852319e-28,  2.135449992350667e-14, -5.248480810110068e-15,  6.727016818512868e-16,
 -5.896779924860289e-17,  3.959799761393827e-18, -2.168146254178100e-19,  1.006842351973751e-20, -4.074170873483151e-22,  1.465110460908195e-23, -4.752715431568006e-25,
  1.407134486721429e-26, -3.835967746919281e-28,  4.335667846404868e-15, -1.139119571861748e-15,  1.561013380410461e-16, -1.460385354608422e-17,  1.044506102104618e-18,
 -6.079175181076229e-20,  2.995105878647041e-21, -1.283538409863717e-22,  4.880111423832659e-24, -1.671109371145607e-25,  5.215016439124761e-27, -1.496284846387979e-28,
  8.874799676245416e-16, -2.484245224013321e-16,  3.629716726192131e-17, -3.615115415036808e-18,  2.747653105359207e-19, -1.696273813855726e-20,  8.849078326283666e-22,
 -4.008684552247850e-23,  1.608576156848320e-24, -5.804765205003884e-26,  1.906281374545067e-27, -5.747566369039050e-29,  1.849100809016990e-16, -5.495730359336961e-17,
  8.536391125862614e-18, -9.027389830655758e-19,  7.273351229988572e-20, -4.751973062839280e-21,  2.619221557729784e-22, -1.251678378419985e-23,  5.290564212614560e-25,
 -2.008164110264225e-26,  6.927405251495949e-28, -2.191034947437526e-29,  3.962444721957280e-17, -1.245965753062899e-17,  2.051062659868881e-18, -2.296524871237142e-19,
  1.956250353617568e-20, -1.349223305007992e-21,  7.838781804072864e-23, -3.942791212472448e-24,  1.751628719437201e-25, -6.978940450531384e-27,  2.523819683140842e-28,
 -8.357463527804879e-30,  8.830094044583937e-18, -2.926643505649855e-18,  5.088977389723406e-19, -6.014441595682331e-20,  5.401023507892327e-21, -3.921627467256664e-22,
  2.395318733607056e-23, -1.264930790031810e-24,  5.892367393620407e-26, -2.458559891672649e-27,  9.299810445226722e-29, -3.217243868052920e-30,  2.070097216147972e-18,
 -7.203910687152696e-19,  1.318497679165520e-19, -1.639359595815555e-20,  1.547084692250614e-21, -1.179041983854173e-22,  7.549302583074250e-24, -4.174024400136441e-25,
  2.033304109428691e-26, -8.861663928217805e-28,  3.497412253328580e-29, -1.260943651646248e-30,  5.166173906080831e-19, -1.879986876926685e-19,  3.608001405062026e-20,
 -4.702475612390613e-21,  4.647614902050608e-22, -3.705402704843063e-23,  2.479206202975906e-24, -1.430781058763402e-25,  7.267026101377162e-27, -3.298708662032606e-28,
  1.354575849065160e-29, -5.075920567128168e-31,  1.388512558337508e-19, -5.261393310570843e-20,  1.054492953303980e-20, -1.435063532569808e-21,  1.479809871193266e-22,
 -1.229780227244205e-23,  8.568094411822718e-25, -5.143825949254988e-26,  2.715067414383886e-27, -1.279555209899547e-28,  5.450074148276070e-30, -2.116263877318229e-31,
  4.062716238906897e-20, -1.595923445783472e-20,  3.325758418283430e-21, -4.705971230624326e-22,  5.042413916502530e-23, -4.350673011085493e-24,  3.144315838862755e-25,
 -1.956380181586898e-26,  1.069274017834423e-27, -5.213548019776502e-29,  2.295499331995567e-30, -9.205709531256597e-32,  1.305666560348021e-20, -5.292704587571643e-21,
  1.141483949223329e-21, -1.671788232671225e-22,  1.853108390187210e-23, -1.652897475810524e-24,  1.233992930826280e-25, -7.925011411980568e-27,  4.467460626654875e-28,
 -2.244920544487568e-29,  1.017932832661852e-30, -4.200777978105609e-32,  4.633040357428288e-21, -1.928847371270227e-21,  4.284079175969835e-22, -6.462552960512555e-23,
  7.375384019554819e-24, -6.769247384173382e-25,  5.196857780171944e-26, -3.429863210073190e-27,  1.985644803073862e-28, -1.024058767355054e-29,  4.762675919978849e-31,
 -2.014527780059420e-32,  1.811708146488260e-21, -7.708718940253365e-22,  1.754072545547242e-22, -2.711316388115133e-23,  3.169677656343634e-24, -2.978693450333276e-25,
  2.340223144824077e-26, -1.579763877272180e-27,  9.349381595132908e-29, -4.926536141470282e-30,  2.339790718634927e-31, -1.010096880537694e-32,  7.673666601652114e-22,
 -3.320348309043589e-22,  7.698224112662521e-23, -1.212670659068560e-23,  1.444451339442422e-24, -1.382574035020685e-25,  1.105919585155513e-26, -7.597728790878397e-28,
  4.574251981012374e-29, -2.451016386068892e-30,  1.183241909345549e-31, -5.189916167686970e-33,  3.319270845436761e-22, -1.453096588706819e-22,  3.413460296783639e-23,
 -5.448836156462425e-24,  6.575946257848074e-25, -6.375808023563833e-26,  5.164681498190646e-27, -3.592137717224360e-28,  2.188835895829485e-29, -1.186694096196010e-30,
  5.794859640372234e-32, -2.570231581440982e-33,  1.147908989776236e-22, -5.058098743711711e-23,  1.196941545440978e-23, -1.924888244698925e-24,  2.340186232466119e-25,
 -2.285393486437892e-26,  1.864391656374001e-27, -1.305705886555365e-28,  8.010035260001018e-30, -4.371387129347231e-31,  2.148394593662213e-32, -9.588677116159678e-34,
  5.369937029249926e-02, -1.186240943799936e-04,  2.702671457055163e-07, -6.323630987995600e-10,  1.511040928959691e-12, -3.668389116836090e-15,  9.001411048159912e-18,
 -2.225031212288754e-20,  5.519439211650153e-23, -1.372763286338475e-25,  3.411750329881385e-28, -8.487790771719870e-31,  5.011557719771621e-02, -1.323033292280034e-04,
  4.131393258720558e-07, -1.362132751722129e-09,  4.499380865021036e-12, -1.465332129471692e-14,  4.691810595661608e-17, -1.478712018003517e-19,  4.595483757995715e-22,
 -1.410866296802902e-24,  4.284606769021203e-27, -1.288767284483553e-29,  4.365119797389803e-02, -1.529143227785056e-04,  6.645978321513977e-07, -2.840777345512340e-09,
  1.161316719742192e-11, -4.570976466404466e-14,  1.745576996242720e-16, -6.502655870266659e-19,  2.371865547310789e-21, -8.494432616189904e-24,  2.993235972855411e-26,
 -1.039551289599759e-28,  3.548726461086132e-02, -1.703745152394142e-04,  9.618953662888435e-07, -5.000878862176495e-09,  2.430325264022259e-11, -1.124031928207917e-13,
  4.999769004773118e-16, -2.153250979592367e-18,  9.021711476176065e-21, -3.690641809506451e-23,  1.478304459672171e-25, -5.811051176727341e-28,  2.693098653700232e-02,
 -1.760625352185533e-04,  1.227965472422110e-06, -7.569823796727049e-09,  4.301377611062693e-11, -2.302332576428639e-13,  1.175100260642406e-15, -5.766128381080126e-18,
  2.736383437364808e-20, -1.261543280823639e-22,  5.669944634825459e-25, -2.491209827535717e-27,  1.908114071908165e-02, -1.663466469235724e-04,  1.393324717037638e-06,
 -1.005313464885622e-08,  6.602856931014263e-11, -4.043717413246357e-13,  2.342412099503818e-15, -1.296035161081186e-17,  6.897639371956384e-20, -3.549859608675876e-22,
  1.773903565425403e-24, -8.635034408237555e-27,  1.262460137862450e-02, -1.432685399190289e-04,  1.418278514661839e-06, -1.186746635677056e-08,  8.926381090414758e-11,
 -6.199601426420551e-13,  4.042127801698288e-15, -2.502042699243461e-17,  1.482237055934671e-19, -8.454671615735895e-22,  4.665053941272429e-24, -2.499156866797822e-26,
  7.801948824166975e-03, -1.126348665108707e-04,  1.304561850264489e-06, -1.256215578897663e-08,  1.073913950964322e-10, -8.399201336919944e-13,  6.123408599806589e-15,
 -4.214163938240683e-17,  2.762507587325938e-19, -1.736553166016185e-21,  1.052249160447269e-23, -6.171177492862803e-26,  4.505008874260958e-03, -8.105422344344972e-05,
  1.090245607431398e-06, -1.200075381633153e-08,  1.158682094762472e-10, -1.014634493660526e-12,  8.226978209480724e-15, -6.263094661586234e-17,  4.521195851801872e-19,
 -3.117709674589025e-21,  2.065404755196006e-23, -1.320388189125558e-25,  2.431405860185934e-03, -5.355018448556458e-05,  8.313366325302437e-07, -1.039864233465198e-08,
  1.127900142412216e-10, -1.100499940051737e-12,  9.879617115893002e-15, -8.284689538215465e-17,  6.559359593471743e-19, -4.942722078516026e-21,  3.566679323558457e-23,
 -2.476581421865356e-25,  1.227103268112342e-03, -3.257376498356354e-05,  5.803976350606100e-07, -8.206673473240827e-09,  9.954224607747304e-11, -1.077697627798142e-12,
  1.067073442463380e-14, -9.820801562994067e-17,  8.498902244325749e-19, -6.975357524861299e-21,  5.465444610305922e-23, -4.109481420074268e-25,  5.794202389588366e-04,
 -1.829073129746818e-05,  3.721016105344502e-07, -5.919928348177003e-09,  7.997525977712545e-11, -9.572851959381663e-13,  1.041918815340161e-14, -1.049163295170088e-16,
  9.894701574931379e-19, -8.820188237501136e-21,  7.483773435104973e-23, -6.077431642422800e-25,  2.561304875076730e-04, -9.503534520102747e-06,  2.196535286142828e-07,
 -3.915424589066149e-09,  5.870305119243245e-11, -7.743725933936521e-13,  9.237608146503818e-15, -1.014922273162864e-16,  1.040424470925702e-18, -1.004814621808732e-20,
  9.210566320522596e-23, -8.060008034897255e-25,  1.060705138344196e-04, -4.579166693649974e-06,  1.196795090680485e-07, -2.381128170671571e-09,  3.949147977329343e-11,
 -5.724656429695783e-13,  7.465139419479304e-15, -8.927248796626486e-17,  9.924724251971019e-19, -1.036213155114559e-20,  1.024008397220216e-22, -9.636807483856468e-25,
  4.118654578670611e-05, -2.050394909624788e-06,  6.032748991533273e-08, -1.334972693823599e-09,  2.442037421828375e-11, -3.879957087207836e-13,  5.517857665431070e-15,
 -7.166537409320525e-17,  8.622730631483282e-19, -9.713802747664461e-21,  1.032986660730558e-22, -1.043598724711040e-24,  1.500938534922611e-05, -8.548932111719556e-07,
  2.819707827380215e-08, -6.917362718243254e-10,  1.391884251271921e-11, -2.418110439086360e-13,  3.742355722032541e-15, -5.268497279309482e-17,  6.847887072032662e-19,
 -8.309196066151276e-21,  9.492830185857734e-23, -1.027905956862762e-24,  5.139290001120523e-06, -3.325655051515023e-07,  1.224781375284624e-08, -3.320900837223980e-10,
  7.331801744631097e-12, -1.389739626516635e-13,  2.336017962301416e-15, -3.558277682750772e-17,  4.987891689664781e-19, -6.508676901549625e-21,  7.976461160961202e-23,
 -9.244085724352958e-25,  1.655532235924650e-06, -1.209531259365377e-07,  4.955224993010725e-09, -1.480766008925271e-10,  3.578623856539714e-12, -7.385977946408192e-14,
  1.345978444180697e-15, -2.214653087655720e-17,  3.342905757027513e-19, -4.684332514958667e-21,  6.149692851592790e-23, -7.617924545616490e-25,  5.024752540413473e-07,
 -4.121466225506783e-08,  1.871693492795075e-09, -6.147816964493804e-11,  1.622818727124970e-12, -3.640054346198071e-14,  7.179482179867397e-16, -1.274086260517711e-17,
  2.067964067775417e-19, -3.107694098198257e-21,  4.365032198953024e-23, -5.772720000721589e-25,  1.439399571380216e-07, -1.318736866596847e-08,  6.616664494735077e-10,
 -2.382810075619315e-11,  6.855757473091613e-13, -1.668259692923644e-14,  3.555631684671766e-16, -6.795755919843077e-18,  1.184496410906229e-19, -1.906623697297631e-21,
  2.861886611675597e-23, -4.036212247576822e-25,  3.899399439950301e-08, -3.971827275050289e-09,  2.194888555329005e-10, -8.645366221762947e-12,  2.705879718729304e-13,
 -7.131009578118813e-15,  1.639915080121317e-16, -3.371085225694401e-18,  6.301983404649671e-20, -1.085278950283027e-21,  1.738976292822668e-23, -2.612723816424040e-25,
  1.001272784318480e-08, -1.129016264292462e-09,  6.851413519475893e-11, -2.944938302899353e-12,  1.000782558807199e-13, -2.851757275287837e-15,  7.066082002617236e-17,
 -1.560249133916018e-18,  3.124633335068891e-20, -5.750670335924910e-22,  9.826231519230832e-24, -1.571227101548244e-25,  2.443320763886146e-09, -3.037798338746266e-10,
  2.018729309839779e-11, -9.448097832075645e-13,  3.479812587884657e-14, -1.070483311775031e-15,  2.853924340530406e-17, -6.760590519749046e-19,  1.448747761010926e-20,
 -2.846482661994075e-22,  5.181587216855498e-24, -8.809643364316325e-26,  5.683072792071900e-10, -7.762116314471285e-11,  5.633456648655740e-12, -2.864771612827136e-13,
  1.141516317712215e-14, -3.785265583862660e-16,  1.084354456395978e-17, -2.752415435912418e-19,  6.304392934667741e-21, -1.321017252682449e-22,  2.559349526516757e-24,
 -4.622439348123615e-26,  1.264299859953736e-10, -1.890357996954611e-11,  1.494501635556351e-12, -8.240705095645711e-14,  3.546385577758625e-15, -1.265728182531789e-16,
  3.890917376848481e-18, -1.057001771719647e-19,  2.584938150587432e-21, -5.770630546051706e-23,  1.188768595004403e-24, -2.278726910331533e-26,  2.700741066159024e-11,
 -4.405787959838628e-12,  3.784865407441312e-13, -2.258360120657776e-14,  1.047856416757460e-15, -4.019301118693818e-17,  1.324110712028302e-18, -3.845113963129737e-20,
  1.002886417414007e-21, -2.382811450265947e-23,  5.214359844706536e-25, -1.059874686377841e-26,  5.564449824957477e-12, -9.872154622451517e-13,  9.192946241953029e-14,
 -5.923838521412341e-15,  2.958402044525727e-16, -1.217728681773409e-17,  4.293443922151151e-19, -1.331142310683251e-20,  3.698704559060318e-22, -9.343304907515120e-24,
  2.169824014062800e-25, -4.672322145738916e-27,  1.111411629653362e-12, -2.137724172037230e-13,  2.152608153713006e-14, -1.495030457627532e-15,  8.022323529375600e-17,
 -3.538151949656248e-18,  1.333270402000646e-19, -4.407858529493016e-21,  1.303267804704863e-22, -3.496464126857066e-24,  8.608441868377516e-26, -1.961856166416944e-27,
  2.164431279496623e-13, -4.499503773730822e-14,  4.887699603627744e-15, -3.651294203288094e-16,  2.101487993640486e-17, -9.915250641773943e-19,  3.987620692602933e-20,
 -1.403933751592674e-21,  4.411709442112322e-23, -1.255606137091436e-24,  3.273816261382584e-26, -7.888348677313109e-28,  4.136725832583864e-14, -9.265782987684938e-15,
  1.083162449746507e-15, -8.685460229651096e-17,  5.351919045829679e-18, -2.696954199300903e-19,  1.155849351950477e-20, -4.327690844843880e-22,  1.443477368743748e-23,
 -4.352912991373467e-25,  1.200566368879850e-26, -3.055120218970349e-28,  7.816190131320849e-15, -1.880502095186346e-15,  2.359813941577851e-16, -2.026752396603054e-17,
  1.334511517436435e-18, -7.169994297665847e-20,  3.269412740309835e-21, -1.299874986329823e-22,  4.595613573536635e-24, -1.466442347682687e-25,  4.272995624117702e-27,
 -1.146997821408416e-28,  1.472037035378761e-15, -3.792043209060235e-16,  5.095099422347074e-17, -4.676493618032123e-18,  3.283708705286378e-19, -1.877523013343391e-20,
  9.093063257978051e-22, -3.832814594292286e-23,  1.434124396001407e-24, -4.835399306166539e-26,  1.486490494183334e-27, -4.203429979135026e-29,  2.788588909047394e-16,
 -7.666503865096220e-17,  1.099975125778190e-17, -1.076358268782226e-18,  8.042250170853809e-20, -4.883684913341570e-21,  2.507434263760265e-22, -1.118519718952970e-23,
  4.421917314513886e-25, -1.572842273405971e-26,  5.093444982339472e-28, -1.515034742990610e-29,  5.367282634071726e-17, -1.569478070028891e-17,  2.397785886415572e-18,
 -2.495043411031996e-19,  1.979023227379696e-20, -1.273547605433950e-21,  6.917602353552849e-23, -3.259306735844938e-24,  1.358875694592029e-25, -5.089882783870114e-27,
  1.733347640302884e-28, -5.414339297378474e-30,  1.061176574914735e-17, -3.288829963476526e-18,  5.333932606374157e-19, -5.885819990625901e-20,  4.943268473016600e-21,
 -3.362964955213168e-22,  1.928087689120357e-23, -9.574257638086502e-25,  4.200890709419810e-26, -1.653686139036691e-27,  5.910771954697738e-29, -1.935267415856227e-30,
  2.180758770011374e-18, -7.136820650287600e-19,  1.224746136488952e-19, -1.428862422686618e-20,  1.267085101817006e-21, -9.088599403575398e-23,  5.486053171116832e-24,
 -2.864108809256707e-25,  1.319447289676884e-26, -5.446394251825396e-28,  2.038770231327338e-29, -6.982088364556759e-31,  4.716669141383744e-19, -1.623616914557749e-19,
  2.937873398796124e-20, -3.611897134455278e-21,  3.371387251612865e-22, -2.542122338674019e-23,  1.610967592471993e-24, -8.818295287949661e-26,  4.254159240876677e-27,
 -1.836687100942378e-28,  7.182846867378906e-30, -2.566840974824186e-31,  1.087609521029809e-19, -3.921851581757503e-20,  7.454147730330628e-21, -9.622704528066377e-22,
  9.421926833150582e-23, -7.443854330896723e-24,  4.936785041863462e-25, -2.824804138696795e-26,  1.422874343345619e-27, -6.407011922227920e-29,  2.610475094823968e-30,
 -9.708259161457814e-32,  2.708417891039390e-20, -1.018664357877025e-20,  2.025396703091841e-21, -2.734631212450191e-22,  2.798151713046314e-23, -2.307921665208830e-24,
  1.596245803654270e-25, -9.515175893274038e-27,  4.987891613410969e-28, -2.335012181796843e-29,  9.881230498636576e-31, -3.812805610416888e-32,  7.373222244677007e-21,
 -2.879422975906950e-21,  5.962521847192448e-22, -8.383892224223858e-23,  8.927883834470539e-24, -7.656839706865320e-25,  5.501426554758263e-26, -3.403544783348408e-27,
  1.849983718348235e-28, -8.971861216768816e-30,  3.929741204568938e-31, -1.568021027191456e-32,  2.217279280824240e-21, -8.948448310262773e-22,  1.920644000753075e-22,
 -2.799416762825070e-23,  3.088418287740165e-24, -2.742086313109757e-25,  2.037989995730032e-26, -1.303161231137979e-27,  7.315125773816682e-29, -3.660812191462484e-30,
  1.653339516588686e-31, -6.796615871371524e-33,  7.415780735564050e-22, -3.077704548650235e-22,  6.812207038852482e-23, -1.024078160991412e-23,  1.164765623123124e-24,
 -1.065502096349271e-25,  8.153662060930411e-27, -5.364449459451284e-28,  3.096168325837839e-29, -1.592061600525197e-30,  7.383024992438068e-32, -3.114177322875581e-33,
  2.757470280361171e-22, -1.170881374260380e-22,  2.658208668070462e-23, -4.099473981219271e-24,  4.781732791412681e-25, -4.483740307453540e-26,  3.515123957943563e-27,
 -2.367931537607332e-28,  1.398550530250196e-29, -7.354946850358681e-31,  3.486431567802125e-32, -1.502306917225645e-33,  1.122046939681879e-22, -4.849214140514588e-23,
  1.122786607519950e-23, -1.766299257977883e-24,  2.101102964876358e-25, -2.008482408472911e-26,  1.604545386342938e-27, -1.100968995599821e-28,  6.620461280590736e-30,
 -3.543276566114990e-31,  1.708584873068364e-32, -7.485866139350197e-34,  4.716527649379889e-23, -2.063561658796743e-23,  4.844280232689049e-24, -7.727631662305550e-25,
  9.319924861312158e-26, -9.030383206623726e-27,  7.310336163265200e-28, -5.081313215014376e-29,  3.094366447813067e-30, -1.676637533635689e-31,  8.182601061451905e-33,
 -3.627233683100567e-34,  1.604878128500296e-23, -7.069912680453997e-24,  1.672543222471745e-24, -2.688966171480789e-25,  3.268181543136706e-26, -3.190759907108657e-27,
  2.602252906316294e-28, -1.821960260084316e-29,  1.117406480590675e-30, -6.096510002880780e-32,  2.995458902349002e-33, -1.336588238546444e-34,  5.322915070269813e-02,
 -1.164919051406879e-04,  2.628214647639879e-07, -6.087618566447062e-10,  1.439784033999271e-12, -3.459636247600895e-15,  8.402404820647517e-18, -2.056060017886950e-20,
  5.048935345856519e-23, -1.243474784431899e-25,  3.059573479745687e-28, -7.540332991707585e-31,  4.959287228681834e-02, -1.290623950439421e-04,  3.972161966287119e-07,
 -1.292427386505875e-09,  4.217247805778527e-12, -1.357535552398326e-14,  4.297618392673513e-17, -1.339463131208025e-19,  4.117102360437529e-22, -1.250300802902995e-24,
  3.756117123310342e-27, -1.117772054869143e-29,  4.304996271870014e-02, -1.477308066825105e-04,  6.315939203922549e-07, -2.662058649223067e-09,  1.073943410547285e-11,
 -4.173056695781815e-14,  1.573684841833081e-16, -5.790362593533097e-19,  2.086559164296521e-21, -7.383800857772149e-24,  2.571342794665616e-26, -8.826738211559758e-29,
  3.482078592137822e-02, -1.629129507262595e-04,  9.041458033603389e-07, -4.629379288270030e-09,  2.217046319959054e-11, -1.010958050866976e-13,  4.435357182349998e-16,
 -1.884721234710099e-18,  7.793633886057766e-21, -3.147436840399872e-23,  1.244842155671855e-25, -4.832594876763789e-28,  2.624582460519766e-02, -1.665908034989017e-04,
  1.141109773224064e-06, -6.916961535046867e-09,  3.867855156236595e-11, -2.038733679472440e-13,  1.025254925233480e-15, -4.958979046838685e-18,  2.320541756866985e-20,
 -1.055233469960771e-22,  4.679195127856504e-25, -2.028835864353645e-27,  1.843730785750873e-02, -1.556652352745396e-04,  1.278768526261562e-06, -9.058441554905977e-09,
  5.847515995818062e-11, -3.522704468606330e-13,  2.008595990579201e-15, -1.094459424804267e-17,  5.738757380267351e-20, -2.910824109188382e-22,  1.434016892268085e-24,
 -6.883730748205670e-27,  1.207335082438401e-02, -1.324685796694186e-04,  1.284045516101458e-06, -1.053339697003368e-08,  7.778062758061197e-11, -5.308468492723915e-13,
  3.403629225312871e-15, -2.073028878597938e-17,  1.208966182573641e-19, -6.791324475112308e-22,  3.691705818338235e-24, -1.948990670250516e-26,  7.371367241987949e-03,
 -1.027733714495218e-04,  1.163596018231634e-06, -1.097067969291257e-08,  9.197196086665279e-11, -7.061739820297302e-13,  5.058354606171167e-15, -3.422566432459674e-17,
  2.206993166467486e-19, -1.365335787855281e-21,  8.145051596058167e-24, -4.704535092486845e-26,  4.197366397306884e-03, -7.287825400485442e-05,  9.567234405949845e-07,
 -1.029904411195620e-08,  9.741597640446300e-11, -8.366944262295281e-13,  6.660062456291918e-15, -4.981017976428179e-17,  3.534515910355511e-19, -2.397048899590623e-21,
  1.562423068691560e-23, -9.831337587943019e-26,  2.229757418369279e-03, -4.736954018269942e-05,  7.166941107274021e-07, -8.757947119322307e-09,  9.297482145000629e-11,
 -8.890088950603885e-13,  7.828859555395717e-15, -6.444859311459241e-17,  5.012516245930496e-19, -3.712392066765233e-21,  2.634203541253747e-23, -1.799350142337375e-25,
  1.105507036145710e-03, -2.829898086382735e-05,  4.908049740670237e-07, -6.773396998653250e-09,  8.034148438562692e-11, -8.517424665109833e-13,  8.266725225254530e-15,
 -7.464040296906939e-17,  6.341270446793780e-19, -5.112344528891500e-21,  3.936763114422585e-23, -2.910416993493774e-25,  5.117899225272316e-04, -1.557769321516925e-05,
  3.081497157823083e-07, -4.780841198625622e-09,  6.310952823561485e-11, -7.391726066487319e-13,  7.880913422810820e-15, -7.780451582517209e-17,  7.199466014675630e-19,
 -6.300590942396113e-21,  5.251269519551635e-23, -4.190939968144203e-25,  2.213543167908119e-04, -7.919382763035998e-06,  1.778293742654901e-07, -3.088932107922550e-09,
  4.522055334761285e-11, -5.833196487811798e-13,  6.812249512505517e-15, -7.333936012216988e-17,  7.372609951102257e-19, -6.986949278355836e-21,  6.288202824547969e-23,
 -5.405474970022171e-25,  8.950184578941781e-05, -3.726093965589074e-06,  9.454868267300008e-08, -1.831913915372680e-09,  2.964851171001472e-11, -4.200274211101951e-13,
  5.359247056570005e-15, -6.276755926543819e-17,  6.839666170462691e-19, -7.004254683618218e-21,  6.793166128532278e-23, -6.277526305619987e-25,  3.385740295428373e-05,
 -1.625757516934016e-06,  4.641766615898449e-08, -9.997607664534166e-10,  1.783704891503303e-11, -2.768253962647844e-13,  3.850158735637540e-15, -4.895228581875442e-17,
  5.770624651287974e-19, -6.373682384613774e-21,  6.649500367193054e-23, -6.594194940066634e-25,  1.199329115051482e-05, -6.590721691383437e-07,  2.108739387968375e-08,
 -5.033048369149173e-10,  9.873010745605282e-12, -1.674726934714228e-13,  2.533745778586391e-15, -3.490522289137178e-17,  4.443390029109707e-19, -5.284320972422589e-21,
  5.920758341806478e-23, -6.291237616398312e-25,  3.982314087936098e-06, -2.487220777584167e-07,  8.883877132697076e-09, -2.342797923866514e-10,  5.040741963868893e-12,
 -9.325803396295910e-14,  1.531901301551081e-15, -2.282643744743381e-17,  3.132815262917072e-19, -4.005490357481701e-21,  4.812880999822028e-23, -5.472024278095584e-25,
  1.240988872527666e-06, -8.754744574544426e-08,  3.478263866544529e-09, -1.010719562551399e-10,  2.379877728227515e-12, -4.792907645371185e-14,  8.533253638544735e-16,
 -1.373134499517712e-17,  2.028818006527572e-19, -2.784900756727222e-21,  3.583861499927273e-23, -4.354456229103578e-25,  3.634485634556482e-07, -2.880045793771241e-08,
  1.268452612393076e-09, -4.051000679828908e-11,  1.041685314208422e-12, -2.279539295923723e-14,  4.391722078049343e-16, -7.620597493334438e-18,  1.210500902481322e-19,
 -1.781671606044889e-21,  2.452682533735411e-23, -3.181029210625074e-25,  1.001994763104940e-07, -8.873947019282060e-09,  4.318760478991291e-10, -1.512218064199595e-11,
  4.238168726415448e-13, -1.006044699644999e-14,  2.094230874339798e-16, -3.913304284431575e-18,  6.674544102535406e-20, -1.052136730408646e-21,  1.547672587330209e-23,
 -2.140388943474260e-25,  2.605264833057423e-08, -2.566888032784472e-09,  1.376283991232660e-10, -5.271487454775478e-12,  1.607204830476359e-13, -4.131823359525177e-15,
  9.280126971572227e-17, -1.865019506959129e-18,  3.411569742714235e-20, -5.753328914893422e-22,  9.033868465895024e-24, -1.330916704375479e-25,  6.402461860224377e-09,
 -6.988412323594741e-10,  4.116252233218320e-11, -1.720867253336362e-12,  5.697471637708338e-14, -1.583872802505991e-15,  3.833127878049620e-17, -8.274993894597881e-19,
  1.621624742564615e-20, -2.922692556998507e-22,  4.894025140024101e-24, -7.673769653006784e-26,  1.490879524775964e-09, -1.795811260655684e-10,  1.158867089286193e-11,
 -5.277040838417038e-13,  1.893980021130289e-14, -5.685168819177182e-16,  1.480596420925412e-17, -3.429513648228144e-19,  7.192286899757729e-21, -1.384016962245877e-22,
  2.469185102590840e-24, -4.117018861563108e-26,  3.299121606869400e-10, -4.369450269791599e-11,  3.081279554143687e-12, -1.525190253374390e-13,  5.924291944603527e-15,
 -1.917413307940269e-16,  5.366925723722377e-18, -1.332338875859627e-19,  2.987138108890720e-21, -6.131389961460276e-23,  1.164432604073377e-24, -2.062834071506710e-26,
  6.960907228062982e-11, -1.010230461881650e-11,  7.765747556950166e-13, -4.170258432228865e-14,  1.750238349651959e-15, -6.099322315679888e-17,  1.832626551000237e-18,
 -4.870534316236415e-20,  1.166232961647315e-21, -2.551014249204904e-23,  5.152669596958144e-25, -9.690440164736093e-27,  1.405771346860905e-11, -2.228350817204006e-12,
  1.862804611832155e-13, -1.083184901078391e-14,  4.904136115417445e-16, -1.837599749875309e-17,  5.919630346981415e-19, -1.682411998362732e-20,  4.298053021024773e-22,
 -1.000963454748858e-23,  2.148436132917690e-25, -4.285833038909510e-27,  2.729363834103527e-12, -4.710711947091379e-13,  4.272463563036110e-14, -2.685020967902736e-15,
  1.309299191348868e-16, -5.267780870618031e-18,  1.817132155584772e-19, -5.516643562309787e-21,  1.502107054638876e-22, -3.720952208685248e-24,  8.479237018623026e-26,
 -1.792685839671238e-27,  5.120367240537227e-13, -9.593139169092536e-14,  9.418057089354233e-15, -6.384743278297268e-16,  3.347839962430615e-17, -1.444240072891050e-18,
  5.327999453661022e-20, -1.725855865345149e-21,  5.003318086483396e-23, -1.317015796423457e-24,  3.183397043043798e-26, -7.126739827381794e-28,  9.335566005067861e-14,
 -1.892921091259389e-14,  2.006984960980514e-15, -1.464900194600747e-16,  8.245969132838026e-18, -3.808621185864784e-19,  1.500677220209985e-20, -5.180334351182989e-22,
  1.597189937888010e-23, -4.462912812504475e-25,  1.143116731503966e-26, -2.707310770926641e-28,  1.665074167363695e-14, -3.642993451275249e-15,  4.161713479031264e-16,
 -3.264118448296837e-17,  1.969098934079262e-18, -9.722551341749577e-20,  4.085932738449253e-21, -1.501195149025112e-22,  4.916606400276173e-24, -1.456707612890475e-25,
  3.949655887040137e-27, -9.885904628560122e-29,  2.926944997004174e-15, -6.889061585236026e-16,  8.459455701744817e-17, -7.115094917311991e-18,  4.591634454389179e-19,
 -2.419693588241780e-20,  1.082969891875906e-21, -4.229014745788198e-23,  1.469390913943473e-24, -4.610646132389007e-26,  1.321789755564276e-27, -3.492597771973313e-29,
  5.113658764450862e-16, -1.290794465661243e-16,  1.699554558677602e-17, -1.529628105795199e-18,  1.053957276216031e-19, -5.917469562248197e-21,  2.816016413885830e-22,
 -1.167025444923371e-23,  4.295688156071797e-25, -1.425579845805780e-26,  4.315687832361692e-28, -1.202349003670528e-29,  8.963421693139228e-17, -2.418769254148458e-17,
  3.405967496004378e-18, -3.272729247292531e-19,  2.402689354130866e-20, -1.434505351803802e-21,  7.245584586077738e-23, -3.181390256186569e-24,  1.238622373389021e-25,
 -4.340906773219544e-27,  1.385713287917800e-28, -4.064872927671037e-30,  1.592895815584985e-17, -4.579947426118380e-18,  6.878220128236199e-19, -7.038715275234700e-20,
  5.493510516303296e-21, -3.480441689186821e-22,  1.862184236938011e-23, -8.646821843149067e-25,  3.554510296390392e-26, -1.313317659822826e-27,  4.413592254664644e-29,
 -1.361060622496790e-30,  2.903208124710330e-18, -8.863177806055052e-19,  1.415430042469969e-19, -1.538466655398672e-20,  1.273310853955284e-21, -8.540581891269863e-23,
  4.829893827449299e-24, -2.366758405390615e-25,  1.025206102478723e-26, -3.985818593908039e-28,  1.407563791637009e-29, -4.555005936569447e-31,  5.495259228009921e-19,
 -1.774760315211282e-19,  3.004217733025973e-20, -3.458089880298891e-21,  3.026759944741329e-22, -2.143737845550639e-23,  1.278237266952315e-24, -6.594562691617458e-26,
  3.003271666608834e-27, -1.225946003663071e-28,  4.539798660285514e-30, -1.538534020831682e-31,  1.094803821711137e-19, -3.725944959905437e-20,  6.662073175038334e-21,
 -8.094929642668907e-22,  7.470039540212008e-23, -5.570513411379987e-24,  3.492355266025575e-25, -1.891879802501657e-26,  9.035226148311478e-28, -3.862870233160706e-29,
  1.496403366207979e-30, -5.298557015590912e-32,  2.328127537724458e-20, -8.315005213242188e-21,  1.564477342696284e-21, -1.999491235375337e-22,  1.938744184341060e-23,
 -1.517254570316443e-24,  9.970294942693852e-26, -5.654269612639654e-27,  2.823556439674468e-28, -1.260782517914700e-29,  5.095271902875923e-31, -1.880023910429422e-32,
  5.359959827121454e-21, -2.000202118224631e-21,  3.943828959380956e-22, -5.280827443720747e-23,  5.359846309416584e-24, -4.386082363437520e-25,  3.010439621344613e-26,
 -1.781230927641916e-27,  9.270217389708960e-29, -4.309477393959640e-30,  1.811334487592288e-31, -6.943476463101048e-33,  1.354374211096764e-21, -5.256554678211493e-22,
  1.081255049270455e-22, -1.510291575637205e-23,  1.597871335444870e-24, -1.361743905716239e-25,  9.724151282868263e-27, -5.980205589830098e-28,  3.231744020637845e-29,
 -1.558511102235729e-30,  6.789237959558765e-32, -2.694715902170961e-33,  3.801599688345024e-22, -1.527100311961285e-22,  3.261066097272150e-23, -4.729087690056537e-24,
  5.191420627797089e-25, -4.586973401031970e-26,  3.393127752337582e-27, -2.159771431295768e-28,  1.206980942384493e-29, -6.014244135717458e-31,  2.704860897637745e-32,
 -1.107418584875522e-33,  1.195467148959225e-22, -4.945008123339999e-23,  1.090547549444635e-23, -1.633446516053928e-24,  1.851202916567388e-25, -1.687529000135043e-26,
  1.286979957649061e-27, -8.439322980300978e-29,  4.855245210104279e-30, -2.488802851186739e-31,  1.150661920893507e-32, -4.839276377879196e-34,  4.217314718469372e-23,
 -1.786873076255883e-23,  4.046911828911105e-24, -6.226051087070936e-25,  7.244977234832876e-26, -6.777714156396327e-27,  5.301522651418980e-28, -3.563468654401654e-29,
  2.100159410905324e-30, -1.102173333713925e-31,  5.214024538165581e-33, -2.242327626369511e-34,  1.645442471512362e-23, -7.102191536867601e-24,  1.642116376941949e-24,
 -2.579601326653373e-25,  3.064264669199999e-26, -2.925167810842282e-27,  2.333743934525005e-28, -1.599225758017647e-29,  9.604426792311452e-31, -5.133949001108577e-32,
  2.472639476283075e-33, -1.082080427706179e-34,  6.711782850040942e-24, -2.934690672633178e-24,  6.884464425365627e-25, -1.097438409124360e-25,  1.322642720979628e-26,
 -1.280673515933209e-27,  1.036044056683929e-28, -7.196680961774904e-30,  4.379759423340631e-31, -2.371628546697958e-32,  1.156736533171992e-33, -5.124616979751301e-35,
  2.245152243722464e-24, -9.887932894836993e-25,  2.338522326982599e-25, -3.758546544674155e-26,  4.566797860802709e-27, -4.457304726732222e-28,  3.634144806194402e-29,
 -2.543713836180189e-30,  1.559621887175950e-31, -8.506881331687628e-33,  4.178645664637477e-34, -1.864040620874095e-35,  5.276734250570296e-02, -1.144181675588582e-04,
  2.556522933563206e-07, -5.862680896688817e-10,  1.372562181058102e-12, -3.264708377489669e-15,  7.848670749000130e-18, -1.901426639012381e-20,  4.622536960628030e-23,
 -1.127474241002781e-25,  2.746523354973372e-28, -6.706740265158787e-31,  4.908288153397646e-02, -1.259455751707316e-04,  3.821031421558746e-07, -1.227068686460730e-09,
  3.955758710456931e-12, -1.258748490333987e-14,  3.940356801592104e-17, -1.214636964456827e-19,  3.692893954190563e-22, -1.109444076361255e-24,  3.297410458735836e-27,
 -9.709241548142110e-30,  4.246894672020039e-02, -1.428029751325215e-04,  6.006533100841424e-07, -2.496704765504654e-09,  9.941315924888581e-12, -3.814097322380215e-14,
  1.420516587753551e-16, -5.163282789249671e-19,  1.838357155484851e-21, -6.428893158378626e-24,  2.212790416863308e-26, -7.508716955567749e-29,  3.418325693399011e-02,
 -1.558961141342784e-04,  8.506567187983565e-07, -4.290266283916111e-09,  2.025086244900237e-11, -9.105704601032538e-14,  3.940913505241655e-16, -1.652533251176796e-18,
  6.745288896397121e-21, -2.689544271890781e-23,  1.050477566968328e-25, -4.027933639882365e-28,  2.559720791316140e-02, -1.577837203307283e-04,  1.061689024553029e-06,
 -6.329433260045314e-09,  3.483631764539414e-11, -1.808529410833284e-13,  8.962532242776106e-16, -4.273742379964539e-18,  1.972302683218184e-20, -8.847653865532832e-23,
  3.871294461929369e-25, -1.656662588769125e-27,  1.783444054060660e-02, -1.458545059523694e-04,  1.175456552806788e-06, -8.176683637260514e-09,  5.188802448554138e-11,
 -3.075433142337782e-13,  1.726357273030065e-15, -9.265350981581059e-18,  4.787206182426447e-20, -2.393495624630502e-22,  1.162661320452844e-24, -5.504516944839609e-27,
  1.156324953490389e-02, -1.226814412649591e-04,  1.164775189803421e-06, -9.369593859042198e-09,  6.793571234816164e-11, -4.557095744696266e-13,  2.873861236222472e-15,
 -1.722587364877041e-17,  9.891144102271192e-20, -5.472879562495121e-22,  2.931342078515966e-24, -1.525310054664593e-26,  6.978091474962720e-03, -9.396721164692896e-05,
  1.040331604880631e-06, -9.605832092603642e-09,  7.898880210434444e-11, -5.955185106847575e-13,  4.191946005500138e-15, -2.789067608192808e-17,  1.769448689725018e-19,
 -1.077457310542913e-21,  6.329149686720687e-24, -3.600860885388150e-26,  3.920414028296628e-03, -6.569354106762672e-05,  8.419615163136671e-07, -8.866027055407765e-09,
  8.217381538391280e-11, -6.923866902797303e-13,  5.411564236298899e-15, -3.976779030357399e-17,  2.774372459595127e-19, -1.850747266192277e-21,  1.187104903819107e-23,
 -7.353363429769396e-26,  2.051114760173612e-03, -4.203236749353686e-05,  6.199690501370761e-07, -7.402965020669945e-09,  7.693626909235148e-11, -7.210750512547590e-13,
  6.230133079057812e-15, -5.035805525265333e-17,  3.848067011179660e-19, -2.801591990140498e-21,  1.955086783306326e-23, -1.313940255463173e-25,  9.996784424536657e-04,
 -2.467703922383412e-05,  4.167079144202780e-07, -5.614103632187539e-09,  6.513253126805900e-11, -6.762870137134774e-13,  6.435244737807197e-15, -5.701252764194341e-17,
  4.755895364011271e-19, -3.766920039212538e-21,  2.851234201436130e-23, -2.072849449203220e-25,  4.540690337822237e-04, -1.332587034606458e-05,  2.563816544823577e-07,
 -3.879776063472155e-09,  5.005364972603091e-11, -5.737656092507449e-13,  5.993518272268523e-15, -5.802348758142804e-17,  5.268736399013400e-19, -4.527531724370089e-21,
  3.707235125282088e-23, -2.908088856902435e-25,  1.923035613008186e-04, -6.633548733425728e-06,  1.447453476547027e-07, -2.450504266989024e-09,  3.503561796043799e-11,
 -4.420178937215112e-13,  5.054435988067946e-15, -5.332904751581182e-17,  5.258022753771523e-19, -4.890406584173531e-21,  4.322002574075628e-23, -3.650148387805287e-25,
  7.598162046605109e-05, -3.050167810856000e-06,  7.515586041977861e-08, -1.418309518045674e-09,  2.240368324674728e-11, -3.102376642529826e-13,  3.873713069843146e-15,
 -4.444031382599498e-17,  4.747220427175516e-19, -4.768963029777363e-21,  4.539926682383194e-23, -4.120103113497905e-25,  2.802740683439872e-05, -1.297943353324856e-06,
  3.596526341014675e-08, -7.540704701325072e-10,  1.312350234343298e-11, -1.989778714606511e-13,  2.706879736296044e-15, -3.369606006094419e-17,  3.892257441181992e-19,
 -4.215491685708918e-21,  4.315128846071769e-23, -4.200994112894618e-25,  9.659630388983705e-06, -5.120808236647354e-07,  1.589487245711365e-08, -3.691337829301928e-10,
  7.060104179765335e-12, -1.169449033830247e-13,  1.729834430792327e-15, -2.332225479280064e-17,  2.908038201513294e-19, -3.389977331084272e-21,  3.725496414317775e-23,
 -3.884989533944235e-25,  3.113526427622735e-06, -1.876551845077196e-07,  6.500803125218485e-09, -1.667501185267291e-10,  3.496801317229726e-12, -6.315029447925168e-14,
  1.013832428837892e-15, -1.477955719732131e-17,  1.986190268205586e-19, -2.488450652619450e-21,  2.931912619926010e-23, -3.270560569501376e-25,  9.395960405792724e-07,
 -6.399168403147597e-08,  2.465512096264691e-09, -6.966844840584063e-11,  1.598383194039150e-12, -3.141297950374255e-14,  5.464415563177362e-16, -8.600172121773006e-18,
  1.243892256356368e-19, -1.672729949844626e-21,  2.110258089566069e-23, -2.515063991573068e-25,  2.658218210592768e-07, -2.034523793326743e-08,  8.689636236829705e-10,
 -2.698299466230105e-11,  6.759285956747879e-13, -1.443118110865502e-14,  2.715897599352770e-16, -4.608280812960875e-18,  7.164246402502527e-20, -1.032818189571452e-21,
  1.393558531538689e-23, -1.772585687872838e-25,  7.060903256315245e-08, -6.043211525675389e-09,  2.852487681809607e-10, -9.711016575057529e-12,  2.651071283277523e-13,
 -6.138954196675433e-15,  1.248140901772676e-16, -2.280295755953982e-18,  3.805950150029846e-20, -5.875510722981064e-22,  8.470027263615339e-24, -1.148690431888429e-25,
  1.764084673847120e-08, -1.680750341975513e-09,  8.742104566991045e-11, -3.255796844771130e-12,  9.669104332830335e-14, -2.424778759142129e-15,  5.318869380377236e-17,
 -1.045025178737426e-18,  1.870510624822563e-20, -3.089061593999482e-22,  4.753186199589401e-24, -6.866586602933928e-26,  4.153981606875421e-09, -4.387635246349334e-10,
  2.507901079927607e-11, -1.019642714806082e-12,  3.288623211013275e-14, -8.918426579361697e-16,  2.107976620070265e-17, -4.448991435862100e-19,  8.531144405272006e-21,
 -1.505709032226084e-22,  2.470743943083662e-24, -3.798838228582447e-26,  9.241421089463171e-10, -1.078031338545978e-10,  6.753851102116926e-12, -2.991729019106624e-13,
  1.046217962218599e-14, -3.063989954675490e-16,  7.794220724699984e-18, -1.765180257833215e-19,  3.622602738124101e-21, -6.826962594242145e-23,  1.193640625291787e-24,
 -1.951703157188456e-26,  1.947842963659552e-10, -2.500534017384293e-11,  1.712854785936749e-12, -8.250783165421079e-14,  3.123564854222733e-15, -9.865750776717939e-17,
  2.697858209117582e-18, -6.549457306006643e-20,  1.437185162644602e-21, -2.889441514030694e-23,  5.378554036165216e-25, -9.345180483046241e-27,  3.902259258864507e-11,
 -5.494577237247917e-12,  4.105466509058154e-13, -2.146536447263452e-14,  8.783926063621871e-16, -2.988270314614231e-17,  8.774447397747624e-19, -2.281052606538155e-20,
  5.347094001486704e-22, -1.145892163352773e-23,  2.269111575890533e-25, -4.186327926989191e-27,  7.458537936020050e-12, -1.148254608745577e-12,  9.337170064213819e-14,
 -5.289422058567409e-15,  2.336167621611503e-16, -8.549299497179787e-18,  2.692483350472900e-19, -7.487909560740969e-21,  1.873355169156957e-22, -4.275662085208620e-24,
  8.999799997770872e-26, -1.761734616279689e-27,  1.365994933556052e-12, -2.292356596546008e-13,  2.024145572686140e-14, -1.240161845748863e-15,  5.902998799231568e-17,
 -2.320797126496546e-18,  7.830522973470548e-20, -2.327280748727498e-21,  6.208438359293902e-23, -1.507823145665739e-24,  3.370924079045728e-26, -6.996107944919783e-28,
  2.409203397018108e-13, -4.394150077755325e-14,  4.204019759918117e-15, -2.780818672242071e-16,  1.424337662614856e-17, -6.008257508317687e-19,  2.169353137467248e-20,
 -6.883108973664758e-22,  1.956034116633617e-23, -5.050607529838845e-25,  1.198256864941842e-26, -2.634595694291976e-28,  4.115518400968457e-14, -8.134562759049517e-15,
  8.414035444517753e-16, -5.997939925676582e-17,  3.300809086986807e-18, -1.491905881080809e-19,  5.757416868025498e-21, -1.948062447183722e-22,  5.891353823416607e-24,
 -1.615749319197388e-25,  4.064479865964224e-27, -9.459335208232262e-29,  6.854354436188308e-15, -1.463954458685820e-15,  1.633492318654704e-16, -1.252572287076034e-17,
  7.394435791203874e-19, -3.575992546294888e-20,  1.473102333900271e-21, -5.309110102937089e-23,  1.706808785132894e-24, -4.967023925684987e-26,  1.323541391217062e-27,
 -3.257532654621566e-29,  1.121427771788440e-15, -2.580554847995467e-16,  3.099105000033927e-17, -2.551377966897545e-18,  1.612979102033945e-19, -8.333644259181774e-21,
  3.659522748147741e-22, -1.403061529549581e-23,  4.789368056558897e-25, -1.477271208378691e-26,  4.165385351904257e-28, -1.083089648033222e-29,  1.817851254148295e-16,
 -4.493450737691265e-17,  5.794433498200305e-18, -5.111164136746164e-19,  3.454152020979091e-20, -1.903497082603925e-21,  8.896980139068174e-23, -3.623701662606510e-24,
  1.311668771339709e-25, -4.282919486045097e-27,  1.276372949975987e-28, -3.502301844808761e-30,  2.948024770090900e-17, -7.803417663216037e-18,  1.077807594319816e-18,
 -1.016424038045376e-19,  7.328469620825600e-21, -4.299812224773007e-22,  2.135593650546807e-23, -9.225927832709226e-25,  3.536016753078507e-26, -1.220556697416976e-27,
  3.839365993288582e-29, -1.110309908740859e-30,  4.835091001295858e-18, -1.366091461099965e-18,  2.015603304983513e-19, -2.027392921429722e-20,  1.556175003898057e-21,
 -9.701871400668313e-23,  5.110873657550898e-24, -2.337794814132828e-25,  9.471532322155985e-27, -3.450657343219363e-28,  1.143945909408715e-29, -3.481443732092257e-31,
  8.117418789757653e-19, -2.439638981586575e-19,  3.834164543361633e-20, -4.102782048166987e-21,  3.344603284671691e-22, -2.210724758358504e-23,  1.232630555547764e-24,
 -5.957979374705643e-26,  2.546814531922149e-27, -9.775208403858756e-29,  3.409343159043019e-30, -1.090076117035533e-31,  1.413586106364649e-19, -4.502784076207751e-20,
  7.514251857952414e-21, -8.529543063306464e-22,  7.365119801381223e-23, -5.148402413460887e-24,  3.031063231581569e-25, -1.544646798016395e-26,  6.951307153342194e-28,
 -2.804999482740732e-29,  1.027166161192499e-30, -3.443559857377957e-32,  2.590192418890368e-20, -8.710763855178412e-21,  1.538259323861346e-21, -1.846380788562485e-22,
  1.683697794547825e-23, -1.241157066034068e-24,  7.694796365440117e-26, -4.123555624793785e-27,  1.948782617138974e-28, -8.247468083334214e-30,  3.163582524836998e-31,
 -1.109541579985919e-32,  5.070149438972370e-21, -1.792709693379537e-21,  3.337436803117983e-22, -4.221028419170408e-23,  4.051257699556712e-24, -3.139263684122032e-25,
  2.043187807592523e-26, -1.147984467935947e-27,  5.681188348369107e-29, -2.514694762384828e-30,  1.007694983300161e-31, -3.687723869647906e-33,  1.076802479336795e-21,
 -3.985370567870693e-22,  7.789305390491287e-23, -1.033960491860402e-23,  1.040554647330908e-24, -8.445072761530122e-26,  5.750119005075402e-27, -3.375921784214095e-28,
  1.743770519209351e-29, -8.047292129116112e-31,  3.358492007454499e-32, -1.278617588121489e-33,  2.519375713043877e-22, -9.714566753264112e-23,  1.984273164742997e-23,
 -2.752347876161535e-24,  2.892143890754425e-25, -2.448436921603216e-26,  1.737175690508804e-27, -1.061669963914956e-28,  5.702597513107241e-30, -2.733924400849015e-31,
  1.184170480957193e-32, -4.674136542235381e-34,  6.583741819397953e-23, -2.631678261070984e-23,  5.589805468714307e-24, -8.062927041049109e-25,  8.804948601454102e-26,
 -7.740176667583366e-27,  5.697326009027433e-28, -3.609003112499976e-29,  2.007473416004905e-30, -9.957722906102123e-32,  4.458731204637414e-33, -1.817715634855885e-34,
  1.941647963952670e-23, -8.003405963882215e-24,  1.758243330017827e-24, -2.623405148296862e-25,  2.961909164372804e-26, -2.690090701084633e-27,  2.044226846404206e-28,
 -1.335828456185287e-29,  7.659203964095276e-31, -3.913225971851695e-32,  1.803455738465454e-33, -7.561275080185704e-35,  6.483056867803335e-24, -2.740545218834706e-24,
  6.190987869091954e-25, -9.500322617445610e-26,  1.102734742616068e-26, -1.029085432940137e-27,  8.030285977494039e-29, -5.385104419849611e-30,  3.166595608060851e-31,
 -1.658201072831443e-32,  7.827703529032046e-34, -3.359410536056868e-35,  2.420410152425762e-24, -1.043315081320018e-24,  2.408668729527454e-25, -3.778085923076663e-26,
  4.481274027011109e-27, -4.271655712760361e-28,  3.403177705204752e-29, -2.328859729909612e-30,  1.396764689797118e-31, -7.456541337688939e-33,  3.586709688966807e-34,
 -1.567693185793219e-35,  9.565840854634043e-25, -4.179862955606627e-25,  9.798269348534823e-26, -1.560758465191006e-26,  1.879655781366251e-27, -1.818698138116787e-28,
  1.470258966088807e-29, -1.020583537291416e-30,  6.206897383616025e-32, -3.358815890289636e-33,  1.637179423690882e-34, -7.248584793096121e-36,  3.142893432301248e-25,
 -1.383797033468316e-25,  3.271717972551418e-26, -5.256775189893424e-27,  6.385237759825618e-28, -6.230244672992646e-29,  5.078138835199971e-30, -3.553386052337006e-31,
  2.178048527811081e-32, -1.187667823228995e-33,  5.832286146807597e-35, -2.600997336977045e-36,  5.231371623639049e-02, -1.124007216401480e-04,  2.487467202074685e-07,
 -5.648193915015694e-10,  1.309109418348177e-12, -3.082565598112552e-15,  7.336384855789152e-18, -1.759793313671540e-20,  4.235730433411327e-23, -1.023292378576503e-25,
  2.467915616783270e-28, -5.972558222836734e-31,  4.858512112054750e-02, -1.229465921688604e-04,  3.677499263524911e-07, -1.165740295199009e-09,  3.713197136975112e-12,
 -1.168131173720284e-14,  3.616219861801267e-17, -1.102608318383752e-19,  3.316241231494243e-22, -9.857062172299327e-25,  2.898678554649731e-27, -8.446143058649289e-30,
  4.190715926558706e-02, -1.381149432374060e-04,  5.716226330620668e-07, -2.343565829588243e-09,  9.211451295462356e-12, -3.489878011483726e-14,  1.283844393105253e-16,
 -4.610393207992524e-19,  1.622084116966434e-21, -5.606449425728191e-24,  1.907505243778621e-26, -6.399196254577359e-29,  3.357296452268164e-02, -1.492914200752634e-04,
  8.010591312241937e-07, -3.980323021447126e-09,  1.852067786990985e-11, -8.213058029673453e-14,  3.507023379578508e-16, -1.451398236275112e-18,  5.848604041188114e-21,
 -2.302753807884896e-23,  8.883027065661959e-26, -3.364643873936275e-28,  2.498259204334483e-02, -1.495848129527105e-04,  9.889644265989536e-07, -5.799859373683343e-09,
  3.142502322284398e-11, -1.607103623330568e-13,  7.849660283922921e-16, -3.690716283079241e-18,  1.679989349198452e-20, -7.435613777211689e-23,  3.210767983484292e-25,
 -1.356268672715174e-27,  1.726922772027459e-02, -1.368296740675960e-04,  1.082121679326503e-06, -7.393516196564438e-09,  4.613133210987181e-11, -2.690584444004637e-13,
  1.487140120565306e-15, -7.862787664154018e-18,  4.003734783797411e-20, -1.973477321301470e-22,  9.453590786746024e-25, -4.414881265185127e-27,  1.109047328752651e-02,
 -1.137951708580234e-04,  1.058572829668691e-06, -8.351946259320272e-09,  5.947395332332880e-11, -3.921845618268900e-13,  2.433041224162322e-15, -1.435456560481636e-17,
  8.116734285202022e-20, -4.424319422320491e-22,  2.335282555820645e-24, -1.197849385631603e-26,  6.618167072277955e-03, -8.608502474114231e-05,  9.322685105847808e-07,
 -8.432082373397625e-09,  6.802440365834918e-11, -5.036774084567460e-13,  3.484778377742775e-15, -2.280313322470249e-17,  1.423557652603994e-19, -8.533546296032889e-22,
  4.936645415248251e-24, -2.766908731216243e-26,  3.670467652977712e-03, -5.936207534791364e-05,  7.430227685085190e-07, -7.655332497799782e-09,  6.953959859705727e-11,
 -5.749263499079764e-13,  4.412960230614421e-15, -3.187015848348094e-17,  2.186311853456153e-19, -1.434827939728155e-21,  9.057935827555988e-24, -5.524256652767719e-26,
  1.892370331855271e-03, -3.740807628306911e-05,  5.380685061185069e-07, -6.279688147192209e-09,  6.390260253074733e-11, -5.871687661023949e-13,  4.978352679307625e-15,
 -3.951765066244645e-17,  2.967355610579686e-19, -2.124057832545129e-21,  1.458010190853517e-23, -9.642245589665834e-26,  9.072346614605145e-04, -2.159611284550690e-05,
  3.551708149991954e-07, -4.672310845066011e-09,  5.303032871281211e-11, -5.393954708149133e-13,  5.033043227516599e-15, -4.375997542975813e-17,  3.584854910791932e-19,
 -2.790008895551796e-21,  2.076089871294076e-23, -1.484444875606689e-25,  4.045909274412694e-04, -1.144825572478387e-05,  2.142746926037243e-07, -3.163424557782127e-09,
  3.989442714665105e-11, -4.476528461657130e-13,  4.582301130663288e-15, -4.350847844904034e-17,  3.877526680838723e-19, -3.272290510006633e-21,  2.632759932336976e-23,
 -2.030213779196428e-25,  1.679116725036701e-04, -5.584311903447316e-06,  1.184310247310595e-07, -1.954541716095614e-09,  2.729655139280625e-11, -3.368801684599202e-13,
  3.772523653177054e-15, -3.901566864208051e-17,  3.773465927929325e-19, -3.444962098103141e-21,  2.990117407198809e-23, -2.481372802341355e-25,  6.488367168472753e-05,
 -2.511346707369221e-06,  6.009741966638166e-08, -1.104831393965592e-09,  1.703607186552005e-11, -2.306308305901098e-13,  2.818557482624968e-15, -3.167829373054151e-17,
  3.317805545790650e-19, -3.270051750664764e-21,  3.055998864460102e-23, -2.724031174715914e-25,  2.335843601462686e-05, -1.043128045321243e-06,  2.805556321642207e-08,
 -5.726982714953767e-10,  9.723892854825868e-12, -1.440563455779520e-13,  1.917129750134341e-15, -2.336893003337642e-17,  2.645409484878280e-19, -2.809800242379120e-21,
  2.822425231943403e-23, -2.697855078821880e-25,  7.840064811229826e-06, -4.008840485397536e-07,  1.207259617166234e-08, -2.728320551890803e-10,  5.088462474546666e-12,
 -8.231686100906535e-14,  1.190616631287090e-15, -1.571198040000540e-17,  1.919193282749498e-19, -2.193250032213815e-21,  2.364414521711680e-23, -2.420043821267370e-25,
  2.455471775408939e-06, -1.427896840123580e-07,  4.797742359642477e-09, -1.197120729210636e-10,  2.446983081653157e-12, -4.314137094158960e-14,  6.769827021958618e-16,
 -9.656212235646340e-18,  1.270790777925671e-19, -1.560318355319303e-21,  1.802810035923879e-23, -1.973285794397227e-25,  7.183388958661117e-07, -4.722040675618746e-08,
  1.764305430080029e-09, -4.848227497531042e-11,  1.083872463547609e-12, -2.078856046176547e-14,  3.533573061127425e-16, -5.439751206351867e-18,  7.702584715272792e-20,
 -1.014825638947109e-21,  1.255173681843301e-23, -1.467510391040136e-25,  1.965268699059941e-07, -1.452469489361211e-08,  6.015699084218931e-10, -1.816258812759160e-11,
  4.432408823183015e-13, -9.233206315334881e-15,  1.697509020517804e-16, -2.816661999066684e-18,  4.285958703097329e-20, -6.052268790647070e-22,  8.004472587879763e-24,
 -9.986081997354286e-26,  5.035283979630326e-08, -4.163613346505428e-09,  1.905885005739262e-10, -6.308239178802474e-12,  1.677478223375628e-13, -3.789402380683452e-15,
  7.525115240978582e-17, -1.344197036478653e-18,  2.195552172152414e-20, -3.319508266986802e-22,  4.689869691475540e-24, -6.237330296046191e-26,  1.210192444057591e-08,
 -1.114640181036849e-09,  5.623362169879518e-11, -2.036198240093635e-12,  5.890094034284717e-14, -1.440837387078722e-15,  3.086699187476252e-17, -5.928983676226320e-19,
  1.038433981385509e-20, -1.679386358652770e-22,  2.532311535456399e-24, -3.587210457177072e-26,  2.733741663300851e-09, -2.793252240912745e-10,  1.549043701772996e-11,
 -6.124082858114024e-13,  1.923991335979266e-14, -5.089655382209377e-16,  1.174876860644036e-17, -2.424129755892115e-19,  4.548350456412267e-21, -7.861038753335173e-23,
  1.264045749464244e-24, -1.905722146784233e-26,  5.817315428441006e-10, -6.569408307119328e-11,  3.994763200886438e-12, -1.721091323401549e-13,  5.863610647052475e-15,
 -1.675272366168484e-16,  4.162253920959769e-18, -9.215875629442107e-20,  1.850718643974112e-21, -3.415523639473193e-23,  5.852168473962971e-25, -9.383153795808456e-27,
  1.169251800737175e-10, -1.454312582805040e-11,  9.674020654056012e-13, -4.533899386752958e-14,  1.672621260584705e-15, -5.154868831694573e-17,  1.377002038587386e-18,
 -3.268684633010510e-20,  7.019513923303270e-22, -1.382194093636494e-23,  2.521638014335197e-25, -4.296797012024543e-27,  2.226728000082724e-11, -3.040558823990439e-12,
  2.207525683290529e-13, -1.123482798258710e-14,  4.481684839578940e-16, -1.488130644196759e-17,  4.269527645370807e-19, -1.085542375062776e-20,  2.490847126426460e-22,
 -5.229010499896064e-24,  1.015022658650121e-25, -1.836847897226310e-27,  4.032540858484182e-12, -6.026534333333682e-13,  4.765164136391410e-14, -2.629043838127785e-15,
  1.132448728878240e-16, -4.046563245002995e-18,  1.245664797106601e-19, -3.389221963044766e-21,  8.302469759877562e-23, -1.856777579531842e-24,  3.832225792406533e-26,
 -7.360258541477579e-28,  6.973986812228756e-13, -1.137354095141810e-13,  9.773375732559221e-15, -5.835778480446102e-16,  2.710605446256828e-17, -1.041096643032260e-18,
  3.435065433775759e-20, -9.992331407248497e-22,  2.611073687091364e-23, -6.216108856072616e-25,  1.363120510286379e-26, -2.776685858895316e-28,  1.157470582956351e-13,
 -2.054056463822076e-14,  1.914237407535533e-15, -1.234984329044283e-16,  6.176925382021402e-18, -2.547036607756112e-19,  8.998118904233454e-21, -2.795807288198984e-22,
  7.786310972165273e-24, -1.971668879386243e-25,  4.590422338241783e-27, -9.910390478037208e-29,  1.854131212899012e-14, -3.570378411619636e-15,  3.601066272565186e-16,
 -2.505978959521544e-17,  1.347765528182777e-18, -5.959080017919741e-20,  2.251608991527528e-21, -7.465231703472658e-23,  2.213845945138859e-24, -5.957834604823598e-26,
  1.471529934785209e-27, -3.364561580832422e-29,  2.885576071159105e-15, -6.012638149086034e-16,  6.549440998621695e-17, -4.907732259771258e-18,  2.834010710840080e-19,
 -1.341851693684530e-20,  5.416401531475690e-22, -1.914243657639898e-23,  6.038906397786084e-25, -1.725616947980284e-26,  4.517691415391694e-28, -1.093059189365647e-29,
  4.396210739193299e-16, -9.884243819898244e-17,  1.160297233673094e-17, -9.345300371143424e-19,  5.785193825155191e-20, -2.929242186145664e-21,  1.261561334972141e-22,
 -4.747122209466321e-24,  1.591418197723114e-25, -4.823702855879174e-27,  1.337313100969173e-28, -3.420852301994289e-30,  6.613806895659747e-17, -1.599893350527729e-17,
  2.019423639355860e-18, -1.744891997148171e-19,  1.156021858261396e-20, -6.250002496157791e-22,  2.868002297291314e-23, -1.147577210008235e-24,  4.083286459205730e-26,
 -1.311375938273157e-27,  3.845879968408432e-29, -1.039022385406812e-30,  9.923191583079544e-18, -2.574887938094710e-18,  3.486354356267051e-19, -3.225043766267992e-20,
  2.282481549814691e-21, -1.315440679240630e-22,  6.421643008271543e-24, -2.728372207456534e-25,  1.029004485347265e-26, -3.497019889943176e-28,  1.083553886190973e-29,
 -3.088125531228713e-31,  1.501563079110999e-18, -4.166235167807454e-19,  6.035640356200791e-20, -5.963950448676399e-21,  4.499826147274741e-22, -2.759279388852848e-23,
  1.430500970804993e-24, -6.443002238236229e-26,  2.571657536143234e-27, -9.234528153582814e-29,  3.018806126957691e-30, -9.063583652047871e-32,  2.320515056487949e-19,
 -6.861503385617874e-20,  1.060615668025242e-20, -1.116700001505481e-21,  8.961874657685679e-23, -5.834644308813800e-24,  3.205973353011305e-25, -1.527863110416959e-26,
  6.442304623539548e-28, -2.440156077012015e-29,  8.402120117028683e-31, -2.653257032487419e-32,  3.713832207492452e-20, -1.166091343115445e-20,  1.917367644028124e-21,
 -2.145106528681362e-22,  1.826399084092353e-23, -1.259443649281166e-24,  7.317881128149008e-26, -3.682049802103909e-27,  1.636719814567112e-28, -6.526142095122468e-30,
  2.362328977600609e-31, -7.831474385240651e-33,  6.249735946384388e-21, -2.075738072964224e-21,  3.618386180767230e-22, -4.288189622423690e-23,  3.862244140133000e-24,
 -2.813145823386816e-25,  1.723925662671074e-26, -9.135028839142764e-28,  4.270436622749941e-29, -1.788329635265976e-30,  6.789918558575316e-32, -2.357920969426205e-33,
  1.124007709520078e-21, -3.932584363928433e-22,  7.240442799302209e-23, -9.057769415738472e-24,  8.601381343117085e-25, -6.596588613052706e-26,  4.250618701460902e-27,
 -2.365200134574082e-28,  1.159551590816178e-29, -5.086052699728589e-31,  2.020178299975028e-32, -7.330043559796661e-34,  2.197327223377607e-22, -8.062350250740136e-23,
  1.561310635349688e-23, -2.053684289281277e-24,  2.048472998017082e-25, -1.648219320006712e-26,  1.112878642862871e-27, -6.480882692956086e-29,  3.321315045500288e-30,
 -1.521085782789064e-31,  6.301321350014778e-33, -2.381848792589640e-34,  4.748555293508770e-23, -1.818465043964994e-23,  3.687009790378926e-24, -5.076796159908255e-25,
  5.296534429198113e-26, -4.452787150564024e-27,  3.137954869807065e-28, -1.905200344869562e-29,  1.016852891016261e-30, -4.844952841440730e-32,  2.086004826703061e-33,
 -8.186225025482969e-35,  1.152264090498351e-23, -4.581929898294734e-24,  9.677335759698878e-25, -1.388047241594226e-25,  1.507446202626809e-26, -1.318052121072381e-27,
  9.651305732002065e-29, -6.082781609809348e-30,  3.366899527371254e-31, -1.662146714324514e-32,  7.408172320273524e-34, -3.006632373264578e-35,  3.178533636030393e-24,
 -1.305317172815002e-24,  2.855950187159188e-25, -4.243931532318570e-26,  4.772435747435193e-27, -4.317620901557934e-28,  3.268607510519088e-29, -2.128079186719676e-30,
  1.215824199715995e-31, -6.190384596334861e-33,  2.843334086941592e-34, -1.188238224440035e-35,  1.001995689044640e-24, -4.225345279120771e-25,  9.519473750720585e-26,
 -1.456854664013507e-26,  1.686531539440444e-27, -1.569814099849331e-28,  1.221887937885583e-29, -8.173889381664754e-31,  4.795036329840477e-32, -2.505133766053835e-33,
  1.179917063097624e-34, -5.052824608680028e-36,  3.571953125276405e-25, -1.537496734211971e-25,  3.543949970707212e-26, -5.549966815135836e-27,  6.572626285832495e-28,
 -6.255585409175133e-29,  4.976311678707564e-30, -3.400438136059518e-31,  2.036576323232466e-32, -1.085719793433250e-33,  5.215500648445740e-35, -2.276659036721559e-36,
  1.365571599129788e-25, -5.962821570778770e-26,  1.396692919117345e-26, -2.223032897445695e-27,  2.675170368542762e-28, -2.586445633582103e-29,  2.089362128281324e-30,
 -1.449283690530017e-31,  8.807896674948158e-33, -4.763041639258446e-34,  2.320077879278236e-35, -1.026539878279830e-36,  4.402560218990402e-26, -1.937876399996782e-26,
  4.580273444966360e-27, -7.356893427025212e-28,  8.933310248613893e-29, -8.713698676122736e-30,  7.100130175840056e-31, -4.966733053258009e-32,  3.043442462843548e-33,
 -1.659067632102895e-34,  8.144827541843082e-36, -3.631279601500130e-37,  5.186805086767732e-02, -1.104375077556850e-04,  2.420925580579882e-07, -5.443574494775047e-10,
  1.249179704011917e-12, -2.912255440109137e-15,  6.862078286007978e-18, -1.629958602310917e-20,  3.884498831688022e-23, -9.296351770026510e-26,  2.219657348704980e-28,
 -5.325308914658231e-31,  4.809913155726930e-02, -1.200595557569416e-04,  3.541099500015624e-07, -1.108152023899538e-09,  3.488005819442889e-12, -1.084929946313769e-14,
  3.321828372384784e-17, -1.001949556841285e-19,  2.981392295954860e-22, -8.768596426351222e-25,  2.551572366072398e-27, -7.358021301866606e-30,  4.136367081236757e-02,
 -1.336519997978202e-04,  5.443616397887346e-07, -2.201603286276105e-09,  8.543271862288909e-12, -3.196677868820727e-14,  1.161727087591572e-16, -4.122200178692470e-19,
  1.433333746140773e-21, -4.896890306758528e-24,  1.647102766862909e-26, -5.463398757616586e-29,  3.298832023494202e-02, -1.430690868405375e-04,  7.550204783672530e-07,
 -3.696689198926348e-09,  1.695904918916019e-11, -7.418098760902257e-14,  3.125634634770787e-16, -1.276848930805408e-18,  5.080157755776891e-21, -1.975352709046654e-23,
  7.526917159759764e-26, -2.816631786468821e-28,  2.439964718636215e-02, -1.419431809831642e-04,  9.222800697621811e-07, -5.321783137903245e-09,  2.839114105274529e-11,
 -1.430528974757121e-13,  6.887669279421884e-16, -3.193582259442637e-18,  1.434055828135786e-20, -6.263129443106211e-23,  2.669347100411645e-25, -1.113157663011344e-27,
  1.673867825431079e-02, -1.285154384192020e-04,  9.976565975217365e-07, -6.696597333843130e-09,  4.108996533037065e-11, -2.358705158638932e-13,  1.283900664592550e-15,
 -6.688330242223549e-18,  3.356914624672597e-20, -1.631497232842374e-22,  7.708251304613610e-25, -3.551347991169980e-27,  1.065161709867658e-02, -1.057118808912700e-04,
  9.638100483527772e-07, -7.460071407669023e-09,  5.218309249700423e-11, -3.383353025010067e-13,  2.065204717651048e-15, -1.199500548431469e-17,  6.680149578791826e-20,
 -3.587672926246215e-22,  1.866429241153599e-24, -9.438581333344066e-27,  6.288127579142621e-03, -7.901385108058768e-05,  8.372955858412236e-07, -7.419944324548052e-09,
  5.873802946111092e-11, -4.272169018382617e-13,  2.905706196620590e-15, -1.870342982070208e-17,  1.149143246173347e-19, -6.782485519177789e-22,  3.864680647856606e-24,
 -2.134230876907620e-26,  3.444351506990650e-03, -5.376727234096943e-05,  6.574729729000132e-07, -6.629222404321498e-09,  5.903179251990423e-11, -4.789784481365954e-13,
  3.611249584945663e-15, -2.563498610145782e-17,  1.729528739683262e-19, -1.116837509506014e-21,  6.940220124491674e-24, -4.168017075360410e-26,  1.750893279376272e-03,
 -3.338842386960408e-05,  4.684794120113027e-07, -5.345059507894690e-09,  5.326966541155974e-11, -4.799600633280526e-13,  3.994057457705469e-15, -3.114081652795518e-17,
  2.298190576835565e-19, -1.617658508747325e-21,  1.092398022670731e-23, -7.110019695476924e-26,  8.261971814908540e-04, -1.896537221535599e-05,  3.038581703510066e-07,
 -3.903960180647495e-09,  4.335742749151720e-11, -4.320968793260486e-13,  3.954338611808011e-15, -3.374717010401165e-17,  2.715418159774333e-19, -2.076919964021084e-21,
  1.519569926883854e-23, -1.068772739761239e-25,  3.620003482326166e-04, -9.875694848181044e-06,  1.798662937560622e-07, -2.591153159157233e-09,  3.194925482008776e-11,
 -3.509963472503293e-13,  3.521421086994706e-15, -3.279825993807069e-17,  2.869332116658861e-19, -2.378415154912811e-21,  1.880540957479151e-23, -1.425767235060102e-25,
  1.473306210079542e-04, -4.723738892223883e-06,  9.738962847343235e-08, -1.567126620948411e-09,  2.138246017861332e-11, -2.581912199458614e-13,  2.832021884518437e-15,
 -2.871383145870657e-17,  2.724605251838405e-19, -2.441937238721118e-21,  2.081923225978804e-23, -1.697879672795336e-25,  5.572198440439988e-05, -2.079293539622776e-06,
  4.833382013887726e-08, -8.657610856961108e-10,  1.303383035603378e-11, -1.725305256054141e-13,  2.064060737529751e-15, -2.273055611768782e-17,  2.334483116684055e-19,
 -2.257748437816197e-21,  2.071606389443872e-23, -1.813939506728344e-25,  1.959475225357794e-05, -8.437319200357129e-07,  2.202912953103699e-08, -4.378714509607503e-10,
  7.254450095872088e-12, -1.050268257700775e-13,  1.367535974617103e-15, -1.632546127172654e-17,  1.811386123234235e-19, -1.887065330840535e-21,  1.860332722096950e-23,
 -1.746134306550154e-25,  6.410755783791047e-06, -3.161308857098877e-07,  9.237423382322424e-09, -2.031727559289790e-10,  3.695537679180836e-12, -5.839421841187129e-14,
  8.259810514477225e-16, -1.067032722884627e-17,  1.276960914190649e-19, -1.430776176241563e-21,  1.513231068884903e-23, -1.520361032961691e-25,  1.952838691474322e-06,
 -1.095486097064894e-07,  3.570261496765161e-09, -8.666445638019850e-11,  1.726902682354688e-12, -2.972607252574160e-14,  4.559975652808896e-16, -6.364636584706236e-18,
  8.203427952143917e-20, -9.872127011109530e-22,  1.118680020527378e-23, -1.201591063199215e-25,  5.543795296957422e-07, -3.516714233004571e-08,  1.274211703041781e-09,
 -3.405288336586692e-11,  7.418775411360213e-13, -1.388779790803586e-14,  2.306835595560125e-16, -3.473936888776183e-18,  4.816144268207791e-20, -6.217326855310321e-22,
  7.539716029965640e-24, -8.648307804220867e-26,  1.468262150842012e-07, -1.047609731642799e-08,  4.207260104866176e-10, -1.235095590162135e-11,  2.936517221641355e-13,
 -5.968721536112274e-15,  1.072052669684868e-16, -1.739659682596720e-18,  2.591122341061244e-20, -3.584292254392269e-22,  4.646852311916562e-24, -5.686283086134369e-26,
  3.632592943033771e-08, -2.901253964842243e-09,  1.287784650018115e-10, -4.143948996906967e-12,  1.073391794919302e-13, -2.365502959214149e-15,  4.588320919409419e-17,
 -8.013876395004901e-19,  1.281003494276240e-20, -1.896907143608684e-22,  2.626631414868292e-24, -3.425899225886717e-26,  8.408379362012640e-09, -7.484417429808448e-10,
  3.661922303949770e-11, -1.289100687426729e-12,  3.632025349444232e-14, -8.666506075369967e-16,  1.813244671963927e-17, -3.405061710360634e-19,  5.835725534875698e-21,
 -9.242277711474604e-23,  1.365719029182316e-24, -1.897109151749871e-26,  1.824225607513195e-09, -1.802485236133790e-10,  9.696618741787128e-12, -3.727259965607856e-13,
  1.140556877497347e-14, -2.943017791794311e-16,  6.634517162910080e-18, -1.338230191308103e-19,  2.456825066380638e-21, -4.158027094621351e-23,  6.551824773992061e-25,
 -9.685660900839260e-27,  3.717466661823291e-10, -4.062560540049590e-11,  2.397237393706695e-12, -1.004382010187820e-13,  3.333285535486492e-15, -9.289889133779315e-17,
  2.254143968865945e-18, -4.879291281297917e-20,  9.587639308354078e-22, -1.732687340304643e-23,  2.909219534360749e-25, -4.573879992106553e-27,  7.133733993874894e-11,
 -8.593294063513979e-12,  5.549481864383976e-13, -2.530001667152606e-14,  9.093880537506939e-16, -2.734352495378985e-17,  7.134325772470610e-19, -1.655782314742359e-20,
  3.479588950141829e-22, -6.709931787103327e-24,  1.199675252921918e-25, -2.004643855683325e-27,  1.292951444294887e-11, -1.711364867901016e-12,  1.206928708563792e-13,
 -5.977514630534370e-15,  2.323984079950437e-16, -7.530572262596012e-18,  2.110773937829921e-19, -5.248113375258633e-21,  1.178608728302244e-22, -2.423488731539240e-24,
  4.611018541961737e-26, -8.184124147188056e-28,  2.221080055188437e-12, -3.220679629490100e-13,  2.475336409942050e-14, -1.329703769179453e-15,  5.584628769595502e-17,
 -1.948099838844378e-18,  5.860526747719491e-20, -1.559742010134249e-21,  3.740588173828737e-23, -8.195937403981300e-25,  1.658411013527539e-26, -3.124726616036266e-28,
  3.631177630875731e-13, -5.751988910755580e-14,  4.808181908364311e-15, -2.797092898063491e-16,  1.267424198156932e-17, -4.754403708929114e-19,  1.533664988776987e-20,
 -4.365608333254918e-22,  1.117200631292926e-23, -2.606651338286120e-25,  5.605843078204638e-27, -1.120591165149834e-28,  5.677029297679793e-14, -9.796798644007324e-15,
  8.889305957573433e-16, -5.591477006860538e-17,  2.730005504360668e-18, -1.100079477948175e-19,  3.801521647804411e-21, -1.156392583501649e-22,  3.155448958342415e-24,
 -7.834352968282569e-26,  1.789550309915584e-27, -3.792887652722071e-29,  8.535415080121828e-15, -1.600326251321280e-15,  1.573120620436124e-16, -1.068253204309056e-17,
  5.612637187902288e-19, -2.426767086223146e-20,  8.974985455346066e-22, -2.914964526922308e-23,  8.474445901601497e-25, -2.237295003498111e-26,  5.424352910909049e-28,
 -1.218176201815071e-29,  1.242220089603297e-15, -2.523693946689182e-16,  2.682255235916859e-17, -1.963217319188386e-18,  1.108479122129505e-19, -5.136618935558018e-21,
  2.030959620127527e-22, -7.036276267002314e-24,  2.177549512769687e-25, -6.108044037928294e-27,  1.570669028227669e-28, -3.734843032163119e-30,  1.763351201173581e-16,
 -3.871251734462921e-17,  4.439573110899644e-18, -3.496525276545350e-19,  2.118540403190275e-20, -1.050811986471789e-21,  4.436840560776290e-23, -1.637978232172867e-24,
  5.390955526944814e-26, -1.605221928523051e-27,  4.374321997976889e-29, -1.100462373333933e-30,  2.462938740828406e-17, -5.826784203793909e-18,  7.194846245534591e-19,
 -6.086512531109510e-20,  3.951240323195399e-21, -2.094870650861962e-22,  9.433741657374800e-24, -3.706876093911320e-25,  1.296075573251775e-26, -4.092562937175115e-28,
  1.180722223232678e-29, -3.139707990847991e-31,  3.419160619816991e-18, -8.691500391653492e-19,  1.152943983620095e-19, -1.045603563014685e-20,  7.260278882381597e-22,
 -4.108095699372210e-23,  1.970283732355469e-24, -8.229440518491545e-26,  3.052956300372809e-27, -1.021113376600324e-28,  3.115443054279496e-30, -8.747279719499060e-32,
  4.772354729950704e-19, -1.299494954783116e-19,  1.847347357687959e-20, -1.792239057006598e-21,  1.328536434599665e-22, -8.008743449529521e-24,  4.084223906286295e-25,
 -1.810542364811622e-26,  7.116457037941421e-28, -2.517751528584984e-29,  8.113067348754317e-31, -2.402161241360434e-32,  6.784975958833914e-20, -1.972575558395600e-20,
  2.997142603992419e-21, -3.103234382239643e-22,  2.450447466917651e-23, -1.570620555080900e-24,  8.500806723554113e-26, -3.992539228224710e-27,  1.659890692817187e-28,
 -6.201925982221957e-30,  2.107438492136178e-31, -6.570325845478995e-33,  9.970040931662766e-21, -3.083854356193834e-21,  4.993245571240653e-22, -5.502904041917477e-23,
  4.617495413188479e-24, -3.139543161177455e-25,  1.799509504475751e-26, -8.935832091560563e-28,  3.921769811683872e-29, -1.544553802297137e-30,  5.524499098981101e-32,
 -1.810377276096921e-33,  1.538735799502177e-21, -5.044457577635100e-22,  8.675335867206018e-23, -1.014576169400642e-23,  9.021036414408624e-25, -6.489219198995959e-26,
  3.928961301872503e-27, -2.057774017548630e-28,  9.511539004105518e-30, -3.939775744988560e-31,  1.480066429639346e-32, -5.087294925069713e-34,  2.538107449207698e-22,
 -8.782422806911781e-23,  1.598321358193376e-23, -1.976782471286289e-24,  1.856429283934681e-25, -1.408475200377496e-26,  8.981503290225194e-28, -4.947383036104748e-29,
  2.401855116330903e-30, -1.043564272305011e-31,  4.107110415586059e-33, -1.477033079984142e-34,  4.557217322690924e-23, -1.656933147291909e-23,  3.177846486584195e-24,
 -4.140242312050359e-25,  4.091429096595217e-26, -3.262351960452688e-27,  2.183509512823927e-28, -1.260814666443890e-29,  6.408429439405598e-31, -2.911588590438767e-32,
  1.196874409935071e-33, -4.490350017923127e-35,  9.073916745874813e-24, -3.449745364215764e-24,  6.940314548010369e-25, -9.482966874665170e-26,  9.819151121610049e-27,
 -8.194709416781823e-28,  5.734065819874670e-29, -3.457522468905352e-30,  1.833084419540281e-31, -8.677655722989976e-33,  3.712803582746995e-34, -1.448212078808546e-35,
  2.039044360822204e-24, -8.063604524047273e-25,  1.692948859752293e-25, -2.413855900906288e-26,  2.606294791271267e-27, -2.265984578473212e-28,  1.650153798456262e-29,
 -1.034488884996483e-30,  5.696509577346390e-32, -2.798149183102586e-33,  1.241083207729952e-34, -5.013333296384171e-36,  5.246718766085642e-25, -2.146177248596008e-25,
  4.675500995845415e-26, -6.917933393999562e-27,  7.746680842212941e-28, -6.979671300296104e-29,  5.262819573133750e-30, -3.413181962652960e-31,  1.942711541420777e-32,
 -9.855296434650871e-34,  4.510675865382867e-35, -1.878574086779937e-36,  1.557491269260320e-25, -6.550833461086747e-26,  1.471652459750819e-26, -2.245765320759962e-27,
  2.592513379133447e-28, -2.406485556615019e-29,  1.868131326527830e-30, -1.246461146047402e-31,  7.293709784591642e-33, -3.801246040437943e-34,  1.786142168508447e-35,
 -7.631343143234247e-37,  5.289496306559664e-26, -2.273354517447740e-26,  5.231319896568738e-27, -8.178644215110148e-28,  9.669610419920986e-29, -9.188270332873770e-30,
  7.297723790439634e-31, -4.979061099664729e-32,  2.977587809715303e-33, -1.585079988016214e-34,  7.603555822976308e-36, -3.314552950131198e-37,  1.952768729629939e-26,
 -8.520584521574383e-27,  1.994165839125383e-27, -3.171362435483779e-28,  3.813254660171904e-29, -3.683827839138185e-30,  2.973510107887175e-31, -2.060996411118820e-32,
  1.251620255207559e-33, -6.763470244408421e-35,  3.292158354901703e-36, -1.455645754173083e-37,  6.171420657589321e-27, -2.715680211200868e-27,  6.416524919623988e-28,
 -1.030282879484123e-28,  1.250630003909287e-29, -1.219481792431685e-30,  9.933397570072389e-32, -6.946460719794373e-33,  4.255216982305937e-34, -2.318927359528122e-35,
  1.138083032848933e-36, -5.072518604227440e-38,  5.143013342033850e-02, -1.085265610411696e-04,  2.356782963946849e-07, -5.248277396176158e-10,  1.192545239569580e-12,
 -2.752904790860495e-15,  6.422601270270107e-18, -1.510842459209886e-20,  3.565262876772783e-23, -8.453618711157617e-26,  1.998166339317285e-28, -4.754214662119318e-31,
  4.762447619188880e-02, -1.172789349306614e-04,  3.411399514894375e-07, -1.054037436887560e-09,  3.278770426481553e-12, -1.008467656638398e-14,  3.054178263138452e-17,
 -9.114048927547812e-20,  2.683340157852354e-22, -7.809854360047123e-25,  2.248973059654952e-27, -6.419220606303526e-30,  4.083760849533460e-02, -1.294005074917050e-04,
  5.187419365891289e-07, -2.069877964987330e-09,  7.930908934731590e-12, -2.931211512688460e-14,  1.052470598633472e-16, -3.690513455024683e-19,  1.268347743294251e-21,
 -4.283703046552988e-24,  1.424590166386764e-26, -4.672638874540400e-29,  3.242784963373447e-02, -1.372018613998673e-04,  7.122406050827809e-07, -3.436817620483622e-09,
  1.554764099827131e-11, -6.709075276675876e-14,  2.789847046018047e-16, -1.125104228392599e-18,  4.420366227630084e-21, -1.697664624630575e-23,  6.390518274629809e-26,
 -2.362844501415507e-28,  2.384623711071825e-02, -1.348128753777334e-04,  8.610526352051565e-07, -4.889544688521077e-09,  2.568840353782499e-11, -1.275456913798665e-13,
  6.054463897569382e-16, -2.768791373285961e-18,  1.226678211658350e-20, -5.287243101299531e-23,  2.224441974864000e-25, -9.158881852167507e-28,  1.624008538398576e-02,
 -1.208447937939432e-04,  9.210916459760468e-07, -6.075284521129681e-09,  3.666612710140690e-11, -2.071880144266258e-13,  1.110824149197529e-15, -5.702433671675128e-18,
  2.821505644743483e-20, -1.352284317798425e-22,  6.302345570053693e-25, -2.864921069791204e-27,  1.024364295211075e-02, -9.834578745389965e-05,  8.790838885894718e-07,
 -6.676692543711325e-09,  4.588603046436435e-11, -2.925705952087145e-13,  1.757428195202495e-15, -1.005037337174013e-17,  5.513530699385969e-20, -2.917982503929167e-22,
  1.496406261375469e-24, -7.461694648104872e-27,  5.984926717652550e-03, -7.265629258457951e-05,  7.536249461954668e-07, -6.544872376179875e-09,  5.085069705603591e-11,
 -3.633703136748361e-13,  2.430023628455799e-15, -1.538875157165733e-17,  9.306758939133833e-20, -5.409290110134428e-22,  3.036349303991632e-24, -1.652367016077864e-26,
  3.239319909740429e-03, -4.881033320585747e-05,  5.832878435394299e-07, -5.756874457337355e-09,  5.026386450487036e-11, -4.003317359415005e-13,  2.965270715455274e-15,
 -2.069360598677620e-17,  1.373311415614820e-19, -8.727181801669246e-22,  5.339206640930701e-24, -3.157968673489816e-26,  1.624448564578539e-03, -2.988335919596546e-05,
  4.091519075631755e-07, -4.564612390658798e-09,  4.456248759152492e-11, -3.937859124902930e-13,  3.216886353174594e-15, -2.463980538685796e-17,  1.787487118755606e-19,
 -1.237418731663522e-21,  8.221985253555167e-24, -5.267474719781887e-26,  7.549165460491616e-04, -1.671072853327312e-05,  2.609036432514980e-07, -3.274524836883797e-09,
  3.559278856634941e-11, -3.476150160624925e-13,  3.120614252148863e-15, -2.614544650079044e-17,  2.066674420860676e-19, -1.553720106265051e-21,  1.117892135628350e-23,
 -7.735253990152739e-26,  3.251901027938368e-04, -8.552954811163240e-06,  1.516219908773469e-07, -2.131827101756334e-09,  2.570512693227826e-11, -2.765391195314577e-13,
  2.719711979015670e-15, -2.485263014118439e-17,  2.134627353236543e-19, -1.738225776886474e-21,  1.350833220446375e-23, -1.007082378930374e-25,  1.298825199711851e-04,
 -4.014397659428224e-06,  8.047767505818400e-08, -1.262881513812898e-09,  1.683796492987452e-11, -1.989611492721199e-13,  2.137947624883949e-15, -2.125448603552498e-17,
  1.978984734170971e-19, -1.741508613351215e-21,  1.458629295141569e-23, -1.169191624522942e-25,  4.811703355271649e-05, -1.730880084277709e-06,  3.909022657174062e-08,
 -6.823352651529348e-10,  1.003110515113859e-11, -1.298561336915281e-13,  1.521026812546382e-15, -1.641515725155615e-17,  1.653416457254879e-19, -1.569316234829036e-21,
  1.413953153295517e-23, -1.216366804615450e-25,  1.654160135812867e-05, -6.866922844103572e-07,  1.740716014754559e-08, -3.369656651498313e-10,  5.448232384728662e-12,
 -7.709430586861982e-14,  9.823033435139704e-16, -1.148615617428923e-17,  1.249316139546193e-19, -1.276732045567153e-21,  1.235423802097412e-23, -1.138799841755647e-25,
  5.279900187841086e-06, -2.510608387689815e-07,  7.118811877822607e-09, -1.524039937647498e-10,  2.703887112771001e-12, -4.173787339085152e-14,  5.774391202982560e-16,
 -7.303304845782173e-18,  8.564191007774002e-20, -9.409315959983006e-22,  9.764288331887024e-24, -9.631031898215957e-26,  1.565790021300800e-06, -8.471829504460238e-08,
  2.678224033596515e-09, -6.325121090730497e-11,  1.228789829899777e-12, -2.065400201563663e-14,  3.097568686060686e-16, -4.231198717784846e-18,  5.341803285820081e-20,
 -6.301241177476342e-22,  7.003653043864218e-24, -7.382941526383028e-26,  4.317696541097515e-07, -2.642550384618607e-08,  9.285224463662024e-10, -2.413426349528855e-11,
  5.124260534569713e-13, -9.363254384388629e-15,  1.520003315296188e-16, -2.239396713556279e-18,  3.039967703616568e-20, -3.845578355800231e-22,  4.572880207307564e-24,
 -5.146373551797519e-26,  1.108166216903808e-07, -7.631501932552605e-09,  2.971770801843467e-10, -8.482744999279165e-12,  1.964989504714532e-13, -3.897377643876647e-15,
  6.839314477408266e-17, -1.085468681271654e-18,  1.582640940515034e-20, -2.144735907945785e-22,  2.725838482360626e-24, -3.271943388589855e-26,  2.650335387010076e-08,
 -2.043981134387050e-09,  8.796921443876103e-11, -2.752040962657576e-12,  6.943858424497270e-14, -1.492902912069308e-15,  2.828574552514071e-17, -4.830759887782703e-19,
  7.557371048288357e-21, -1.096107729907825e-22,  1.487623680741226e-24, -1.902944616539997e-26,  5.914934089731797e-09, -5.086640516016834e-10,  2.413333883461820e-11,
 -8.258939556599214e-13,  2.266402561261551e-14, -5.275142355306031e-16,  1.077914115551087e-17, -1.978986972930308e-19,  3.318893493954510e-21, -5.147543912394510e-23,
  7.454332289092427e-25, -1.015409736331117e-26,  1.233903992718386e-09, -1.178609702769158e-10,  6.149494805312375e-12, -2.298040227803659e-13,  6.848948288891757e-15,
 -1.723750264116578e-16,  3.794838934127058e-18, -7.482848244298977e-20,  1.344164296088380e-21, -2.227669506592575e-23,  3.439672102219954e-25, -4.986018053125809e-27,
  2.410820702716088e-10, -2.548627169352857e-11,  1.459048925186012e-12, -5.943885020084377e-14,  1.921375375355802e-15, -5.223181490472876e-17,  1.237681160939974e-18,
 -2.618969811752031e-20,  5.035232757704560e-22, -8.910560094733133e-24,  1.466037196080119e-25, -2.260046602439425e-27,  4.422170038692168e-11, -5.156973451907864e-12,
  3.232342024776414e-13, -1.433201359190347e-14,  5.018518718895964e-16, -1.472026705088773e-17,  3.751057282016741e-19, -8.510986611910118e-21,  1.750102973807904e-22,
 -3.304862104562317e-24,  5.790345876807890e-26, -9.487781776343426e-28,  7.636982958871309e-12, -9.794086034474070e-13,  6.707427491064930e-14, -3.232001215219978e-15,
  1.224446029771560e-16, -3.871336917952739e-18,  1.059962548912859e-19, -2.576880206065430e-21,  5.663430959146751e-23, -1.140529474034170e-24,  2.126775302277531e-26,
 -3.702001277706108e-28,  1.245891561672468e-12, -1.752061737441160e-13,  1.308457095837980e-14, -6.841621040917636e-16,  2.801016186822073e-17, -9.536616371625745e-19,
  2.803194952567940e-20, -7.296546916440329e-22,  1.712856180083259e-23, -3.676435402846523e-25,  7.292351494179576e-27, -1.347760921425479e-28,  1.927669620004030e-13,
 -2.964384896462501e-14,  2.409567917617724e-15, -1.365196882489503e-16,  6.033049584100756e-18, -2.209805049772350e-19,  6.967606243581424e-21, -1.940409956637123e-22,
  4.862211217519464e-24, -1.111637033801225e-25,  2.344189803519740e-27, -4.597752559672987e-29,  2.841910923910688e-14, -4.766441472296406e-15,  4.209082892819227e-16,
 -2.580347003454653e-17,  1.229421132501403e-18, -4.839869365547649e-20,  1.635574245275007e-21, -4.869741572526693e-23,  1.301655188841468e-24, -3.168009473182128e-26,
  7.098443217674568e-28, -1.476708805399772e-29,  4.014254105339225e-15, -7.323937515710320e-16,  7.013366101817118e-17, -4.645418180759281e-18,  2.383494122071771e-19,
 -1.007459485576307e-20,  3.645804545857330e-22, -1.159631638254839e-23,  3.304136037252956e-25, -8.555260657526272e-27,  2.035635413134880e-28, -4.489185928928195e-30,
  5.467918236273916e-16, -1.082427260382221e-16,  1.121920210183337e-17, -8.017235894392841e-19,  4.424305489930115e-20, -2.005765064511946e-21,  7.765552718897943e-23,
 -2.636514307437958e-24,  8.001819794620181e-26, -2.202659981099844e-27,  5.561897716337463e-29, -1.299448401449620e-30,  7.236764218251175e-17, -1.550340059471920e-17,
  1.735969279512032e-18, -1.336275177770809e-19,  7.920959519508139e-21, -3.847147021095085e-22,  1.591907152714318e-23, -5.763804422640414e-25,  1.861763021920126e-26,
 -5.444127467705768e-28,  1.457790463422976e-29, -3.605757261481891e-31,  9.388499526291159e-18, -2.170809821121015e-18,  2.620716009825232e-19, -2.169433020823910e-20,
  1.379337812353489e-21, -7.168218387650214e-23,  3.166542183784476e-24, -1.221410244271527e-25,  4.194863631046114e-27, -1.301901909698640e-28,  3.693764429511217e-30,
 -9.664599945827928e-32,  1.206174007147650e-18, -3.001675326711676e-19,  3.898684842891844e-20, -3.464451596105824e-21,  2.358933865810814e-22, -1.309849489125831e-23,
  6.169223964166779e-25, -2.532062902989395e-26,  9.236109845358910e-28, -3.039141664728361e-29,  9.127114222526684e-31, -2.523743361034831e-32,  1.552713358017912e-19,
 -4.146533125323455e-20,  5.780818918361952e-21, -5.503376670610056e-22,  4.005852005339283e-23, -2.372810918101374e-24,  1.189760269140271e-25, -5.188797723527355e-27,
  2.007569830896459e-28, -6.995101272124329e-30,  2.221018972422927e-31, -6.482802712950791e-33,  2.029893341324043e-20, -5.798617029594503e-21,  8.655035967162349e-22,
 -8.807609154951402e-23,  6.839522345475867e-24, -4.313637755199302e-25,  2.298630500441069e-26, -1.063472685073332e-27,  4.357555998107797e-29, -1.605395290082098e-30,
  5.381410081744518e-32, -1.655790118890878e-33,  2.736216632980199e-21, -8.332210391997009e-22,  1.327719786868699e-22, -1.440578703714826e-23,  1.190663064095525e-24,
 -7.978249697532893e-26,  4.508884927756882e-27, -2.208661529517921e-28,  9.566437106857211e-30, -3.719885572016588e-31,  1.314173050670900e-32, -4.255354789816701e-34,
  3.867915589616237e-22, -1.250863406056790e-22,  2.121110188304284e-23, -2.446614042361562e-24,  2.146445321067165e-25, -1.524147083780049e-26,  9.113156114683279e-28,
 -4.715460075099393e-29,  2.154185787755295e-30, -8.822105366248115e-32,  3.277968428249417e-33, -1.114777902364271e-34,  5.841216037101410e-23, -1.997877308494663e-23,
  3.592119465099458e-24, -4.389990914307491e-25,  4.075166541056610e-26, -3.057278808296303e-27,  1.928458293997108e-28, -1.051148673448513e-29,  5.051366454548425e-31,
 -2.173173655808524e-32,  8.471457945789427e-34, -3.018516850325648e-35,  9.612126383333839e-24, -3.461439706688739e-24,  6.571705741476004e-25, -8.476566876876194e-26,
  8.295277196992100e-27, -6.552014773415030e-28,  4.345257985474256e-29, -2.486874252112404e-30,  1.253192454167756e-31, -5.646463371540696e-33,  2.302434776353050e-34,
 -8.570880651408750e-36,  1.758945131378998e-24, -6.636200759643001e-25,  1.324209404074803e-25, -1.794728701218911e-26,  1.843699573172837e-27, -1.526897742046935e-28,
  1.060475461028566e-29, -6.348406311659148e-31,  3.342268733542941e-32, -1.571500672103514e-33,  6.679713986898956e-35, -2.588957563294435e-36,  3.650310513492338e-25,
 -1.435158326485913e-25,  2.994174962323196e-26, -4.242506312921174e-27,  4.552741198631162e-28, -3.934756570720093e-29,  2.848874329094566e-30, -1.775983202000564e-31,
  9.726588487063472e-33, -4.752624514126496e-34,  2.097220997276653e-35, -8.429908904412383e-37,  8.736649101867353e-26, -3.558838191634812e-26,  7.717729110656137e-27,
 -1.136739087835381e-27,  1.267253763104568e-28, -1.136835102046911e-29,  8.535907282730617e-31, -5.513326801721555e-32,  3.125641512050658e-33, -1.579534502647654e-34,
  7.202445778500113e-36, -2.988810090206077e-37,  2.435562154599655e-26, -1.021587031741194e-26,  2.288059296059722e-27, -3.481034305336374e-28,  4.006559088771502e-29,
 -3.708283858961101e-30,  2.870590814497907e-31, -1.910083083482937e-32,  1.114722175134850e-33, -5.794593781291296e-35,  2.715970845698857e-36, -1.157596253876565e-37,
  7.861432311864485e-27, -3.373327719154888e-27,  7.748707343327778e-28, -1.209268435054218e-28,  1.427206517056293e-29, -1.353836113728643e-30,  1.073479994519972e-31,
 -7.312204233095338e-33,  4.365959852149223e-34, -2.320599675732621e-35,  1.111523718166008e-36, -4.838382157039192e-38,  2.797524777783555e-27, -1.219706233028013e-27,
  2.852130873638452e-28, -4.531826896525998e-29,  5.444370963101155e-30, -5.255130710368491e-31,  4.238329076305237e-32, -2.935300627996704e-33,  1.781176967219572e-34,
 -9.617719553734415e-36,  4.677997462634247e-37, -2.066907699029748e-38,  8.657298539796469e-28, -3.808403097061412e-28,  8.995260851064656e-29, -1.443834915224691e-29,
  1.752015964301303e-30, -1.707791292406381e-31,  1.390625169914085e-32, -9.721456804463799e-34,  5.953162462080019e-35, -3.243203360342864e-36,  1.591199820374732e-37,
 -7.089918259117895e-39,  5.099975859449615e-02, -1.066660061599164e-04,  2.294930576866836e-07, -5.061792470272474e-10,  1.138994956691438e-12, -2.603712628988053e-15,
  6.015091015011804e-18, -1.401473072300310e-20,  3.274829275356380e-23, -7.694659473269625e-26,  1.800301537626607e-28, -4.249965229258731e-31,  4.716073982370370e-02,
 -1.145995323643568e-04,  3.287997350002479e-07, -1.003151682357358e-09,  3.084205122958443e-12, -9.381352063192733e-15,  2.810595653502959e-17, -8.298682379952908e-20,
  2.417719990326379e-22, -6.964280772455148e-25,  1.984800743333295e-27, -5.608055581693135e-30,  4.032815201345775e-02, -1.253478126139570e-04,  4.946458574295759e-07,
 -1.947539550928071e-09,  7.369112030327663e-12, -2.690573925519319e-14,  9.545941999318853e-17, -3.308255494028858e-19,  1.123914820081939e-21, -3.752934959858621e-24,
  1.234123702496203e-26, -4.003206190796184e-29,  3.189018267843529e-02, -1.316647745130561e-04,  6.724482371179901e-07, -3.198436519382855e-09,  1.427031080975264e-11,
 -6.075771839603562e-14,  2.493736356998144e-16, -9.929573409248305e-19,  3.852819625062137e-21, -1.461677550405328e-23,  5.436247853666513e-26, -1.986254130832463e-28,
  2.332040046102520e-02, -1.281523540631874e-04,  8.047624927830817e-07, -4.498173623246478e-09,  2.327673922077484e-11, -1.139026344907815e-13,  5.331414057765781e-16,
 -2.405067402917107e-18,  1.051427870278645e-20, -4.473100577847630e-23,  1.857950954651113e-25, -7.554041088480781e-28,  1.577099562964477e-02, -1.137580068737171e-04,
  8.515759839205447e-07, -5.520380562681316e-09,  3.277654029819048e-11, -1.823465571166176e-13,  9.630978065706138e-16, -4.872814239304149e-18,  2.377178720600128e-20,
 -1.123701035751048e-22,  5.166643729123052e-25, -2.317656447010453e-27,  9.863834767996424e-03, -9.162154686624147e-05,  8.031827107143584e-07, -5.987127878193760e-09,
  4.043459771433400e-11, -2.535791834167876e-13,  1.499217934197533e-15, -8.443179858195614e-18,  4.563329929593838e-20, -2.380261712439960e-22,  1.203430936484220e-24,
 -5.917814347219120e-27,  5.705880959701071e-03, -6.692814793870944e-05,  6.797381984075830e-07, -5.786372391447748e-09,  4.413326059908038e-11, -3.099010240182501e-13,
  2.038064589782011e-15, -1.270007466253640e-17,  7.561575851511142e-20, -4.328597202909964e-22,  2.393915601830482e-24, -1.283961162132384e-26,  3.052992189508595e-03,
 -4.440727298583963e-05,  5.187784698435624e-07, -5.013027416736266e-09,  4.292441007244554e-11, -3.356493219848167e-13,  2.442929797631349e-15, -1.676304850721718e-17,
  1.094446353469541e-19, -6.845571476640739e-22,  4.123791388345341e-24, -2.402509271455863e-26,  1.511131003587063e-03, -2.681769675382479e-05,  3.584076330655399e-07,
 -3.910646963376727e-09,  3.740611269209841e-11, -3.242522588079004e-13,  2.600781891173357e-15, -1.957339764004092e-17,  1.396023632186510e-19, -9.506216135094533e-22,
  6.215829405517758e-24, -3.920339605410270e-26,  6.920122291896800e-04, -1.477149846126484e-05,  2.248093593599434e-07, -2.756825433947868e-09,  2.933379140572050e-11,
 -2.808065891677482e-13,  2.473298802740668e-15, -2.034697443331567e-17,  1.580242491359769e-19, -1.167912348819423e-21,  8.264733813121363e-24, -5.626992336871462e-26,
  2.932515607846189e-04, -7.435713209263548e-06,  1.283361155043904e-07, -1.761468241059616e-09,  2.077446640066665e-11, -2.188989303005254e-13,  2.110758508799011e-15,
 -1.892684841328089e-17,  1.596312738005355e-19, -1.277163632506276e-21,  9.756788606587146e-24, -7.153678594384381e-26,  1.150226818504034e-04, -3.426899908164397e-06,
  6.681673443584988e-08, -1.022710147581471e-09,  1.332711060084149e-11, -1.541304521160834e-13,  1.622803569962207e-15, -1.582158669016577e-17,  1.445737861911946e-19,
 -1.249367891853188e-21,  1.028161547933718e-23, -8.101413202094945e-26,  4.177070640910834e-05, -1.448367133384228e-06,  3.178550677081094e-08, -5.407772931610922e-10,
  7.764681143274805e-12, -9.831765113223248e-14,  1.127703856929139e-15, -1.192867060914203e-17,  1.178558284880825e-19, -1.097956666247438e-21,  9.715442190881880e-24,
 -8.212277505979213e-26,  1.404968487494071e-05, -5.622368088839644e-07,  1.383958914664924e-08, -2.609498452634092e-10,  4.118214651117903e-12, -5.696590862143600e-14,
  7.103777820922762e-16, -8.137379664041594e-18,  8.677516708895923e-20, -8.700277347502544e-22,  8.264530373839534e-24, -7.482523754686347e-26,  4.378935536178026e-06,
 -2.007491515267440e-07,  5.524251836216318e-09, -1.151312109470406e-10,  1.992627989097525e-12, -3.005235984615834e-14,  4.067147743349245e-16, -5.036939881014618e-18,
  5.788375730053460e-20, -6.236772621248358e-22,  6.351016508630146e-24, -6.150577923806062e-26,  1.265394875962526e-06, -6.602328663556463e-08,  2.024747852057503e-09,
 -4.652834747156206e-11,  8.813709746804485e-13, -1.446753421180666e-14,  2.121558941618290e-16, -2.836482166435447e-18,  3.507978019135204e-20, -4.056634522736669e-22,
  4.422970000139260e-24, -4.576328509075462e-26,  3.392693035127436e-07, -2.002943178048980e-08,  6.825126626426488e-10, -1.725485252989857e-11,  3.570801869175510e-13,
 -6.369389926660331e-15,  1.010632071296654e-16, -1.456812662197748e-18,  1.936618658501535e-20, -2.400856673477337e-22,  2.799695927778791e-24, -3.091688821578927e-26,
  8.446907584267733e-08, -5.613201342007471e-09,  2.119387206978832e-10, -5.882546108519096e-12,  1.327719302773891e-13, -2.569877570358099e-15,  4.406466862347537e-17,
 -6.840459248090364e-19,  9.763942844825914e-21, -1.296359313780951e-22,  1.615304674163946e-24, -1.902072002856997e-26,  1.954973051572898e-08, -1.455488651777815e-09,
  6.073351347582564e-11, -1.847153661648434e-12,  4.540062298050647e-14, -9.523038202681108e-16,  1.762537763326381e-17, -2.943527028754354e-19,  4.507071371595009e-21,
 -6.403054537816844e-23,  8.517987329473118e-25, -1.068685998586156e-26,  4.211393802856630e-09, -3.497946835954933e-10,  1.609105746462638e-11, -5.353039725688139e-13,
  1.430734305021387e-14, -3.248339853864129e-16,  6.482719302131725e-18, -1.163635893986778e-19,  1.909679200023314e-21, -2.900700447599131e-23,  4.116719135199063e-25,
 -5.499187219925242e-27,  8.457080527635371e-10, -7.806576303012331e-11,  3.949852541129565e-12, -1.434859410564408e-13,  4.164787742669307e-15, -1.022364889008288e-16,
  2.197969095688484e-18, -4.236869668411612e-20,  7.446851977485917e-22, -1.208531752752612e-23,  1.828597364793365e-25, -2.599126288356453e-27,  1.586093927277089e-10,
 -1.621435458203152e-11,  9.003797865335857e-13, -3.566000072306215e-14,  1.122669603184240e-15, -2.976675210760202e-17,  6.887895459172946e-19, -1.424749547146838e-20,
  2.680084955382655e-22, -4.644082980988554e-24,  7.487108183580272e-26, -1.131727611344289e-27,  2.784309495978818e-11, -3.142090159405000e-12,  1.911001259508122e-13,
 -8.239393219007268e-15,  2.810253767857968e-16, -8.040350094831219e-18,  2.000853141107314e-19, -4.437984199785674e-21,  8.928961000335209e-23, -1.651070617173158e-24,
  2.834652889790377e-26, -4.554341687193143e-28,  4.587164129376456e-12, -5.697403195226070e-13,  3.787847276134350e-14, -1.775363769271620e-15,  6.552907737664721e-17,
 -2.021241231695651e-18,  5.405166635407199e-20, -1.284716432774348e-21,  2.762922939192218e-23, -5.448940649327804e-25,  9.957493683851017e-27, -1.699692010824093e-28,
  7.115303672424692e-13, -9.699315211693281e-14,  7.035988384249148e-15, -3.580026224191877e-16,  1.428444446453489e-17, -4.745930711604324e-19,  1.362830009735499e-20,
 -3.468878152534983e-22,  7.969847557306957e-24, -1.675517029344906e-25,  3.257508597678553e-27, -5.904835621435357e-29,  1.043075353196027e-13, -1.556415546584030e-14,
  1.229710664473083e-15, -6.783467228589195e-17,  2.922828753219954e-18, -1.045109654088276e-19,  3.220298330679827e-21, -8.772420114393756e-23,  2.151978761401847e-24,
 -4.820299820546599e-26,  9.965732258341692e-28, -1.917544538135036e-29,  1.451692802695245e-14, -2.365047932476922e-15,  2.031677428980597e-16, -1.213444783478542e-17,
  5.640166347579465e-19, -2.168585000582518e-20,  7.164850154623716e-22, -2.087519317518522e-23,  5.464644055988241e-25, -1.303508785762371e-26,  2.864470190931128e-28,
 -5.847947234869644e-30,  1.928415927525045e-15, -3.421701019794970e-16,  3.190407500143892e-17, -2.060411579902656e-18,  1.032010473137364e-19, -4.262948225788732e-21,
  1.509066109064613e-22, -4.699418237389651e-24,  1.311993523502106e-25, -3.330940100168930e-27,  7.776380711751277e-29, -1.683669633875575e-30,  2.460655614264744e-16,
 -4.743491823204866e-17,  4.792234286422984e-18, -3.341952256399344e-19,  1.801804682386326e-20, -7.988576279152650e-22,  3.027500774285125e-23, -1.006984129476099e-24,
  2.996316217598835e-26, -8.091907873229575e-28,  2.005882741715634e-29, -4.603425016448323e-31,  3.038624407085344e-17, -6.348188778478975e-18,  6.936679196235105e-19,
 -5.216174928947184e-20,  3.023599200779194e-21, -1.437414893087229e-22,  5.826775519431779e-24, -2.068353034303264e-25,  6.554717766041511e-27, -1.881727272260713e-28,
  4.949775207821128e-30, -1.203372895821990e-31,  3.663530496804419e-18, -8.273454612766221e-19,  9.759757577049292e-20, -7.901655608036211e-21,  4.918071491188744e-22,
 -2.504152288548070e-23,  1.084684626304566e-24, -4.105482965687207e-26,  1.384510257536186e-27, -4.221838500086522e-29,  1.177572840574329e-30, -3.030668340498189e-32,
  4.356988067780229e-19, -1.060777193693762e-19,  1.348210765674076e-20, -1.173257038262776e-21,  7.829776838301911e-23, -4.264504101886234e-24,  1.971544436787035e-25,
 -7.948256894304957e-27,  2.849569819315367e-28, -9.221179431607560e-30,  2.724895963184380e-31, -7.417727596443416e-33,  5.172834767125474e-20, -1.353874978386997e-20,
  1.849885875231092e-21, -1.727151044003177e-22,  1.233827456417937e-23, -7.177693524422523e-25,  3.536957913698110e-26, -1.516888677904579e-27,  5.774633497728000e-29,
 -1.980836471137508e-30,  6.194797306662937e-32, -1.781853967129306e-33,  6.216050259050267e-21, -1.743569968876339e-21,  2.554963264630302e-22, -2.553904903594463e-23,
  1.949280213586318e-24, -1.209101884808924e-25,  6.340387702981816e-27, -2.888301955418311e-28,  1.165887302756931e-29, -4.233572958725534e-31,  1.399375282206914e-32,
 -4.247710482513472e-34,  7.680363071475748e-22, -2.301026016152735e-22,  3.606273747325828e-23, -3.850001263213195e-24,  3.132669968458304e-25, -2.067614103382991e-26,
  1.151578702303155e-27, -5.562010738134646e-29,  2.376485166440767e-30, -9.119889165929201e-32,  3.181046236981922e-33, -1.017399833824534e-34,  9.931992299995000e-23,
 -3.166537424154771e-23,  5.291309473497562e-24, -6.016258879097877e-25,  5.205152677513294e-26, -3.646642640067149e-27,  2.152206676698309e-28, -1.099705524834674e-29,
  4.963089270851849e-31, -2.008760825827448e-32,  7.379206738694770e-34, -2.482013925040017e-35,  1.370918044515005e-23, -4.632262480412934e-24,  8.223703991262326e-25,
 -9.925888508529399e-26,  9.103225164946506e-27, -6.749880516534100e-28,  4.209673536199947e-29, -2.269552585271517e-30,  1.079138294358145e-31, -4.595174491895233e-33,
  1.773558233629364e-34, -6.258962132431769e-36,  2.063137754979809e-24, -7.354963728077744e-25,  1.381588157776125e-25, -1.763441438522931e-26,  1.708182046574154e-27,
 -1.335905246281732e-28,  8.775066978825401e-30, -4.975723438036513e-31,  2.484943210375124e-32, -1.109928581596399e-33,  4.487907821085823e-35, -1.657068637223523e-36,
  3.461007061672313e-25, -1.295271129786250e-25,  2.562450489391327e-26, -3.443444306233380e-27,  3.508096845497731e-28, -2.881935792945423e-29,  1.985986195945625e-30,
 -1.179908597759965e-31,  6.166471543872105e-33, -2.878866792764001e-34,  1.215269228720746e-35, -4.678921403312630e-37,  6.614626032201461e-26, -2.584610723489629e-26,
  5.356510270834611e-27, -7.539724750919792e-28,  8.038962010772869e-29, -6.904269572262603e-30,  4.968530934676252e-31, -3.079143352074579e-32,  1.676746952448835e-33,
 -8.147670409717163e-35,  3.576114238849077e-36, -1.429993830480882e-37,  1.468251444673487e-26, -5.954415400968108e-27,  1.285057532986547e-27, -1.883659553271123e-28,
  2.090056216383451e-29, -1.866378652908383e-30,  1.395140957257394e-31, -8.972358250638919e-33,  5.065400477638307e-34, -2.549418654962437e-35,  1.157932666990293e-36,
 -4.786841493288801e-38,  3.832973771389823e-27, -1.603033876828716e-27,  3.578802015489874e-28, -5.427270835827055e-29,  6.226938427418466e-30, -5.745674917813054e-31,
  4.434474668229236e-32, -2.942145131334814e-33,  1.712210069286441e-34, -8.876232690575017e-36,  4.149365265666219e-37, -1.764013771695713e-38,  1.172900210690226e-27,
 -5.024333075801897e-28,  1.151935904421101e-28, -1.794312661447112e-29,  2.113746319357854e-30, -2.001438920986222e-31,  1.584169671374250e-32, -1.077231958027893e-33,
  6.421187207515551e-35, -3.407466146898152e-36,  1.629544647608110e-37, -7.082484142902984e-39,  4.015399302881205e-28, -1.749253785907561e-28,  4.086649183227529e-29,
 -6.487368350764788e-30,  7.786567047273024e-31, -7.509195459751997e-32,  6.050978151845085e-33, -4.187108957014275e-34,  2.538687421257668e-35, -1.369696420721645e-36,
  6.656893149802706e-38, -2.939017159095444e-39,  1.215377265466112e-28, -5.344814152744613e-29,  1.261962078095030e-29, -2.024838947476392e-30,  2.456136551463766e-31,
 -2.393277257459343e-32,  1.948115898192955e-33, -1.361399012754421e-34,  8.334012214350166e-36, -4.538745494944313e-37,  2.226099227104363e-38, -9.915678329787558e-40,
  5.057672842137632e-02, -1.048540524029892e-04,  2.235265568361152e-07, -4.883642093842009e-10,  1.088333141862714e-12, -2.463943487076394e-15,  5.636943055983731e-18,
 -1.300975252092483e-20,  3.010345415204014e-23, -7.010587284479460e-26,  1.623302915659182e-28, -3.804522141012586e-31,  4.670752741630820e-02, -1.120164608867154e-04,
  3.170519234095357e-07, -9.552695411500482e-10,  2.903139719034056e-12, -8.733841061473315e-15,  2.588697676724893e-17, -7.563640944219755e-20,  2.180721384239912e-22,
 -6.217571805168065e-25,  1.753854384043955e-27, -4.906166947672650e-30,  3.983452986053487e-02, -1.214821633578288e-04,  4.719654545731891e-07, -1.833817275547786e-09,
  6.853177679783276e-12, -2.472192799866594e-14,  8.668016739184053e-17, -2.969300312499345e-19,  9.972863085506235e-22, -3.292774783461759e-24,  1.070810366027227e-26,
 -3.435462400964032e-29,  3.137404503164765e-02, -1.264349223294752e-04,  6.353978767445058e-07, -2.979516806536795e-09,  1.311282407871149e-11, -5.509292463036705e-14,
  2.232206833443841e-16, -8.776832066756314e-19,  3.363738979455826e-21, -1.260742943163647e-23,  4.633280921722125e-26, -1.673054832462174e-28,  2.282033409902291e-02,
 -1.219240039079607e-04,  7.529459915652654e-07, -4.143297231628626e-09,  2.112137613397490e-11, -1.018787619830024e-13,  4.702776929034724e-16, -2.093003758658227e-18,
  9.030096591436278e-21, -3.792349713245006e-23,  1.555329716008183e-25, -6.245170972272434e-28,  1.532918149974349e-02, -1.072017312819923e-04,  7.883615613039240e-07,
 -5.023920376711048e-09,  2.935012997607416e-11, -1.607871166213707e-13,  8.367279443073591e-16, -4.173044771110822e-18,  2.007513576393930e-20, -9.360716863703585e-23,
  4.246667869292608e-25, -1.880074352383414e-27,  9.509759516424018e-03, -8.547284223442978e-05,  7.350576552997580e-07, -5.378869512512407e-09,  3.570449758487443e-11,
 -2.202774491463724e-13,  1.282027819272819e-15, -7.111213159303549e-18,  3.787155115852637e-20, -1.947191353683700e-22,  9.707229049417962e-25, -4.708105684303357e-27,
  5.448620761990813e-03, -6.175643834332702e-05,  6.143422779346513e-07, -5.127282913053609e-09,  3.839692617863822e-11, -2.649950366255057e-13,  1.714121350675828e-15,
 -1.051226744475504e-17,  6.162844790526772e-20, -3.475154891173824e-22,  1.893863332147761e-24, -1.001245050928390e-26,  2.883298398469475e-03, -4.048648535837412e-05,
  4.625312550775006e-07, -4.376907911668984e-09,  3.676166084841451e-11, -2.822773214059896e-13,  2.019106351093249e-15, -1.362524773558941e-17,  8.753144340123429e-20,
 -5.389595521348257e-22,  3.197359340946227e-24, -1.835096165199742e-26,  1.409311270347213e-03, -2.412844400008786e-05,  3.148673474039731e-07, -3.360815747659774e-09,
  3.150334339647041e-11, -2.679353386985069e-13,  2.110447378993642e-15, -1.560887580961864e-17,  1.094686172473793e-19, -7.333531708904749e-22,  4.719551644784979e-24,
 -2.930802227149166e-26,  6.363243930711196e-04, -1.309777920976914e-05,  1.943681074328303e-07, -2.329372542903687e-09,  2.426790063387899e-11, -2.277492683179067e-13,
  1.968485945822715e-15, -1.590365928213170e-17,  1.213778760291028e-19, -8.820219845934824e-22,  6.139801571812794e-24, -4.113740104879761e-26,  2.654357744143196e-04,
 -6.488239804159484e-06,  1.090568194742176e-07, -1.461518495816855e-09,  1.686295599288524e-11, -1.740628560125282e-13,  1.645912900802356e-15, -1.448472581543109e-17,
  1.199802682702350e-19, -9.432996563483711e-22,  7.084984426487210e-24, -5.109544887577737e-26,  1.023112491807255e-04, -2.938052386933018e-06,  5.572835388894455e-08,
 -8.321628362412349e-10,  1.060062630134788e-11, -1.200153254556400e-13,  1.238334546982966e-15, -1.184197306186388e-17,  1.062134389085726e-19, -9.014945172979833e-22,
  7.290349379817457e-24, -5.647632610125694e-26,  3.644750290128166e-05, -1.218068819146020e-06,  2.598116961241668e-08, -4.309090296594356e-10,  6.043979558859306e-12,
 -7.486863126251010e-14,  8.410547573495353e-16, -8.721245843161869e-18,  8.453272068471030e-20, -7.730856503807064e-22,  6.719205562623107e-24, -5.581464484202984e-26,
  1.200381325031804e-05, -4.630064666586554e-07,  1.106874390027764e-08, -2.033187956424702e-10,  3.132438235758267e-12, -4.236403183683957e-14,  5.171179455978642e-16,
 -5.803837974252629e-18,  6.068776476948924e-20, -5.970466016589823e-22,  5.568253752522397e-24, -4.952243092372684e-26,  3.656285999005030e-06, -1.615818976938250e-07,
  4.315730494726680e-09, -8.757162007234450e-11,  1.478768240461420e-12, -2.179342517935401e-14,  2.885581497723392e-16, -3.499715975620291e-18,  3.941873460460651e-20,
 -4.165739332894531e-22,  4.163214590542107e-24, -3.959062953844809e-26,  1.030473105194808e-06, -5.183925022034190e-08,  1.542298226744814e-09, -3.448944878047693e-11,
  6.371070237053123e-13, -1.021436640762431e-14,  1.464770582028169e-16, -1.917032959335194e-18,  2.322788510512914e-20, -2.633532487526896e-22,  2.816979903343282e-24,
 -2.861085470389186e-26,  2.688857650268886e-07, -1.530932692647842e-08,  5.059221533239983e-10, -1.244158965555910e-11,  2.509741485950544e-13, -4.370608501929696e-15,
  6.778909499255948e-17, -9.561794356861635e-19,  1.244876058721334e-20, -1.512586531482200e-22,  1.729905818885184e-24, -1.874650653132791e-26,  6.500648458600005e-08,
 -4.167502652855098e-09,  1.525679061154496e-10, -4.117843369862311e-12,  9.056415501457319e-14, -1.710762356834539e-15,  2.866427946983790e-17, -4.352729045350143e-19,
  6.082919015242406e-21, -7.913266125148125e-23,  9.667661412925229e-25, -1.116846248850763e-26,  1.457482631721310e-08, -1.047245939486048e-09,  4.236505236645919e-11,
 -1.252662975429450e-12,  2.999302336840919e-14, -6.138154419459302e-16,  1.109817710055317e-17, -1.812544297295924e-19,  2.716515890943966e-21, -3.780430581455156e-23,
  4.929768046652409e-25, -6.066585706609748e-27,  3.033894970069569e-09, -2.433130783023259e-10,  1.085115464375062e-11, -3.509013283315028e-13,  9.134575913904022e-15,
 -2.023034719202274e-16,  3.943270066229777e-18, -6.920407724108695e-20,  1.111433212378365e-21, -1.653398524315742e-23,  2.299755200394963e-25, -3.012723223168852e-27,
  5.871533362910913e-10, -5.236004611112912e-11,  2.568653226899667e-12, -9.070062081990570e-14,  2.563856535837456e-15, -6.138490576871255e-17,  1.288759484769782e-18,
 -2.428548731918490e-20,  4.176574833812640e-22, -6.637391281762725e-24,  9.841395711106979e-26, -1.371652527864571e-27,  1.058259500799599e-10, -1.045764911237589e-11,
  5.631668752831530e-13, -2.168177949986569e-14,  6.647518990443533e-16, -1.718984063161452e-17,  3.884109903512684e-19, -7.853467051772825e-21,  1.445383517766203e-22,
 -2.452410141107643e-24,  3.874139896196441e-26, -5.741866161809775e-28,  1.779984835909280e-11, -1.943055726108987e-12,  1.146415220623933e-13, -4.805606318488996e-15,
  1.596347411829594e-16, -4.454564369610564e-18,  1.082467704345436e-19, -2.346943073301230e-21,  4.619828101379832e-23, -8.364593816781838e-25,  1.407159844299813e-26,
 -2.216752435204470e-28,  2.800954001946401e-12, -3.367746020582070e-13,  2.172964579737280e-14, -9.904545626824526e-16,  3.561129082833809e-17, -1.071459492079602e-18,
  2.798197689296504e-20, -6.501714266484699e-22,  1.368128917474311e-23, -2.642115283314042e-25,  4.731297262440084e-27, -7.919087414222977e-29,  4.135872107095187e-13,
 -5.462443752508591e-14,  3.847683317088331e-15, -1.904624369608122e-16,  7.404833422094769e-18, -2.400353229189056e-19,  6.732701196624070e-21, -1.675559971284728e-22,
  3.767245862708294e-24, -7.756493199210737e-26,  1.477921418893127e-27, -2.627278678559343e-29,  5.751368872014952e-14, -8.322740787707695e-15,  6.389266765793529e-16,
 -3.430515831622871e-17,  1.440818828221066e-18, -5.028199901695461e-20,  1.513789896499590e-21, -4.032968347654378e-23,  9.683903620444414e-25, -2.124845127908021e-26,
  4.306314124301807e-28, -8.127674847632570e-30,  7.564921144910511e-15, -1.196498812554133e-15,  9.994559229455435e-17, -5.813667347610717e-18,  2.635357711886660e-19,
 -9.893715306556182e-21,  3.195063793918287e-22, -9.107414978324401e-24,  2.334422379182695e-25, -5.456453094051951e-27,  1.175754080665282e-28, -2.355205255175089e-30,
  9.460715018460141e-16, -1.631595765566784e-16,  1.480590624150642e-17, -9.319210081422511e-19,  4.555104385950013e-20, -1.838234705662645e-21,  6.363676688410494e-23,
 -1.939721309858668e-24,  5.304821011207604e-26, -1.320280391359791e-27,  3.023616096881111e-29, -6.425811487262308e-31,  1.131940744856248e-16, -2.123600737796278e-17,
  2.090102783939667e-18, -1.421795185125178e-19,  7.486183455795136e-21, -3.244845213566112e-22,  1.203342649909985e-23, -3.919913170717395e-25,  1.143205956521558e-26,
 -3.028140612772077e-28,  7.367147697555946e-30, -1.660385824176168e-31,  1.305292773743182e-17, -2.657599416384811e-18,  2.832304172361352e-19, -2.079586495866840e-20,
  1.178283820395381e-21, -5.480644893283586e-23,  2.175629673137351e-24, -7.568972763625835e-26,  2.352556851795497e-27, -6.628403173366767e-29,  1.712275077326229e-30,
 -4.090543773618382e-32,  1.463436735261360e-18, -3.225750063583462e-19,  3.716074422717849e-20, -2.940967308595887e-21,  1.791073209891920e-22, -8.931300219056438e-24,
  3.791835447357507e-25, -1.407761708794557e-26,  4.659941996279649e-28, -1.395670386981831e-29,  3.825808169273157e-31, -9.682216115819498e-33,  1.611762879894909e-19,
 -3.836402130524662e-20,  4.768403775803548e-21, -4.061514142815088e-22,  2.655210292871280e-23, -1.417839667459616e-24,  6.431359015217055e-26, -2.545712656634802e-27,
  8.966835733321134e-29, -2.852527019197232e-30,  8.291242924155664e-32, -2.221272774469241e-33,  1.764995112451912e-20, -4.524261844614181e-21,  6.054864628140987e-22,
 -5.540971021605544e-23,  3.882729353525716e-24, -2.217245164316900e-25,  1.073258123986253e-26, -4.524312568916734e-28,  1.693978911518522e-29, -5.718203641484506e-31,
  1.760729389347113e-32, -4.988997690700977e-34,  1.949031147172480e-21, -5.364355342750229e-22,  7.712380633458431e-23, -7.568054286787411e-24,  5.674364682847434e-25,
 -3.459813302208644e-26,  1.784520873792540e-27, -8.000510247857981e-29,  3.180083128686283e-30, -1.137676131609023e-31,  3.706678873893411e-33, -1.109559160396906e-34,
  2.205887627237208e-22, -6.497725754168320e-23,  1.000959226794722e-23, -1.050834950486216e-24,  8.412978612003131e-26, -5.466556209838337e-27,  2.999063065144295e-28,
 -1.427570850508909e-29,  6.014346715216884e-31, -2.276837029724808e-32,  7.837754120512610e-34, -2.475032273870329e-35,  2.606605890718994e-23, -8.187694203229436e-24,
  1.347412683742160e-24, -1.509298262819293e-25,  1.287058190676846e-26, -8.891733918423712e-28,  5.177415661394297e-29, -2.611197209022200e-30,  1.163692266328065e-31,
 -4.652816508757502e-33,  1.689151325600120e-34, -5.616988109258335e-36,  3.283207775229480e-24, -1.095317571828630e-24,  1.918922151855882e-25, -2.286182217820464e-26,
  2.070404014280597e-27, -1.516534050240362e-28,  9.347099042059537e-30, -4.982084553692419e-31,  2.342896376702922e-32, -9.870478589480280e-34,  3.770418366812268e-35,
 -1.317355329719279e-36,  4.509264251122297e-25, -1.590540548784751e-25,  2.954559392799230e-26, -3.729906596351473e-27,  3.574581962612123e-28, -2.766723115666924e-29,
  1.799222227724446e-30, -1.010361097733566e-31,  4.998725600009306e-33, -2.212539312123724e-34,  8.867841955792490e-36, -3.246529766317320e-37,  6.917078961393698e-26,
 -2.566712262042370e-26,  5.031901630713911e-27, -6.701532431071456e-28,  6.767940318198526e-29, -5.512983151720596e-30,  3.768007681640298e-31, -2.220909925660944e-32,
  1.151798812583935e-33, -5.337340685025603e-35,  2.236872185894618e-36, -8.552321123754633e-38,  1.213970247350633e-26, -4.712599991315556e-27,  9.698268711619743e-28,
 -1.355618775934095e-28,  1.435567110096091e-29, -1.224806895795516e-30,  8.757742436747654e-32, -5.393809177818739e-33,  2.919575362563986e-34, -1.410438896088251e-35,
  6.155736063830003e-37, -2.448117255259563e-38,  2.491541236639845e-27, -1.005690092372654e-27,  2.159361672871231e-28, -3.149139105527772e-29,  3.476820541512087e-30,
 -3.089715723953294e-31,  2.298761673663921e-32, -1.471642115344212e-33,  8.271619104938082e-35, -4.145325455560765e-36,  1.874990584723096e-37, -7.720101940570356e-39,
  6.072876660528414e-28, -2.531931281071993e-28,  5.633314794995815e-29, -8.513847786216396e-30,  9.735687182109404e-31, -8.954037453884279e-32,  6.888847625943320e-33,
 -4.556549555938136e-34,  2.643851803066684e-35, -1.366646542655154e-36,  6.370812968965655e-38, -2.701101198651464e-39,  1.757083605764471e-28, -7.513172938429387e-29,
  1.719100971991560e-29, -2.672372098375869e-30,  3.141905380792798e-31, -2.969239552600891e-32,  2.345796113628856e-33, -1.592233871270836e-34,  9.474257451322134e-36,
 -5.018989304653222e-37,  2.396226506731968e-38, -1.039794156203815e-39,  5.775152367317759e-29, -2.513673151254518e-29,  5.866782384332930e-30, -9.304111933346723e-31,
  1.115661549069592e-31, -1.074902658954387e-32,  8.653679864298318e-34, -5.982731546505782e-35,  3.624223463722720e-36, -1.953713281366272e-37,  9.487436975597680e-39,
 -4.185342565638212e-40,  1.707600623814659e-29, -7.506929225939703e-30,  1.771787578725370e-30, -2.841770532160451e-31,  3.445763255855432e-32, -3.356315642751497e-33,
  2.731016620139617e-34, -1.907821962398042e-35,  1.167488323546537e-36, -6.355992447454151e-38,  3.116335980947566e-39, -1.387643329343489e-40,  5.016085193403542e-02,
 -1.030889891017811e-04,  2.177690635791101e-07, -4.713378814224500e-10,  1.040378185173993e-12, -2.332921564484262e-15,  5.285785668442410e-18, -1.208560180267416e-20,
  2.769259557179360e-23, -6.393552016143837e-26,  1.464739216303482e-28, -3.410955229107733e-31,  4.626446290062577e-02, -1.095251218430529e-04,  3.058617334063806e-07,
 -9.101836697295489e-10,  2.734508218149379e-12, -8.137199112079321e-15,  2.386358281285189e-17, -6.900310442030076e-20,  1.969013290046385e-22, -5.557351023051429e-25,
  1.551677575861459e-27, -4.297987147192730e-30,  3.935601586724951e-02, -1.177926357428922e-04,  4.506015944178581e-07, -1.728011673481476e-09,  6.378887105697516e-12,
 -2.273787293135590e-14,  7.879566297643912e-17, -2.668337082754305e-19,  8.861055042380984e-22, -2.893205952253044e-24,  9.305453644798196e-27, -2.953109286722448e-29,
  3.087825019233125e-02, -1.214912713248156e-04,  6.008670654165508e-07, -2.778243551407890e-09,  1.206260909198534e-11, -5.001877344017562e-14,  2.000867463763548e-16,
 -7.769616610594653e-19,  2.941530759504370e-21, -1.089331791135078e-23,  3.956277703241905e-26, -1.412026521745608e-28,  2.234437824001086e-02, -1.160937201963665e-04,
  7.051887703011947e-07, -3.821061926968825e-09,  1.919208416156622e-11, -9.126391363929760e-14,  4.155220881143686e-16, -1.824735626201579e-18,  7.770515932545561e-21,
 -3.221869252491423e-23,  1.304861327832055e-25, -5.175056562978332e-28,  1.491261749857551e-02, -1.011282412340133e-04,  7.307894386128847e-07, -4.578991602648912e-09,
  2.632610024999093e-11, -1.420381977306879e-13,  7.283922187617607e-16, -3.581434905345983e-18,  1.699210328527160e-20, -7.816606518740230e-23,  3.499418613713465e-25,
 -1.529198929642018e-27,  9.179233558262783e-03, -7.984117939205049e-05,  6.737987058650720e-07, -4.841235494116297e-09,  3.159118824933126e-11, -1.917674244827978e-13,
  1.098877656771966e-15, -6.004374884042446e-18,  3.151338820706261e-20, -1.597368475359457e-22,  7.853108284917676e-25, -3.757170822954655e-27,  5.211049042638759e-03,
 -5.707775448724272e-05,  5.563330675089381e-07, -4.553192296373476e-09,  3.348567724350209e-11, -2.271764551973398e-13,  1.445606106160575e-15, -8.726525464423169e-18,
  5.038158714756494e-20, -2.798897262987857e-22,  1.503266477008185e-24, -7.834946042408157e-27,  2.728433883699268e-03, -3.698674030305101e-05,  4.133593640560466e-07,
 -3.831377033982554e-09,  3.157136068541853e-11, -2.380974215431194e-13,  1.674063894472583e-15, -1.111149560153499e-17,  7.024883254498181e-20, -4.258668390340032e-22,
  2.488402492724430e-24, -1.407174462888835e-26,  1.317591531906324e-03, -2.176264555920609e-05,  2.773935670729950e-07, -2.897021659129853e-09,  2.661768984603855e-11,
 -2.221564967953717e-13,  1.718717744167368e-15, -1.249423738840035e-17,  8.617653203643339e-20, -5.680518013805380e-22,  3.598618147147658e-24, -2.200616602657016e-26,
  5.868750162298928e-04, -1.164837358612470e-05,  1.686029602814390e-07, -1.975102976268252e-09,  2.015143210324774e-11, -1.854380613678835e-13,  1.573105754136132e-15,
 -1.248354005368500e-17,  9.364161472345837e-20, -6.691587099232829e-22,  4.582733792427319e-24, -3.022066288928008e-26,  2.411227922233344e-04, -5.681602697746385e-06,
  9.302915332422961e-08, -1.217545459097750e-09,  1.374598243602496e-11, -1.390234916185687e-13,  1.289352489413985e-15, -1.113811613977398e-17,  9.062347172570137e-20,
 -7.002583389536131e-22,  5.171780636516812e-24, -3.669149418817238e-26,  9.139129161442566e-05, -2.529458466643029e-06,  4.668578838979530e-08, -6.802466701986084e-10,
  8.472527112787174e-12, -9.391822070379110e-14,  9.498387966392487e-16, -8.910648890476329e-18,  7.846006760876525e-20, -6.541543295214917e-22,  5.199266656974555e-24,
 -3.960397135877752e-26,  3.196035660210375e-05, -1.029366199090593e-06,  2.134440831057218e-08, -3.451654412411497e-10,  4.730157301821657e-12, -5.733195909367992e-14,
  6.308903389608844e-16, -6.414075689897581e-18,  6.100049208522365e-20, -5.477313111278770e-22,  4.676609052502090e-24, -3.818108769375493e-26,  1.031455821869804e-05,
 -3.834240658696347e-07,  8.903714477015779e-09, -1.593552516451289e-10,  2.397157933094875e-12, -3.170226633076197e-14,  3.788508218446169e-16, -4.166671463134353e-18,
  4.272797558262731e-20, -4.125233209430235e-22,  3.777828378471649e-24, -3.300905397910923e-26,  3.072881715520904e-06, -1.308881034588300e-07,  3.393582786903258e-09,
 -6.705291610943514e-11,  1.104898120922198e-12, -1.591418292214459e-14,  2.061820045568866e-16, -2.449248361606266e-18,  2.704209742396897e-20, -2.803312357122520e-22,
  2.749887182488294e-24, -2.568151069640477e-26,  8.453973169416930e-07, -4.099743455774825e-08,  1.183417894431070e-09, -2.575587299400284e-11,  4.640259146782355e-13,
 -7.267087637155589e-15,  1.019228178652888e-16, -1.305931177486035e-18,  1.550443093520461e-20, -1.723674071767786e-22,  1.809029302065113e-24, -1.803777935279185e-26,
  2.148859383441411e-07, -1.179699216464689e-08,  3.780952809544049e-10, -9.045256666298144e-12,  1.778756562241055e-13, -3.024522922186049e-15,  4.586111850716728e-17,
 -6.330524875563773e-19,  8.072688950654853e-21, -9.614537707205730e-23,  1.078526431237899e-24, -1.147050578392787e-26,  5.049623524955719e-08, -3.122359025629945e-09,
  1.108294810162895e-10, -2.908939981401946e-12,  6.234454387683008e-14, -1.149462963154364e-15,  1.882163391370860e-17, -2.796030037285241e-19,  3.825958783102841e-21,
 -4.877130271637341e-23,  5.842547794824747e-25, -6.622287445139207e-27,  1.097887703330217e-08, -7.611421179149026e-10,  2.984986541869205e-11, -8.580767301643898e-13,
  2.001507882249861e-14, -3.996711191419808e-16,  7.059835080970732e-18, -1.127631505077924e-19,  1.654308976887804e-21, -2.255330612145792e-23,  2.883092348043725e-25,
 -3.480229559660149e-27,  2.210733308558202e-09, -1.711395940507717e-10,  7.398753791898446e-12, -2.325676300220144e-13,  5.896585101404552e-15, -1.273910113221316e-16,
  2.425294116726178e-18, -4.161712909882664e-20,  6.541096515690303e-22, -9.530489015002669e-24,  1.299252623814902e-25, -1.669243671999404e-27,  4.127923366701586e-10,
 -3.555051434680092e-11,  1.690733707865043e-12, -5.802656778666926e-14,  1.597339754822204e-15, -3.730063965077430e-17,  7.647560918405684e-19, -1.408816258538561e-20,
  2.370721786539925e-22, -3.689415554402605e-24,  5.360738245399814e-26, -7.326534989917413e-28,  7.158275876591299e-11, -6.835401278966342e-12,  3.569133231676848e-13,
 -1.335594627655572e-14,  3.987523577114191e-16, -1.005608426450812e-17,  2.218709398965609e-19, -4.385103729474174e-21,  7.896007689213107e-23, -1.311814199570591e-24,
  2.030578802651123e-26, -2.950837914945430e-28,  1.155006968222821e-11, -1.219125724741346e-12,  6.976188238185662e-14, -2.842686023009119e-15,  9.195785377581102e-17,
 -2.502527618260828e-18,  5.937856964984079e-20, -1.258378856468789e-21,  2.423390607867102e-23, -4.296155339346616e-25,  7.081542163221660e-27, -1.093794334402120e-28,
  1.738047951830253e-12, -2.022120087312212e-13,  1.265891582884355e-14, -5.610194645878044e-16,  1.964583135976943e-17, -5.765121363312220e-19,  1.470204737573368e-20,
 -3.339180763570674e-22,  6.874523269636159e-24, -1.299923912705012e-25,  2.280911948988341e-27, -3.743272156389054e-29,  2.446029322893519e-13, -3.128589516425970e-14,
  2.139180418019570e-15, -1.029908027191778e-16,  3.900735073993920e-18, -1.233489883835182e-19,  3.378944838647942e-21, -8.220906422669193e-23,  1.808576117502676e-24,
 -3.646489992580638e-26,  6.808750996373263e-28, -1.186900712329141e-29,  3.230497214457044e-14, -4.531354558940500e-15,  3.378764802563243e-16, -1.765214252925493e-17,
  7.225015923667786e-19, -2.460338226945629e-20,  7.235786997684686e-22, -1.884985859185523e-23,  4.429699554234301e-25, -9.519850795665419e-27,  1.891010593069429e-28,
 -3.500451033113896e-30,  4.020537280791149e-15, -6.170159389276725e-16,  5.009592011222558e-17, -2.837010403287530e-18,  1.253835510876751e-19, -4.594985628770354e-21,
  1.450086452178972e-22, -4.043065710032867e-24,  1.014528339584095e-25, -2.323249292145677e-27,  4.907992406842356e-29, -9.644931098354604e-31,  4.738914798284758e-16,
 -7.938902993677222e-17,  7.008092378497345e-18, -4.297447297311671e-19,  2.049138338846479e-20, -8.076424919696523e-22,  2.733481808412349e-23, -8.153300586540757e-25,
  2.183770801102622e-26, -5.326813829269269e-28,  1.196431172975717e-29, -2.495313894555564e-31,  5.321943768633690e-17, -9.710729859578187e-18,  9.306394927439105e-19,
 -6.172606873030700e-20,  3.172783269310623e-21, -1.343985800550258e-22,  4.875647035287791e-24, -1.555035465745854e-25,  4.443773333359248e-27, -1.154195239563904e-28,
  2.755273832758225e-30, -6.096868103202756e-32,  5.735855793316793e-18, -1.137379664114813e-18,  1.181590586006488e-19, -8.467057197531719e-21,  4.687265509255396e-22,
 -2.132333060335327e-23,  8.286262560108739e-25, -2.824361367904005e-26,  8.607168906101974e-28, -2.379391131108154e-29,  6.034529035818203e-31, -1.416205322115583e-32,
  5.984349447942069e-19, -1.286615457491183e-19,  1.446608856011574e-20, -1.118557638538455e-21,  6.662289466212994e-23, -3.252163938519478e-24,  1.352772881104815e-25,
 -4.924478987231304e-27,  1.599474827822077e-28, -4.703607918279479e-30,  1.266738773861197e-31, -3.151425883372071e-33,  6.106541073973480e-20, -1.420039167170437e-20,
  1.725038262012573e-21, -1.437319222032202e-22,  9.200235465944642e-24, -4.814292470384159e-25,  2.141684569499143e-26, -8.320026303080091e-28,  2.878114363490321e-29,
 -8.997494872929193e-31,  2.571491017863546e-32, -6.777698065675450e-34,  6.169128986297419e-21, -1.547657040610473e-21,  2.027433109258448e-22, -1.817491803142753e-23,
  1.248585358314689e-24, -6.995586533665570e-26,  3.324732033239585e-27, -1.377012049647870e-28,  5.068692337233995e-30, -1.683068944439364e-31,  5.100634346072132e-33,
 -1.423188071551189e-34,  6.259260290375507e-22, -1.689228866424748e-22,  2.381248745187199e-23, -2.292541904036758e-24,  1.687611410019885e-25, -1.010947143608065e-26,
  5.126255822360784e-28, -2.260808649798786e-29,  8.845037363336625e-31, -3.116210465677051e-32,  1.000362836111158e-33, -2.951891521866854e-35,  6.485461558432536e-23,
 -1.876965500662253e-23,  2.840202111211988e-24, -2.930367537085966e-25,  2.307033242239371e-26, -1.475014167667092e-27,  7.967043476243009e-29, -3.735732568073294e-30,
  1.551160105314186e-31, -5.790294204541921e-33,  1.966342524123700e-34, -6.128341638502892e-36,  6.995575487012699e-24, -2.163515290539109e-24,  3.504179786553131e-25,
 -3.864690303560044e-26,  3.246468681495521e-27, -2.210539476316041e-28,  1.269236520643663e-29, -6.315326863817755e-31,  2.777915758201210e-32, -1.096753790983491e-33,
  3.933250262928119e-35, -1.292566726364444e-36,  8.028382273546420e-25, -2.642788133250081e-25,  4.566291467718872e-26, -5.366888779499852e-27,  4.796800950850582e-28,
 -3.469150323303649e-29,  2.112072769266581e-30, -1.112459016756939e-31,  5.171762330712758e-33, -2.154763280071734e-34,  8.142955033384278e-36, -2.815674148757623e-37,
  1.004237333140086e-25, -3.502855737691670e-26,  6.431064861731451e-27, -8.025713275431971e-28,  7.605860954781399e-29, -5.823459521040673e-30,  3.747547953927327e-31,
 -2.083226348483196e-32,  1.020613086243382e-33, -4.474793957916020e-35,  1.777101130711644e-36, -6.448508818607774e-38,  1.405073674706850e-26, -5.167063340037384e-27,
  1.003346351300708e-27, -1.323720885993054e-28,  1.324616899103069e-29, -1.069433535441587e-30,  7.246628852765080e-32, -4.235782360273029e-33,  2.179089714641550e-34,
 -1.001917482595062e-35,  4.167396265175965e-37, -1.581737952584101e-38,  2.257897532940482e-27, -8.704666849070570e-28,  1.778116336822608e-28, -2.467207243829167e-29,
  2.594010044418992e-30, -2.197795990944831e-31,  1.560909994601553e-32, -9.550817442718870e-34,  5.137061060930883e-35, -2.466533593726099e-36,  1.070125651143098e-37,
 -4.231514160553988e-39,  4.271430857123807e-28, -1.715539047237829e-28,  3.663589944010107e-29, -5.314102912999234e-30,  5.836194749894768e-31, -5.159882602688851e-32,
  3.819939454425806e-33, -2.433734867037452e-34,  1.361557366123963e-35, -6.792696824749131e-37,  3.059021039682948e-38, -1.254209501068434e-39,  9.690460273561597e-29,
 -4.026857932185054e-29,  8.926954906080794e-30, -1.344288283973348e-30,  1.531767373636582e-31, -1.403932256290099e-32,  1.076511920113005e-33, -7.097372843380564e-35,
  4.105172419680282e-36, -2.115561334362345e-37,  9.832871955357543e-39, -4.157051113044851e-40,  2.643644142770866e-29, -1.128228184965727e-29,  2.576013000473991e-30,
 -3.995902345357953e-31,  4.688129085735818e-32, -4.421435304786372e-33,  3.486139625900576e-34, -2.361691154723665e-35,  1.402646151699922e-36, -7.417034535430484e-38,
  3.534896237132717e-39, -1.531284624797852e-40,  8.323959923533388e-30, -3.619706840905148e-30,  8.439479529468196e-31, -1.337023198572750e-31,  1.601591613033644e-32,
 -1.541536393992103e-33,  1.239829182456159e-34, -8.563440164978146e-36,  5.182779439757868e-37, -2.791378148869517e-38,  1.354339777958685e-39, -5.969557898386045e-41,
  2.401176144692044e-30, -1.055231218341804e-30,  2.489573150082400e-31, -3.991422428987892e-32,  4.837833901759789e-33, -4.710400072608725e-34,  3.831351085874883e-35,
 -2.675477911614506e-36,  1.636648235434485e-37, -8.906945338892199e-39,  4.365516074568392e-40, -1.943205548669877e-41,  };
  int offset = -46;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 46;
    if (std::isnan(t)) {
      fill_n(rr+offset, 46, 0.5);
      fill_n(ww+offset, 46, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 46; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=46; ++j) {
        const int boxof = it*552+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
