/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 19:18:58 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.ortholog;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.gmod.schema.sequence.Feature;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.chado.FeatureLocLazyQualifierValue;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierLazyLoading;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class MatchPanel_ESTest extends MatchPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Feature feature0 = new Feature();
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue(feature0, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("  not found! Try again!", featureLocLazyQualifierValue0);
      boolean boolean0 = MatchPanel.isMatchTag((Qualifier) qualifierLazyLoading0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isMatchTag((Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isMatchTag((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isClusterTag((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, genbankDocumentEntry0);
      matchPanel0.getGeneNameList(true);
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      boolean boolean0 = MatchPanel.isMatchTag("/paralogous_to=!,+6^Z+B7}X1");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, emblDocumentEntry0);
      boolean boolean0 = matchPanel0.isEmpty();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, emblDocumentEntry0);
      matchPanel0.getMatchQualifiers();
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastDocumentEntry0, false);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, mSPcrunchDocumentEntry0);
      // Undeclared exception!
      try { 
        matchPanel0.updateFromFeature((uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      boolean boolean0 = MatchPanel.isClusterTag("/paralogous_to=Ortholog/Paralog/Similarity");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      boolean boolean0 = MatchPanel.isClusterTag("orthologous_to");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      boolean boolean0 = MatchPanel.isClusterTag("Ortholog/Paralog/Similarity");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      boolean boolean0 = MatchPanel.isMatchTag("orthologous_to");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      boolean boolean0 = MatchPanel.isMatchTag("default_schema");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      String string0 = MatchPanel.getDescription();
      assertEquals("Ortholog/Paralog/Similarity", string0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, publicDBDocumentEntry0);
      matchPanel0.getGeneNameList();
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, publicDBDocumentEntry0);
      QualifierVector qualifierVector0 = new QualifierVector();
      // Undeclared exception!
      try { 
        matchPanel0.updateFromQualifiers(qualifierVector0, (uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, genbankDocumentEntry0);
      matchPanel0.setEmpty(true);
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("/similarity=uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel$2", "Ortholog/Paralog/Similarity");
      boolean boolean0 = MatchPanel.isMatchTag(qualifier0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((uk.ac.sanger.artemis.Feature) null, genbankDocumentEntry0);
      // Undeclared exception!
      try { 
        matchPanel0.featureChanged((FeatureChangeEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }
}
