//
//  Server.cpp  --  Server function implementations
//  -- created  4/16/00   updated 4/19/00
/////////////////////////////////////////////////////

#include <iostream.h>
#include <string>
#include "Server.h"
#include "imap.h"
#include "SelectFolder.h"
#include "Althea.h"
#include "errors.h"
#include "callbacks.h"
#include "support.h"

extern Althea gAlthea;


void Server::set_Server_Name( const string &new_server_name )
{
    server_name = new_server_name;
}

void Server::set_Port_Number( int new_port_number )
{
    port_number = new_port_number;
}

void Server::set_Username( const string &new_username )
{
    username = new_username;
}

void Server::set_Password( const string &new_password )
{
    password = new_password;
}

void Server::set_Current_State( server_state s )
{
    current_state = s;
}

void Server::set_IMAP_Server_Name( const string &NewIMAPServerName )
{
    imap_server_name = NewIMAPServerName;
}

void Server::set_SMTP_Server_Name( const string &NewSMTPServerName )
{
    smtp_server_name = NewSMTPServerName;
}

void Server::set_FCC_Folder( const string &NewFCCFolder )
{
    fccfolder = NewFCCFolder;
}

void Server::set_Folder_Root( const string &NewFolderRoot )
{
    folder_root = NewFolderRoot;
}

void Server::set_EMail_Address( const string &NewEMailAddress )
{
    emailaddress = NewEMailAddress;
}

void Server::set_Save_Password( bool saveit )
{
    savepassword=saveit;
}

void Server::set_Use_SSL( bool use_ssl )
{
    usessl=use_ssl;
}



string Server::get_EMail_Address()
{
  return( emailaddress );
}

string Server::get_Server_Name()
{
    return( server_name );
}

string Server::get_SMTP_Server_Name()
{
    return( smtp_server_name );
}

string Server::get_IMAP_Server_Name()
{
    return( imap_server_name );
}

int Server::get_Port_Number()
{
    return( port_number );
}

string Server::get_Username()
{
    return( username );
}

string Server::get_Password()
{
    return( password );
}
bool Server::get_Save_Password()
{
    return( savepassword );
}
bool Server::get_Use_SSL()
{
    return( usessl );
}

string Server::get_FCC_Folder()
{
    return( fccfolder );
}

int Server::get_Num_Folders()
{
    return( folder_list.size() );
}

server_state Server::get_Current_State()
{
    return( current_state );
}

Folder * Server::get_Folder( int number )
{
    list<Folder>::iterator it;
    int count = 1;

    it = folder_list.begin();

    while( it != folder_list.end() && count < number )
    {
	count++;
        it++;
    }

    if( count == number )
        return( &(*it) );

    else
        return( NULL );
}

AConPtr Server::get_Connection()
{
    return( network_connection );
}

string Server::get_Folder_Root()
{
    return( folder_root );
}

bool Server::get_Reserved() 
{
  return( reserved );
}



void Server::reserve()
{
  reserved=true;
}

void Server::release()
{
  reserved=false;
}


void Server::add_Folder( Folder &F)
{
    if( F.get_Folder_Name() != "INBOX" )
        F.set_Full_Folder_Name( folder_root + "/" + F.get_Folder_Name() );
    else
        F.set_Full_Folder_Name( F.get_Folder_Name() );
    
    F.set_Server_Ptr( this );
    folder_list.push_back( F );
}

void Server::delete_Folder( const string &name )
{
    list<Folder>::iterator it;
    it = folder_list.begin();
    while( it != folder_list.end() && (*it).get_Folder_Name() != name )
        it++;
    if( (*it).get_Folder_Name() == name )
        folder_list.erase( it );
}

// Network-related functions go here

int Server::login()
{
    //if( password == "" ) {
    //  create_password_window( this );
    //  return( BAD_LOGIN );
    //} else
  return( IMAPLogin( network_connection, imap_server_name, port_number, username, password, usessl ) );

}

int Server::check_Connected()
{

int ret_val;


	ret_val = IMAPCheckMail( network_connection );

	if (ret_val==LOST_CONNECTION_TO_SERVER)
	{
cout << "reconnecting" << endl;
		ret_val=login();
		if (ret_val==SUCCESS)
		{
			if (gAlthea.get_Current_Folder()!=NULL)
			{
				gAlthea.get_Current_Folder()->clear();
				ret_val=gAlthea.get_Current_Folder()->get_Message_Headers();

	cout << "ret_val=" << ret_val << endl;
	//			if (ret_val==SUCCESS)
	//			{
					update_message_list(gAlthea.get_Current_Folder());
	//			} else 
	//			{
	//				error( "Problem reselecting folder" );
	//				return ret_val;
	//			}
			}
		} else {error( "Problem reconnecting" ); return ret_val;}

	}  
	return SUCCESS;




}




int Server::logout()
{
    int return_code;
    if( return_code == SUCCESS ) // Successful login
        set_Current_State( AUTH );
    return( return_code );
}

int Server::get_Folder_List_From_Server()
{
    list<string> folder_names;
    int return_code;
    Folder *F;
    
    return_code = getIMAPFolders( network_connection, folder_names, folder_root );

    if( return_code == SUCCESS )  //  Successful
    {
        list<string>::iterator it = folder_names.begin();
        while( it != folder_names.end() )
        {
            if( *it != "\r" )  // Because of the way the names were parsed, there's a \r in the empty name
            {
                F = new Folder( *it );
                add_Folder( *F );
            }
            it++;
        }
    }

    return( return_code );
}

int Server::get_New_Mail()
{
    return( GetNewMail( network_connection, *get_Folder( 1 ) ) );
}

    

//  For Debugging Purposes Only

void Server::display()
{
    //list<Folder>::iterator it;
    
    cout << "Server Info" << endl << "   " << server_name << endl
        << "   " << port_number << endl
        << "   " << username << endl
        << "   " << password << endl << "|" << endl
        << "Folder Info" << endl;

    /*it = folder_list.begin();
    while( it != folder_list.end() )
    {
        (*it).display();
        it++;
    }*/
    
}




