/** @file
 * CPUM - Disassembler.
 */

/*
 * Copyright (C) 2006-2010 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */

#ifndef ___VBox_vmm_cpumdis_h
#define ___VBox_vmm_cpumdis_h

#include <VBox/vmm/cpum.h>
#include <iprt/x86.h>
#include <VBox/dis.h>


RT_C_DECLS_BEGIN
/** @addtogroup grp_cpum
 * @{
 */

#ifdef IN_RING3
VMMR3DECL(int) CPUMR3DisasmInstrCPU(PVM pVM, PVMCPU pVCpu, PCPUMCTX pCtx, RTGCPTR GCPtrPC, PDISCPUSTATE pCpu, const char *pszPrefix);

# ifdef DEBUG
/** @deprecated  Use DBGFR3DisasInstrCurrentLog().  */
VMMR3DECL(void) CPUMR3DisasmInstr(PVM pVM, PVMCPU pVCpu, PCPUMCTX pCtx, RTGCPTR pc, const char *pszPrefix);
# else
/** @deprecated  Use DBGFR3DisasInstrCurrentLog(). */
#  define CPUMR3DisasmInstr(pVM, pVCpu, pCtx, pc, pszPrefix)                   do {} while (0)
# endif

#endif /* IN_RING3 */

/** @} */
RT_C_DECLS_END


#endif

