//                       -*- mode: C++ -*-
//
// Copyright(C) 2007 Christian Dietrich <stettberger@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KOPETESILC_SILCBUDDYATTRIBUTES_H
#define KOPETESILC_SILCBUDDYATTRIBUTES_H

#include <qstring.h>

#include <klocale.h>

// include libsilc stuff into a separate namespace
namespace SilcTK {
#include <silc.h>
#include <silcclient.h>
}

//#include "silcprotocol.h"
//#include "silccontact.h"

class SilcBuddyContact;

/**
 * @brief class for managing silcattributes
 *
 * every SilcBuddyContact has an attributes field, where his SilcAttributes
 * are managed
 *
 * @author Christian Dietrich <stettberger@brokenpipe.de>
 */

class SilcBuddyAttributes {
public:

  SilcBuddyAttributes(SilcBuddyContact *);
  virtual ~SilcBuddyAttributes();

  void updateAttributes(SilcTK::SilcDList attrs);

  QString getInformations() const;

private:
  /**
   * @brief SilcBuddyContact this attributes belongs to
   */
  SilcBuddyContact *buddy;

  /**
   * @brief SILC_ATTRIBUTE_USER_INFO
   */
  SilcTK::SilcVCard _vcard;
  
  /**
   * @brief SILC_ATTRIBUTE_STATUS_MOOD
   */
  SilcTK::SilcAttributeMood _mood;
  
  /**
   * @brief SILC_ATTRIBUTE_STATUS_FREETEXT or SILC_ATTRIBUTE_STATUS_MESSAGE 
   */
  QString _status_text;

  /**
   * @brief SILC_ATTRIBUTE_PREFERRED_LANGUAGE
   */
  QString _language;

  /**
   * @brief SILC_ATTRIBUTE_PREFERRED_CONTACT
   */
  SilcTK::SilcAttributeContact _contactinfo;

  /**
   * @brief SILC_ATTRIBUTE_TIMEZONE
   */
  QString _timezone;

  /**
   * @brief SILC_ATTRIBUTE_GEOLOCATION
   */
  SilcTK::SilcAttributeObjGeo _geolocation;

  /**
   * @brief SILC_ATTRIBUTE_USER_ICON
   *
   * path to the user icon
   *
   */
  QString _usericon;

  /**
   * @brief SilcAttributeMood to QString
   */
  QString getMood() const;
  /**
   * @brief SilcAttributeContact to QString
   */
  QString getContact() const;
};


#endif // KOPETESILC_SILCBUDDYATTRIBUTES_H
