/* $Id: log.h,v 1.1.1.1 1998/07/29 15:14:29 proff Exp $
 * $Copyright$
 */

#ifndef LOG_H
#define LOG_H

/*
 * if anyone can work out how to do this in one syslog call, without
 * using vsprintf, I'd dearly like to know. CPP IS LAME.
 *
 * You need to call these macros like so:
 *
 *	logd(("messge id %s", msgid));
 */

#define logt(x) \
do\
{\
	char _buf[4096]; /* security - don't let this overflow */ \
	logPrintP = _buf; \
	syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
} while(0)

#define logl(x) \
do\
{\
	if (con->logListMerge)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logn(x) \
do\
{\
	if (con->logNocem)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define loglc(x) \
do\
{\
	if (con->logListMergeCorrelation)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logd(x) \
do\
{\
	if (con->logDebug)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define loge(x) \
do\
{\
	if (con->logErrors)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_ERR, (errno ? "%s:%d:%m: %s" : "%s:%d: %s"), __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logen(x) \
do\
{\
	if (con->logErrors)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_ERR, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logw(x) \
do\
{\
	if (con->logWarnings)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_WARNING, (errno ? "%s:%d:%m: %s" : "%s:%d: %s"), __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logwn(x) \
do\
{\
	if (con->logWarnings)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_WARNING, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define log(x) \
do\
{\
	if (con->logInfo)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_INFO, "%s", logPrint x);\
	}\
} while(0)

#define loginne(x) \
do\
{\
	if (con->logErrors && con->logInn)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_ERR, "%s", logPrint x);\
	}\
} while(0)

#define loginnw(x) \
do\
{\
	if (con->logWarnings && con->logInn)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_WARNING, "%s", logPrint x);\
	}\
} while(0)

#define loginn(x) \
do\
{\
	if (con->logInfo && con->logInn)\
	{\
		char _buf[4096]; /* security - don't let this overflow */ \
		logPrintP = _buf; \
		syslog(LOG_INFO, "%s", logPrint x);\
	}\
} while(0)


#include "log.ext"

#endif LOG_H
