/* $Id: nconf.h,v 1.1.1.1 1998/07/29 15:14:28 proff Exp $
 * $Copyright$
 */

#ifndef NCONF_H
#define NCONF_H

#include "config.h"

/*
 * you will definately want to be more frugal on large nntpcache servers.
 * each additional nntpcache child uses around 3-10 file descriptors for
 * itself and an additional fd in the master process.
 * you need to keep in mind any OS imposed limitation. On *BSD the
 * limit can be modified via:
 *
 *	sysctl -w kern.maxfiles=n
 *
 * FreeBSD also supports:
 *
 *	sysctl -w kern.maxfilesperproc=m
 *
 * where m and n are numerical limits.
 */

#define MAX_CHILDREN 256

/*
 * based on the above we adjust FD_SETSIZE accordingly. This is
 * probably evil on older OS's. But we like evil.
 */

#if (NC_FD_SETSIZE > 0) && (MAX_CHILDREN + 12 > NC_FD_SETSIZE)
#  ifdef FD_SETSIZE
#     error FD_SETSIZE already defined. sys/types.h already included?
#  else
#     define FD_SETSIZE 12+MAX_CHILDREN
#  endif
#endif  

/*
 * max length of various variables types or buffers. 
 * nb. this generally includes the \0 in string variables
 */

#define MAX_BFR		512*8+1
#define MAX_LINE	512*8+1 /* line of data from the server */
#define MAX_CMD		512+1   /* max command line from client (rfc977) */
#define MAX_URL		512+1	/* max url for http server */
#define MAX_USERNAME	16+1	/* max username length + nil */
#define MAX_FILE	128	/* max length of filename without directory name */
#define MAX_GROUP	256	/* longest usenet group */
#define MAX_SUBGROUP	MAX_FILE
#define MAX_PATH	1024	/* max dir/file name length */
#define MAX_HOST	128	/* max FQDN length */
#define MAX_IPNAME	3+1+3+1+3+1+3+1	/* max dotted quad length */
/*                      xxx.xxx.xxx.xxx\0 */
#define MAX_HEADER	2048
#define MAX_MSGID	500	/* this was 127, but pine generated moby-msgid's put an */
				/* end to all that. gross */
#define MAX_XOVER	4096
#define MAX_NOCEM	8	/* max numer of NOCEM groups to monitor */
/* truncate arguments longer than this */
#define MAX_SYSLOG	256

/*
 * do not increase this value past 512
 */

#define XOVER_INDEX_SIZE 512

/* history file entry prepended length header size */
#define HEADER_LEN 5

/* highest used fd */
#define FD_HIGH MAX_CHILDREN+10

#define IO_BUF_LEN 65000

#define bool int
#define POINTER void *
#ifdef HAVE_MMAP
#  define MMALLOC
#  ifdef HAVE_MMAP_ANON
#    define USE_MMAP_ANON
#  endif
#else
#  error you need a working mmap() for this version of nntpcache. try 0.88.3
#endif

#ifdef EFENCE
#  undef MMALLOC
#endif

#define USE_REGEX

#ifdef USE_REGEX
#  define nn_regcomp regcomp
#  define nn_regexec regexec
#endif

#define EL(x) ((x)[0]=='.' && ((x)[1]=='\r' || (x)[1]=='\n'))
#define SKIPWHITE(x) {while (isspace(*(x))) (x)++;}
#define SKIPNOWHITE(x) {while (*(x) && !isspace(*(x))) (x)++;}
#define SKIPSPACE(x) {while (*(x)== ' ') (x)++;}
#define SKIPNOSPACE(x) {while (*(x) && *(x)!=' ') (x)++;}

#define STR(x) #x

extern void ncExit(int x);

#define Exit(x) \
	do\
	{\
	     ncExit(x);\
	     exit(0); /* fool the compiler */\
	} while (0)

#define NOTREACHED \
	do\
	{\
	     assert ("PC" == "never at this location, by george!");\
	     Exit(1);\
	} while (0)

#define SPAM "spam"

/* ego damage control module */

#define XCACHE "X-Cache: nntpcache " VERSION " (see http://www.nntpcache.org/)\r\n"

#endif /* NCONF_H */
