/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLpreName (const char Fname[], char Pname[])

Purpose:
  Return the last component of a file name stripped of its extension

Description:
  This routine takes a filename and returns the last component of the filename
  stripped of the filename extension.  The extension is the part of the last
  component of the path name beginning with (and including) a period.  The
  string returned for a path name "/abc/def.ghi" is "def".

Parameters:
  <-  int FLpreName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the file name
  <-  char Pname[]
      Output string filename string without the extension.  This string is
      at most FILENAME_MAX characters long including the terminating null
      character.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.5 $  $Date: 1997/10/14 14:38:58 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLpreName.c 1.5 1997/10/14 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */


int
FLpreName (Fname, Pname)

     const char Fname[];
     char Pname[];

{
  char *p;
  int n;
  char Bname[FILENAME_MAX];

  FLbaseName (Fname, Bname);
  p = strchr (Bname, '.');
  if (p != NULL)
    *p = '\0';
  n = STcopyMax (Bname, Pname, FILENAME_MAX-1);

  return n;
}
