/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFsetHinfo (const char Info[])
  char *AFgetHinfo (void)

Purpose:
  Set the audio file header information string
  Get the audio file header information string

Description:
  This routine sets the information string to be written to an audio file
  header.  By default the header information records specify the date and user
  name.  This routine allows the user to specify information records that are
  used in addition to, or in place of, the standard header information.  This
  routine must be called before the audio file to be created is first opened
  using AFopenWrite.  AFopenWrite resets the header string to a NULL string.

  Standard Header Information: 
    date: 1994/01/25 19:19:39 UTC    date
    sample_rate: 8012.5              sampling frequency (if non-integer)
    user: kabal@aldebaran            user
    program: CopyAudio               program name (set by UTsetProg)

  Additional structured information records should follow this format; a named
  field terminated by a colon followed by numeric data or a character string.
  Comments can follow as unstructured information.  For the purpose of this
  routine, records are separated by newline characters. The last record need
  not be terminated by a newline character.  When written to the header, the
  newline characters are replaced by nulls.  To place a newline character
  into the header without having it serve as a record separator, escape the
  newline character by preceding it with a backslash character, i.e. in a
  C-language string an escaped newline character would appear as "\\\n".

  If the input header information string is a NULL pointer, the standard
  information is used.  If the first character of the header information string
  is a newline character, the input header information string is added to the
  existing information records (the standard information and/or any previously
  specified records).  Otherwise the input header information string replaces
  the standard information.  The following examples illustrate the behaviour.

  - AFsetHinfo (NULL)
      Reset, use only the standard information records
  - AFsetHinfo ("")
      No header information records
  - AFsetHinfo ("<info>")
      Replace existing information with <info>; do not use the standard
      information records
  - AFsetHinfo ("\n<info>")
      Add <info> to the existing information string, if the overall information
      string begins with a newline character, the overall information string
      appears in the header after the standard information string

  The procedure AFgetHinfo is used internally by the audio file routines to
  retrieve the user supplied header information string.

Parameters:
  AFsetHinfo:
   -> const char Info[]
      String containing the user supplied header information
  AFgetHinfo:
  <-  char *AFgetUinfo
      Pointer to the header information string.  A NULL pointer indicates that
      no information string has been set.

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.33 $  $Date: 1998/06/17 15:41:21 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFsetHinfo.c 1.33 1998/06/17 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/AFmsg.h>
#include <libtsp/AFpar.h>

static char *Uinfo = NULL;


void
AFsetHinfo (Info)

     const char Info[];

{
  int Ni;
  static int Ninfo = 0;

  if (Info == NULL) {
    UTfree ((void *) Uinfo);
    Uinfo = NULL;
    Ninfo = 0;
  }
  else {

/* Copy the header information string to an allocated buffer */
    if (Info[0] == '\n') {
      Ni = Ninfo;
      Ninfo += strlen (Info);
      Uinfo = (char *) UTrealloc (Uinfo, Ninfo+1);
      strncpy (&Uinfo[Ni], Info, (size_t) (Ninfo-Ni));
      Uinfo[Ninfo] = '\0';
   }
    else {
      Ninfo = strlen (Info);
      UTfree ((void *) Uinfo);
      Uinfo = (char *) UTmalloc (Ninfo+1);
      strncpy (Uinfo, Info, (size_t) Ninfo);
      Uinfo[Ninfo] = '\0';
    }
  }
}

char *
AFgetHinfo ()

{
  return Uinfo;
}
