/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.threading;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.broadinstitute.gatk.utils.threading.ThreadEfficiencyMonitor;

@Invariant(value={"activeThreads.size() <= nThreadsToCreate", "countDownLatch.getCount() <= nThreadsToCreate", "nThreadsCreated <= nThreadsToCreate"})
public class EfficiencyMonitoringThreadFactory
extends ThreadEfficiencyMonitor
implements ThreadFactory {
    final int nThreadsToCreate;
    final List<Thread> activeThreads;
    int nThreadsCreated = 0;
    final CountDownLatch countDownLatch;

    public EfficiencyMonitoringThreadFactory(int nThreadsToCreate) {
        if (nThreadsToCreate <= 0) {
            throw new IllegalArgumentException("nThreadsToCreate <= 0: " + nThreadsToCreate);
        }
        this.nThreadsToCreate = nThreadsToCreate;
        this.activeThreads = new ArrayList<Thread>(nThreadsToCreate);
        this.countDownLatch = new CountDownLatch(nThreadsToCreate);
    }

    @Ensures(value={"result >= 0"})
    public int getNThreadsCreated() {
        return this.nThreadsCreated;
    }

    protected void waitForAllThreadsToComplete() throws InterruptedException {
        this.countDownLatch.await();
    }

    @Override
    @Ensures(value={"activeThreads.size() <= old(activeThreads.size())", "! activeThreads.contains(thread)", "countDownLatch.getCount() <= old(countDownLatch.getCount())"})
    public synchronized void threadIsDone(Thread thread) {
        ++this.nThreadsAnalyzed;
        super.threadIsDone(thread);
        if (this.activeThreads.remove(thread)) {
            this.countDownLatch.countDown();
        }
    }

    @Override
    @Ensures(value={"activeThreads.size() > old(activeThreads.size())", "activeThreads.contains(result)", "nThreadsCreated == old(nThreadsCreated) + 1"})
    public synchronized Thread newThread(Runnable runnable) {
        if (this.activeThreads.size() >= this.nThreadsToCreate) {
            throw new IllegalStateException("Attempting to create more activeThreads than allowed by constructor argument nThreadsToCreate " + this.nThreadsToCreate);
        }
        ++this.nThreadsCreated;
        TrackingThread myThread = new TrackingThread(runnable);
        this.activeThreads.add(myThread);
        return myThread;
    }

    private class TrackingThread
    extends Thread {
        private TrackingThread(Runnable runnable) {
            super(runnable);
        }

        @Override
        public void run() {
            super.run();
            EfficiencyMonitoringThreadFactory.this.threadIsDone(this);
        }
    }
}

