/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import picard.fastq.ReadNameEncoder;
import picard.illumina.parser.ClusterData;

public class IlluminaReadNameEncoder
implements ReadNameEncoder {
    final String runBarcode;

    public IlluminaReadNameEncoder(String runBarcode) {
        this.runBarcode = runBarcode;
    }

    @Override
    public String generateReadName(ClusterData cluster, Integer pairNumber) {
        return this.runBarcode + ":" + cluster.getLane() + ":" + cluster.getTile() + ":" + cluster.getX() + ":" + cluster.getY() + IlluminaReadNameEncoder.generatePairNumberSuffix(pairNumber);
    }

    private static String generatePairNumberSuffix(Integer pairNumber) {
        if (pairNumber == null) {
            return "";
        }
        return "/" + pairNumber;
    }
}

