<?php
/*
** Zabbix
** Copyright (C) 2001-2016 Zabbix SIA
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/


require_once dirname(__FILE__).'/include/config.inc.php';
require_once dirname(__FILE__).'/include/hosts.inc.php';
require_once dirname(__FILE__).'/include/httptest.inc.php';
require_once dirname(__FILE__).'/include/forms.inc.php';

$page['title'] = _('Details of web scenario');
$page['file'] = 'httpdetails.php';
$page['scripts'] = ['class.calendar.js', 'gtlc.js', 'flickerfreescreen.js'];
$page['type'] = detect_page_type(PAGE_TYPE_HTML);

require_once dirname(__FILE__).'/include/page_header.php';

// VAR	TYPE	OPTIONAL	FLAGS	VALIDATION	EXCEPTION
$fields = [
	'period' =>		[T_ZBX_INT, O_OPT, null,	null,		null],
	'stime' =>		[T_ZBX_STR, O_OPT, null,	null,		null],
	'reset' =>		[T_ZBX_STR, O_OPT, P_SYS|P_ACT, null,	null],
	'httptestid' =>	[T_ZBX_INT, O_MAND, P_SYS,	DB_ID,		null],
	'fullscreen' =>	[T_ZBX_INT, O_OPT, P_SYS,	IN('0,1'),	null],
	// ajax
	'favobj' =>		[T_ZBX_STR, O_OPT, P_ACT,	null,		null],
	'favid' =>		[T_ZBX_INT, O_OPT, P_ACT,	null,		null]
];
check_fields($fields);

/*
 * Ajax
 */
if (isset($_REQUEST['favobj'])) {
	// saving fixed/dynamic setting to profile
	if ($_REQUEST['favobj'] == 'timelinefixedperiod') {
		if (isset($_REQUEST['favid'])) {
			CProfile::update('web.httptest.timelinefixed', $_REQUEST['favid'], PROFILE_TYPE_INT);
		}
	}
}

if ($page['type'] == PAGE_TYPE_JS || $page['type'] == PAGE_TYPE_HTML_BLOCK) {
	require_once dirname(__FILE__).'/include/page_footer.php';
	exit;
}

/*
 * Collect data
 */
$httptest = API::HttpTest()->get([
	'output' => ['httptestid', 'name', 'hostid'],
	'httptestids' => getRequest('httptestid'),
	'preservekeys' => true
]);
$httptest = reset($httptest);
if (!$httptest) {
	access_deny();
}

$http_test_name = CMacrosResolverHelper::resolveHttpTestName($httptest['hostid'], $httptest['name']);

// Create details widget.
$details_screen = CScreenBuilder::getScreen([
	'resourcetype' => SCREEN_RESOURCE_HTTPTEST_DETAILS,
	'mode' => SCREEN_MODE_JS,
	'dataId' => 'httptest_details',
	'profileIdx2' => $httptest['httptestid']
]);

(new CWidget())
	->setTitle(_('Details of web scenario').': '.$http_test_name)
	->setControls((new CForm())
		->cleanItems()
		->addItem((new CList())
			->addItem(get_icon('reset', ['id' => getRequest('httptestid')]))
			->addItem(get_icon('fullscreen', ['fullscreen' => $_REQUEST['fullscreen']]))
		)
	)
	->addItem($details_screen->get())
	->show();

echo BR();

$graphs = [];

// dims
$graph_dims = getGraphDims();
$graph_dims['width'] = -50;
$graph_dims['graphHeight'] = 150;

/*
 * Graph in
 */
$graph_in = new CScreenBase([
	'resourcetype' => SCREEN_RESOURCE_GRAPH,
	'mode' => SCREEN_MODE_PREVIEW,
	'dataId' => 'graph_in',
	'profileIdx' => 'web.httptest',
	'profileIdx2' => getRequest('httptestid'),
	'period' => getRequest('period'),
	'stime' => getRequest('stime')
]);

$httptest_manager = new CHttpTestManager();
$itemids = $httptest_manager->getHttpStepItems($httptest['httptestid']);
$itemids = zbx_objectValues($itemids, 'itemid');

$graph_in->timeline['starttime'] = date(TIMESTAMP_FORMAT, get_min_itemclock_by_itemid($itemids));

$url = (new CUrl('chart3.php'))
	->setArgument('height', 150)
	->setArgument('name', $http_test_name.': '._('Speed'))
	->setArgument('http_item_type', HTTPSTEP_ITEM_TYPE_IN)
	->setArgument('httptestid', $httptest['httptestid'])
	->setArgument('graphtype', GRAPH_TYPE_STACKED)
	->setArgument('period', $graph_in->timeline['period'])
	->setArgument('stime', $graph_in->timeline['stime'])
	->setArgument('profileIdx', $graph_in->profileIdx)
	->setArgument('profileIdx2', $graph_in->profileIdx2)
	->getUrl();

$graphs[] = (new CDiv(new CLink(null, $url)))
	->addClass('flickerfreescreen')
	->setId('flickerfreescreen_graph_in')
	->setAttribute('data-timestamp', time());

$time_control_data = [
	'id' => 'graph_in',
	'containerid' => 'flickerfreescreen_graph_in',
	'src' => $url,
	'objDims' => $graph_dims,
	'loadSBox' => 1,
	'loadImage' => 1,
	'periodFixed' => CProfile::get('web.httptest.timelinefixed', 1),
	'sliderMaximumTimePeriod' => ZBX_MAX_PERIOD
];
zbx_add_post_js('timeControl.addObject("graph_in", '.zbx_jsvalue($graph_in->timeline).', '.
	zbx_jsvalue($time_control_data).');'
);
$graph_in->insertFlickerfreeJs();

/*
 * Graph time
 */
$graph_time = new CScreenBase([
	'resourcetype' => SCREEN_RESOURCE_GRAPH,
	'mode' => SCREEN_MODE_PREVIEW,
	'dataId' => 'graph_time',
	'profileIdx' => 'web.httptest',
	'profileIdx2' => getRequest('httptestid'),
	'period' => getRequest('period'),
	'stime' => getRequest('stime')
]);

$url = (new CUrl('chart3.php'))
	->setArgument('height', 150)
	->setArgument('name', $http_test_name.': '._('Response time'))
	->setArgument('http_item_type', HTTPSTEP_ITEM_TYPE_TIME)
	->setArgument('httptestid', $httptest['httptestid'])
	->setArgument('graphtype', GRAPH_TYPE_STACKED)
	->setArgument('period', $graph_time->timeline['period'])
	->setArgument('stime', $graph_time->timeline['stime'])
	->setArgument('profileIdx', $graph_time->profileIdx)
	->setArgument('profileIdx2', $graph_time->profileIdx2)
	->getUrl();

$graphs[] = (new CDiv(new CLink(null, $url)))
	->addClass('flickerfreescreen')
	->setId('flickerfreescreen_graph_time')
	->setAttribute('data-timestamp', time());

$time_control_data = [
	'id' => 'graph_time',
	'containerid' => 'flickerfreescreen_graph_time',
	'src' => $url,
	'objDims' => $graph_dims,
	'loadSBox' => 1,
	'loadImage' => 1,
	'periodFixed' => CProfile::get('web.httptest.timelinefixed', 1),
	'sliderMaximumTimePeriod' => ZBX_MAX_PERIOD
];
zbx_add_post_js('timeControl.addObject("graph_time", '.zbx_jsvalue($graph_in->timeline).', '.
	zbx_jsvalue($time_control_data).');'
);
$graph_time->insertFlickerfreeJs();

// scroll
CScreenBuilder::insertScreenStandardJs(['timeline' => $graph_in->timeline]);

// Create graphs widget.
(new CWidget())
	->addItem((new CFilter('web.httpdetails.filter.state'))->addNavigator())
	->addItem((new CDiv($graphs))->addClass(ZBX_STYLE_TABLE_FORMS_CONTAINER))
	->show();

require_once dirname(__FILE__).'/include/page_footer.php';
