#ifndef SOLID_H
#define SOLID_H


#define ID_BOX		0
#define ID_SPHERE	1
#define ID_CONE		2
#define ID_TORUS	3
#define ID_RECT		4
#define ID_DISK		5
#define ID_LINE		6
#define ID_STATUE	7
#define ID_SIZE		8
#define ID_RADIUS	9
#define ID_RADIUS2	10
#define ID_HEIGHT	11
#define ID_TEXTURE	12
#define ID_TEX_XP	13
#define ID_TEX_XN	14
#define ID_TEX_YP	15
#define ID_TEX_YN	16
#define ID_TEX_ZP	17
#define ID_TEX_ZN	18
#define ID_EMISSION	19
#define ID_DIFFUSE	20
#define ID_AMBIENT	21
#define ID_SPECULAR	22
#define ID_SHININESS	23
#define ID_GEOMETRY	24
#define ID_SCALE	25
#define ID_FRAMES	26
#define ID_BOX_BLEND	27
#define ID_SPOT_DIRECTION	28
#define ID_SPOT_CUTOFF	29
#define ID_CONSTANT_ATTENUATION	30
#define ID_LINEAR_ATTENUATION	31
#define ID_QUADRATIC_ATTENUATION	32
#define ID_STYLE	33
#define ID_BBOX		34
#define ID_DSPHERE	35

#define MAXFRAMES	256
#define BEGINFRAME	'['
#define SEPFRAME	'-'
#define ENDFRAME	']'


#include "zmath.h"


void zvVertex3fv(float *v);
void zvVertex3f(float x, float y, float z);
void SolidClose(void);
void deleteSolidFromList(struct _ZVSolid *s);
struct _ZVSolid *parseGeometry(const char *geometry);
void getSolidBB(struct _ZVSolid *s, V3 *center, V3 *size);
void setSolidPosition(struct _ZVSolid *s, M4 *mpos);
void getSolidPosition(struct _ZVSolid *s, M4 *mpos);
void setSolidVisible(struct _ZVSolid *s, boolean flag);
void setSolidBBFlag(struct _ZVSolid *s, boolean flag);
void setSolidFrame(struct _ZVSolid *s, u_int16 frame);


#endif /* SOLID_H */
