#ifndef DRAW_H
#define DRAW_H


#define SPHERE_SLICES	16
#define SPHERE_STACKS	16
#define CYLINDER_SLICES	16
#define CYLINDER_STACKS	16
#define TORUS_CIRCLES	16
#define TORUS_CYLINDER	8
#define DISK_SLICES	32
#define DISK_LOOPS	8

/* draw styles */
#define STYLE_FILL	0
#define STYLE_LINES	1
#define STYLE_POINTS	2


void drawPoint(float x, float y);
void drawLine(float x, float y);
void drawRect(float x, float y, int style);
void drawBox(float, float, float, float, float, float, int, int[], int style);
void drawOctagon(float side, float height, int style);
void drawTorus(float rc, int numc, float rt, int numt, int style);
void drawSphere(float radius, int slices, int stacks, int style);
void drawCylinder(float baseR, float topR, float height, int slices, int stacks, int style);
void drawDisk(float innerR, float outerR, int slices, int loops, int style);


#endif /* DRAW_H */
