
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#include "global.h"
#include "boneFactory.h"

  void FACTORY :: buildSphere(MESH3D *result,
				float radius,
				int cpt1,
				int cpt2,
				float centerx,
				float centery,
				float centerz)
   {
    int i,j;
    if (cpt1 <= 0) return;
    if (cpt2 <= 0) return;

    trace(DBG_MAN, "buildSphere: Creating");
    trace(DBG_MAN, "           Radius        : %f"     , radius);
    trace(DBG_MAN, "           Nb edges 1    : %i" , cpt1);
    trace(DBG_MAN, "           Nb edges 2    : %i" , cpt2);

    for (i=0; i<cpt1; i++)
     for (j=0; j<cpt2; j++)
      result -> addVertex (
         centerx + radius * sin(i * M_PI / (cpt1-1)) * cos(j * 2.0f * M_PI / cpt2),
         centery + radius * cos(i * M_PI / (cpt1-1)),
         centerz + radius * sin(i * M_PI / (cpt1-1)) * sin(j * 2.0f * M_PI / cpt2)
	);

    TRIANGLE * triangle;
    int cpt = 0;
    for (i=0; i<cpt1; i++)
     for (j=0; j<cpt2; j++)
      {
       int i1 = ((i)) * cpt2 + ((j));
       int i2 = ((i+1)%cpt1) * cpt2 + ((j));
       int i3 = ((i+1)%cpt1) * cpt2 + ((j+1)%cpt2);
       int i4 = ((i)) * cpt2 + ((j+1)%cpt2);

       result -> addTriangle(i1,i3,i2);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor(1,1,1);

       result -> addTriangle(i1,i4,i3);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor(1,1,1);
      }

    result -> rebuildNormals();
    result -> setName("FACTORY :: buildSphere");
   }

  void FACTORY :: buildTorus(MESH3D *result,
			       float bigRadius,
			       float littleRadius,
			       int cpt1,
			       int cpt2,
			       float centerx,
			       float centery,
			       float centerz)
   {
    int i,j;
    if (cpt1 <= 0) return;
    if (cpt2 <= 0) return;

    trace(DBG_MAN, "buildTorus:");
    trace(DBG_MAN, "           Big radius    : %f" , bigRadius);
    trace(DBG_MAN, "           Little radius : %f" , littleRadius);
    trace(DBG_MAN, "           Nb edges 1    : %i" , cpt1);
    trace(DBG_MAN, "           Nb edges 2    : %i" , cpt2);

    TRIANGLE * triangle;
    int cpt = 0;
    for (i=0; i<cpt1; i++)
     for (j=0; j<cpt2; j++)
      result -> addVertex (
         centerx + (bigRadius + littleRadius * cos(j * 2.0f * M_PI / cpt2 + M_PI)) * sin(i * 2.0f * M_PI / cpt1),
         centery + (bigRadius + littleRadius * cos(j * 2.0f * M_PI / cpt2 + M_PI)) * cos(i * 2.0f * M_PI / cpt1),
         centerz +              littleRadius * sin(j * 2.0f * M_PI / cpt2 + M_PI)
	);

    for (i=0; i<cpt1; i++)
     for (j=0; j<cpt2; j++)
      {
       int i1 = ((i)) * cpt2 + ((j));
       int i2 = ((i+1)%cpt1) * cpt2 + ((j));
       int i3 = ((i+1)%cpt1) * cpt2 + ((j+1)%cpt2);
       int i4 = ((i)) * cpt2 + ((j+1)%cpt2);
       result -> addTriangle(i1,i3,i2);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor(1,1,1);

       result -> addTriangle(i1,i4,i3);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor (1,1,1);
      }

    result -> rebuildNormals();
    result -> setName("FACTORY :: buildTorus");
   }

  void FACTORY :: buildCylinder(MESH3D *result,
				  float radius,
				  float height,
				  int cpt1,
				  int cpt2,
				  float centerx,
				  float centery,
				  float centerz)
   {
    int i,j;
    if (cpt1 <= 0) return;
    if (cpt2 <= 0) return;

    trace(DBG_MAN, "buildCylinder:");
    trace(DBG_MAN, "           Radius        : %f"     , radius);
    trace(DBG_MAN, "           Nb edges 1    : %i" , cpt1);
    trace(DBG_MAN, "           Nb edges 2    : %i" , cpt2);

    for (i=0; i<cpt1; i++)
     for (j=0; j<cpt2; j++)
      result -> addVertex (
         centerx +   radius                      * sin(j * 2.0f * M_PI / cpt2),
         centery + (height * i) / (cpt1 - 1),
         centerz +   radius                      * cos(j * 2.0f * M_PI / cpt2)
	 // centerx + (radius * i) / (cpt1 - 1) * sin(j * 2.0f * M_PI / cpt2),
         // centery + (height * i) / (cpt1 - 1),
         // centerz + (radius * i) / (cpt1 - 1) * cos(j * 2.0f * M_PI / cpt2)
	);

    TRIANGLE * triangle;
    int cpt = 0;
    for (i=0; i<cpt1-1; i++)
     for (j=0; j<cpt2; j++)
      {
       int i1 = ((i)) * cpt2 + ((j));
       int i2 = ((i+1)%cpt1) * cpt2 + ((j));
       int i3 = ((i+1)%cpt1) * cpt2 + ((j+1)%cpt2);
       int i4 = ((i)) * cpt2 + ((j+1)%cpt2);
       result -> addTriangle(i1,i3,i2);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor(1,1,1);

       result -> addTriangle(i1,i4,i3);
       triangle = result -> triangleList.getElementAt(cpt++);
       triangle -> setColor(1,1,1);
      }

    result -> rebuildNormals();
    result -> setName("FACTORY :: buildCylinder");
   }

  void FACTORY :: readVRMLfile(MESH3D * result, char * filename, float size, float centerx, float centery, float centerz, int colorMask)
   {
    trace(DBG_MAN, "Creating TRI mesh with vrml file");
    trace(DBG_MAN, "           Filename      : [%s]", filename);

    char endLine = '\0';
    char skippedText[1024];
    float x,y,z;
    int index1, index2, index3, indexEnd;
    int vertices=0, faces=0;

    // First look if the file exists
    FILE *fileIn = fopen(filename , "rt");
    if (fileIn == NULL) return;
    fclose(fileIn);

    // Now that we know it exists, we'll look after the vertices part
    fileIn = fopen(filename , "rt");
    strcpy(skippedText, "");
    while ((strcmp(skippedText, "point") != 0) && (!feof(fileIn)))
      fscanf(fileIn, "%s", skippedText);
    if (!feof(fileIn))
     {
      fscanf(fileIn, "%s\n", skippedText);

      endLine = '\0';
      while (endLine != ']')
       {
        fscanf(fileIn, "%f %f %f%c", &x, &y, &z, &endLine);
        result -> addVertex(centerx + x * size, centery + y * size, centerz + z * size);
        vertices ++;
       }
      trace(DBG_MAN, "           Vertices added: %i", vertices);
     }
    fclose(fileIn);

    // We'll look after the faces part
    fileIn = fopen(filename , "rt");
    strcpy(skippedText, "");
    while ((strcmp(skippedText, "coordIndex") != 0) && (!feof(fileIn)))
      fscanf(fileIn, "%s", skippedText);
    if (!feof(fileIn))
     {
      fscanf(fileIn, "%s", skippedText);

      endLine = '\0';
      while (endLine != ']')
       {
        fscanf(fileIn, "%d, %d, %d, %d%c", &index1, &index2, &index3, &indexEnd, &endLine);
        result -> addTriangle(index1, index2, index3);
        faces ++;
       }
      trace(DBG_MAN, "           Faces added   : %i", faces);
     }
    fclose(fileIn);

    // We'll now go on color part
    fileIn = fopen(filename , "rt");
    strcpy(skippedText, "");
    while ((strcmp(skippedText, "color") != 0) && (!feof(fileIn)))
      fscanf(fileIn, "%s", skippedText);
    if (!feof(fileIn))
      fscanf(fileIn, "%s", skippedText);
    if (!feof(fileIn) && strcmp(skippedText, "NULL"))
     {
      TRIANGLE * triangle;
      float r,g,b;
      int cpt=0;

      printf("[%s]\n", skippedText);
      fscanf(fileIn, "%s", skippedText);
      fscanf(fileIn, "%s", skippedText);
      fscanf(fileIn, "%s", skippedText);

      endLine = '\0';
      while (endLine != ']')
       {
        fscanf(fileIn, "%f %f %f%c", &r, &g, &b, &endLine);
        triangle = result -> triangleList.getElementAt(cpt++);

        if ((r==g) && (g==b) && (colorMask != 0))
         {
          r = (triangle -> vertex1 -> initialPosition.x + 1.0f) / 2.0f;
          g = (triangle -> vertex1 -> initialPosition.y + 1.0f) / 2.0f;
          b = (triangle -> vertex1 -> initialPosition.z + 1.0f) / 2.0f;
	 }
	triangle -> setColor(r,g,b);
       }
     }
    fclose(fileIn);

    // And finaly come on texture mapping coordinates
    fileIn = fopen(filename , "rt");
    strcpy(skippedText, "");
    while ((strcmp(skippedText, "texCoord") != 0) && (!feof(fileIn)))
      fscanf(fileIn, "%s", skippedText);
    if (!feof(fileIn))
     {
      VERTEX * vertex;
      float u,v;
      int cpt=0;

      fscanf(fileIn, "%s", skippedText);
      fscanf(fileIn, "%s", skippedText);
      fscanf(fileIn, "%s", skippedText);
      fscanf(fileIn, "%s", skippedText);

      endLine = '\0';
      while (endLine != ']')
       {
        fscanf(fileIn, "%f %f%c", &u, &v, &endLine);
	vertex = result -> vertexList . getElementAt(cpt++);
	vertex->u = u;
	vertex->v = v;
       }
     }
    fclose(fileIn);

    result -> rebuildNormals();
    result -> setName(filename);

   }

  //-- VRENG 3D intern format

  void FACTORY :: readVRE3Dfile(MESH3D *result, BONEVERTEX *skeletonRoot, char *filename, float scale)
   {
    FILE *file = fopen(filename, "rb");
    if (file == NULL) return;

    int i, index1, index2, index3;
    float x,y,z;

    trace(DBG_MAN, "readVRE3Dfile: reading mesh and skeleton from VRE3D file %s", filename);

    // Reading name
    char name[512];
    readString(file, name);
    result -> setName(name);

    // Reading vertices
    int vertices = readInt(file);
    for (i=0; i<vertices; i++)
     {
      x = readFloat(file) * scale;
      y = readFloat(file) * scale;
      z = readFloat(file) * scale;
      result -> addVertex(x,y,z);
     }
    trace(DBG_MAN, "           Vertices added: %i", vertices);

    int faces = readInt(file);
    for (i=0; i<faces; i++)
     {
      // Reading indices
      index1 = readInt(file);
      index2 = readInt(file);
      index3 = readInt(file);
      result -> addTriangle(index1, index2, index3);
      TRIANGLE * face = result -> triangleList.getElementAt(i);
      // Reading color
      float r = readFloat(file);
      float g = readFloat(file);
      float b = readFloat(file);
      float a = readFloat(file);
      face -> setColor(r,g,b,a);
      // Reading texture coordinantes
      face -> u1 = readFloat(file);
      face -> v1 = readFloat(file);
      face -> u2 = readFloat(file);
      face -> v2 = readFloat(file);
      face -> u3 = readFloat(file);
      face -> v3 = readFloat(file);
     }
    trace(DBG_MAN, "           Faces added   : %i", faces);
    // Reading skeleton
    skeletonRoot -> readFromFile(file, scale);

    trace(DBG_MAN, "           Skeleton added!");

    result -> rebuildNormals();

    fclose(file);
   }

  void FACTORY :: writeVRE3Dfile(MESH3D *outMesh, BONEVERTEX *skeletonRoot, char* filename)
   {
    FILE * file = fopen(filename, "wb");
    if (file == NULL) return;

    if (! outMesh ->   vertexListCompiled) outMesh -> compileVertexList();
    if (! outMesh -> triangleListCompiled) outMesh -> compileTriangleList();

    int i, index1, index2, index3;

    trace(DBG_MAN, "writeVRE3Dfile: writing mesh and skeleton to VRE3D file");

    // Writing name
    writeString(file, outMesh -> getName());

    // Writing vertices coordinates
    writeInt(file, outMesh -> vertices);
    for (i=0; i<outMesh->vertices; i++)
     {
      writeFloat(file, outMesh -> vertex[i] -> initialPosition.x);
      writeFloat(file, outMesh -> vertex[i] -> initialPosition.y);
      writeFloat(file, outMesh -> vertex[i] -> initialPosition.z);
     }
    trace(DBG_MAN, "           Vertices added: %i", outMesh -> vertices);

    // Writing triangles
    writeInt(file, outMesh -> triangles);
    for (i=0; i<outMesh->triangles; i++)
     {
      index1 = 0;
      index2 = 0;
      index3 = 0;
      while (outMesh->vertex[index1] != outMesh->triangle[i]->vertex1) index1++;
      while (outMesh->vertex[index2] != outMesh->triangle[i]->vertex2) index2++;
      while (outMesh->vertex[index3] != outMesh->triangle[i]->vertex3) index3++;
      // Writing indices
      writeInt(file, index1);
      writeInt(file, index2);
      writeInt(file, index3);
      // Writing triangle color
      writeFloat(file, outMesh->triangle[i]->colorRed);
      writeFloat(file, outMesh->triangle[i]->colorGreen);
      writeFloat(file, outMesh->triangle[i]->colorBlue);
      writeFloat(file, outMesh->triangle[i]->colorAlpha);
      // Writing triangle texture coordinates
      writeFloat(file, outMesh->triangle[i]->u1);
      writeFloat(file, outMesh->triangle[i]->v1);
      writeFloat(file, outMesh->triangle[i]->u2);
      writeFloat(file, outMesh->triangle[i]->v2);
      writeFloat(file, outMesh->triangle[i]->u3);
      writeFloat(file, outMesh->triangle[i]->v3);
     }
    trace(DBG_MAN, "           Faces added   : %i", outMesh -> triangles);
    // Writing skeleton
    skeletonRoot -> writeToFile(file);

    trace(DBG_MAN, "           Skeleton added!");
    fclose(file);
   }

  void FACTORY :: readTGA(char *filename, int **buffer, int *width, int *height)
   {
    trace(DBG_MAN, "readTGA: reading TGA file: [%s]", filename);

    FILE *fichier = fopen(filename, "rb");
    if (fichier == NULL)
     {
      trace(DBG_FORCE, "readTGA: open TGA: %s", filename);
      return;
     }

    int sizex,sizey,data;
    data = fgetc(fichier); if (data != 0) return; // ID Length = 0
    data = fgetc(fichier); if (data != 0) return; // Colore map type = No color map included
    data = fgetc(fichier); if (data != 2) return; // Image type = uncompressed true color
    data = fgetc(fichier); if (data != 0) return; // Color map spec : 1st entry index
    data = fgetc(fichier); if (data != 0) return;
    data = fgetc(fichier); if (data != 0) return; // Color map spec : color map length
    data = fgetc(fichier); if (data != 0) return;
    data = fgetc(fichier); if (data != 0) return; // Color map spec : color map entry size
    data = fgetc(fichier); if (data != 0) return; // X origin
    data = fgetc(fichier); if (data != 0) return;
    data = fgetc(fichier); if (data != 0) return; // Y origin
    data = fgetc(fichier); if (data != 0) return;
    sizex = fgetc(fichier); sizex += fgetc(fichier) << 8;
    sizey = fgetc(fichier); sizey += fgetc(fichier) << 8;
    data = fgetc(fichier); if (data != 24) return; // Pixel depth(24 bits)
    data = fgetc(fichier); if (data != 0) return; // Image descriptor

    * width  = sizex;
    * height = sizey;
    smartFree(*buffer);
    * buffer = (int *) malloc(sizex * sizey * sizeof(int));

    printf("           Width         : %i\n", sizex);
    printf("           Height        : %i\n", sizey);

    int x,y;
    for (y=0; y<sizey; y++)
     for (x=0; x<sizex; x++)
      {
       data  = fgetc(fichier);
       data += fgetc(fichier) << 8;
       data += fgetc(fichier) << 16;
       (*buffer) [(sizey - y - 1) * sizex + x] = data << 8;
      }
    printf("           Bits per pixel: 24\n");

    fclose(fichier);
   }
