#ifndef WATER_H
#define WATER_H

#define WATER_TYPE 	31
#define WATER_NAME 	"Water"
#define	WATER_INIT 	waterInitFuncList

#define	WATER_AMPLITUDE	 0.05 /* original: 0.03 */
#define	WATER_FREQ	 5.0
#define	WATER_PHASE	 0.0001 /* original: 0.00003 */
#define	WATER_MESH	 32

struct _TextureCacheEntry;

class Water: public WObject {
public:
  float posx, posy, posz;
  float rotx, roty, rotz;
  float scalex, scaley, scalez;
  float ttrans[2];
  float amplitude;
  float freq;
  float phase;
  int texture;
  struct _TextureCacheEntry *tc;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Water(char *);	// constructor

  static void (creator)(char *);
  virtual void changePermanent(float lasting);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void render();
};

void WATER_INIT(void);

#endif /* WATER_H */
