#ifndef STARS_H
#define STARS_H

#define STARS_TYPE	24
#define STARS_NAME	"Stars"
#define	STARS_INIT	starsInitFuncList

#define STARS_MAX	200	/* 400 */
#define STARS_MAXPOS	5000	/* 10000 */
#define STARS_WARP	10.0
#define STARS_WIDTH	100
#define STARS_HEIGHT	100
#define STARS_SPEED	1.0	/* 1 m/s */
#define STARS_MAXANGLE	360

enum {
  STARS_NORMAL = 0,
  STARS_WEIRD = 1
};
enum {
  STARS_STREAK = 0,
  STARS_CIRCLE = 1
};

typedef struct _starRec {
  float x[2], y[2], z[2];
  float offsetX, offsetY, offsetR, rotation;
} starRec;

class Stars: public WObject {
public:
  u_int16 number;	/* number of stars */
  u_int16 maxpos;	/* maxpos */
  u_int16 count;
  float speed;		/* speed */
  float warp;		/* limit */
  starRec *stars;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Stars(char *);	// constructor

  static void (creator)(char *);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();
};

void STARS_INIT(void);

#endif /* STARS_H */
