#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "user.h"	/* USER_TYPE */
#include "step.h"	/* STEP_SIZE */
#include "panel.h"

#include "zv.h"		/* parseGeometry */


const WClass Panel::wclass(PANEL_TYPE, "Panel", Panel::creator);


/* panel creation from a file */
void Panel::creator(char *l)
{
  new Panel(l);
}

Panel::Panel(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  nature.collision = COL_ONCE;
  initializeObject(this, PANEL_TYPE, VR_STILL);
} 

/* object intersection */
void Panel::whenIntersect(WObject *pcur, WObject *pold)
{
  if (pcur->noh.type == USER_TYPE) {
    pcur->pos.z += STEP_SIZE;	/* up */
    updateObjectIn3D(pcur);
    updateBB(pcur);
    if (projectMovementOnObject(pcur->pos, pold->pos, this->pos))
      updateReplica(pcur, pold->pos);
    else
      copyPositionAndBB(pold, pcur);
  }
  else
    copyPositionAndBB(pold, pcur);
}

void panelInitFuncList(void) { }

#endif /* !VRENGD */
