#ifndef VRENGD

#include <GL/gl.h>

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"
#include "user.h"	/* USER_FOVY */
#include "mirror.h"

#include "zv.h"		/* parseGeometry */


const WClass Mirror::wclass(MIRROR_TYPE, "Mirror", Mirror::creator);

static int toggle = 0;


/* mirror creation from a file */
void Mirror::creator(char *l)
{
  new Mirror(l);
}

Mirror::Mirror(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  pos.bbsize.v[0] += MIRROR_FAR / 2;
  pos.bbsize.v[1] += MIRROR_FAR / 2;
  trace(DBG_WMGT, "pos.bbsize.v[0]=%f, pos.bbsize.v[1]=%f",
        pos.bbsize.v[0], pos.bbsize.v[1]);

  nature.collision = COL_ONCE;
  initializeObject(this, MIRROR_TYPE, VR_STILL);
} 

void Mirror::whenNoIntersect(WObject *pcur, WObject *pold)
{
  toggle = 0;
}

/* object intersection: stop */
void Mirror::whenIntersect(WObject *pcur, WObject *pold)
{
  float left, right, bottom, top, ratio;
  int width, height;
#if 0
  int viewport[4];
#endif
  static struct {
      float fovy, near, far;
  } cam_mirror;

  updateObjectIn3D(this);
#if 0
  updateCameraFromObject(this);
#endif
  trace(DBG_FORCE, "mirror: toggle=%d", toggle);
  if (toggle % 1 == 0) {
    width = 10;
    height = 10;
    cam_mirror.fovy = (float) MIRROR_FOVY;
    cam_mirror.near = (float) MIRROR_NEAR;
    cam_mirror.far =  (float) MIRROR_FAR;
    toggle = 1;
  }
  else {
    setCameraProjection(USER_FOVY, USER_NEAR, USER_FAR);
#if 0
    glGetInterger(GL_VIEWPORT, viewport);
    width = viewport[2];
    height = viewport[3];
    cam_mirror.fovy = (float) USER_FOVY;
    cam_mirror.near = (float) USER_NEAR;
    cam_mirror.far =  (float) USER_FAR;
#endif
    toggle = 0;
  }
  toggle++;

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  top = cam_mirror.near * tan(cam_mirror.fovy * M_PI_180);
  bottom = -top;
  ratio= (float) width / (float) height;
  right = top * ratio;
  left = -right;
  glFrustum(left, right, bottom, top, cam_mirror.near, cam_mirror.far);
  glTranslatef(0.0, 0.0, -cam_mirror.near);
  glMatrixMode(GL_MODELVIEW);

  /* copyPositionAndBB(pold, pcur); */
  pcur->pos.x += USER_GOTHROUGH; /* step to shift */
  pcur->pos.y += USER_GOTHROUGH; /* step to shift */
  updateObjectIn3D(pcur);
  updateBB(pcur);
}

void mirrorInitFuncList(void) { }

#endif /* !VRENGD */
