#ifndef IFC_H
#define IFC_H

// VRENG stuff
#define IFC_TYPE	42
#define IFC_NAME	"Ifc"
#define	IFC_INIT	ifcInitFuncList

// Class name limit
#define IFC_NAME_LEN    255

// List of 3D points
typedef struct _PointList {
	V3 point;
	struct _PointList *next;
} PointList;

// 2D objects
typedef struct _Object2D {
	PointList *points;
	V3 color;
	int type;
	int tag;
	struct _Object2D *next;
} Object2D;

// Ifc object specific properties
class Ifc: public WObject {
public:

  // window geometry
  int incrx, incry;
  float fx, fy;
  // class name and codebase URL
  char app[IFC_NAME_LEN];
  char url[IFC_NAME_LEN];

  // TRUE if the child has requested a position delta
  int wantDelta;
  // Values of the requested deltas, (x,y,z) and (az,ay,ax)
  V3 posDelta, angDelta;

  // TRUE if a new shape has been added (removed) to the list of 2D objects
  boolean needRedraw;
  // List of 2D Objects this Ifc has
  Object2D *o2;
  // OpenGL displaylist constructed from the above list
  int32 displaylist;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Ifc(char *l);

  static void (creator)(char *l);
  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual boolean whenIntersectOut(WObject *pcur, WObject *pold);
  virtual void render();
  virtual void click(V3);
  virtual void quit();
};

// 2D helpers
Object2D *ifcNewObject2D(Object2D *list, int type, int tag, V3 color);
Object2D *ifcRemoveObject2D(Object2D *list, int type, int tag);
void ifcFreeObject2D(Object2D *);
void ifcFreeObject2DList(Object2D *);
void ifcFreePointList(PointList *);
void ifcAddPoint(Object2D *, V3);

// VRENG initialization function
void IFC_INIT(void);


#endif // IFC_H
