#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"	/* calculateCoordinatesIntoGrid */
#include "aoi.h"	/* AOI_TYPE */
#include "walls.h"	/* wallsIntersectObject */
#include "col.h"

#include "zv.h"		/* Solid */


/* return a constant to describe intersection status of both Bounding Boxes */
int interBBs (V3 center1, V3 size1, V3 center2, V3 size2)
{
  float dcx, dcy, dcz, sx1, sx2, sy1, sy2, sz1, sz2;

  dcx = ABSF(center2.v[0] - center1.v[0]);
  dcy = ABSF(center2.v[1] - center1.v[1]);
  dcz = ABSF(center2.v[2] - center1.v[2]);
  sx1 = ABSF(size1.v[0]);
  sx2 = ABSF(size2.v[0]);
  sy1 = ABSF(size1.v[1]);
  sy2 = ABSF(size2.v[1]);
  sz1 = ABSF(size1.v[2]);
  sz2 = ABSF(size2.v[2]);
  
  if (dcx >= sx1 + sx2  ||  dcy >= sy1 + sy2  ||  dcz >= sz1 + sz2)
    return INTER_NO;	/* doesn't intersect */
  if (dcx + sx1 <= sx2  &&  dcy + sy1 <= sy2  && dcz + sz1 <= sz2)
    return INTER_1IN2;
  if (dcx + sx2 <= sx1  &&  dcy + sy2 <= sy1  &&  dcz + sz2 <= sz1)
    return INTER_2IN1;
  return INTER_INTERSECT;
}

/* general function to handle intersections */
void generalIntersect(WObject *pcur, WObject *pold, ObjectList *vicinitylist)
{
  V3 norm;
 
  /* walls */
  if (wallsIntersectObject(&(pcur->pos.bbcenter), &(pcur->pos.bbsize), &norm)) {
    pcur->whenWallIntersect(pold, &norm);
    //DAX }
    //DAX else
    //DAX   copyPositionAndBB(pold, pcur);
    //DAX return;
  }
 
  ObjectList *tmplist = vicinitylist;
  int ya_collision = 0;

  while (tmplist && tmplist->pobject) {
    WObject *po = tmplist->pobject;

    if (!isValidType(po->noh.type)) {
      tmplist = tmplist->next;
      continue;		/* SURELY a BUG! */
    }
    if (po->nature.collision == COL_NEVER) {
      tmplist = tmplist->next;
      continue;
    }
    /* MS. : Test for outgoing intersection */
    if (interBBs(pcur->pos.bbcenter, pcur->pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) == INTER_NO &&
        interBBs(pold->pos.bbcenter, pold->pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) != INTER_NO) {
       if (po->whenIntersectOut(pcur, pold) == TRUE) {
         if (thisWorldIsDead == TRUE) return;
         switch (po->nature.collision) {
           case COL_ONCE:
           case COL_GHOST:
             tmplist = tmplist->next;
             break;
           default:
             tmplist = vicinitylist;
             break;
         }
       }
       else
	   tmplist = tmplist->next;
       continue;
    }
    /* MS. : Test for ingoing intersection */
    else if
       (interBBs(pcur->pos.bbcenter, pcur->pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) != INTER_NO &&
        interBBs(pold->pos.bbcenter, pold->pos.bbsize,
                 po->pos.bbcenter, po->pos.bbsize) == INTER_NO) {
        ya_collision = 1 ;

      /* current object intersects and its old instance didn't intersect */
      if (po->noh.type != AOI_TYPE) {
        po->whenIntersect(pcur, pold);
        if (thisWorldIsDead == TRUE) return;
        switch (po->nature.collision) {
          case COL_ONCE:
          case COL_GHOST:
            tmplist = tmplist->next;
            break;
          default:
            if (pcur->nature.collision == COL_GHOST) {
              tmplist = tmplist->next;
            }
            else
              tmplist = vicinitylist;
        }
        continue;
      }

      // begin AOI
      else {
        /* 2 cases: local avatar or another mobile object */
        if (pcur == (WObject *) worlds->plocaluser) {
          if (currentAoi != po)
            aoiEnter((Aoi *) po); /* avatars: change mcast address */
        }
        else { /* other mobile objects: problem of property transfert */
          // move this piece of code into aoi.cc
          //DAX notice("Object %s enters %s (ie. %s)",
          //DAX     pcur->name.instance_name, po->name.instance_name, po->chan);
		  ;
        }
        break;     /* avoids a warning */
      }
      // end AOI
    }
    else if (thisWorldIsDead == FALSE) {
      po->whenNoIntersect(pcur, pold);
    }
    tmplist = tmplist->next;
  }
  if (ya_collision == 0)
	pcur->state.collide = 0;
}

/* return: normal vectors of still object */
void normal(Pos &mobile, Pos &fixe, V3 *norm)
{
  float fxmin, fxmax, fymin, fymax, fzmin, fzmax,
        mxmin, mxmax, mymin, mymax, mzmin, mzmax;
  
  mxmin = mobile.bbcenter.v[0] - mobile.bbsize.v[0];
  mxmax = mobile.bbcenter.v[0] + mobile.bbsize.v[0];
  mymin = mobile.bbcenter.v[1] - mobile.bbsize.v[1];
  mymax = mobile.bbcenter.v[1] + mobile.bbsize.v[1];
  mzmin = mobile.bbcenter.v[2] - mobile.bbsize.v[2];
  mzmax = mobile.bbcenter.v[2] + mobile.bbsize.v[2];
  fxmin = fixe.bbcenter.v[0] - fixe.bbsize.v[0];
  fxmax = fixe.bbcenter.v[0] + fixe.bbsize.v[0];
  fymin = fixe.bbcenter.v[1] - fixe.bbsize.v[1];
  fymax = fixe.bbcenter.v[1] + fixe.bbsize.v[1];
  fzmin = fixe.bbcenter.v[2] - fixe.bbsize.v[2];
  fzmax = fixe.bbcenter.v[2] + fixe.bbsize.v[2];

  V3 n;
  n.v[2] = 0.0;

  if (fxmax - fxmin < fymax - fymin) {
    n.v[0] = 1.0;
    n.v[1] = 0.0;
    n.v[2] = 0.0;
  } else {
    n.v[0] = 0.0;
    n.v[1] = 1.0;
    n.v[2] = 0.0;
  }
  /* test which normal we take */
  float sp;
  sp = (mobile.bbcenter.v[0] - fixe.bbcenter.v[0]) * n.v[0]
     + (mobile.bbcenter.v[1] - fixe.bbcenter.v[1]) * n.v[1]
     + (mobile.bbcenter.v[2] - fixe.bbcenter.v[2]) * n.v[2];
  if (sp < 0.0) {
    n.v[0] = -n.v[0];
    n.v[1] = -n.v[1];
    n.v[2] = -n.v[2];
  }
  *norm = n;
}

/* projete le mouvement de l'objet mobile parallelement a l'objet fixe */
int
projectMovementOnObject(Pos &mobile, Pos &mobileold, Pos &fixe)
{
  float dx, dy, dz;
  float sp;	/* scalar product */
  V3 n;

  dx = mobile.x - mobileold.x;
  dy = mobile.y - mobileold.y;
  dz = mobile.z - mobileold.z;
  if ((ABSF(dx) + ABSF(dy) + ABSF(dz)) == 0.0)
    return 0;

  normal(mobile, fixe, &n);
  sp =  (n.v[0] * dx) + (n.v[1] * dy) + (n.v[2] * dz);
  // trace(DBG_WMGT, "dx=%.2f dy=%.2f, nx=%.2f ny=%.2f nz=%.2f, sp=%.2f, px=%.2f py=%.2f", dx, dy, n.v[0], n.v[1], n.v[2], sp, -sp*n.v[0], -sp*n.v[1]);

  if (dx != 0.0)
    mobile.x += - (sp * n.v[0]);
  if (dy != 0.0)
    mobile.y += - (sp * n.v[1]);
  if (dz != 0.0)
    mobile.z += - (sp * n.v[2]);

  if (sp > 0.0)
    return 1;
  if (sp < 0.0)
    return -1;
  return 0;
}

/* 3D stub for solids intersections */
int Solid_intersect_2D(Solid *s_handle1, Solid *s_handle2)
{
  return INTER_INTERSECT;
}

#endif /* !VRENGD */
