#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* COL_ONCE */
#include "cd.h"

#include "zv.h"		/* parseGeometry */
#include "helpers.h"	/* startmp3 */


const WClass Cd::wclass(CD_TYPE, "Cd", Cd::creator);


/* cd initialization from a file */
void Cd::creator(char *l)
{
  new Cd(l);
}

Cd::Cd(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, CD_TYPE, VR_STILL);
  nature.collision = COL_ONCE;
} 

/* intersection: stop */
void Cd::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

/* play */
#if 0
void Cd::play(void *data, time_t sec, time_t usec)
{
  startmp3(name.url);
}
#else
static
void cdPlay(Cd *po, void *data, time_t sec, time_t usec)
{
  startmp3(po->name.url);
}
#endif

/* stop */
#if 0
void Cd::stop(void *data, time_t sec, time_t usec)
#else
static
void cdStop(Cd *po, void *data, time_t sec, time_t usec)
#endif
{
  stopmp3();
}

/* pause */
#if 0
void Cd::pause(void *data, time_t sec, time_t usec)
#else
static
void cdPause(Cd *po, void *data, time_t sec, time_t usec)
#endif
{
  pausemp3();
}

/* continue */
#if 0
void Cd::cont(void *data, time_t sec, time_t usec)
#else
static
void cdCont(Cd *po, void *data, time_t sec, time_t usec)
#endif
{
  contmp3();
}

void Cd::quit()
{
  stopmp3();
}

void cdInitFuncList(void)
{
#if 0
  setMethodHandler(CD_TYPE, 0, Cd::play, "Play");
  setMethodHandler(CD_TYPE, 1, Cd::stop, "Stop");
  setMethodHandler(CD_TYPE, 2, Cd::pause, "Pause");
  setMethodHandler(CD_TYPE, 3, Cd::cont, "Continue");
#else
  setMethodFunc(CD_TYPE, 0, WO_ACTION cdPlay, "Play");
  setMethodFunc(CD_TYPE, 1, WO_ACTION cdStop, "Stop");
  setMethodFunc(CD_TYPE, 2, WO_ACTION cdPause, "Pause");
  setMethodFunc(CD_TYPE, 3, WO_ACTION cdCont, "Continue");
#endif
}


#endif /* !VRENGD */
