#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "bgcolor.h"

#include "zv.h"		/* parseGeometry */


const WClass Bgcolor::wclass(BGCOLOR_TYPE, "Bgcolor", Bgcolor::creator);


/* bgcolor creation from a file */
void Bgcolor::creator(char *l)
{
  new Bgcolor(l);
}

Bgcolor::Bgcolor(char *l)
{
  parseColor(l, this);
  initializeObject(this, BGCOLOR_TYPE, VR_INVISIBLE);

  /* HACK !, we use (x,y,z,az) to map (r,g,b,a) :-) */
  bgcolor.red = pos.x;
  bgcolor.green = pos.y;
  bgcolor.blue = pos.z;
  bgcolor.alpha = pos.az;
} 

void Bgcolor::quit()
{
  memset((char *) &bgcolor, 0, sizeof(bgcolor)); /* black */
}

void bgcolorInitFuncList(void) { }

#endif /* !VRENGD */
