#include "global.h"

#include "net.h"
#include "netdefs.h"		/* RECV_RTP */
#include "netImpl.h"
#include "dates.h"		/* resetDates */

#include "world.h"		/* isValidType countProperties */


// network ids globals
u_int32 my_ssrc_id = 0;		/* ssrc network format */
u_int32 my_host_id = 0;		/* addr_IP network format */
u_int16 my_port_id = 0;		/* port network format */
u_int16 my_obj_id;		/* new object'id (naming), fmt host */
u_int32 my_mgr_ssrc_id = 0;	/* manager ssrc network format */

static NetObject *netobjects_list = NULL;	/* net objects list */


//
// Handling names and properties
//

NetObject * getNetObjectsList(void)
{
  return netobjects_list;
}

void clearNetObjectsList(void)
{
  netobjects_list = NULL;
}

// get current ssrc
u_int32 getMySsrc(void)
{
  return my_ssrc_id;
}

// build a reading string from a name
char * getNetNameById(NetObjectId noid)
{
  static char str[80];

  sprintf(str, "%x/%x/%x",
    ntohl(noid.src_id), ntohs(noid.port_id), ntohs(noid.obj_id));
  return str;
}

// return 0 if differents, other if equals
int equalNetObjectId(NetObjectId n1, NetObjectId n2)
{
  return    n1.src_id == n2.src_id
         && n1.port_id == n2.port_id
         && n1.obj_id == n2.obj_id;
}

// get an object by name, NULL if not found
NetObject * getNetObjectId(NetObjectId noid)
{
  NetObject *pn;

  for (pn = netobjects_list; 
      pn != NULL && !equalNetObjectId(pn->noid, noid); 
      pn = pn->next) {
    if (!isValidType(pn->type)) {
      trace(DBG_FORCE, "getNetObjectId: bad type=%d", pn->type);
      return NULL;
    }
#if 0
    assert(pn->next == NULL || pn->next->prev == pn);
    assert(pn->prev == NULL || pn->prev->next == pn);
    assert(pn->prev || pn == netobjects_list);
#endif
  }
  return pn;
}

#ifdef OLD_SSRC
// get an object by SSRC
NetObject * getObjectBySSRC(u_int32 ssrc)
{
  NetObject *pn = netobject_list;

  for ( ; pn != NULL && pn->noid.src_id != ssrc; pn = pn->next)
	;
  return pn;
}
#endif

// insert object in head of NetObject list
void insertNetObject(NetObject *pn)
{
  if (!pn) {
    trace(DBG_FORCE, "insertNetObject: pn NULL");
    return;
  }
  if ((pn->next = netobjects_list) != NULL)	/* YAVAIT 1 BUG  = */
    netobjects_list->prev = pn;
  netobjects_list = pn;
  pn->prev = NULL;  
}

/* initialise la gestion des responsabilites (0=non, 1=oui)
 * Les dates passent par resetDates
 * param "responsible" est copie dans le champ de meme nom
 */
void initProperties(NetObject *pn, u_int8 responsible)
{
  if (!pn) {
    trace(DBG_FORCE, "initProperties: pn NULL");
    return;
  }
  if (pn->prop) {
    trace(DBG_FORCE, "initProperties: prop already exists = %d", pn->prop);
    return;
  }

  u_int8 n = countProperties(pn->type);
  if ((pn->prop = (NetProperty *) calloc(1, n * sizeof(NetProperty))) == NULL) {
    trace(DBG_FORCE, "can't alloc prop");
    return ;
  }

  for (int i = 0; i < n; i++) {
    NetProperty *pprop = pn->prop + i;
    pprop->responsible = responsible;
    pprop->version = 0;
    resetDates(pprop);
  }
}

/*
 * Assigns a unique identifier to each Vreng object
 * whether if be a networked object or not.
 */
void setNetObjectId(NetObject *pnoh) {
  // Application's identifier
  pnoh->noid.src_id = my_ssrc_id;
  // Comm port identifier
  pnoh->noid.port_id = my_port_id;
  // Application wide unique number
  pnoh->noid.obj_id = htons(my_obj_id++);
}

/* Cree un nouveau nom d'objet et baptise ainsi l'objet 
 * Des la sortie, on peut faire un getNetObjectId
 * et des declareObjDelta. Un declareObjCreationToNetwork
 * est souhaitable apres, des que les props sont init
 * dans le wmgt
 */
void createNetObject(NetObject *pn, u_int8 perm)
{
  if (!pn) {
    trace(DBG_FORCE, "createNetObject: pn NULL");
    return;
  }
// M.S.: Objects need a unique ID from the start,
// not just for networked objects, so that the
// Ifc controller apps can tell them apart.
// setNetObjId needs to be called for all objects.
#if 0
  if (pn->noid.src_id != 0 || pn->next != NULL) {
    warning("createNetObject: already named object");
    return;
  }
  pn->noid.src_id = my_ssrc_id;
  // OBSOLETED  pn->noid.src_id = my_host_id;

  pn->noid.port_id = my_port_id;
  pn->noid.obj_id = htons(my_obj_id++);
#else
  if (pn->next != NULL) {
    warning("createNetObject: already named object, type=%d", pn->type);
    return;
  }
  setNetObjectId(pn);
#endif

  pn->permanent = perm;
  insertNetObject(pn);
  initProperties(pn, RESPONSIBLE); /* new: then we are responsible */
#ifdef OLD_SSRC
  if (pn->s)
    warning("createNetObject: already sourced");
  else
    pn->s = (source *) calloc(1, sizeof(source));
  /* init_seq(pn->s, rtp_seq); */
#endif
}

/* Build an object name from the string "scene_id/obj_id", both u_int16 > 0
 * Used by getNetObjectId and declareObjDelta.
 */
void createNetObjectFromString(NetObject *pn, const char *s, u_int8 perm)
{
  if (!pn) {
    trace(DBG_FORCE, "createNetObjectFromString: pn NULL");
    return;
  }
  //PD if (pn->noid.src_id != 0 || pn->next != NULL) {
  if (pn->next != NULL) {
    warning("createNetObjectFromString: already named object, type=%d src_id=%x next=%p", pn->type, pn->noid.src_id, pn->next);
    return;
  }

  u_int16 scene_id, obj_id;
  int c = sscanf(s, "%hu/%hu", &scene_id, &obj_id);

  if (c != 2 || scene_id <= 0 || obj_id <= 0) {
    warning("createNetObjectFromString: invalid namefromstring %s", (char *)s);
    return;
  }
  pn->noid.src_id = htonl(1); 
  pn->noid.port_id = htons(scene_id);
  pn->noid.obj_id = htons(obj_id);
  if (getNetObjectId(pn->noid) != NULL) {
    warning("createNetObjectFromString: already seen %d/%d", scene_id, obj_id);
    return;
  }
  pn->permanent = perm;  /* perm should be == 1 */
  insertNetObject(pn);
  initProperties(pn, NOT_RESPONSIBLE); /* 0 == we are not responsible */
}

// delete an object from the list, free properties
void deleteNetObject(NetObject *pn)
{
  if (!pn) {
    trace(DBG_FORCE, "deleteNetObject: pn NULL");
    return;
  }
  if (getNetObjectId(pn->noid) == NULL) {
    /* warning("deleteNetObject: already unnamed/deleted object %d", pn->type); */
    return;
  }
  if (pn->prev)
    pn->prev->next = pn->next;
  else {
    if (pn != netobjects_list) {
      trace(DBG_FORCE, "deleteNetObject: object=%d pn=%x netobjects_list=%x",
            pn->type, pn, netobjects_list);
      return;
    }
    netobjects_list = pn->next;
  }
  if (pn->next)
    pn->next->prev = pn->prev;
  pn->next = NULL;
  pn->prev = NULL;
  memset(&(pn->noid), 0, sizeof(pn->noid));
  free(pn->prop); 
#ifdef OLD_SSRC
  free(pn->s); 
#endif
  pn->prop = NULL;
}

