/*
 * MP3 tool
 *
 * Philippe Dax
 * May 2000
 */

#ifndef VRENGD

#include "global.h"
#include "mpg.h"


/* global variable */
int mp3tool = MPG123_TOOL;

static int mp3pid = -1;

static
void loadmp3(const char *tool, const char *url)
{
  mp3pid = fork();
  switch (mp3pid) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", tool);
    break;
  case 0:
    switch (mp3tool) {
    case MPG123_TOOL:
      execlp(tool, tool, "-qy", url, (char *) NULL);
      break;
    case XAUDIO_TOOL:
      execlp(tool, tool, url, (char *) NULL);
      break;
    case FREEAMP_TOOL:
      execlp(tool, tool, url, (char *) NULL);
      break;
    }
    trace(DBG_TOOL, "can't exec %s", tool);
    exit(1);
  default:
    break;
  }
}

void startmp3(const char *url)
{
  trace(DBG_TOOL, "mp3tool=%x url=%s", mp3tool, url);
  switch (mp3tool) {
  case MPG123_TOOL:
    loadmp3("mpg123", url);
    break;
  case XAUDIO_TOOL:
    loadmp3("xaudio", url);
    break;
  case FREEAMP_TOOL:
    loadmp3("freeamp", url);
    break;
  default:
    trace(DBG_TOOL, "unknown mp3 tool");
  }
}

void stopmp3(void)
{
  if (mp3pid > 0)
    kill(mp3pid, SIGKILL);
}

void pausemp3(void)
{
  if (mp3pid > 0)
    kill(mp3pid, SIGSTOP);
}

void contmp3(void)
{
  if (mp3pid > 0)
    kill(mp3pid, SIGCONT);
}

#endif /* !VRENGD */
