/* ==================================================== ======== ======= *
 *
 *  guiImpl.h : implementation (private) header for the VREng GUI
 *  NOTE: this file is common to  Athena, Motif and Ubit GUIs
 *
 *  VREng Project
 *  Author: Eric Lecolinet @ ENST Paris (elc@enst.fr)
 *  Date:   27 Nov 01
 *
 *  WWW: http://www.enst.fr/~elc  http://www.infres.enst.fr/net/vreng/
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef GUI_IMPL_HH
#define GUI_IMPL_HH

#include <GL/glx.h>
#include <GL/gl.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "config.h"
#include "vrdefs.h"


#define NET_TIMEOUT	500	// 500 ms - ex: 1000 ms
#define WMGT_TIMEOUT	50	// 50 ms
#define KRBUF_MAXCOUNT	10	// max number of postponed Key Release(s)
#define SHARED_COLOR_COUNT 25   // first colors preserved


// KR structure for postponing Key Releases when AutoRepeat is ON
struct KRKey {
  int vrkey;		// code of the corresponding VREng change key
  struct timeval time;	// time when this key was released
};


// struct for updating the ObjectBar and the ObjectMenu in the GUI
struct ObjInfo {
  char *name;			// class, instance or action name
  void (*fun)(int);		// function to call
  int  farg;			// arg of the function
};


class GUI {
public:
  // General
  boolean       sceneInitialized;  //NEW!
  boolean       readyAndVisible;// ready for rendering (and not iconified)
  int		cycles;		// how many mainLoop loops were perforemd
  class UAppli *appli;          // Application context of the Ubit GUI
  class GuiWidgets *guiWidgets;	// the widgets of the GUI

  // X Window
  Display	*display;
  Screen        *screen; 
  Colormap      cmap;
  XtAppContext	appContext; //TMP: will be removed soon
#ifndef WANT_UBIT
  Widget	toplevel;
  int 		appWidth, appHeight;
#endif
  // inputTable[table_no] = Xt Input table that corresponds to
  // -- tab_manager_fd for table_no==0
  // -- tab_fd for table_no==1
  XtInputId     *inputTable[2];

  // X Keyboard management
  long  postponedKRmask;	// mask of all postponed Key Release events
  int   postponedKRcount;	// count in the KRbuf
  KRKey postponedKRbuf[KRBUF_MAXCOUNT];

  // OpenGL and rendering window
  GLXContext	glxc;
  XVisualInfo	*glvisual;
  Window	glwin;		// the OpenGL rendering window:

  // Vreng 
  struct _ZVSolid *current_solid; // the solid that is currently selected
  void (*vrengInitCB)();  // fct. qui sera lancee apres l'ouverture de la fenetre

public:
  GUI();
  void createToplevel(int argc, char *argv[], char **fallback_resources);
  void initX();
  void mainLoop();

#ifdef WANT_UBIT
  void initScene();
  void renderScene();
  void resizeGLBuffer(class UEvent*);
#else
    void setVrengResources();
    static XrmOptionDescRec* getComlineOptions();
    static int getComlineOptionsCount();
    static XtResource* getVrengResourcesDefs();
    static int getVrengResourcesDefsCount();
#endif

  // table_no==0 for tab_manager_fd and table_no==1 for tab_fd
  void addInputTable(int cnt, int *fd_table, int table_no);
  void removeInputTable(int cnt, int table_no);

  // Key processing
  void processKey(KeySym keysym, boolean pressed);
  static long convertKey(KeySym keysym, int &vrkey);  // returns keymask
  boolean pendingPostponedKRs() {return (postponedKRmask!=0 || postponedKRcount!=0);}
  void flushPostponedKRs();

  // Callback functions

  // returns info about the pointed object but do NOT select it
  static struct _ZVSolid* getPointedObject(int x, int y, ObjInfo*);

  // returns info about the pointed object AND selects it
  static struct _ZVSolid* selectPointedObject(int x, int y, ObjInfo*);

  static void callVrengAction(int spaction);
  static void changeVrengKey(int key, boolean ispressed);

  static void setPref(int tool);
  static void setAudio(int on);
  static void setVideo(int on);
  static void setWhiteboard(int on);
  static void setSlidecast(int on);
  static void setModeler(int on);
  static void setJmrc(int on);
  static void back(int);
  static void forward(int);
  static void home(int);
  static void listbookmarks(int);
  static void addbookmark(int);
  static void quit(int status);
  static void help(int topic);
#if NOT_YET
  static void pref(int);
  static void edit(int);
  static void views(int);
  static void stats(int topic);
#endif
};


#endif /* GUI_IMPL_HH */
