#ifndef VRENGD

#include "global.h"


/* globals */
char vrengdir[PATH_LEN];	/* user homedir vreng path */
char vrengprefs[PATH_LEN];	/* prefs path */
char vrengbookmarks[PATH_LEN];	/* bookmarks path */
char vrengcache[PATH_LEN];	/* cache path */
char vrengpasswdfile[PATH_LEN];	/* VNC password path */

char systemname[9] = "unknown";
char releasename[9] = "unknown";
char machinename[9] = "unknown";

char *my_vrestr = NULL;
char *my_widthstr = NULL;
char *my_depthstr = NULL;
char *my_heightstr = NULL;
char *my_mapfrontstr = NULL;
char *my_mapbackstr = NULL;
char *my_mapleftstr = NULL;
char *my_maprightstr = NULL;
char *my_hoststr = NULL;
char *my_webstr = NULL;
char *my_modelstr = NULL;
char *my_facestr = NULL;
char *my_colorstr = NULL;
char *my_bapsstr = NULL;
char *httpproxystr = NULL;
char *noproxystr = NULL;
char *mcastproxystr = NULL;


void initsysinfo(void)
{
#if HAVE_UNAME
  struct utsname sysinfo;

  uname(&sysinfo);
  strcpy(systemname, sysinfo.sysname);
  strcpy(releasename, sysinfo.release);
  strcpy(machinename, sysinfo.machine);
#endif
}

void initNice(void)
{
#ifndef WIN32
  //PD nice(NZERO + 00);
  nice(0);
#endif /* !WIN32 */
}

void initFloating(void)
{
#if HAVE_FPSETMASK
  fpsetmask(0L);
#endif
}

void initEnv(void)
{
  char *home;
  char cwd[PATH_LEN];
  char pathenvdir[PATH_LEN], pathprefs[PATH_LEN], pathbookmarks[PATH_LEN], pathcache[PATH_LEN], pathpasswdfile[PATH_LEN];
  struct stat bufstat;

  if ((home = getenv("HOME")) == (char *) NULL)
    return;
  if (getcwd(cwd, sizeof(cwd)) == (char *) NULL)
    return;
  sprintf(pathenvdir, "%s/.vreng", home);
  if (stat(pathenvdir, &bufstat) < 0) {
    mkdir(pathenvdir, 0700);
  }
  strncpy(vrengdir, pathenvdir, PATH_LEN);
  chdir(pathenvdir);
  sprintf(pathprefs, "%s/prefs", pathenvdir);
  if (stat(pathprefs, &bufstat) == 0) {
    strncpy(vrengprefs, pathprefs, PATH_LEN);
  }
  sprintf(pathbookmarks, "%s/bookmarks", pathenvdir);
  strncpy(vrengbookmarks, pathbookmarks, PATH_LEN);
  sprintf(pathpasswdfile, "%s/MyPasswdFile", pathenvdir);
  strncpy(vrengpasswdfile, pathpasswdfile, PATH_LEN);

  sprintf(pathcache, "%s/cache", pathenvdir);
  if (stat(pathcache, &bufstat) < 0) {
    mkdir(pathcache, 0700);
  }
  strncpy(vrengcache, pathcache, PATH_LEN);
  chdir(cwd);
}

void parsePrefs(void)
{
  FILE *fp;
  char *p1, *p2, buf[BUFSIZ];

  if ((fp = fopen(vrengprefs, "r")) == NULL)
    return;

  while (fgets(buf, sizeof(buf), fp)) {
    if (*buf == '#' || *buf == '\n')
      continue;
    buf[strlen(buf) - 1] = '\0';
    p1 = strtok(buf, " \t");
    p2 = strtok(NULL, " \t");
    if (strncasecmp(p1, "world", 5) == 0) {
      my_vrestr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_vrestr, p2);
      trace(DBG_INIT, "vre = %s", p2);
    }
    else if (strncasecmp(p1, "width", 5) == 0) {
      my_widthstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_widthstr, p2);
      trace(DBG_INIT, "width = %s", p2);
    }
    else if (strncasecmp(p1, "depth", 5) == 0) {
      my_depthstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_depthstr, p2);
      trace(DBG_INIT, "depth = %s", p2);
    }
    else if (strncasecmp(p1, "height", 6) == 0) {
      my_heightstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_heightstr, p2);
      trace(DBG_INIT, "height = %s", p2);
    }
    else if (strncasecmp(p1, "mapfront", 8) == 0 ||
             strncasecmp(p1, "mapface", 7) == 0) {
      my_mapfrontstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_mapfrontstr, p2);
      trace(DBG_INIT, "mapfront = %s", p2);
    }
    else if (strncasecmp(p1, "mapback", 7) == 0) {
      my_mapbackstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_mapbackstr, p2);
      trace(DBG_INIT, "mapback = %s", p2);
    }
    else if (strncasecmp(p1, "mapleft", 7) == 0) {
      my_mapleftstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_mapleftstr, p2);
      trace(DBG_INIT, "mapleft = %s", p2);
    }
    else if (strncasecmp(p1, "mapright", 8) == 0) {
      my_maprightstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_maprightstr, p2);
      trace(DBG_INIT, "mapright = %s", p2);
    }
    else if (strncasecmp(p1, "host", 4) == 0) {
      my_hoststr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_hoststr, p2);
      trace(DBG_INIT, "host = %s", p2);
    }
    else if (strncasecmp(p1, "web", 3) == 0) {
      my_webstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_webstr, p2);
      trace(DBG_INIT, "web = %s", p2);
    }
    else if (strncasecmp(p1, "model", 5) == 0) {
      my_modelstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_modelstr, p2);
      trace(DBG_INIT, "model = %s", p2);
    }
    else if (strncasecmp(p1, "face", 4) == 0) {
      my_facestr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_facestr, p2);
      trace(DBG_INIT, "face = %s", p2);
    }
    else if (strncasecmp(p1, "color", 5) == 0) {
      my_colorstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_colorstr, p2);
      trace(DBG_INIT, "color = %s", p2);
    }
    else if (strncasecmp(p1, "baps", 4) == 0) {
      my_bapsstr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(my_bapsstr, p2);
      trace(DBG_INIT, "baps = %s", p2);
    }
    else if (strncasecmp(p1, "http_proxy", 10) == 0) {
      httpproxystr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(httpproxystr, p2);
      trace(DBG_INIT, "httpproxy = %s", p2);
    }
    else if (strncasecmp(p1, "no_proxy", 8) == 0) {
      noproxystr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(noproxystr, p2);
      trace(DBG_INIT, "noproxy = %s", p2);
    }
    else if (strncasecmp(p1, "mcast_proxy", 11) == 0) {
      mcastproxystr = (char *) calloc(1, strlen(p2) + 1);
      strcpy(mcastproxystr, p2);
      trace(DBG_INIT, "mcastproxy = %s", p2);
    }
  }

  fclose(fp);
}

#endif /* !VRENGD */
