#include "UniversalRealTest.hh"
#include "tyvis/UniversalReal.hh"
#include <warped/SerializedInstance.h>
#include <clutils/StringUtilities.h>

double
UniversalRealTest::getDefaultValue(){
  static double defaultValue = 5.55;
  return defaultValue;
}

void 
UniversalRealTest::setUp(){
  toTest = new UniversalReal( getDefaultValue() );
}

void 
UniversalRealTest::tearDown(){
  delete toTest;
}

void
UniversalRealTest::testGetUniversalKind(){
  CPPUNIT_ASSERT( toTest->getUniversalKind() == VHDLData::UNIVERSAL_REAL );
}

void
UniversalRealTest::testGetLength(){
  CPPUNIT_ASSERT( toTest->length() == 1 );
}

void
UniversalRealTest::testPrint(){
  ostringstream printStream;
  toTest->print( printStream );
  CPPUNIT_ASSERT( printStream.str() == doubleToString( getDefaultValue() ));
}

void
UniversalRealTest::testEqual(){
  UniversalReal a(10);
  UniversalReal b(10);
  
  CPPUNIT_ASSERT( a == b );
}

void
UniversalRealTest::testNotEqual(){
  UniversalReal a(10);
  UniversalReal b(11);
  
  CPPUNIT_ASSERT( a != b );
}

void
UniversalRealTest::testGreater(){
  UniversalReal a(10);
  UniversalReal b(11);
  
  CPPUNIT_ASSERT( b > a );
}

void
UniversalRealTest::testGreaterEqual(){
  UniversalReal a(10);
  UniversalReal b(11);
  UniversalReal c(11);
  
  CPPUNIT_ASSERT( b >= a );
  CPPUNIT_ASSERT( b >= c );
}

void
UniversalRealTest::testLess(){
  UniversalReal a(10);
  UniversalReal b(11);
  
  CPPUNIT_ASSERT( a < b );
}

void
UniversalRealTest::testLessEqual(){
  UniversalReal a(10);
  UniversalReal b(11);
  UniversalReal c(11);
  
  CPPUNIT_ASSERT( a <= c );
  CPPUNIT_ASSERT( b <= c );
}

void
UniversalRealTest::testClone(){
  UniversalReal *cloned = dynamic_cast<UniversalReal *>(toTest->clone());
  CPPUNIT_ASSERT( cloned != 0 );
  CPPUNIT_ASSERT( cloned != toTest );
  CPPUNIT_ASSERT( *cloned = *toTest );
  delete cloned;
}

void
UniversalRealTest::testSerialization(){
  SerializedInstance *serialized = static_cast<Serializable *>(toTest)->serialize();
  CPPUNIT_ASSERT( serialized->getDataType() == toTest->getDataType() );
  UniversalReal *deserialized = dynamic_cast<UniversalReal *>( serialized->deserialize() );
  CPPUNIT_ASSERT( deserialized != 0 );
  CPPUNIT_ASSERT( deserialized != toTest );
  CPPUNIT_ASSERT( *deserialized = *toTest );
  delete deserialized;
}
