#ifndef UNIVERSAL_INTEGER_TEST_HH
#define UNIVERSAL_INTEGER_TEST_HH

#include <cppunit/extensions/HelperMacros.h>
#include "VHDLDataTest.hh"

class UniversalInteger;

class UniversalIntegerTest : public VHDLDataTest {
  CPPUNIT_TEST_SUITE( UniversalIntegerTest);
  CPPUNIT_TEST(testGetUniversalKind);
  CPPUNIT_TEST(testGetLength);
  CPPUNIT_TEST(testPrint);
  CPPUNIT_TEST(testEqual);
  CPPUNIT_TEST(testNotEqual);
  CPPUNIT_TEST(testGreater);
  CPPUNIT_TEST(testGreaterEqual);
  CPPUNIT_TEST(testLess);
  CPPUNIT_TEST(testLessEqual);
  CPPUNIT_TEST(testClone);
  CPPUNIT_TEST(testSerialization);
  CPPUNIT_TEST(testMinus);
  CPPUNIT_TEST(testPlus);
  CPPUNIT_TEST(testMultiply);
  CPPUNIT_TEST(testDivide);
  CPPUNIT_TEST_SUITE_END();

private:
  UniversalInteger *toTest;

  static int getDefaultValue();

public:
  void setUp();
  void tearDown();

  void testGetUniversalKind();
  void testGetLength();
  void testPrint();
  void testEqual();
  void testNotEqual();
  void testGreater();
  void testGreaterEqual();
  void testLess();
  void testLessEqual();
  void testClone();
  void testSerialization();
  void testPlus();
  void testMinus();
  void testMultiply();
  void testDivide();
};

#endif
