#ifndef _SAVANT_SEVERITY_LEVEL_HH
#define _SAVANT_SEVERITY_LEVEL_HH

#include <iostream>
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include "tyvis/VHDLData.hh"
using std::cout;

class _savant_severity_level : public VHDLData {
  friend ostream& operator<<(ostream&, const _savant_severity_level&);
public:
  enum SeverityLevel_t { NOTE, WARNING, ERROR, FAILURE };
  
  SeverityLevel_t val;

  int getIntValue() const { return val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return (double)val; }

  virtual VHDLData::UniversalType getUniversalKind() const{
    return SEVERITY_LEVEL;
  }

  _savant_severity_level() { val = NOTE;}
  _savant_severity_level(SeverityLevel_t s) { val = s;}
  _savant_severity_level(const _savant_severity_level& s) : VHDLData() { val = s.val;}

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }
  
  bool operator!=(const RValue &compareTo ) const {
    return val != dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }

  bool operator>( const RValue &compareTo ) const{
    return val > dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }

  bool operator>=( const RValue &compareTo ) const {
    return val >= dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }

  bool operator<( const RValue &compareTo ) const {
    return val < dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }

  bool operator<=( const RValue &compareTo ) const {
    return val <= dynamic_cast<const _savant_severity_level &>( compareTo ).val;
  }

  void print(ostream& os = cout) const { os << *this; os.flush();}

  VHDLData *clone() const {
    return new _savant_severity_level(*this);
  }

  static const string &getSeverityLevelType(){
    static const string universalSeverityLevelType = "SeverityLevel";
    return universalSeverityLevelType;
  }

  const string &getDataType() const {
    return getSeverityLevelType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new _savant_severity_level( SeverityLevel_t( si->getInt() ));
  }
  
  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getSeverityLevelType(),
							   &_savant_severity_level::deserialize );
  }


};

inline ostream& operator<<(ostream& os, const _savant_severity_level& sl) {
  switch (sl.val) {
  case _savant_severity_level::NOTE:
    os << "NOTE";
    break;
  case _savant_severity_level::WARNING:
    os << "WARNING";
    break;
  case _savant_severity_level::ERROR:
    os << "ERROR";
    break;
  case _savant_severity_level::FAILURE:
    os << "FAILURE";
    break;
  default:
    os << "(invalid SeverityLevel type)";
    break;
  }
  return os;
}

#endif

