#include "TypeConvert.hh"
#include "_savant_entity_elab.hh"
#include "SourceBase.hh"
#include "SourceInfo.hh"
#include "VHDLProcess.hh"

TypeConvert::TypeConvert(_savant_entity_elab *proc) {
  upperSignalnetInfo   = NULL;
  upperDriver          = NULL;
  lowerSignal          = NULL;
  conversionFunctionId = -1;
  sourceBaseDeleteFlag = false;
  enclosingScope       = proc;
}

TypeConvert::~TypeConvert() {

  if ( sourceBaseDeleteFlag == false ){
    upperSignalnetInfo->set_sourcebase_delete_flag(false);
  }
  
  delete upperSignalnetInfo;
  delete upperDriver;
  delete lowerSignal;
}

VHDLType *
TypeConvert::resolve( VHDLKernel *processPtr ){
  VHDLType *retval = lowerSignal->resolve(processPtr);
  VHDLType *typeconvertvalue = NULL;

  // We need to manually update the signal with the resolved value if the
  // type is a composite resolved type. If the composite type is not a
  // composite resolved type, then we update its value in the scalar type
  // itself
  
  if ( lowerSignal->_is_composite_resolved_type() ){
    assignVariable( *lowerSignal, *retval );
  }

  if( enclosingScope != NULL ){
    // All the operations within the typeconversion function must be performed
    // wihin the context of the enclosingScope.  However, the function could be
    // called from several different processes. So save and restore the enclosingScoope
    // to ensure that the operating region is correct within the TCF.
    _savant_entity_elab *oldProc = processPtr->getProc();
    processPtr->setProc( enclosingScope );
    typeconvertvalue = (savantTypeConversionFn[conversionFunctionId](static_cast<VHDLProcess *>(processPtr), lowerSignal));
    processPtr->setProc( oldProc );
  }
  else {
    typeconvertvalue = (savantTypeConversionFn[conversionFunctionId](static_cast<VHDLProcess *>(processPtr), lowerSignal));
  }

  ASSERT ( typeconvertvalue != NULL );
    
  assignVariable( *upperDriver, *typeconvertvalue, nullInfo, nullInfo );

  delete typeconvertvalue;
  return upperDriver;
}
