#ifndef FILETYPE_HH
#define FILETYPE_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include <iostream>
#include "tyvis/VHDLType.hh"
#include "tyvis/_savant_file_open_kind.hh"
#include "tyvis/TypeKind.hh"
#include "tyvis/ArrayType.hh"

using std::ios;

extern const int maxExtraInFilesInProcedure;
extern const int maxExtraOutFilesInProcedure;

class AccessVariable;
class VHDLKernel;

class FileType : public VHDLType {
public:

  FileType(bool alias = false);
  FileType(const FileType &);
  FileType( VHDLKernel*, const char*, const _savant_file_open_kind );
  FileType( VHDLKernel*, const ArrayType&, const _savant_file_open_kind );

  virtual void openFile( VHDLKernel *, 
			 const char *fileName, 
			 const _savant_file_open_kind &, 
			 ios::openmode = ios::out );
  
  virtual  void openFile( VHDLKernel *, 
			  const ArrayType& fileName, 
			  const _savant_file_open_kind &, 
			  ios::openmode = ios::out);

  void closeFile(VHDLKernel *);
  
  void reset(const char *fileName);
  void reset(const ArrayType& fileName);
  
  virtual ~FileType();

  virtual Type get_kind() const;

  ObjectBase* getObject() const {
    return NULL;
  }

  virtual ObjectBase::ObjectType getKind() const;

  virtual void print(ostream& = cout) const;
  
  VHDLType* clone() const;
  
  int savantwriteline( VHDLKernel *, AccessVariable & );
  int savantwriteline( VHDLKernel *, AccessType & );
  int savantreadline(  VHDLKernel *, AccessVariable & );
  int savantreadline(  VHDLKernel *, AccessType &);
  int savantreadline(  VHDLKernel *, AccessType &, IntegerType& );
  
  EnumerationType savantendfile_boolean( VHDLKernel *, int );
  
  int get_fileHandle() const;
  _savant_file_open_kind& get_fileOpenKind();
  void set_fileHandle(const int);
  void set_fileOpenKind(const _savant_file_open_kind &);

  VHDLType& operator=(const VHDLType &);
  FileType& operator=(const FileType &);

  bool operator==( const RValue & ) const;
  bool operator!=( const RValue & ) const;
  bool operator>( const RValue & ) const;
  bool operator>=( const RValue & ) const;
  bool operator<( const RValue & ) const;
  bool operator<=( const RValue & ) const;
  
  int fileHandle;
  _savant_file_open_kind openKind;
};

extern int savantwrite( VHDLKernel *, FileType &, const VHDLType & );
extern int savantread( VHDLKernel *, FileType&, VHDLType & );
extern EnumerationType savantendfile_boolean( VHDLKernel *, FileType & );
extern int savantfile_close( VHDLKernel *, const FileType & );

#endif
