#include "EnumerationTypeInfo.hh"
#include "EnumerationType.hh"
#include "std_standardPkg.hh"

//The constructors for EnumerationTypeInfo
EnumerationTypeInfo::EnumerationTypeInfo() {
  imageMap       = NULL;
  no_of_elements = 0;
  dirn           = ArrayInfo::to;
  left           = 0;
}

EnumerationTypeInfo::EnumerationTypeInfo(int n, char** image, int l, ArrayInfo::ArrayDirn_t d)  {
  imageMap       = image;
  no_of_elements = n;
  dirn           = d;
  left           = l;
}

EnumerationTypeInfo::~EnumerationTypeInfo() {
}

EnumerationTypeInfo::EnumerationTypeInfo(const EnumerationTypeInfo& ei) :
  TypeInfo(){
  imageMap       = ei.imageMap;
  no_of_elements = ei.no_of_elements;
  dirn           = ei.dirn;
  left           = ei.left;
}

char **
EnumerationTypeInfo::get_imageMap() const{
  return imageMap;
}

int
EnumerationTypeInfo::get_no_of_elements() const{
  return no_of_elements;
}

int 
EnumerationTypeInfo::get_left() const{
  return left;
}

int 
EnumerationTypeInfo::get_right() const{
  if (dirn == ArrayInfo::to) {
    return get_no_of_elements() - 1 + left;
  }
  else {
    return left - get_no_of_elements() + 1;
  }
}

EnumerationTypeInfo&
EnumerationTypeInfo::operator=(const EnumerationTypeInfo &ei) {
  imageMap       = ei.imageMap;
  no_of_elements = ei.no_of_elements;
  dirn           = ei.dirn;
  left           = ei.left;
  
  return *this;
}
  
ArrayInfo::ArrayDirn_t 
EnumerationTypeInfo::get_direction() const{
  return dirn;
}

int
EnumerationTypeInfo::getCharacterOffset() const {
  ASSERT (imageMap != NULL);

  if (strlen(imageMap[0]) < 2) {
    return 0;
  }

  if (imageMap[0][0] == '\'') {
    return imageMap[0][1];
  }

  return 0;
}

int
EnumerationTypeInfo::get_range() const {
  return get_no_of_elements();
}

VHDLType*
EnumerationTypeInfo::createObject(ObjectBase::ObjectType objType) const {
  return new EnumerationType(objType, *this);
}

bool
EnumerationTypeInfo::is_character_type() const {
  // DEM - this is bogus - we need to actually determine if this is a
  // character type by checking if the elements all belong in the set
  // defined in savantcharacterType_info
  if( this == &SavantcharacterType_info ||
      this == &SavantbitType_info ){
    return true;
  }
  else{
    return false;
  }
}
