//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "Savantbit_vectorType.hh"
#include "Vector.hh"

rangeInfo Savantbit_vectorType_rangeInfo[] = {rangeInfo(UniversalInteger((int)0), to, UniversalInteger( (int)2147483647))};
arrayTypeInfo Savantbit_vectorType_info(1, Savantbit_vectorType_rangeInfo);

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, const TypeInfo&) : ArrayType(objType) {
  if (ArrayType::rangeInfo != NULL) {
    object = new     Vector<EnumerationType> (objType);
    object->setRange(objType, ArrayType::rangeInfo, 1, SavantbitType_info);
  }
  else {
    object = NULL;
  }
}

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, 
					   int left, ArrayDirn_t dirn,
					   int right,
					   const TypeInfo&) {
  ArrayInfo aInfo;
  if (left < right && dirn == downto){
    aInfo = ArrayInfo();
  }
  else{
    aInfo = ArrayInfo(left, dirn, right);
  }
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantbitType_info);
}

Savantbit_vectorType::Savantbit_vectorType(const Savantbit_vectorType &tmp) {
  object = new Vector<EnumerationType> (ObjectBase::VARIABLE);
  object->setRange(ObjectBase::VARIABLE, &(tmp.object->bounds), 1, SavantbitType_info);
  *object = *(tmp.object);
}

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, 
					   int left, ArrayDirn_t dirn,
					   int right, char* value,
					   const TypeInfo&) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantbitType_info);
  this->operator=(value);
}

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, 
				   int left, ArrayDirn_t dirn, 
				   int right, const Savantbit_vectorType& tmp){
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantbitType_info);
  *object = *(tmp.object);
}

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType,
					   const Savantbit_vectorType& value) {
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, value.object);
  *object = *(value.object);
}

Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, 
					   char* value, const TypeInfo&) {
  ArrayInfo aInfo = ArrayInfo(0, to, strlen(value)-1);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1, SavantbitType_info);
  *this = value;
}

//Constructor for aggregate initialization
Savantbit_vectorType::Savantbit_vectorType(ObjectBase::ObjectType objType, 
					   int left1, ArrayDirn_t dirn1, 
					   int right1,int noofElmntAssns, ...)
  : ArrayType(objType) {
    ArrayInfo aInfo[] = {ArrayInfo(left1, dirn1, right1)};
    object = new     Vector<EnumerationType> (objType);
    object->setRange(objType, aInfo, 1, SavantbitType_info);
    va_list ap;
    ElementAssociation* elmtptr;
    ElementAssociation* othersAssociation;
    ElementAssociation** elmtAssocArray;
    char* charptr = NULL;
    int i=0;
    int j=0;

    int correct_index = 0;
    int temp =0;
    bool positional_association = false;
    charptr = new char[object->numElems];
    elmtAssocArray = (ElementAssociation**) new char[noofElmntAssns *
						    sizeof(ElementAssociation*)];
    for (i=0; i < object->numElems; i++) {
      charptr[i] = 'U';
    }

    va_start(ap, noofElmntAssns);
    for(i =0; i < noofElmntAssns; i++) {
      elmtAssocArray[i] = va_arg(ap, ElementAssociation*);
    }
    va_end(ap);
    
    elmtptr = elmtAssocArray[0];
    if( noofElmntAssns == this->object->bounds.length()) {
      if(elmtptr->choice.left() == elmtptr->choice.right()) {
	if(elmtptr->choice.left() == 0) {
	  if(this->object->bounds.contains(0)) {
	    temp = elmtAssocArray[noofElmntAssns -1]->choice.left();
	    if(this->object->bounds.contains(temp)) {
	      positional_association = false;
	    }
	    else {
	      positional_association = true;
	    }
	  }
	  else {
	    positional_association = true;
	  }
	}
	else {
	  positional_association = false;
	}
      }
      else {
	positional_association = false;
      }
    }
    else {
      positional_association = false;
    }
    for(i =0; i < noofElmntAssns; i++) {
      elmtptr = elmtAssocArray[i];
      if(elmtptr->choice == Others) {
	othersAssociation = elmtptr;
	break;
      }
      else {
	if(elmtptr->choice.left() == elmtptr->choice.right()) {
	  if(positional_association == true) {
	    correct_index = this->object->bounds.actualIndex(elmtptr->choice.left());
	  }
	  else {
	    correct_index = elmtptr->choice.left();
	  }
	  (*this->object)[correct_index].assignVal(*elmtptr->value);
	  charptr[this->object->bounds.storageIndex(correct_index)]
	    = 'I';

	}
	else {
	  if(elmtptr->choice.dirn() == to) {
	    for(j=elmtptr->choice.left(); j <= elmtptr->choice.right(); j++) {
	      if(positional_association == true) {
		correct_index = this->object->bounds.actualIndex(j);
	      }
	      else {
		correct_index = j;
	      }
	      (*this->object)[correct_index].assignVal(*elmtptr->value);
	      charptr[this->object->bounds.storageIndex(correct_index)] = 'I';
	    }
	  }
	  else {
	    for(j=elmtptr->choice.left(); j >= elmtptr->choice.right(); j--) {
	      if(positional_association == true) {
		correct_index = this->object->bounds.actualIndex(j);
	      }
	      else {
		correct_index = j;
	      }
	      (*this->object)[correct_index].assignVal(*elmtptr->value);
	      charptr[this->object->bounds.storageIndex(correct_index)] = 'I';
	    }
	  }
	}
      }
    }

    for(i=0; i < object->numElems; i++) {
      if(charptr[i] == 'U') {
	this->object->get_element(i) = *othersAssociation->value;
      }
    }

    for(i =0; i < noofElmntAssns; i++) {
      delete  elmtAssocArray[i]->value;
      delete  elmtAssocArray[i];
    }
    if(elmtAssocArray != NULL) {
      delete [] elmtAssocArray;
    }
    delete [] charptr;
}

//Constructor for alias initialization
Savantbit_vectorType::Savantbit_vectorType(bool alias, 
					   ObjectBase::ObjectType,
					   int left, ArrayDirn_t dirn, 
					   int right, const ArrayType& actual,
					   const ArrayInfo& boundsOfActual)
  : ArrayType(alias) {
  ArrayInfo actualBounds = boundsOfActual;
  
  if(boundsOfActual == nullInfo) {
    actualBounds  = actual.object->bounds;
  }
  object = actual.object->getNewArray(ArrayInfo(left, dirn, right),
				      actualBounds);
}

Savantbit_vectorType::~Savantbit_vectorType() {}

Savantbit_vectorType&
Savantbit_vectorType::getSlice(const ArrayInfo& newBounds) {
  return *(Savantbit_vectorType *) getNewArray(newBounds, newBounds);
}

VHDLType& 
Savantbit_vectorType::operator=(const VHDLType& val) {
  if (object == NULL) {
    object = (VectorBase *) ((Savantbit_vectorType &) val).object->clone();
  }
  
  is_alias = val.is_alias;
  *object = *((const Savantbit_vectorType&) val).object;
  return *this;
}

Savantbit_vectorType& 
Savantbit_vectorType::operator=(const Savantbit_vectorType& val) {
  if (object == NULL) {
    object = (VectorBase *) val.object->clone();
  }
  
  *object = *val.object;
  return *this;
}

VHDLType& 
Savantbit_vectorType::operator=(const char *str) {
  register int leftlimit = object->bounds.left();
  register int rightlimit =  object->bounds.right();
  register int i = 0;
  if(object->bounds.dirn() == to) {
    for(i = leftlimit; i <= rightlimit; i++) {
      ((EnumerationType &) (*object)[i]).object->updateVal(UniversalInteger(str[i - leftlimit] - '0'));
    }
  } else {
    for(i = leftlimit; i >= rightlimit; i--) {
      ((EnumerationType &) (*object)[i]).object->updateVal(UniversalInteger(str[leftlimit - i] - '0'));
    }
  }
  return (*this);
}

VHDLType&
Savantbit_vectorType::operator[](const int i) const {
  return (EnumerationType &) (*object)[i];
}

EnumerationType&
Savantbit_vectorType::operator[](const ScalarType& i) const {
  UniversalInteger val = (UniversalInteger &) i.object->readVal();
  return (EnumerationType &) (*object)[int(val)];
}

const IntegerType
Savantbit_vectorType::LEFT_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).left();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const IntegerType
Savantbit_vectorType::RIGHT_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).right();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const IntegerType
Savantbit_vectorType::HIGH_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = ((*this).dirn() == to ? (*this).right() : (*this).left());
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const IntegerType
Savantbit_vectorType::LOW_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = ((*this).dirn() == to ? (*this).left() : (*this).right());
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const IntegerType
Savantbit_vectorType::LENGTH_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  int retval;
  switch(val) {
  case 1:
    retval = (*this).length();
    return IntegerType(ObjectBase::VARIABLE, UniversalInteger(retval));
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

const EnumerationType
Savantbit_vectorType::ASCENDING_O(const IntegerType& n) const {
  int val = ((UniversalInteger &) n.object->readVal()).val;
  switch(val) {
  case 1:
    if((*this).dirn() == to) {
      return SAVANT_BOOLEAN_TRUE;
    } else {
      return SAVANT_BOOLEAN_FALSE;
    }
    break;
  }
  cerr << "Index not int range." << endl;
  abort();
}

EnumerationType
savantEqual(const Savantbit_vectorType &lhs, const Savantbit_vectorType &rhs) {

  bool lhs_is_null_range = lhs.object->bounds.is_null_range();
  bool rhs_is_null_range = rhs.object->bounds.is_null_range();

  //Checking for null arrays
  if( lhs_is_null_range && rhs_is_null_range) {
    return SAVANT_BOOLEAN_TRUE;
  }
  else if( lhs_is_null_range || rhs_is_null_range) {
    return SAVANT_BOOLEAN_FALSE;
  }

  int lhs_left      = lhs.object->bounds.left();
  int rhs_left      = rhs.object->bounds.left();
  int lhs_counter   = 0;
  int rhs_counter   = 0;
  int lhs_increment = lhs.object->bounds.dirn();
  int rhs_increment = rhs.object->bounds.dirn();
  int counter;
  
  if (lhs.get_number_of_elements() != rhs.get_number_of_elements()) {
    return SAVANT_BOOLEAN_FALSE;
  }

  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    if (SAVANT_BOOLEAN_FALSE == savantEqual((EnumerationType&) lhs[lhs_counter + lhs_left], (EnumerationType&)rhs[rhs_counter + rhs_left]))
      return SAVANT_BOOLEAN_FALSE;
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }

  return SAVANT_BOOLEAN_TRUE;
}


EnumerationType
savantNotEqual(const Savantbit_vectorType &lhs, 
	       const Savantbit_vectorType &rhs) {
  return savantNot(savantEqual(lhs, rhs));
}

EnumerationType
savantLessThan(const Savantbit_vectorType &lhs, 
	       const Savantbit_vectorType &rhs) {

  bool lhs_is_null_range = lhs.object->bounds.is_null_range();
  bool rhs_is_null_range = rhs.object->bounds.is_null_range();
  
  //Checking for null arrays
  if( lhs_is_null_range && rhs_is_null_range) {
    return SAVANT_BOOLEAN_FALSE;
  }
  else if( lhs_is_null_range && (!rhs_is_null_range)) {
    return SAVANT_BOOLEAN_TRUE;
  }
  else if((!lhs_is_null_range) && rhs_is_null_range) {
    return SAVANT_BOOLEAN_FALSE;
  }
  
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int lhs_counter   = 0;
  register int rhs_counter   = 0;
  
  register int counter = 0;
  register int lhs_length = lhs.get_number_of_elements();
  register int rhs_length = rhs.get_number_of_elements();
  register int i = 0;
  
  if(lhs_length < rhs_length){
    counter = lhs_length;
  }
  else {
    counter = rhs_length;
  }

  for(i = 0; (i < counter); i++) {
    if (SAVANT_BOOLEAN_TRUE == savantGreaterThan((EnumerationType&)lhs[lhs_counter + lhs_left], (EnumerationType&)rhs[rhs_counter + rhs_left])){
      return SAVANT_BOOLEAN_FALSE;
    }
    if(SAVANT_BOOLEAN_TRUE == savantLessThan((EnumerationType&) lhs[lhs_counter + lhs_left], (EnumerationType&) rhs[rhs_counter + rhs_left])) {
      return SAVANT_BOOLEAN_TRUE;
    }
    
    rhs_counter += rhs_increment;
    lhs_counter += lhs_increment;
  }
  
  if(lhs_length < rhs_length) {
    return SAVANT_BOOLEAN_TRUE;
  }
  else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

EnumerationType
savantLessThanOrEqual(const Savantbit_vectorType &lhs, 
		      const Savantbit_vectorType &rhs) {

  return savantOr(savantLessThan(lhs, rhs), savantEqual(lhs, rhs));
}

EnumerationType
savantGreaterThan(const Savantbit_vectorType &lhs, 
		  const Savantbit_vectorType &rhs) {
  return savantNot(savantLessThanOrEqual(lhs, rhs));
}

EnumerationType
savantGreaterThanOrEqual(const Savantbit_vectorType &lhs, 
			 const Savantbit_vectorType &rhs) {
  return savantNot(savantLessThan(lhs, rhs));
}

Savantbit_vectorType
savantAnd(const Savantbit_vectorType &lhs, 
	  const Savantbit_vectorType &rhs) {

  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
  
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int lhs_counter   = 0;
  register int rhs_counter   = 0;
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantAnd((const EnumerationType &) lhs[lhs_counter + lhs_left], 
		(const EnumerationType &) rhs[rhs_counter + rhs_left]);
    
    rhs_counter += rhs_increment;
    lhs_counter += lhs_increment;
  }
  
  return result;
}

Savantbit_vectorType
savantOr(const Savantbit_vectorType &lhs, 
	 const Savantbit_vectorType &rhs) {

  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int lhs_counter   = 0;
  register int rhs_counter   = 0;
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantOr((const EnumerationType &) lhs[lhs_counter + lhs_left], 
	       (const EnumerationType &) rhs[rhs_counter + rhs_left]);

    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }

  return result;
}

Savantbit_vectorType
savantNand(const Savantbit_vectorType &lhs, const Savantbit_vectorType &rhs) {

  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int rhs_counter   = 0;
  register int lhs_counter   = 0;
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantNand((const EnumerationType &) lhs[lhs_counter + lhs_left], 
		 (const EnumerationType &) rhs[rhs_counter + rhs_left]);
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }
  
  return result;
}

Savantbit_vectorType
savantNor(const Savantbit_vectorType &lhs, const Savantbit_vectorType &rhs) {

  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_counter   = 0;
  register int lhs_counter   = 0;
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantNor((const EnumerationType &) lhs[lhs_counter + lhs_left],  
		(const EnumerationType &) rhs[rhs_counter + rhs_left]);
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }
  
  return result;
}

Savantbit_vectorType
savantXor(const Savantbit_vectorType &lhs, const Savantbit_vectorType &rhs) {
  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int rhs_counter   = 0;
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  ASSERT((result.get_number_of_elements() == lhs.get_number_of_elements()));
  ASSERT((result.object->bounds.left() == lhs_left));
    
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantXor((const EnumerationType &) lhs[lhs_counter + lhs_left],  
		(const EnumerationType &) rhs[rhs_counter + rhs_left]);

    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }

  return result;
}

Savantbit_vectorType
savantXnor(const Savantbit_vectorType &lhs, const Savantbit_vectorType &rhs) {
  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()) || (rhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int rhs_left      = rhs.object->bounds.left();
  register int lhs_increment = lhs.object->bounds.dirn();
  register int rhs_increment = rhs.object->bounds.dirn();
  register int lhs_counter   = 0;
  register int rhs_counter   = 0;
  register int counter       = 0;
  
  ASSERT((lhs.get_number_of_elements() == rhs.get_number_of_elements()));
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantXnor((const EnumerationType &) lhs[rhs_counter + lhs_left],
		 (const EnumerationType &) rhs[rhs_counter + rhs_left]);
    
    lhs_counter += lhs_increment;
    rhs_counter += rhs_increment;
  }
  
  return result;
}

Savantbit_vectorType
savantNot(const Savantbit_vectorType &lhs) {
  Savantbit_vectorType result(lhs);

  if((lhs.object->bounds.is_null_range()))
    return lhs;
 
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  for(counter = lhs.get_number_of_elements() - 1; (counter >= 0); counter--) {
    result[lhs_counter + lhs_left] = 
      savantNot((const EnumerationType &) lhs[lhs_counter + lhs_left]);
    
    lhs_counter += lhs_increment;
  }
  
  return result;
}

Savantbit_vectorType
savantSLL(const Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return lhs;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSLL(lhs, savantUnaryMinus(rhs));
  }

  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return lhs;
  
  while (rhs_value) {
    lhs_counter = lhs_left;
    for(counter = 0; (counter < (lhs_size - 1)); counter++) {
      result[lhs_counter] = temp[lhs_counter + lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[result.object->bounds.right()] = EnumerationType(ObjectBase::VARIABLE, SavantbitType_info.get_left());
    
    temp = result;
    rhs_value--;
  }
  
  return result;
}

Savantbit_vectorType
savantSRL(const Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return lhs;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSRL(lhs, savantUnaryMinus(rhs));
  }
    
  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return lhs;

  while(rhs_value) {
    lhs_counter = lhs_left + lhs_increment;
    for(counter = 1; (counter < lhs_size); counter++) {
      result[lhs_counter] = temp[lhs_counter - lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[lhs_left] = EnumerationType(ObjectBase::VARIABLE, SavantbitType_info.get_left());
    temp = result;

    rhs_value--;
  }
  
  return result;
}

Savantbit_vectorType
savantSRA(const Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return lhs;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSLA(lhs, savantUnaryMinus(rhs));
  }
    
  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return lhs;

  while(rhs_value) {
    lhs_counter = lhs_left + lhs_increment;
    for(counter = 1; (counter < lhs_size); counter++) {
      result[lhs_counter] = temp[lhs_counter - lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[lhs_left] = temp[lhs_left];

    temp = result;

    rhs_value--;
  }
  
  return result;
}

Savantbit_vectorType
savantSLA(const Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return lhs;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSRL(lhs, savantUnaryMinus(rhs));
  }
    
  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return result;

  while(rhs_value) {
    lhs_counter = lhs_left;
    for(counter = 0; (counter < (lhs_size - 1)); counter++) {
      result[lhs_counter] = temp[lhs_counter + lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[result.object->bounds.right()] = temp[temp.object->bounds.right()];
    temp = result;

    rhs_value--;
  }
  
  return result;
}

Savantbit_vectorType
savantROL(Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return result;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSRL(lhs, savantUnaryMinus(rhs));
  }
    
  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return result;

  while(rhs_value) {
    lhs_counter = lhs_left;
    for(counter = 0; (counter < (lhs_size - 1)); counter++) {
      result[lhs_counter] = temp[lhs_counter + lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[result.object->bounds.right()] = temp[lhs_left];
    temp = result;

    rhs_value--;
  }
  
  return result;
}

Savantbit_vectorType
savantROR(Savantbit_vectorType &lhs, const IntegerType &rhs) {
  Savantbit_vectorType result(lhs);
  Savantbit_vectorType temp(lhs);
  
  if(lhs.object->bounds.is_null_range()) {
    return result;
  }
  
  if(EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(false)) == savantLessThan(rhs, IntegerType(ObjectBase::VARIABLE, 0))) {
    return savantSLA(lhs, savantUnaryMinus(rhs));
  }
    
  register int lhs_size      = lhs.get_number_of_elements();
  register int rhs_value     = (UniversalInteger &) rhs.object->readVal();
  register int lhs_left      = lhs.object->bounds.left();
  register int lhs_counter   = 0;
  register int lhs_increment = lhs.object->bounds.dirn();
  register int counter       = 0;
  
  if (rhs_value == 0)
    return lhs;

  while(rhs_value) {
    lhs_counter = lhs_left + lhs_increment;
    for(counter = 1; (counter < lhs_size); counter++) {
      result[lhs_counter] = temp[lhs_counter - lhs_increment];
      lhs_counter += lhs_increment;
    }

    result[lhs_left] = temp[temp.object->bounds.right()];

    temp = result;

    rhs_value--;
  }
  
  return result;
}

EnumerationType
savantEqual(const Savantbit_vectorType &lhs, char *rhs) {
  Savantbit_vectorType rhs_bit(ObjectBase::VARIABLE, 0, to, (int) strlen(rhs), rhs);

  return savantEqual(lhs, rhs_bit);
}

EnumerationType
savantNotEqual(const Savantbit_vectorType &lhs, char *rhs) {
  Savantbit_vectorType rhs_bit(ObjectBase::VARIABLE, 0, to, (int) strlen(rhs), rhs);

  return savantNotEqual(lhs, rhs_bit);
}

template<class Type>
EnumerationType savantEqual(const Vector<Type>& lhs, const Vector<Type>& rhs) {
  for(int i =0; i < lhs.numElems; i++) {
    if(SAVANT_BOOLEAN_FALSE == savantEqual(lhs.get_element(i), rhs.get_element(i))) {
      return SAVANT_BOOLEAN_FALSE;
    }
  }
  return SAVANT_BOOLEAN_TRUE;
}

template<class Type>
EnumerationType savantNotEqual(const Vector<Type>& lhs, const Vector<Type>& rhs) {
  return savantNot(savantEqual(lhs, rhs));
}

Savantbit_vectorType savantConcatenate(const Savantbit_vectorType& lhs, const Savantbit_vectorType& rhs)  {
  bool lhs_is_null_range = lhs.object->bounds.is_null_range();
  bool rhs_is_null_range = rhs.object->bounds.is_null_range();
  
  if( lhs_is_null_range && rhs_is_null_range) {
    return rhs;
  }
  else if(lhs_is_null_range || rhs_is_null_range) {
    if(lhs_is_null_range == true) {
      return rhs;
    }
    else { 
      return lhs;
    }
  } 
  
  int new_length = lhs.get_bounds()->length() + rhs.get_bounds()->length();
  int new_left_bounds  = UniversalInteger((int) 0);
  int new_right_bounds = new_left_bounds + new_length - 1;
  Savantbit_vectorType retval(ObjectBase::VARIABLE, new_left_bounds,  to, new_right_bounds);

  int i = 0, j = new_left_bounds;

  if (lhs.get_bounds()->dirn() == to)  {
    for(i = lhs.get_bounds()->left(); i <= lhs.get_bounds()->right(); i++) {
      retval[j] = lhs[i];
      j++;
    }
  }
  else {
    for(i = lhs.get_bounds()->left(); i >= lhs.get_bounds()->right(); i--) {
      retval[j] = lhs[i];
      j++;
    }
  }
  
  int k;
  if(rhs.dirn() == to) {
    for(k = rhs.get_bounds()->left(); k <= rhs.get_bounds()->right(); k++) {
      retval[j] = rhs[k];
      j++;
    }
  }
  else {
    for(k = rhs.get_bounds()->left(); k >= rhs.get_bounds()->right(); k--) {
      retval[j] = rhs[k];
      j++;
    }
  }
  
  return retval;
}

Savantbit_vectorType savantConcatenate(const Savantbit_vectorType& lhs, const EnumerationType& rhs)  {
  bool lhs_is_null_range = lhs.object->bounds.is_null_range();

  if( lhs_is_null_range == true) {
    int left_bounds = UniversalInteger((int) 0);
    ArrayDirn_t new_direction = to;
    Savantbit_vectorType  retval (ObjectBase::VARIABLE, left_bounds, new_direction, left_bounds);
    retval[left_bounds] = rhs;
    return retval;
  }
  else {
    int new_length = lhs.get_bounds()->length() + 1;
    int new_left_bounds = UniversalInteger((int) 0);
    int new_right_bounds = new_left_bounds + new_length - 1;
    Savantbit_vectorType retval(ObjectBase::VARIABLE, new_left_bounds,  to, new_right_bounds);
    int i = 0, j = new_left_bounds;
    if(lhs.dirn() == to) {
      for(i = lhs.get_bounds()->left(); i <= lhs.get_bounds()->right(); i++) {
	retval[j] = lhs[i];
	j++;
      }
    }
    else {
      for(i = lhs.get_bounds()->left(); i >= lhs.get_bounds()->right(); i--) {
	retval[j] = lhs[i];
	j++;
      }
    }
    retval[j] = rhs;
    return retval;	 
  }
}

Savantbit_vectorType savantConcatenate(const EnumerationType& lhs, const Savantbit_vectorType& rhs)  {
  int new_length = rhs.get_bounds()->length() + 1;
  int new_left_bounds = UniversalInteger((int) 0);
  int new_right_bounds = new_left_bounds + new_length - 1;
  Savantbit_vectorType retval(ObjectBase::VARIABLE, new_left_bounds,  to, new_right_bounds);
  
  int i,  j = retval.get_bounds()->left();

  retval[j] = lhs;
  if(rhs.dirn() == to) {
    for(i = rhs.get_bounds()->left(); i <= rhs.get_bounds()->right(); i++) {
      j++;
      retval[j] = rhs[i];
    }
  }
  else {
    for(i = rhs.get_bounds()->left(); i >= rhs.get_bounds()->right(); i--) {
      j++;
      retval[j] = rhs[i];
    }
  }
  return retval;	 
}

Savantbit_vectorType savantConcatenate(const EnumerationType& lhs, const EnumerationType& rhs, Savantbit_vectorType* typePtr)  {
  int left_bounds = UniversalInteger((int) 0);
  typePtr = typePtr;
  ArrayDirn_t new_direction = to;
  int right_bounds = ((new_direction == to)? (left_bounds + 1):(left_bounds - 1));
  Savantbit_vectorType retval (ObjectBase::VARIABLE, left_bounds, new_direction, right_bounds);
  retval[left_bounds] = lhs;
  retval[right_bounds] = rhs;
  return retval;
}

ostream&
operator << (ostream& os, const Savantbit_vectorType& bv) {
  int index  = bv.left();
  int inc    = bv.dirn();
  int length = bv.length();
  int i      = 0;
  
  for(i = 0; (i < length); i++) {
    cout << (const EnumerationType &) bv[index];
    index += inc;
  }
  return os;
}
