//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef SIGNALNETINFO_HH
#define SIGNALNETINFO_HH

#include "vhdl.hh"
#include "ObjectBase.hh"
#include "Block.hh"
#include "fstream.h"
class SourceBase;

class SignalNetinfo : public ObjectBase {
public:
  int id;
  int fanout;
  FanDest_t* obj_ids;
  static int globalSignalId;
  SourceBase *source;
  Block      downTypeConversionFnList;
  bool sourcebase_delete_flag;
  Block      *additionalDriverList;
  bool additionalDriverListDeleteFlag;
  
  SignalNetinfo& Add(SignalNetinfo& sig);
  SignalNetinfo& Add(int);
  SignalNetinfo& Add(int objid, int sigid);
  SignalNetinfo& Add(SignalNetinfo* ptr);

  void print(ostream&) const;
  virtual ObjectType getKind() const {return SIGNAL_NETINFO;};
  bool _is_signal() const;
  SignalNetinfo();
  SignalNetinfo(SignalNetinfo* ptr);
  virtual ~SignalNetinfo();

  const VHDLData& readVal() const;
  void updateVal(const VHDLData&);

  ObjectBase& operator=(const SignalNetinfo &s);
  ObjectBase& operator=(const ObjectBase& s);
  ObjectBase* clone() const;
  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);

  bool driver_added_flag;

  void set_driver_added_flag(const bool);
  void set_driver_added_flag();
  bool get_driver_added_flag() const;
  bool get_sourcebase_delete_flag() const;
  void set_sourcebase_delete_flag(const bool);

  Block* getAdditionalDriverList();
  void setAdditionalDriverList(Block *);
  void addAdditionalDriver(VHDLType *driver);
  void addAdditionalDriver(Block *newDriverList);
  void dump_connectivity_info(ofstream&);
  void dump_driver_data(ofstream&);
};

#endif

