#ifndef SIGNAL_CC
#define SIGNAL_CC
//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Signal.cc,v 1.35 1999/03/09 22:52:11 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "SourceData.hh"

template <class Type>
inline
Signal<Type>::Signal() {
  type = EXPLICIT;
  fanDest = NULL;
  source = NULL;
  attributeList = NULL;
  compositeResolvedSignal = false;
  allAttributes.sigtype = drvVal.get_universal_kind();
  sourceBaseDeleteFlag = false;
}

// template <class Type>
// Signal<Type>::Signal(const bool b) {
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(b);
//   effVal = Type(b);
// }

// template <class Type>
// Signal<Type>::Signal(const char c) {
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(c);
//   effVal = Type(c);
// }

template <class Type>
inline
Signal<Type>::Signal(const int i) {
  fanDest = NULL;
  type = EXPLICIT;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  source = NULL;
  drvVal = Type(i);
  effVal = Type(i);
  compositeResolvedSignal = false;  
  allAttributes.sigtype = drvVal.get_universal_kind();
  sourceBaseDeleteFlag = false;
}

// template <class Type>
// Signal<Type>::Signal(const double d) {
//   fanDest = NULL;
//   attributeList = NULL;
//   source = NULL;
//   drvVal = Type(d);
//   effVal = Type(d);
// }

template <class Type>
inline
Signal<Type>::Signal(const VHDLData& val) {
  fanDest = NULL;
  source = NULL;
  type = EXPLICIT;
  sensitive = true;
  numAttributes = 0;
  attributeList = NULL;
  this->operator=(val);
  compositeResolvedSignal = false;
  allAttributes.sigtype = drvVal.get_universal_kind();
  sourceBaseDeleteFlag = false;
}


// template <class Type>
// Signal<Type>::Signal(const char* newname) : SignalBase(newname) {
//   fanDest = NULL;
//   source = NULL;
//   attributeList = NULL;
// }


template <class Type>
inline
Signal<Type>::Signal(const Signal<Type>& s)
 : SignalBase(s.name) {
  *source = *s.source;
  drvVal = s.drvVal;
  effVal = s.effVal;
  // Yes, these make multiple pointers to the same memory.  Since the
  // contents of this memory never change, it is allocated once at the
  // beginning of the simulation, and deleted at the end.  SO, everyone
  // looks at the same memory, and it never needs to be
  // newd/deleted/copied.
  type = s.type;
  sensitive = s.sensitive;
  numAttributes = s.numAttributes;
  fanDest = s.fanDest;
  attributeList = s.attributeList;
  compositeResolvedSignal = false;
  allAttributes = s.allAttributes;
  sourceBaseDeleteFlag = false;
}

template <class Type>
inline
Signal<Type>::~Signal() {
  if(source != NULL) {
    //     delete []source;
  }
  if ( additionalDriverList != NULL ){
    delete additionalDriverList;
  }
  if ( sourceBaseDeleteFlag == true ){
    delete source;
  }
}

template <class Type>
inline ObjectBase&
Signal<Type>:: operator=(const ObjectBase& s) {
//   Signal<Type> sig = (Signal<Type>&) s;

  
  switch(s.getKind()) {
  case SIGNAL:
  case IMPLICIT_SIGNAL:
    SignalBase::operator=((const SignalBase &) s);
    source = ((Signal<Type>*)&s)->source;
    drvVal = ((Signal<Type>*)&s)->drvVal;
    effVal = ((Signal<Type>*)&s)->effVal;
    sourceBaseDeleteFlag = ((Signal<Type>*)&s)->sourceBaseDeleteFlag;
    // Yes, these make multiple pointers to the same memory.  Since the
    // contents of this memory never change, it is allocated once at the
    // beginning of the simulation, and deleted at the end.  SO, everyone
    // looks at the same memory, and it never needs to be
    // newd/deleted/copied.
    compositeResolvedSignal =  ((SignalBase &)s).isCompositeResolvedSignal();
    break;
  case VARIABLE:
    drvVal = s.readVal();
    effVal = s.readVal();
    break;
  case SIGNAL_NETINFO:
    break;
  default:
    cerr << "Unknown ObjectBase::ObjectType" << endl;
    abort();
  }
  return ((ObjectBase &) (*this));
}

template <class Type>
inline ObjectBase&
Signal<Type>:: operator=(const VHDLData& s) {
  //This  functions is used only during initialization
  //Will not be called later
  drvVal = s;
  effVal = s;
  return ((ObjectBase &) (*this));
}


template <class Type>
inline void
Signal<Type>::updateDriver(const int sigId, const int srcId, VHDLData* data, const ArrayInfo *sInfo, const ArrayInfo *dInfo) {
  SignalBase *driver_in_block;
  int index;
  
  if((sInfo == NULL && dInfo == NULL) ||
     (*sInfo == defaultInfo && *dInfo == defaultInfo)) {
    // Update the correct driver.
    if ( source->getDriver(srcId) != NULL ){
      source->getDriver(srcId)->updateData(*(Type*)data);
    } else {
      ASSERT(additionalDriverList != NULL);
      for ( index = 0 ; index < additionalDriverList->getNumberOfElements(); index++){
	driver_in_block = ((VHDLType *)additionalDriverList->getElement(index))->findSigInBlock(sigId, srcId);
	if ( driver_in_block != NULL){
	  driver_in_block->updateDriver(sigId, srcId, data, sInfo, dInfo);
	  return; // work done quit.
	}
      }

      cerr << "Signal<Type>::updateDriver(..) could not update the driver" << endl;
    }
  } else {
    cerr << "Attempt to update driver of non-scalar signal" << endl;
    abort();
  }
}

template <class Type>
inline void
Signal<Type>::disconnectDriver(const int srcId) {
  // disconnect the correct driver.
  SourceData* driver = source->getDriver(srcId);
  ASSERT(driver != NULL);
  driver->disConnect();
}

 
template <class Type>
inline VHDLType*
Signal<Type>::readDriver(int sigsrc) {
  return source->getDriver(sigsrc)->getData();
}


template <class Type>
inline void
Signal<Type>::updateDrvVal(const VHDLData* data, const ArrayInfo *sInfo, 
			      const ArrayInfo *dInfo) {
  if(sInfo == NULL && dInfo == NULL) {
    drvVal = *(Type*)data;
  } else if (data->length() != drvVal.length()) {
   // if we're not assigning to the entire bit_vector
#ifdef VHDLDBG
    cout << name << "Data length is " << sInfo->length() << ", my length is " 
	 << drvVal.length();
    cout << ".  Assigning data |";
    data->print(cout);
    cout << "| to sig " << name << " slice " << *sInfo << endl;
#endif
    if(dInfo != NULL) {
      drvVal.assignSlice(data, sInfo, dInfo);
    } else {
      drvVal.assignSlice(data, sInfo);
    }      
  }
  else { // assignment is for equal arrays
    drvVal = *(Type*)data;
  }
}


template <class Type>
inline VHDLData*
Signal<Type>::readDrvVal() {
  return &drvVal;
}

template <class Type>
inline void
Signal<Type>::updateEffVal(const VHDLData& data, const ArrayInfo *sInfo,
				    const ArrayInfo *dInfo) {
  updateEffVal(&data, sInfo, dInfo);
}

template <class Type>
inline void
Signal<Type>::updateEffVal(const VHDLData* data, const ArrayInfo *sInfo,
				    const ArrayInfo *dInfo) {
  if(sInfo == NULL && dInfo == NULL) {
    effVal = ((Type &) *data);
  } else if (data->length() != drvVal.length()) {
   // if we're not assigning to the entire bit_vector
#ifdef VHDLDBG
    cout << name << "Data length is " << sInfo->length() << ", my length is " 
	 << effVal.length();
    cout << ".  Assigning data |";
    data->print(cout);
    cout << "| to sig " << name << " slice " << *sInfo << endl;
#endif
    if(dInfo != NULL) {
      effVal.assignSlice(data, sInfo, dInfo);
    } else {
      effVal.assignSlice(data, sInfo);
    }      
  }
  else { // assignment is for equal arrays
    effVal = *(Type*)data;
  }
}

template <class Type>
inline VHDLData*
Signal<Type>::readEffVal() {
  return &effVal;
}


template <class Type>
inline FanDest_t*
Signal<Type>::getFanList() {
  return fanDest;
}


template <class Type>
inline VHDLType*
Signal<Type>::resolve(VHDLKernelBase* processPtr) {
  return source->resolve(processPtr, type);
}

// if you can figure out how to make operator<< link for this, do it!
template <class Type>
inline void 
Signal<Type>::print(ostream& os) const {
  register int i;

  os << "Signal(" << id << "): " << type << ":";
  os << " drv(" << drvVal << "), eff(" << effVal << ")";
  if (busResFn != -1) {
    os << "busResFn(#" << busResFn << ")";
  }
//   os << endl << "Source: " << endl;
//   if(source != NULL) {
//     source->print(os);
//   } else {
//     os << "(null)";
//   }
  if (fanout > 0) {
    os << "    fanouts: ";
    for (i = 0; i < fanout; i++) {
      os << fanDest[i] << ": ";
    }
    os << "\n";
  }
  if (numAttributes > 0) {
    os << "    Attributes: ";
    for (i = 0; i < numAttributes; i++) {
      os << attributeList[i] << " ";
    }
    os << endl;
  }
  os << "Is a composite resolved Signal? " << compositeResolvedSignal << endl;
}

template <class Type>
inline SignalBase *
Signal<Type>::findSigInBlock(int sigId, int srcId){

  if ( id == sigId ){
    if ( source->getDriver(srcId) != NULL ){
      return this;
    } else {
      return NULL;
    }
  } else {
    return NULL;
  }
}

#endif
