//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _PORT_ASSOCIATION_HH_
#define _PORT_ASSOCIATION_HH_
#include "Types.hh"

class PortAssociation {

public:
  VHDLType* actualPort;
  VHDLType* formalPort;
  PortType mode;

  PortAssociation();
  PortAssociation(VHDLType*, VHDLType*, PortType);
  ~PortAssociation();
  
  inline void setActual(VHDLType* actual) {
    actualPort = actual;
  }

  inline void setFormal(VHDLType* formal) {
    formalPort = formal;
  }

  inline void setMode(PortType portMode) {
    mode = portMode;
  }

  inline VHDLType* getActual(void) {
    return actualPort;
  }

  inline VHDLType* getFormal(VHDLType*) {
    return formalPort;
  }

  inline PortType getPortType(void) {
    return mode;
  }
};
#endif
