//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef EVENTS_HH
#define EVENTS_HH

#include "BasicEvent.hh"
#include "ArrayInfo.hh"
#include "vhdl.hh"

// this the base class that VHDL sends around
struct VHDLEvent: public BasicEvent {
  VHDLEvent() {
    type = I_GUARD;
    transactionType = NORMALTRANSACTION;
  }
  VHDLEvent(const VHDLEvent *v) : BasicEvent((const BasicEvent*)v) {
    type = v->type;
    transactionType = v->transactionType;
  };
  SigType type;
  TransactionType transactionType; //0 for normal transaction, 1 for canceltransaction
};


// class for sending wait expirations to yourself
struct WaitEvent: public VHDLEvent {
  int waitId;
};


// class for sending signals around
struct SigEvent: public VHDLEvent {
  SigEvent() {};
  SigEvent(const SigEvent* s) : VHDLEvent((const VHDLEvent*)s) {
    sigId = s->sigId;
    sigsrc = s->sigsrc;
    senderSigId = s->senderSigId;
    rejTime = s->rejTime;
  };
  int sigId;
  int sigsrc;
  VTime rejTime;
  ArrayInfo sBound;
  ArrayInfo dBound;
  int senderSigId;
};


inline ostream& operator<<(ostream& os, const SigEvent& s) {
  os << (BasicEvent&)s << "\n\t signal sending " << s.senderSigId << "  signal " << s.sigId << "(" << s.sigsrc 
     << ") rejTime: " << s.rejTime << " sbound: " << s.sBound
     << " dbound: " << s.dBound;
  return os;
}

inline int
SigEventCompareRecv(const SigEvent* a, const SigEvent* b) {
  register int retVal;  
  if ( a->recvTime > b->recvTime ) {
    retVal = 1;
  }
  else if ( a->recvTime < b->recvTime ) {
    retVal = -1;
  }
  else {
    retVal = 0;
  }
  return retVal;
}

struct MarkedEvent : public VHDLEvent{
  SigEvent *event;
  bool marked;

  MarkedEvent(SigEvent *s): event(s), marked(false) {};
  ~MarkedEvent() {
    if ( event != NULL ){
      event->~SigEvent();
      delete [] (char *)event;
    }
  }
  inline void setsigevent(SigEvent *s){
    event = s;
  }
  inline void mark() {
    marked = true;
  }
  inline bool isMarked() const {
    return marked;
  }
};

inline ostream& operator<<(ostream& os, const MarkedEvent& s) {
  os << *s.event << endl
     << "marked = " << s.marked;
  return os;
}

inline int
MarkedEventCompareRecv(const MarkedEvent* a, const MarkedEvent* b) {
  return SigEventCompareRecv((const SigEvent *) a->event, 
			     (const SigEvent *) b->event);
}

#endif
