#ifndef BVBASE_CC
#define BVBASE_CC
//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: BVBase.cc,v 1.6 1999/03/09 22:51:58 dmartin Exp $
//--------------------------------------------------------------------------

#include "VectorBase.hh"

char&
VectorBase::operator[](int pos){
#ifdef DEVELOPER_ASSERTIONS
  if (!bounds.contains(pos)) {
    cerr << "VectorBase::operator[]: bit specifier (" << pos 
	 << ") out of range--my bounds are " << bounds << endl;
    abort();
  }
#endif
  register int i = bounds.storageIndex(pos);
  return ch[i];
}


bool VectorBase::operator!=(const VHDLData& d) const {
  
  VectorBase bvb = *(VectorBase*)&d;

  if (numbits != bvb.numbits) {
    return true;
  }
  else {
    for (register int i = 0; i < numbits; i++) {
      if (ch[i] != bvb.ch[i]) {
	return true;
      }
    }
    return false;
  }
}


void VectorBase::print(ostream& os) const { 
  os << "VectorBase(" << bounds << ")"; 
}


int VectorBase::getSize() const {
  return sizeof(*this);
}


int VectorBase::length() const { 
  return numbits; 
}
#endif

VectorBase& VectorBase::operator=(const VectorBase& data) {
    cerr << "ERROR: VectorBase::operator=(const VectorBase&) called" 
	 << " Continuing anyway..." << endl;
    return (VectorBase&) data;
  } 
