<?php

Function ABParseCSV( $filename, $type )
	{
	include( "features/contacts/import.defs/" . $type . ".def.php3" );
	
    	$fp = fopen( $filename, "r" );
	$cf = 0;

	if( $ABInfo[$type]["HeaderLine"] )
		{
		$ret[$cf] = fgetcsv( $fp, 4096, $ABInfo[$type]["Delimiter"] );

		$cf++;
		}
	else
		{
		for( $i = 0; $i < $ABInfo[$type]["FieldCount"]; $i++ )
			{
			$ret[0][$i] = $ABInfo[$type]["Fields"][$i];
			}
		}

	$cline = "1";

	while( $cline = fgetcsv( $fp, 4096, $ABInfo[$type]["Delimiter"] ) )
		{
		$ret[$cf] = $cline;

		$cf++;
		}

	fclose( $fp );

	return $ret;
	}

Function ABParseTranslateFields( $type, $record )
	{
	include( "features/contacts/import.defs/" . $type . ".def.php3" );

	$TWIGFields = array( "item", "description", "url", "firstname", "lastname", "email", "company", "home_phone", "work_phone", "mobile", "fax", "address1", "address2", "city", "state", "zipcode", "country", "title", "pager", "ofax", "department", "office", "spouse", "bday", "oaddress1", "oaddress2", "ocity", "ozip", "ostate", "ocountry", "email2", "email3" );

	$j = count( $TWIGFields );

	for( $i = 0; $i < $j; $i++ )
		{
		$citem = $TWIGFields[$i];
		$crecnum = $ABInfo[$type]["TFields"][$citem];

		$ret[$citem] = trim(chop($record[$crecnum]));
		}

	return $ret;
	}

Function ABAddRecord( $fields )
	{
	GLOBAL $dbconfig, $login;

	$result = dbQuery( "SELECT id, item, firstname, lastname FROM " . $dbconfig["contact_table"] . " WHERE item = '" . SQLString( $fields["item"] ) . "' AND firstname = '" . SQLString( $fields["firstname"] ) . "' AND lastname = '" . SQLString( $fields["lastname"] ) . "'" );

	if( dbNumRows( $result ) == 1 )
		{
		$recid = dbResult( $result, 0, "id" );
		$fields["username"] = $login["username"];
		$result = dbQuery( "UPDATE " . $dbconfig["contact_table"] . " SET " . MakeUpdateString( $fields ) . " WHERE id = '" . $recid . "'" );
		}
	else
		{
		$ins = MakeInsertString( $fields );
		$result = dbQuery( "INSERT INTO " . $dbconfig["contact_table"] . " (" . $ins["fields"] . ") VALUES (" . $ins["values"] . ")" );
		}
	}

Function ABImportCSV( $filename, $type, $group )
	{
	GLOBAL $login;

	include( "features/contacts/import.defs/" . $type . ".def.php3" );

	$TWIGFields = array( "username", "item", "description", "url", "firstname", "lastname", "email", "company", "home_phone", "work_phone", "mobile", "fax", "address1", "address2", "city", "state", "zipcode", "country", "title", "pager", "ofax", "department", "office", "spouse", "bday", "oaddress1", "oaddress2", "ocity", "ozip", "ostate", "ocountry", "email2", "email3" );
	
	$records = ABParseCSV( $filename, $type );

	$j = count( $records );

	for( $i = $ABInfo[$type]["HeaderLine"]; $i < $j; $i ++ )
		{
		$ret = ABParseTranslateFields( $type, $records[$i] );

		$ret["username"] = $login["username"];
		$ret["groupid"] = $group;

		if( !$ret["item"] )
			{
			if( $ret["email"] )
				{
				$ret["item"] = substr( $ret["email"], 0, strchr( $ret["email"], "@" ) - 1 );
				}
			if( $ret["firstname"] )
				{
				$ret["item"] = $ret["firstname"];
				}
			elseif( $ret["company"] )
				{
				$ret["item"] = $ret["company"];
				}
			}
		
		ABAddRecord( $ret );
		}
	}
	
?>

