<?php
 if ($list) {$list = " checked";}
 if ($missing) {$missing = " checked";}
 if ($same) {$same = " checked";}

 $languages  = array ( 	"chinesebig5", "chinesegb", "czech", "catalan", "danish", "dutch",
			"english", "estonian", "finnish", "french", "german", "hebrew", 
			"italian", "polish", "portuguese", "russian", "russianwin", 
			"spanish", "swedish", "korean", "jpeuc", "turkish" );

 $features	= array ( "Global", "Administration", "Bookmarks", "Contacts", "Groups", "Help", "Logout",
 			"Mail", "Main", "Meetings", "News", "Notes", "Prefs", "Schedule", "ToDo" ); 

 // Function borrowed from common.inc.php3.
 // We need a non-global version that *returns* the phrases.
 Function TWIGAdminLoadLanguageFile( $filepath, $filename, $lang )
	{
	TWIGDebug( "TWIGAdminLoadLanguageFile( \"" . $filepath . "\", \"" . $filename . "\", \"" . $lang . "\" );" );

	if( !$filename ) { $sep = ""; } else { $sep = "."; }

	if( file_exists( $filepath . $filename . $sep . $lang . ".strings.php3" ) ) 
   		{
		TWIGDebug( "TWIGAdminLoadLanguageFile() - including " . $filepath . $filename . $sep . $lang . ".strings.php3", 20 );
   		include( $filepath . $filename . $sep . $lang . ".strings.php3" );
   		} 
	else 
		{
		// Probably need to think of something else to do than just include English,
		// which definitely won't do much for us in this feature!
		// TWIGDebug( "TWIGAdminLoadLanguageFile() " . $lang . " not found - including " . $filepath . $filename . ".english.strings.php3", 20 );
		TWIGDebug( "TWIGAdminLoadLanguageFile() " . $lang . " not found!", 20 );
   		include( $filepath . $filename . $sep . "empty.strings.php3" );
   		}

	return $TWIGphrase;
	}

 echo "<form action=\"" . $config["baseurl"] . "\" METHOD=POST>\n";
 echo TWIGSession( "put" );
 echo TWIGContext( "put", "admin", "languages" );
 echo "<table width=100%><tr><td valign=top>Compare the following languages: </td>";
 echo "<td>";

 $controlsheaders = array (	$TWIGphrase["Language"], "&nbsp;",
 				$TWIGphrase["Feature"], "&nbsp;",
		 		$TWIGphrase["Options"], "&nbsp;" );

 $j = count( $languages );
 for( $i = 0; $i < $j; $i++ )
 	{
 	$controlscontent[$i][0] = $TWIGphrase[$languages[$i]];
 	$str="<input type=checkbox name=selectedlanguages[" . $languages[$i] . "]";
 	if( $selectedlanguages[$languages[$i]] ) { $str .= " checked"; }
 	$str .= " >&nbsp;";
 	$controlscontent[$i][1] = $str;
 	}
 $j = count( $features );
 for( $i = 0; $i < $j; $i++ )
 	{
 	$controlscontent[$i][2] = $TWIGphrase[$features[$i]];
 	$str="<input type=checkbox name=selectedfeatures[" . $features[$i] . "]";
 	if( $selectedfeatures[$features[$i]] ) { $str .= " checked"; }
 	$str .= " >&nbsp;";
 	$controlscontent[$i][3] = $str;
 	}
 $controlscontent[0][4] = $TWIGphrase["Show full phrase lists"];
 $controlscontent[0][5] = "<input type=checkbox name=list" . $list . ">";
 $controlscontent[1][4] = $TWIGphrase["List keys with null values"];
 $controlscontent[1][5] = "<input type=checkbox name=missing" . $missing . ">";
 $controlscontent[2][4] = $TWIGphrase["List keys for which the value is the same as it is in English"];
 $controlscontent[2][5] = "<input type=checkbox name=same" . $same . ">";


TWIGGenerateTable( $controlsheaders, $controlscontent );

?>

</td>
</tr>
<tr>
  <td></td>
  <td colspan=2 align=center><input type=submit value=Update></td>
</tr>
</table></form>

<?php

if( $selectedlanguages && $selectedfeatures)
 	{
 	$languages = "";
 	while( list( $key, $val ) = each( $selectedlanguages ) )
 		{
 		$languages[] = $key;
 		}

 	$features = "";
 	while( list( $key, $val ) = each( $selectedfeatures ) )
 		{
		// Do some quick translation of features to lower case,
		// and abbreviate known abbreviated features
 		$features[$key]["name"] = $key;
		if( $key == "Administration" ) { $key = "Admin"; }
		if( $key == "Global" )
			{
			$features[$key]["stringpath"] = "lib/strings/";
			}
		else
			{
			$features[$key]["stringpath"] = "features/" . strtolower( $key ) . "/strings/";
			}
 		}

 	if( $same )
 		{
 		while( list( $key, $val ) = each( $features ) )
 			{
 			$TPstrings["english"][$key] = TWIGAdminLoadLanguageFile( $features[$key]["stringpath"], "", "english" );
 			}
		}

	reset( $languages );
 	while( list( $lkey, $lval ) = each( $languages ) )
 		{
		reset( $features );
 		while( list( $fkey, $fval ) = each( $features ) )
 			{
 			$TPstrings[$lval][$fkey] = TWIGAdminLoadLanguageFile( $features[$fkey]["stringpath"], "", "$lval" );
			if( !is_array( $TPstrings[$lval][$fkey] ) )
				{
				// We have a problem.
				// The feature has no file for the language.
				}
 			}
 		}

	reset( $features );
 	while( list( $fkey, $fval ) = each( $features ) )
 		{
 		$listcontents = "";
		$languagecolumn = 1;
		reset( $languages );
 		while( list( $lkey, $lval ) = each( $languages ) )
 			{
			$listtableindex = 0;
			reset( $TPstrings[$lval][$fkey] );
 			while( list( $key, $val ) = each( $TPstrings[$lval][$fkey] ) )
 				{
 				$listcontents[$listtableindex][0] = "$" . "TWIGphrase[" . $key . "]";
 				$listcontents[$listtableindex][$languagecolumn] = $TPstrings[$lval][$fkey][$key];
 				$listtableindex++;
 				if( !$TPstrings[$lval][$fkey][$key] )
					{
					$missingarray[$lval][$fkey][] = $key;
					}
 				elseif( $lval != "english" )
 					{
 					if( $TPstrings[$lval][$fkey][$key] == $TPstrings["english"][$fkey][$key] )
						{
						$samearray[$lval][$fkey][] = $key;
						}
					}
				}
			$languagecolumn++;
			}
 		if( $list )
 			{
 			echo "<b>";
 			if( $TWIGphrase[$features[$fkey]["name"]] )
 				echo $TWIGphrase[$features[$fkey]["name"]];
 			echo "</b>";

 			$listheaders[] = "Key";
			reset( $languages );
 			while( list( $lkey, $lval ) = each( $languages ) )
 				{
 				$listheaders[] = $TWIGphrase[$lval];
 				}
 			TWIGGenerateTable( $listheaders, $listcontents );
 			echo "<b>" . $TWIGphrase["Total"] . ": </b>" . count( $listcontents ) . "<br><br>";
 			}
 		}

 	if( $same || $missing )
 		{
 		echo $config["hr"];
 		echo "<table width=100%>";
		reset( $languages );
 		while( list( $lkey, $lval ) = each( $languages ) )
 			{
			reset( $features );
 			while( list( $fkey, $fval ) = each( $features ) )
 				{
 				echo "<tr>";
 				echo "<td valign=top><b>";
 				if( $TWIGphrase[$lval] )
 					echo $TWIGphrase[$lval];
 				echo "</b></td>";
 				if( $missing )
 					{
 					echo "<td valign=top width=40%>";
 					$missingheaders = array ( $TWIGphrase["Keys with null values"] );
 					$missingcontents = array();
 					if( $missingarray[$lval][$fkey] )
 						{
 						$n = 0;
 						while( list( $key, $val ) = each( $missingarray[$lval][$fkey] ) )
 							{
 							$missingcontents[$n][0] = "$" . "TWIGphrase[\"" . $val . "\"]";
 							$n++;
 							}
 						}
 					TWIGGenerateTable( $missingheaders, $missingcontents );
 					echo "<b>" . $TWIGphrase["Total"] . ": </b>";
 					if( $missingarray[$lval][$fkey] )
 						{
						echo count( $missingarray[$lval][$fkey] );
						}
 					else
						{
						echo "0";
						}
 					}  
 				echo "</td>";
 				if( $same )
 					{
 					if( $lval != "english" )
 						{
 						$sameheaders = array ($TWIGphrase["Same as English"]);
 						}
 					echo "<td valign=top width=40%>";
 					$samecontents = array();
 					if( $samearray[$lval][$fkey] )
 						{
 						$n=0;
 						while( list( $key, $val ) = each( $samearray[$lval][$fkey] ) )
 							{
 							$samecontents[$n][0] = "$" . "TWIGphrase[\"" . $val . "\"]";
 							$n++;
 							}
 						}
 					TWIGGenerateTable( $sameheaders, $samecontents );
 					if( $lval != "english" )
 						{
 						echo "<b>" . $TWIGphrase["Total"] . ": </b>";
 						if( $samearray[$lval][$fkey] )
 							{
							echo count( $samearray[$lval][$fkey] );
							}
 						else
							{
							echo "0";
							}
 						}
 						echo "</td>";
 					}  
 					echo "</tr><tr><td colspan=3>&nbsp;</td></tr>";
				}
 			}
 			echo "</table>";
 		}
 	}
?>
