<?php
/**
 * Copyright 1999 - 2001 by Gero Kohnert
 *
 * @modulegroup timetrack
 * @module timetrack_select
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';

include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","select");

 /**
  * display a timetrack selection form
  */
 class timetrack_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang , $tutos;

     $this->assign('action', "timetrack_overview.php");
     $this->assign('ext', $this->ext);

     // if( $this->ext == 0 ) {
       $this->assign('title', $lang['SearchForTT']);
       
       $this->assign('name',
		     array('id'    => 'name',
			   'label' => $lang['AdrName'],
			   'value' => $this->lookfor));
     
       $this->assign('search',
		     array('label' => $lang['Search'],
			   'title' => $lang['SearchForTT']));
     
       $this->assign('extlink',
		     array('label' => $lang['extended'],
			   'link'  => "timetrack_select.php?ext=1",
			   'title' => $lang['extended']));
     // }
     
     $this->template('timetrack_select');
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['TimetrackSearch'];
     if ( ! $this->user->feature_ok(usetimetrack,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     # Defaults for search
     $this->fd = new DateTime(0);
     $this->td = new DateTime(0);
     if ( isset($_SESSION['ttsearchfrom']) ) {
       $this->fd->setDateTime($_SESSION['ttsearchfrom']);
     }
     if ( isset($_SESSION['ttsearchto']) ) {
       $this->td->setDateTime($_SESSION['ttsearchto']);
     }
     if ( isset($_SESSION['ttsearchstate']) ) {
       $this->state = $_SESSION['ttsearchstate'];
     } else {
       $this->state = -2;
     }
     if ( isset($_GET['ext']) ) {
       $this->ext = $_GET['ext'];
     } else {
       $this->ext = 0;
     }
   }
 }

 $l = new timetrack_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: timetrack_select.php,v 1.20.2.2 2004/06/29 16:07:01 tapoueh Exp $
    $Author: tapoueh $
-->
