<?php
/*
 * Copyright 1999 - 2003 by Gero Kohnert
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','overview');

 /**
  * show a overview of user-resources and appointmens
  */
 class res_cal extends layout {

   /**  
    * Find the first line able to receive current task
    */
   function find_row($xarr, $d1, $d2) {
     $row_found  = False;
     
     for( $target_row = 0;  ! $row_found; $target_row++ ) {
       $row_ok = True;
       for( $d = $d1; $row_ok && $d <= $d2; $d++) {
	 $row_ok = $row_ok && ($xarr[$d][$target_row] <= 0);
       }
       $row_found = $row_ok;
     }
     return $target_row - 1;
   }

   /**
    * display the info
    */
   Function info() {
     global $tutos, $lang;

     $this->assign('start', $this->start->getLinkDateTime());
     $this->assign('end',   $this->end->getLinkDateTime());

     $month = Date("m/Y",$this->start->ts);
     $m = Date("m",$this->start->ts);
     $y = Date("Y",$this->start->ts);
     $cols = Date("j",$this->end->ts);

     $last = "res_cal.php?id=". $this->base->id ;
     $t = MkTime(0,0,0,($m -1),Date("d",$this->start->ts),$y);
     $last = addUrlParameter($last,"start=". Date("Ymd",$t));

     $next = "res_cal.php?id=". $this->base->id;
     $t = MkTime(0,0,0,($m +1),Date("d",$this->start->ts),$y);
     $next = addUrlParameter($next,"start=". Date("Ymd",$t));

     $this->assign('cols', $cols);
     $this->assign('last', $last);
     $this->assign('next', $next);

     $this->assign('AdrName', $lang['AdrName']);
     $this->assign('ResCal',  $lang['ResCal']);
     $this->assign('hours',   $lang['hours']);

     $restitle = sprintf($lang['ResCalDetail'],
			 $this->base->getFullName(), $month);

     $this->assign('restitle',
		   array('label' => $restitle,
			 'link'  => $this->base->getUrl(),
			 'title' => myentities($restitle)));

     $dinfos = array();
     for ($i = 1; $i <= $cols; $i++) {
       $t = MkTime(0,0,0,$m,$i,$y);
       $dinfo = GetDaysInfo($t);
       $dinfos[] = array('color' => $dinfo[color],
			 'label' => sprintf("%02d",$i));
     }
     $this->assign('dinfos', $dinfos);
     
     $this->callist = array();
     appointment::readCal($this,$this->start,$this->end);
     $n2 = count($this->callist);

     $this->assign('TaskVolumeFull', $lang['TaskVolumeFull']);
     $this->assign('TaskVolumeDone', $lang['TaskVolumeDone']);
     $this->assign('TaskVolumeTodo', $lang['TaskVolumeTodo']);

     // $this->debug(count($this->uids));
     $project_tasks = array();
     $entries = array();

     $line = 0;
     foreach ($this->uids as $i => $f) {
       $line++;
       $maxr = 0;
       $q1 = "SELECT t.* from ". $this->dbconn->prefix ."tasks t,". $this->dbconn->prefix ."taskworker w";
       $q1 = $q1 ." WHERE ( t.id = w.t_id) and (w.w_id =  ". $f->id ." or w.w_id = ". $this->base->id .")";
       $q1 = $q1 ."   AND ( (t.s_start < " . $this->dbconn->Date($this->end) ." AND t.s_start   >= " . $this->dbconn->Date($this->start) .") ";
       $q1 = $q1 ."    OR   (t.s_end < " . $this->dbconn->Date($this->end) ." AND t.s_end   >= " . $this->dbconn->Date($this->start) .") ";
       $q1 = $q1 ."    OR   (t.s_start < " . $this->dbconn->Date($this->start) ." AND t.s_end   >= " . $this->dbconn->Date($this->end) .") ";
       $q1 = $q1 ." )";

       /*
       if( $this->state > -1 ) 
	 $q1 .= " AND t.status = ".$this->state;
       */

       $q1 = $q1 ." ORDER by t.s_start";

       $result1 = $this->dbconn->Exec($q1);
       $n1 = $result1->numrows();

       // echo "<!-- tasks $n1 | apps $n2 | cols $cols -->\n";
       // $this->debug($this->state);

       // Reset Fields  / Field index is day in month
       for ($r = 0; $r < ($n1 + $n2) ; $r++) {
         for ($d = 1; $d <= $cols; $d++) {
           $xarr[$d][$r] = -1;
         }
       }
       $obj = array();

       // Fill Fields
       // Task Entries
       for($a = 0;  $a < $n1; $a++) {
         $task = new task($this->dbconn);
         $task->read_result($result1,$a);

         if ( ! $task->see_ok() )
           continue;

	 /**
	  * Exclude ended tasks and task with null planned charge
	  * That concerns logical and organisation tasks
	  */
	 if( $task->isfinished()
	     || ($task->volume == 0 && $task->volume_done == 0) )
	   continue;

	 /**
	  * Also exclude tasks if their status is not $this->state
	  */
	 // $this->debug($this->state." ".$task->state);
	 if( $this->state != -1 && $this->state != $task->state )
	   continue;

	 /**
	  * Do not consider task from project not alive
	  * Beware of cost if this is activated.
	  */
	 $project = $task->getProject($project_tasks);
	 if( $project != -1
	     && $project->getType() == "product" && ! $project->isalive() )
	   continue;

	 // Mark all fields covered by this task
         $m1 = Date("m/Y",$task->s_start->ts);
         $d1 = Date("j",$task->s_start->ts);
         $m2 = Date("m/Y",$task->s_end->ts);
         $d2 = Date("j",$task->s_end->ts);
         if ( $m1 != $month ) {
           $d1 = 1;
         }
         if ( $m2 != $month ) {
           $d2 = $cols;
         }

	 $r = $this->find_row($xarr, $d1, $d2);

	 for( $d = $d1; $d <= $d2; $d++ ) {
	   $xarr[$d][$r] = $task->id;
	   $obj[$task->id] = &$task;
	   $maxr = Max($maxr, $r);
	 }
         unset($task);
       }
       $result1->free();

       // echo "<!-- $n1 $n2 $maxr -->\n";

       // Calendar Entries
       foreach($this->callist as $i => $app) {
         $found = 0;
         foreach($app->participant as $i2 => $f2) {
           if ( $i2 == $f->id ) {
             $found++;
             break;
           }
           if ( $i2 == $this->base->id ) {
             $found++;
             break;
           }
         }
         if ( $found == 0 ) {
           // $a++;
           continue;
         }

         // Mark all fields covered by this task
         $m1 = Date("m/Y",$app->start->ts);
         $d1 = Date("j",$app->start->ts);
         $m2 = Date("m/Y",$app->end->ts);
         $d2 = Date("j",$app->end->ts);
         if ( $m1 != $month ) {
           $d1 = 1;
         }
         if ( $m2 != $month ) {
           $d2 = $cols;
         }

	 $r = $this->find_row($xarr, $d1, $d2);

	 for( $d = $d1; $d <= $d2; $d++ ) {
	   $obj[$app->id] = &$task;
	   $xarr[$d][$r] = $app->id;
	   $maxr = Max($maxr, $r);
	 }

         // $a++;
         unset($task);
       }

       if ( ($n1 + $n2) > 0 ) {
	 error_log('New entry '. $f->getFullName());
	 if( isset($entry) ) {
	   $entries[] = $entry;
	 }

	 $entry = array();
	 $entry['name'] =
	    array('rows'  => $maxr + 1,
		  'label' => $f->getShortname(),
		  'link'  => $f->getUrl(),
		  'title' => $f->getFullName());

	 $entry['res']  = array();
       }
       // echo "<!-- $n1 $n2 $maxr -->\n";

       // Each person may have tasks to be presented on multiple lines
       $l = 0;

       // We have to count the number of cells to fill at the end of
       // each line
       $fcols = 0;

       for ($r = 0; $r < ($n1 + $n2); $r++) {
         if ( $r > $maxr ) {
           continue;
         }

	 if( $r > 0 ) {
	   // New line
	   $l++;
	   $fcols = 0;
	   $entry['res'][$l] = array();
	 }

         $day = 1;
         $old = $xarr[$day][$r];
         $colspan = 0;

         while ( $day <= $cols ) {

           if ( $xarr[$day][$r] != $old ) {
             if ( $old < 0 ) {
	       $entry['res'][$l][] = array('id' => -1,
					   'colspan' => $colspan);
             }
	     else {
               if ( $obj[$old]->getType() == "task" ) {
		 $volume      = $obj[$old]->volume;
		 $volume_done = $obj[$old]->volume_done;
		 $volume_todo = $obj[$old]->volume_todo;

		 error_log('res_cal : '.$obj[$old]->id);
		 error_log('res_cal : '.$project_tasks[$obj[$old]->id]);

		 $title = $obj[$old]->getFullName();

		 if( array_key_exists($obj[$old]->id, $project_tasks) )
		   $title =
		     $project_tasks[$obj[$old]->id]->getFullName()
		     ." :: ".$title;

		 $entry['res'][$l][] =
		    array('id'      => $old,
			  'colspan' => $colspan,
			  'class'   => "task".$obj[$old]->state,
			  'label'   => myentities($obj[$old]->getFullName()),
			  'link'    => $obj[$old]->getUrl(),
			  'title'   => myentities($title),
			  'volume'  => $volume,
			  'volume_done' => $volume_done,
			  'volume_todo' => $volume_todo,
			  'volume_link' => 'timetrack_overview?link_id='.$old);

               }
	       else {
                 if ( $obj[$old]->descr == "" ) {
                   $obj[$old]->descr = $lang['AppLoc'][$obj[$old]->outside];
                 }

                 if ( $obj[$old]->mod_allow == 3 )
		   $class = "privapp";
		 else
		   $class = "app";

		 $entry['res'][$l][] =
		    array('id'      => $old,
			  'colspan' => $colspan,
			  'class'   => "app",
			  'label'   => myentities($obj[$old]->descr),
			  'link'    => $obj[$old]->getUrl(),
			  'title'   => myentities($obj[$old]->descr));
               }
             }
             $old = $xarr[$day][$r];

	     $fcols += $colspan;
             $colspan = 1;
           }
	   else {
             $colspan++;
           }

           $day++;
         }

         if ( $old < 0 ) {
         }
	 else {
           if ( $old < 0 ) {
	     $entry['res'][] = array('id' => -1,
				     'colspan' => $colspan);
           }
	   else {
             if ( $obj[$old]->getType() == "task" ) {

		 $entry['res'][$l][] =
		    array('id'      => $old,
			  'colspan' => $colspan,
			  'class'   => "task".$obj[$old]->state,
			  'label'   => $obj[$old]->getFullName(),
			  'link'    => $obj[$old]->getUrl(),
			  'title'   => $obj[$old]->getFullName(),
			  'volume'  => $obj[$old]->volume);

             }
	     else {
	       if ( $obj[$old]->mod_allow == 3 )
		 $class = "privapp";
	       else
		 $class = "app";

	       $entry['res'][$l][] =
		  array('id'      => $old,
			'colspan' => $colspan,
			'class'   => "app",
			'label'   => myentities($obj[$old]->descr),
			'link'    => $obj[$old]->getUrl(),
			'title'   => $obj[$old]->descr);

             }
	     $fcols += $colspan;
           }
         }

	 // Add to current entry the number of cells not painted
	 if( $fcols < $cols )
	   $entry['res'][$l][] = array('id' => -1,
				       'colspan' => $cols - $fcols);

       }
     }
     // Don't forget the last element
     if( ! in_array($entry, $entries) )
       $entries[] = $entry;

     // $this->debug($entries);

     $this->assign('entries', $entries);
     $this->template('res_cal');
   }

   /**
    * Provide a task state legend
    */
   function legend() {
     global $lang;

     $this->assign("legend", $lang['legend']);
     $this->assign("TaskState", $lang['TaskState']);

     foreach( $lang['TaskStates'] as $i => $f ) {
       $states[$i] = $f;
     }
     $this->assign('states', $states);

     /**
      * Make up a filter array
      */
     $filter['id']      = $this->base->id;
     $filter['state']   = $this->state;

     // $this->debug($filter);
     $this->assign('filter', $filter);

     $this->template('task_overview_legend');
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     $x = array('url'   => "res_cal.php?format=paper&amp;id=".$this->obj->id,
		'text'  => $lang['Printable'],
		'image' => 'format',
		'info'  => $lang['PrintableInfo'],
		'category' => array("obj", "product_show"));
     $this->addMenu($x);
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ResCal'];
     $this->link = "res_cal.php";
     $this->uids = array();
     if ( isset($_GET['id']) ) {
       $this->link = addUrlParameter($this->link,"id=".$_GET['id']);
       if ($_GET['id'] == 0 ) {
         $this->base = new team($this->dbconn);
         $this->base->read(0);
       } else {
         $this->base = GetObject($this->dbconn,$_GET['id']);
       }
       if ( $this->base->gettype() == "team" ) {
         $this->base->read_member();
         @reset($this->base->member);
         while ( list ($i,$f) = @each ($this->base->member) ) {
           $this->uids[$i] = $f;
         }
       } else if ( $this->base->gettype() == "address" ) {
         $this->uids[$this->base->id] = $this->base;
       } else if ( $this->base->gettype() == "user" ) {
         $this->uids[$this->base->id] = $this->base;
       }
     } else {
       $this->base = $this->user;
       $this->uids[$this->base->id] = $this->base;
     }
     if ( isset($_GET['start']) ) {
       $this->start = new DateTime($_GET['start']);
     } else {
       $t = MkTime(0,0,0,Date("m"),1,Date("Y"));
       $this->start = new DateTime();
       $this->start->setDateTimeTS($t);
     }
     if ( isset($_GET['end']) ) {
       $this->end = new DateTime($_GET['end']);
     } else {
       $t = $this->start->getTimeStamp();
       $x = Date("m",$t);
       while ( $x == Date("m",$t) ) {
         $t += 86400;
       }
       $t = MkTime(0,0,0,Date("m",$t),Date("d",$t),Date("Y",$t));
       $t -= 1;
       $this->end = new DateTime();
       $this->end->setDateTimeTS($t);
     }
     $this->link = addUrlParameter($this->link,"start=".Date("Ymd",$this->start->ts));
     $this->link = addUrlParameter($this->link,"end=".Date("Ymd",$this->end->ts));

     
     /**
      * State
      *
      * As in legend we add a filter and use generic mklink.tpl, the
      * state is to be found in $_REQUEST['xo']
      */
     if( isset($_REQUEST['xo']) ) {
       $_REQUEST['state'] = $_REQUEST['xo'];
     }

     if ( isset($_REQUEST['state']) ) {
       if (false == is_numeric($_REQUEST['state'])) {
         $msg .= sprintf($lang['Err0012'],"state",$_REQUEST['state']);
	 $this->stop = true;
       }
       $this->state = $_REQUEST['state'];
     }
     else
       $this->state = -1;
     
     $this->assign('state', $this->state);

   }
 }

 $l = new res_cal($current_user);
 $l->display();
 $dbconn->Close();

?>
<!--
    CVS Info:  $Id: res_cal.php,v 1.30.2.13 2005/03/16 15:46:01 tapoueh Exp $
    $Author: tapoueh $
-->
