<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_gantt
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","show");

 /**
  * display 
  */
 class task_gantt extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang;

     $this->assign('gantt_url',
		   "gantt_png.php?".$this->get_task_filter('url'));
     $this->template('task_gantt');
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     $this->menuprint("task", true);
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->state = -1;
     $this->start = new DateTime(0);
     $this->end   = new DateTime(0);

     $this->name = $lang['TaskGantt'];
     if ( isset($_GET['id']) ) {
       $this->parent = GetObject($this->dbconn,$_GET['id']);
     } else {
       $msg .= $lang['Err0048'];
       $this->stop = true;
       $this->parent = $this->user;
     }

     if ( isset($_REQUEST['state']) ) {
       if (false == is_numeric($_REQUEST['state'])) {
         $msg .= sprintf($lang['Err0012'],"state",$_REQUEST['state']);
	 $this->stop = true;
       }
       $this->state = $_REQUEST['state'];
     }
     else
       $this->state = -1;
     
     // Timerange Start
     if ( isset($_REQUEST['start']) ) {
       $this->start->setDateTime($_REQUEST['start']);
     }
     else {
       if( isset($_REQUEST['start_d']) ) {
         $this->start->setDateTimeF('start');
         $_SESSION['tasksearchfrom'] = $this->start->getYYYYMMDD();
       }
     }
     // Timerange End
     if ( isset($_REQUEST['end']) ) {
       $this->end->setDateTime($_REQUEST['end']);
     }
     else {
       if( isset($_REQUEST['end_d']) ) {
         $this->end->setDateTimeF('end');
         $_SESSION['tasksearchto'] = $this->end->getYYYYMMDD();
       }
     }

     $this->addMenu(array('url'   => 
			  "task_overview.php?".$this->get_task_filter('url'), 
			  'text'  => $lang['TaskOverview'], 
			  'image' => 'task_overview',
			  'info'  => $lang['TaskOverview'], 
			  'category' => array('task', 'task_gantt')));
   }
 }

 $l = new task_gantt($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
 CVS Info: $Id: task_gantt.php,v 1.14.2.4 2005/03/25 16:53:58 tapoueh Exp $
 $Author: tapoueh $
 -->
