<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup note
 * @module note_ins
 * @package note
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("note","ins");
 loadmodule("note");

 /* Check Input */
 $gotourl = "note/note_new.php";

 $msg = "";
 $u = new note($dbconn);

 if ( isset($_POST['id']) ) {
   $u->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $u->id,true);
 } else {
   $u->creator = $current_user;
 }
 if ( empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['NoteName']) ."<br>";
 } else {
   $u->setName(StripSlashes($_POST['name']));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($u->name),true);
 }
 if ( empty($_POST['note']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['NoteDescription']) ."<br>";
 } else {
   $u->setText(StripSlashes($_POST['note']));
   $gotourl= addUrlParameter($gotourl,"note=". UrlEncode($u->note),true);
 }
 if ( empty($_POST['link_id']) ) {
   $msg .= "No Link ID given !<br>";
 } else {
   $u->setReference($_POST['link_id']);
   $gotourl= addUrlParameter($gotourl,"link_id=". $u->link_id,true);
   $u->read_reference();
 }

 $r = new DateTime(0);
 $r->setDateTimeF("remember");
 $u->setRemember($r);

 $gotourl= addUrlParameter($gotourl,"remember=". $u->remember->getYYYYMMDD(),true);
 if ( !$r->checkDMY(true) ) {
   $msg .= sprintf($lang['Err0038'],$lang['NoteRemember']) ."<br>";
 }

 # other modules
 $msg .= module_parseforms($current_user,$u,$gotourl);

 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $u->save();
   $dbconn->Commit("WORK");
   $gotourl = $u->ref->getURL();
 }
 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: note_ins.php,v 1.14 2003/11/27 15:35:34 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>