<?php
/**
 * Copyright 2004 by Gero Kohnert
 *
 * this script will import a given file to the document management system
 * other than normal TUTOS scripts it is not called via web but locally 
 *
 * @modulegroup file
 * @module file_import
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 $tutos['nocheck'] = 1;

 include_once 'webelements.p3';
 include_once 'permission.p3';

 $tutos[authtype] = "cmdline";

 $dbnr = 0;
 $uname = "";
 $pw = "";

 check_user();
 loadmodule('file');

 # get the id of the object where we should add the given file
 $id = auth_cmdline::getParameter("i");
 if ($id == "") {
   die("no id given\nYou should use a -i parameter in the cmdline\n");
 }
 if (!is_numeric($id)) {
   die("id '". $id ."' is not a number\n");
 }
 $ref = getObject($dbconn,$id);
 if (!is_object($ref)) {
   die("id '". $id ."' is not a known object\n");
 }
 if (! $ref->use_ok()) {
   die(sprintf($lang['Err0001'],$lang[$ref->getType()],$ref->getFullName())."\n");
 }

 # check the given file
 $fname = auth_cmdline::getParameter("f");
 if ($fname == "") {
#   die("no filename given\nYou should use a -f parameter in the cmdline\n");
   # we use stdin
   $fname = "-";
 }

 if ($fname == "-") {
   $fname = tempnam ($tutos[sessionpath], "import");
   $fname1 = "php://stdin";
   $fd1 = fopen($fname1,"rb");
   $fd2 = fopen($fname,"w");
   while (!feof($fd1)) {
#	 echo "A:".fread($fd1,4096);
     fwrite($fd2,fread($fd1,4096));
   }
   fclose($fd1);
   fclose($fd2);
   $orgname = $fname1;
 } else {
   $orgname = $fname;
 }
 if (!file_exists($fname)) {
   die("file ". $fname ." is not there\n");
 }
 if (!is_file($fname)) {
   die("file ". $fname ." is not a file\n");
 }
 if (!is_readable($fname)) {
   die("file ". $fname ." is not readable\n");
 }
 if (0 == filesize($fname)) {
   die("file ". $fname ." is empty\n");
 }

 $ct = auth_cmdline::getParameter("ct");

 if ($ct) {
   #$ct = $ct;
 } else if ( eregi("\.doc$",$fname) ) {
     $ct = "application/msword";
 } else if ( eregi("\.xls$",$fname) ) {
   $ct = "application/vnd-ms-excel";
 } else if ( eregi("\.ppt$",$fname) ) {
   $ct = "application/vnd.ms-powerpoint";
 } else if ( eregi("\.pdf$",$fname) ) {
   $ct = "application/pdf";
 } else if ( eregi("\.gif$",$fname) ) {
   $ct = "image/gif";
 } else if ( eregi("\.jp[e]g$",$fname) ) {
   $ct = "image/jpeg";
 } else {
   $ct = "text/plain";
 }

 #
 # there are two alternate ways to get a file in
 #
 if (false) {
   # via direct copy  (might have problems with permisssions)
   $obj = new tutos_file($dbconn);
   $obj->setAuthor($current_user);
   $obj->setVersion("1");
   $obj->setFileName(basename($fname));
   $obj->setName(basename($orgname));

   $obj->logtxt = "automated initial import from ".$orgname ;
   $obj->vsys = FILE_RCS;
   $obj->nocheck = true;
   $obj->filetype = $ct;
   $obj->filesize = filesize($fname);
   $obj->tmploc = $fname;
   $obj->addReference($ref);


   $owner = fileowner($obj->base);
   $group = filegroup($obj->base);
   echo $obj->save();
   @chgrp(dirname($obj->base ."/". $obj->fileloc),$group);
   @chown(dirname($obj->base ."/". $obj->fileloc),$owner);
   @chgrp($obj->base ."/". $obj->fileloc,$group);
   @chown($obj->base ."/". $obj->fileloc,$owner);
   
 } else {
   # via http
   $uname = auth_cmdline::getParameter("u");
   $pw    = auth_cmdline::getParameter("p");
   $dbnr  = auth_cmdline::getParameter("d");
   # this requires the file to be readable by the server process
   if ($orgname == $fname) {
	 $orgname = $fname;
     # it is not a temp file so copy it 
     $fname = tempnam ($tutos[sessionpath], "import");
     @copy ($orgname , $fname);
   }
   @chmod($fname,0666);
   $url = getBaseUrl(true) ."php/file/file_ins.php";
   $url = addUrlParameter($url,"uname=".$uname,true);
   $url = addUrlParameter($url,"pw=".$pw,true);
   $url = addUrlParameter($url,"dbnr=".$dbnr,true);
   $url = addUrlParameter($url,"link_id[]=".$ref->id,true);
   $n = auth_cmdline::getParameter("n");
   if ($n) {
     $url = addUrlParameter($url,"name=".urlencode($n),true);
   } else {
     $url = addUrlParameter($url,"name=".urlencode($orgname),true);
   }
   $url = addUrlParameter($url,"ct=".urlencode($ct),true);
   $url = addUrlParameter($url,"file=".urlencode(basename($fname)),true);

   echo $url."\n";

   $fd = fopen($url,"r");
   while ($fd && !feof($fd)) {
	 echo fgets($fd,4096);
   }
   fclose($fd);
 }
 if ($orgname != $fname) {
   echo "\ndeleted ". $fname ." size:". filesize($fname) ."\n";
   @unlink($fname);
 }
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: file_import.php,v 1.2.2.1 2004/04/14 17:39:19 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>
