<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 *  CVS Info:  $Id: timetrack_ins.php,v 1.30.2.5 2003/07/03 14:35:23 gokohnert Exp $
 *  $Author: gokohnert $
 *
 * @modulegroup timetrack
 * @module timetrack_ins
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","ins");

 /* Check Input */
 $msg = "";
 $mode = 0;
 $tt = new timetrack($dbconn);


 if ( isset($_POST['gotourl']) ) {
   $gotourl = $_POST['gotourl'];
 } else {
   $gotourl = "timetrack_new.php";
 }
 if ( isset($_POST['mode']) ) {
   $mode = $_POST['mode'];
   $gotourl= addUrlParameter($gotourl,"mode=". $mode);
 }
 if ( isset($_POST['id']) ) {
   $tt->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $tt->id);
 } else {
   $tt->creator = $current_user;
 }
 
 # reference
 if ( isset($_POST['lfn']) ) {
   if ( empty($_POST['lfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TimetrackRef']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['lfn']),"lfn","ll","api");   // api: address, product, installation
     $tt->setReference($x->id);
     $tt->ref = getObject($dbconn,$tt->link_id);
     $gotourl= addUrlParameter($gotourl,"lid=". $x->id);
   }
 } else if ( isset($_POST['lid']) ) {
   $tt->setReference($_POST['lid']);
   $tt->ref = getObject($dbconn,$tt->link_id);
   $gotourl= addUrlParameter($gotourl,"lid=". $_POST['lid']);
 }
 # worker
 if ( isset($_POST['wfn']) ) {
   if ( empty($_POST['wfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TimetrackWorker']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['wfn']),"wfn","wl","a");
     $tt->setWorker($x->id);
     $gotourl= addUrlParameter($gotourl,"wid=". $x->id);
   }
 } else if ( isset($_POST['wid']) ) {
   $tt->setWorker($_POST['wid']);
   $gotourl= addUrlParameter($gotourl,"wid=". $_POST['wid']);
 }
 # description
 if ( empty($_POST['desc'])  ) {
   $msg .= sprintf($lang['Err0009'],$lang['Description']) ."<br>";
 } else {
   if ( isset($_POST['desc']) ) {
     $tt->setDescription(StripSlashes($_POST['desc']));
     $gotourl= addUrlParameter($gotourl,"desc=". UrlEncode($tt->desc));
   }
 }
 # state
 if ( isset($_POST['state']) ) {
   $tt->setState($_POST['state']);
   $gotourl= addUrlParameter($gotourl,"state=". UrlEncode($tt->state));
 }

 # Read the Work Day
 $wd = new DateTime(0);
 if ( isset($_POST['wd_d']) ) {
   $wd->setDateTimeF("wd",1);
   if ( 1 != $wd->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['Date']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"wd=". $wd->getYYYYMMDD());
   }
   $tt->setWorkday($wd);
 }

 if ( isset($_POST['start_d']) ) {
   $start = new DateTime();
   $start->setDateTimeF("start",0);
   if ( 1 != $start->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['AppStart']) ."<br>";
   } else {
    $gotourl= addUrlParameter($gotourl,"start=". $start->getYYYYMMDDHHMM());
   }
   $tt->setStart($start);
 }
 if ( isset($_POST['end_d']) ) {
   $end   = new DateTime();
   $end->setDateTimeF("end",0);
   if ( 1 != $end->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['AppEnd']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"end=". $end->getYYYYMMDDHHMM());
   }
   $tt->setEnd($end);
   if ( $tt->t_end->notime == 0 ) {
     $tt->setVolume( ($tt->t_end->getTimeStamp() - $tt->t_start->getTimeStamp()) / 3600.0);
   }
 }
 # volume
 if ( $tt->t_start->notime == 1 ) {
   $volume = 0.0;
   list($volume) = sscanf($_POST['volume'],"%f");
   if ( (empty($volume) || ! is_double($volume) ) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeDone']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"volume=". UrlEncode($volume));
     $tt->setVolume($volume);
   }
 }

 # volume todo
 if ( isset($_POST['volume_todo']) && $_POST['volume_todo'] != "" ) {
   $volume_todo = 0.0;
   list($volume_todo) = sscanf($_POST['volume_todo'],"%f");
   if ( ! (empty($volume_todo) || is_double($volume_todo)) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeTodo']) ."<br>";
     $gotourl= addUrlParameter($gotourl,"volume_todo=".UrlEncode($volume_todo));
   } else {
     $gotourl= addUrlParameter($gotourl,"volume_todo=".UrlEncode($volume_todo));
     $tt->setVolumeTodo($volume_todo);
   }
 }

 if ( isset($_POST['cph']) ) {
   $cph = 0.0;
   list($cph) = sscanf($_POST['cph'],"%f");
   if ( empty($cph) || ! is_double($cph) ) {
#   $msg .= sprintf($lang['Err0009'],$lang['TTcph']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"cph=". UrlEncode($cph));
     $tt->setCph($cph);
   }
 }
 # currency
 if ( isset($_POST['currency']) ) {
   $tt->setCurrency($_POST['currency']);
   $gotourl= addUrlParameter($gotourl,"currency=". UrlEncode($tt->currency));
 }

 # other modules
 $msg .= module_parseforms($current_user,$tt,$gotourl);

 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $tt->save();
   $dbconn->Commit("WORK");
   $gotourl = $tt->ref->getURL();
 }

 $gotourl = addSessionKey($gotourl);
 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
?>
